/*
 * 1.00 xx/08/2012 John Wiseman G8BPQ
*/

#define _CRT_SECURE_NO_DEPRECATE

/*
POSIX getopt for Windows

AT&T Public License

Code given out at the 1985 UNIFORUM conference in Dallas.  
*/

#ifdef __GNUC__
#include <getopt.h>
#endif
#ifndef __GNUC__

#ifndef _WINGETOPT_H_
#define _WINGETOPT_H_

#ifdef __cplusplus
extern "C" {
#endif

extern int opterr;
extern int optind;
extern int optopt;
extern char *optarg;
extern int getopt(int argc, char **argv, char *opts);

#ifdef __cplusplus
}
#endif

#endif  /* _GETOPT_H_ */
#endif  /* __GNUC__ */


#ifdef WIN32
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <windows.h>
#else
#define HANDLE int
#define BOOL int
#include <termios.h>
#include <linux/i2c-dev.h>
#endif

#define VERSION "0.0.0.4"

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
//#include <unistd.h>
//#include <sys/ioctl.h>
//#include <termios.h>
#include <fcntl.h>
#include <signal.h>
#include <ctype.h>
//#include <syslog.h>
#include <string.h>

//#include <linux/i2c-dev.h>


#define G8BPQ_CRC	1

#define I2C_SLAVE	0x0703

#define	SIZE		4096

#define FEND		0300	/* Frame End			(0xC0)	*/
#define FESC		0333	/* Frame Escape			(0xDB)	*/
#define TFEND		0334	/* Transposed Frame End		(0xDC)	*/
#define TFESC		0335	/* Transposed Frame Escape	(0xDD)	*/

#define TRUE 1
#define FALSE 0



/*
 * Keep these off the stack.
 */
 
 
static int address;
static char progname[80];

static unsigned char ibuf[SIZE];	/* buffer for input operations	*/

static char *usage_string	= "usage for i2c: pitnc_getparams i2bus i2cdevice\n"
							  "usage for Serial /dev/ttyAMA0: pitnc_getparams 0 0 \n"
							  "usage for Serial other device: pitnc_getparams device 0\n"
							  "Serial speed defaults to 19200. For others specify device:speed, eg COM1:115200\n";


int fd;
FILE * file;

int i2c = 0;

char * strlop(char * buf, char delim)
{
	// Terminate buf at delim, and return rest of string

	char * ptr = strchr(buf, delim);

	if (ptr == NULL) return NULL;

	*(ptr)++=0;

	return ptr;
}



#ifdef WIN32

#define ioctl ioctlsocket



int i2c_smbus_read_byte(int fd)
{
	return 0;
}

int i2c_smbus_write_byte(int fd, int chat)
{
	return 0;
}

#endif

int main(int argc, char *argv[])
{
	unsigned char *icp;
	int retval, size, len;
	char i2cname [20];
	char serName[256] = "/dev/ttyAMA0";
	int fends = 0;
	int count = 0;
	int bus;    
	int ptr = 0;
	int sum = 0;
	
	while ((size = getopt(argc, argv, ":v")) != -1) 
	{
		switch (size) 
		{
	
		case 'v':
			printf("%s\n", VERSION);
			return 1;
		case ':':
		case '?':
			fprintf(stderr, usage_string);
			return 1;
		}
	}

	// Allow 2 params 
	
	if ((argc - optind) != 2 )
	{
		fprintf(stderr, usage_string);

		return 1;
	}
	
	bus = strtol(argv[optind], 0, 0);
	address = strtol(argv[optind + 1], 0, 0);

	if (address > 0)
		i2c = TRUE;	

	if (i2c)
	{
		sprintf(i2cname, "/dev/i2c-%s", argv[optind]);
		fd = open(i2cname, O_RDWR);
                                              
		if (fd < 0)
		{
			fprintf(stderr, "%s: Cannot find i2c bus %s\n", progname, i2cname);
			exit(1);
		}
	
#ifndef WIN32
 		retval = ioctl(fd,  I2C_SLAVE, address);	
		if(retval == -1)
		{
			fprintf(stderr, "%s: Cannot open i2c device %x\n", progname, address);
			exit (1);
		}
#endif
	}
	else
	{
		char * serbaud = 0;
	
		if (strlen(argv[optind]) > 3)
		{
			strcpy(serName, argv[optind]);
			serbaud = strlop(serName, ':');
		}
		else
			if (bus > 0)
				sprintf(serName,"/dev/ttyO%d", bus);
		
		if (serbaud)
			fd = OpenCOMPort(serName, atoi(serbaud));
		else            	
			fd = OpenCOMPort(serName, 19200);
	}
	
#ifdef WIN32                                                                     

		Sleep(100);
#else
		usleep(100000);
#endif

	// Send request for params
	
	if (i2c)
	{
		i2c_smbus_write_byte(fd, FEND);
		i2c_smbus_write_byte(fd, FEND);
        i2c_smbus_write_byte(fd, 15); 
		i2c_smbus_write_byte(fd, 1);
		i2c_smbus_write_byte(fd, FEND);
		
	}
	else
	{
		unsigned char Block[5];
		
		while (ReadCOMBlock(fd, Block, 1))
		{
//			printf("%x \n", Block[0]);
		}
		
		Block[0] = FEND;
		Block[1] = FEND;
		Block[2] = 15;
		Block[3] = 1;
		Block[4] = FEND;
		
		WriteCOMBlock(fd, Block, 4);
	}
	
	while (TRUE)
	{
getanother:
		if (i2c)
			retval = i2c_smbus_read_byte(fd);
		else
		{
			unsigned char Block[4];
			int n = ReadCOMBlock(fd, Block, 1);
			
			if (n == 0)
				goto nochar;
				
			retval = Block[0];
		}	
	
		if (retval == -1)	 		// Read failed		
  		{
			perror("poll failed");	 	
			exit(0);
		}
	

		if (retval == 0x0e)
			continue;
		
		ibuf[ptr++] = retval;
		sum ^= retval;
		
		
		if (ptr >= SIZE)
			ptr = SIZE;
			
			
		if (retval == FEND)
		{
			fends++;
			
			if (fends == 1)
				sum = ptr = 0;
				
			if (fends == 2)
			{
				int i;
				
				sum ^= FEND;

				if (ptr < 5 || ibuf[0] == 0)		// KISS Data
				{
					fends = 0;
					sum = ptr = 0;
					printf("KISS Data Frame\r\n");
					goto getanother;
				}
					
				printf("\n");
				printf("   TNC Software Version         %3d\n", ibuf[1]);
				printf("01 TXDelay - Zero means use ADC %3d\n", ibuf[2]);
				printf("02 Persistance                  %3d\n", ibuf[3]);
				printf("03 Slottime (in 10 mS)          %3d\n", ibuf[4]);
				printf("04 TXTail                       %3d\n", ibuf[5]);
				printf("05 Full Duplex - Not used       %3d\n", ibuf[6]);
				printf("06 Our Channel (Hex)             %02x\n", ibuf[7]);
				printf("07 I2C Address (0 = async) Hex   %02x\n", ibuf[8]);
				
				if (ptr < 14)
				{
					printf("   ADC Value                    %3d\n", ibuf[9]);
				}
				else
				{
					printf("08 Mode Speed                  %4d\n", ibuf[9] * 100);
					printf("09 RX Level (Config)            %3d\n", ibuf[10]);
					printf("10 TX Level                     %3d\n", ibuf[11]);
					printf("11 RX Level (Actual)            %3d\n", ibuf[12]);
					printf("13 Centre Freq                 %4d\n", ibuf[13] * 10);
				}

				for (i = 0; i < ptr; i++)
					printf("%x ", ibuf[i]);	

				printf("sum %x \n", sum);
				if (sum != 0)
					printf("** Checksum Error - Sum = %x Should be Zero\n\n", sum);
				
				exit(0);

			}
                }		
nochar:
#ifdef WIN32
		Sleep(10);
#else
		usleep(10000);
#endif
		count++;
		
		if (count > 250)
		{
			printf("retrying...\n");
			count = 0;
	
			if (i2c)
			{
				i2c_smbus_write_byte(fd, FEND);
				i2c_smbus_write_byte(fd, FEND);
       	 		i2c_smbus_write_byte(fd, 15); 
				i2c_smbus_write_byte(fd, 1);
				i2c_smbus_write_byte(fd, FEND);
		
			}
			else
			{

				unsigned char Block[5];
				
				Block[0] = FEND;
				Block[1] = FEND;
				Block[2] = 15;
				Block[3] = 1;
				Block[4] = FEND;
		
				WriteCOMBlock(fd, Block, 4);;
			}
		}
	}

	return 1;
}

#ifndef WIN32

static struct speed_struct
{
	int	user_speed;
	speed_t termios_speed;
} speed_table[] = {
	{300,         B300},
	{600,         B600},
	{1200,        B1200},
	{2400,        B2400},
	{4800,        B4800},
	{9600,        B9600},
	{19200,       B19200},
	{38400,       B38400},
	{57600,       B57600},
	{115200,      B115200},
	{-1,          B0}
};

#endif

#ifdef WIN32

int OpenCOMPort(char * pPort, int speed)
{
	char szPort[80];
	BOOL fRetVal ;
	COMMTIMEOUTS  CommTimeOuts ;
	char buf[100];
	HANDLE fd;
	DCB dcb;

	// convert to \\.\COM or ports above 10 wont work

	sprintf(szPort, "\\\\.\\%s", pPort);

	printf("\nUsing Serial port %s\n", szPort);


	// open COMM device

	fd = CreateFile( szPort, GENERIC_READ | GENERIC_WRITE,
                  0,                    // exclusive access
                  NULL,                 // no security attrs
                  OPEN_EXISTING,
                  FILE_ATTRIBUTE_NORMAL,
                  NULL );

	if (fd == (HANDLE) -1)
	{
		int err = GetLastError();
		printf(" %s could not be opened Error %d\n ", pPort, err);
		return (FALSE);
	}


	// setup device buffers

	SetupComm(fd, 4096, 4096 ) ;

	// purge any information in the buffer

	PurgeComm(fd, PURGE_TXABORT | PURGE_RXABORT |
                                      PURGE_TXCLEAR | PURGE_RXCLEAR ) ;

	// set up for overlapped I/O

	CommTimeOuts.ReadIntervalTimeout = 0xFFFFFFFF ;
	CommTimeOuts.ReadTotalTimeoutMultiplier = 0 ;
	CommTimeOuts.ReadTotalTimeoutConstant = 0 ;
	CommTimeOuts.WriteTotalTimeoutMultiplier = 0 ;
//     CommTimeOuts.WriteTotalTimeoutConstant = 0 ;
	CommTimeOuts.WriteTotalTimeoutConstant = 500 ;
	SetCommTimeouts(fd, &CommTimeOuts ) ;

   dcb.DCBlength = sizeof( DCB ) ;

   GetCommState(fd, &dcb ) ;

   dcb.BaudRate = speed;
   dcb.ByteSize = 8;
   dcb.Parity = 0;
   dcb.StopBits = ONESTOPBIT;

	// setup hardware flow control

	dcb.fOutxDsrFlow = 0;
	dcb.fDtrControl = DTR_CONTROL_DISABLE ;

	dcb.fOutxCtsFlow = 0;
	dcb.fRtsControl = RTS_CONTROL_DISABLE ;

	// setup software flow control

   dcb.fInX = dcb.fOutX = 0;
   dcb.XonChar = 0;
   dcb.XoffChar = 0;
   dcb.XonLim = 100 ;
   dcb.XoffLim = 100 ;

   // other various settings

   dcb.fBinary = TRUE ;
   dcb.fParity = FALSE;

   fRetVal = SetCommState(fd, &dcb);

	if (fRetVal)
	{
		EscapeCommFunction(fd, SETDTR);
		EscapeCommFunction(fd, SETRTS);
	}
	else
	{
		printf(buf,"%s Setup Failed %d ", pPort, GetLastError());
		CloseHandle(fd);
		return 0;
	}

	return fd;
}

int ReadCOMBlock(HANDLE fd, char * Block, int MaxLength )
{
	BOOL       fReadStat ;
	COMSTAT    ComStat ;
	DWORD      dwErrorFlags;
	DWORD      dwLength;

	// only try to read number of bytes in queue

	ClearCommError(fd, &dwErrorFlags, &ComStat);

	dwLength = min((DWORD) MaxLength, ComStat.cbInQue);

	if (dwLength > 0)
	{
		fReadStat = ReadFile(fd, Block, dwLength, &dwLength, NULL) ;

		if (!fReadStat)
		{
		    dwLength = 0 ;
			ClearCommError(fd, &dwErrorFlags, &ComStat ) ;
		}
	}

   return dwLength;
}


BOOL WriteCOMBlock(HANDLE fd, char * Block, int BytesToWrite)
{
	BOOL        fWriteStat;
	DWORD       BytesWritten;
	DWORD       ErrorFlags;
	COMSTAT     ComStat;

	fWriteStat = WriteFile(fd, Block, BytesToWrite,
	                       &BytesWritten, NULL );

	if ((!fWriteStat) || (BytesToWrite != BytesWritten))
		ClearCommError(fd, &ErrorFlags, &ComStat);

	return TRUE;
}


#else
int OpenCOMPort(char * Port, int speed)
{
	char buf[100];

	//	Linux Version.

	int fd;
	int hwflag = 0;
	u_long param=1;
	struct termios term;
	struct speed_struct *s;
	
	printf("\nUsing Serial port %s\n", Port);


	if ((fd = open(Port, O_RDWR | O_NDELAY)) == -1)
	{
		printf("Device %s\n", Port);
		perror("Com Open Failed");
		exit (0);
	}

	// Validate Speed Param

	for (s = speed_table; s->user_speed != -1; s++)      
		if (s->user_speed == speed)
			break;

   if (s->user_speed == -1)
   {
	   fprintf(stderr, "tty_speed: invalid speed %d\n", speed);
	   exit (0);
   }
   
   if (tcgetattr(fd, &term) == -1)
   {
	   perror("tty_speed: tcgetattr");
	   exit (0);
   }

   	cfmakeraw(&term);
	cfsetispeed(&term, s->termios_speed);
	cfsetospeed(&term, s->termios_speed);

	if (tcsetattr(fd, TCSANOW, &term) == -1)
	{
		perror("tty_speed: tcsetattr");
		return FALSE;
	}

	ioctl(fd, FIONBIO, &param);

	return fd;
}

int ReadCOMBlock(int fd, char * Block, int MaxLength)
{
	int Length;
	
	Length = read(fd, Block, MaxLength);

	if (Length < 0)
	{
		if	(errno != 11)					// Would Block
		{
			perror("read");
			printf("%d\n", errno);
		}
		return 0;
	}

	return Length;
}
BOOL WriteCOMBlock(HANDLE fd, char * Block, int BytesToWrite)
{
	return write(fd, Block, BytesToWrite);
	return TRUE;
}

#endif
