
#include <winioctl.h>

#define MAXBLOCK 4096

typedef struct VCOMStruct
{
   HANDLE  ComDev ;
   BYTE    Port;
   BOOL    Connected;
   UCHAR	RXMSG[512];				// Msg being built
   UCHAR	RXBUFFER[MAXBLOCK];		// Raw chars from Comms
   int		RXBCOUNT;				// chars in RXBUFFER
   UCHAR * RXBPTR;					// get pointer for RXBUFFER (put ptr is RXBCOUNT) 
   UCHAR * RXMPTR;					// put pointer for RXMSG
   BOOL	   MSGREADY;				// Complete msg in RXMSG
   BOOL	   ESCFLAG;					// FESC received
   BOOL		NewVCOM;				// Set if using User Mode VCOM Driver
   BOOL		NewVCOMConnected;		// Set if COM side is connected
   int		ReopenTimer;			// Open retry delay timer 	
   
} VCOMINFO, *PVCOMINFO ;

PVCOMINFO VCOMInfo[32]={0};

#define IOCTL_SERIAL_IS_COM_OPEN CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x800,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERIAL_GETDATA     CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x801,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERIAL_SETDATA     CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x802,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_SERIAL_SET_CTS     CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x803,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERIAL_SET_DSR     CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x804,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERIAL_SET_DCD     CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x805,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_SERIAL_CLR_CTS     CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x806,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERIAL_CLR_DSR     CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x807,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERIAL_CLR_DCD     CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x808,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_BPQ_ADD_DEVICE     CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x809,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_BPQ_DELETE_DEVICE  CTL_CODE(FILE_DEVICE_SERIAL_PORT,0x80a,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define W98_SERIAL_GETDATA     0x801
#define W98_SERIAL_SETDATA     0x802
