
#include "ARDOPC.h"


//	These Templates are used to save lots of calculations when
//	generating samples. They are pre-calculated (by Calctemplates.c)
//  so they can be stored in ROM on embedded platforms

CONST short int50BaudTwoToneLeaderTemplate[240] = {	// holds just 1 symbol (20 ms) of the 50 Baud leader

	0, -263, 0, 793, 1496, 1322, 0, -1849, -2988, -2375,
	0, 2901, 4474, 3424, 0, -3944, -5945, -4462, 0, 4978,
	7402, 5489, 0, -5996, -8836, -6499, 0, 6999, 10249, 7493,
	0, -7981, -11631, -8465, 0, 8944, 12984, 9416, 0, -9880,
	-14298, -10339, 0, 10791, 15576, 11235, 0, -11670, -16809, -12099,
	0, 12519, 17998, 12931, 0, -13333, -19136, -13726, 0, 14111,
	20223, 14486, 0, -14849, -21252, -15203, 0, 15548, 22226, 15881,
	0, -16202, -23136, -16514, 0, 16814, 23985, 17103, 0, -17378,
	-24767, -17643, 0, 17897, 25482, 18137, 0, -18364, -26126, -18580,
	0, 18783, 26700, 18973, 0, -19148, -27199, -19312, 0, 19463,
	27625, 19601, 0, -19723, -27974, -19833, 0, 19930, 28247, 20014,
	0, -20081, -28442, -20137, 0, 20179, 28560, 20208, 0, -20220,
	-28599, -20220, 0, 20207, 28560, 20180, 0, -20137, -28442, -20082,
	0, 20013, 28247, 19931, 0, -19833, -27974, -19724, 0, 19600,
	27625, 19464, 0, -19312, -27199, -19149, 0, 18972, 26700, 18783,
	0, -18579, -26126, -18365, 0, 18137, 25482, 17897, 0, -17643,
	-24767, -17379, 0, 17102, 23985, 16815, 0, -16513, -23136, -16203,
	0, 15881, 22226, 15548, 0, -15203, -21252, -14849, 0, 14485,
	20223, 14112, 0, -13726, -19136, -13333, 0, 12931, 17998, 12520,
	0, -12098, -16809, -11671, 0, 11235, 15576, 10791, 0, -10338,
	-14299, -9880, 0, 9415, 12984, 8944, 0, -8465, -11631, -7982,
	0, 7493, 10249, 6999, 0, -6499, -8836, -5996, 0, 5489,
	7402, 4978, 0, -4462, -5945, -3944, 0, 3424, 4474, 2902,
	0, -2375, -2988, -1849, 0, 1322, 1496, 794, 0, -263};

CONST short intFSK50bdCarTemplate[12][240] = {
{
	0, 15576, 26127, 28247, 21253, 7402, -8837, -22226, -28443, -25482,
	-14299, 1496, 16810, 26700, 27975, 20223, 5946, -10249, -23137, -28560,
	-24768, -12984, 2989, 17998, 27200, 27625, 19137, 4473, -11632, -23985,
	-28599, -23985, -11632, 4474, 19137, 27625, 27200, 17998, 2989, -12984,
	-24768, -28560, -23137, -10249, 5946, 20223, 27975, 26700, 16810, 1496,
	-14300, -25482, -28443, -22226, -8837, 7402, 21254, 28247, 26127, 15576,
	0, -15576, -26127, -28247, -21253, -7402, 8837, 22226, 28443, 25482,
	14299, -1496, -16810, -26700, -27974, -20223, -5946, 10249, 23137, 28560,
	24768, 12984, -2989, -17998, -27200, -27625, -19137, -4473, 11632, 23986,
	28599, 23985, 11632, -4474, -19137, -27625, -27200, -17998, -2989, 12984,
	24768, 28560, 23137, 10249, -5946, -20223, -27975, -26700, -16810, -1496,
	14300, 25482, 28443, 22226, 8837, -7402, -21254, -28247, -26127, -15576,
	0, 15576, 26127, 28247, 21253, 7402, -8838, -22226, -28443, -25482,
	-14299, 1497, 16810, 26700, 27974, 20223, 5946, -10249, -23138, -28560,
	-24768, -12983, 2989, 17998, 27200, 27625, 19136, 4473, -11632, -23986,
	-28599, -23985, -11632, 4474, 19137, 27625, 27200, 17998, 2989, -12984,
	-24768, -28560, -23137, -10249, 5946, 20223, 27975, 26700, 16810, 1496,
	-14300, -25482, -28443, -22226, -8837, 7402, 21254, 28247, 26127, 15576,
	0, -15576, -26127, -28247, -21253, -7401, 8838, 22226, 28443, 25482,
	14299, -1497, -16810, -26700, -27974, -20223, -5945, 10249, 23138, 28560,
	24768, 12983, -2989, -17998, -27200, -27625, -19136, -4473, 11632, 23986,
	28599, 23985, 11632, -4474, -19137, -27625, -27200, -17998, -2989, 12984,
	24768, 28560, 23137, 10248, -5946, -20223, -27975, -26700, -16810, -1496,
	14300, 25482, 28443, 22226, 8837, -7402, -21254, -28247, -26127, -15576},

	{	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810,
	0, 16810, 27200, 27200, 16810, 0, -16810, -27200, -27200, -16810},

	{	0, 17998, 27975, 25482, 11632, -7402, -23137, -28560, -21253, -4474,
	14299, 26700, 27200, 15576, -2989, -20223, -28443, -23985, -8837, 10249,
	24768, 28247, 19137, 1496, -16810, -27625, -26127, -12984, 5946, 22226,
	28599, 22226, 5946, -12984, -26127, -27625, -16810, 1496, 19137, 28247,
	24768, 10249, -8837, -23985, -28443, -20223, -2989, 15576, 27200, 26700,
	14300, -4474, -21253, -28560, -23137, -7402, 11632, 25482, 27975, 17998,
	0, -17998, -27975, -25482, -11632, 7402, 23137, 28560, 21253, 4474,
	-14299, -26700, -27200, -15576, 2989, 20223, 28443, 23985, 8837, -10249,
	-24768, -28247, -19137, -1496, 16810, 27625, 26127, 12984, -5946, -22226,
	-28599, -22226, -5946, 12984, 26127, 27625, 16810, -1496, -19137, -28247,
	-24768, -10249, 8837, 23985, 28443, 20223, 2989, -15576, -27200, -26700,
	-14300, 4474, 21253, 28560, 23137, 7402, -11632, -25482, -27975, -17998,
	0, 17998, 27975, 25482, 11632, -7402, -23137, -28560, -21253, -4474,
	14299, 26700, 27200, 15576, -2989, -20223, -28443, -23985, -8837, 10249,
	24768, 28247, 19137, 1496, -16810, -27625, -26127, -12984, 5946, 22226,
	28599, 22226, 5946, -12984, -26127, -27625, -16810, 1496, 19137, 28247,
	24768, 10249, -8837, -23985, -28443, -20223, -2989, 15576, 27200, 26700,
	14300, -4473, -21253, -28560, -23137, -7402, 11632, 25482, 27975, 17998,
	0, -17998, -27975, -25482, -11632, 7402, 23137, 28560, 21253, 4474,
	-14299, -26700, -27200, -15576, 2989, 20223, 28443, 23986, 8837, -10249,
	-24768, -28247, -19137, -1496, 16810, 27625, 26127, 12984, -5946, -22226,
	-28599, -22226, -5946, 12984, 26127, 27625, 16810, -1496, -19137, -28247,
	-24768, -10249, 8837, 23985, 28443, 20223, 2989, -15576, -27200, -26700,
	-14300, 4473, 21253, 28560, 23137, 7402, -11632, -25482, -27975, -17998},

	{	0, 19137, 28443, 23137, 5946, -14299, -27200, -26127, -11632, 8837,
	24768, 27975, 16810, -2989, -21253, -28600, -21253, -2989, 16810, 27975,
	24768, 8837, -11632, -26127, -27200, -14299, 5946, 23137, 28443, 19137,
	0, -19137, -28443, -23137, -5946, 14300, 27200, 26127, 11632, -8837,
	-24768, -27975, -16810, 2989, 21253, 28599, 21253, 2989, -16810, -27975,
	-24768, -8837, 11632, 26127, 27200, 14299, -5946, -23137, -28443, -19137,
	0, 19137, 28443, 23137, 5946, -14300, -27200, -26127, -11632, 8837,
	24768, 27974, 16810, -2989, -21254, -28599, -21253, -2989, 16810, 27975,
	24768, 8837, -11632, -26127, -27200, -14299, 5946, 23137, 28443, 19137,
	0, -19137, -28443, -23137, -5946, 14300, 27200, 26127, 11632, -8838,
	-24768, -27974, -16810, 2989, 21254, 28599, 21253, 2989, -16810, -27975,
	-24768, -8837, 11632, 26127, 27200, 14299, -5946, -23137, -28443, -19137,
	0, 19137, 28443, 23137, 5946, -14300, -27200, -26127, -11632, 8838,
	24768, 27974, 16810, -2989, -21254, -28599, -21253, -2989, 16810, 27975,
	24768, 8837, -11632, -26127, -27200, -14299, 5946, 23138, 28443, 19136,
	0, -19137, -28443, -23137, -5946, 14300, 27200, 26127, 11632, -8838,
	-24768, -27974, -16810, 2989, 21254, 28599, 21253, 2989, -16810, -27975,
	-24768, -8837, 11632, 26127, 27200, 14299, -5946, -23138, -28443, -19136,
	0, 19137, 28443, 23137, 5945, -14300, -27200, -26127, -11632, 8838,
	24768, 27974, 16810, -2989, -21254, -28599, -21253, -2989, 16810, 27975,
	24768, 8837, -11632, -26127, -27200, -14299, 5946, 23138, 28443, 19136,
	0, -19137, -28443, -23137, -5945, 14300, 27200, 26127, 11632, -8838,
	-24768, -27974, -16810, 2989, 21254, 28599, 21253, 2989, -16810, -27975,
	-24768, -8837, 11633, 26127, 27200, 14299, -5946, -23138, -28443, -19136},

	{	0, 18574, 28247, 24385, 8837, -10944, -25482, -27809, -16810, 2243,
	20223, 28511, 23137, 6676, -12984, -26422, -27200, -14943, 4474, 21747,
	28599, 21747, 4474, -14943, -27200, -26422, -12984, 6676, 23137, 28511,
	20223, 2243, -16810, -27809, -25482, -10944, 8837, 24385, 28247, 18574,
	0, -18574, -28247, -24385, -8837, 10944, 25482, 27809, 16810, -2243,
	-20223, -28511, -23137, -6676, 12984, 26422, 27200, 14943, -4473, -21747,
	-28599, -21747, -4474, 14943, 27200, 26422, 12984, -6676, -23137, -28511,
	-20223, -2244, 16810, 27809, 25482, 10944, -8837, -24385, -28247, -18574,
	0, 18574, 28247, 24385, 8837, -10944, -25482, -27809, -16810, 2243,
	20223, 28511, 23137, 6676, -12984, -26422, -27200, -14943, 4473, 21747,
	28599, 21747, 4474, -14943, -27200, -26422, -12984, 6676, 23137, 28511,
	20223, 2244, -16810, -27809, -25482, -10944, 8837, 24385, 28247, 18574,
	0, -18574, -28247, -24385, -8838, 10944, 25482, 27809, 16810, -2243,
	-20223, -28511, -23137, -6676, 12984, 26422, 27200, 14943, -4473, -21747,
	-28599, -21747, -4474, 14943, 27200, 26423, 12984, -6676, -23137, -28511,
	-20223, -2244, 16810, 27809, 25482, 10944, -8837, -24385, -28247, -18574,
	0, 18574, 28247, 24385, 8838, -10944, -25482, -27809, -16810, 2243,
	20223, 28511, 23137, 6676, -12983, -26422, -27200, -14943, 4473, 21747,
	28599, 21747, 4474, -14943, -27200, -26423, -12984, 6676, 23137, 28511,
	20223, 2244, -16810, -27809, -25482, -10944, 8837, 24385, 28247, 18574,
	0, -18574, -28247, -24385, -8838, 10944, 25482, 27809, 16810, -2243,
	-20223, -28511, -23138, -6676, 12983, 26422, 27200, 14943, -4473, -21747,
	-28599, -21747, -4474, 14943, 27200, 26423, 12984, -6676, -23137, -28511,
	-20223, -2244, 16810, 27809, 25482, 10944, -8837, -24385, -28247, -18574},

	{	0, 19686, 28560, 21747, 2989, -17410, -28247, -23570, -5946, 14943,
	27625, 25134, 8837, -12312, -26700, -26422, -11632, 9546, 25482, 27422,
	14299, -6676, -23985, -28121, -16810, 3733, 22226, 28511, 19137, -748,
	-20223, -28590, -21253, -2243, 17998, 28355, 23137, 5211, -15576, -27809,
	-24768, -8122, 12984, 26959, 26127, 10944, -10249, -25813, -27200, -13646,
	7402, 24385, 27975, 16199, -4474, -22689, -28443, -18574, 1496, 20745,
	28599, 20745, 1496, -18574, -28443, -22689, -4473, 16199, 27975, 24385,
	7402, -13646, -27200, -25813, -10249, 10944, 26127, 26959, 12984, -8122,
	-24768, -27809, -15576, 5212, 23137, 28355, 17998, -2243, -21253, -28590,
	-20223, -748, 19137, 28511, 22226, 3732, -16810, -28121, -23985, -6676,
	14300, 27422, 25482, 9546, -11632, -26422, -26700, -12312, 8837, 25134,
	27625, 14943, -5946, -23570, -28247, -17410, 2989, 21747, 28560, 19686,
	0, -19687, -28560, -21747, -2989, 17410, 28247, 23569, 5946, -14943,
	-27625, -25134, -8837, 12312, 26700, 26422, 11632, -9546, -25482, -27422,
	-14299, 6676, 23986, 28121, 16810, -3733, -22226, -28511, -19137, 748,
	20223, 28590, 21253, 2243, -17998, -28355, -23137, -5211, 15576, 27809,
	24768, 8122, -12984, -26959, -26127, -10944, 10249, 25813, 27200, 13646,
	-7402, -24385, -27974, -16199, 4474, 22689, 28443, 18574, -1496, -20745,
	-28599, -20745, -1496, 18574, 28443, 22689, 4473, -16199, -27975, -24385,
	-7402, 13646, 27200, 25813, 10249, -10944, -26127, -26959, -12983, 8122,
	24768, 27809, 15576, -5212, -23137, -28355, -17998, 2244, 21254, 28590,
	20223, 748, -19137, -28511, -22226, -3732, 16810, 28121, 23985, 6676,
	-14300, -27422, -25482, -9546, 11632, 26423, 26700, 12312, -8838, -25134,
	-27625, -14943, 5946, 23570, 28247, 17410, -2989, -21747, -28560, -19686},

	{	0, 20745, 28560, 18574, -2989, -22689, -28247, -16199, 5946, 24385,
	27625, 13646, -8837, -25813, -26700, -10944, 11632, 26959, 25482, 8122,
	-14299, -27809, -23986, -5212, 16810, 28355, 22226, 2244, -19137, -28590,
	-20223, 748, 21253, 28511, 17998, -3732, -23137, -28121, -15576, 6676,
	24768, 27422, 12984, -9546, -26127, -26423, -10249, 12312, 27200, 25134,
	7402, -14943, -27974, -23570, -4474, 17410, 28443, 21747, 1497, -19686,
	-28599, -19687, 1496, 21747, 28443, 17410, -4473, -23569, -27975, -14943,
	7401, 25134, 27200, 12312, -10249, -26422, -26127, -9547, 12983, 27422,
	24768, 6676, -15576, -28121, -23138, -3733, 17998, 28511, 21254, 749,
	-20222, -28590, -19137, 2243, 22226, 28355, 16810, -5211, -23985, -27809,
	-14300, 8122, 25482, 26959, 11633, -10944, -26700, -25814, -8838, 13646,
	27625, 24385, 5946, -16198, -28247, -22690, -2989, 18573, 28560, 20746,
	0, -20745, -28560, -18574, 2989, 22689, 28247, 16199, -5945, -24385,
	-27625, -13647, 8837, 25813, 26700, 10945, -11632, -26959, -25483, -8123,
	14299, 27809, 23986, 5212, -16810, -28355, -22226, -2244, 19136, 28590,
	20223, -748, -21253, -28511, -17999, 3732, 23137, 28121, 15577, -6675,
	-24768, -27422, -12984, 9546, 26127, 26423, 10249, -12312, -27200, -25134,
	-7402, 14942, 27974, 23570, 4474, -17410, -28443, -21748, -1497, 19686,
	28599, 19687, -1496, -21747, -28443, -17411, 4473, 23569, 27975, 14944,
	-7401, -25133, -27200, -12313, 10248, 26422, 26127, 9547, -12983, -27422,
	-24768, -6677, 15575, 28120, 23138, 3733, -17997, -28511, -21254, -749,
	20222, 28590, 19137, -2243, -22225, -28355, -16811, 5211, 23985, 27809,
	14300, -8121, -25482, -26959, -11633, 10943, 26700, 25814, 8838, -13645,
	-27625, -24386, -5947, 16198, 28247, 22690, 2990, -18573, -28560, -20746},

	{	0, 21747, 28247, 14943, -8837, -26422, -25482, -6676, 16810, 28511,
	20223, -2243, -23137, -27809, -12984, 10944, 27200, 24385, 4474, -18574,
	-28599, -18574, 4473, 24385, 27200, 10944, -12984, -27809, -23137, -2243,
	20223, 28511, 16810, -6676, -25482, -26422, -8837, 14943, 28247, 21747,
	0, -21747, -28247, -14943, 8837, 26422, 25482, 6676, -16810, -28511,
	-20223, 2243, 23137, 27809, 12984, -10944, -27200, -24385, -4474, 18574,
	28599, 18574, -4473, -24385, -27200, -10944, 12984, 27809, 23137, 2244,
	-20223, -28511, -16810, 6676, 25482, 26423, 8838, -14943, -28247, -21747,
	0, 21747, 28247, 14943, -8837, -26422, -25482, -6676, 16810, 28511,
	20223, -2243, -23137, -27809, -12984, 10944, 27200, 24385, 4474, -18574,
	-28599, -18574, 4473, 24385, 27200, 10944, -12983, -27809, -23138, -2244,
	20223, 28511, 16810, -6676, -25482, -26423, -8838, 14943, 28247, 21747,
	0, -21747, -28247, -14943, 8837, 26422, 25482, 6676, -16810, -28511,
	-20223, 2243, 23137, 27809, 12984, -10944, -27200, -24385, -4474, 18573,
	28599, 18574, -4473, -24385, -27200, -10945, 12983, 27809, 23138, 2244,
	-20223, -28511, -16810, 6676, 25482, 26423, 8838, -14943, -28247, -21747,
	0, 21747, 28247, 14943, -8837, -26422, -25482, -6676, 16810, 28511,
	20223, -2243, -23137, -27809, -12984, 10944, 27200, 24385, 4474, -18573,
	-28599, -18574, 4473, 24385, 27200, 10945, -12983, -27809, -23138, -2244,
	20222, 28511, 16810, -6676, -25482, -26423, -8838, 14943, 28247, 21747,
	0, -21747, -28247, -14943, 8837, 26422, 25482, 6676, -16810, -28511,
	-20223, 2243, 23137, 27809, 12984, -10944, -27200, -24385, -4474, 18573,
	28599, 18574, -4473, -24385, -27200, -10945, 12983, 27809, 23138, 2244,
	-20222, -28511, -16811, 6676, 25482, 26423, 8838, -14943, -28247, -21747},

	{	0, 21253, 28443, 16810, -5946, -24768, -27200, -11632, 11632, 27200,
	24768, 5946, -16810, -28443, -21253, 0, 21253, 28443, 16810, -5946,
	-24768, -27200, -11632, 11632, 27200, 24768, 5946, -16810, -28443, -21253,
	0, 21253, 28443, 16810, -5946, -24768, -27200, -11632, 11632, 27200,
	24768, 5946, -16810, -28443, -21253, 0, 21253, 28443, 16810, -5946,
	-24768, -27200, -11632, 11632, 27200, 24768, 5946, -16810, -28443, -21253,
	0, 21253, 28443, 16810, -5946, -24768, -27200, -11632, 11632, 27200,
	24768, 5946, -16810, -28443, -21253, 0, 21253, 28443, 16810, -5946,
	-24768, -27200, -11632, 11632, 27200, 24768, 5946, -16810, -28443, -21253,
	0, 21253, 28443, 16810, -5946, -24768, -27200, -11632, 11632, 27200,
	24768, 5946, -16810, -28443, -21253, 0, 21254, 28443, 16810, -5946,
	-24768, -27200, -11632, 11632, 27200, 24768, 5946, -16810, -28443, -21253,
	0, 21254, 28443, 16810, -5946, -24768, -27200, -11632, 11632, 27200,
	24768, 5946, -16810, -28443, -21253, 0, 21254, 28443, 16810, -5946,
	-24768, -27200, -11632, 11632, 27200, 24768, 5946, -16810, -28443, -21253,
	0, 21254, 28443, 16810, -5946, -24768, -27200, -11632, 11632, 27200,
	24768, 5946, -16810, -28443, -21253, 0, 21254, 28443, 16810, -5946,
	-24768, -27200, -11632, 11632, 27200, 24768, 5946, -16810, -28443, -21253,
	0, 21254, 28443, 16810, -5946, -24768, -27200, -11632, 11632, 27200,
	24768, 5946, -16810, -28443, -21253, 0, 21254, 28443, 16810, -5946,
	-24768, -27200, -11632, 11632, 27200, 24768, 5946, -16810, -28443, -21253,
	0, 21254, 28443, 16810, -5946, -24768, -27200, -11632, 11632, 27200,
	24768, 5946, -16810, -28443, -21253, 0, 21254, 28443, 16810, -5946,
	-24768, -27200, -11632, 11632, 27200, 24768, 5946, -16810, -28443, -21253},

	{	0, 22226, 27975, 12984, -11632, -27625, -23137, -1496, 21253, 28247,
	14300, -10249, -27200, -23985, -2989, 20223, 28443, 15576, -8837, -26700,
	-24768, -4474, 19137, 28560, 16810, -7402, -26127, -25482, -5946, 17998,
	28599, 17998, -5946, -25482, -26127, -7402, 16810, 28560, 19137, -4473,
	-24768, -26700, -8838, 15576, 28443, 20223, -2989, -23985, -27200, -10249,
	14299, 28247, 21254, -1496, -23137, -27625, -11632, 12983, 27974, 22226,
	0, -22226, -27975, -12984, 11632, 27625, 23137, 1496, -21253, -28247,
	-14300, 10249, 27200, 23986, 2989, -20223, -28443, -15576, 8837, 26700,
	24768, 4474, -19136, -28560, -16810, 7401, 26127, 25482, 5946, -17998,
	-28599, -17998, 5946, 25482, 26127, 7402, -16810, -28560, -19137, 4473,
	24768, 26700, 8838, -15576, -28443, -20223, 2989, 23985, 27200, 10249,
	-14299, -28247, -21254, 1496, 23137, 27625, 11632, -12983, -27974, -22226,
	0, 22226, 27975, 12984, -11632, -27625, -23138, -1497, 21253, 28247,
	14300, -10248, -27200, -23986, -2989, 20222, 28443, 15576, -8837, -26700,
	-24768, -4474, 19136, 28560, 16810, -7401, -26127, -25482, -5946, 17998,
	28599, 17998, -5945, -25482, -26127, -7402, 16810, 28560, 19137, -4473,
	-24768, -26700, -8838, 15576, 28443, 20223, -2989, -23985, -27200, -10249,
	14299, 28247, 21254, -1496, -23137, -27625, -11633, 12983, 27974, 22226,
	0, -22226, -27975, -12984, 11632, 27625, 23138, 1497, -21253, -28247,
	-14300, 10248, 27200, 23986, 2990, -20222, -28443, -15577, 8837, 26700,
	24768, 4474, -19136, -28560, -16811, 7401, 26127, 25483, 5946, -17998,
	-28599, -17999, 5945, 25482, 26127, 7402, -16810, -28560, -19137, 4473,
	24768, 26700, 8838, -15576, -28443, -20223, 2988, 23985, 27200, 10249,
	-14299, -28247, -21254, 1496, 23137, 27625, 11633, -12983, -27974, -22226},

	{	0, 23137, 27200, 8837, -16810, -28600, -16810, 8837, 27200, 23137,
	0, -23137, -27200, -8837, 16810, 28599, 16810, -8837, -27200, -23137,
	0, 23137, 27200, 8837, -16810, -28599, -16810, 8837, 27200, 23137,
	0, -23137, -27200, -8837, 16810, 28599, 16810, -8837, -27200, -23137,
	0, 23137, 27200, 8837, -16810, -28599, -16810, 8837, 27200, 23137,
	0, -23137, -27200, -8837, 16810, 28599, 16810, -8837, -27200, -23137,
	0, 23137, 27200, 8837, -16810, -28599, -16810, 8837, 27200, 23137,
	0, -23137, -27200, -8837, 16810, 28599, 16810, -8837, -27200, -23137,
	0, 23137, 27200, 8837, -16810, -28599, -16810, 8837, 27200, 23137,
	0, -23137, -27200, -8838, 16810, 28599, 16810, -8837, -27200, -23137,
	0, 23137, 27200, 8838, -16810, -28599, -16810, 8837, 27200, 23137,
	0, -23137, -27200, -8838, 16810, 28599, 16810, -8837, -27200, -23137,
	0, 23137, 27200, 8838, -16810, -28599, -16810, 8837, 27200, 23137,
	0, -23137, -27200, -8838, 16810, 28599, 16810, -8837, -27200, -23137,
	0, 23137, 27200, 8838, -16810, -28599, -16810, 8837, 27200, 23137,
	0, -23137, -27200, -8838, 16810, 28599, 16810, -8837, -27200, -23138,
	0, 23137, 27200, 8838, -16810, -28599, -16810, 8837, 27200, 23138,
	0, -23137, -27200, -8838, 16810, 28599, 16810, -8837, -27200, -23138,
	0, 23137, 27200, 8838, -16810, -28599, -16810, 8837, 27200, 23138,
	0, -23137, -27200, -8838, 16810, 28599, 16810, -8837, -27200, -23138,
	0, 23137, 27200, 8838, -16810, -28599, -16810, 8837, 27200, 23138,
	0, -23137, -27200, -8838, 16810, 28599, 16810, -8837, -27200, -23138,
	0, 23137, 27200, 8838, -16810, -28599, -16810, 8837, 27200, 23138,
	0, -23137, -27200, -8838, 16810, 28599, 16810, -8837, -27200, -23138},

	{	0, 23985, 26127, 4474, -21253, -27625, -8837, 17998, 28443, 12984,
	-14300, -28560, -16810, 10249, 27975, 20223, -5946, -26700, -23137, 1496,
	24768, 25482, 2989, -22226, -27200, -7402, 19137, 28247, 11632, -15576,
	-28599, -15576, 11632, 28247, 19137, -7402, -27200, -22226, 2989, 25482,
	24768, 1496, -23137, -26700, -5946, 20223, 27975, 10249, -16810, -28560,
	-14299, 12984, 28443, 17998, -8837, -27625, -21253, 4474, 26127, 23985,
	0, -23986, -26127, -4473, 21254, 27625, 8837, -17998, -28443, -12984,
	14300, 28560, 16810, -10249, -27975, -20223, 5946, 26700, 23137, -1496,
	-24768, -25482, -2989, 22226, 27200, 7402, -19137, -28247, -11632, 15576,
	28599, 15576, -11632, -28247, -19137, 7402, 27200, 22226, -2989, -25482,
	-24768, -1496, 23137, 26700, 5946, -20223, -27974, -10249, 16810, 28560,
	14299, -12984, -28443, -17998, 8838, 27625, 21253, -4474, -26127, -23985,
	0, 23986, 26127, 4473, -21254, -27625, -8837, 17998, 28443, 12983,
	-14300, -28560, -16810, 10249, 27975, 20223, -5946, -26700, -23137, 1497,
	24768, 25482, 2989, -22226, -27200, -7401, 19137, 28247, 11632, -15576,
	-28599, -15576, 11632, 28247, 19136, -7402, -27200, -22226, 2989, 25482,
	24768, 1496, -23138, -26700, -5946, 20223, 27974, 10249, -16810, -28560,
	-14299, 12984, 28443, 17998, -8838, -27625, -21253, 4474, 26127, 23985,
	0, -23986, -26127, -4473, 21254, 27625, 8837, -17998, -28443, -12983,
	14300, 28560, 16810, -10249, -27975, -20223, 5946, 26700, 23137, -1497,
	-24768, -25482, -2989, 22226, 27200, 7401, -19137, -28247, -11632, 15576,
	28599, 15576, -11632, -28247, -19136, 7402, 27200, 22226, -2989, -25482,
	-24768, -1496, 23138, 26700, 5945, -20223, -27974, -10248, 16810, 28560,
	14299, -12984, -28443, -17998, 8838, 27625, 21253, -4474, -26127, -23985}};


// 100 Baud FSK for one carrier. Used for OFDM ACK

CONST short intFSK100bdCarTemplate[4][120] = {
	{0, 18574, 28247, 24385, 8837, -10944, -25482, -27809, -16810, 2243,
	20223, 28511, 23137, 6676, -12984, -26422, -27200, -14943, 4474, 21747,
	28599, 21747, 4474, -14943, -27200, -26422, -12984, 6676, 23137, 28511,
	20223, 2243, -16810, -27809, -25482, -10944, 8837, 24385, 28247, 18574,
	0, -18574, -28247, -24385, -8837, 10944, 25482, 27809, 16810, -2243,
	-20223, -28511, -23137, -6676, 12984, 26422, 27200, 14943, -4473, -21747,
	-28599, -21747, -4474, 14943, 27200, 26422, 12984, -6676, -23137, -28511,
	-20223, -2244, 16810, 27809, 25482, 10944, -8837, -24385, -28247, -18574,
	0, 18574, 28247, 24385, 8837, -10944, -25482, -27809, -16810, 2243,
	20223, 28511, 23137, 6676, -12984, -26422, -27200, -14943, 4473, 21747,
	28599, 21747, 4474, -14943, -27200, -26422, -12984, 6676, 23137, 28511,
	20223, 2244, -16810, -27809, -25482, -10944, 8837, 24385, 28247, 18574},

	{	0, 19686, 28560, 21747, 2989, -17410, -28247, -23570, -5946, 14943,
	27625, 25134, 8837, -12312, -26700, -26422, -11632, 9546, 25482, 27422,
	14299, -6676, -23985, -28121, -16810, 3733, 22226, 28511, 19137, -748,
	-20223, -28590, -21253, -2243, 17998, 28355, 23137, 5211, -15576, -27809,
	-24768, -8122, 12984, 26959, 26127, 10944, -10249, -25813, -27200, -13646,
	7402, 24385, 27974, 16199, -4474, -22689, -28443, -18574, 1496, 20745,
	28599, 20745, 1496, -18574, -28443, -22689, -4473, 16199, 27975, 24385,
	7402, -13646, -27200, -25813, -10249, 10944, 26127, 26959, 12983, -8122,
	-24768, -27809, -15576, 5212, 23138, 28355, 17998, -2244, -21254, -28590,
	-20223, -748, 19137, 28511, 22226, 3732, -16810, -28121, -23985, -6676,
	14300, 27422, 25482, 9546, -11632, -26423, -26700, -12312, 8838, 25134,
	27625, 14943, -5946, -23570, -28247, -17410, 2989, 21747, 28560, 19686},

	{	0, 20745, 28560, 18574, -2989, -22689, -28247, -16199, 5946, 24385,
	27625, 13646, -8837, -25813, -26700, -10944, 11632, 26959, 25482, 8122,
	-14299, -27809, -23986, -5212, 16810, 28355, 22226, 2244, -19137, -28590,
	-20223, 748, 21253, 28511, 17998, -3732, -23137, -28121, -15576, 6676,
	24768, 27422, 12984, -9546, -26127, -26423, -10249, 12312, 27200, 25134,
	7402, -14943, -27974, -23570, -4474, 17410, 28443, 21747, 1496, -19686,
	-28599, -19687, 1496, 21747, 28443, 17410, -4473, -23569, -27975, -14943,
	7402, 25134, 27200, 12312, -10249, -26422, -26127, -9547, 12983, 27422,
	24768, 6676, -15576, -28121, -23138, -3733, 17998, 28511, 21254, 748,
	-20223, -28590, -19137, 2243, 22226, 28355, 16810, -5211, -23985, -27809,
	-14300, 8122, 25482, 26959, 11632, -10944, -26700, -25814, -8838, 13646,
	27625, 24385, 5946, -16198, -28247, -22690, -2989, 18574, 28560, 20745},

	{	0, 21747, 28247, 14943, -8837, -26422, -25482, -6676, 16810, 28511,
	20223, -2243, -23137, -27809, -12984, 10944, 27200, 24385, 4474, -18574,
	-28599, -18574, 4474, 24385, 27200, 10944, -12984, -27809, -23137, -2243,
	20223, 28511, 16810, -6676, -25482, -26422, -8837, 14943, 28247, 21747,
	0, -21747, -28247, -14943, 8837, 26422, 25482, 6676, -16810, -28511,
	-20223, 2243, 23137, 27809, 12984, -10944, -27200, -24385, -4474, 18574,
	28599, 18574, -4474, -24385, -27200, -10944, 12984, 27809, 23137, 2243,
	-20223, -28511, -16810, 6676, 25482, 26422, 8837, -14943, -28247, -21747,
	0, 21747, 28247, 14943, -8837, -26422, -25482, -6676, 16810, 28511,
	20223, -2243, -23137, -27809, -12984, 10944, 27200, 24385, 4473, -18574,
	-28599, -18574, 4474, 24385, 27200, 10944, -12984, -27809, -23137, -2243,
	20223, 28511, 16810, -6676, -25482, -26422, -8837, 14943, 28247, 21747}};

CONST short intQAM50bdCarTemplate[11][4][120] = 
{
	{
		{// Carrier 0 Phase 0
	0, 8034, 15282, 21034, 24727, 26000, 24727, 21034, 15282, 8034,
	0, -8034, -15282, -21034, -24727, -26000, -24727, -21034, -15282, -8034,
	0, 8034, 15282, 21034, 24727, 26000, 24727, 21034, 15282, 8034,
	0, -8034, -15282, -21034, -24727, -26000, -24727, -21034, -15282, -8034,
	0, 8034, 15282, 21034, 24727, 26000, 24727, 21034, 15282, 8034,
	0, -8034, -15282, -21034, -24727, -26000, -24727, -21034, -15282, -8034,
	0, 8034, 15282, 21034, 24727, 26000, 24727, 21034, 15282, 8034,
	0, -8034, -15282, -21034, -24727, -26000, -24727, -21034, -15282, -8034,
	0, 8034, 15282, 21034, 24727, 26000, 24727, 21034, 15282, 8034,
	0, -8034, -15282, -21034, -24727, -26000, -24727, -21034, -15282, -8034,
	0, 8034, 15282, 21034, 24727, 26000, 24727, 21034, 15282, 8034,
	0, -8034, -15282, -21034, -24727, -26000, -24727, -21034, -15282, -8034},
	{// Carrier 0 Phase 1
	18384, 23166, 25679, 25679, 23166, 18384, 11803, 4067, -4067, -11803,
	-18384, -23166, -25679, -25679, -23166, -18384, -11803, -4067, 4067, 11803,
	18384, 23166, 25679, 25679, 23166, 18384, 11803, 4067, -4067, -11803,
	-18384, -23166, -25679, -25679, -23166, -18384, -11803, -4067, 4067, 11803,
	18384, 23166, 25679, 25679, 23166, 18384, 11803, 4067, -4067, -11803,
	-18384, -23166, -25679, -25679, -23166, -18384, -11803, -4067, 4067, 11803,
	18384, 23166, 25679, 25679, 23166, 18384, 11803, 4067, -4067, -11803,
	-18384, -23166, -25679, -25679, -23166, -18384, -11803, -4067, 4067, 11803,
	18384, 23166, 25679, 25679, 23166, 18384, 11803, 4067, -4067, -11803,
	-18384, -23166, -25679, -25679, -23166, -18384, -11803, -4067, 4067, 11803,
	18384, 23166, 25679, 25679, 23166, 18384, 11803, 4067, -4067, -11803,
	-18384, -23166, -25679, -25679, -23166, -18384, -11803, -4067, 4067, 11803},
	{// Carrier 0 Phase 2
	26000, 24727, 21034, 15282, 8034, 0, -8034, -15282, -21034, -24727,
	-26000, -24727, -21034, -15282, -8034, 0, 8034, 15282, 21034, 24727,
	26000, 24727, 21034, 15282, 8034, 0, -8034, -15282, -21034, -24727,
	-26000, -24727, -21034, -15282, -8034, 0, 8034, 15282, 21034, 24727,
	26000, 24727, 21034, 15282, 8034, 0, -8034, -15282, -21034, -24727,
	-26000, -24727, -21034, -15282, -8034, 0, 8034, 15282, 21034, 24727,
	26000, 24727, 21034, 15282, 8034, 0, -8034, -15282, -21034, -24727,
	-26000, -24727, -21034, -15282, -8034, 0, 8034, 15282, 21034, 24727,
	26000, 24727, 21034, 15282, 8034, 0, -8034, -15282, -21034, -24727,
	-26000, -24727, -21034, -15282, -8034, 0, 8034, 15282, 21034, 24727,
	26000, 24727, 21034, 15282, 8034, 0, -8034, -15282, -21034, -24727,
	-26000, -24727, -21034, -15282, -8034, 0, 8034, 15282, 21034, 24727},
	{// Carrier 0 Phase 3
	18384, 11803, 4067, -4067, -11803, -18384, -23166, -25679, -25679, -23166,
	-18384, -11803, -4067, 4067, 11803, 18384, 23166, 25679, 25679, 23166,
	18384, 11803, 4067, -4067, -11803, -18384, -23166, -25679, -25679, -23166,
	-18384, -11803, -4067, 4067, 11803, 18384, 23166, 25679, 25679, 23166,
	18384, 11803, 4067, -4067, -11803, -18384, -23166, -25679, -25679, -23166,
	-18384, -11803, -4067, 4067, 11803, 18384, 23166, 25679, 25679, 23166,
	18384, 11803, 4067, -4067, -11803, -18384, -23166, -25679, -25679, -23166,
	-18384, -11803, -4067, 4067, 11803, 18384, 23166, 25679, 25679, 23166,
	18384, 11803, 4067, -4067, -11803, -18384, -23166, -25679, -25679, -23166,
	-18384, -11803, -4067, 4067, 11803, 18384, 23166, 25679, 25679, 23166,
	18384, 11803, 4067, -4067, -11803, -18384, -23166, -25679, -25679, -23166,
	-18384, -11803, -4067, 4067, 11803, 18384, 23166, 25679, 25679, 23166},
	},

	{{// Carrier 1 Phase 0
	0, 10575, 19321, 24727, 25857, 22516, 15282, 5405, -5405, -15282,
	-22516, -25857, -24727, -19321, -10575, 0, 10575, 19321, 24727, 25857,
	22516, 15282, 5405, -5405, -15282, -22516, -25857, -24727, -19321, -10575,
	0, 10575, 19321, 24727, 25857, 22516, 15282, 5405, -5405, -15282,
	-22516, -25857, -24727, -19321, -10575, 0, 10575, 19321, 24727, 25857,
	22516, 15282, 5405, -5405, -15282, -22516, -25857, -24727, -19321, -10575,
	0, 10575, 19321, 24727, 25857, 22516, 15282, 5405, -5405, -15282,
	-22516, -25857, -24727, -19321, -10575, 0, 10575, 19321, 24727, 25857,
	22516, 15282, 5405, -5405, -15282, -22516, -25857, -24727, -19321, -10575,
	0, 10575, 19321, 24727, 25857, 22516, 15282, 5405, -5405, -15282,
	-22516, -25857, -24727, -19321, -10575, 0, 10575, 19321, 24727, 25857,
	22516, 15282, 5405, -5405, -15282, -22516, -25857, -24727, -19321, -10575},
	{
// Carrier 1 Phase 1
	18384, 24273, 25964, 23166, 16362, 6729, -4067, -14160, -21805, -25679,
	-25114, -20205, -11803, -1360, 9317, 18384, 24273, 25964, 23166, 16362,
	6729, -4067, -14160, -21805, -25679, -25114, -20205, -11803, -1360, 9317,
	18384, 24273, 25964, 23166, 16362, 6729, -4067, -14160, -21805, -25679,
	-25114, -20205, -11803, -1360, 9317, 18384, 24273, 25964, 23166, 16362,
	6729, -4067, -14160, -21805, -25679, -25114, -20205, -11803, -1360, 9317,
	18384, 24273, 25964, 23166, 16362, 6729, -4067, -14160, -21805, -25679,
	-25114, -20205, -11803, -1360, 9317, 18384, 24273, 25964, 23166, 16362,
	6729, -4067, -14160, -21805, -25679, -25114, -20205, -11803, -1360, 9317,
	18384, 24273, 25964, 23166, 16362, 6729, -4067, -14160, -21805, -25679,
	-25114, -20205, -11803, -1360, 9317, 18384, 24273, 25964, 23166, 16362,
	6729, -4067, -14160, -21805, -25679, -25114, -20205, -11803, -1360, 9317},
	{
// Carrier 1 Phase 2
	26000, 23752, 17397, 8034, -2717, -12999, -21034, -25431, -25431, -21034,
	-13000, -2717, 8034, 17397, 23752, 26000, 23752, 17397, 8034, -2717,
	-13000, -21034, -25431, -25431, -21034, -12999, -2717, 8034, 17397, 23752,
	26000, 23752, 17397, 8034, -2717, -13000, -21034, -25431, -25431, -21034,
	-12999, -2717, 8034, 17397, 23752, 26000, 23752, 17397, 8034, -2717,
	-13000, -21034, -25431, -25431, -21034, -12999, -2717, 8034, 17397, 23752,
	26000, 23752, 17397, 8034, -2717, -13000, -21034, -25431, -25431, -21034,
	-12999, -2717, 8034, 17397, 23752, 26000, 23752, 17397, 8034, -2717,
	-13000, -21034, -25431, -25431, -21034, -12999, -2717, 8034, 17397, 23752,
	26000, 23752, 17397, 8034, -2717, -13000, -21034, -25431, -25431, -21034,
	-12999, -2717, 8034, 17397, 23752, 26000, 23752, 17397, 8034, -2717,
	-13000, -21034, -25431, -25431, -21034, -12999, -2717, 8034, 17397, 23752},
	{
// Carrier 1 Phase 3
	18384, 9317, -1360, -11803, -20205, -25114, -25679, -21805, -14160, -4067,
	6729, 16362, 23166, 25964, 24273, 18384, 9317, -1360, -11803, -20205,
	-25114, -25679, -21805, -14160, -4067, 6729, 16362, 23166, 25964, 24273,
	18384, 9317, -1360, -11803, -20205, -25114, -25679, -21805, -14160, -4067,
	6729, 16362, 23166, 25964, 24273, 18384, 9317, -1360, -11803, -20205,
	-25114, -25679, -21805, -14160, -4067, 6729, 16362, 23166, 25964, 24273,
	18384, 9317, -1360, -11803, -20205, -25114, -25679, -21805, -14160, -4067,
	6729, 16362, 23166, 25964, 24273, 18384, 9317, -1360, -11803, -20205,
	-25114, -25679, -21805, -14160, -4067, 6729, 16362, 23166, 25964, 24273,
	18384, 9317, -1360, -11803, -20205, -25114, -25679, -21805, -14160, -4067,
	6729, 16362, 23166, 25964, 24273, 18384, 9317, -1360, -11803, -20205,
	-25114, -25679, -21805, -14160, -4067, 6729, 16362, 23166, 25964, 24273},
	},

	{{// Carrier 2 Phase 0
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999, -22516, -26000,
	-22516, -13000, 0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000, 22516, 13000,
	0, -12999, -22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000, 0, 12999,
	22516, 26000, 22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999, -22516, -26000,
	-22516, -13000, 0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000, 22516, 13000,
	0, -12999, -22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000, 0, 12999,
	22516, 26000, 22516, 13000, 0, -12999, -22516, -26000, -22516, -13000},
	{
// Carrier 2 Phase 1
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114, -25114, -18384,
	-6729, 6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384, 6729, -6729,
	-18384, -25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729, 18384, 25114,
	25114, 18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114, -25114, -18384,
	-6729, 6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384, 6729, -6729,
	-18384, -25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729, 18384, 25114,
	25114, 18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729},
	{
// Carrier 2 Phase 2
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516, -13000, 0,
	12999, 22516, 26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0, -12999, -22516,
	-26000, -22516, -13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516, 26000, 22516,
	13000, 0, -12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516, -13000, 0,
	12999, 22516, 26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0, -12999, -22516,
	-26000, -22516, -13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516, 26000, 22516,
	13000, 0, -12999, -22516, -26000, -22516, -13000, 0, 12999, 22516},
	{
// Carrier 2 Phase 3
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729, 18384,
	25114, 25114, 18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114, -25114,
	-18384, -6729, 6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384, 6729,
	-6729, -18384, -25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729, 18384,
	25114, 25114, 18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114, -25114,
	-18384, -6729, 6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384, 6729,
	-6729, -18384, -25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114},
	},

	{{// Carrier 3 Phase 0
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282,
	0, 15282, 24727, 24727, 15282, 0, -15282, -24727, -24727, -15282},
	{
// Carrier 3 Phase 1
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067,
	18384, 25679, 23166, 11803, -4067, -18384, -25679, -23166, -11803, 4067},
	{
// Carrier 3 Phase 2
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034,
	26000, 21034, 8034, -8034, -21034, -26000, -21034, -8034, 8034, 21034},
	{
// Carrier 3 Phase 3
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679,
	18384, 4067, -11803, -23166, -25679, -18384, -4067, 11803, 23166, 25679},
	},

	{{//Carrier 4 Phase 0
	0, 17397, 25857, 21034, 5405, -12999, -24727, -23752, -10575, 8034,
	22516, 25431, 15282, -2717, -19321, -26000, -19321, -2717, 15282, 25431,
	22516, 8034, -10575, -23752, -24727, -12999, 5405, 21034, 25857, 17397,
	0, -17397, -25857, -21034, -5405, 13000, 24727, 23752, 10575, -8034,
	-22516, -25431, -15282, 2717, 19321, 26000, 19321, 2717, -15282, -25431,
	-22516, -8034, 10575, 23752, 24727, 12999, -5405, -21034, -25857, -17397,
	0, 17397, 25857, 21034, 5405, -13000, -24727, -23752, -10575, 8034,
	22516, 25431, 15282, -2717, -19321, -26000, -19321, -2717, 15282, 25431,
	22516, 8034, -10575, -23752, -24727, -12999, 5405, 21034, 25857, 17397,
	0, -17397, -25857, -21034, -5405, 13000, 24727, 23752, 10575, -8034,
	-22516, -25431, -15282, 2717, 19321, 26000, 19321, 2717, -15282, -25431,
	-22516, -8034, 10575, 23752, 24727, 12999, -5405, -21034, -25857, -17397},
	{
// Carrier 4 Phase 1
	18384, 25964, 20205, 4067, -14160, -25114, -23166, -9317, 9317, 23166,
	25114, 14160, -4067, -20205, -25964, -18384, -1360, 16362, 25679, 21805,
	6729, -11803, -24273, -24273, -11803, 6729, 21805, 25679, 16362, -1360,
	-18384, -25964, -20205, -4067, 14160, 25114, 23166, 9317, -9317, -23166,
	-25114, -14160, 4067, 20205, 25964, 18384, 1360, -16362, -25679, -21805,
	-6729, 11803, 24273, 24273, 11803, -6729, -21805, -25679, -16362, 1360,
	18384, 25964, 20205, 4067, -14160, -25114, -23166, -9317, 9317, 23166,
	25114, 14160, -4067, -20205, -25964, -18384, -1360, 16362, 25679, 21805,
	6729, -11803, -24273, -24273, -11803, 6729, 21805, 25679, 16362, -1360,
	-18384, -25964, -20205, -4067, 14160, 25114, 23166, 9317, -9317, -23166,
	-25114, -14160, 4067, 20205, 25964, 18384, 1360, -16362, -25679, -21805,
	-6729, 11803, 24273, 24273, 11803, -6729, -21805, -25679, -16362, 1360},
	{
// Carrier 4 Phase 2
	26000, 19321, 2717, -15282, -25431, -22516, -8034, 10575, 23752, 24727,
	12999, -5405, -21034, -25857, -17397, 0, 17397, 25857, 21034, 5405,
	-13000, -24727, -23752, -10575, 8034, 22516, 25431, 15282, -2717, -19321,
	-26000, -19321, -2717, 15282, 25431, 22516, 8034, -10575, -23752, -24727,
	-12999, 5405, 21034, 25857, 17397, 0, -17397, -25857, -21034, -5405,
	13000, 24727, 23752, 10575, -8034, -22516, -25431, -15282, 2717, 19321,
	26000, 19321, 2717, -15282, -25431, -22516, -8034, 10575, 23752, 24727,
	12999, -5405, -21034, -25857, -17397, 0, 17397, 25857, 21034, 5405,
	-13000, -24727, -23752, -10575, 8034, 22516, 25431, 15282, -2717, -19321,
	-26000, -19321, -2717, 15282, 25431, 22516, 8034, -10575, -23752, -24727,
	-12999, 5405, 21034, 25857, 17397, 0, -17397, -25857, -21034, -5405,
	13000, 24727, 23752, 10575, -8034, -22516, -25431, -15282, 2717, 19321},
	{
// Carrier 4 Phase 3
	18384, 1360, -16362, -25679, -21805, -6729, 11803, 24273, 24273, 11803,
	-6729, -21805, -25679, -16362, 1360, 18384, 25964, 20205, 4067, -14160,
	-25114, -23166, -9317, 9317, 23166, 25114, 14160, -4067, -20205, -25964,
	-18384, -1360, 16362, 25679, 21805, 6729, -11803, -24273, -24273, -11803,
	6729, 21805, 25679, 16362, -1360, -18384, -25964, -20205, -4067, 14160,
	25114, 23166, 9317, -9317, -23166, -25114, -14160, 4067, 20205, 25964,
	18384, 1360, -16362, -25679, -21805, -6729, 11803, 24273, 24273, 11803,
	-6729, -21805, -25679, -16362, 1360, 18384, 25964, 20205, 4067, -14160,
	-25114, -23166, -9317, 9317, 23166, 25114, 14160, -4067, -20205, -25964,
	-18384, -1360, 16362, 25679, 21805, 6729, -11803, -24273, -24273, -11803,
	6729, 21805, 25679, 16362, -1360, -18384, -25964, -20205, -4067, 14160,
	25114, 23166, 9317, -9317, -23166, -25114, -14160, 4067, 20205, 25964},
	},

	{{// Carrier 5 Phase 0
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384,
	0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384,
	-26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384,
	0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384,
	-26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384,
	0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384,
	-26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384},
	{
// Carrier 5 Phase 1
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0,
	-18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000,
	-18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0,
	-18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000,
	-18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0,
	-18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000,
	-18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0},
	{
// Carrier 5 Phase 2
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384,
	0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384,
	-26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384,
	0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384,
	-26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384,
	0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384,
	-26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384},
	{
// Carrier 5 Phase 3
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0,
	-18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000,
	-18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0,
	-18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000,
	-18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000, 18384, 0,
	-18384, -26000, -18384, 0, 18384, 26000, 18384, 0, -18384, -26000,
	-18384, 0, 18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0, 18384, 26000},
	},

	{{//Carrier 6 Phase 0
	0, 19321, 25857, 15282, -5405, -22516, -24727, -10575, 10575, 24727,
	22516, 5405, -15282, -25857, -19321, 0, 19321, 25857, 15282, -5405,
	-22516, -24727, -10575, 10575, 24727, 22516, 5405, -15282, -25857, -19321,
	0, 19321, 25857, 15282, -5405, -22516, -24727, -10575, 10575, 24727,
	22516, 5405, -15282, -25857, -19321, 0, 19321, 25857, 15282, -5405,
	-22516, -24727, -10575, 10575, 24727, 22516, 5405, -15282, -25857, -19321,
	0, 19321, 25857, 15282, -5405, -22516, -24727, -10575, 10575, 24727,
	22516, 5405, -15282, -25857, -19321, 0, 19321, 25857, 15282, -5405,
	-22516, -24727, -10575, 10575, 24727, 22516, 5405, -15282, -25857, -19321,
	0, 19321, 25857, 15282, -5405, -22516, -24727, -10575, 10575, 24727,
	22516, 5405, -15282, -25857, -19321, 0, 19321, 25857, 15282, -5405,
	-22516, -24727, -10575, 10575, 24727, 22516, 5405, -15282, -25857, -19321},
	{
// Carrier 6 Phase 1
	18384, 25964, 16362, -4067, -21805, -25114, -11803, 9317, 24273, 23166,
	6729, -14160, -25679, -20205, -1360, 18384, 25964, 16362, -4067, -21805,
	-25114, -11803, 9317, 24273, 23166, 6729, -14160, -25679, -20205, -1360,
	18384, 25964, 16362, -4067, -21805, -25114, -11803, 9317, 24273, 23166,
	6729, -14160, -25679, -20205, -1360, 18384, 25964, 16362, -4067, -21805,
	-25114, -11803, 9317, 24273, 23166, 6729, -14160, -25679, -20205, -1360,
	18384, 25964, 16362, -4067, -21805, -25114, -11803, 9317, 24273, 23166,
	6729, -14160, -25679, -20205, -1360, 18384, 25964, 16362, -4067, -21805,
	-25114, -11803, 9317, 24273, 23166, 6729, -14160, -25679, -20205, -1360,
	18384, 25964, 16362, -4067, -21805, -25114, -11803, 9317, 24273, 23166,
	6729, -14160, -25679, -20205, -1360, 18384, 25964, 16362, -4067, -21805,
	-25114, -11803, 9317, 24273, 23166, 6729, -14160, -25679, -20205, -1360},
	{
// Carrier 6 Phase 2
	26000, 17397, -2717, -21034, -25431, -13000, 8034, 23752, 23752, 8034,
	-13000, -25431, -21034, -2717, 17397, 26000, 17397, -2717, -21034, -25431,
	-12999, 8034, 23752, 23752, 8034, -13000, -25431, -21034, -2717, 17397,
	26000, 17397, -2717, -21034, -25431, -12999, 8034, 23752, 23752, 8034,
	-13000, -25431, -21034, -2717, 17397, 26000, 17397, -2717, -21034, -25431,
	-12999, 8034, 23752, 23752, 8034, -13000, -25431, -21034, -2717, 17397,
	26000, 17397, -2717, -21034, -25431, -12999, 8034, 23752, 23752, 8034,
	-13000, -25431, -21034, -2717, 17397, 26000, 17397, -2717, -21034, -25431,
	-12999, 8034, 23752, 23752, 8034, -13000, -25431, -21034, -2717, 17397,
	26000, 17397, -2717, -21034, -25431, -12999, 8034, 23752, 23752, 8034,
	-13000, -25431, -21034, -2717, 17397, 26000, 17397, -2717, -21034, -25431,
	-12999, 8034, 23752, 23752, 8034, -13000, -25431, -21034, -2717, 17397},
	{
// Carrier 6 Phase 3
	18384, -1360, -20205, -25679, -14160, 6729, 23166, 24273, 9317, -11803,
	-25114, -21805, -4067, 16362, 25964, 18384, -1360, -20205, -25679, -14160,
	6729, 23166, 24273, 9317, -11803, -25114, -21805, -4067, 16362, 25964,
	18384, -1360, -20205, -25679, -14160, 6729, 23166, 24273, 9317, -11803,
	-25114, -21805, -4067, 16362, 25964, 18384, -1360, -20205, -25679, -14160,
	6729, 23166, 24273, 9317, -11803, -25114, -21805, -4067, 16362, 25964,
	18384, -1360, -20205, -25679, -14160, 6729, 23166, 24273, 9317, -11803,
	-25114, -21805, -4067, 16362, 25964, 18384, -1360, -20205, -25679, -14160,
	6729, 23166, 24273, 9317, -11803, -25114, -21805, -4067, 16362, 25964,
	18384, -1360, -20205, -25679, -14160, 6729, 23166, 24273, 9317, -11803,
	-25114, -21805, -4067, 16362, 25964, 18384, -1360, -20205, -25679, -14160,
	6729, 23166, 24273, 9317, -11803, -25114, -21805, -4067, 16362, 25964},
	},

	{{// Carrier 7 Phase 0
	0, 21034, 24727, 8034, -15282, -26000, -15282, 8034, 24727, 21034,
	0, -21034, -24727, -8034, 15282, 26000, 15282, -8034, -24727, -21034,
	0, 21034, 24727, 8034, -15282, -26000, -15282, 8034, 24727, 21034,
	0, -21034, -24727, -8034, 15282, 26000, 15282, -8034, -24727, -21034,
	0, 21034, 24727, 8034, -15282, -26000, -15282, 8034, 24727, 21034,
	0, -21034, -24727, -8034, 15282, 26000, 15282, -8034, -24727, -21034,
	0, 21034, 24727, 8034, -15282, -26000, -15282, 8034, 24727, 21034,
	0, -21034, -24727, -8034, 15282, 26000, 15282, -8034, -24727, -21034,
	0, 21034, 24727, 8034, -15282, -26000, -15282, 8034, 24727, 21034,
	0, -21034, -24727, -8034, 15282, 26000, 15282, -8034, -24727, -21034,
	0, 21034, 24727, 8034, -15282, -26000, -15282, 8034, 24727, 21034,
	0, -21034, -24727, -8034, 15282, 26000, 15282, -8034, -24727, -21034},
	{
// Carrier 7 Phase 1
	18384, 25679, 11803, -11803, -25679, -18384, 4067, 23166, 23166, 4067,
	-18384, -25679, -11803, 11803, 25679, 18384, -4067, -23166, -23166, -4067,
	18384, 25679, 11803, -11803, -25679, -18384, 4067, 23166, 23166, 4067,
	-18384, -25679, -11803, 11803, 25679, 18384, -4067, -23166, -23166, -4067,
	18384, 25679, 11803, -11803, -25679, -18384, 4067, 23166, 23166, 4067,
	-18384, -25679, -11803, 11803, 25679, 18384, -4067, -23166, -23166, -4067,
	18384, 25679, 11803, -11803, -25679, -18384, 4067, 23166, 23166, 4067,
	-18384, -25679, -11803, 11803, 25679, 18384, -4067, -23166, -23166, -4067,
	18384, 25679, 11803, -11803, -25679, -18384, 4067, 23166, 23166, 4067,
	-18384, -25679, -11803, 11803, 25679, 18384, -4067, -23166, -23166, -4067,
	18384, 25679, 11803, -11803, -25679, -18384, 4067, 23166, 23166, 4067,
	-18384, -25679, -11803, 11803, 25679, 18384, -4067, -23166, -23166, -4067},
	{
// Carrier 7 Phase 2
	26000, 15282, -8034, -24727, -21034, 0, 21034, 24727, 8034, -15282,
	-26000, -15282, 8034, 24727, 21034, 0, -21034, -24727, -8034, 15282,
	26000, 15282, -8034, -24727, -21034, 0, 21034, 24727, 8034, -15282,
	-26000, -15282, 8034, 24727, 21034, 0, -21034, -24727, -8034, 15282,
	26000, 15282, -8034, -24727, -21034, 0, 21034, 24727, 8034, -15282,
	-26000, -15282, 8034, 24727, 21034, 0, -21034, -24727, -8034, 15282,
	26000, 15282, -8034, -24727, -21034, 0, 21034, 24727, 8034, -15282,
	-26000, -15282, 8034, 24727, 21034, 0, -21034, -24727, -8034, 15282,
	26000, 15282, -8034, -24727, -21034, 0, 21034, 24727, 8034, -15282,
	-26000, -15282, 8034, 24727, 21034, 0, -21034, -24727, -8034, 15282,
	26000, 15282, -8034, -24727, -21034, 0, 21034, 24727, 8034, -15282,
	-26000, -15282, 8034, 24727, 21034, 0, -21034, -24727, -8034, 15282},
	{
// Carrier 7 Phase 3
	18384, -4067, -23166, -23166, -4067, 18384, 25679, 11803, -11803, -25679,
	-18384, 4067, 23166, 23166, 4067, -18384, -25679, -11803, 11803, 25679,
	18384, -4067, -23166, -23166, -4067, 18384, 25679, 11803, -11803, -25679,
	-18384, 4067, 23166, 23166, 4067, -18384, -25679, -11803, 11803, 25679,
	18384, -4067, -23166, -23166, -4067, 18384, 25679, 11803, -11803, -25679,
	-18384, 4067, 23166, 23166, 4067, -18384, -25679, -11803, 11803, 25679,
	18384, -4067, -23166, -23166, -4067, 18384, 25679, 11803, -11803, -25679,
	-18384, 4067, 23166, 23166, 4067, -18384, -25679, -11803, 11803, 25679,
	18384, -4067, -23166, -23166, -4067, 18384, 25679, 11803, -11803, -25679,
	-18384, 4067, 23166, 23166, 4067, -18384, -25679, -11803, 11803, 25679,
	18384, -4067, -23166, -23166, -4067, 18384, 25679, 11803, -11803, -25679,
	-18384, 4067, 23166, 23166, 4067, -18384, -25679, -11803, 11803, 25679},
	},

	{{// Carrier 8 Phase 0
	0, 22516, 22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0, -22516, -22516},
	{
// Carrier 8 Phase 1
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729},
	{
// Carrier 8 Phase 2
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999},
	{
// Carrier 8 Phase 3
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114},
	},

	{{// Carrier 9 Phase 0
	0, 23752, 19321, -8034, -25857, -13000, 15282, 25431, 5405, -21034,
	-22516, 2717, 24727, 17397, -10575, -26000, -10575, 17397, 24727, 2717,
	-22516, -21034, 5405, 25431, 15282, -13000, -25857, -8034, 19321, 23752,
	0, -23752, -19321, 8034, 25857, 12999, -15282, -25431, -5405, 21034,
	22516, -2717, -24727, -17397, 10575, 26000, 10575, -17397, -24727, -2717,
	22516, 21034, -5405, -25431, -15282, 13000, 25857, 8034, -19321, -23752,
	0, 23752, 19321, -8034, -25857, -12999, 15282, 25431, 5405, -21034,
	-22516, 2717, 24727, 17397, -10575, -26000, -10575, 17397, 24727, 2717,
	-22516, -21034, 5405, 25431, 15282, -13000, -25857, -8034, 19321, 23752,
	0, -23752, -19321, 8034, 25857, 12999, -15282, -25431, -5405, 21034,
	22516, -2717, -24727, -17397, 10575, 26000, 10575, -17397, -24727, -2717,
	22516, 21034, -5405, -25431, -15282, 13000, 25857, 8034, -19321, -23752},
	{
// Carrier 9 Phase 1
	18384, 24273, 1360, -23166, -20205, 6729, 25679, 14160, -14160, -25679,
	-6729, 20205, 23166, -1360, -24273, -18384, 9317, 25964, 11803, -16362,
	-25114, -4067, 21805, 21805, -4067, -25114, -16362, 11803, 25964, 9317,
	-18384, -24273, -1360, 23166, 20205, -6729, -25679, -14160, 14160, 25679,
	6729, -20205, -23166, 1360, 24273, 18384, -9317, -25964, -11803, 16362,
	25114, 4067, -21805, -21805, 4067, 25114, 16362, -11803, -25964, -9317,
	18384, 24273, 1360, -23166, -20205, 6729, 25679, 14160, -14160, -25679,
	-6729, 20205, 23166, -1360, -24273, -18384, 9317, 25964, 11803, -16362,
	-25114, -4067, 21805, 21805, -4067, -25114, -16362, 11803, 25964, 9317,
	-18384, -24273, -1360, 23166, 20205, -6729, -25679, -14160, 14160, 25679,
	6729, -20205, -23166, 1360, 24273, 18384, -9317, -25964, -11803, 16362,
	25114, 4067, -21805, -21805, 4067, 25114, 16362, -11803, -25964, -9317},
	{
// Carrier 9 Phase 2
	26000, 10575, -17397, -24727, -2717, 22516, 21034, -5405, -25431, -15282,
	12999, 25857, 8034, -19321, -23752, 0, 23752, 19321, -8034, -25857,
	-13000, 15282, 25431, 5405, -21034, -22516, 2717, 24727, 17397, -10575,
	-26000, -10575, 17397, 24727, 2717, -22516, -21034, 5405, 25431, 15282,
	-13000, -25857, -8034, 19321, 23752, 0, -23752, -19321, 8034, 25857,
	12999, -15282, -25431, -5405, 21034, 22516, -2717, -24727, -17397, 10575,
	26000, 10575, -17397, -24727, -2717, 22516, 21034, -5405, -25431, -15282,
	13000, 25857, 8034, -19321, -23752, 0, 23752, 19321, -8034, -25857,
	-12999, 15282, 25431, 5405, -21034, -22516, 2717, 24727, 17397, -10575,
	-26000, -10575, 17397, 24727, 2717, -22516, -21034, 5405, 25431, 15282,
	-13000, -25857, -8034, 19321, 23752, 0, -23752, -19321, 8034, 25857,
	12999, -15282, -25431, -5405, 21034, 22516, -2717, -24727, -17397, 10575},
	{
// Carrier 9 Phase 3
	18384, -9317, -25964, -11803, 16362, 25114, 4067, -21805, -21805, 4067,
	25114, 16362, -11803, -25964, -9317, 18384, 24273, 1360, -23166, -20205,
	6729, 25679, 14160, -14160, -25679, -6729, 20205, 23166, -1360, -24273,
	-18384, 9317, 25964, 11803, -16362, -25114, -4067, 21805, 21805, -4067,
	-25114, -16362, 11803, 25964, 9317, -18384, -24273, -1360, 23166, 20205,
	-6729, -25679, -14160, 14160, 25679, 6729, -20205, -23166, 1360, 24273,
	18384, -9317, -25964, -11803, 16362, 25114, 4067, -21805, -21805, 4067,
	25114, 16362, -11803, -25964, -9317, 18384, 24273, 1360, -23166, -20205,
	6729, 25679, 14160, -14160, -25679, -6729, 20205, 23166, -1360, -24273,
	-18384, 9317, 25964, 11803, -16362, -25114, -4067, 21805, 21805, -4067,
	-25114, -16362, 11803, 25964, 9317, -18384, -24273, -1360, 23166, 20205,
	-6729, -25679, -14160, 14160, 25679, 6729, -20205, -23166, 1360, 24273},
	},

	{{// Carrier 10 Phase 0
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727,
	0, 24727, 15282, -15282, -24727, 0, 24727, 15282, -15282, -24727},
	{
// Carrier 10 Phase 1
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803,
	18384, 23166, -4067, -25679, -11803, 18384, 23166, -4067, -25679, -11803},
	{
// Carrier 10 Phase 2
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034,
	26000, 8034, -21034, -21034, 8034, 26000, 8034, -21034, -21034, 8034},
	{
// Carrier 10 Phase 3
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11803, -25679, -4067, 23166,
	18384, -11803, -25679, -4067, 23166, 18384, -11804, -25679, -4067, 23166}
	}};


CONST short intOFDMTemplate[MAXCAR][8][216] = 
{{{

// Carrier 0 Phase 0
	0, 4514, 8892, 12999, 16712, 19917, 22516, 24432,
	25605, 26000, 25605, 24432, 22516, 19917, 16712, 13000,
	8892, 4514, 0, -4514, -8892, -12999, -16712, -19917,
	-22516, -24432, -25604, -26000, -25605, -24432, -22516, -19917,
	-16712, -13000, -8892, -4514, 0, 4514, 8892, 12999,
	16712, 19917, 22516, 24432, 25604, 26000, 25605, 24432,
	22516, 19917, 16712, 13000, 8892, 4514, 0, -4514,
	-8892, -12999, -16712, -19917, -22516, -24431, -25604, -26000,
	-25605, -24432, -22516, -19917, -16712, -13000, -8892, -4514,
	0, 4514, 8892, 12999, 16712, 19917, 22516, 24431,
	25604, 26000, 25605, 24432, 22516, 19917, 16712, 13000,
	8892, 4514, 0, -4514, -8892, -12999, -16712, -19917,
	-22516, -24431, -25604, -26000, -25605, -24432, -22516, -19917,
	-16712, -13000, -8892, -4514, 0, 4514, 8892, 12999,
	16712, 19917, 22516, 24431, 25604, 26000, 25605, 24432,
	22516, 19917, 16712, 13000, 8892, 4514, 0, -4514,
	-8892, -12999, -16712, -19917, -22516, -24431, -25604, -26000,
	-25605, -24432, -22516, -19917, -16712, -13000, -8892, -4514,
	0, 4514, 8892, 12999, 16712, 19917, 22516, 24431,
	25604, 26000, 25605, 24432, 22516, 19917, 16712, 13000,
	8892, 4514, 0, -4514, -8892, -12999, -16712, -19917,
	-22516, -24431, -25604, -26000, -25605, -24432, -22516, -19917,
	-16712, -13000, -8892, -4514, 0, 4514, 8892, 12999,
	16712, 19917, 22516, 24431, 25604, 26000, 25605, 24432,
	22516, 19917, 16712, 13000, 8892, 4514, 0, -4514,
	-8892, -12999, -16712, -19917, -22516, -24431, -25604, -26000,
	-25605, -24432, -22516, -19917, -16712, -13000, -8892, -4514},
	{
// Carrier 0 Phase 1
	9949, 13969, 17565, 20627, 23062, 24796, 25777, 25975,
	25383, 24020, 21928, 19169, 15827, 12005, 7818, 3393,
	-1134, -5627, -9949, -13969, -17565, -20627, -23062, -24796,
	-25777, -25975, -25383, -24020, -21928, -19169, -15827, -12005,
	-7818, -3393, 1134, 5627, 9949, 13969, 17565, 20627,
	23062, 24796, 25777, 25975, 25383, 24020, 21928, 19169,
	15827, 12005, 7818, 3393, -1134, -5627, -9949, -13969,
	-17565, -20627, -23062, -24796, -25777, -25975, -25383, -24020,
	-21928, -19169, -15827, -12005, -7818, -3393, 1134, 5627,
	9949, 13969, 17565, 20627, 23062, 24796, 25777, 25975,
	25383, 24020, 21928, 19169, 15827, 12005, 7818, 3393,
	-1134, -5627, -9949, -13969, -17565, -20627, -23062, -24796,
	-25777, -25975, -25383, -24020, -21928, -19169, -15827, -12005,
	-7818, -3393, 1134, 5627, 9949, 13969, 17565, 20627,
	23062, 24796, 25777, 25975, 25383, 24020, 21928, 19169,
	15827, 12005, 7818, 3393, -1134, -5627, -9949, -13969,
	-17565, -20627, -23062, -24796, -25777, -25975, -25383, -24020,
	-21928, -19169, -15827, -12005, -7818, -3393, 1134, 5627,
	9949, 13969, 17565, 20627, 23062, 24796, 25777, 25975,
	25383, 24020, 21928, 19169, 15827, 12005, 7818, 3393,
	-1134, -5627, -9949, -13969, -17565, -20627, -23062, -24796,
	-25777, -25975, -25383, -24020, -21928, -19169, -15827, -12005,
	-7818, -3393, 1134, 5627, 9949, 13969, 17565, 20627,
	23062, 24796, 25777, 25975, 25383, 24020, 21928, 19169,
	15827, 12005, 7818, 3393, -1134, -5627, -9949, -13969,
	-17565, -20627, -23062, -24796, -25777, -25975, -25383, -24020,
	-21928, -19169, -15827, -12005, -7818, -3393, 1134, 5627},
	{
// Carrier 0 Phase 2
	18384, 21297, 23564, 25114, 25901, 25901, 25114, 23564,
	21297, 18384, 14912, 10988, 6729, 2266, -2266, -6729,
	-10988, -14912, -18384, -21297, -23563, -25114, -25901, -25901,
	-25114, -23564, -21297, -18384, -14913, -10988, -6729, -2266,
	2266, 6729, 10988, 14912, 18384, 21297, 23563, 25114,
	25901, 25901, 25114, 23564, 21297, 18384, 14913, 10988,
	6729, 2266, -2266, -6729, -10988, -14912, -18384, -21297,
	-23563, -25114, -25901, -25901, -25114, -23564, -21297, -18384,
	-14913, -10988, -6729, -2266, 2266, 6729, 10988, 14912,
	18384, 21297, 23563, 25114, 25901, 25901, 25114, 23564,
	21297, 18384, 14913, 10988, 6729, 2266, -2265, -6729,
	-10988, -14912, -18384, -21297, -23563, -25114, -25901, -25901,
	-25114, -23564, -21297, -18384, -14913, -10988, -6729, -2266,
	2265, 6729, 10988, 14912, 18384, 21297, 23563, 25114,
	25901, 25901, 25114, 23564, 21297, 18384, 14913, 10988,
	6729, 2266, -2265, -6729, -10988, -14912, -18384, -21297,
	-23563, -25114, -25901, -25901, -25114, -23564, -21298, -18384,
	-14913, -10988, -6729, -2266, 2265, 6729, 10987, 14912,
	18384, 21297, 23563, 25114, 25901, 25901, 25114, 23564,
	21298, 18384, 14913, 10988, 6729, 2266, -2265, -6729,
	-10987, -14912, -18384, -21297, -23563, -25114, -25901, -25901,
	-25114, -23564, -21298, -18384, -14913, -10988, -6729, -2266,
	2265, 6729, 10987, 14912, 18384, 21297, 23563, 25114,
	25901, 25901, 25114, 23564, 21298, 18384, 14913, 10988,
	6729, 2266, -2265, -6729, -10987, -14912, -18384, -21297,
	-23563, -25114, -25901, -25901, -25114, -23564, -21298, -18384,
	-14913, -10988, -6729, -2266, 2265, 6729, 10987, 14912},
	{
// Carrier 0 Phase 3
	24020, 25383, 25975, 25777, 24796, 23062, 20627, 17565,
	13969, 9949, 5627, 1134, -3393, -7818, -12005, -15827,
	-19169, -21928, -24020, -25383, -25975, -25777, -24796, -23062,
	-20627, -17565, -13969, -9949, -5627, -1134, 3393, 7818,
	12005, 15827, 19169, 21928, 24020, 25383, 25975, 25777,
	24796, 23062, 20627, 17565, 13969, 9949, 5627, 1134,
	-3393, -7818, -12005, -15827, -19169, -21928, -24020, -25383,
	-25975, -25777, -24796, -23062, -20627, -17565, -13969, -9949,
	-5627, -1134, 3393, 7818, 12005, 15827, 19169, 21928,
	24020, 25383, 25975, 25777, 24796, 23062, 20627, 17565,
	13969, 9949, 5627, 1134, -3393, -7818, -12005, -15827,
	-19169, -21928, -24020, -25383, -25975, -25777, -24796, -23062,
	-20627, -17565, -13969, -9949, -5627, -1134, 3393, 7818,
	12005, 15827, 19169, 21928, 24020, 25383, 25975, 25777,
	24796, 23062, 20627, 17565, 13969, 9949, 5627, 1134,
	-3393, -7818, -12005, -15827, -19169, -21928, -24020, -25383,
	-25975, -25777, -24796, -23062, -20627, -17565, -13969, -9949,
	-5627, -1134, 3393, 7818, 12005, 15827, 19169, 21928,
	24020, 25383, 25975, 25777, 24796, 23062, 20627, 17565,
	13969, 9949, 5627, 1134, -3393, -7818, -12005, -15827,
	-19169, -21928, -24020, -25383, -25975, -25777, -24796, -23062,
	-20627, -17565, -13969, -9949, -5627, -1134, 3393, 7818,
	12005, 15827, 19169, 21928, 24020, 25383, 25975, 25777,
	24796, 23062, 20627, 17565, 13969, 9949, 5627, 1134,
	-3393, -7818, -12005, -15827, -19169, -21928, -24020, -25383,
	-25975, -25777, -24796, -23062, -20627, -17565, -13969, -9949,
	-5627, -1134, 3393, 7818, 12005, 15827, 19169, 21928},
	{
// Carrier 0 Phase 4
	26000, 25605, 24432, 22516, 19917, 16712, 13000, 8892,
	4514, 0, -4514, -8892, -12999, -16712, -19917, -22516,
	-24432, -25604, -26000, -25605, -24432, -22516, -19917, -16712,
	-13000, -8892, -4514, 0, 4514, 8892, 12999, 16712,
	19917, 22516, 24432, 25604, 26000, 25605, 24432, 22516,
	19917, 16712, 13000, 8892, 4514, 0, -4514, -8892,
	-12999, -16712, -19917, -22516, -24431, -25604, -26000, -25605,
	-24432, -22516, -19917, -16712, -13000, -8892, -4514, 0,
	4514, 8892, 12999, 16712, 19917, 22516, 24431, 25604,
	26000, 25605, 24432, 22516, 19917, 16712, 13000, 8892,
	4514, 0, -4514, -8892, -12999, -16712, -19917, -22516,
	-24431, -25604, -26000, -25605, -24432, -22516, -19917, -16712,
	-13000, -8892, -4514, 0, 4514, 8892, 12999, 16712,
	19917, 22516, 24431, 25604, 26000, 25605, 24432, 22516,
	19917, 16712, 13000, 8892, 4514, 0, -4514, -8892,
	-12999, -16712, -19917, -22516, -24431, -25604, -26000, -25605,
	-24432, -22516, -19917, -16712, -13000, -8892, -4514, 0,
	4514, 8892, 12999, 16712, 19917, 22516, 24431, 25604,
	26000, 25605, 24432, 22516, 19917, 16712, 13000, 8892,
	4514, 0, -4514, -8892, -12999, -16712, -19917, -22516,
	-24431, -25604, -26000, -25605, -24432, -22516, -19917, -16712,
	-13000, -8892, -4514, 0, 4514, 8892, 12999, 16712,
	19917, 22516, 24431, 25604, 26000, 25605, 24432, 22516,
	19917, 16712, 13000, 8892, 4514, 0, -4514, -8892,
	-12999, -16712, -19917, -22516, -24431, -25604, -26000, -25605,
	-24432, -22516, -19917, -16712, -13000, -8892, -4514, 0,
	4514, 8892, 12999, 16712, 19917, 22516, 24431, 25604},
	{
// Carrier 0 Phase 5
	24020, 21928, 19169, 15827, 12005, 7818, 3393, -1134,
	-5627, -9949, -13969, -17565, -20627, -23062, -24796, -25777,
	-25975, -25383, -24020, -21928, -19169, -15827, -12005, -7818,
	-3393, 1134, 5627, 9949, 13969, 17565, 20627, 23062,
	24796, 25777, 25975, 25383, 24020, 21928, 19169, 15827,
	12005, 7818, 3393, -1134, -5627, -9949, -13969, -17565,
	-20627, -23062, -24796, -25777, -25975, -25383, -24020, -21928,
	-19169, -15827, -12005, -7818, -3393, 1134, 5627, 9949,
	13969, 17565, 20627, 23062, 24796, 25777, 25975, 25383,
	24020, 21928, 19169, 15827, 12005, 7818, 3393, -1134,
	-5627, -9949, -13969, -17565, -20627, -23062, -24796, -25777,
	-25975, -25383, -24020, -21928, -19169, -15827, -12005, -7818,
	-3393, 1134, 5627, 9949, 13969, 17565, 20627, 23062,
	24796, 25777, 25975, 25383, 24020, 21928, 19169, 15827,
	12005, 7818, 3393, -1134, -5627, -9949, -13969, -17565,
	-20627, -23062, -24796, -25777, -25975, -25383, -24020, -21928,
	-19169, -15827, -12005, -7818, -3393, 1134, 5627, 9949,
	13969, 17565, 20627, 23062, 24796, 25777, 25975, 25383,
	24020, 21928, 19169, 15827, 12005, 7818, 3393, -1134,
	-5627, -9949, -13969, -17565, -20627, -23062, -24796, -25777,
	-25975, -25383, -24020, -21928, -19169, -15827, -12005, -7818,
	-3393, 1134, 5627, 9949, 13969, 17565, 20627, 23062,
	24796, 25777, 25975, 25383, 24020, 21928, 19169, 15827,
	12005, 7818, 3393, -1134, -5627, -9949, -13969, -17565,
	-20627, -23062, -24796, -25777, -25975, -25383, -24020, -21928,
	-19169, -15827, -12005, -7818, -3393, 1134, 5627, 9949,
	13969, 17565, 20627, 23062, 24796, 25777, 25975, 25383},
	{
// Carrier 0 Phase 6
	18384, 14912, 10988, 6729, 2266, -2266, -6729, -10988,
	-14912, -18384, -21297, -23563, -25114, -25901, -25901, -25114,
	-23564, -21297, -18384, -14913, -10988, -6729, -2266, 2266,
	6729, 10988, 14912, 18384, 21297, 23563, 25114, 25901,
	25901, 25114, 23564, 21297, 18384, 14913, 10988, 6729,
	2266, -2266, -6729, -10988, -14912, -18384, -21297, -23563,
	-25114, -25901, -25901, -25114, -23564, -21297, -18384, -14913,
	-10988, -6729, -2266, 2266, 6729, 10988, 14912, 18384,
	21297, 23563, 25114, 25901, 25901, 25114, 23564, 21297,
	18384, 14913, 10988, 6729, 2266, -2265, -6729, -10988,
	-14912, -18384, -21297, -23563, -25114, -25901, -25901, -25114,
	-23564, -21297, -18384, -14913, -10988, -6729, -2266, 2265,
	6729, 10988, 14912, 18384, 21297, 23563, 25114, 25901,
	25901, 25114, 23564, 21297, 18384, 14913, 10988, 6729,
	2266, -2265, -6729, -10988, -14912, -18384, -21297, -23563,
	-25114, -25901, -25901, -25114, -23564, -21298, -18384, -14913,
	-10988, -6729, -2266, 2265, 6729, 10987, 14912, 18384,
	21297, 23563, 25114, 25901, 25901, 25114, 23564, 21298,
	18384, 14913, 10988, 6729, 2266, -2265, -6729, -10987,
	-14912, -18384, -21297, -23563, -25114, -25901, -25901, -25114,
	-23564, -21298, -18384, -14913, -10988, -6729, -2266, 2265,
	6729, 10987, 14912, 18384, 21297, 23563, 25114, 25901,
	25901, 25114, 23564, 21298, 18384, 14913, 10988, 6729,
	2266, -2265, -6729, -10987, -14912, -18384, -21297, -23563,
	-25114, -25901, -25901, -25114, -23564, -21298, -18384, -14913,
	-10988, -6729, -2266, 2265, 6729, 10987, 14912, 18384,
	21297, 23563, 25114, 25901, 25901, 25114, 23564, 21298},
	{
// Carrier 0 Phase 7
	9949, 5627, 1134, -3393, -7818, -12005, -15827, -19169,
	-21928, -24020, -25383, -25975, -25777, -24796, -23062, -20627,
	-17565, -13969, -9949, -5627, -1134, 3393, 7818, 12005,
	15827, 19169, 21928, 24020, 25383, 25975, 25777, 24796,
	23062, 20627, 17565, 13969, 9949, 5627, 1134, -3393,
	-7818, -12005, -15827, -19169, -21928, -24020, -25383, -25975,
	-25777, -24796, -23062, -20627, -17565, -13969, -9949, -5627,
	-1134, 3393, 7818, 12005, 15827, 19169, 21928, 24020,
	25383, 25975, 25777, 24796, 23062, 20627, 17565, 13969,
	9949, 5627, 1134, -3393, -7818, -12005, -15827, -19169,
	-21928, -24020, -25383, -25975, -25777, -24796, -23062, -20627,
	-17565, -13969, -9949, -5627, -1134, 3393, 7818, 12005,
	15827, 19169, 21928, 24020, 25383, 25975, 25777, 24796,
	23062, 20627, 17565, 13969, 9949, 5627, 1134, -3393,
	-7818, -12005, -15827, -19169, -21928, -24020, -25383, -25975,
	-25777, -24796, -23062, -20627, -17565, -13969, -9949, -5627,
	-1134, 3393, 7818, 12005, 15827, 19169, 21928, 24020,
	25383, 25975, 25777, 24796, 23062, 20627, 17565, 13969,
	9949, 5627, 1134, -3393, -7818, -12005, -15827, -19169,
	-21928, -24020, -25383, -25975, -25777, -24796, -23062, -20627,
	-17565, -13969, -9949, -5627, -1134, 3393, 7818, 12005,
	15827, 19169, 21928, 24020, 25383, 25975, 25777, 24796,
	23062, 20627, 17565, 13969, 9949, 5627, 1134, -3393,
	-7818, -12005, -15827, -19169, -21928, -24020, -25383, -25975,
	-25777, -24796, -23062, -20627, -17565, -13969, -9949, -5627,
	-1134, 3393, 7818, 12005, 15827, 19169, 21928, 24020,
	25383, 25975, 25777, 24796, 23062, 20627, 17565, 13969},
	},{{

// Carrier 1 Phase 0
	0, 5257, 10298, 14912, 18911, 22129, 24432, 25725,
	25956, 25114, 23234, 20394, 16712, 12339, 7456, 2266,
	-3018, -8178, -12999, -17284, -20855, -23563, -25299, -25989,
	-25605, -24163, -21722, -18384, -14287, -9599, -4514, 756,
	5996, 10988, 15526, 19422, 22516, 24680, 25824, 25901,
	24907, 22885, 19917, 16126, 11668, 6729, 1511, -3768,
	-8892, -13649, -17842, -21297, -23873, -25462, -26000, -25462,
	-23873, -21297, -17842, -13649, -8892, -3768, 1511, 6729,
	11668, 16126, 19917, 22885, 24907, 25901, 25824, 24680,
	22516, 19422, 15526, 10988, 5996, 756, -4514, -9599,
	-14287, -18384, -21722, -24163, -25604, -25989, -25299, -23564,
	-20855, -17284, -13000, -8178, -3018, 2266, 7456, 12339,
	16712, 20394, 23234, 25114, 25956, 25725, 24432, 22129,
	18911, 14912, 10298, 5257, 0, -5257, -10298, -14912,
	-18911, -22129, -24432, -25725, -25956, -25114, -23234, -20394,
	-16712, -12339, -7456, -2266, 3018, 8178, 13000, 17284,
	20855, 23564, 25299, 25989, 25604, 24163, 21722, 18384,
	14287, 9599, 4514, -756, -5996, -10988, -15526, -19422,
	-22516, -24680, -25824, -25901, -24907, -22885, -19917, -16126,
	-11668, -6729, -1511, 3768, 8892, 13649, 17842, 21297,
	23873, 25462, 26000, 25462, 23873, 21297, 17842, 13649,
	8892, 3768, -1511, -6729, -11668, -16126, -19917, -22885,
	-24907, -25901, -25824, -24680, -22516, -19422, -15526, -10988,
	-5995, -756, 4514, 9599, 14287, 18384, 21722, 24163,
	25605, 25989, 25299, 23563, 20855, 17284, 12999, 8178,
	3018, -2266, -7456, -12339, -16712, -20394, -23234, -25114,
	-25956, -25725, -24432, -22129, -18911, -14912, -10298, -5257},
	{
// Carrier 1 Phase 1
	9949, 14601, 18650, 21928, 24300, 25667, 25975, 25209,
	23401, 20627, 17000, 12671, 7818, 2642, -2642, -7818,
	-12671, -17000, -20627, -23401, -25209, -25975, -25667, -24300,
	-21928, -18650, -14601, -9949, -4886, 378, 5627, 10644,
	15221, 19169, 22325, 24558, 25777, 25931, 25013, 23062,
	20158, 16421, 12005, 7093, 1889, -3393, -8536, -13326,
	-17565, -21078, -23721, -25383, -25997, -25536, -24020, -21512,
	-18115, -13969, -9246, -4141, 1134, 6363, 11329, 15827,
	19671, 22703, 24796, 25865, 25865, 24796, 22703, 19671,
	15827, 11329, 6363, 1134, -4141, -9246, -13969, -18115,
	-21512, -24020, -25536, -25997, -25383, -23721, -21078, -17565,
	-13326, -8536, -3393, 1889, 7093, 12005, 16421, 20158,
	23062, 25013, 25931, 25777, 24558, 22325, 19169, 15221,
	10644, 5627, 378, -4886, -9949, -14601, -18650, -21928,
	-24300, -25667, -25975, -25209, -23401, -20627, -17000, -12671,
	-7818, -2642, 2642, 7818, 12671, 17000, 20627, 23401,
	25209, 25975, 25667, 24300, 21928, 18650, 14601, 9949,
	4886, -378, -5627, -10644, -15221, -19169, -22325, -24558,
	-25777, -25931, -25013, -23062, -20158, -16421, -12005, -7093,
	-1889, 3393, 8536, 13326, 17565, 21078, 23721, 25383,
	25997, 25536, 24020, 21512, 18115, 13969, 9246, 4141,
	-1134, -6363, -11329, -15827, -19671, -22703, -24796, -25865,
	-25865, -24796, -22703, -19671, -15827, -11329, -6363, -1134,
	4142, 9246, 13969, 18115, 21512, 24020, 25536, 25997,
	25383, 23721, 21078, 17565, 13326, 8536, 3393, -1889,
	-7093, -12005, -16421, -20158, -23062, -25013, -25931, -25777,
	-24558, -22325, -19169, -15221, -10644, -5627, -378, 4886},
	{
// Carrier 1 Phase 2
	18384, 21722, 24163, 25605, 25989, 25299, 23564, 20855,
	17284, 13000, 8178, 3018, -2266, -7456, -12339, -16712,
	-20394, -23234, -25114, -25956, -25725, -24432, -22129, -18911,
	-14912, -10298, -5257, 0, 5257, 10298, 14912, 18911,
	22129, 24432, 25725, 25956, 25114, 23234, 20394, 16712,
	12339, 7456, 2266, -3018, -8178, -12999, -17284, -20855,
	-23563, -25299, -25989, -25605, -24163, -21722, -18384, -14287,
	-9599, -4514, 756, 5996, 10988, 15526, 19422, 22516,
	24680, 25824, 25901, 24907, 22885, 19917, 16126, 11668,
	6729, 1511, -3768, -8892, -13649, -17842, -21297, -23873,
	-25462, -26000, -25462, -23873, -21297, -17842, -13649, -8892,
	-3768, 1511, 6729, 11668, 16126, 19917, 22885, 24907,
	25901, 25824, 24680, 22516, 19422, 15526, 10988, 5996,
	756, -4514, -9599, -14287, -18384, -21722, -24163, -25604,
	-25989, -25299, -23564, -20855, -17284, -12999, -8178, -3018,
	2266, 7456, 12339, 16712, 20394, 23234, 25114, 25956,
	25725, 24432, 22129, 18911, 14912, 10298, 5257, 0,
	-5257, -10298, -14912, -18911, -22129, -24432, -25725, -25956,
	-25114, -23234, -20394, -16712, -12339, -7456, -2266, 3018,
	8178, 13000, 17284, 20855, 23564, 25299, 25989, 25604,
	24163, 21722, 18384, 14287, 9599, 4514, -756, -5996,
	-10988, -15526, -19422, -22516, -24680, -25824, -25901, -24907,
	-22885, -19917, -16126, -11668, -6729, -1511, 3768, 8892,
	13649, 17842, 21297, 23873, 25462, 26000, 25462, 23873,
	21297, 17842, 13649, 8892, 3768, -1511, -6729, -11668,
	-16126, -19917, -22885, -24907, -25901, -25824, -24680, -22516,
	-19422, -15526, -10988, -5995, -756, 4514, 9599, 14287},
	{
// Carrier 1 Phase 3
	24020, 25536, 25997, 25383, 23721, 21078, 17565, 13326,
	8536, 3393, -1889, -7093, -12005, -16421, -20158, -23062,
	-25013, -25931, -25777, -24558, -22325, -19169, -15221, -10644,
	-5627, -378, 4886, 9949, 14601, 18650, 21928, 24300,
	25667, 25975, 25209, 23401, 20627, 17000, 12671, 7818,
	2642, -2642, -7818, -12671, -17000, -20627, -23401, -25209,
	-25975, -25667, -24300, -21928, -18650, -14601, -9949, -4886,
	378, 5627, 10644, 15221, 19169, 22325, 24558, 25777,
	25931, 25013, 23062, 20158, 16421, 12005, 7093, 1889,
	-3393, -8536, -13326, -17565, -21078, -23721, -25383, -25997,
	-25536, -24020, -21512, -18115, -13969, -9246, -4141, 1134,
	6363, 11329, 15827, 19672, 22703, 24796, 25865, 25865,
	24796, 22703, 19671, 15827, 11329, 6363, 1134, -4141,
	-9246, -13969, -18115, -21512, -24020, -25536, -25997, -25383,
	-23721, -21078, -17565, -13326, -8536, -3393, 1889, 7093,
	12005, 16421, 20158, 23062, 25013, 25931, 25777, 24558,
	22325, 19169, 15221, 10644, 5627, 378, -4886, -9949,
	-14601, -18650, -21928, -24300, -25667, -25975, -25209, -23401,
	-20627, -17000, -12671, -7818, -2642, 2642, 7818, 12671,
	17000, 20627, 23401, 25209, 25975, 25667, 24300, 21928,
	18650, 14601, 9949, 4886, -378, -5627, -10644, -15221,
	-19169, -22325, -24558, -25777, -25931, -25013, -23062, -20158,
	-16421, -12005, -7093, -1889, 3393, 8536, 13326, 17565,
	21078, 23721, 25383, 25997, 25536, 24020, 21512, 18115,
	13969, 9246, 4141, -1134, -6363, -11329, -15827, -19671,
	-22703, -24796, -25865, -25865, -24796, -22703, -19671, -15827,
	-11329, -6363, -1134, 4142, 9246, 13969, 18115, 21512},
	{
// Carrier 1 Phase 4
	26000, 25462, 23873, 21297, 17842, 13649, 8892, 3768,
	-1511, -6729, -11668, -16126, -19917, -22885, -24907, -25901,
	-25824, -24680, -22516, -19422, -15526, -10988, -5996, -756,
	4514, 9599, 14287, 18384, 21722, 24163, 25605, 25989,
	25299, 23563, 20855, 17284, 13000, 8178, 3018, -2266,
	-7456, -12339, -16712, -20394, -23234, -25114, -25956, -25725,
	-24432, -22129, -18911, -14912, -10298, -5257, 0, 5257,
	10298, 14913, 18911, 22129, 24432, 25725, 25956, 25114,
	23234, 20394, 16712, 12339, 7456, 2266, -3018, -8178,
	-12999, -17284, -20855, -23563, -25299, -25989, -25605, -24163,
	-21722, -18384, -14287, -9599, -4514, 756, 5996, 10988,
	15526, 19422, 22516, 24680, 25824, 25901, 24907, 22885,
	19917, 16126, 11668, 6729, 1511, -3768, -8892, -13649,
	-17842, -21297, -23873, -25462, -26000, -25462, -23873, -21297,
	-17842, -13649, -8892, -3768, 1511, 6729, 11668, 16126,
	19917, 22885, 24907, 25901, 25824, 24680, 22516, 19422,
	15526, 10988, 5995, 756, -4514, -9599, -14287, -18384,
	-21722, -24163, -25605, -25989, -25299, -23563, -20855, -17284,
	-12999, -8178, -3018, 2266, 7456, 12339, 16712, 20394,
	23234, 25114, 25956, 25725, 24431, 22129, 18911, 14912,
	10298, 5257, 0, -5257, -10298, -14912, -18911, -22129,
	-24432, -25725, -25956, -25114, -23234, -20394, -16712, -12339,
	-7456, -2266, 3018, 8178, 13000, 17284, 20855, 23564,
	25299, 25989, 25604, 24163, 21722, 18384, 14287, 9599,
	4514, -756, -5996, -10988, -15526, -19422, -22516, -24680,
	-25824, -25901, -24907, -22885, -19917, -16126, -11668, -6729,
	-1511, 3768, 8892, 13649, 17842, 21297, 23873, 25462},
	{
// Carrier 1 Phase 5
	24020, 21512, 18115, 13969, 9246, 4141, -1134, -6363,
	-11329, -15827, -19671, -22703, -24796, -25865, -25865, -24796,
	-22703, -19671, -15827, -11329, -6363, -1134, 4141, 9246,
	13969, 18115, 21512, 24020, 25536, 25997, 25383, 23721,
	21078, 17565, 13326, 8536, 3393, -1889, -7093, -12005,
	-16421, -20158, -23062, -25013, -25931, -25777, -24558, -22325,
	-19169, -15221, -10644, -5627, -378, 4886, 9949, 14601,
	18650, 21928, 24300, 25667, 25975, 25209, 23401, 20627,
	17000, 12671, 7818, 2642, -2642, -7818, -12671, -17000,
	-20627, -23401, -25209, -25975, -25667, -24300, -21928, -18650,
	-14601, -9949, -4886, 378, 5627, 10644, 15221, 19169,
	22325, 24558, 25777, 25931, 25013, 23062, 20158, 16421,
	12005, 7093, 1889, -3393, -8536, -13326, -17565, -21078,
	-23721, -25383, -25997, -25536, -24020, -21512, -18115, -13969,
	-9246, -4141, 1134, 6363, 11329, 15827, 19672, 22703,
	24796, 25865, 25865, 24796, 22703, 19671, 15827, 11329,
	6363, 1134, -4141, -9246, -13969, -18115, -21512, -24020,
	-25536, -25997, -25383, -23721, -21078, -17565, -13326, -8536,
	-3393, 1889, 7093, 12005, 16421, 20158, 23062, 25013,
	25931, 25777, 24558, 22325, 19169, 15221, 10644, 5627,
	378, -4886, -9949, -14601, -18650, -21928, -24300, -25667,
	-25975, -25209, -23401, -20627, -17000, -12671, -7818, -2642,
	2642, 7818, 12671, 17000, 20627, 23401, 25209, 25975,
	25667, 24300, 21928, 18650, 14601, 9949, 4886, -378,
	-5627, -10644, -15221, -19169, -22325, -24558, -25777, -25931,
	-25013, -23062, -20158, -16421, -12005, -7093, -1889, 3393,
	8536, 13326, 17565, 21078, 23721, 25383, 25997, 25536},
	{
// Carrier 1 Phase 6
	18384, 14287, 9599, 4514, -756, -5995, -10988, -15526,
	-19422, -22516, -24680, -25824, -25901, -24907, -22885, -19917,
	-16126, -11668, -6729, -1511, 3768, 8892, 13649, 17842,
	21297, 23873, 25462, 26000, 25462, 23873, 21297, 17842,
	13649, 8892, 3768, -1511, -6729, -11668, -16126, -19917,
	-22885, -24907, -25901, -25824, -24680, -22516, -19422, -15526,
	-10988, -5995, -756, 4514, 9599, 14287, 18384, 21722,
	24163, 25605, 25989, 25299, 23563, 20855, 17284, 12999,
	8178, 3018, -2266, -7456, -12339, -16712, -20394, -23234,
	-25114, -25956, -25725, -24432, -22129, -18911, -14912, -10298,
	-5257, 0, 5257, 10298, 14913, 18911, 22129, 24432,
	25725, 25956, 25114, 23234, 20394, 16712, 12339, 7456,
	2266, -3018, -8178, -13000, -17284, -20855, -23564, -25299,
	-25989, -25604, -24163, -21722, -18384, -14287, -9599, -4514,
	756, 5996, 10988, 15526, 19422, 22516, 24680, 25824,
	25901, 24907, 22885, 19917, 16126, 11668, 6729, 1511,
	-3768, -8892, -13649, -17842, -21297, -23873, -25462, -26000,
	-25462, -23873, -21297, -17842, -13649, -8892, -3768, 1511,
	6729, 11668, 16126, 19917, 22885, 24907, 25901, 25824,
	24680, 22516, 19422, 15526, 10988, 5995, 756, -4514,
	-9599, -14287, -18384, -21722, -24163, -25605, -25989, -25299,
	-23563, -20855, -17284, -12999, -8178, -3018, 2266, 7456,
	12339, 16712, 20394, 23234, 25114, 25956, 25725, 24431,
	22129, 18911, 14912, 10298, 5257, 0, -5257, -10298,
	-14913, -18911, -22129, -24432, -25725, -25956, -25114, -23234,
	-20394, -16712, -12339, -7456, -2265, 3018, 8178, 13000,
	17284, 20855, 23564, 25299, 25989, 25604, 24163, 21722},
	{
// Carrier 1 Phase 7
	9949, 4886, -378, -5627, -10644, -15221, -19169, -22325,
	-24558, -25777, -25931, -25013, -23062, -20158, -16421, -12005,
	-7093, -1889, 3393, 8536, 13326, 17565, 21078, 23721,
	25383, 25997, 25536, 24020, 21512, 18115, 13969, 9246,
	4141, -1134, -6363, -11329, -15827, -19671, -22703, -24796,
	-25865, -25865, -24796, -22703, -19671, -15827, -11329, -6363,
	-1134, 4142, 9246, 13969, 18115, 21512, 24020, 25536,
	25997, 25383, 23721, 21078, 17565, 13326, 8536, 3393,
	-1889, -7093, -12005, -16421, -20158, -23062, -25013, -25931,
	-25777, -24558, -22325, -19169, -15221, -10644, -5627, -378,
	4886, 9949, 14601, 18650, 21928, 24300, 25667, 25975,
	25209, 23401, 20627, 17000, 12671, 7818, 2642, -2642,
	-7818, -12671, -17000, -20627, -23401, -25209, -25975, -25667,
	-24300, -21928, -18650, -14601, -9949, -4886, 378, 5627,
	10644, 15221, 19169, 22325, 24558, 25777, 25931, 25013,
	23062, 20158, 16421, 12005, 7093, 1889, -3393, -8536,
	-13326, -17565, -21078, -23721, -25383, -25997, -25536, -24020,
	-21512, -18115, -13969, -9246, -4141, 1134, 6363, 11329,
	15827, 19672, 22703, 24796, 25865, 25865, 24796, 22703,
	19671, 15827, 11329, 6363, 1134, -4142, -9246, -13969,
	-18115, -21512, -24020, -25536, -25997, -25383, -23721, -21078,
	-17565, -13326, -8536, -3393, 1889, 7093, 12005, 16421,
	20158, 23062, 25013, 25931, 25777, 24558, 22325, 19169,
	15221, 10644, 5627, 378, -4886, -9949, -14601, -18650,
	-21928, -24300, -25667, -25975, -25209, -23401, -20627, -17000,
	-12671, -7818, -2642, 2642, 7818, 12671, 17000, 20627,
	23401, 25209, 25975, 25667, 24300, 21928, 18650, 14601},
	},{{

// Carrier 2 Phase 0
	0, 5996, 11668, 16712, 20855, 23873, 25605, 25956,
	24907, 22516, 18911, 14287, 8892, 3018, -3018, -8892,
	-14287, -18911, -22516, -24907, -25956, -25605, -23873, -20855,
	-16712, -11668, -5996, 0, 5995, 11668, 16712, 20855,
	23873, 25604, 25956, 24907, 22516, 18911, 14287, 8892,
	3018, -3018, -8892, -14287, -18911, -22516, -24907, -25956,
	-25605, -23873, -20855, -16712, -11668, -5996, 0, 5995,
	11668, 16712, 20855, 23873, 25604, 25956, 24907, 22516,
	18911, 14287, 8892, 3018, -3018, -8892, -14287, -18911,
	-22516, -24907, -25956, -25605, -23873, -20855, -16712, -11668,
	-5996, 0, 5995, 11668, 16712, 20855, 23873, 25604,
	25956, 24907, 22516, 18911, 14287, 8892, 3018, -3018,
	-8892, -14287, -18911, -22516, -24907, -25956, -25605, -23873,
	-20855, -16712, -11668, -5996, 0, 5995, 11668, 16712,
	20855, 23873, 25604, 25956, 24907, 22516, 18911, 14287,
	8892, 3018, -3018, -8892, -14287, -18911, -22516, -24907,
	-25955, -25605, -23873, -20855, -16712, -11668, -5996, 0,
	5995, 11668, 16712, 20855, 23873, 25604, 25956, 24907,
	22516, 18911, 14287, 8892, 3018, -3018, -8892, -14287,
	-18911, -22516, -24907, -25955, -25605, -23873, -20855, -16712,
	-11669, -5996, 0, 5995, 11668, 16712, 20855, 23873,
	25604, 25956, 24907, 22516, 18911, 14287, 8892, 3018,
	-3018, -8892, -14286, -18911, -22516, -24907, -25955, -25605,
	-23873, -20855, -16712, -11669, -5996, 0, 5995, 11668,
	16712, 20854, 23873, 25604, 25956, 24907, 22516, 18911,
	14287, 8892, 3018, -3018, -8892, -14286, -18911, -22516,
	-24907, -25955, -25605, -23873, -20855, -16712, -11669, -5996},
	{
// Carrier 2 Phase 1
	9949, 15221, 19671, 23062, 25209, 25997, 25383, 23401,
	20158, 15827, 10644, 4886, -1134, -7093, -12671, -17565,
	-21512, -24300, -25777, -25865, -24558, -21928, -18115, -13326,
	-7818, -1889, 4141, 9949, 15221, 19671, 23062, 25209,
	25997, 25383, 23401, 20158, 15827, 10644, 4886, -1134,
	-7093, -12671, -17565, -21512, -24300, -25777, -25865, -24558,
	-21928, -18115, -13326, -7818, -1889, 4141, 9949, 15221,
	19671, 23062, 25209, 25997, 25383, 23401, 20158, 15827,
	10644, 4886, -1133, -7093, -12671, -17565, -21512, -24300,
	-25777, -25865, -24558, -21928, -18115, -13326, -7818, -1889,
	4141, 9949, 15221, 19671, 23062, 25209, 25997, 25383,
	23401, 20158, 15827, 10644, 4886, -1133, -7093, -12671,
	-17565, -21512, -24300, -25777, -25865, -24558, -21928, -18115,
	-13326, -7818, -1889, 4141, 9949, 15221, 19671, 23062,
	25209, 25997, 25383, 23401, 20158, 15827, 10644, 4886,
	-1133, -7093, -12670, -17565, -21512, -24300, -25777, -25865,
	-24558, -21928, -18115, -13326, -7818, -1889, 4141, 9949,
	15220, 19671, 23062, 25209, 25997, 25383, 23401, 20158,
	15828, 10644, 4887, -1133, -7093, -12670, -17565, -21512,
	-24299, -25777, -25865, -24558, -21928, -18115, -13326, -7818,
	-1889, 4141, 9949, 15220, 19671, 23062, 25209, 25997,
	25383, 23401, 20158, 15828, 10644, 4887, -1133, -7093,
	-12670, -17565, -21512, -24299, -25777, -25865, -24558, -21928,
	-18115, -13326, -7818, -1889, 4141, 9949, 15220, 19671,
	23062, 25209, 25997, 25383, 23401, 20158, 15828, 10644,
	4887, -1133, -7093, -12670, -17565, -21512, -24299, -25777,
	-25865, -24558, -21928, -18115, -13326, -7818, -1889, 4141},
	{
// Carrier 2 Phase 2
	18384, 22129, 24680, 25901, 25725, 24163, 21297, 17284,
	12339, 6729, 756, -5257, -10988, -16126, -20394, -23563,
	-25462, -25989, -25114, -22885, -19422, -14913, -9599, -3768,
	2265, 8178, 13649, 18384, 22129, 24680, 25901, 25725,
	24163, 21297, 17284, 12339, 6729, 756, -5257, -10988,
	-16126, -20394, -23563, -25462, -25989, -25114, -22885, -19422,
	-14913, -9599, -3768, 2265, 8178, 13649, 18384, 22128,
	24680, 25901, 25725, 24163, 21298, 17284, 12339, 6729,
	756, -5257, -10987, -16126, -20394, -23563, -25462, -25989,
	-25114, -22885, -19422, -14913, -9599, -3768, 2265, 8178,
	13649, 18384, 22128, 24680, 25901, 25725, 24163, 21298,
	17284, 12339, 6729, 756, -5257, -10987, -16126, -20394,
	-23563, -25462, -25989, -25114, -22885, -19422, -14913, -9599,
	-3768, 2265, 8177, 13649, 18384, 22128, 24680, 25901,
	25725, 24163, 21298, 17284, 12339, 6729, 756, -5257,
	-10987, -16125, -20394, -23563, -25462, -25989, -25114, -22885,
	-19422, -14913, -9599, -3768, 2265, 8177, 13649, 18384,
	22128, 24680, 25901, 25725, 24163, 21298, 17284, 12339,
	6729, 756, -5257, -10987, -16125, -20394, -23563, -25462,
	-25989, -25114, -22885, -19422, -14913, -9599, -3768, 2265,
	8177, 13649, 18384, 22128, 24680, 25901, 25725, 24163,
	21298, 17284, 12339, 6729, 756, -5257, -10987, -16125,
	-20394, -23563, -25462, -25989, -25114, -22885, -19422, -14913,
	-9599, -3768, 2265, 8177, 13649, 18384, 22128, 24680,
	25901, 25725, 24163, 21298, 17284, 12339, 6729, 756,
	-5257, -10987, -16125, -20394, -23563, -25462, -25989, -25114,
	-22885, -19422, -14913, -9599, -3768, 2265, 8177, 13649},
	{
// Carrier 2 Phase 3
	24020, 25667, 25931, 24796, 22325, 18650, 13969, 8536,
	2642, -3393, -9246, -14601, -19169, -22703, -25013, -25975,
	-25536, -23721, -20627, -16421, -11329, -5627, 378, 6363,
	12005, 17000, 21078, 24020, 25667, 25931, 24796, 22325,
	18650, 13969, 8536, 2642, -3393, -9246, -14601, -19169,
	-22703, -25013, -25975, -25536, -23721, -20627, -16421, -11329,
	-5627, 378, 6363, 12005, 17000, 21078, 24020, 25667,
	25931, 24796, 22325, 18650, 13969, 8536, 2642, -3393,
	-9246, -14601, -19169, -22703, -25013, -25975, -25536, -23721,
	-20627, -16421, -11329, -5627, 377, 6363, 12005, 17000,
	21078, 24020, 25667, 25931, 24796, 22325, 18650, 13969,
	8536, 2642, -3393, -9246, -14601, -19169, -22703, -25013,
	-25975, -25536, -23721, -20627, -16421, -11329, -5627, 377,
	6363, 12005, 17000, 21078, 24020, 25667, 25931, 24796,
	22325, 18650, 13969, 8536, 2642, -3393, -9246, -14601,
	-19169, -22703, -25013, -25975, -25536, -23721, -20627, -16421,
	-11329, -5627, 377, 6363, 12005, 17000, 21078, 24020,
	25667, 25931, 24796, 22325, 18650, 13970, 8536, 2642,
	-3393, -9246, -14601, -19169, -22703, -25013, -25975, -25536,
	-23721, -20627, -16421, -11329, -5627, 377, 6363, 12005,
	17000, 21078, 24020, 25667, 25931, 24796, 22325, 18650,
	13970, 8536, 2642, -3393, -9246, -14601, -19169, -22703,
	-25013, -25975, -25536, -23721, -20627, -16421, -11329, -5627,
	377, 6362, 12005, 17000, 21078, 24020, 25667, 25931,
	24796, 22325, 18650, 13970, 8536, 2642, -3393, -9246,
	-14601, -19168, -22703, -25013, -25975, -25536, -23721, -20627,
	-16421, -11329, -5627, 377, 6362, 12005, 17000, 21078},
	{
// Carrier 2 Phase 4
	26000, 25299, 23234, 19917, 15526, 10298, 4514, -1511,
	-7456, -12999, -17842, -21722, -24432, -25824, -25824, -24432,
	-21722, -17842, -13000, -7456, -1511, 4514, 10298, 15526,
	19917, 23234, 25299, 26000, 25299, 23234, 19917, 15526,
	10298, 4514, -1511, -7456, -12999, -17842, -21722, -24431,
	-25824, -25824, -24432, -21722, -17842, -13000, -7456, -1511,
	4514, 10297, 15526, 19917, 23234, 25299, 26000, 25299,
	23234, 19917, 15526, 10298, 4514, -1511, -7456, -12999,
	-17842, -21722, -24431, -25824, -25824, -24432, -21722, -17842,
	-13000, -7457, -1511, 4514, 10297, 15526, 19917, 23234,
	25299, 26000, 25299, 23234, 19917, 15526, 10298, 4515,
	-1511, -7456, -12999, -17842, -21722, -24431, -25824, -25824,
	-24432, -21722, -17842, -13000, -7457, -1511, 4514, 10297,
	15525, 19917, 23234, 25299, 26000, 25299, 23234, 19917,
	15526, 10298, 4515, -1511, -7456, -12999, -17842, -21722,
	-24431, -25824, -25824, -24432, -21722, -17842, -13000, -7457,
	-1512, 4514, 10297, 15525, 19916, 23234, 25299, 26000,
	25299, 23234, 19917, 15526, 10298, 4515, -1511, -7456,
	-12999, -17842, -21722, -24431, -25824, -25824, -24432, -21722,
	-17842, -13000, -7457, -1512, 4514, 10297, 15525, 19916,
	23234, 25299, 26000, 25299, 23234, 19917, 15526, 10298,
	4515, -1511, -7456, -12999, -17842, -21722, -24431, -25824,
	-25824, -24432, -21722, -17842, -13000, -7457, -1512, 4514,
	10297, 15525, 19916, 23234, 25299, 26000, 25299, 23234,
	19917, 15526, 10298, 4515, -1511, -7456, -12999, -17842,
	-21722, -24431, -25824, -25824, -24432, -21722, -17842, -13000,
	-7457, -1512, 4514, 10297, 15525, 19916, 23234, 25299},
	{
// Carrier 2 Phase 5
	24020, 21078, 17000, 12005, 6363, 378, -5627, -11329,
	-16421, -20627, -23721, -25536, -25975, -25013, -22703, -19169,
	-14601, -9246, -3393, 2642, 8536, 13969, 18650, 22325,
	24796, 25931, 25667, 24020, 21078, 17000, 12005, 6363,
	378, -5627, -11329, -16420, -20627, -23721, -25536, -25975,
	-25013, -22703, -19169, -14601, -9247, -3393, 2642, 8536,
	13969, 18650, 22325, 24796, 25931, 25667, 24020, 21078,
	17000, 12005, 6363, 378, -5627, -11329, -16420, -20627,
	-23721, -25536, -25975, -25013, -22703, -19169, -14601, -9247,
	-3393, 2642, 8536, 13969, 18650, 22325, 24796, 25931,
	25667, 24020, 21078, 17000, 12005, 6363, 378, -5627,
	-11329, -16420, -20627, -23721, -25536, -25975, -25013, -22703,
	-19169, -14601, -9247, -3393, 2642, 8536, 13969, 18650,
	22325, 24796, 25931, 25667, 24020, 21078, 17000, 12005,
	6363, 378, -5627, -11329, -16420, -20627, -23721, -25536,
	-25975, -25013, -22703, -19169, -14601, -9247, -3393, 2642,
	8536, 13969, 18650, 22325, 24796, 25931, 25667, 24020,
	21078, 17000, 12005, 6363, 378, -5627, -11329, -16420,
	-20627, -23721, -25536, -25975, -25013, -22703, -19169, -14601,
	-9247, -3393, 2642, 8535, 13969, 18650, 22325, 24796,
	25931, 25668, 24020, 21078, 17000, 12005, 6363, 378,
	-5627, -11329, -16420, -20627, -23721, -25536, -25975, -25013,
	-22703, -19169, -14601, -9247, -3394, 2642, 8535, 13969,
	18649, 22325, 24796, 25931, 25668, 24021, 21079, 17000,
	12005, 6363, 378, -5627, -11329, -16420, -20626, -23721,
	-25536, -25975, -25013, -22703, -19169, -14601, -9247, -3394,
	2642, 8535, 13969, 18649, 22325, 24796, 25931, 25668},
	{
// Carrier 2 Phase 6
	18384, 13649, 8178, 2266, -3768, -9599, -14912, -19422,
	-22885, -25114, -25989, -25462, -23564, -20394, -16126, -10988,
	-5257, 756, 6729, 12339, 17284, 21297, 24163, 25725,
	25901, 24680, 22129, 18384, 13649, 8178, 2266, -3768,
	-9599, -14912, -19422, -22885, -25114, -25988, -25462, -23564,
	-20394, -16126, -10988, -5257, 756, 6729, 12339, 17284,
	21297, 24163, 25725, 25901, 24680, 22129, 18384, 13649,
	8178, 2266, -3768, -9599, -14912, -19422, -22885, -25114,
	-25988, -25462, -23564, -20394, -16126, -10988, -5257, 756,
	6729, 12339, 17284, 21297, 24162, 25725, 25901, 24680,
	22129, 18384, 13649, 8178, 2266, -3768, -9599, -14912,
	-19422, -22885, -25114, -25988, -25462, -23564, -20394, -16126,
	-10988, -5257, 756, 6729, 12339, 17284, 21297, 24162,
	25725, 25901, 24680, 22129, 18384, 13649, 8178, 2266,
	-3768, -9599, -14912, -19422, -22885, -25114, -25988, -25462,
	-23564, -20394, -16126, -10988, -5257, 755, 6729, 12339,
	17284, 21297, 24162, 25725, 25901, 24680, 22129, 18384,
	13649, 8178, 2266, -3767, -9599, -14912, -19422, -22885,
	-25114, -25988, -25462, -23564, -20394, -16126, -10988, -5257,
	755, 6729, 12339, 17284, 21297, 24162, 25725, 25901,
	24680, 22129, 18384, 13649, 8178, 2266, -3767, -9599,
	-14912, -19422, -22885, -25113, -25988, -25462, -23564, -20395,
	-16126, -10988, -5257, 755, 6728, 12339, 17284, 21297,
	24162, 25725, 25901, 24680, 22129, 18385, 13649, 8178,
	2266, -3767, -9599, -14912, -19422, -22885, -25113, -25988,
	-25462, -23564, -20395, -16126, -10988, -5258, 755, 6728,
	12339, 17284, 21297, 24162, 25725, 25901, 24680, 22129},
	{
// Carrier 2 Phase 7
	9949, 4141, -1889, -7818, -13326, -18115, -21928, -24558,
	-25865, -25777, -24300, -21512, -17565, -12671, -7093, -1134,
	4886, 10644, 15827, 20158, 23401, 25383, 25997, 25209,
	23062, 19672, 15221, 9949, 4142, -1889, -7818, -13326,
	-18115, -21928, -24558, -25865, -25777, -24300, -21512, -17565,
	-12671, -7093, -1134, 4886, 10644, 15827, 20158, 23401,
	25383, 25997, 25209, 23062, 19672, 15221, 9949, 4142,
	-1889, -7818, -13326, -18115, -21928, -24558, -25865, -25777,
	-24300, -21512, -17565, -12671, -7093, -1134, 4886, 10644,
	15827, 20158, 23401, 25383, 25997, 25209, 23062, 19672,
	15221, 9949, 4142, -1888, -7818, -13325, -18115, -21928,
	-24558, -25865, -25777, -24300, -21512, -17565, -12671, -7094,
	-1134, 4886, 10644, 15827, 20157, 23401, 25383, 25997,
	25209, 23062, 19672, 15221, 9949, 4142, -1888, -7818,
	-13325, -18115, -21928, -24558, -25865, -25777, -24300, -21512,
	-17565, -12671, -7094, -1134, 4886, 10643, 15827, 20157,
	23401, 25383, 25997, 25209, 23062, 19672, 15221, 9950,
	4142, -1888, -7818, -13325, -18115, -21928, -24558, -25865,
	-25777, -24300, -21512, -17565, -12671, -7094, -1134, 4886,
	10643, 15827, 20157, 23401, 25383, 25997, 25209, 23062,
	19672, 15221, 9950, 4142, -1888, -7818, -13325, -18115,
	-21928, -24558, -25865, -25777, -24300, -21512, -17565, -12671,
	-7094, -1134, 4886, 10643, 15827, 20157, 23401, 25383,
	25997, 25209, 23062, 19672, 15221, 9950, 4142, -1888,
	-7818, -13325, -18115, -21927, -24558, -25865, -25777, -24300,
	-21512, -17565, -12671, -7094, -1134, 4886, 10643, 15827,
	20157, 23401, 25383, 25997, 25209, 23062, 19672, 15221},
	},{{

// Carrier 3 Phase 0
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729},
	{
// Carrier 3 Phase 1
	9949, 15827, 20627, 24020, 25777, 25777, 24020, 20627,
	15827, 9949, 3393, -3393, -9949, -15827, -20627, -24020,
	-25777, -25777, -24020, -20627, -15827, -9949, -3393, 3393,
	9949, 15827, 20627, 24020, 25777, 25777, 24020, 20627,
	15827, 9949, 3393, -3393, -9949, -15827, -20627, -24020,
	-25777, -25777, -24020, -20627, -15827, -9949, -3393, 3393,
	9949, 15827, 20627, 24020, 25777, 25777, 24020, 20627,
	15827, 9949, 3393, -3393, -9949, -15827, -20627, -24020,
	-25777, -25777, -24020, -20627, -15827, -9949, -3393, 3393,
	9949, 15827, 20627, 24020, 25777, 25777, 24020, 20627,
	15827, 9949, 3393, -3393, -9949, -15827, -20627, -24020,
	-25777, -25777, -24020, -20627, -15827, -9949, -3393, 3393,
	9949, 15827, 20627, 24020, 25777, 25777, 24020, 20627,
	15827, 9949, 3393, -3393, -9949, -15827, -20627, -24020,
	-25777, -25777, -24020, -20627, -15827, -9949, -3393, 3393,
	9949, 15827, 20627, 24020, 25777, 25777, 24020, 20627,
	15827, 9949, 3393, -3393, -9949, -15827, -20627, -24020,
	-25777, -25777, -24020, -20627, -15827, -9949, -3393, 3393,
	9949, 15827, 20627, 24020, 25777, 25777, 24020, 20627,
	15827, 9949, 3393, -3393, -9949, -15827, -20627, -24020,
	-25777, -25777, -24020, -20627, -15827, -9949, -3393, 3393,
	9949, 15827, 20627, 24020, 25777, 25777, 24020, 20627,
	15827, 9949, 3393, -3393, -9949, -15827, -20627, -24020,
	-25777, -25777, -24020, -20627, -15827, -9949, -3393, 3393,
	9949, 15827, 20627, 24020, 25777, 25777, 24020, 20627,
	15827, 9949, 3393, -3393, -9949, -15827, -20627, -24020,
	-25777, -25777, -24020, -20627, -15827, -9949, -3393, 3393},
	{
// Carrier 3 Phase 2
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999},
	{
// Carrier 3 Phase 3
	24020, 25777, 25777, 24020, 20627, 15827, 9949, 3393,
	-3393, -9949, -15827, -20627, -24020, -25777, -25777, -24020,
	-20627, -15827, -9949, -3393, 3393, 9949, 15827, 20627,
	24020, 25777, 25777, 24020, 20627, 15827, 9949, 3393,
	-3393, -9949, -15827, -20627, -24020, -25777, -25777, -24020,
	-20627, -15827, -9949, -3393, 3393, 9949, 15827, 20627,
	24020, 25777, 25777, 24020, 20627, 15827, 9949, 3393,
	-3393, -9949, -15827, -20627, -24020, -25777, -25777, -24020,
	-20627, -15827, -9949, -3393, 3393, 9949, 15827, 20627,
	24020, 25777, 25777, 24020, 20627, 15827, 9949, 3393,
	-3393, -9949, -15827, -20627, -24020, -25777, -25777, -24020,
	-20627, -15827, -9949, -3393, 3393, 9949, 15827, 20627,
	24020, 25777, 25777, 24020, 20627, 15827, 9949, 3393,
	-3393, -9949, -15827, -20627, -24020, -25777, -25777, -24020,
	-20627, -15827, -9949, -3393, 3393, 9949, 15827, 20627,
	24020, 25777, 25777, 24020, 20627, 15827, 9949, 3393,
	-3393, -9949, -15827, -20627, -24020, -25777, -25777, -24020,
	-20627, -15827, -9949, -3393, 3393, 9949, 15827, 20627,
	24020, 25777, 25777, 24020, 20627, 15827, 9949, 3393,
	-3393, -9949, -15827, -20627, -24020, -25777, -25777, -24020,
	-20627, -15827, -9949, -3393, 3393, 9949, 15827, 20627,
	24020, 25777, 25777, 24020, 20627, 15827, 9949, 3393,
	-3393, -9949, -15827, -20627, -24020, -25777, -25777, -24020,
	-20627, -15827, -9949, -3393, 3393, 9949, 15827, 20627,
	24020, 25777, 25777, 24020, 20627, 15827, 9949, 3393,
	-3393, -9949, -15827, -20627, -24020, -25777, -25777, -24020,
	-20627, -15827, -9949, -3393, 3393, 9949, 15827, 20627},
	{
// Carrier 3 Phase 4
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114},
	{
// Carrier 3 Phase 5
	24020, 20627, 15827, 9949, 3393, -3393, -9949, -15827,
	-20627, -24020, -25777, -25777, -24020, -20627, -15827, -9949,
	-3393, 3393, 9949, 15827, 20627, 24020, 25777, 25777,
	24020, 20627, 15827, 9949, 3393, -3393, -9949, -15827,
	-20627, -24020, -25777, -25777, -24020, -20627, -15827, -9949,
	-3393, 3393, 9949, 15827, 20627, 24020, 25777, 25777,
	24020, 20627, 15827, 9949, 3393, -3393, -9949, -15827,
	-20627, -24020, -25777, -25777, -24020, -20627, -15827, -9949,
	-3393, 3393, 9949, 15827, 20627, 24020, 25777, 25777,
	24020, 20627, 15827, 9949, 3393, -3393, -9949, -15827,
	-20627, -24020, -25777, -25777, -24020, -20627, -15827, -9949,
	-3393, 3393, 9949, 15827, 20627, 24020, 25777, 25777,
	24020, 20627, 15827, 9949, 3393, -3393, -9949, -15827,
	-20627, -24020, -25777, -25777, -24020, -20627, -15827, -9949,
	-3393, 3393, 9949, 15827, 20627, 24020, 25777, 25777,
	24020, 20627, 15827, 9949, 3393, -3393, -9949, -15827,
	-20627, -24020, -25777, -25777, -24020, -20627, -15827, -9949,
	-3393, 3393, 9949, 15827, 20627, 24020, 25777, 25777,
	24020, 20627, 15827, 9949, 3393, -3393, -9949, -15827,
	-20627, -24020, -25777, -25777, -24020, -20627, -15827, -9949,
	-3393, 3393, 9949, 15827, 20627, 24020, 25777, 25777,
	24020, 20627, 15827, 9949, 3393, -3393, -9949, -15827,
	-20627, -24020, -25777, -25777, -24020, -20627, -15827, -9949,
	-3393, 3393, 9949, 15827, 20627, 24020, 25777, 25777,
	24020, 20627, 15827, 9949, 3393, -3393, -9949, -15827,
	-20627, -24020, -25777, -25777, -24020, -20627, -15827, -9949,
	-3393, 3393, 9949, 15827, 20627, 24020, 25777, 25777},
	{
// Carrier 3 Phase 6
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516},
	{
// Carrier 3 Phase 7
	9949, 3393, -3393, -9949, -15827, -20627, -24020, -25777,
	-25777, -24020, -20627, -15827, -9949, -3393, 3393, 9949,
	15827, 20627, 24020, 25777, 25777, 24020, 20627, 15827,
	9949, 3393, -3393, -9949, -15827, -20627, -24020, -25777,
	-25777, -24020, -20627, -15827, -9949, -3393, 3393, 9949,
	15827, 20627, 24020, 25777, 25777, 24020, 20627, 15827,
	9949, 3393, -3393, -9949, -15827, -20627, -24020, -25777,
	-25777, -24020, -20627, -15827, -9949, -3393, 3393, 9949,
	15827, 20627, 24020, 25777, 25777, 24020, 20627, 15827,
	9949, 3393, -3393, -9949, -15827, -20627, -24020, -25777,
	-25777, -24020, -20627, -15827, -9949, -3393, 3393, 9949,
	15827, 20627, 24020, 25777, 25777, 24020, 20627, 15827,
	9949, 3393, -3393, -9949, -15827, -20627, -24020, -25777,
	-25777, -24020, -20627, -15827, -9949, -3393, 3393, 9949,
	15827, 20627, 24020, 25777, 25777, 24020, 20627, 15827,
	9949, 3393, -3393, -9949, -15827, -20627, -24020, -25777,
	-25777, -24020, -20627, -15827, -9949, -3393, 3393, 9949,
	15827, 20627, 24020, 25777, 25777, 24020, 20627, 15827,
	9949, 3393, -3393, -9949, -15827, -20627, -24020, -25777,
	-25777, -24020, -20627, -15827, -9949, -3393, 3393, 9949,
	15827, 20627, 24020, 25777, 25777, 24020, 20627, 15827,
	9949, 3393, -3393, -9949, -15827, -20627, -24020, -25777,
	-25777, -24020, -20627, -15827, -9949, -3393, 3393, 9949,
	15827, 20627, 24020, 25777, 25777, 24020, 20627, 15827,
	9949, 3393, -3393, -9949, -15827, -20627, -24020, -25777,
	-25777, -24020, -20627, -15827, -9949, -3393, 3393, 9949,
	15827, 20627, 24020, 25777, 25777, 24020, 20627, 15827},
	},{{

// Carrier 4 Phase 0
	0, 7456, 14287, 19917, 23873, 25824, 25605, 23234,
	18911, 13000, 5996, -1511, -8892, -15526, -20855, -24432,
	-25956, -25299, -22516, -17842, -11668, -4514, 3018, 10298,
	16712, 21722, 24907, 26000, 24907, 21722, 16712, 10298,
	3018, -4514, -11668, -17842, -22516, -25299, -25956, -24431,
	-20855, -15526, -8892, -1511, 5996, 13000, 18911, 23234,
	25605, 25824, 23873, 19917, 14287, 7456, 0, -7456,
	-14287, -19917, -23873, -25824, -25604, -23234, -18911, -12999,
	-5995, 1511, 8892, 15526, 20855, 24432, 25956, 25299,
	22516, 17842, 11668, 4514, -3018, -10298, -16712, -21722,
	-24907, -26000, -24907, -21722, -16712, -10297, -3018, 4515,
	11668, 17842, 22516, 25299, 25956, 24431, 20855, 15525,
	8892, 1511, -5996, -13000, -18911, -23234, -25605, -25824,
	-23873, -19917, -14287, -7456, 0, 7457, 14287, 19917,
	23873, 25824, 25604, 23234, 18911, 12999, 5995, -1511,
	-8892, -15526, -20855, -24432, -25956, -25299, -22516, -17842,
	-11668, -4514, 3018, 10298, 16712, 21722, 24907, 26000,
	24907, 21722, 16712, 10297, 3018, -4515, -11668, -17842,
	-22516, -25299, -25955, -24431, -20855, -15525, -8892, -1511,
	5996, 13000, 18911, 23234, 25605, 25824, 23873, 19916,
	14287, 7456, 0, -7457, -14287, -19917, -23873, -25824,
	-25604, -23234, -18911, -12999, -5995, 1512, 8892, 15526,
	20855, 24432, 25956, 25299, 22516, 17842, 11668, 4514,
	-3018, -10298, -16712, -21722, -24907, -26000, -24907, -21722,
	-16712, -10297, -3018, 4515, 11669, 17842, 22516, 25299,
	25955, 24431, 20854, 15525, 8892, 1511, -5996, -13000,
	-18911, -23234, -25605, -25824, -23873, -19916, -14286, -7456},
	{
// Carrier 4 Phase 1
	9949, 16421, 21512, 24796, 25997, 25013, 21928, 17000,
	10644, 3393, -4141, -11329, -17565, -22325, -25209, -25975,
	-24558, -21078, -15827, -9246, -1889, 5627, 12671, 18650,
	23062, 25536, 25865, 24020, 20158, 14601, 7818, 378,
	-7093, -13969, -19672, -23721, -25777, -25667, -23401, -19169,
	-13326, -6363, 1134, 8536, 15221, 20627, 24300, 25931,
	25383, 22703, 18115, 12005, 4886, -2642, -9949, -16421,
	-21512, -24796, -25997, -25013, -21928, -17000, -10644, -3393,
	4142, 11329, 17565, 22325, 25209, 25975, 24558, 21078,
	15827, 9246, 1888, -5627, -12671, -18650, -23062, -25536,
	-25865, -24020, -20158, -14601, -7818, -377, 7093, 13969,
	19672, 23721, 25777, 25667, 23401, 19169, 13325, 6363,
	-1134, -8536, -15221, -20627, -24300, -25931, -25383, -22703,
	-18115, -12005, -4886, 2642, 9949, 16421, 21512, 24796,
	25997, 25013, 21928, 17000, 10644, 3393, -4142, -11329,
	-17565, -22325, -25209, -25975, -24558, -21078, -15827, -9246,
	-1888, 5627, 12671, 18650, 23062, 25536, 25865, 24020,
	20157, 14601, 7818, 377, -7094, -13969, -19672, -23721,
	-25777, -25667, -23401, -19169, -13325, -6363, 1134, 8536,
	15221, 20627, 24300, 25931, 25383, 22703, 18115, 12005,
	4886, -2642, -9950, -16421, -21512, -24796, -25997, -25013,
	-21928, -17000, -10643, -3393, 4142, 11329, 17565, 22325,
	25209, 25975, 24558, 21078, 15827, 9246, 1888, -5627,
	-12671, -18650, -23062, -25536, -25865, -24020, -20157, -14601,
	-7818, -377, 7094, 13970, 19672, 23721, 25777, 25667,
	23401, 19168, 13325, 6362, -1134, -8536, -15221, -20627,
	-24300, -25931, -25383, -22703, -18115, -12005, -4886, 2642},
	{
// Carrier 4 Phase 2
	18384, 22885, 25462, 25901, 24163, 20394, 14912, 8178,
	756, -6729, -13649, -19422, -23564, -25725, -25725, -23563,
	-19422, -13649, -6729, 756, 8178, 14913, 20394, 24163,
	25901, 25462, 22885, 18384, 12339, 5257, -2266, -9599,
	-16126, -21297, -24680, -25989, -25114, -22129, -17284, -10988,
	-3768, 3768, 10988, 17284, 22129, 25114, 25988, 24680,
	21297, 16126, 9599, 2265, -5257, -12339, -18384, -22885,
	-25462, -25901, -24162, -20394, -14912, -8178, -756, 6729,
	13649, 19422, 23564, 25725, 25725, 23563, 19422, 13649,
	6729, -756, -8178, -14913, -20394, -24163, -25901, -25462,
	-22885, -18384, -12339, -5257, 2266, 9599, 16126, 21298,
	24680, 25989, 25114, 22128, 17284, 10987, 3768, -3768,
	-10988, -17284, -22129, -25114, -25988, -24680, -21297, -16125,
	-9599, -2265, 5257, 12339, 18384, 22885, 25462, 25901,
	24162, 20394, 14912, 8177, 755, -6729, -13649, -19422,
	-23564, -25725, -25725, -23563, -19422, -13649, -6729, 756,
	8178, 14913, 20394, 24163, 25901, 25462, 22885, 18384,
	12339, 5257, -2266, -9599, -16126, -21298, -24680, -25989,
	-25114, -22128, -17284, -10987, -3767, 3768, 10988, 17284,
	22129, 25114, 25988, 24680, 21297, 16125, 9599, 2265,
	-5257, -12339, -18384, -22885, -25462, -25901, -24162, -20394,
	-14912, -8177, -755, 6729, 13649, 19422, 23564, 25725,
	25725, 23563, 19422, 13649, 6728, -756, -8178, -14913,
	-20395, -24163, -25901, -25462, -22885, -18384, -12339, -5257,
	2266, 9599, 16126, 21298, 24680, 25989, 25113, 22128,
	17284, 10987, 3767, -3768, -10988, -17284, -22129, -25114,
	-25988, -24680, -21297, -16125, -9599, -2265, 5258, 12339},
	{
// Carrier 4 Phase 3
	24020, 25865, 25536, 23062, 18650, 12671, 5627, -1889,
	-9246, -15827, -21078, -24558, -25975, -25209, -22325, -17565,
	-11329, -4141, 3393, 10644, 17000, 21928, 25013, 25997,
	24796, 21512, 16421, 9949, 2642, -4886, -12005, -18115,
	-22703, -25383, -25931, -24300, -20627, -15221, -8536, -1134,
	6363, 13326, 19169, 23401, 25667, 25777, 23721, 19671,
	13969, 7093, -378, -7818, -14601, -20158, -24020, -25865,
	-25536, -23062, -18650, -12671, -5627, 1889, 9247, 15827,
	21078, 24558, 25975, 25209, 22325, 17565, 11329, 4141,
	-3393, -10644, -17000, -21928, -25013, -25997, -24796, -21512,
	-16420, -9949, -2642, 4886, 12005, 18115, 22703, 25383,
	25931, 24300, 20627, 15221, 8536, 1133, -6363, -13326,
	-19169, -23401, -25667, -25777, -23721, -19671, -13969, -7093,
	378, 7818, 14601, 20158, 24020, 25865, 25536, 23062,
	18650, 12670, 5627, -1889, -9247, -15827, -21078, -24558,
	-25975, -25209, -22325, -17565, -11329, -4141, 3393, 10644,
	17000, 21928, 25013, 25997, 24796, 21512, 16420, 9949,
	2642, -4887, -12005, -18115, -22703, -25383, -25931, -24299,
	-20627, -15220, -8535, -1133, 6363, 13326, 19169, 23401,
	25668, 25777, 23721, 19671, 13969, 7093, -378, -7818,
	-14601, -20158, -24020, -25865, -25536, -23062, -18650, -12670,
	-5627, 1889, 9247, 15828, 21078, 24558, 25975, 25209,
	22325, 17565, 11329, 4141, -3394, -10644, -17000, -21928,
	-25013, -25997, -24796, -21512, -16420, -9949, -2642, 4887,
	12005, 18115, 22703, 25383, 25931, 24299, 20626, 15220,
	8535, 1133, -6363, -13326, -19169, -23401, -25668, -25777,
	-23721, -19671, -13969, -7093, 378, 7818, 14601, 20158},
	{
// Carrier 4 Phase 4
	26000, 24907, 21722, 16712, 10298, 3018, -4514, -11668,
	-17842, -22516, -25299, -25956, -24432, -20855, -15526, -8892,
	-1511, 5996, 13000, 18911, 23234, 25605, 25824, 23873,
	19917, 14287, 7456, 0, -7456, -14287, -19917, -23873,
	-25824, -25604, -23234, -18911, -12999, -5995, 1511, 8892,
	15526, 20855, 24432, 25956, 25299, 22516, 17842, 11668,
	4514, -3018, -10298, -16712, -21722, -24907, -26000, -24907,
	-21722, -16712, -10297, -3018, 4514, 11668, 17842, 22516,
	25299, 25956, 24431, 20855, 15526, 8892, 1511, -5996,
	-13000, -18911, -23234, -25605, -25824, -23873, -19917, -14287,
	-7456, 0, 7457, 14287, 19917, 23873, 25824, 25604,
	23234, 18911, 12999, 5995, -1511, -8892, -15526, -20855,
	-24432, -25956, -25299, -22516, -17842, -11668, -4514, 3018,
	10298, 16712, 21722, 24907, 26000, 24907, 21722, 16712,
	10297, 3018, -4515, -11668, -17842, -22516, -25299, -25955,
	-24431, -20855, -15525, -8892, -1511, 5996, 13000, 18911,
	23234, 25605, 25824, 23873, 19917, 14287, 7456, 0,
	-7457, -14287, -19917, -23873, -25824, -25604, -23234, -18911,
	-12999, -5995, 1512, 8892, 15526, 20855, 24432, 25956,
	25299, 22516, 17842, 11668, 4514, -3018, -10298, -16712,
	-21722, -24907, -26000, -24907, -21722, -16712, -10297, -3018,
	4515, 11669, 17842, 22516, 25299, 25955, 24431, 20855,
	15525, 8892, 1511, -5996, -13000, -18911, -23234, -25605,
	-25824, -23873, -19916, -14286, -7456, 0, 7457, 14287,
	19917, 23873, 25824, 25604, 23234, 18911, 12999, 5995,
	-1512, -8892, -15526, -20855, -24432, -25956, -25299, -22516,
	-17842, -11668, -4514, 3018, 10298, 16712, 21722, 24907},
	{
// Carrier 4 Phase 5
	24020, 20158, 14601, 7818, 378, -7093, -13969, -19671,
	-23721, -25777, -25667, -23401, -19169, -13326, -6363, 1134,
	8536, 15221, 20627, 24300, 25931, 25383, 22703, 18115,
	12005, 4886, -2642, -9949, -16421, -21512, -24796, -25997,
	-25013, -21928, -17000, -10644, -3393, 4142, 11329, 17565,
	22325, 25209, 25975, 24558, 21078, 15827, 9246, 1889,
	-5627, -12671, -18650, -23062, -25536, -25865, -24020, -20158,
	-14601, -7818, -378, 7093, 13969, 19672, 23721, 25777,
	25667, 23401, 19169, 13326, 6363, -1134, -8536, -15221,
	-20627, -24300, -25931, -25383, -22703, -18115, -12005, -4886,
	2642, 9949, 16421, 21512, 24796, 25997, 25013, 21928,
	17000, 10644, 3393, -4142, -11329, -17565, -22325, -25209,
	-25975, -24558, -21078, -15827, -9246, -1888, 5627, 12671,
	18650, 23062, 25536, 25865, 24020, 20157, 14601, 7818,
	377, -7094, -13969, -19672, -23721, -25777, -25667, -23401,
	-19169, -13325, -6363, 1134, 8536, 15221, 20627, 24300,
	25931, 25383, 22703, 18115, 12005, 4886, -2642, -9949,
	-16421, -21512, -24796, -25997, -25013, -21928, -17000, -10643,
	-3393, 4142, 11329, 17565, 22325, 25209, 25975, 24558,
	21078, 15827, 9246, 1888, -5627, -12671, -18650, -23062,
	-25536, -25865, -24020, -20157, -14601, -7818, -377, 7094,
	13970, 19672, 23721, 25777, 25667, 23401, 19168, 13325,
	6363, -1134, -8536, -15221, -20627, -24300, -25931, -25383,
	-22703, -18115, -12005, -4886, 2642, 9950, 16421, 21512,
	24796, 25997, 25013, 21927, 17000, 10643, 3393, -4142,
	-11329, -17565, -22325, -25209, -25975, -24558, -21078, -15827,
	-9246, -1888, 5627, 12671, 18650, 23062, 25536, 25865},
	{
// Carrier 4 Phase 6
	18384, 12339, 5257, -2266, -9599, -16126, -21297, -24680,
	-25989, -25114, -22129, -17284, -10988, -3768, 3768, 10988,
	17284, 22129, 25114, 25989, 24680, 21297, 16126, 9599,
	2266, -5257, -12339, -18384, -22885, -25462, -25901, -24163,
	-20394, -14912, -8178, -756, 6729, 13649, 19422, 23564,
	25725, 25725, 23563, 19422, 13649, 6729, -756, -8178,
	-14913, -20394, -24163, -25901, -25462, -22885, -18384, -12339,
	-5257, 2266, 9599, 16126, 21298, 24680, 25989, 25114,
	22128, 17284, 10987, 3768, -3768, -10988, -17284, -22129,
	-25114, -25988, -24680, -21297, -16126, -9599, -2265, 5257,
	12339, 18384, 22885, 25462, 25901, 24162, 20394, 14912,
	8178, 756, -6729, -13649, -19422, -23564, -25725, -25725,
	-23563, -19422, -13649, -6729, 756, 8178, 14913, 20394,
	24163, 25901, 25462, 22885, 18384, 12339, 5257, -2266,
	-9599, -16126, -21298, -24680, -25989, -25114, -22128, -17284,
	-10987, -3767, 3768, 10988, 17284, 22129, 25114, 25988,
	24680, 21297, 16125, 9599, 2265, -5257, -12339, -18384,
	-22885, -25462, -25901, -24162, -20394, -14912, -8177, -755,
	6729, 13649, 19422, 23564, 25725, 25725, 23563, 19422,
	13649, 6729, -756, -8178, -14913, -20394, -24163, -25901,
	-25462, -22885, -18384, -12339, -5257, 2266, 9599, 16126,
	21298, 24680, 25989, 25113, 22128, 17284, 10987, 3767,
	-3768, -10988, -17284, -22129, -25114, -25988, -24680, -21297,
	-16125, -9599, -2265, 5258, 12339, 18385, 22885, 25462,
	25901, 24162, 20394, 14912, 8177, 755, -6729, -13649,
	-19422, -23564, -25725, -25725, -23563, -19422, -13649, -6728,
	756, 8178, 14913, 20395, 24163, 25901, 25462, 22885},
	{
// Carrier 4 Phase 7
	9949, 2642, -4886, -12005, -18115, -22703, -25383, -25931,
	-24300, -20627, -15221, -8536, -1134, 6363, 13326, 19169,
	23401, 25667, 25777, 23721, 19671, 13969, 7093, -378,
	-7818, -14601, -20158, -24020, -25865, -25536, -23062, -18650,
	-12671, -5627, 1889, 9246, 15827, 21078, 24558, 25975,
	25209, 22325, 17565, 11329, 4141, -3393, -10644, -17000,
	-21928, -25013, -25997, -24796, -21512, -16420, -9949, -2642,
	4886, 12005, 18115, 22703, 25383, 25931, 24300, 20627,
	15221, 8536, 1133, -6363, -13326, -19169, -23401, -25667,
	-25777, -23721, -19671, -13969, -7093, 378, 7818, 14601,
	20158, 24020, 25865, 25536, 23062, 18650, 12671, 5627,
	-1889, -9247, -15827, -21078, -24558, -25975, -25209, -22325,
	-17565, -11329, -4141, 3393, 10644, 17000, 21928, 25013,
	25997, 24796, 21512, 16420, 9949, 2642, -4886, -12005,
	-18115, -22703, -25383, -25931, -24300, -20627, -15220, -8536,
	-1133, 6363, 13326, 19169, 23401, 25667, 25777, 23721,
	19671, 13969, 7093, -378, -7818, -14601, -20158, -24020,
	-25865, -25536, -23062, -18650, -12670, -5627, 1889, 9247,
	15828, 21078, 24558, 25975, 25209, 22325, 17565, 11329,
	4141, -3393, -10644, -17000, -21928, -25013, -25997, -24796,
	-21512, -16420, -9949, -2642, 4887, 12005, 18115, 22703,
	25383, 25931, 24299, 20627, 15220, 8535, 1133, -6363,
	-13326, -19169, -23401, -25668, -25777, -23721, -19671, -13969,
	-7093, 378, 7818, 14601, 20158, 24021, 25865, 25536,
	23062, 18649, 12670, 5627, -1889, -9247, -15828, -21079,
	-24558, -25975, -25209, -22325, -17565, -11329, -4141, 3394,
	10644, 17000, 21928, 25013, 25997, 24796, 21512, 16420},
	},{{

// Carrier 5 Phase 0
	0, 8178, 15526, 21297, 24907, 25989, 24432, 20394,
	14287, 6729, -1511, -9599, -16712, -22129, -25299, -25901,
	-23873, -19422, -13000, -5257, 3018, 10988, 17842, 22885,
	25604, 25725, 23234, 18384, 11668, 3768, -4514, -12339,
	-18911, -23563, -25824, -25462, -22516, -17284, -10298, -2266,
	5995, 13649, 19917, 24163, 25956, 25114, 21722, 16126,
	8892, 756, -7456, -14912, -20855, -24680, -26000, -24680,
	-20855, -14913, -7456, 756, 8892, 16126, 21722, 25114,
	25956, 24163, 19917, 13649, 5996, -2265, -10297, -17284,
	-22516, -25462, -25824, -23564, -18911, -12339, -4514, 3768,
	11668, 18384, 23234, 25725, 25605, 22885, 17842, 10988,
	3018, -5257, -12999, -19422, -23873, -25901, -25299, -22129,
	-16712, -9599, -1511, 6729, 14287, 20394, 24431, 25988,
	24907, 21298, 15526, 8178, 0, -8177, -15525, -21297,
	-24907, -25989, -24432, -20394, -14287, -6729, 1511, 9599,
	16712, 22128, 25299, 25901, 23873, 19422, 13000, 5257,
	-3018, -10987, -17842, -22885, -25604, -25725, -23234, -18384,
	-11668, -3768, 4514, 12339, 18911, 23563, 25824, 25462,
	22516, 17284, 10298, 2266, -5995, -13649, -19916, -24162,
	-25955, -25114, -21722, -16126, -8892, -756, 7456, 14912,
	20855, 24680, 26000, 24680, 20855, 14913, 7457, -755,
	-8892, -16125, -21722, -25113, -25956, -24163, -19917, -13649,
	-5996, 2265, 10297, 17284, 22516, 25462, 25824, 23564,
	18911, 12339, 4515, -3767, -11668, -18384, -23234, -25725,
	-25605, -22885, -17842, -10988, -3018, 5257, 12999, 19422,
	23873, 25901, 25299, 22129, 16712, 9599, 1512, -6728,
	-14286, -20394, -24431, -25988, -24907, -21298, -15526, -8178},
	{
// Carrier 5 Phase 1
	9949, 17000, 22325, 25383, 25865, 23721, 19169, 12671,
	4886, -3393, -11329, -18115, -23062, -25667, -25667, -23062,
	-18115, -11329, -3393, 4886, 12671, 19169, 23721, 25865,
	25383, 22325, 17000, 9949, 1889, -6363, -13969, -20158,
	-24300, -25975, -25013, -21512, -15827, -8536, -378, 7818,
	15221, 21078, 24796, 25997, 24558, 20627, 14601, 7093,
	-1134, -9246, -16420, -21928, -25209, -25931, -24020, -19672,
	-13326, -5627, 2642, 10644, 17565, 22703, 25536, 25777,
	23401, 18650, 12005, 4142, -4141, -12005, -18650, -23401,
	-25777, -25536, -22703, -17565, -10644, -2642, 5627, 13325,
	19671, 24020, 25931, 25209, 21928, 16421, 9247, 1134,
	-7093, -14601, -20627, -24558, -25997, -24796, -21078, -15221,
	-7818, 377, 8536, 15827, 21512, 25013, 25975, 24300,
	20158, 13969, 6363, -1888, -9949, -17000, -22325, -25383,
	-25865, -23721, -19169, -12671, -4886, 3393, 11329, 18115,
	23062, 25667, 25667, 23062, 18115, 11329, 3393, -4886,
	-12670, -19169, -23721, -25865, -25383, -22325, -17000, -9950,
	-1889, 6363, 13969, 20157, 24299, 25975, 25013, 21512,
	15828, 8536, 378, -7818, -15220, -21078, -24796, -25997,
	-24558, -20627, -14601, -7094, 1133, 9246, 16420, 21928,
	25209, 25931, 24020, 19672, 13326, 5627, -2642, -10643,
	-17565, -22703, -25536, -25777, -23401, -18650, -12005, -4142,
	4141, 12005, 18649, 23401, 25777, 25536, 22703, 17565,
	10644, 2642, -5627, -13325, -19671, -24020, -25931, -25209,
	-21928, -16421, -9247, -1134, 7093, 14601, 20626, 24558,
	25997, 24796, 21079, 15221, 7818, -377, -8535, -15827,
	-21512, -25013, -25975, -24300, -20158, -13970, -6363, 1888},
	{
// Carrier 5 Phase 2
	18384, 23234, 25725, 25605, 22885, 17842, 10988, 3018,
	-5257, -12999, -19422, -23873, -25901, -25299, -22129, -16712,
	-9599, -1511, 6729, 14287, 20394, 24431, 25989, 24907,
	21297, 15526, 8178, 0, -8178, -15526, -21297, -24907,
	-25989, -24432, -20394, -14287, -6729, 1511, 9599, 16712,
	22128, 25299, 25901, 23873, 19422, 13000, 5257, -3018,
	-10988, -17842, -22885, -25604, -25725, -23234, -18384, -11668,
	-3768, 4514, 12339, 18911, 23563, 25824, 25462, 22516,
	17284, 10298, 2266, -5995, -13649, -19917, -24162, -25956,
	-25114, -21722, -16126, -8892, -756, 7456, 14912, 20855,
	24680, 26000, 24680, 20855, 14913, 7457, -756, -8892,
	-16125, -21722, -25114, -25956, -24163, -19917, -13649, -5996,
	2265, 10297, 17284, 22516, 25462, 25824, 23564, 18911,
	12339, 4515, -3768, -11668, -18384, -23234, -25725, -25605,
	-22885, -17842, -10988, -3018, 5257, 12999, 19422, 23873,
	25901, 25299, 22129, 16712, 9599, 1512, -6729, -14287,
	-20394, -24431, -25988, -24907, -21298, -15526, -8178, 0,
	8177, 15525, 21297, 24907, 25989, 24432, 20394, 14287,
	6729, -1511, -9599, -16712, -22128, -25299, -25901, -23873,
	-19422, -13000, -5257, 3018, 10987, 17842, 22885, 25604,
	25725, 23234, 18385, 11669, 3768, -4514, -12339, -18911,
	-23563, -25824, -25462, -22516, -17284, -10298, -2266, 5995,
	13649, 19916, 24162, 25955, 25114, 21722, 16126, 8892,
	756, -7456, -14912, -20854, -24680, -26000, -24680, -20855,
	-14913, -7457, 755, 8892, 16125, 21722, 25113, 25956,
	24163, 19917, 13649, 5996, -2265, -10297, -17284, -22516,
	-25462, -25824, -23564, -18912, -12339, -4515, 3767, 11668},
	{
// Carrier 5 Phase 3
	24020, 25931, 25209, 21928, 16421, 9246, 1134, -7093,
	-14601, -20627, -24558, -25997, -24796, -21078, -15221, -7818,
	378, 8536, 15827, 21512, 25013, 25975, 24300, 20158,
	13969, 6363, -1889, -9949, -17000, -22325, -25383, -25865,
	-23721, -19169, -12671, -4886, 3393, 11329, 18115, 23062,
	25667, 25667, 23062, 18115, 11329, 3393, -4886, -12671,
	-19169, -23721, -25865, -25383, -22325, -17000, -9949, -1889,
	6363, 13969, 20158, 24300, 25975, 25013, 21512, 15827,
	8536, 378, -7818, -15221, -21078, -24796, -25997, -24558,
	-20627, -14601, -7093, 1133, 9246, 16420, 21928, 25209,
	25931, 24020, 19672, 13326, 5627, -2642, -10644, -17565,
	-22703, -25536, -25777, -23401, -18650, -12005, -4142, 4141,
	12005, 18650, 23401, 25777, 25536, 22703, 17565, 10644,
	2642, -5627, -13325, -19671, -24020, -25931, -25209, -21928,
	-16421, -9247, -1134, 7093, 14601, 20627, 24558, 25997,
	24796, 21078, 15221, 7818, -377, -8536, -15827, -21512,
	-25013, -25975, -24300, -20158, -13969, -6363, 1888, 9949,
	17000, 22325, 25383, 25865, 23721, 19169, 12671, 4887,
	-3393, -11329, -18115, -23062, -25667, -25667, -23062, -18115,
	-11329, -3393, 4886, 12670, 19169, 23721, 25865, 25383,
	22325, 17000, 9950, 1889, -6363, -13969, -20157, -24299,
	-25975, -25013, -21512, -15828, -8536, -378, 7818, 15220,
	21078, 24796, 25997, 24558, 20627, 14601, 7094, -1133,
	-9246, -16420, -21927, -25209, -25931, -24021, -19672, -13326,
	-5627, 2642, 10643, 17565, 22703, 25536, 25777, 23401,
	18650, 12005, 4142, -4141, -12005, -18649, -23401, -25777,
	-25536, -22703, -17565, -10644, -2642, 5627, 13325, 19671},
	{
// Carrier 5 Phase 4
	26000, 24680, 20855, 14912, 7456, -756, -8892, -16126,
	-21722, -25114, -25956, -24163, -19917, -13649, -5996, 2266,
	10298, 17284, 22516, 25462, 25824, 23564, 18911, 12339,
	4514, -3768, -11668, -18384, -23234, -25725, -25605, -22885,
	-17842, -10988, -3018, 5257, 12999, 19422, 23873, 25901,
	25299, 22129, 16712, 9599, 1511, -6729, -14287, -20394,
	-24431, -25988, -24907, -21298, -15526, -8178, 0, 8178,
	15526, 21297, 24907, 25989, 24432, 20394, 14287, 6729,
	-1511, -9599, -16712, -22128, -25299, -25901, -23873, -19422,
	-13000, -5257, 3018, 10987, 17842, 22885, 25604, 25725,
	23234, 18384, 11668, 3768, -4514, -12339, -18911, -23563,
	-25824, -25462, -22516, -17284, -10298, -2266, 5995, 13649,
	19917, 24162, 25956, 25114, 21722, 16126, 8892, 756,
	-7456, -14912, -20855, -24680, -26000, -24680, -20855, -14913,
	-7457, 755, 8892, 16125, 21722, 25114, 25956, 24163,
	19917, 13649, 5996, -2265, -10297, -17284, -22516, -25462,
	-25824, -23564, -18911, -12339, -4515, 3767, 11668, 18384,
	23234, 25725, 25605, 22885, 17842, 10988, 3018, -5257,
	-12999, -19422, -23873, -25901, -25299, -22129, -16712, -9599,
	-1512, 6729, 14286, 20394, 24431, 25988, 24907, 21298,
	15526, 8178, 0, -8177, -15525, -21297, -24907, -25989,
	-24432, -20395, -14287, -6729, 1511, 9599, 16712, 22128,
	25299, 25901, 23873, 19422, 13000, 5257, -3018, -10987,
	-17842, -22885, -25604, -25725, -23234, -18385, -11669, -3768,
	4514, 12339, 18911, 23563, 25824, 25462, 22516, 17284,
	10298, 2266, -5995, -13649, -19916, -24162, -25955, -25114,
	-21722, -16126, -8892, -756, 7456, 14912, 20854, 24680},
	{
// Carrier 5 Phase 5
	24020, 19671, 13326, 5627, -2642, -10644, -17565, -22703,
	-25536, -25777, -23401, -18650, -12005, -4142, 4141, 12005,
	18650, 23401, 25777, 25536, 22703, 17565, 10644, 2642,
	-5627, -13326, -19671, -24020, -25931, -25209, -21928, -16421,
	-9246, -1134, 7093, 14601, 20627, 24558, 25997, 24796,
	21078, 15221, 7818, -378, -8536, -15827, -21512, -25013,
	-25975, -24300, -20158, -13969, -6363, 1888, 9949, 17000,
	22325, 25383, 25865, 23721, 19169, 12671, 4886, -3393,
	-11329, -18115, -23062, -25667, -25667, -23062, -18115, -11329,
	-3393, 4886, 12671, 19169, 23721, 25865, 25383, 22325,
	17000, 9949, 1889, -6363, -13969, -20158, -24300, -25975,
	-25013, -21512, -15827, -8536, -378, 7818, 15221, 21078,
	24796, 25997, 24558, 20627, 14601, 7094, -1133, -9246,
	-16420, -21928, -25209, -25931, -24020, -19672, -13326, -5627,
	2642, 10643, 17565, 22703, 25536, 25777, 23401, 18650,
	12005, 4142, -4141, -12005, -18650, -23401, -25777, -25536,
	-22703, -17565, -10644, -2642, 5627, 13325, 19671, 24020,
	25931, 25209, 21928, 16421, 9247, 1134, -7093, -14601,
	-20627, -24558, -25997, -24796, -21078, -15221, -7818, 377,
	8535, 15827, 21512, 25013, 25975, 24300, 20158, 13970,
	6363, -1888, -9949, -17000, -22325, -25383, -25865, -23721,
	-19169, -12671, -4887, 3393, 11329, 18115, 23062, 25667,
	25668, 23062, 18115, 11329, 3394, -4886, -12670, -19168,
	-23721, -25865, -25383, -22325, -17000, -9950, -1889, 6362,
	13969, 20157, 24299, 25975, 25013, 21512, 15828, 8536,
	378, -7817, -15220, -21078, -24796, -25997, -24558, -20627,
	-14601, -7094, 1133, 9246, 16420, 21927, 25209, 25931},
	{
// Carrier 5 Phase 6
	18384, 11668, 3768, -4514, -12339, -18911, -23564, -25824,
	-25462, -22516, -17284, -10298, -2266, 5995, 13649, 19917,
	24163, 25956, 25114, 21722, 16126, 8892, 756, -7456,
	-14912, -20855, -24680, -26000, -24680, -20855, -14913, -7456,
	756, 8892, 16126, 21722, 25114, 25956, 24163, 19917,
	13649, 5996, -2265, -10298, -17284, -22516, -25462, -25824,
	-23564, -18911, -12339, -4514, 3768, 11668, 18384, 23234,
	25725, 25605, 22885, 17842, 10988, 3018, -5257, -12999,
	-19422, -23873, -25901, -25299, -22129, -16712, -9599, -1511,
	6729, 14287, 20394, 24431, 25988, 24907, 21298, 15526,
	8178, 0, -8178, -15526, -21297, -24907, -25989, -24432,
	-20394, -14287, -6729, 1511, 9599, 16712, 22128, 25299,
	25901, 23873, 19422, 13000, 5257, -3018, -10987, -17842,
	-22885, -25604, -25725, -23234, -18384, -11668, -3768, 4514,
	12339, 18911, 23563, 25824, 25462, 22516, 17284, 10298,
	2266, -5995, -13649, -19917, -24162, -25955, -25114, -21722,
	-16126, -8892, -756, 7456, 14912, 20855, 24680, 26000,
	24680, 20855, 14913, 7457, -755, -8892, -16125, -21722,
	-25114, -25956, -24163, -19917, -13649, -5996, 2265, 10297,
	17284, 22516, 25462, 25824, 23564, 18911, 12339, 4515,
	-3767, -11668, -18384, -23234, -25725, -25605, -22885, -17842,
	-10988, -3018, 5257, 12999, 19422, 23873, 25901, 25299,
	22129, 16712, 9599, 1512, -6728, -14286, -20394, -24431,
	-25988, -24907, -21298, -15526, -8178, 0, 8177, 15525,
	21297, 24907, 25989, 24432, 20395, 14287, 6729, -1511,
	-9599, -16712, -22128, -25299, -25901, -23873, -19422, -13000,
	-5258, 3018, 10987, 17841, 22885, 25604, 25725, 23234},
	{
// Carrier 5 Phase 7
	9949, 1889, -6363, -13969, -20158, -24300, -25975, -25013,
	-21512, -15827, -8536, -378, 7818, 15221, 21078, 24796,
	25997, 24558, 20627, 14601, 7093, -1134, -9246, -16421,
	-21928, -25209, -25931, -24020, -19672, -13326, -5627, 2642,
	10644, 17565, 22703, 25536, 25777, 23401, 18650, 12005,
	4142, -4141, -12005, -18650, -23401, -25777, -25536, -22703,
	-17565, -10644, -2642, 5627, 13326, 19671, 24020, 25931,
	25209, 21928, 16421, 9247, 1134, -7093, -14601, -20627,
	-24558, -25997, -24796, -21078, -15221, -7818, 377, 8536,
	15827, 21512, 25013, 25975, 24300, 20158, 13969, 6363,
	-1888, -9949, -17000, -22325, -25383, -25865, -23721, -19169,
	-12671, -4886, 3393, 11329, 18115, 23062, 25667, 25667,
	23062, 18115, 11329, 3393, -4886, -12670, -19169, -23721,
	-25865, -25383, -22325, -17000, -9949, -1889, 6363, 13969,
	20157, 24300, 25975, 25013, 21512, 15827, 8536, 378,
	-7818, -15220, -21078, -24796, -25997, -24558, -20627, -14601,
	-7094, 1133, 9246, 16420, 21928, 25209, 25931, 24020,
	19672, 13326, 5627, -2642, -10643, -17565, -22703, -25536,
	-25777, -23401, -18650, -12005, -4142, 4141, 12005, 18650,
	23401, 25777, 25536, 22703, 17565, 10644, 2642, -5627,
	-13325, -19671, -24020, -25931, -25209, -21928, -16421, -9247,
	-1134, 7093, 14601, 20626, 24558, 25997, 24796, 21079,
	15221, 7818, -377, -8535, -15827, -21512, -25013, -25975,
	-24300, -20158, -13970, -6363, 1888, 9949, 17000, 22325,
	25383, 25865, 23721, 19169, 12671, 4887, -3393, -11329,
	-18115, -23062, -25667, -25668, -23062, -18115, -11329, -3394,
	4886, 12670, 19168, 23721, 25865, 25383, 22325, 17000},
	},{{

// Carrier 6 Phase 0
	0, 8892, 16712, 22516, 25605, 25605, 22516, 16712,
	8892, 0, -8892, -16712, -22516, -25604, -25605, -22516,
	-16712, -8892, 0, 8892, 16712, 22516, 25604, 25605,
	22516, 16712, 8892, 0, -8892, -16712, -22516, -25604,
	-25605, -22516, -16712, -8892, 0, 8892, 16712, 22516,
	25604, 25605, 22516, 16712, 8892, 0, -8892, -16712,
	-22516, -25604, -25605, -22516, -16712, -8892, 0, 8892,
	16712, 22516, 25604, 25605, 22516, 16712, 8892, 0,
	-8892, -16712, -22516, -25604, -25605, -22516, -16712, -8892,
	0, 8892, 16712, 22516, 25604, 25605, 22516, 16712,
	8892, 0, -8892, -16712, -22516, -25604, -25605, -22516,
	-16712, -8892, 0, 8892, 16712, 22516, 25604, 25605,
	22516, 16712, 8892, 0, -8892, -16712, -22516, -25604,
	-25605, -22516, -16712, -8892, 0, 8892, 16712, 22516,
	25604, 25605, 22516, 16712, 8892, 0, -8892, -16712,
	-22516, -25604, -25605, -22516, -16712, -8892, 0, 8892,
	16712, 22516, 25604, 25605, 22516, 16712, 8892, 0,
	-8892, -16712, -22516, -25604, -25605, -22516, -16712, -8892,
	0, 8892, 16712, 22516, 25604, 25605, 22516, 16712,
	8892, 0, -8892, -16712, -22516, -25604, -25605, -22516,
	-16712, -8892, 0, 8892, 16712, 22516, 25604, 25605,
	22516, 16712, 8892, 0, -8892, -16712, -22516, -25604,
	-25605, -22516, -16712, -8892, 0, 8892, 16712, 22516,
	25604, 25605, 22516, 16712, 8892, 0, -8892, -16712,
	-22516, -25604, -25605, -22516, -16712, -8892, 0, 8892,
	16712, 22516, 25604, 25605, 22516, 16712, 8892, 0,
	-8892, -16712, -22516, -25604, -25605, -22516, -16712, -8892},
	{
// Carrier 6 Phase 1
	9949, 17565, 23062, 25777, 25383, 21928, 15827, 7818,
	-1134, -9949, -17565, -23062, -25777, -25383, -21928, -15827,
	-7818, 1134, 9949, 17565, 23062, 25777, 25383, 21928,
	15827, 7818, -1134, -9949, -17565, -23062, -25777, -25383,
	-21928, -15827, -7818, 1134, 9949, 17565, 23062, 25777,
	25383, 21928, 15827, 7818, -1134, -9949, -17565, -23062,
	-25777, -25383, -21928, -15827, -7818, 1134, 9949, 17565,
	23062, 25777, 25383, 21928, 15827, 7818, -1134, -9949,
	-17565, -23062, -25777, -25383, -21928, -15827, -7818, 1134,
	9949, 17565, 23062, 25777, 25383, 21928, 15827, 7818,
	-1134, -9949, -17565, -23062, -25777, -25383, -21928, -15827,
	-7818, 1134, 9949, 17565, 23062, 25777, 25383, 21928,
	15827, 7818, -1134, -9949, -17565, -23062, -25777, -25383,
	-21928, -15827, -7818, 1134, 9949, 17565, 23062, 25777,
	25383, 21928, 15827, 7818, -1134, -9949, -17565, -23062,
	-25777, -25383, -21928, -15827, -7818, 1134, 9949, 17565,
	23062, 25777, 25383, 21928, 15827, 7818, -1134, -9949,
	-17565, -23062, -25777, -25383, -21928, -15827, -7818, 1133,
	9949, 17565, 23062, 25777, 25383, 21928, 15827, 7818,
	-1133, -9949, -17565, -23062, -25777, -25383, -21928, -15827,
	-7818, 1133, 9949, 17565, 23062, 25777, 25383, 21928,
	15827, 7818, -1133, -9949, -17565, -23062, -25777, -25383,
	-21928, -15827, -7818, 1133, 9949, 17565, 23062, 25777,
	25383, 21928, 15827, 7818, -1133, -9949, -17565, -23062,
	-25777, -25383, -21928, -15827, -7818, 1133, 9949, 17565,
	23062, 25777, 25383, 21928, 15827, 7818, -1133, -9949,
	-17565, -23062, -25777, -25383, -21928, -15827, -7818, 1133},
	{
// Carrier 6 Phase 2
	18384, 23564, 25901, 25114, 21297, 14912, 6729, -2266,
	-10988, -18384, -23563, -25901, -25114, -21297, -14913, -6729,
	2266, 10988, 18384, 23563, 25901, 25114, 21297, 14913,
	6729, -2266, -10988, -18384, -23563, -25901, -25114, -21297,
	-14913, -6729, 2266, 10988, 18384, 23563, 25901, 25114,
	21297, 14913, 6729, -2266, -10988, -18384, -23563, -25901,
	-25114, -21297, -14913, -6729, 2266, 10988, 18384, 23563,
	25901, 25114, 21297, 14913, 6729, -2266, -10988, -18384,
	-23563, -25901, -25114, -21297, -14913, -6729, 2265, 10988,
	18384, 23563, 25901, 25114, 21297, 14913, 6729, -2265,
	-10988, -18384, -23563, -25901, -25114, -21297, -14913, -6729,
	2265, 10988, 18384, 23563, 25901, 25114, 21297, 14913,
	6729, -2265, -10988, -18384, -23563, -25901, -25114, -21297,
	-14913, -6729, 2265, 10988, 18384, 23563, 25901, 25114,
	21297, 14913, 6729, -2265, -10987, -18384, -23563, -25901,
	-25114, -21298, -14913, -6729, 2265, 10987, 18384, 23563,
	25901, 25114, 21298, 14913, 6729, -2265, -10987, -18384,
	-23563, -25901, -25114, -21298, -14913, -6729, 2265, 10987,
	18384, 23563, 25901, 25114, 21298, 14913, 6729, -2265,
	-10987, -18384, -23563, -25901, -25114, -21298, -14913, -6729,
	2265, 10987, 18384, 23563, 25901, 25114, 21298, 14913,
	6729, -2265, -10987, -18384, -23563, -25901, -25114, -21298,
	-14913, -6729, 2265, 10987, 18384, 23563, 25901, 25114,
	21298, 14913, 6729, -2265, -10987, -18384, -23563, -25901,
	-25114, -21298, -14913, -6729, 2265, 10987, 18384, 23563,
	25901, 25114, 21298, 14913, 6729, -2265, -10987, -18384,
	-23563, -25901, -25114, -21298, -14913, -6729, 2265, 10987},
	{
// Carrier 6 Phase 3
	24020, 25975, 24796, 20627, 13969, 5627, -3393, -12005,
	-19169, -24020, -25975, -24796, -20627, -13969, -5627, 3393,
	12005, 19169, 24020, 25975, 24796, 20627, 13969, 5627,
	-3393, -12005, -19169, -24020, -25975, -24796, -20627, -13969,
	-5627, 3393, 12005, 19169, 24020, 25975, 24796, 20627,
	13969, 5627, -3393, -12005, -19169, -24020, -25975, -24796,
	-20627, -13969, -5627, 3393, 12005, 19169, 24020, 25975,
	24796, 20627, 13969, 5627, -3393, -12005, -19169, -24020,
	-25975, -24796, -20627, -13969, -5627, 3393, 12005, 19169,
	24020, 25975, 24796, 20627, 13969, 5627, -3393, -12005,
	-19169, -24020, -25975, -24796, -20627, -13969, -5627, 3393,
	12005, 19169, 24020, 25975, 24796, 20627, 13969, 5627,
	-3393, -12005, -19169, -24020, -25975, -24796, -20627, -13969,
	-5627, 3393, 12005, 19169, 24020, 25975, 24796, 20627,
	13969, 5627, -3393, -12005, -19169, -24020, -25975, -24796,
	-20627, -13969, -5627, 3393, 12005, 19169, 24020, 25975,
	24796, 20627, 13969, 5627, -3393, -12005, -19169, -24020,
	-25975, -24796, -20627, -13969, -5627, 3393, 12005, 19169,
	24020, 25975, 24796, 20627, 13969, 5627, -3393, -12005,
	-19169, -24020, -25975, -24796, -20627, -13969, -5627, 3393,
	12005, 19169, 24020, 25975, 24796, 20627, 13969, 5627,
	-3393, -12005, -19169, -24020, -25975, -24796, -20627, -13969,
	-5627, 3393, 12005, 19169, 24020, 25975, 24796, 20627,
	13969, 5627, -3393, -12005, -19169, -24020, -25975, -24796,
	-20627, -13969, -5627, 3393, 12005, 19169, 24020, 25975,
	24796, 20627, 13969, 5627, -3393, -12005, -19169, -24020,
	-25975, -24796, -20627, -13969, -5627, 3393, 12005, 19169},
	{
// Carrier 6 Phase 4
	26000, 24432, 19917, 13000, 4514, -4514, -12999, -19917,
	-24432, -26000, -24432, -19917, -13000, -4514, 4514, 12999,
	19917, 24432, 26000, 24432, 19917, 13000, 4514, -4514,
	-12999, -19917, -24431, -26000, -24432, -19917, -13000, -4514,
	4514, 12999, 19917, 24431, 26000, 24432, 19917, 13000,
	4514, -4514, -12999, -19917, -24431, -26000, -24432, -19917,
	-13000, -4514, 4514, 12999, 19917, 24431, 26000, 24432,
	19917, 13000, 4514, -4514, -12999, -19917, -24431, -26000,
	-24432, -19917, -13000, -4514, 4514, 12999, 19917, 24431,
	26000, 24432, 19917, 13000, 4514, -4514, -12999, -19917,
	-24431, -26000, -24432, -19917, -13000, -4514, 4514, 12999,
	19917, 24431, 26000, 24432, 19917, 13000, 4514, -4514,
	-12999, -19917, -24431, -26000, -24432, -19917, -13000, -4514,
	4514, 12999, 19917, 24431, 26000, 24432, 19917, 13000,
	4515, -4514, -12999, -19917, -24431, -26000, -24432, -19917,
	-13000, -4515, 4514, 12999, 19917, 24431, 26000, 24432,
	19917, 13000, 4515, -4514, -12999, -19917, -24431, -26000,
	-24432, -19917, -13000, -4515, 4514, 12999, 19917, 24431,
	26000, 24432, 19917, 13000, 4515, -4514, -12999, -19917,
	-24431, -26000, -24432, -19917, -13000, -4515, 4514, 12999,
	19917, 24431, 26000, 24432, 19917, 13000, 4515, -4514,
	-12999, -19917, -24431, -26000, -24432, -19917, -13000, -4515,
	4514, 12999, 19917, 24431, 26000, 24432, 19917, 13000,
	4515, -4514, -12999, -19916, -24431, -26000, -24432, -19917,
	-13000, -4515, 4514, 12999, 19916, 24431, 26000, 24432,
	19917, 13000, 4515, -4514, -12999, -19916, -24431, -26000,
	-24432, -19917, -13000, -4515, 4514, 12999, 19916, 24431},
	{
// Carrier 6 Phase 5
	24020, 19169, 12005, 3393, -5627, -13969, -20627, -24796,
	-25975, -24020, -19169, -12005, -3393, 5627, 13969, 20627,
	24796, 25975, 24020, 19169, 12005, 3393, -5627, -13969,
	-20627, -24796, -25975, -24020, -19169, -12005, -3393, 5627,
	13969, 20627, 24796, 25975, 24020, 19169, 12005, 3393,
	-5627, -13969, -20627, -24796, -25975, -24020, -19169, -12005,
	-3393, 5627, 13969, 20627, 24796, 25975, 24020, 19169,
	12005, 3393, -5627, -13969, -20627, -24796, -25975, -24020,
	-19169, -12005, -3393, 5627, 13969, 20627, 24796, 25975,
	24020, 19169, 12005, 3393, -5627, -13969, -20627, -24796,
	-25975, -24020, -19169, -12005, -3393, 5627, 13969, 20627,
	24796, 25975, 24020, 19169, 12005, 3393, -5627, -13969,
	-20627, -24796, -25975, -24020, -19169, -12005, -3393, 5627,
	13969, 20627, 24796, 25975, 24020, 19169, 12005, 3393,
	-5627, -13969, -20627, -24796, -25975, -24020, -19169, -12005,
	-3393, 5627, 13969, 20627, 24796, 25975, 24020, 19169,
	12005, 3393, -5627, -13969, -20627, -24796, -25975, -24020,
	-19169, -12005, -3393, 5627, 13969, 20627, 24796, 25975,
	24020, 19169, 12005, 3393, -5627, -13969, -20627, -24796,
	-25975, -24020, -19169, -12005, -3393, 5627, 13969, 20627,
	24796, 25975, 24020, 19169, 12005, 3393, -5627, -13969,
	-20627, -24796, -25975, -24020, -19169, -12005, -3393, 5627,
	13969, 20627, 24796, 25975, 24020, 19169, 12005, 3393,
	-5627, -13969, -20627, -24796, -25975, -24020, -19169, -12005,
	-3393, 5627, 13969, 20627, 24796, 25975, 24020, 19169,
	12005, 3393, -5627, -13969, -20627, -24796, -25975, -24020,
	-19169, -12005, -3393, 5627, 13969, 20627, 24796, 25975},
	{
// Carrier 6 Phase 6
	18384, 10988, 2266, -6729, -14912, -21297, -25114, -25901,
	-23564, -18384, -10988, -2266, 6729, 14912, 21297, 25114,
	25901, 23564, 18384, 10988, 2266, -6729, -14912, -21297,
	-25114, -25901, -23564, -18384, -10988, -2266, 6729, 14912,
	21297, 25114, 25901, 23564, 18384, 10988, 2266, -6729,
	-14912, -21297, -25114, -25901, -23564, -18384, -10988, -2266,
	6729, 14912, 21297, 25114, 25901, 23564, 18384, 10988,
	2266, -6729, -14912, -21297, -25114, -25901, -23564, -18384,
	-10988, -2266, 6729, 14912, 21297, 25114, 25901, 23564,
	18384, 10988, 2266, -6729, -14912, -21297, -25114, -25901,
	-23564, -18384, -10988, -2266, 6729, 14912, 21297, 25114,
	25901, 23564, 18384, 10988, 2266, -6729, -14912, -21297,
	-25114, -25901, -23564, -18384, -10988, -2266, 6729, 14912,
	21297, 25114, 25901, 23564, 18384, 10988, 2266, -6729,
	-14912, -21297, -25114, -25901, -23564, -18384, -10988, -2266,
	6729, 14912, 21297, 25114, 25901, 23564, 18384, 10988,
	2266, -6729, -14912, -21297, -25114, -25901, -23564, -18384,
	-10988, -2266, 6729, 14912, 21297, 25114, 25901, 23564,
	18384, 10988, 2266, -6729, -14912, -21297, -25114, -25901,
	-23564, -18384, -10988, -2266, 6729, 14912, 21297, 25114,
	25901, 23564, 18384, 10988, 2266, -6729, -14912, -21297,
	-25114, -25901, -23564, -18384, -10988, -2266, 6729, 14912,
	21297, 25114, 25901, 23564, 18384, 10988, 2266, -6729,
	-14912, -21297, -25114, -25901, -23564, -18384, -10988, -2266,
	6729, 14912, 21297, 25114, 25901, 23564, 18384, 10988,
	2266, -6729, -14912, -21297, -25113, -25901, -23564, -18384,
	-10988, -2266, 6729, 14912, 21297, 25113, 25901, 23564},
	{
// Carrier 6 Phase 7
	9949, 1134, -7818, -15827, -21928, -25383, -25777, -23062,
	-17565, -9949, -1134, 7818, 15827, 21928, 25383, 25777,
	23062, 17565, 9949, 1134, -7818, -15827, -21928, -25383,
	-25777, -23062, -17565, -9949, -1134, 7818, 15827, 21928,
	25383, 25777, 23062, 17565, 9949, 1134, -7818, -15827,
	-21928, -25383, -25777, -23062, -17565, -9949, -1134, 7818,
	15827, 21928, 25383, 25777, 23062, 17565, 9949, 1134,
	-7818, -15827, -21928, -25383, -25777, -23062, -17565, -9949,
	-1134, 7818, 15827, 21928, 25383, 25777, 23062, 17565,
	9949, 1134, -7818, -15827, -21928, -25383, -25777, -23062,
	-17565, -9949, -1134, 7818, 15827, 21928, 25383, 25777,
	23062, 17565, 9949, 1134, -7818, -15827, -21928, -25383,
	-25777, -23062, -17565, -9949, -1134, 7818, 15827, 21928,
	25383, 25777, 23062, 17565, 9949, 1134, -7818, -15827,
	-21928, -25383, -25777, -23062, -17565, -9949, -1134, 7818,
	15827, 21928, 25383, 25777, 23062, 17565, 9949, 1134,
	-7818, -15827, -21928, -25383, -25777, -23062, -17565, -9949,
	-1134, 7818, 15827, 21928, 25383, 25777, 23062, 17565,
	9949, 1134, -7818, -15827, -21928, -25383, -25777, -23062,
	-17565, -9949, -1134, 7818, 15827, 21928, 25383, 25777,
	23062, 17565, 9949, 1134, -7818, -15827, -21928, -25383,
	-25777, -23062, -17565, -9949, -1134, 7818, 15827, 21928,
	25383, 25777, 23062, 17565, 9949, 1134, -7818, -15827,
	-21928, -25383, -25777, -23062, -17565, -9950, -1134, 7818,
	15827, 21928, 25383, 25777, 23062, 17565, 9950, 1134,
	-7818, -15827, -21928, -25383, -25777, -23062, -17565, -9950,
	-1134, 7818, 15827, 21928, 25383, 25777, 23062, 17565},
	},{{

// Carrier 7 Phase 0
	0, 9599, 17842, 23564, 25956, 24680, 19917, 12339,
	3018, -6729, -15526, -22129, -25605, -25462, -21722, -14912,
	-5996, 3768, 13000, 20394, 24907, 25901, 23234, 17284,
	8892, -756, -10298, -18384, -23873, -25989, -24431, -19422,
	-11668, -2266, 7456, 16126, 22516, 25725, 25299, 21297,
	14287, 5257, -4514, -13649, -20855, -25114, -25824, -22885,
	-16712, -8178, 1511, 10988, 18911, 24163, 26000, 24163,
	18911, 10988, 1511, -8178, -16712, -22885, -25824, -25114,
	-20855, -13649, -4514, 5257, 14287, 21298, 25299, 25725,
	22516, 16126, 7456, -2266, -11668, -19422, -24432, -25988,
	-23873, -18384, -10297, -756, 8892, 17284, 23234, 25901,
	24907, 20394, 12999, 3768, -5996, -14913, -21722, -25462,
	-25604, -22128, -15526, -6729, 3018, 12339, 19917, 24680,
	25956, 23563, 17842, 9599, 0, -9599, -17842, -23564,
	-25956, -24680, -19917, -12339, -3018, 6729, 15526, 22129,
	25605, 25462, 21722, 14912, 5995, -3768, -13000, -20394,
	-24907, -25901, -23234, -17284, -8892, 756, 10298, 18384,
	23873, 25989, 24431, 19422, 11668, 2265, -7457, -16126,
	-22516, -25725, -25299, -21297, -14287, -5257, 4515, 13649,
	20855, 25114, 25824, 22885, 16712, 8177, -1512, -10988,
	-18911, -24163, -26000, -24162, -18911, -10987, -1511, 8178,
	16712, 22885, 25824, 25113, 20855, 13649, 4514, -5257,
	-14287, -21298, -25299, -25725, -22516, -16125, -7456, 2266,
	11669, 19422, 24432, 25988, 23873, 18384, 10297, 755,
	-8892, -17284, -23234, -25901, -24907, -20394, -12999, -3767,
	5996, 14913, 21722, 25462, 25604, 22128, 15525, 6728,
	-3018, -12339, -19917, -24680, -25955, -23563, -17842, -9599},
	{
// Carrier 7 Phase 1
	9949, 18115, 23721, 25975, 24558, 19671, 12005, 2642,
	-7093, -15827, -22325, -25667, -25383, -21512, -14601, -5627,
	4142, 13326, 20627, 25013, 25865, 23062, 17000, 8536,
	-1134, -10644, -18650, -24020, -25997, -24300, -19169, -11329,
	-1889, 7818, 16421, 22703, 25777, 25209, 21078, 13969,
	4886, -4886, -13969, -21078, -25209, -25777, -22703, -16420,
	-7818, 1889, 11329, 19169, 24300, 25997, 24020, 18650,
	10644, 1134, -8536, -17000, -23062, -25865, -25013, -20627,
	-13326, -4141, 5627, 14601, 21512, 25383, 25667, 22325,
	15827, 7093, -2642, -12005, -19672, -24558, -25975, -23721,
	-18115, -9949, -378, 9247, 17565, 23401, 25931, 24796,
	20158, 12671, 3393, -6363, -15221, -21928, -25536, -25536,
	-21928, -15221, -6363, 3393, 12671, 20158, 24796, 25931,
	23401, 17565, 9246, -378, -9949, -18115, -23721, -25975,
	-24558, -19671, -12005, -2642, 7094, 15827, 22325, 25667,
	25383, 21512, 14601, 5627, -4142, -13326, -20627, -25013,
	-25865, -23062, -17000, -8536, 1134, 10644, 18650, 24020,
	25997, 24300, 19169, 11329, 1888, -7818, -16421, -22703,
	-25777, -25209, -21078, -13969, -4886, 4887, 13969, 21078,
	25209, 25777, 22703, 16420, 7818, -1889, -11329, -19169,
	-24300, -25997, -24020, -18650, -10643, -1133, 8536, 17000,
	23062, 25865, 25013, 20627, 13325, 4141, -5627, -14601,
	-21512, -25383, -25667, -22325, -15827, -7093, 2642, 12005,
	19672, 24558, 25975, 23721, 18115, 9949, 377, -9247,
	-17565, -23401, -25931, -24796, -20157, -12670, -3393, 6363,
	15221, 21928, 25536, 25536, 21928, 15220, 6363, -3394,
	-12671, -20158, -24796, -25931, -23401, -17565, -9246, 378},
	{
// Carrier 7 Phase 2
	18384, 23873, 25989, 24432, 19422, 11668, 2266, -7456,
	-16126, -22516, -25725, -25299, -21297, -14287, -5257, 4514,
	13649, 20855, 25114, 25824, 22885, 16712, 8178, -1511,
	-10988, -18911, -24163, -26000, -24163, -18911, -10988, -1511,
	8178, 16712, 22885, 25824, 25114, 20855, 13649, 4514,
	-5257, -14287, -21297, -25299, -25725, -22516, -16126, -7456,
	2266, 11668, 19422, 24432, 25988, 23873, 18384, 10298,
	756, -8892, -17284, -23234, -25901, -24907, -20394, -12999,
	-3768, 5996, 14913, 21722, 25462, 25604, 22128, 15526,
	6729, -3018, -12339, -19917, -24680, -25956, -23563, -17842,
	-9599, 0, 9599, 17842, 23564, 25956, 24680, 19917,
	12339, 3018, -6729, -15526, -22129, -25605, -25462, -21722,
	-14912, -5995, 3768, 13000, 20394, 24907, 25901, 23234,
	17284, 8892, -756, -10298, -18384, -23873, -25989, -24431,
	-19422, -11668, -2265, 7457, 16126, 22516, 25725, 25299,
	21297, 14287, 5257, -4515, -13649, -20855, -25114, -25824,
	-22885, -16712, -8177, 1511, 10988, 18911, 24163, 26000,
	24162, 18911, 10987, 1511, -8178, -16712, -22885, -25824,
	-25114, -20855, -13649, -4514, 5257, 14287, 21298, 25299,
	25725, 22516, 16125, 7456, -2266, -11668, -19422, -24432,
	-25988, -23873, -18384, -10297, -755, 8892, 17284, 23234,
	25901, 24907, 20394, 12999, 3767, -5996, -14913, -21722,
	-25462, -25604, -22128, -15525, -6729, 3018, 12339, 19917,
	24680, 25955, 23563, 17842, 9599, 0, -9599, -17842,
	-23564, -25956, -24680, -19916, -12339, -3018, 6729, 15526,
	22129, 25605, 25462, 21722, 14912, 5995, -3768, -13000,
	-20395, -24907, -25901, -23234, -17284, -8892, 756, 10298},
	{
// Carrier 7 Phase 3
	24020, 25997, 24300, 19169, 11329, 1889, -7818, -16421,
	-22703, -25777, -25209, -21078, -13969, -4886, 4886, 13969,
	21078, 25209, 25777, 22703, 16421, 7818, -1889, -11329,
	-19169, -24300, -25997, -24020, -18650, -10644, -1134, 8536,
	17000, 23062, 25865, 25013, 20627, 13326, 4141, -5627,
	-14601, -21512, -25383, -25667, -22325, -15827, -7093, 2642,
	12005, 19672, 24558, 25975, 23721, 18115, 9949, 378,
	-9246, -17565, -23401, -25931, -24796, -20158, -12671, -3393,
	6363, 15221, 21928, 25536, 25536, 21928, 15221, 6363,
	-3393, -12671, -20158, -24796, -25931, -23401, -17565, -9246,
	378, 9949, 18115, 23721, 25975, 24558, 19671, 12005,
	2642, -7093, -15827, -22325, -25667, -25383, -21512, -14601,
	-5627, 4142, 13326, 20627, 25013, 25865, 23062, 17000,
	8536, -1134, -10644, -18650, -24020, -25997, -24300, -19169,
	-11329, -1888, 7818, 16421, 22703, 25777, 25209, 21078,
	13969, 4886, -4886, -13969, -21078, -25209, -25777, -22703,
	-16420, -7818, 1889, 11329, 19169, 24300, 25997, 24020,
	18650, 10644, 1133, -8536, -17000, -23062, -25865, -25013,
	-20627, -13325, -4141, 5627, 14601, 21512, 25383, 25667,
	22325, 15827, 7093, -2642, -12005, -19672, -24558, -25975,
	-23721, -18115, -9949, -377, 9247, 17565, 23401, 25931,
	24796, 20157, 12670, 3393, -6363, -15221, -21928, -25536,
	-25536, -21928, -15220, -6363, 3393, 12671, 20158, 24796,
	25931, 23401, 17565, 9246, -378, -9950, -18115, -23721,
	-25975, -24558, -19671, -12005, -2642, 7094, 15828, 22325,
	25668, 25383, 21512, 14601, 5627, -4142, -13326, -20627,
	-25013, -25865, -23062, -17000, -8535, 1134, 10644, 18650},
	{
// Carrier 7 Phase 4
	26000, 24163, 18911, 10988, 1511, -8178, -16712, -22885,
	-25824, -25114, -20855, -13649, -4514, 5257, 14287, 21297,
	25299, 25725, 22516, 16126, 7456, -2266, -11668, -19422,
	-24432, -25989, -23873, -18384, -10298, -756, 8892, 17284,
	23234, 25901, 24907, 20394, 12999, 3768, -5996, -14913,
	-21722, -25462, -25604, -22128, -15526, -6729, 3018, 12339,
	19917, 24680, 25956, 23563, 17842, 9599, 0, -9599,
	-17842, -23564, -25956, -24680, -19917, -12339, -3018, 6729,
	15526, 22129, 25605, 25462, 21722, 14912, 5995, -3768,
	-13000, -20394, -24907, -25901, -23234, -17284, -8892, 756,
	10298, 18384, 23873, 25989, 24431, 19422, 11668, 2265,
	-7457, -16126, -22516, -25725, -25299, -21297, -14287, -5257,
	4515, 13649, 20855, 25114, 25824, 22885, 16712, 8177,
	-1511, -10988, -18911, -24163, -26000, -24162, -18911, -10987,
	-1511, 8178, 16712, 22885, 25824, 25114, 20855, 13649,
	4514, -5257, -14287, -21298, -25299, -25725, -22516, -16125,
	-7456, 2266, 11668, 19422, 24432, 25988, 23873, 18384,
	10297, 755, -8892, -17284, -23234, -25901, -24907, -20394,
	-12999, -3767, 5996, 14913, 21722, 25462, 25604, 22128,
	15525, 6729, -3018, -12339, -19917, -24680, -25955, -23563,
	-17842, -9599, 0, 9599, 17842, 23564, 25956, 24680,
	19916, 12339, 3018, -6729, -15526, -22129, -25605, -25462,
	-21722, -14912, -5995, 3768, 13000, 20394, 24907, 25901,
	23234, 17284, 8892, -756, -10298, -18384, -23873, -25989,
	-24431, -19422, -11668, -2265, 7457, 16126, 22516, 25725,
	25299, 21297, 14286, 5257, -4515, -13649, -20855, -25114,
	-25824, -22885, -16712, -8177, 1512, 10988, 18911, 24163},
	{
// Carrier 7 Phase 5
	24020, 18650, 10644, 1134, -8536, -17000, -23062, -25865,
	-25013, -20627, -13326, -4141, 5627, 14601, 21512, 25383,
	25667, 22325, 15827, 7093, -2642, -12005, -19672, -24558,
	-25975, -23721, -18115, -9949, -378, 9246, 17565, 23401,
	25931, 24796, 20158, 12671, 3393, -6363, -15221, -21928,
	-25536, -25536, -21928, -15221, -6363, 3393, 12671, 20158,
	24796, 25931, 23401, 17565, 9246, -378, -9949, -18115,
	-23721, -25975, -24558, -19671, -12005, -2642, 7093, 15827,
	22325, 25667, 25383, 21512, 14601, 5627, -4142, -13326,
	-20627, -25013, -25865, -23062, -17000, -8536, 1134, 10644,
	18650, 24020, 25997, 24300, 19169, 11329, 1888, -7818,
	-16421, -22703, -25777, -25209, -21078, -13969, -4886, 4886,
	13969, 21078, 25209, 25777, 22703, 16420, 7818, -1889,
	-11329, -19169, -24300, -25997, -24020, -18650, -10644, -1133,
	8536, 17000, 23062, 25865, 25013, 20627, 13325, 4141,
	-5627, -14601, -21512, -25383, -25667, -22325, -15827, -7093,
	2642, 12005, 19672, 24558, 25975, 23721, 18115, 9949,
	377, -9247, -17565, -23401, -25931, -24796, -20157, -12670,
	-3393, 6363, 15221, 21928, 25536, 25536, 21928, 15220,
	6363, -3393, -12671, -20158, -24796, -25931, -23401, -17565,
	-9246, 378, 9950, 18115, 23721, 25975, 24558, 19671,
	12005, 2642, -7094, -15828, -22325, -25668, -25383, -21512,
	-14601, -5627, 4142, 13326, 20627, 25013, 25865, 23062,
	17000, 8535, -1134, -10644, -18650, -24020, -25997, -24299,
	-19168, -11329, -1888, 7818, 16421, 22703, 25777, 25209,
	21078, 13969, 4886, -4887, -13970, -21079, -25209, -25777,
	-22703, -16420, -7818, 1889, 11329, 19169, 24300, 25997},
	{
// Carrier 7 Phase 6
	18384, 10298, 756, -8892, -17284, -23234, -25901, -24907,
	-20394, -12999, -3768, 5996, 14913, 21722, 25462, 25604,
	22129, 15526, 6729, -3018, -12339, -19917, -24680, -25956,
	-23563, -17842, -9599, 0, 9599, 17842, 23564, 25956,
	24680, 19917, 12339, 3018, -6729, -15526, -22129, -25605,
	-25462, -21722, -14912, -5995, 3768, 13000, 20394, 24907,
	25901, 23234, 17284, 8892, -756, -10298, -18384, -23873,
	-25989, -24431, -19422, -11668, -2265, 7456, 16126, 22516,
	25725, 25299, 21297, 14287, 5257, -4514, -13649, -20855,
	-25114, -25824, -22885, -16712, -8178, 1511, 10988, 18911,
	24163, 26000, 24162, 18911, 10987, 1511, -8178, -16712,
	-22885, -25824, -25114, -20855, -13649, -4514, 5257, 14287,
	21298, 25299, 25725, 22516, 16125, 7456, -2266, -11668,
	-19422, -24432, -25988, -23873, -18384, -10297, -756, 8892,
	17284, 23234, 25901, 24907, 20394, 12999, 3768, -5996,
	-14913, -21722, -25462, -25604, -22128, -15525, -6729, 3018,
	12339, 19917, 24680, 25955, 23563, 17842, 9599, 0,
	-9599, -17842, -23564, -25956, -24680, -19916, -12339, -3018,
	6729, 15526, 22129, 25605, 25462, 21722, 14912, 5995,
	-3768, -13000, -20394, -24907, -25901, -23234, -17284, -8892,
	756, 10298, 18384, 23873, 25989, 24431, 19422, 11668,
	2265, -7457, -16126, -22516, -25725, -25299, -21297, -14286,
	-5257, 4515, 13649, 20855, 25114, 25824, 22885, 16712,
	8177, -1512, -10988, -18911, -24163, -26000, -24162, -18911,
	-10987, -1511, 8178, 16712, 22885, 25824, 25113, 20854,
	13649, 4514, -5257, -14287, -21298, -25299, -25725, -22516,
	-16125, -7456, 2266, 11669, 19422, 24432, 25988, 23873},
	{
// Carrier 7 Phase 7
	9949, 378, -9246, -17565, -23401, -25931, -24796, -20158,
	-12671, -3393, 6363, 15221, 21928, 25536, 25536, 21928,
	15221, 6363, -3393, -12671, -20158, -24796, -25931, -23401,
	-17565, -9246, 378, 9949, 18115, 23721, 25975, 24558,
	19671, 12005, 2642, -7093, -15827, -22325, -25667, -25383,
	-21512, -14601, -5627, 4142, 13326, 20627, 25013, 25865,
	23062, 17000, 8536, -1134, -10644, -18650, -24020, -25997,
	-24300, -19169, -11329, -1889, 7818, 16421, 22703, 25777,
	25209, 21078, 13969, 4886, -4886, -13969, -21078, -25209,
	-25777, -22703, -16420, -7818, 1889, 11329, 19169, 24300,
	25997, 24020, 18650, 10644, 1133, -8536, -17000, -23062,
	-25865, -25013, -20627, -13325, -4141, 5627, 14601, 21512,
	25383, 25667, 22325, 15827, 7093, -2642, -12005, -19672,
	-24558, -25975, -23721, -18115, -9949, -377, 9247, 17565,
	23401, 25931, 24796, 20157, 12670, 3393, -6363, -15221,
	-21928, -25536, -25536, -21928, -15220, -6363, 3393, 12671,
	20158, 24796, 25931, 23401, 17565, 9246, -378, -9949,
	-18115, -23721, -25975, -24558, -19671, -12005, -2642, 7094,
	15827, 22325, 25667, 25383, 21512, 14601, 5627, -4142,
	-13326, -20627, -25013, -25865, -23062, -17000, -8535, 1134,
	10644, 18650, 24020, 25997, 24299, 19169, 11329, 1888,
	-7818, -16421, -22703, -25777, -25209, -21078, -13969, -4886,
	4887, 13970, 21078, 25209, 25777, 22703, 16420, 7818,
	-1889, -11329, -19169, -24300, -25997, -24020, -18649, -10643,
	-1133, 8536, 17000, 23062, 25865, 25013, 20626, 13325,
	4141, -5627, -14601, -21512, -25383, -25667, -22325, -15827,
	-7093, 2642, 12005, 19672, 24558, 25975, 23721, 18115},
	},{{

// Carrier 8 Phase 0
	0, 10298, 18911, 24432, 25956, 23234, 16712, 7456,
	-3018, -12999, -20855, -25299, -25605, -21722, -14287, -4514,
	5995, 15526, 22516, 25824, 24907, 19917, 11668, 1511,
	-8892, -17842, -23873, -26000, -23873, -17842, -8892, 1511,
	11668, 19917, 24907, 25824, 22516, 15526, 5996, -4514,
	-14287, -21722, -25604, -25299, -20855, -13000, -3018, 7456,
	16712, 23234, 25956, 24432, 18911, 10298, 0, -10297,
	-18911, -24431, -25956, -23234, -16712, -7457, 3018, 12999,
	20855, 25299, 25605, 21722, 14287, 4514, -5995, -15526,
	-22516, -25824, -24907, -19917, -11668, -1511, 8892, 17842,
	23873, 26000, 23873, 17842, 8892, -1511, -11668, -19917,
	-24907, -25824, -22516, -15526, -5996, 4514, 14287, 21722,
	25604, 25299, 20855, 13000, 3018, -7456, -16712, -23234,
	-25956, -24432, -18911, -10298, 0, 10297, 18911, 24431,
	25956, 23234, 16712, 7457, -3018, -12999, -20855, -25299,
	-25605, -21722, -14287, -4515, 5995, 15525, 22516, 25824,
	24907, 19917, 11669, 1512, -8892, -17842, -23873, -26000,
	-23873, -17842, -8892, 1511, 11668, 19916, 24907, 25824,
	22516, 15526, 5996, -4514, -14286, -21722, -25604, -25299,
	-20855, -13000, -3018, 7456, 16712, 23234, 25955, 24432,
	18911, 10298, 0, -10297, -18911, -24431, -25956, -23234,
	-16712, -7457, 3018, 12999, 20854, 25299, 25605, 21722,
	14287, 4515, -5995, -15525, -22516, -25824, -24907, -19917,
	-11669, -1512, 8892, 17842, 23873, 26000, 23873, 17842,
	8892, -1511, -11668, -19916, -24907, -25824, -22516, -15526,
	-5996, 4514, 14286, 21722, 25604, 25299, 20855, 13000,
	3018, -7456, -16712, -23234, -25955, -24432, -18912, -10298},
	{
// Carrier 8 Phase 1
	9949, 18650, 24300, 25975, 23401, 17000, 7818, -2642,
	-12671, -20627, -25209, -25667, -21928, -14601, -4886, 5627,
	15221, 22325, 25777, 25013, 20158, 12005, 1889, -8536,
	-17565, -23721, -25997, -24020, -18115, -9246, 1134, 11329,
	19671, 24796, 25865, 22703, 15827, 6363, -4141, -13969,
	-21512, -25536, -25383, -21078, -13326, -3393, 7093, 16420,
	23062, 25931, 24558, 19169, 10644, 378, -9949, -18650,
	-24300, -25975, -23401, -17000, -7818, 2642, 12671, 20627,
	25209, 25667, 21928, 14601, 4886, -5627, -15221, -22325,
	-25777, -25013, -20158, -12005, -1889, 8536, 17565, 23721,
	25997, 24020, 18115, 9247, -1133, -11329, -19671, -24796,
	-25865, -22703, -15827, -6363, 4141, 13969, 21512, 25536,
	25383, 21078, 13326, 3393, -7093, -16420, -23062, -25931,
	-24558, -19169, -10644, -378, 9949, 18650, 24300, 25975,
	23401, 17000, 7818, -2642, -12670, -20627, -25209, -25667,
	-21928, -14601, -4887, 5627, 15220, 22325, 25777, 25013,
	20158, 12005, 1889, -8536, -17565, -23721, -25997, -24020,
	-18115, -9247, 1133, 11329, 19671, 24796, 25865, 22703,
	15828, 6363, -4141, -13969, -21512, -25536, -25383, -21078,
	-13326, -3393, 7093, 16420, 23062, 25931, 24558, 19169,
	10644, 378, -9949, -18650, -24299, -25975, -23401, -17000,
	-7818, 2642, 12670, 20626, 25209, 25668, 21928, 14601,
	4887, -5627, -15220, -22325, -25777, -25013, -20158, -12005,
	-1889, 8535, 17565, 23721, 25997, 24021, 18115, 9247,
	-1133, -11329, -19671, -24796, -25865, -22703, -15828, -6363,
	4141, 13969, 21512, 25536, 25383, 21079, 13326, 3394,
	-7093, -16420, -23062, -25931, -24558, -19169, -10644, -378},
	{
// Carrier 8 Phase 2
	18384, 24163, 25989, 23564, 17284, 8178, -2266, -12339,
	-20394, -25114, -25725, -22129, -14913, -5257, 5257, 14912,
	22129, 25725, 25114, 20394, 12339, 2266, -8178, -17284,
	-23563, -25989, -24163, -18384, -9599, 756, 10988, 19422,
	24680, 25901, 22885, 16126, 6729, -3768, -13649, -21297,
	-25462, -25462, -21298, -13649, -3768, 6729, 16126, 22885,
	25901, 24680, 19422, 10988, 756, -9599, -18384, -24162,
	-25989, -23564, -17284, -8178, 2265, 12339, 20394, 25114,
	25725, 22129, 14913, 5257, -5257, -14912, -22128, -25725,
	-25114, -20394, -12339, -2266, 8178, 17284, 23563, 25988,
	24163, 18384, 9599, -756, -10987, -19422, -24680, -25901,
	-22885, -16126, -6729, 3768, 13649, 21297, 25462, 25462,
	21298, 13649, 3768, -6729, -16125, -22885, -25901, -24680,
	-19422, -10988, -756, 9599, 18384, 24162, 25989, 23564,
	17284, 8178, -2265, -12339, -20394, -25114, -25725, -22129,
	-14913, -5257, 5257, 14912, 22128, 25725, 25114, 20394,
	12339, 2266, -8177, -17284, -23563, -25988, -24163, -18384,
	-9599, 755, 10987, 19422, 24680, 25901, 22885, 16126,
	6729, -3767, -13649, -21297, -25462, -25462, -21298, -13649,
	-3768, 6728, 16125, 22885, 25901, 24680, 19422, 10988,
	756, -9599, -18384, -24162, -25989, -23564, -17284, -8178,
	2265, 12339, 20394, 25113, 25725, 22129, 14913, 5258,
	-5257, -14912, -22128, -25725, -25114, -20395, -12339, -2266,
	8177, 17284, 23563, 25988, 24163, 18385, 9599, -755,
	-10987, -19422, -24680, -25901, -22885, -16126, -6729, 3767,
	13649, 21297, 25462, 25462, 21298, 13649, 3768, -6728,
	-16125, -22885, -25901, -24680, -19422, -10988, -756, 9598},
	{
// Carrier 8 Phase 3
	24020, 25997, 23721, 17565, 8536, -1889, -12005, -20158,
	-25013, -25777, -22325, -15221, -5627, 4886, 14601, 21928,
	25667, 25209, 20627, 12671, 2642, -7818, -17000, -23401,
	-25975, -24300, -18650, -9949, 378, 10644, 19169, 24558,
	25931, 23062, 16421, 7093, -3393, -13326, -21078, -25383,
	-25536, -21512, -13969, -4142, 6363, 15827, 22703, 25865,
	24796, 19672, 11329, 1134, -9246, -18115, -24020, -25997,
	-23721, -17565, -8536, 1888, 12005, 20158, 25013, 25777,
	22325, 15221, 5627, -4886, -14601, -21928, -25667, -25209,
	-20627, -12671, -2642, 7818, 17000, 23401, 25975, 24300,
	18650, 9949, -377, -10644, -19169, -24558, -25931, -23062,
	-16421, -7094, 3393, 13325, 21078, 25383, 25536, 21512,
	13969, 4142, -6363, -15827, -22703, -25865, -24796, -19672,
	-11329, -1134, 9246, 18115, 24020, 25997, 23721, 17565,
	8536, -1888, -12005, -20157, -25013, -25777, -22325, -15221,
	-5627, 4886, 14601, 21928, 25667, 25209, 20627, 12671,
	2642, -7818, -17000, -23401, -25975, -24300, -18650, -9950,
	377, 10643, 19169, 24558, 25931, 23062, 16421, 7094,
	-3393, -13325, -21078, -25383, -25536, -21512, -13970, -4142,
	6363, 15827, 22703, 25865, 24796, 19672, 11329, 1134,
	-9246, -18115, -24020, -25997, -23721, -17565, -8536, 1888,
	12005, 20157, 25013, 25777, 22325, 15221, 5627, -4886,
	-14601, -21927, -25667, -25209, -20627, -12671, -2642, 7817,
	17000, 23401, 25975, 24300, 18650, 9950, -377, -10643,
	-19168, -24558, -25931, -23062, -16421, -7094, 3393, 13325,
	21078, 25383, 25536, 21512, 13970, 4142, -6362, -15827,
	-22703, -25865, -24796, -19672, -11330, -1134, 9246, 18115},
	{
// Carrier 8 Phase 4
	26000, 23873, 17842, 8892, -1511, -11668, -19917, -24907,
	-25824, -22516, -15526, -5996, 4514, 14287, 21722, 25604,
	25299, 20855, 13000, 3018, -7456, -16712, -23234, -25956,
	-24432, -18911, -10298, 0, 10298, 18911, 24431, 25956,
	23234, 16712, 7456, -3018, -12999, -20855, -25299, -25605,
	-21722, -14287, -4514, 5995, 15526, 22516, 25824, 24907,
	19917, 11668, 1511, -8892, -17842, -23873, -26000, -23873,
	-17842, -8892, 1511, 11668, 19917, 24907, 25824, 22516,
	15526, 5996, -4514, -14287, -21722, -25604, -25299, -20855,
	-13000, -3018, 7456, 16712, 23234, 25956, 24432, 18911,
	10298, 0, -10297, -18911, -24431, -25956, -23234, -16712,
	-7457, 3018, 12999, 20855, 25299, 25605, 21722, 14287,
	4515, -5995, -15525, -22516, -25824, -24907, -19917, -11668,
	-1511, 8892, 17842, 23873, 26000, 23873, 17842, 8892,
	-1511, -11668, -19917, -24907, -25824, -22516, -15526, -5996,
	4514, 14287, 21722, 25604, 25299, 20855, 13000, 3018,
	-7456, -16712, -23234, -25955, -24432, -18911, -10298, 0,
	10297, 18911, 24431, 25956, 23234, 16712, 7457, -3018,
	-12999, -20855, -25299, -25605, -21722, -14287, -4515, 5995,
	15525, 22516, 25824, 24907, 19917, 11669, 1512, -8892,
	-17842, -23873, -26000, -23873, -17842, -8892, 1511, 11668,
	19916, 24907, 25824, 22516, 15526, 5996, -4514, -14286,
	-21722, -25604, -25299, -20855, -13000, -3018, 7456, 16712,
	23234, 25955, 24432, 18911, 10298, 0, -10297, -18911,
	-24431, -25956, -23234, -16712, -7457, 3018, 12999, 20854,
	25299, 25605, 21722, 14287, 4515, -5995, -15525, -22516,
	-25824, -24907, -19917, -11669, -1512, 8892, 17841, 23873},
	{
// Carrier 8 Phase 5
	24020, 18115, 9246, -1134, -11329, -19671, -24796, -25865,
	-22703, -15827, -6363, 4141, 13969, 21512, 25536, 25383,
	21078, 13326, 3393, -7093, -16421, -23062, -25931, -24558,
	-19169, -10644, -378, 9949, 18650, 24300, 25975, 23401,
	17000, 7818, -2642, -12671, -20627, -25209, -25667, -21928,
	-14601, -4886, 5627, 15221, 22325, 25777, 25013, 20158,
	12005, 1889, -8536, -17565, -23721, -25997, -24020, -18115,
	-9247, 1133, 11329, 19671, 24796, 25865, 22703, 15827,
	6363, -4141, -13969, -21512, -25536, -25383, -21078, -13326,
	-3393, 7093, 16420, 23062, 25931, 24558, 19169, 10644,
	378, -9949, -18650, -24300, -25975, -23401, -17000, -7818,
	2642, 12670, 20627, 25209, 25667, 21928, 14601, 4886,
	-5627, -15221, -22325, -25777, -25013, -20158, -12005, -1889,
	8536, 17565, 23721, 25997, 24020, 18115, 9247, -1133,
	-11329, -19671, -24796, -25865, -22703, -15827, -6363, 4141,
	13969, 21512, 25536, 25383, 21078, 13326, 3393, -7093,
	-16420, -23062, -25931, -24558, -19169, -10644, -378, 9949,
	18650, 24299, 25975, 23401, 17000, 7818, -2642, -12670,
	-20627, -25209, -25668, -21928, -14601, -4887, 5627, 15220,
	22325, 25777, 25013, 20158, 12005, 1889, -8535, -17565,
	-23721, -25997, -24020, -18115, -9247, 1133, 11329, 19671,
	24796, 25865, 22703, 15828, 6363, -4141, -13969, -21512,
	-25536, -25383, -21079, -13326, -3394, 7093, 16420, 23062,
	25931, 24558, 19169, 10644, 378, -9949, -18649, -24299,
	-25975, -23401, -17000, -7818, 2642, 12670, 20626, 25209,
	25668, 21928, 14601, 4887, -5627, -15220, -22325, -25777,
	-25013, -20158, -12005, -1889, 8535, 17565, 23721, 25997},
	{
// Carrier 8 Phase 6
	18384, 9599, -756, -10988, -19422, -24680, -25901, -22885,
	-16126, -6729, 3768, 13649, 21297, 25462, 25462, 21297,
	13649, 3768, -6729, -16126, -22885, -25901, -24680, -19422,
	-10988, -756, 9599, 18384, 24163, 25989, 23564, 17284,
	8178, -2265, -12339, -20394, -25114, -25725, -22129, -14913,
	-5257, 5257, 14912, 22128, 25725, 25114, 20394, 12339,
	2266, -8178, -17284, -23563, -25988, -24163, -18384, -9599,
	756, 10987, 19422, 24680, 25901, 22885, 16126, 6729,
	-3768, -13649, -21297, -25462, -25462, -21298, -13649, -3768,
	6729, 16125, 22885, 25901, 24680, 19422, 10988, 756,
	-9599, -18384, -24162, -25989, -23564, -17284, -8178, 2265,
	12339, 20394, 25114, 25725, 22129, 14913, 5257, -5257,
	-14912, -22128, -25725, -25114, -20394, -12339, -2266, 8177,
	17284, 23563, 25988, 24163, 18384, 9599, -755, -10987,
	-19422, -24680, -25901, -22885, -16126, -6729, 3767, 13649,
	21297, 25462, 25462, 21298, 13649, 3768, -6729, -16125,
	-22885, -25901, -24680, -19422, -10988, -756, 9599, 18384,
	24162, 25989, 23564, 17284, 8178, -2265, -12339, -20394,
	-25113, -25725, -22129, -14913, -5257, 5257, 14912, 22128,
	25725, 25114, 20395, 12339, 2266, -8177, -17284, -23563,
	-25988, -24163, -18385, -9599, 755, 10987, 19422, 24680,
	25901, 22885, 16126, 6729, -3767, -13649, -21297, -25462,
	-25462, -21298, -13649, -3768, 6728, 16125, 22885, 25901,
	24680, 19422, 10988, 756, -9599, -18384, -24162, -25989,
	-23564, -17284, -8178, 2265, 12339, 20394, 25113, 25725,
	22129, 14913, 5258, -5257, -14912, -22128, -25725, -25114,
	-20395, -12340, -2266, 8177, 17284, 23563, 25988, 24163},
	{
// Carrier 8 Phase 7
	9949, -378, -10644, -19169, -24558, -25931, -23062, -16421,
	-7093, 3393, 13326, 21078, 25383, 25536, 21512, 13969,
	4142, -6363, -15827, -22703, -25865, -24796, -19672, -11329,
	-1134, 9246, 18115, 24020, 25997, 23721, 17565, 8536,
	-1889, -12005, -20158, -25013, -25777, -22325, -15221, -5627,
	4886, 14601, 21928, 25667, 25209, 20627, 12671, 2642,
	-7818, -17000, -23401, -25975, -24300, -18650, -9949, 378,
	10644, 19169, 24558, 25931, 23062, 16421, 7093, -3393,
	-13325, -21078, -25383, -25536, -21512, -13969, -4142, 6363,
	15827, 22703, 25865, 24796, 19672, 11329, 1134, -9246,
	-18115, -24020, -25997, -23721, -17565, -8536, 1888, 12005,
	20157, 25013, 25777, 22325, 15221, 5627, -4886, -14601,
	-21928, -25667, -25209, -20627, -12671, -2642, 7818, 17000,
	23401, 25975, 24300, 18650, 9949, -377, -10643, -19169,
	-24558, -25931, -23062, -16421, -7094, 3393, 13325, 21078,
	25383, 25536, 21512, 13970, 4142, -6363, -15827, -22703,
	-25865, -24796, -19672, -11329, -1134, 9246, 18115, 24020,
	25997, 23721, 17565, 8536, -1888, -12005, -20157, -25013,
	-25777, -22325, -15221, -5627, 4886, 14601, 21928, 25667,
	25209, 20627, 12671, 2642, -7818, -17000, -23401, -25975,
	-24300, -18650, -9950, 377, 10643, 19168, 24558, 25931,
	23062, 16421, 7094, -3393, -13325, -21078, -25383, -25536,
	-21512, -13970, -4142, 6362, 15827, 22703, 25865, 24796,
	19672, 11329, 1134, -9246, -18115, -24020, -25997, -23721,
	-17565, -8536, 1888, 12005, 20157, 25013, 25777, 22325,
	15221, 5627, -4886, -14601, -21927, -25667, -25209, -20627,
	-12671, -2642, 7817, 17000, 23401, 25975, 24300, 18650},
	},{{

// Carrier 9 Phase 0
	0, 10988, 19917, 25114, 25605, 21297, 13000, 2266,
	-8892, -18384, -24432, -25901, -22516, -14913, -4514, 6729,
	16712, 23563, 26000, 23564, 16712, 6729, -4514, -14912,
	-22516, -25901, -24432, -18384, -8892, 2266, 12999, 21297,
	25604, 25114, 19917, 10988, 0, -10988, -19917, -25114,
	-25605, -21297, -13000, -2266, 8892, 18384, 24431, 25901,
	22516, 14913, 4514, -6729, -16712, -23563, -26000, -23564,
	-16712, -6729, 4514, 14912, 22516, 25901, 24432, 18384,
	8892, -2265, -12999, -21297, -25604, -25114, -19917, -10988,
	0, 10988, 19917, 25114, 25605, 21297, 13000, 2266,
	-8892, -18384, -24431, -25901, -22516, -14913, -4514, 6729,
	16712, 23563, 26000, 23564, 16712, 6729, -4514, -14912,
	-22516, -25901, -24432, -18384, -8892, 2265, 12999, 21297,
	25604, 25114, 19917, 10988, 0, -10987, -19917, -25114,
	-25605, -21298, -13000, -2266, 8892, 18384, 24431, 25901,
	22516, 14913, 4514, -6729, -16712, -23563, -26000, -23564,
	-16712, -6729, 4514, 14912, 22516, 25901, 24432, 18384,
	8892, -2265, -12999, -21297, -25604, -25114, -19917, -10988,
	0, 10987, 19917, 25114, 25605, 21298, 13000, 2266,
	-8892, -18384, -24431, -25901, -22516, -14913, -4514, 6729,
	16712, 23563, 26000, 23564, 16712, 6729, -4514, -14912,
	-22516, -25901, -24432, -18384, -8892, 2265, 12999, 21297,
	25604, 25114, 19917, 10988, 0, -10987, -19917, -25114,
	-25605, -21298, -13000, -2266, 8892, 18384, 24431, 25901,
	22516, 14913, 4515, -6729, -16712, -23563, -26000, -23564,
	-16712, -6729, 4514, 14912, 22516, 25901, 24432, 18384,
	8892, -2265, -12999, -21297, -25604, -25114, -19917, -10988},
	{
// Carrier 9 Phase 1
	9949, 19169, 24796, 25777, 21928, 13969, 3393, -7818,
	-17565, -24020, -25975, -23062, -15827, -5627, 5627, 15827,
	23062, 25975, 24020, 17565, 7818, -3393, -13969, -21928,
	-25777, -24796, -19169, -9949, 1134, 12005, 20627, 25383,
	25383, 20627, 12005, 1134, -9949, -19169, -24796, -25777,
	-21928, -13969, -3393, 7818, 17565, 24020, 25975, 23062,
	15827, 5627, -5627, -15827, -23062, -25975, -24020, -17565,
	-7818, 3393, 13969, 21928, 25777, 24796, 19169, 9949,
	-1134, -12005, -20627, -25383, -25383, -20627, -12005, -1134,
	9949, 19169, 24796, 25777, 21928, 13969, 3393, -7818,
	-17565, -24020, -25975, -23062, -15827, -5627, 5627, 15827,
	23062, 25975, 24020, 17565, 7818, -3393, -13969, -21928,
	-25777, -24796, -19169, -9949, 1134, 12005, 20627, 25383,
	25383, 20627, 12005, 1134, -9949, -19169, -24796, -25777,
	-21928, -13969, -3393, 7818, 17565, 24020, 25975, 23062,
	15827, 5627, -5627, -15827, -23062, -25975, -24020, -17565,
	-7818, 3393, 13969, 21928, 25777, 24796, 19169, 9949,
	-1133, -12005, -20627, -25383, -25383, -20627, -12005, -1134,
	9949, 19169, 24796, 25777, 21928, 13969, 3393, -7818,
	-17565, -24020, -25975, -23062, -15827, -5627, 5627, 15827,
	23062, 25975, 24020, 17565, 7818, -3393, -13969, -21928,
	-25777, -24796, -19169, -9949, 1133, 12005, 20627, 25383,
	25383, 20627, 12005, 1134, -9949, -19169, -24796, -25777,
	-21928, -13969, -3393, 7818, 17565, 24020, 25975, 23062,
	15827, 5627, -5627, -15827, -23062, -25975, -24020, -17565,
	-7818, 3393, 13969, 21928, 25777, 24796, 19169, 9949,
	-1133, -12005, -20627, -25383, -25383, -20627, -12005, -1134},
	{
// Carrier 9 Phase 2
	18384, 24432, 25901, 22516, 14912, 4514, -6729, -16712,
	-23563, -26000, -23564, -16712, -6729, 4514, 14912, 22516,
	25901, 24432, 18384, 8892, -2266, -12999, -21297, -25604,
	-25114, -19917, -10988, 0, 10988, 19917, 25114, 25605,
	21297, 13000, 2266, -8892, -18384, -24431, -25901, -22516,
	-14913, -4514, 6729, 16712, 23563, 26000, 23564, 16712,
	6729, -4514, -14912, -22516, -25901, -24432, -18384, -8892,
	2265, 12999, 21297, 25604, 25114, 19917, 10988, 0,
	-10988, -19917, -25114, -25605, -21297, -13000, -2266, 8892,
	18384, 24431, 25901, 22516, 14913, 4514, -6729, -16712,
	-23563, -26000, -23564, -16712, -6729, 4514, 14912, 22516,
	25901, 24432, 18384, 8892, -2265, -12999, -21297, -25604,
	-25114, -19917, -10988, 0, 10987, 19917, 25114, 25605,
	21298, 13000, 2266, -8892, -18384, -24431, -25901, -22516,
	-14913, -4514, 6729, 16712, 23563, 26000, 23564, 16712,
	6729, -4514, -14912, -22516, -25901, -24432, -18384, -8892,
	2265, 12999, 21297, 25604, 25114, 19917, 10988, 0,
	-10987, -19917, -25114, -25605, -21298, -13000, -2266, 8892,
	18384, 24431, 25901, 22516, 14913, 4514, -6729, -16712,
	-23563, -26000, -23564, -16712, -6729, 4514, 14912, 22516,
	25901, 24432, 18384, 8892, -2265, -12999, -21297, -25604,
	-25114, -19917, -10988, 0, 10987, 19917, 25114, 25605,
	21298, 13000, 2266, -8892, -18384, -24431, -25901, -22516,
	-14913, -4515, 6729, 16712, 23563, 26000, 23564, 16712,
	6729, -4514, -14912, -22516, -25901, -24432, -18384, -8892,
	2265, 12999, 21297, 25604, 25114, 19917, 10988, 0,
	-10987, -19917, -25114, -25605, -21298, -13000, -2266, 8892},
	{
// Carrier 9 Phase 3
	24020, 25975, 23062, 15827, 5627, -5627, -15827, -23062,
	-25975, -24020, -17565, -7818, 3393, 13969, 21928, 25777,
	24796, 19169, 9949, -1134, -12005, -20627, -25383, -25383,
	-20627, -12005, -1134, 9949, 19169, 24796, 25777, 21928,
	13969, 3393, -7818, -17565, -24020, -25975, -23062, -15827,
	-5627, 5627, 15827, 23062, 25975, 24020, 17565, 7818,
	-3393, -13969, -21928, -25777, -24796, -19169, -9949, 1134,
	12005, 20627, 25383, 25383, 20627, 12005, 1134, -9949,
	-19169, -24796, -25777, -21928, -13969, -3393, 7818, 17565,
	24020, 25975, 23062, 15827, 5627, -5627, -15827, -23062,
	-25975, -24020, -17565, -7818, 3393, 13969, 21928, 25777,
	24796, 19169, 9949, -1134, -12005, -20627, -25383, -25383,
	-20627, -12005, -1134, 9949, 19169, 24796, 25777, 21928,
	13969, 3393, -7818, -17565, -24020, -25975, -23062, -15827,
	-5627, 5627, 15827, 23062, 25975, 24020, 17565, 7818,
	-3393, -13969, -21928, -25777, -24796, -19169, -9949, 1133,
	12005, 20627, 25383, 25383, 20627, 12005, 1134, -9949,
	-19169, -24796, -25777, -21928, -13969, -3393, 7818, 17565,
	24020, 25975, 23062, 15827, 5627, -5627, -15827, -23062,
	-25975, -24020, -17565, -7818, 3393, 13969, 21928, 25777,
	24796, 19169, 9949, -1133, -12005, -20627, -25383, -25383,
	-20627, -12005, -1134, 9949, 19169, 24796, 25777, 21928,
	13969, 3393, -7818, -17565, -24020, -25975, -23062, -15827,
	-5627, 5627, 15827, 23062, 25975, 24020, 17565, 7818,
	-3393, -13969, -21928, -25777, -24796, -19169, -9949, 1133,
	12005, 20627, 25383, 25383, 20627, 12005, 1134, -9949,
	-19169, -24796, -25777, -21928, -13969, -3393, 7818, 17565},
	{
// Carrier 9 Phase 4
	26000, 23564, 16712, 6729, -4514, -14912, -22516, -25901,
	-24432, -18384, -8892, 2266, 12999, 21297, 25604, 25114,
	19917, 10988, 0, -10988, -19917, -25114, -25605, -21297,
	-13000, -2266, 8892, 18384, 24431, 25901, 22516, 14913,
	4514, -6729, -16712, -23563, -26000, -23564, -16712, -6729,
	4514, 14912, 22516, 25901, 24432, 18384, 8892, -2266,
	-12999, -21297, -25604, -25114, -19917, -10988, 0, 10988,
	19917, 25114, 25605, 21297, 13000, 2266, -8892, -18384,
	-24431, -25901, -22516, -14913, -4514, 6729, 16712, 23563,
	26000, 23564, 16712, 6729, -4514, -14912, -22516, -25901,
	-24432, -18384, -8892, 2265, 12999, 21297, 25604, 25114,
	19917, 10988, 0, -10987, -19917, -25114, -25605, -21298,
	-13000, -2266, 8892, 18384, 24431, 25901, 22516, 14913,
	4514, -6729, -16712, -23563, -26000, -23564, -16712, -6729,
	4514, 14912, 22516, 25901, 24432, 18384, 8892, -2265,
	-12999, -21297, -25604, -25114, -19917, -10988, 0, 10987,
	19917, 25114, 25605, 21298, 13000, 2266, -8892, -18384,
	-24431, -25901, -22516, -14913, -4514, 6729, 16712, 23563,
	26000, 23564, 16712, 6729, -4514, -14912, -22516, -25901,
	-24432, -18384, -8892, 2265, 12999, 21297, 25604, 25114,
	19917, 10988, 0, -10987, -19917, -25114, -25605, -21298,
	-13000, -2266, 8892, 18384, 24431, 25901, 22516, 14913,
	4515, -6729, -16712, -23563, -26000, -23564, -16712, -6729,
	4514, 14912, 22516, 25901, 24432, 18384, 8892, -2265,
	-12999, -21297, -25604, -25114, -19917, -10988, 0, 10987,
	19917, 25114, 25605, 21298, 13000, 2266, -8892, -18384,
	-24431, -25901, -22516, -14913, -4515, 6729, 16712, 23563},
	{
// Carrier 9 Phase 5
	24020, 17565, 7818, -3393, -13969, -21928, -25777, -24796,
	-19169, -9949, 1134, 12005, 20627, 25383, 25383, 20627,
	12005, 1134, -9949, -19169, -24796, -25777, -21928, -13969,
	-3393, 7818, 17565, 24020, 25975, 23062, 15827, 5627,
	-5627, -15827, -23062, -25975, -24020, -17565, -7818, 3393,
	13969, 21928, 25777, 24796, 19169, 9949, -1134, -12005,
	-20627, -25383, -25383, -20627, -12005, -1134, 9949, 19169,
	24796, 25777, 21928, 13969, 3393, -7818, -17565, -24020,
	-25975, -23062, -15827, -5627, 5627, 15827, 23062, 25975,
	24020, 17565, 7818, -3393, -13969, -21928, -25777, -24796,
	-19169, -9949, 1134, 12005, 20627, 25383, 25383, 20627,
	12005, 1134, -9949, -19169, -24796, -25777, -21928, -13969,
	-3393, 7818, 17565, 24020, 25975, 23062, 15827, 5627,
	-5627, -15827, -23062, -25975, -24020, -17565, -7818, 3393,
	13969, 21928, 25777, 24796, 19169, 9949, -1133, -12005,
	-20627, -25383, -25383, -20627, -12005, -1134, 9949, 19169,
	24796, 25777, 21928, 13969, 3393, -7818, -17565, -24020,
	-25975, -23062, -15827, -5627, 5627, 15827, 23062, 25975,
	24020, 17565, 7818, -3393, -13969, -21928, -25777, -24796,
	-19169, -9949, 1133, 12005, 20627, 25383, 25383, 20627,
	12005, 1134, -9949, -19169, -24796, -25777, -21928, -13969,
	-3393, 7818, 17565, 24020, 25975, 23062, 15827, 5627,
	-5627, -15827, -23062, -25975, -24020, -17565, -7818, 3393,
	13969, 21928, 25777, 24796, 19169, 9949, -1133, -12005,
	-20627, -25383, -25383, -20627, -12005, -1134, 9949, 19169,
	24796, 25777, 21928, 13969, 3393, -7818, -17565, -24020,
	-25975, -23062, -15827, -5627, 5627, 15827, 23062, 25975},
	{
// Carrier 9 Phase 6
	18384, 8892, -2266, -12999, -21297, -25604, -25114, -19917,
	-10988, 0, 10988, 19917, 25114, 25605, 21297, 13000,
	2266, -8892, -18384, -24432, -25901, -22516, -14913, -4514,
	6729, 16712, 23563, 26000, 23564, 16712, 6729, -4514,
	-14912, -22516, -25901, -24432, -18384, -8892, 2266, 12999,
	21297, 25604, 25114, 19917, 10988, 0, -10988, -19917,
	-25114, -25605, -21297, -13000, -2266, 8892, 18384, 24431,
	25901, 22516, 14913, 4514, -6729, -16712, -23563, -26000,
	-23564, -16712, -6729, 4514, 14912, 22516, 25901, 24432,
	18384, 8892, -2265, -12999, -21297, -25604, -25114, -19917,
	-10988, 0, 10988, 19917, 25114, 25605, 21297, 13000,
	2266, -8892, -18384, -24431, -25901, -22516, -14913, -4514,
	6729, 16712, 23563, 26000, 23564, 16712, 6729, -4514,
	-14912, -22516, -25901, -24432, -18384, -8892, 2265, 12999,
	21297, 25604, 25114, 19917, 10988, 0, -10987, -19917,
	-25114, -25605, -21298, -13000, -2266, 8892, 18384, 24431,
	25901, 22516, 14913, 4514, -6729, -16712, -23563, -26000,
	-23564, -16712, -6729, 4514, 14912, 22516, 25901, 24432,
	18384, 8892, -2265, -12999, -21297, -25604, -25114, -19917,
	-10988, 0, 10987, 19917, 25114, 25605, 21298, 13000,
	2266, -8892, -18384, -24431, -25901, -22516, -14913, -4515,
	6729, 16712, 23563, 26000, 23564, 16712, 6729, -4514,
	-14912, -22516, -25901, -24432, -18384, -8892, 2265, 12999,
	21297, 25604, 25114, 19917, 10988, 0, -10987, -19917,
	-25114, -25605, -21298, -13000, -2266, 8892, 18384, 24431,
	25901, 22516, 14913, 4515, -6729, -16712, -23563, -26000,
	-23564, -16712, -6729, 4514, 14912, 22516, 25901, 24432},
	{
// Carrier 9 Phase 7
	9949, -1134, -12005, -20627, -25383, -25383, -20627, -12005,
	-1134, 9949, 19169, 24796, 25777, 21928, 13969, 3393,
	-7818, -17565, -24020, -25975, -23062, -15827, -5627, 5627,
	15827, 23062, 25975, 24020, 17565, 7818, -3393, -13969,
	-21928, -25777, -24796, -19169, -9949, 1134, 12005, 20627,
	25383, 25383, 20627, 12005, 1134, -9949, -19169, -24796,
	-25777, -21928, -13969, -3393, 7818, 17565, 24020, 25975,
	23062, 15827, 5627, -5627, -15827, -23062, -25975, -24020,
	-17565, -7818, 3393, 13969, 21928, 25777, 24796, 19169,
	9949, -1134, -12005, -20627, -25383, -25383, -20627, -12005,
	-1134, 9949, 19169, 24796, 25777, 21928, 13969, 3393,
	-7818, -17565, -24020, -25975, -23062, -15827, -5627, 5627,
	15827, 23062, 25975, 24020, 17565, 7818, -3393, -13969,
	-21928, -25777, -24796, -19169, -9949, 1134, 12005, 20627,
	25383, 25383, 20627, 12005, 1134, -9949, -19169, -24796,
	-25777, -21928, -13969, -3393, 7818, 17565, 24020, 25975,
	23062, 15827, 5627, -5627, -15827, -23062, -25975, -24020,
	-17565, -7818, 3393, 13969, 21928, 25777, 24796, 19169,
	9949, -1133, -12005, -20627, -25383, -25383, -20627, -12005,
	-1134, 9949, 19169, 24796, 25777, 21928, 13969, 3393,
	-7818, -17565, -24020, -25975, -23062, -15827, -5627, 5627,
	15827, 23062, 25975, 24020, 17565, 7818, -3393, -13969,
	-21928, -25777, -24796, -19169, -9949, 1133, 12005, 20627,
	25383, 25383, 20627, 12005, 1134, -9949, -19169, -24796,
	-25777, -21928, -13969, -3393, 7818, 17565, 24020, 25975,
	23062, 15827, 5627, -5627, -15827, -23062, -25975, -24020,
	-17565, -7818, 3393, 13969, 21928, 25777, 24796, 19169},
	},{{

// Carrier 10 Phase 0
	0, 11668, 20855, 25605, 24907, 18911, 8892, -3018,
	-14287, -22516, -25956, -23873, -16712, -5996, 5996, 16712,
	23873, 25956, 22516, 14287, 3018, -8892, -18911, -24907,
	-25604, -20855, -11668, 0, 11668, 20855, 25605, 24907,
	18911, 8892, -3018, -14287, -22516, -25956, -23873, -16712,
	-5995, 5996, 16712, 23873, 25956, 22516, 14287, 3018,
	-8892, -18911, -24907, -25604, -20855, -11668, 0, 11668,
	20855, 25605, 24907, 18911, 8892, -3018, -14287, -22516,
	-25956, -23873, -16712, -5995, 5996, 16712, 23873, 25956,
	22516, 14287, 3018, -8892, -18911, -24907, -25604, -20855,
	-11668, 0, 11668, 20855, 25605, 24907, 18911, 8892,
	-3018, -14287, -22516, -25956, -23873, -16712, -5995, 5996,
	16712, 23873, 25956, 22516, 14287, 3018, -8892, -18911,
	-24907, -25604, -20855, -11668, 0, 11668, 20855, 25605,
	24907, 18911, 8892, -3018, -14287, -22516, -25956, -23873,
	-16712, -5995, 5996, 16712, 23873, 25956, 22516, 14287,
	3018, -8892, -18911, -24907, -25604, -20855, -11668, 0,
	11668, 20855, 25605, 24907, 18911, 8892, -3018, -14287,
	-22516, -25956, -23873, -16712, -5995, 5996, 16712, 23873,
	25956, 22516, 14287, 3018, -8892, -18911, -24907, -25604,
	-20855, -11668, 0, 11668, 20855, 25605, 24907, 18911,
	8892, -3018, -14287, -22516, -25956, -23873, -16712, -5995,
	5996, 16712, 23873, 25955, 22516, 14287, 3018, -8892,
	-18911, -24907, -25604, -20855, -11668, 0, 11669, 20855,
	25605, 24907, 18911, 8892, -3018, -14287, -22516, -25956,
	-23873, -16712, -5995, 5996, 16712, 23873, 25955, 22516,
	14287, 3018, -8892, -18911, -24907, -25604, -20855, -11668},
	{
// Carrier 10 Phase 1
	9949, 19671, 25209, 25383, 20158, 10644, -1134, -12671,
	-21512, -25777, -24558, -18115, -7818, 4141, 15221, 23062,
	25997, 23401, 15827, 4886, -7093, -17565, -24300, -25865,
	-21928, -13326, -1889, 9949, 19672, 25209, 25383, 20158,
	10644, -1134, -12671, -21512, -25777, -24558, -18115, -7818,
	4142, 15221, 23062, 25997, 23401, 15827, 4886, -7093,
	-17565, -24300, -25865, -21928, -13326, -1889, 9949, 19672,
	25209, 25383, 20158, 10644, -1134, -12671, -21512, -25777,
	-24558, -18115, -7818, 4142, 15221, 23062, 25997, 23401,
	15827, 4886, -7093, -17565, -24300, -25865, -21928, -13326,
	-1889, 9949, 19672, 25209, 25383, 20158, 10644, -1134,
	-12671, -21512, -25777, -24558, -18115, -7818, 4142, 15221,
	23062, 25997, 23401, 15827, 4886, -7093, -17565, -24300,
	-25865, -21928, -13325, -1888, 9949, 19672, 25209, 25383,
	20158, 10644, -1134, -12671, -21512, -25777, -24558, -18115,
	-7818, 4142, 15221, 23062, 25997, 23401, 15827, 4886,
	-7093, -17565, -24300, -25865, -21928, -13325, -1888, 9949,
	19672, 25209, 25383, 20158, 10644, -1134, -12671, -21512,
	-25777, -24558, -18115, -7818, 4142, 15221, 23062, 25997,
	23401, 15827, 4886, -7094, -17565, -24300, -25865, -21928,
	-13325, -1888, 9949, 19672, 25209, 25383, 20157, 10644,
	-1134, -12671, -21512, -25777, -24558, -18115, -7818, 4142,
	15221, 23062, 25997, 23401, 15827, 4886, -7094, -17565,
	-24300, -25865, -21928, -13325, -1888, 9950, 19672, 25209,
	25383, 20157, 10643, -1134, -12671, -21512, -25777, -24558,
	-18115, -7818, 4142, 15221, 23062, 25997, 23401, 15827,
	4886, -7094, -17565, -24300, -25865, -21928, -13325, -1888},
	{
// Carrier 10 Phase 2
	18384, 24680, 25725, 21297, 12339, 756, -10988, -20394,
	-25462, -25114, -19422, -9599, 2266, 13649, 22129, 25901,
	24163, 17284, 6729, -5257, -16126, -23564, -25989, -22885,
	-14912, -3768, 8178, 18384, 24680, 25725, 21297, 12339,
	756, -10988, -20394, -25462, -25114, -19422, -9599, 2266,
	13649, 22129, 25901, 24163, 17284, 6729, -5257, -16126,
	-23564, -25988, -22885, -14912, -3768, 8178, 18384, 24680,
	25725, 21297, 12339, 756, -10988, -20394, -25462, -25114,
	-19422, -9599, 2266, 13649, 22129, 25901, 24163, 17284,
	6729, -5257, -16126, -23564, -25988, -22885, -14912, -3768,
	8178, 18384, 24680, 25725, 21297, 12339, 756, -10988,
	-20394, -25462, -25114, -19422, -9599, 2266, 13649, 22129,
	25901, 24162, 17284, 6729, -5257, -16126, -23564, -25988,
	-22885, -14912, -3768, 8178, 18384, 24680, 25725, 21297,
	12339, 756, -10988, -20394, -25462, -25114, -19422, -9599,
	2266, 13649, 22129, 25901, 24162, 17284, 6729, -5257,
	-16126, -23564, -25988, -22885, -14912, -3768, 8178, 18384,
	24680, 25725, 21297, 12339, 756, -10988, -20394, -25462,
	-25114, -19422, -9599, 2266, 13649, 22129, 25901, 24162,
	17284, 6729, -5257, -16126, -23564, -25988, -22885, -14912,
	-3768, 8178, 18384, 24680, 25725, 21297, 12339, 755,
	-10988, -20394, -25462, -25114, -19422, -9599, 2266, 13649,
	22129, 25901, 24162, 17284, 6729, -5257, -16126, -23564,
	-25988, -22885, -14912, -3767, 8178, 18384, 24680, 25725,
	21297, 12339, 755, -10988, -20394, -25462, -25114, -19422,
	-9599, 2266, 13649, 22129, 25901, 24162, 17284, 6729,
	-5257, -16126, -23564, -25988, -22885, -14912, -3767, 8178},
	{
// Carrier 10 Phase 3
	24020, 25931, 22325, 13969, 2642, -9246, -19169, -25013,
	-25536, -20627, -11329, 378, 12005, 21078, 25667, 24796,
	18650, 8536, -3393, -14601, -22703, -25975, -23721, -16421,
	-5627, 6363, 17000, 24020, 25931, 22325, 13969, 2642,
	-9246, -19169, -25013, -25536, -20627, -11329, 378, 12005,
	21078, 25667, 24796, 18650, 8536, -3393, -14601, -22703,
	-25975, -23721, -16420, -5627, 6363, 17000, 24020, 25931,
	22325, 13969, 2642, -9246, -19169, -25013, -25536, -20627,
	-11329, 378, 12005, 21078, 25667, 24796, 18650, 8536,
	-3393, -14601, -22703, -25975, -23721, -16420, -5627, 6363,
	17000, 24020, 25931, 22325, 13969, 2642, -9247, -19169,
	-25013, -25536, -20627, -11329, 378, 12005, 21078, 25667,
	24796, 18650, 8536, -3393, -14601, -22703, -25975, -23721,
	-16420, -5627, 6363, 17000, 24020, 25931, 22325, 13969,
	2642, -9247, -19169, -25013, -25536, -20627, -11329, 378,
	12005, 21078, 25667, 24796, 18650, 8536, -3393, -14601,
	-22703, -25975, -23721, -16420, -5627, 6363, 17000, 24020,
	25931, 22325, 13969, 2642, -9247, -19169, -25013, -25536,
	-20627, -11329, 378, 12005, 21078, 25667, 24796, 18650,
	8536, -3393, -14601, -22703, -25975, -23721, -16420, -5627,
	6363, 17000, 24020, 25931, 22325, 13969, 2642, -9247,
	-19169, -25013, -25536, -20627, -11329, 378, 12005, 21078,
	25667, 24796, 18650, 8536, -3393, -14601, -22703, -25975,
	-23721, -16420, -5627, 6363, 17000, 24020, 25931, 22325,
	13969, 2642, -9247, -19169, -25013, -25536, -20627, -11329,
	378, 12005, 21078, 25668, 24796, 18650, 8535, -3393,
	-14601, -22703, -25975, -23721, -16420, -5627, 6363, 17000},
	{
// Carrier 10 Phase 4
	26000, 23234, 15526, 4514, -7456, -17842, -24432, -25824,
	-21722, -12999, -1511, 10298, 19917, 25299, 25299, 19917,
	10298, -1511, -13000, -21722, -25824, -24432, -17842, -7456,
	4514, 15526, 23234, 26000, 23234, 15526, 4514, -7456,
	-17842, -24432, -25824, -21722, -12999, -1511, 10298, 19917,
	25299, 25299, 19917, 10298, -1511, -13000, -21722, -25824,
	-24431, -17842, -7456, 4514, 15526, 23234, 26000, 23234,
	15526, 4514, -7456, -17842, -24432, -25824, -21722, -12999,
	-1511, 10298, 19917, 25299, 25299, 19917, 10297, -1511,
	-13000, -21722, -25824, -24431, -17842, -7456, 4514, 15526,
	23234, 26000, 23234, 15526, 4514, -7456, -17842, -24432,
	-25824, -21722, -12999, -1511, 10298, 19917, 25299, 25299,
	19917, 10297, -1511, -13000, -21722, -25824, -24431, -17842,
	-7456, 4514, 15526, 23234, 26000, 23234, 15526, 4514,
	-7457, -17842, -24432, -25824, -21722, -12999, -1511, 10298,
	19917, 25299, 25299, 19917, 10297, -1511, -13000, -21722,
	-25824, -24431, -17842, -7456, 4515, 15526, 23234, 26000,
	23234, 15525, 4514, -7457, -17842, -24432, -25824, -21722,
	-12999, -1511, 10298, 19917, 25299, 25299, 19917, 10297,
	-1511, -13000, -21722, -25824, -24431, -17842, -7456, 4515,
	15526, 23234, 26000, 23234, 15525, 4514, -7457, -17842,
	-24432, -25824, -21722, -12999, -1511, 10298, 19917, 25299,
	25299, 19917, 10297, -1512, -13000, -21722, -25824, -24431,
	-17842, -7456, 4515, 15526, 23234, 26000, 23234, 15525,
	4514, -7457, -17842, -24432, -25824, -21722, -12999, -1511,
	10298, 19917, 25299, 25299, 19916, 10297, -1512, -13000,
	-21722, -25824, -24431, -17842, -7456, 4515, 15526, 23234},
	{
// Carrier 10 Phase 5
	24020, 17000, 6363, -5627, -16421, -23721, -25975, -22703,
	-14601, -3393, 8536, 18650, 24796, 25667, 21078, 12005,
	378, -11329, -20627, -25536, -25013, -19169, -9246, 2642,
	13969, 22325, 25931, 24020, 17000, 6363, -5627, -16421,
	-23721, -25975, -22703, -14601, -3393, 8536, 18650, 24796,
	25667, 21078, 12005, 378, -11329, -20627, -25536, -25013,
	-19169, -9246, 2642, 13969, 22325, 25931, 24020, 17000,
	6363, -5627, -16421, -23721, -25975, -22703, -14601, -3393,
	8536, 18650, 24796, 25667, 21078, 12005, 378, -11329,
	-20627, -25536, -25013, -19169, -9246, 2642, 13969, 22325,
	25931, 24020, 17000, 6363, -5627, -16421, -23721, -25975,
	-22703, -14601, -3393, 8536, 18650, 24796, 25667, 21078,
	12005, 378, -11329, -20627, -25536, -25013, -19169, -9246,
	2642, 13969, 22325, 25931, 24020, 17000, 6363, -5627,
	-16421, -23721, -25975, -22703, -14601, -3393, 8536, 18650,
	24796, 25667, 21078, 12005, 377, -11329, -20627, -25536,
	-25013, -19169, -9246, 2642, 13969, 22325, 25931, 24020,
	17000, 6363, -5627, -16421, -23721, -25975, -22703, -14601,
	-3393, 8536, 18650, 24796, 25667, 21078, 12005, 377,
	-11329, -20627, -25536, -25013, -19169, -9246, 2642, 13969,
	22325, 25931, 24020, 17000, 6363, -5627, -16421, -23721,
	-25975, -22703, -14601, -3393, 8536, 18650, 24796, 25667,
	21078, 12005, 377, -11329, -20627, -25536, -25013, -19169,
	-9246, 2642, 13970, 22325, 25931, 24020, 17000, 6363,
	-5627, -16421, -23721, -25975, -22703, -14601, -3393, 8536,
	18650, 24796, 25667, 21078, 12005, 377, -11329, -20627,
	-25536, -25013, -19169, -9246, 2642, 13970, 22325, 25931},
	{
// Carrier 10 Phase 6
	18384, 8178, -3768, -14912, -22885, -25989, -23563, -16126,
	-5257, 6729, 17284, 24163, 25901, 22129, 13649, 2266,
	-9599, -19422, -25114, -25462, -20394, -10988, 756, 12339,
	21297, 25725, 24680, 18384, 8178, -3768, -14913, -22885,
	-25989, -23563, -16126, -5257, 6729, 17284, 24163, 25901,
	22129, 13649, 2265, -9599, -19422, -25114, -25462, -20394,
	-10988, 756, 12339, 21297, 25725, 24680, 18384, 8178,
	-3768, -14913, -22885, -25989, -23563, -16126, -5257, 6729,
	17284, 24163, 25901, 22128, 13649, 2265, -9599, -19422,
	-25114, -25462, -20394, -10987, 756, 12339, 21298, 25725,
	24680, 18384, 8178, -3768, -14913, -22885, -25989, -23563,
	-16126, -5257, 6729, 17284, 24163, 25901, 22128, 13649,
	2265, -9599, -19422, -25114, -25462, -20394, -10987, 756,
	12339, 21298, 25725, 24680, 18384, 8178, -3768, -14913,
	-22885, -25989, -23563, -16125, -5257, 6729, 17284, 24163,
	25901, 22128, 13649, 2265, -9599, -19422, -25114, -25462,
	-20394, -10987, 756, 12339, 21298, 25725, 24680, 18384,
	8177, -3768, -14913, -22885, -25989, -23563, -16125, -5257,
	6729, 17284, 24163, 25901, 22128, 13649, 2265, -9599,
	-19422, -25114, -25462, -20394, -10987, 756, 12339, 21298,
	25725, 24680, 18384, 8177, -3768, -14913, -22885, -25989,
	-23563, -16125, -5257, 6729, 17284, 24163, 25901, 22128,
	13649, 2265, -9599, -19422, -25114, -25462, -20394, -10987,
	756, 12339, 21298, 25725, 24680, 18384, 8177, -3768,
	-14913, -22885, -25989, -23563, -16125, -5257, 6729, 17284,
	24163, 25901, 22128, 13649, 2265, -9599, -19422, -25114,
	-25462, -20394, -10987, 756, 12339, 21298, 25725, 24680},
	{
// Carrier 10 Phase 7
	9949, -1889, -13326, -21928, -25865, -24300, -17565, -7093,
	4886, 15827, 23401, 25997, 23062, 15221, 4141, -7818,
	-18115, -24558, -25777, -21512, -12671, -1134, 10644, 20158,
	25383, 25209, 19671, 9949, -1889, -13326, -21928, -25865,
	-24300, -17565, -7093, 4886, 15827, 23401, 25997, 23062,
	15221, 4141, -7818, -18115, -24558, -25777, -21512, -12671,
	-1134, 10644, 20158, 25383, 25209, 19671, 9949, -1889,
	-13326, -21928, -25865, -24300, -17565, -7093, 4886, 15827,
	23401, 25997, 23062, 15221, 4141, -7818, -18115, -24558,
	-25777, -21512, -12671, -1134, 10644, 20158, 25383, 25209,
	19671, 9949, -1889, -13326, -21928, -25865, -24300, -17565,
	-7093, 4886, 15827, 23401, 25997, 23062, 15221, 4141,
	-7818, -18115, -24558, -25777, -21512, -12671, -1133, 10644,
	20158, 25383, 25209, 19671, 9949, -1889, -13326, -21928,
	-25865, -24300, -17565, -7093, 4886, 15827, 23401, 25997,
	23062, 15221, 4141, -7818, -18115, -24558, -25777, -21512,
	-12670, -1133, 10644, 20158, 25383, 25209, 19671, 9949,
	-1889, -13326, -21928, -25865, -24300, -17565, -7093, 4886,
	15827, 23401, 25997, 23062, 15221, 4141, -7818, -18115,
	-24558, -25777, -21512, -12670, -1133, 10644, 20158, 25383,
	25209, 19671, 9949, -1889, -13326, -21928, -25865, -24300,
	-17565, -7093, 4887, 15827, 23401, 25997, 23062, 15220,
	4141, -7818, -18115, -24558, -25777, -21512, -12670, -1133,
	10644, 20158, 25383, 25209, 19671, 9949, -1889, -13326,
	-21928, -25865, -24299, -17565, -7093, 4887, 15828, 23401,
	25997, 23062, 15220, 4141, -7818, -18115, -24558, -25777,
	-21512, -12670, -1133, 10644, 20158, 25383, 25209, 19671},
	},{{

// Carrier 11 Phase 0
	0, 12339, 21722, 25901, 23873, 16126, 4514, -8178,
	-18911, -25114, -25299, -19422, -8892, 3768, 15526, 23563,
	25956, 22129, 13000, 756, -11668, -21297, -25824, -24163,
	-16712, -5257, 7456, 18384, 24907, 25462, 19917, 9599,
	-3018, -14912, -23234, -25989, -22516, -13649, -1511, 10987,
	20855, 25725, 24432, 17284, 5996, -6729, -17842, -24680,
	-25605, -20394, -10298, 2265, 14287, 22885, 26000, 22885,
	14287, 2266, -10297, -20394, -25604, -24680, -17842, -6729,
	5995, 17284, 24431, 25725, 20855, 10988, -1511, -13649,
	-22516, -25988, -23234, -14913, -3018, 9599, 19917, 25462,
	24907, 18384, 7457, -5257, -16712, -24162, -25824, -21298,
	-11668, 756, 12999, 22128, 25956, 23564, 15526, 3768,
	-8892, -19422, -25299, -25114, -18911, -8178, 4514, 16125,
	23873, 25901, 21722, 12339, 0, -12339, -21722, -25901,
	-23873, -16126, -4515, 8177, 18911, 25114, 25299, 19422,
	8892, -3767, -15525, -23563, -25956, -22129, -13000, -756,
	11668, 21297, 25824, 24163, 16712, 5257, -7456, -18384,
	-24907, -25462, -19917, -9599, 3018, 14912, 23234, 25989,
	22516, 13649, 1512, -10987, -20855, -25725, -24432, -17284,
	-5996, 6728, 17842, 24680, 25605, 20395, 10298, -2265,
	-14286, -22885, -26000, -22885, -14287, -2266, 10297, 20394,
	25604, 24680, 17842, 6729, -5995, -17284, -24431, -25725,
	-20855, -10988, 1511, 13649, 22516, 25988, 23234, 14913,
	3018, -9598, -19916, -25462, -24907, -18385, -7457, 5257,
	16712, 24162, 25824, 21298, 11669, -755, -12999, -22128,
	-25955, -23564, -15526, -3768, 8892, 19422, 25299, 25114,
	18912, 8178, -4514, -16125, -23873, -25901, -21722, -12340},
	{
// Carrier 11 Phase 1
	9949, 20158, 25536, 24796, 18115, 7093, -5627, -17000,
	-24300, -25777, -21078, -11329, 1134, 13326, 22325, 25975,
	23401, 15221, 3393, -9246, -19671, -25383, -25013, -18650,
	-7818, 4886, 16420, 24020, 25865, 21512, 12005, -378,
	-12671, -21928, -25931, -23721, -15827, -4142, 8536, 19169,
	25209, 25209, 19169, 8536, -4141, -15827, -23721, -25931,
	-21928, -12671, -378, 12005, 21512, 25865, 24020, 16421,
	4886, -7818, -18650, -25013, -25383, -19672, -9247, 3393,
	15221, 23401, 25975, 22325, 13326, 1134, -11329, -21078,
	-25777, -24300, -17000, -5627, 7093, 18115, 24796, 25536,
	20158, 9949, -2642, -14601, -23062, -25997, -22703, -13969,
	-1889, 10644, 20627, 25667, 24558, 17565, 6363, -6363,
	-17565, -24558, -25667, -20627, -10644, 1888, 13969, 22703,
	25997, 23062, 14601, 2642, -9949, -20157, -25536, -24796,
	-18115, -7094, 5627, 17000, 24300, 25777, 21078, 11329,
	-1133, -13325, -22325, -25975, -23401, -15221, -3393, 9246,
	19671, 25383, 25013, 18650, 7818, -4886, -16420, -24020,
	-25865, -21512, -12005, 377, 12670, 21928, 25931, 23721,
	15828, 4142, -8535, -19169, -25209, -25209, -19169, -8536,
	4141, 15827, 23721, 25931, 21928, 12671, 378, -12005,
	-21512, -25865, -24020, -16421, -4887, 7818, 18649, 25013,
	25383, 19672, 9247, -3393, -15220, -23401, -25975, -22325,
	-13326, -1134, 11329, 21078, 25777, 24300, 17000, 5627,
	-7093, -18115, -24796, -25536, -20158, -9950, 2642, 14601,
	23062, 25997, 22703, 13970, 1889, -10643, -20626, -25667,
	-24558, -17565, -6363, 6362, 17565, 24558, 25668, 20627,
	10644, -1888, -13969, -22703, -25997, -23062, -14602, -2642},
	{
// Carrier 11 Phase 2
	18384, 24907, 25462, 19917, 9599, -3018, -14912, -23234,
	-25989, -22516, -13649, -1511, 10988, 20855, 25725, 24432,
	17284, 5996, -6729, -17842, -24680, -25605, -20394, -10298,
	2266, 14287, 22885, 26000, 22885, 14287, 2266, -10298,
	-20394, -25604, -24680, -17842, -6729, 5995, 17284, 24431,
	25725, 20855, 10988, -1511, -13649, -22516, -25988, -23234,
	-14913, -3018, 9599, 19917, 25462, 24907, 18384, 7456,
	-5257, -16712, -24162, -25824, -21298, -11668, 756, 12999,
	22128, 25956, 23564, 15526, 3768, -8892, -19422, -25299,
	-25114, -18911, -8178, 4514, 16126, 23873, 25901, 21722,
	12339, 0, -12339, -21722, -25901, -23873, -16126, -4515,
	8177, 18911, 25114, 25299, 19422, 8892, -3768, -15525,
	-23563, -25956, -22129, -13000, -756, 11668, 21297, 25824,
	24163, 16712, 5257, -7456, -18384, -24907, -25462, -19917,
	-9599, 3018, 14912, 23234, 25989, 22516, 13649, 1512,
	-10987, -20855, -25725, -24432, -17284, -5996, 6729, 17842,
	24680, 25605, 20394, 10298, -2265, -14287, -22885, -26000,
	-22885, -14287, -2266, 10297, 20394, 25604, 24680, 17842,
	6729, -5995, -17284, -24431, -25725, -20855, -10988, 1511,
	13649, 22516, 25988, 23234, 14913, 3018, -9599, -19916,
	-25462, -24907, -18385, -7457, 5257, 16712, 24162, 25824,
	21298, 11669, -755, -12999, -22128, -25955, -23564, -15526,
	-3768, 8892, 19422, 25299, 25114, 18911, 8178, -4514,
	-16125, -23873, -25901, -21722, -12339, 0, 12339, 21722,
	25901, 23873, 16126, 4515, -8177, -18911, -25113, -25299,
	-19422, -8892, 3767, 15525, 23563, 25956, 22129, 13000,
	756, -11668, -21297, -25824, -24163, -16712, -5258, 7456},
	{
// Carrier 11 Phase 3
	24020, 25865, 21512, 12005, -378, -12671, -21928, -25931,
	-23721, -15827, -4142, 8536, 19169, 25209, 25209, 19169,
	8536, -4141, -15827, -23721, -25931, -21928, -12671, -378,
	12005, 21512, 25865, 24020, 16421, 4886, -7818, -18650,
	-25013, -25383, -19672, -9246, 3393, 15221, 23401, 25975,
	22325, 13326, 1134, -11329, -21078, -25777, -24300, -17000,
	-5627, 7093, 18115, 24796, 25536, 20158, 9949, -2642,
	-14601, -23062, -25997, -22703, -13969, -1889, 10644, 20627,
	25667, 24558, 17565, 6363, -6363, -17565, -24558, -25667,
	-20627, -10644, 1888, 13969, 22703, 25997, 23062, 14601,
	2642, -9949, -20158, -25536, -24796, -18115, -7094, 5627,
	17000, 24300, 25777, 21078, 11329, -1133, -13325, -22325,
	-25975, -23401, -15221, -3393, 9246, 19671, 25383, 25013,
	18650, 7818, -4886, -16420, -24020, -25865, -21512, -12005,
	377, 12670, 21928, 25931, 23721, 15827, 4142, -8536,
	-19169, -25209, -25209, -19169, -8536, 4141, 15827, 23721,
	25931, 21928, 12671, 378, -12005, -21512, -25865, -24020,
	-16421, -4887, 7818, 18650, 25013, 25383, 19672, 9247,
	-3393, -15220, -23401, -25975, -22325, -13326, -1134, 11329,
	21078, 25777, 24300, 17000, 5627, -7093, -18115, -24796,
	-25536, -20158, -9950, 2642, 14601, 23062, 25997, 22703,
	13970, 1889, -10643, -20626, -25667, -24558, -17565, -6363,
	6362, 17565, 24558, 25668, 20627, 10644, -1888, -13969,
	-22703, -25997, -23062, -14601, -2642, 9949, 20157, 25536,
	24796, 18115, 7094, -5627, -17000, -24299, -25777, -21079,
	-11330, 1133, 13325, 22324, 25975, 23401, 15221, 3394,
	-9246, -19671, -25383, -25013, -18650, -7818, 4886, 16420},
	{
// Carrier 11 Phase 4
	26000, 22885, 14287, 2266, -10298, -20394, -25605, -24680,
	-17842, -6729, 5995, 17284, 24432, 25725, 20855, 10988,
	-1511, -13649, -22516, -25989, -23234, -14913, -3018, 9599,
	19917, 25462, 24907, 18384, 7456, -5257, -16712, -24163,
	-25824, -21297, -11668, 756, 12999, 22128, 25956, 23564,
	15526, 3768, -8892, -19422, -25299, -25114, -18911, -8178,
	4514, 16126, 23873, 25901, 21722, 12339, 0, -12339,
	-21722, -25901, -23873, -16126, -4514, 8178, 18911, 25114,
	25299, 19422, 8892, -3768, -15526, -23563, -25956, -22129,
	-13000, -756, 11668, 21297, 25824, 24163, 16712, 5257,
	-7456, -18384, -24907, -25462, -19917, -9599, 3018, 14912,
	23234, 25989, 22516, 13649, 1511, -10987, -20855, -25725,
	-24432, -17284, -5996, 6729, 17842, 24680, 25605, 20394,
	10298, -2265, -14287, -22885, -26000, -22885, -14287, -2266,
	10297, 20394, 25604, 24680, 17842, 6729, -5995, -17284,
	-24431, -25725, -20855, -10988, 1511, 13649, 22516, 25988,
	23234, 14913, 3018, -9599, -19916, -25462, -24907, -18384,
	-7457, 5257, 16712, 24162, 25824, 21298, 11669, -755,
	-12999, -22128, -25955, -23564, -15526, -3768, 8892, 19422,
	25299, 25114, 18911, 8178, -4514, -16125, -23873, -25901,
	-21722, -12339, 0, 12339, 21722, 25901, 23873, 16126,
	4515, -8177, -18911, -25113, -25299, -19422, -8892, 3767,
	15525, 23563, 25956, 22129, 13000, 756, -11668, -21297,
	-25824, -24163, -16712, -5258, 7456, 18384, 24907, 25462,
	19917, 9599, -3018, -14912, -23234, -25989, -22516, -13649,
	-1512, 10987, 20854, 25725, 24432, 17285, 5996, -6728,
	-17841, -24680, -25605, -20395, -10298, 2265, 14286, 22885},
	{
// Carrier 11 Phase 5
	24020, 16421, 4886, -7818, -18650, -25013, -25383, -19672,
	-9246, 3393, 15221, 23401, 25975, 22325, 13326, 1134,
	-11329, -21078, -25777, -24300, -17000, -5627, 7093, 18115,
	24796, 25536, 20158, 9949, -2642, -14601, -23062, -25997,
	-22703, -13969, -1889, 10644, 20627, 25667, 24558, 17565,
	6363, -6363, -17565, -24558, -25667, -20627, -10644, 1888,
	13969, 22703, 25997, 23062, 14601, 2642, -9949, -20158,
	-25536, -24796, -18115, -7093, 5627, 17000, 24300, 25777,
	21078, 11329, -1133, -13325, -22325, -25975, -23401, -15221,
	-3393, 9246, 19671, 25383, 25013, 18650, 7818, -4886,
	-16420, -24020, -25865, -21512, -12005, 377, 12670, 21928,
	25931, 23721, 15827, 4142, -8536, -19169, -25209, -25209,
	-19169, -8536, 4141, 15827, 23721, 25931, 21928, 12671,
	378, -12005, -21512, -25865, -24020, -16421, -4887, 7818,
	18650, 25013, 25383, 19672, 9247, -3393, -15220, -23401,
	-25975, -22325, -13326, -1134, 11329, 21078, 25777, 24300,
	17000, 5627, -7093, -18115, -24796, -25536, -20158, -9950,
	2642, 14601, 23062, 25997, 22703, 13970, 1889, -10643,
	-20626, -25667, -24558, -17565, -6363, 6362, 17565, 24558,
	25668, 20627, 10644, -1888, -13969, -22703, -25997, -23062,
	-14601, -2642, 9949, 20157, 25536, 24796, 18115, 7094,
	-5627, -17000, -24299, -25777, -21079, -11329, 1133, 13325,
	22325, 25975, 23401, 15221, 3394, -9246, -19671, -25383,
	-25013, -18650, -7818, 4886, 16420, 24020, 25865, 21512,
	12005, -377, -12670, -21927, -25931, -23721, -15828, -4142,
	8535, 19168, 25209, 25209, 19169, 8536, -4141, -15827,
	-23721, -25931, -21928, -12671, -378, 12005, 21512, 25865},
	{
// Carrier 11 Phase 6
	18384, 7456, -5257, -16712, -24163, -25824, -21297, -11668,
	756, 12999, 22129, 25956, 23564, 15526, 3768, -8892,
	-19422, -25299, -25114, -18911, -8178, 4514, 16126, 23873,
	25901, 21722, 12339, 0, -12339, -21722, -25901, -23873,
	-16126, -4514, 8178, 18911, 25114, 25299, 19422, 8892,
	-3768, -15526, -23563, -25956, -22129, -13000, -756, 11668,
	21297, 25824, 24163, 16712, 5257, -7456, -18384, -24907,
	-25462, -19917, -9599, 3018, 14912, 23234, 25989, 22516,
	13649, 1511, -10987, -20855, -25725, -24432, -17284, -5996,
	6729, 17842, 24680, 25605, 20394, 10298, -2265, -14287,
	-22885, -26000, -22885, -14287, -2266, 10297, 20394, 25604,
	24680, 17842, 6729, -5995, -17284, -24431, -25725, -20855,
	-10988, 1511, 13649, 22516, 25988, 23234, 14913, 3018,
	-9599, -19917, -25462, -24907, -18384, -7457, 5257, 16712,
	24162, 25824, 21298, 11668, -755, -12999, -22128, -25955,
	-23564, -15526, -3768, 8892, 19422, 25299, 25114, 18911,
	8178, -4514, -16125, -23873, -25901, -21722, -12339, 0,
	12339, 21722, 25901, 23873, 16126, 4515, -8177, -18911,
	-25113, -25299, -19422, -8892, 3767, 15525, 23563, 25956,
	22129, 13000, 756, -11668, -21297, -25824, -24163, -16712,
	-5258, 7456, 18384, 24907, 25462, 19917, 9599, -3018,
	-14912, -23234, -25989, -22516, -13649, -1512, 10987, 20854,
	25725, 24432, 17284, 5996, -6728, -17841, -24680, -25605,
	-20395, -10298, 2265, 14286, 22885, 26000, 22885, 14287,
	2266, -10297, -20394, -25604, -24680, -17842, -6729, 5995,
	17284, 24431, 25725, 20855, 10988, -1511, -13649, -22516,
	-25988, -23234, -14913, -3018, 9598, 19916, 25462, 24907},
	{
// Carrier 11 Phase 7
	9949, -2642, -14601, -23062, -25997, -22703, -13969, -1889,
	10644, 20627, 25667, 24558, 17565, 6363, -6363, -17565,
	-24558, -25667, -20627, -10644, 1889, 13969, 22703, 25997,
	23062, 14601, 2642, -9949, -20158, -25536, -24796, -18115,
	-7093, 5627, 17000, 24300, 25777, 21078, 11329, -1134,
	-13326, -22325, -25975, -23401, -15221, -3393, 9246, 19671,
	25383, 25013, 18650, 7818, -4886, -16420, -24020, -25865,
	-21512, -12005, 378, 12671, 21928, 25931, 23721, 15827,
	4142, -8536, -19169, -25209, -25209, -19169, -8536, 4141,
	15827, 23721, 25931, 21928, 12671, 378, -12005, -21512,
	-25865, -24020, -16421, -4886, 7818, 18650, 25013, 25383,
	19672, 9247, -3393, -15221, -23401, -25975, -22325, -13326,
	-1134, 11329, 21078, 25777, 24300, 17000, 5627, -7093,
	-18115, -24796, -25536, -20158, -9949, 2642, 14601, 23062,
	25997, 22703, 13969, 1889, -10643, -20627, -25667, -24558,
	-17565, -6363, 6363, 17565, 24558, 25667, 20627, 10644,
	-1888, -13969, -22703, -25997, -23062, -14601, -2642, 9949,
	20157, 25536, 24796, 18115, 7094, -5627, -17000, -24299,
	-25777, -21078, -11329, 1133, 13325, 22325, 25975, 23401,
	15221, 3393, -9246, -19671, -25383, -25013, -18650, -7818,
	4886, 16420, 24020, 25865, 21512, 12005, -377, -12670,
	-21927, -25931, -23721, -15828, -4142, 8535, 19168, 25209,
	25209, 19169, 8536, -4141, -15827, -23721, -25931, -21928,
	-12671, -378, 12005, 21512, 25865, 24021, 16421, 4887,
	-7817, -18649, -25013, -25383, -19672, -9247, 3393, 15220,
	23401, 25975, 22325, 13326, 1134, -11329, -21078, -25777,
	-24300, -17000, -5627, 7093, 18115, 24796, 25536, 20158},
	},{{

// Carrier 12 Phase 0
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000},
	{
// Carrier 12 Phase 1
	9949, 20627, 25777, 24020, 15827, 3393, -9949, -20627,
	-25777, -24020, -15827, -3393, 9949, 20627, 25777, 24020,
	15827, 3393, -9949, -20627, -25777, -24020, -15827, -3393,
	9949, 20627, 25777, 24020, 15827, 3393, -9949, -20627,
	-25777, -24020, -15827, -3393, 9949, 20627, 25777, 24020,
	15827, 3393, -9949, -20627, -25777, -24020, -15827, -3393,
	9949, 20627, 25777, 24020, 15827, 3393, -9949, -20627,
	-25777, -24020, -15827, -3393, 9949, 20627, 25777, 24020,
	15827, 3393, -9949, -20627, -25777, -24020, -15827, -3393,
	9949, 20627, 25777, 24020, 15827, 3393, -9949, -20627,
	-25777, -24020, -15827, -3393, 9949, 20627, 25777, 24020,
	15827, 3393, -9949, -20627, -25777, -24020, -15827, -3393,
	9949, 20627, 25777, 24020, 15827, 3393, -9949, -20627,
	-25777, -24020, -15827, -3393, 9949, 20627, 25777, 24020,
	15827, 3393, -9949, -20627, -25777, -24020, -15827, -3393,
	9949, 20627, 25777, 24020, 15827, 3393, -9949, -20627,
	-25777, -24020, -15827, -3393, 9949, 20627, 25777, 24020,
	15827, 3393, -9949, -20627, -25777, -24020, -15827, -3393,
	9949, 20627, 25777, 24020, 15827, 3393, -9949, -20627,
	-25777, -24020, -15827, -3393, 9949, 20627, 25777, 24020,
	15827, 3393, -9949, -20627, -25777, -24020, -15827, -3393,
	9949, 20627, 25777, 24020, 15827, 3393, -9949, -20627,
	-25777, -24020, -15827, -3393, 9949, 20627, 25777, 24020,
	15827, 3393, -9949, -20627, -25777, -24020, -15827, -3393,
	9949, 20627, 25777, 24020, 15827, 3393, -9949, -20627,
	-25777, -24020, -15827, -3393, 9949, 20627, 25777, 24020,
	15827, 3393, -9949, -20627, -25777, -24020, -15827, -3393},
	{
// Carrier 12 Phase 2
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729},
	{
// Carrier 12 Phase 3
	24020, 25777, 20627, 9949, -3393, -15827, -24020, -25777,
	-20627, -9949, 3393, 15827, 24020, 25777, 20627, 9949,
	-3393, -15827, -24020, -25777, -20627, -9949, 3393, 15827,
	24020, 25777, 20627, 9949, -3393, -15827, -24020, -25777,
	-20627, -9949, 3393, 15827, 24020, 25777, 20627, 9949,
	-3393, -15827, -24020, -25777, -20627, -9949, 3393, 15827,
	24020, 25777, 20627, 9949, -3393, -15827, -24020, -25777,
	-20627, -9949, 3393, 15827, 24020, 25777, 20627, 9949,
	-3393, -15827, -24020, -25777, -20627, -9949, 3393, 15827,
	24020, 25777, 20627, 9949, -3393, -15827, -24020, -25777,
	-20627, -9949, 3393, 15827, 24020, 25777, 20627, 9949,
	-3393, -15827, -24020, -25777, -20627, -9949, 3393, 15827,
	24020, 25777, 20627, 9949, -3393, -15827, -24020, -25777,
	-20627, -9949, 3393, 15827, 24020, 25777, 20627, 9949,
	-3393, -15827, -24020, -25777, -20627, -9949, 3393, 15827,
	24020, 25777, 20627, 9949, -3393, -15827, -24020, -25777,
	-20627, -9949, 3393, 15827, 24020, 25777, 20627, 9949,
	-3393, -15827, -24020, -25777, -20627, -9949, 3393, 15827,
	24020, 25777, 20627, 9949, -3393, -15827, -24020, -25777,
	-20627, -9949, 3393, 15827, 24020, 25777, 20627, 9949,
	-3393, -15827, -24020, -25777, -20627, -9949, 3393, 15827,
	24020, 25777, 20627, 9949, -3393, -15827, -24020, -25777,
	-20627, -9949, 3393, 15827, 24020, 25777, 20627, 9949,
	-3393, -15827, -24020, -25777, -20627, -9949, 3393, 15827,
	24020, 25777, 20627, 9949, -3393, -15827, -24020, -25777,
	-20627, -9949, 3393, 15827, 24020, 25777, 20627, 9949,
	-3393, -15827, -24020, -25777, -20627, -9949, 3393, 15827},
	{
// Carrier 12 Phase 4
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516},
	{
// Carrier 12 Phase 5
	24020, 15827, 3393, -9949, -20627, -25777, -24020, -15827,
	-3393, 9949, 20627, 25777, 24020, 15827, 3393, -9949,
	-20627, -25777, -24020, -15827, -3393, 9949, 20627, 25777,
	24020, 15827, 3393, -9949, -20627, -25777, -24020, -15827,
	-3393, 9949, 20627, 25777, 24020, 15827, 3393, -9949,
	-20627, -25777, -24020, -15827, -3393, 9949, 20627, 25777,
	24020, 15827, 3393, -9949, -20627, -25777, -24020, -15827,
	-3393, 9949, 20627, 25777, 24020, 15827, 3393, -9949,
	-20627, -25777, -24020, -15827, -3393, 9949, 20627, 25777,
	24020, 15827, 3393, -9949, -20627, -25777, -24020, -15827,
	-3393, 9949, 20627, 25777, 24020, 15827, 3393, -9949,
	-20627, -25777, -24020, -15827, -3393, 9949, 20627, 25777,
	24020, 15827, 3393, -9949, -20627, -25777, -24020, -15827,
	-3393, 9949, 20627, 25777, 24020, 15827, 3393, -9949,
	-20627, -25777, -24020, -15827, -3393, 9949, 20627, 25777,
	24020, 15827, 3393, -9949, -20627, -25777, -24020, -15827,
	-3393, 9949, 20627, 25777, 24020, 15827, 3393, -9949,
	-20627, -25777, -24020, -15827, -3393, 9949, 20627, 25777,
	24020, 15827, 3393, -9949, -20627, -25777, -24020, -15827,
	-3393, 9949, 20627, 25777, 24020, 15827, 3393, -9949,
	-20627, -25777, -24020, -15827, -3393, 9949, 20627, 25777,
	24020, 15827, 3393, -9949, -20627, -25777, -24020, -15827,
	-3393, 9949, 20627, 25777, 24020, 15827, 3393, -9949,
	-20627, -25777, -24020, -15827, -3393, 9949, 20627, 25777,
	24020, 15827, 3393, -9949, -20627, -25777, -24020, -15827,
	-3393, 9949, 20627, 25777, 24020, 15827, 3393, -9949,
	-20627, -25777, -24020, -15827, -3393, 9949, 20627, 25777},
	{
// Carrier 12 Phase 6
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114},
	{
// Carrier 12 Phase 7
	9949, -3393, -15827, -24020, -25777, -20627, -9949, 3393,
	15827, 24020, 25777, 20627, 9949, -3393, -15827, -24020,
	-25777, -20627, -9949, 3393, 15827, 24020, 25777, 20627,
	9949, -3393, -15827, -24020, -25777, -20627, -9949, 3393,
	15827, 24020, 25777, 20627, 9949, -3393, -15827, -24020,
	-25777, -20627, -9949, 3393, 15827, 24020, 25777, 20627,
	9949, -3393, -15827, -24020, -25777, -20627, -9949, 3393,
	15827, 24020, 25777, 20627, 9949, -3393, -15827, -24020,
	-25777, -20627, -9949, 3393, 15827, 24020, 25777, 20627,
	9949, -3393, -15827, -24020, -25777, -20627, -9949, 3393,
	15827, 24020, 25777, 20627, 9949, -3393, -15827, -24020,
	-25777, -20627, -9949, 3393, 15827, 24020, 25777, 20627,
	9949, -3393, -15827, -24020, -25777, -20627, -9949, 3393,
	15827, 24020, 25777, 20627, 9949, -3393, -15827, -24020,
	-25777, -20627, -9949, 3393, 15827, 24020, 25777, 20627,
	9949, -3393, -15827, -24020, -25777, -20627, -9949, 3393,
	15827, 24020, 25777, 20627, 9949, -3393, -15827, -24020,
	-25777, -20627, -9949, 3393, 15827, 24020, 25777, 20627,
	9949, -3393, -15827, -24020, -25777, -20627, -9949, 3393,
	15827, 24020, 25777, 20627, 9949, -3393, -15827, -24020,
	-25777, -20627, -9949, 3393, 15827, 24020, 25777, 20627,
	9949, -3393, -15827, -24020, -25777, -20627, -9949, 3393,
	15827, 24020, 25777, 20627, 9949, -3393, -15827, -24020,
	-25777, -20627, -9949, 3393, 15827, 24020, 25777, 20627,
	9949, -3393, -15827, -24020, -25777, -20627, -9949, 3393,
	15827, 24020, 25777, 20627, 9949, -3393, -15827, -24020,
	-25777, -20627, -9949, 3393, 15827, 24020, 25777, 20627},
	},{{

// Carrier 13 Phase 0
	0, 13649, 23234, 25901, 20855, 9599, -4514, -17284,
	-24907, -25114, -17842, -5257, 8892, 20394, 25824, 23563,
	14287, 756, -13000, -22885, -25956, -21297, -10298, 3768,
	16712, 24680, 25299, 18384, 5995, -8178, -19917, -25725,
	-23873, -14912, -1511, 12339, 22516, 25989, 21722, 10988,
	-3018, -16126, -24432, -25462, -18911, -6729, 7456, 19422,
	25605, 24163, 15526, 2265, -11668, -22129, -26000, -22129,
	-11668, 2266, 15526, 24163, 25604, 19422, 7456, -6729,
	-18911, -25462, -24431, -16126, -3018, 10988, 21722, 25989,
	22516, 12339, -1511, -14913, -23873, -25725, -19917, -8178,
	5996, 18384, 25299, 24680, 16712, 3768, -10298, -21297,
	-25956, -22885, -12999, 756, 14287, 23564, 25824, 20394,
	8892, -5257, -17842, -25114, -24907, -17284, -4514, 9599,
	20855, 25901, 23234, 13649, 0, -13649, -23234, -25901,
	-20855, -9599, 4514, 17284, 24907, 25114, 17842, 5257,
	-8892, -20394, -25824, -23563, -14287, -756, 13000, 22885,
	25956, 21297, 10297, -3768, -16712, -24680, -25299, -18384,
	-5995, 8178, 19917, 25725, 23873, 14912, 1511, -12339,
	-22516, -25988, -21722, -10987, 3018, 16126, 24432, 25462,
	18911, 6729, -7457, -19422, -25605, -24162, -15526, -2265,
	11668, 22129, 26000, 22128, 11668, -2266, -15526, -24163,
	-25604, -19422, -7456, 6729, 18911, 25462, 24431, 16125,
	3018, -10988, -21722, -25989, -22516, -12339, 1511, 14913,
	23873, 25725, 19917, 8177, -5996, -18384, -25299, -24680,
	-16712, -3768, 10298, 21298, 25956, 22885, 12999, -756,
	-14287, -23564, -25824, -20394, -8892, 5257, 17842, 25114,
	24907, 17284, 4514, -9599, -20855, -25901, -23234, -13649},
	{
// Carrier 13 Phase 1
	9949, 21078, 25931, 23062, 13326, -378, -13969, -23401,
	-25865, -20627, -9246, 4886, 17565, 25013, 25013, 17565,
	4886, -9246, -20627, -25865, -23401, -13969, -378, 13326,
	23062, 25931, 21078, 9949, -4142, -17000, -24796, -25209,
	-18115, -5627, 8536, 20158, 25777, 23721, 14601, 1134,
	-12671, -22703, -25975, -21512, -10644, 3393, 16421, 24558,
	25383, 18650, 6363, -7818, -19672, -25667, -24020, -15221,
	-1889, 12005, 22325, 25997, 21928, 11329, -2642, -15827,
	-24300, -25536, -19169, -7093, 7093, 19169, 25536, 24300,
	15827, 2642, -11329, -21928, -25997, -22325, -12005, 1889,
	15221, 24020, 25667, 19671, 7818, -6363, -18650, -25383,
	-24558, -16420, -3393, 10644, 21512, 25975, 22703, 12671,
	-1134, -14601, -23721, -25777, -20158, -8536, 5627, 18115,
	25209, 24796, 17000, 4141, -9949, -21078, -25931, -23062,
	-13326, 378, 13969, 23401, 25865, 20627, 9246, -4886,
	-17565, -25013, -25013, -17565, -4886, 9247, 20627, 25865,
	23401, 13969, 378, -13326, -23062, -25931, -21078, -9949,
	4142, 17000, 24796, 25209, 18115, 5627, -8536, -20158,
	-25777, -23721, -14601, -1133, 12671, 22703, 25975, 21512,
	10644, -3393, -16421, -24558, -25383, -18650, -6363, 7818,
	19672, 25667, 24020, 15221, 1888, -12005, -22325, -25997,
	-21928, -11329, 2642, 15827, 24300, 25536, 19169, 7093,
	-7094, -19169, -25536, -24300, -15827, -2642, 11329, 21928,
	25997, 22325, 12005, -1889, -15221, -24020, -25667, -19671,
	-7818, 6363, 18650, 25383, 24558, 16420, 3393, -10644,
	-21512, -25975, -22703, -12670, 1134, 14601, 23721, 25777,
	20157, 8536, -5627, -18115, -25209, -24796, -17000, -4141},
	{
// Carrier 13 Phase 2
	18384, 25299, 24680, 16712, 3768, -10298, -21297, -25956,
	-22885, -12999, 756, 14287, 23564, 25824, 20394, 8892,
	-5257, -17842, -25114, -24907, -17284, -4514, 9599, 20855,
	25901, 23234, 13649, 0, -13649, -23234, -25901, -20855,
	-9599, 4514, 17284, 24907, 25114, 17842, 5257, -8892,
	-20394, -25824, -23563, -14287, -756, 13000, 22885, 25956,
	21297, 10298, -3768, -16712, -24680, -25299, -18384, -5995,
	8178, 19917, 25725, 23873, 14912, 1511, -12339, -22516,
	-25988, -21722, -10988, 3018, 16126, 24432, 25462, 18911,
	6729, -7456, -19422, -25605, -24163, -15526, -2265, 11668,
	22129, 26000, 22128, 11668, -2266, -15526, -24163, -25604,
	-19422, -7456, 6729, 18911, 25462, 24431, 16126, 3018,
	-10988, -21722, -25989, -22516, -12339, 1511, 14913, 23873,
	25725, 19917, 8178, -5996, -18384, -25299, -24680, -16712,
	-3768, 10298, 21298, 25956, 22885, 12999, -756, -14287,
	-23564, -25824, -20394, -8892, 5257, 17842, 25114, 24907,
	17284, 4514, -9599, -20855, -25901, -23234, -13649, 0,
	13649, 23234, 25901, 20855, 9599, -4515, -17284, -24907,
	-25114, -17842, -5257, 8892, 20394, 25824, 23563, 14287,
	756, -13000, -22885, -25956, -21297, -10297, 3768, 16712,
	24680, 25299, 18384, 5995, -8178, -19917, -25725, -23873,
	-14912, -1511, 12339, 22516, 25988, 21722, 10987, -3018,
	-16126, -24432, -25462, -18911, -6729, 7457, 19422, 25605,
	24162, 15525, 2265, -11668, -22129, -26000, -22128, -11668,
	2266, 15526, 24163, 25604, 19422, 7456, -6729, -18911,
	-25462, -24431, -16125, -3018, 10988, 21722, 25989, 22516,
	12339, -1511, -14913, -23873, -25725, -19917, -8177, 5996},
	{
// Carrier 13 Phase 3
	24020, 25667, 19671, 7818, -6363, -18650, -25383, -24558,
	-16421, -3393, 10644, 21512, 25975, 22703, 12671, -1134,
	-14601, -23721, -25777, -20158, -8536, 5627, 18115, 25209,
	24796, 17000, 4141, -9949, -21078, -25931, -23062, -13326,
	378, 13969, 23401, 25865, 20627, 9246, -4886, -17565,
	-25013, -25013, -17565, -4886, 9246, 20627, 25865, 23401,
	13969, 378, -13326, -23062, -25931, -21078, -9949, 4142,
	17000, 24796, 25209, 18115, 5627, -8536, -20158, -25777,
	-23721, -14601, -1134, 12671, 22703, 25975, 21512, 10644,
	-3393, -16421, -24558, -25383, -18650, -6363, 7818, 19672,
	25667, 24020, 15221, 1889, -12005, -22325, -25997, -21928,
	-11329, 2642, 15827, 24300, 25536, 19169, 7093, -7093,
	-19169, -25536, -24300, -15827, -2642, 11329, 21928, 25997,
	22325, 12005, -1889, -15221, -24020, -25667, -19671, -7818,
	6363, 18650, 25383, 24558, 16420, 3393, -10644, -21512,
	-25975, -22703, -12671, 1134, 14601, 23721, 25777, 20158,
	8536, -5627, -18115, -25209, -24796, -17000, -4141, 9949,
	21078, 25931, 23062, 13325, -378, -13969, -23401, -25865,
	-20627, -9246, 4886, 17565, 25013, 25013, 17565, 4886,
	-9247, -20627, -25865, -23401, -13969, -377, 13326, 23062,
	25931, 21078, 9949, -4142, -17000, -24796, -25209, -18115,
	-5627, 8536, 20158, 25777, 23721, 14601, 1133, -12671,
	-22703, -25975, -21512, -10644, 3393, 16421, 24558, 25383,
	18650, 6363, -7818, -19672, -25667, -24020, -15220, -1888,
	12005, 22325, 25997, 21928, 11329, -2642, -15827, -24300,
	-25536, -19169, -7093, 7094, 19169, 25536, 24300, 15827,
	2642, -11329, -21928, -25997, -22325, -12005, 1889, 15221},
	{
// Carrier 13 Phase 4
	26000, 22129, 11668, -2266, -15526, -24163, -25605, -19422,
	-7456, 6729, 18911, 25462, 24432, 16126, 3018, -10988,
	-21722, -25989, -22516, -12339, 1511, 14913, 23873, 25725,
	19917, 8178, -5996, -18384, -25299, -24680, -16712, -3768,
	10298, 21297, 25956, 22885, 12999, -756, -14287, -23564,
	-25824, -20394, -8892, 5257, 17842, 25114, 24907, 17284,
	4514, -9599, -20855, -25901, -23234, -13649, 0, 13649,
	23234, 25901, 20855, 9599, -4514, -17284, -24907, -25114,
	-17842, -5257, 8892, 20394, 25824, 23563, 14287, 756,
	-13000, -22885, -25956, -21297, -10298, 3768, 16712, 24680,
	25299, 18384, 5995, -8178, -19917, -25725, -23873, -14912,
	-1511, 12339, 22516, 25988, 21722, 10987, -3018, -16126,
	-24432, -25462, -18911, -6729, 7456, 19422, 25605, 24162,
	15526, 2265, -11668, -22129, -26000, -22128, -11668, 2266,
	15526, 24163, 25604, 19422, 7456, -6729, -18911, -25462,
	-24431, -16126, -3018, 10988, 21722, 25989, 22516, 12339,
	-1511, -14913, -23873, -25725, -19917, -8178, 5996, 18384,
	25299, 24680, 16712, 3768, -10298, -21298, -25956, -22885,
	-12999, 756, 14287, 23564, 25824, 20394, 8892, -5257,
	-17842, -25114, -24907, -17284, -4514, 9599, 20855, 25901,
	23234, 13649, 0, -13649, -23234, -25901, -20855, -9599,
	4515, 17284, 24907, 25114, 17842, 5257, -8892, -20394,
	-25824, -23563, -14287, -756, 13000, 22885, 25956, 21297,
	10297, -3768, -16712, -24680, -25299, -18384, -5995, 8178,
	19917, 25725, 23873, 14912, 1511, -12339, -22516, -25988,
	-21722, -10987, 3018, 16126, 24432, 25462, 18911, 6729,
	-7457, -19422, -25605, -24162, -15525, -2265, 11668, 22129},
	{
// Carrier 13 Phase 5
	24020, 15221, 1889, -12005, -22325, -25997, -21928, -11329,
	2642, 15827, 24300, 25536, 19169, 7093, -7093, -19169,
	-25536, -24300, -15827, -2642, 11329, 21928, 25997, 22325,
	12005, -1889, -15221, -24020, -25667, -19671, -7818, 6363,
	18650, 25383, 24558, 16421, 3393, -10644, -21512, -25975,
	-22703, -12671, 1134, 14601, 23721, 25777, 20158, 8536,
	-5627, -18115, -25209, -24796, -17000, -4141, 9949, 21078,
	25931, 23062, 13326, -378, -13969, -23401, -25865, -20627,
	-9246, 4886, 17565, 25013, 25013, 17565, 4886, -9246,
	-20627, -25865, -23401, -13969, -378, 13326, 23062, 25931,
	21078, 9949, -4142, -17000, -24796, -25209, -18115, -5627,
	8536, 20158, 25777, 23721, 14601, 1133, -12671, -22703,
	-25975, -21512, -10644, 3393, 16421, 24558, 25383, 18650,
	6363, -7818, -19672, -25667, -24020, -15221, -1888, 12005,
	22325, 25997, 21928, 11329, -2642, -15827, -24300, -25536,
	-19169, -7093, 7093, 19169, 25536, 24300, 15827, 2642,
	-11329, -21928, -25997, -22325, -12005, 1889, 15221, 24020,
	25667, 19671, 7818, -6363, -18650, -25383, -24558, -16420,
	-3393, 10644, 21512, 25975, 22703, 12670, -1134, -14601,
	-23721, -25777, -20158, -8536, 5627, 18115, 25209, 24796,
	17000, 4141, -9949, -21078, -25931, -23062, -13325, 378,
	13969, 23401, 25865, 20627, 9246, -4886, -17565, -25013,
	-25013, -17565, -4886, 9247, 20627, 25865, 23401, 13969,
	377, -13326, -23062, -25931, -21078, -9949, 4142, 17000,
	24796, 25209, 18115, 5627, -8536, -20158, -25777, -23721,
	-14601, -1133, 12671, 22703, 25975, 21512, 10643, -3393,
	-16421, -24558, -25383, -18650, -6363, 7818, 19672, 25667},
	{
// Carrier 13 Phase 6
	18384, 5996, -8178, -19917, -25725, -23873, -14912, -1511,
	12339, 22516, 25989, 21722, 10988, -3018, -16126, -24432,
	-25462, -18911, -6729, 7456, 19422, 25605, 24163, 15526,
	2266, -11668, -22129, -26000, -22129, -11668, 2266, 15526,
	24163, 25604, 19422, 7456, -6729, -18911, -25462, -24431,
	-16126, -3018, 10988, 21722, 25989, 22516, 12339, -1511,
	-14913, -23873, -25725, -19917, -8178, 5996, 18384, 25299,
	24680, 16712, 3768, -10298, -21297, -25956, -22885, -12999,
	756, 14287, 23564, 25824, 20394, 8892, -5257, -17842,
	-25114, -24907, -17284, -4514, 9599, 20855, 25901, 23234,
	13649, 0, -13649, -23234, -25901, -20855, -9599, 4514,
	17284, 24907, 25114, 17842, 5257, -8892, -20394, -25824,
	-23563, -14287, -756, 13000, 22885, 25956, 21297, 10297,
	-3768, -16712, -24680, -25299, -18384, -5995, 8178, 19917,
	25725, 23873, 14912, 1511, -12339, -22516, -25988, -21722,
	-10987, 3018, 16126, 24432, 25462, 18911, 6729, -7457,
	-19422, -25605, -24162, -15526, -2265, 11668, 22129, 26000,
	22128, 11668, -2266, -15526, -24163, -25604, -19422, -7456,
	6729, 18911, 25462, 24431, 16125, 3018, -10988, -21722,
	-25989, -22516, -12339, 1511, 14913, 23873, 25725, 19917,
	8177, -5996, -18384, -25299, -24680, -16712, -3768, 10298,
	21298, 25956, 22885, 12999, -756, -14287, -23564, -25824,
	-20394, -8892, 5257, 17842, 25114, 24907, 17284, 4514,
	-9599, -20855, -25901, -23234, -13649, 0, 13649, 23234,
	25901, 20855, 9599, -4515, -17284, -24907, -25114, -17842,
	-5257, 8892, 20394, 25824, 23563, 14287, 755, -13000,
	-22885, -25955, -21297, -10297, 3768, 16712, 24680, 25299},
	{
// Carrier 13 Phase 7
	9949, -4141, -17000, -24796, -25209, -18115, -5627, 8536,
	20158, 25777, 23721, 14601, 1134, -12671, -22703, -25975,
	-21512, -10644, 3393, 16421, 24558, 25383, 18650, 6363,
	-7818, -19671, -25667, -24020, -15221, -1889, 12005, 22325,
	25997, 21928, 11329, -2642, -15827, -24300, -25536, -19169,
	-7093, 7093, 19169, 25536, 24300, 15827, 2642, -11329,
	-21928, -25997, -22325, -12005, 1889, 15221, 24020, 25667,
	19671, 7818, -6363, -18650, -25383, -24558, -16420, -3393,
	10644, 21512, 25975, 22703, 12671, -1134, -14601, -23721,
	-25777, -20158, -8536, 5627, 18115, 25209, 24796, 17000,
	4141, -9949, -21078, -25931, -23062, -13326, 378, 13969,
	23401, 25865, 20627, 9246, -4886, -17565, -25013, -25013,
	-17565, -4886, 9247, 20627, 25865, 23401, 13969, 378,
	-13326, -23062, -25931, -21078, -9949, 4142, 17000, 24796,
	25209, 18115, 5627, -8536, -20158, -25777, -23721, -14601,
	-1133, 12671, 22703, 25975, 21512, 10644, -3393, -16421,
	-24558, -25383, -18650, -6363, 7818, 19672, 25667, 24020,
	15221, 1888, -12005, -22325, -25997, -21928, -11329, 2642,
	15827, 24300, 25536, 19169, 7093, -7093, -19169, -25536,
	-24300, -15827, -2642, 11329, 21928, 25997, 22325, 12005,
	-1889, -15221, -24020, -25667, -19671, -7818, 6363, 18650,
	25383, 24558, 16420, 3393, -10644, -21512, -25975, -22703,
	-12670, 1134, 14601, 23721, 25777, 20157, 8536, -5627,
	-18115, -25209, -24796, -17000, -4141, 9949, 21078, 25931,
	23062, 13325, -378, -13969, -23401, -25865, -20627, -9246,
	4886, 17565, 25013, 25013, 17565, 4886, -9247, -20627,
	-25865, -23401, -13969, -377, 13326, 23062, 25931, 21078},
	},{{

// Carrier 14 Phase 0
	0, 14287, 23873, 25605, 18911, 5996, -8892, -20855,
	-25956, -22516, -11668, 3018, 16712, 24907, 24907, 16712,
	3018, -11668, -22516, -25956, -20855, -8892, 5996, 18911,
	25605, 23873, 14287, 0, -14287, -23873, -25604, -18911,
	-5995, 8892, 20855, 25956, 22516, 11668, -3018, -16712,
	-24907, -24907, -16712, -3018, 11668, 22516, 25956, 20855,
	8892, -5996, -18911, -25605, -23873, -14287, 0, 14287,
	23873, 25604, 18911, 5995, -8892, -20855, -25956, -22516,
	-11668, 3018, 16712, 24907, 24907, 16712, 3018, -11668,
	-22516, -25956, -20855, -8892, 5996, 18911, 25605, 23873,
	14287, 0, -14287, -23873, -25604, -18911, -5995, 8892,
	20855, 25956, 22516, 11668, -3018, -16712, -24907, -24907,
	-16712, -3018, 11668, 22516, 25956, 20855, 8892, -5996,
	-18911, -25605, -23873, -14287, 0, 14287, 23873, 25604,
	18911, 5995, -8892, -20855, -25956, -22516, -11668, 3018,
	16712, 24907, 24907, 16712, 3018, -11668, -22516, -25956,
	-20855, -8892, 5996, 18911, 25605, 23873, 14287, 0,
	-14287, -23873, -25604, -18911, -5995, 8892, 20855, 25956,
	22516, 11668, -3018, -16712, -24907, -24907, -16712, -3018,
	11668, 22516, 25956, 20855, 8892, -5996, -18911, -25605,
	-23873, -14287, 0, 14287, 23873, 25604, 18911, 5995,
	-8892, -20855, -25956, -22516, -11668, 3018, 16712, 24907,
	24907, 16712, 3018, -11668, -22516, -25955, -20855, -8892,
	5996, 18911, 25605, 23873, 14287, 0, -14287, -23873,
	-25604, -18911, -5995, 8892, 20855, 25956, 22516, 11668,
	-3018, -16712, -24907, -24907, -16712, -3018, 11669, 22516,
	25955, 20855, 8892, -5996, -18911, -25605, -23873, -14286},
	{
// Carrier 14 Phase 1
	9949, 21512, 25997, 21928, 10644, -4141, -17565, -25209,
	-24558, -15827, -1889, 12671, 23062, 25865, 20158, 7818,
	-7093, -19671, -25777, -23401, -13326, 1134, 15221, 24300,
	25383, 18115, 4886, -9949, -21512, -25997, -21928, -10644,
	4142, 17565, 25209, 24558, 15827, 1889, -12671, -23062,
	-25865, -20158, -7818, 7093, 19672, 25777, 23401, 13326,
	-1134, -15221, -24300, -25383, -18115, -4886, 9949, 21512,
	25997, 21928, 10644, -4142, -17565, -25209, -24558, -15827,
	-1889, 12671, 23062, 25865, 20158, 7818, -7093, -19672,
	-25777, -23401, -13326, 1134, 15221, 24300, 25383, 18115,
	4886, -9949, -21512, -25997, -21928, -10644, 4142, 17565,
	25209, 24558, 15827, 1888, -12671, -23062, -25865, -20158,
	-7818, 7093, 19672, 25777, 23401, 13325, -1134, -15221,
	-24300, -25383, -18115, -4886, 9949, 21512, 25997, 21928,
	10644, -4142, -17565, -25209, -24558, -15827, -1888, 12671,
	23062, 25865, 20158, 7818, -7093, -19672, -25777, -23401,
	-13325, 1134, 15221, 24300, 25383, 18115, 4886, -9949,
	-21512, -25997, -21928, -10644, 4142, 17565, 25209, 24558,
	15827, 1888, -12671, -23062, -25865, -20157, -7818, 7094,
	19672, 25777, 23401, 13325, -1134, -15221, -24300, -25383,
	-18115, -4886, 9949, 21512, 25997, 21928, 10643, -4142,
	-17565, -25209, -24558, -15827, -1888, 12671, 23062, 25865,
	20157, 7818, -7094, -19672, -25777, -23401, -13325, 1134,
	15221, 24300, 25383, 18115, 4886, -9949, -21512, -25997,
	-21928, -10643, 4142, 17565, 25209, 24558, 15827, 1888,
	-12671, -23062, -25865, -20157, -7818, 7094, 19672, 25777,
	23401, 13325, -1134, -15221, -24300, -25383, -18115, -4886},
	{
// Carrier 14 Phase 2
	18384, 25462, 24163, 14912, 756, -13649, -23563, -25725,
	-19422, -6729, 8178, 20394, 25901, 22885, 12339, -2266,
	-16126, -24680, -25114, -17284, -3768, 10988, 22129, 25989,
	21297, 9599, -5257, -18384, -25462, -24163, -14912, -756,
	13649, 23564, 25725, 19422, 6729, -8178, -20394, -25901,
	-22885, -12339, 2266, 16126, 24680, 25114, 17284, 3768,
	-10988, -22129, -25988, -21297, -9599, 5257, 18384, 25462,
	24163, 14912, 756, -13649, -23564, -25725, -19422, -6729,
	8178, 20394, 25901, 22885, 12339, -2266, -16126, -24680,
	-25114, -17284, -3768, 10988, 22129, 25988, 21297, 9599,
	-5257, -18384, -25462, -24162, -14912, -756, 13649, 23564,
	25725, 19422, 6729, -8178, -20394, -25901, -22885, -12339,
	2266, 16126, 24680, 25114, 17284, 3768, -10988, -22129,
	-25988, -21297, -9599, 5257, 18384, 25462, 24162, 14912,
	756, -13649, -23564, -25725, -19422, -6729, 8178, 20394,
	25901, 22885, 12339, -2266, -16126, -24680, -25114, -17284,
	-3768, 10988, 22129, 25988, 21297, 9599, -5257, -18384,
	-25462, -24162, -14912, -756, 13649, 23564, 25725, 19422,
	6729, -8178, -20394, -25901, -22885, -12339, 2266, 16126,
	24680, 25114, 17284, 3768, -10988, -22129, -25988, -21297,
	-9599, 5257, 18384, 25462, 24162, 14912, 755, -13649,
	-23564, -25725, -19422, -6729, 8178, 20394, 25901, 22885,
	12339, -2266, -16126, -24680, -25114, -17284, -3767, 10988,
	22129, 25988, 21297, 9599, -5257, -18384, -25462, -24162,
	-14912, -755, 13649, 23564, 25725, 19422, 6729, -8178,
	-20394, -25901, -22885, -12339, 2266, 16126, 24680, 25113,
	17284, 3767, -10988, -22129, -25988, -21297, -9599, 5257},
	{
// Carrier 14 Phase 3
	24020, 25536, 18650, 5627, -9246, -21078, -25975, -22325,
	-11329, 3393, 17000, 25013, 24796, 16421, 2642, -12005,
	-22703, -25931, -20627, -8536, 6363, 19169, 25667, 23721,
	13969, -378, -14601, -24020, -25536, -18650, -5627, 9246,
	21078, 25975, 22325, 11329, -3393, -17000, -25013, -24796,
	-16421, -2642, 12005, 22703, 25931, 20627, 8536, -6363,
	-19169, -25667, -23721, -13969, 378, 14601, 24020, 25536,
	18650, 5627, -9246, -21078, -25975, -22325, -11329, 3393,
	17000, 25013, 24796, 16420, 2642, -12005, -22703, -25931,
	-20627, -8536, 6363, 19169, 25667, 23721, 13969, -378,
	-14601, -24020, -25536, -18650, -5627, 9247, 21078, 25975,
	22325, 11329, -3393, -17000, -25013, -24796, -16420, -2642,
	12005, 22703, 25931, 20627, 8536, -6363, -19169, -25667,
	-23721, -13969, 378, 14601, 24020, 25536, 18650, 5627,
	-9247, -21078, -25975, -22325, -11329, 3393, 17000, 25013,
	24796, 16420, 2642, -12005, -22703, -25931, -20627, -8536,
	6363, 19169, 25667, 23721, 13969, -378, -14601, -24020,
	-25536, -18650, -5627, 9247, 21078, 25975, 22325, 11329,
	-3393, -17000, -25013, -24796, -16420, -2642, 12005, 22703,
	25931, 20627, 8536, -6363, -19169, -25667, -23721, -13969,
	378, 14601, 24020, 25536, 18650, 5627, -9247, -21078,
	-25975, -22325, -11329, 3393, 17000, 25013, 24796, 16420,
	2642, -12005, -22703, -25931, -20627, -8536, 6363, 19169,
	25667, 23721, 13969, -378, -14601, -24020, -25536, -18650,
	-5627, 9247, 21078, 25975, 22325, 11329, -3393, -17000,
	-25013, -24796, -16420, -2642, 12005, 22703, 25931, 20627,
	8535, -6363, -19169, -25668, -23721, -13969, 378, 14601},
	{
// Carrier 14 Phase 4
	26000, 21722, 10298, -4514, -17842, -25299, -24432, -15526,
	-1511, 13000, 23234, 25824, 19917, 7456, -7456, -19917,
	-25824, -23234, -12999, 1511, 15526, 24432, 25299, 17842,
	4514, -10298, -21722, -26000, -21722, -10298, 4514, 17842,
	25299, 24431, 15526, 1511, -13000, -23234, -25824, -19917,
	-7456, 7456, 19917, 25824, 23234, 12999, -1511, -15526,
	-24432, -25299, -17842, -4514, 10298, 21722, 26000, 21722,
	10298, -4514, -17842, -25299, -24431, -15526, -1511, 13000,
	23234, 25824, 19917, 7456, -7456, -19917, -25824, -23234,
	-12999, 1511, 15526, 24432, 25299, 17842, 4514, -10298,
	-21722, -26000, -21722, -10297, 4514, 17842, 25299, 24431,
	15526, 1511, -13000, -23234, -25824, -19917, -7456, 7457,
	19917, 25824, 23234, 12999, -1511, -15526, -24432, -25299,
	-17842, -4514, 10298, 21722, 26000, 21722, 10297, -4515,
	-17842, -25299, -24431, -15526, -1511, 13000, 23234, 25824,
	19917, 7456, -7457, -19917, -25824, -23234, -12999, 1511,
	15526, 24432, 25299, 17842, 4514, -10298, -21722, -26000,
	-21722, -10297, 4515, 17842, 25299, 24431, 15525, 1511,
	-13000, -23234, -25824, -19917, -7456, 7457, 19917, 25824,
	23234, 12999, -1511, -15526, -24432, -25299, -17842, -4514,
	10298, 21722, 26000, 21722, 10297, -4515, -17842, -25299,
	-24431, -15525, -1511, 13000, 23234, 25824, 19917, 7456,
	-7457, -19917, -25824, -23234, -12999, 1512, 15526, 24432,
	25299, 17842, 4514, -10298, -21722, -26000, -21722, -10297,
	4515, 17842, 25299, 24431, 15525, 1511, -13000, -23234,
	-25824, -19916, -7456, 7457, 19917, 25824, 23234, 12999,
	-1512, -15526, -24432, -25299, -17842, -4514, 10298, 21722},
	{
// Carrier 14 Phase 5
	24020, 14601, 378, -13969, -23721, -25667, -19169, -6363,
	8536, 20627, 25931, 22703, 12005, -2642, -16421, -24796,
	-25013, -17000, -3393, 11329, 22325, 25975, 21078, 9246,
	-5627, -18650, -25536, -24020, -14601, -378, 13969, 23721,
	25667, 19169, 6363, -8536, -20627, -25931, -22703, -12005,
	2642, 16421, 24796, 25013, 17000, 3393, -11329, -22325,
	-25975, -21078, -9246, 5627, 18650, 25536, 24020, 14601,
	378, -13969, -23721, -25667, -19169, -6363, 8536, 20627,
	25931, 22703, 12005, -2642, -16421, -24796, -25013, -17000,
	-3393, 11329, 22325, 25975, 21078, 9246, -5627, -18650,
	-25536, -24020, -14601, -378, 13969, 23721, 25667, 19169,
	6363, -8536, -20627, -25931, -22703, -12005, 2642, 16421,
	24796, 25013, 17000, 3393, -11329, -22325, -25975, -21078,
	-9246, 5627, 18650, 25536, 24020, 14601, 377, -13969,
	-23721, -25667, -19169, -6363, 8536, 20627, 25931, 22703,
	12005, -2642, -16421, -24796, -25013, -17000, -3393, 11329,
	22325, 25975, 21078, 9246, -5627, -18650, -25536, -24020,
	-14601, -377, 13969, 23721, 25667, 19169, 6363, -8536,
	-20627, -25931, -22703, -12005, 2642, 16421, 24796, 25013,
	17000, 3393, -11329, -22325, -25975, -21078, -9246, 5627,
	18650, 25536, 24020, 14601, 377, -13969, -23721, -25667,
	-19169, -6363, 8536, 20627, 25931, 22703, 12005, -2642,
	-16421, -24796, -25013, -17000, -3393, 11329, 22325, 25975,
	21078, 9246, -5627, -18650, -25536, -24020, -14601, -377,
	13970, 23721, 25667, 19169, 6363, -8536, -20627, -25931,
	-22703, -12005, 2642, 16421, 24796, 25013, 17000, 3393,
	-11329, -22325, -25975, -21078, -9246, 5627, 18650, 25536},
	{
// Carrier 14 Phase 6
	18384, 5257, -9599, -21297, -25989, -22129, -10988, 3768,
	17284, 25114, 24680, 16126, 2266, -12339, -22885, -25901,
	-20394, -8178, 6729, 19422, 25725, 23563, 13649, -756,
	-14913, -24163, -25462, -18384, -5257, 9599, 21297, 25989,
	22129, 10988, -3768, -17284, -25114, -24680, -16126, -2265,
	12339, 22885, 25901, 20394, 8178, -6729, -19422, -25725,
	-23563, -13649, 756, 14913, 24163, 25462, 18384, 5257,
	-9599, -21297, -25989, -22128, -10988, 3768, 17284, 25114,
	24680, 16126, 2265, -12339, -22885, -25901, -20394, -8178,
	6729, 19422, 25725, 23563, 13649, -756, -14913, -24163,
	-25462, -18384, -5257, 9599, 21298, 25989, 22128, 10987,
	-3768, -17284, -25114, -24680, -16126, -2265, 12339, 22885,
	25901, 20394, 8178, -6729, -19422, -25725, -23563, -13649,
	756, 14913, 24163, 25462, 18384, 5257, -9599, -21298,
	-25989, -22128, -10987, 3768, 17284, 25114, 24680, 16125,
	2265, -12339, -22885, -25901, -20394, -8178, 6729, 19422,
	25725, 23563, 13649, -756, -14913, -24163, -25462, -18384,
	-5257, 9599, 21298, 25989, 22128, 10987, -3768, -17284,
	-25114, -24680, -16125, -2265, 12339, 22885, 25901, 20394,
	8177, -6729, -19422, -25725, -23563, -13649, 756, 14913,
	24163, 25462, 18384, 5257, -9599, -21298, -25989, -22128,
	-10987, 3768, 17284, 25114, 24680, 16125, 2265, -12339,
	-22885, -25901, -20394, -8177, 6729, 19422, 25725, 23563,
	13649, -756, -14913, -24163, -25462, -18384, -5257, 9599,
	21298, 25989, 22128, 10987, -3768, -17284, -25114, -24680,
	-16125, -2265, 12339, 22885, 25901, 20394, 8177, -6729,
	-19422, -25725, -23563, -13649, 756, 14913, 24163, 25462},
	{
// Carrier 14 Phase 7
	9949, -4886, -18115, -25383, -24300, -15221, -1134, 13326,
	23401, 25777, 19671, 7093, -7818, -20158, -25865, -23062,
	-12671, 1889, 15827, 24558, 25209, 17565, 4141, -10644,
	-21928, -25997, -21512, -9949, 4886, 18115, 25383, 24300,
	15221, 1134, -13326, -23401, -25777, -19671, -7093, 7818,
	20158, 25865, 23062, 12671, -1889, -15827, -24558, -25209,
	-17565, -4141, 10644, 21928, 25997, 21512, 9949, -4886,
	-18115, -25383, -24300, -15221, -1134, 13326, 23401, 25777,
	19671, 7093, -7818, -20158, -25865, -23062, -12671, 1889,
	15827, 24558, 25209, 17565, 4141, -10644, -21928, -25997,
	-21512, -9949, 4886, 18115, 25383, 24300, 15221, 1133,
	-13326, -23401, -25777, -19671, -7093, 7818, 20158, 25865,
	23062, 12671, -1889, -15827, -24558, -25209, -17565, -4141,
	10644, 21928, 25997, 21512, 9949, -4886, -18115, -25383,
	-24300, -15221, -1133, 13326, 23401, 25777, 19671, 7093,
	-7818, -20158, -25865, -23062, -12670, 1889, 15827, 24558,
	25209, 17565, 4141, -10644, -21928, -25997, -21512, -9949,
	4886, 18115, 25383, 24300, 15221, 1133, -13326, -23401,
	-25777, -19671, -7093, 7818, 20158, 25865, 23062, 12670,
	-1889, -15827, -24558, -25209, -17565, -4141, 10644, 21928,
	25997, 21512, 9949, -4886, -18115, -25383, -24300, -15220,
	-1133, 13326, 23401, 25777, 19671, 7093, -7818, -20158,
	-25865, -23062, -12670, 1889, 15828, 24558, 25209, 17565,
	4141, -10644, -21928, -25997, -21512, -9949, 4887, 18115,
	25383, 24299, 15220, 1133, -13326, -23401, -25777, -19671,
	-7093, 7818, 20158, 25865, 23062, 12670, -1889, -15828,
	-24558, -25209, -17565, -4141, 10644, 21928, 25997, 21512},
	},{{

// Carrier 15 Phase 0
	0, 14912, 24432, 25114, 16712, 2266, -12999, -23563,
	-25605, -18384, -4514, 10988, 22516, 25901, 19917, 6729,
	-8892, -21297, -26000, -21297, -8892, 6729, 19917, 25901,
	22516, 10988, -4514, -18384, -25604, -23564, -13000, 2265,
	16712, 25114, 24432, 14913, 0, -14912, -24431, -25114,
	-16712, -2266, 12999, 23563, 25605, 18384, 4514, -10988,
	-22516, -25901, -19917, -6729, 8892, 21297, 26000, 21298,
	8892, -6729, -19917, -25901, -22516, -10988, 4514, 18384,
	25604, 23564, 13000, -2265, -16712, -25114, -24432, -14913,
	0, 14912, 24431, 25114, 16712, 2266, -12999, -23563,
	-25605, -18384, -4514, 10987, 22516, 25901, 19917, 6729,
	-8892, -21297, -26000, -21298, -8892, 6729, 19917, 25901,
	22516, 10988, -4514, -18384, -25604, -23564, -13000, 2265,
	16712, 25114, 24432, 14913, 0, -14912, -24431, -25114,
	-16712, -2266, 12999, 23563, 25605, 18384, 4515, -10987,
	-22516, -25901, -19917, -6729, 8892, 21297, 26000, 21298,
	8892, -6729, -19917, -25901, -22516, -10988, 4514, 18384,
	25604, 23564, 13000, -2265, -16712, -25114, -24432, -14913,
	0, 14912, 24431, 25114, 16712, 2266, -12999, -23563,
	-25605, -18384, -4515, 10987, 22516, 25901, 19917, 6729,
	-8892, -21297, -26000, -21298, -8892, 6729, 19916, 25901,
	22516, 10988, -4514, -18384, -25604, -23564, -13000, 2265,
	16712, 25113, 24432, 14913, 0, -14912, -24431, -25114,
	-16712, -2266, 12999, 23563, 25605, 18385, 4515, -10987,
	-22516, -25901, -19917, -6729, 8892, 21297, 26000, 21298,
	8892, -6728, -19916, -25901, -22516, -10988, 4514, 18384,
	25604, 23564, 13000, -2265, -16712, -25113, -24432, -14913},
	{
// Carrier 15 Phase 1
	9949, 21928, 25975, 20627, 7818, -7818, -20627, -25975,
	-21928, -9949, 5627, 19169, 25777, 23062, 12005, -3393,
	-17565, -25383, -24020, -13969, 1134, 15827, 24796, 24796,
	15827, 1134, -13969, -24020, -25383, -17565, -3393, 12005,
	23062, 25777, 19169, 5627, -9949, -21928, -25975, -20627,
	-7818, 7818, 20627, 25975, 21928, 9949, -5627, -19169,
	-25777, -23062, -12005, 3393, 17565, 25383, 24020, 13969,
	-1134, -15827, -24796, -24796, -15827, -1134, 13969, 24020,
	25383, 17565, 3393, -12005, -23062, -25777, -19169, -5627,
	9949, 21928, 25975, 20627, 7818, -7818, -20627, -25975,
	-21928, -9949, 5627, 19169, 25777, 23062, 12005, -3393,
	-17565, -25383, -24020, -13969, 1133, 15827, 24796, 24796,
	15827, 1134, -13969, -24020, -25383, -17565, -3393, 12005,
	23062, 25777, 19169, 5627, -9949, -21928, -25975, -20627,
	-7818, 7818, 20627, 25975, 21928, 9949, -5627, -19169,
	-25777, -23062, -12005, 3393, 17565, 25383, 24020, 13969,
	-1133, -15827, -24796, -24796, -15827, -1134, 13969, 24020,
	25383, 17565, 3393, -12005, -23062, -25777, -19169, -5627,
	9949, 21928, 25975, 20627, 7818, -7818, -20627, -25975,
	-21928, -9950, 5627, 19169, 25777, 23062, 12005, -3393,
	-17565, -25383, -24020, -13970, 1133, 15827, 24796, 24796,
	15828, 1134, -13969, -24020, -25383, -17565, -3393, 12005,
	23062, 25777, 19169, 5627, -9949, -21928, -25975, -20627,
	-7818, 7818, 20626, 25975, 21928, 9950, -5627, -19168,
	-25777, -23062, -12005, 3393, 17565, 25383, 24020, 13970,
	-1133, -15827, -24796, -24796, -15828, -1134, 13969, 24020,
	25383, 17565, 3394, -12005, -23062, -25777, -19169, -5627},
	{
// Carrier 15 Phase 2
	18384, 25605, 23564, 13000, -2266, -16712, -25114, -24432,
	-14913, 0, 14912, 24432, 25114, 16712, 2266, -12999,
	-23563, -25605, -18384, -4514, 10988, 22516, 25901, 19917,
	6729, -8892, -21297, -26000, -21297, -8892, 6729, 19917,
	25901, 22516, 10988, -4514, -18384, -25604, -23564, -13000,
	2265, 16712, 25114, 24432, 14913, 0, -14912, -24431,
	-25114, -16712, -2266, 12999, 23563, 25605, 18384, 4514,
	-10987, -22516, -25901, -19917, -6729, 8892, 21297, 26000,
	21298, 8892, -6729, -19917, -25901, -22516, -10988, 4514,
	18384, 25604, 23564, 13000, -2265, -16712, -25114, -24432,
	-14913, 0, 14912, 24431, 25114, 16712, 2266, -12999,
	-23563, -25605, -18384, -4515, 10987, 22516, 25901, 19917,
	6729, -8892, -21297, -26000, -21298, -8892, 6729, 19917,
	25901, 22516, 10988, -4514, -18384, -25604, -23564, -13000,
	2265, 16712, 25114, 24432, 14913, 0, -14912, -24431,
	-25114, -16712, -2266, 12999, 23563, 25605, 18384, 4515,
	-10987, -22516, -25901, -19917, -6729, 8892, 21297, 26000,
	21298, 8892, -6729, -19916, -25901, -22516, -10988, 4514,
	18384, 25604, 23564, 13000, -2265, -16712, -25114, -24432,
	-14913, 0, 14912, 24431, 25114, 16712, 2266, -12999,
	-23563, -25605, -18384, -4515, 10987, 22516, 25901, 19917,
	6729, -8892, -21297, -26000, -21298, -8892, 6728, 19916,
	25901, 22516, 10988, -4514, -18384, -25604, -23564, -13000,
	2265, 16712, 25113, 24432, 14913, 0, -14912, -24431,
	-25114, -16712, -2266, 12999, 23563, 25605, 18385, 4515,
	-10987, -22516, -25901, -19917, -6729, 8892, 21297, 26000,
	21298, 8892, -6728, -19916, -25901, -22516, -10988, 4514},
	{
// Carrier 15 Phase 3
	24020, 25383, 17565, 3393, -12005, -23062, -25777, -19169,
	-5627, 9949, 21928, 25975, 20627, 7818, -7818, -20627,
	-25975, -21928, -9949, 5627, 19169, 25777, 23062, 12005,
	-3393, -17565, -25383, -24020, -13969, 1134, 15827, 24796,
	24796, 15827, 1134, -13969, -24020, -25383, -17565, -3393,
	12005, 23062, 25777, 19169, 5627, -9949, -21928, -25975,
	-20627, -7818, 7818, 20627, 25975, 21928, 9949, -5627,
	-19169, -25777, -23062, -12005, 3393, 17565, 25383, 24020,
	13969, -1133, -15827, -24796, -24796, -15827, -1134, 13969,
	24020, 25383, 17565, 3393, -12005, -23062, -25777, -19169,
	-5627, 9949, 21928, 25975, 20627, 7818, -7818, -20627,
	-25975, -21928, -9949, 5627, 19169, 25777, 23062, 12005,
	-3393, -17565, -25383, -24020, -13969, 1133, 15827, 24796,
	24796, 15827, 1134, -13969, -24020, -25383, -17565, -3393,
	12005, 23062, 25777, 19169, 5627, -9949, -21928, -25975,
	-20627, -7818, 7818, 20627, 25975, 21928, 9949, -5627,
	-19169, -25777, -23062, -12005, 3393, 17565, 25383, 24020,
	13969, -1133, -15827, -24796, -24796, -15827, -1134, 13969,
	24020, 25383, 17565, 3393, -12005, -23062, -25777, -19169,
	-5627, 9949, 21928, 25975, 20627, 7818, -7818, -20627,
	-25975, -21928, -9950, 5627, 19169, 25777, 23062, 12005,
	-3393, -17565, -25383, -24020, -13970, 1133, 15827, 24796,
	24796, 15828, 1134, -13969, -24020, -25383, -17565, -3394,
	12005, 23062, 25777, 19169, 5627, -9949, -21927, -25975,
	-20627, -7818, 7818, 20626, 25975, 21928, 9950, -5627,
	-19168, -25777, -23062, -12005, 3393, 17565, 25383, 24021,
	13970, -1133, -15827, -24796, -24796, -15828, -1134, 13969},
	{
// Carrier 15 Phase 4
	26000, 21297, 8892, -6729, -19917, -25901, -22516, -10988,
	4514, 18384, 25604, 23564, 13000, -2266, -16712, -25114,
	-24432, -14913, 0, 14912, 24431, 25114, 16712, 2266,
	-12999, -23563, -25605, -18384, -4514, 10988, 22516, 25901,
	19917, 6729, -8892, -21297, -26000, -21297, -8892, 6729,
	19917, 25901, 22516, 10988, -4514, -18384, -25604, -23564,
	-13000, 2265, 16712, 25114, 24432, 14913, 0, -14912,
	-24431, -25114, -16712, -2266, 12999, 23563, 25605, 18384,
	4514, -10987, -22516, -25901, -19917, -6729, 8892, 21297,
	26000, 21298, 8892, -6729, -19917, -25901, -22516, -10988,
	4514, 18384, 25604, 23564, 13000, -2265, -16712, -25114,
	-24432, -14913, 0, 14912, 24431, 25114, 16712, 2266,
	-12999, -23563, -25605, -18384, -4515, 10987, 22516, 25901,
	19917, 6729, -8892, -21297, -26000, -21298, -8892, 6729,
	19917, 25901, 22516, 10988, -4514, -18384, -25604, -23564,
	-13000, 2265, 16712, 25114, 24432, 14913, 0, -14912,
	-24431, -25114, -16712, -2266, 12999, 23563, 25605, 18384,
	4515, -10987, -22516, -25901, -19917, -6729, 8892, 21297,
	26000, 21298, 8892, -6729, -19916, -25901, -22516, -10988,
	4514, 18384, 25604, 23564, 13000, -2265, -16712, -25114,
	-24432, -14913, 0, 14912, 24431, 25114, 16712, 2266,
	-12999, -23563, -25605, -18384, -4515, 10987, 22516, 25901,
	19917, 6729, -8892, -21297, -26000, -21298, -8892, 6728,
	19916, 25901, 22516, 10988, -4514, -18384, -25604, -23564,
	-13000, 2265, 16712, 25113, 24432, 14913, 0, -14912,
	-24431, -25114, -16712, -2266, 12999, 23563, 25605, 18385,
	4515, -10987, -22516, -25901, -19917, -6729, 8892, 21297},
	{
// Carrier 15 Phase 5
	24020, 13969, -1134, -15827, -24796, -24796, -15827, -1134,
	13969, 24020, 25383, 17565, 3393, -12005, -23062, -25777,
	-19169, -5627, 9949, 21928, 25975, 20627, 7818, -7818,
	-20627, -25975, -21928, -9949, 5627, 19169, 25777, 23062,
	12005, -3393, -17565, -25383, -24020, -13969, 1134, 15827,
	24796, 24796, 15827, 1134, -13969, -24020, -25383, -17565,
	-3393, 12005, 23062, 25777, 19169, 5627, -9949, -21928,
	-25975, -20627, -7818, 7818, 20627, 25975, 21928, 9949,
	-5627, -19169, -25777, -23062, -12005, 3393, 17565, 25383,
	24020, 13969, -1133, -15827, -24796, -24796, -15827, -1134,
	13969, 24020, 25383, 17565, 3393, -12005, -23062, -25777,
	-19169, -5627, 9949, 21928, 25975, 20627, 7818, -7818,
	-20627, -25975, -21928, -9949, 5627, 19169, 25777, 23062,
	12005, -3393, -17565, -25383, -24020, -13969, 1133, 15827,
	24796, 24796, 15827, 1134, -13969, -24020, -25383, -17565,
	-3393, 12005, 23062, 25777, 19169, 5627, -9949, -21928,
	-25975, -20627, -7818, 7818, 20627, 25975, 21928, 9949,
	-5627, -19169, -25777, -23062, -12005, 3393, 17565, 25383,
	24020, 13970, -1133, -15827, -24796, -24796, -15828, -1134,
	13969, 24020, 25383, 17565, 3393, -12005, -23062, -25777,
	-19169, -5627, 9949, 21928, 25975, 20627, 7818, -7818,
	-20626, -25975, -21928, -9950, 5627, 19168, 25777, 23062,
	12005, -3393, -17565, -25383, -24020, -13970, 1133, 15827,
	24796, 24796, 15828, 1134, -13969, -24020, -25383, -17565,
	-3394, 12005, 23062, 25777, 19169, 5627, -9949, -21927,
	-25975, -20627, -7818, 7818, 20626, 25975, 21928, 9950,
	-5627, -19168, -25777, -23062, -12005, 3393, 17565, 25383},
	{
// Carrier 15 Phase 6
	18384, 4514, -10988, -22516, -25901, -19917, -6729, 8892,
	21297, 26000, 21297, 8892, -6729, -19917, -25901, -22516,
	-10988, 4514, 18384, 25604, 23564, 13000, -2266, -16712,
	-25114, -24432, -14913, 0, 14912, 24431, 25114, 16712,
	2266, -12999, -23563, -25605, -18384, -4514, 10988, 22516,
	25901, 19917, 6729, -8892, -21297, -26000, -21298, -8892,
	6729, 19917, 25901, 22516, 10988, -4514, -18384, -25604,
	-23564, -13000, 2265, 16712, 25114, 24432, 14913, 0,
	-14912, -24431, -25114, -16712, -2266, 12999, 23563, 25605,
	18384, 4514, -10987, -22516, -25901, -19917, -6729, 8892,
	21297, 26000, 21298, 8892, -6729, -19917, -25901, -22516,
	-10988, 4514, 18384, 25604, 23564, 13000, -2265, -16712,
	-25114, -24432, -14913, 0, 14912, 24431, 25114, 16712,
	2266, -12999, -23563, -25605, -18384, -4515, 10987, 22516,
	25901, 19917, 6729, -8892, -21297, -26000, -21298, -8892,
	6729, 19917, 25901, 22516, 10988, -4514, -18384, -25604,
	-23564, -13000, 2265, 16712, 25114, 24432, 14913, 0,
	-14912, -24431, -25114, -16712, -2266, 12999, 23563, 25605,
	18384, 4515, -10987, -22516, -25901, -19917, -6729, 8892,
	21297, 26000, 21298, 8892, -6729, -19916, -25901, -22516,
	-10988, 4514, 18384, 25604, 23564, 13000, -2265, -16712,
	-25113, -24432, -14913, 0, 14912, 24431, 25114, 16712,
	2266, -12999, -23563, -25605, -18384, -4515, 10987, 22516,
	25901, 19917, 6729, -8892, -21297, -26000, -21298, -8892,
	6728, 19916, 25901, 22516, 10988, -4514, -18384, -25604,
	-23564, -13000, 2265, 16712, 25113, 24432, 14913, 0,
	-14912, -24431, -25114, -16712, -2266, 12999, 23563, 25605},
	{
// Carrier 15 Phase 7
	9949, -5627, -19169, -25777, -23062, -12005, 3393, 17565,
	25383, 24020, 13969, -1134, -15827, -24796, -24796, -15827,
	-1134, 13969, 24020, 25383, 17565, 3393, -12005, -23062,
	-25777, -19169, -5627, 9949, 21928, 25975, 20627, 7818,
	-7818, -20627, -25975, -21928, -9949, 5627, 19169, 25777,
	23062, 12005, -3393, -17565, -25383, -24020, -13969, 1134,
	15827, 24796, 24796, 15827, 1134, -13969, -24020, -25383,
	-17565, -3393, 12005, 23062, 25777, 19169, 5627, -9949,
	-21928, -25975, -20627, -7818, 7818, 20627, 25975, 21928,
	9949, -5627, -19169, -25777, -23062, -12005, 3393, 17565,
	25383, 24020, 13969, -1133, -15827, -24796, -24796, -15827,
	-1134, 13969, 24020, 25383, 17565, 3393, -12005, -23062,
	-25777, -19169, -5627, 9949, 21928, 25975, 20627, 7818,
	-7818, -20627, -25975, -21928, -9949, 5627, 19169, 25777,
	23062, 12005, -3393, -17565, -25383, -24020, -13969, 1133,
	15827, 24796, 24796, 15827, 1134, -13969, -24020, -25383,
	-17565, -3393, 12005, 23062, 25777, 19169, 5627, -9949,
	-21928, -25975, -20627, -7818, 7818, 20627, 25975, 21928,
	9949, -5627, -19169, -25777, -23062, -12005, 3393, 17565,
	25383, 24020, 13970, -1133, -15827, -24796, -24796, -15828,
	-1134, 13969, 24020, 25383, 17565, 3393, -12005, -23062,
	-25777, -19169, -5627, 9949, 21928, 25975, 20627, 7818,
	-7818, -20626, -25975, -21928, -9950, 5627, 19168, 25777,
	23062, 12005, -3393, -17565, -25383, -24020, -13970, 1133,
	15827, 24796, 24796, 15828, 1134, -13969, -24020, -25383,
	-17565, -3394, 12005, 23062, 25777, 19169, 5627, -9949,
	-21927, -25975, -20627, -7818, 7818, 20626, 25975, 21928},
	},{{

// Carrier 16 Phase 0
	0, 15526, 24907, 24432, 14287, -1511, -16712, -25299,
	-23873, -13000, 3018, 17842, 25605, 23234, 11668, -4514,
	-18911, -25824, -22516, -10298, 5996, 19917, 25956, 21722,
	8892, -7456, -20855, -26000, -20855, -7456, 8892, 21722,
	25956, 19917, 5996, -10298, -22516, -25824, -18911, -4514,
	11668, 23234, 25604, 17842, 3018, -13000, -23873, -25299,
	-16712, -1511, 14287, 24432, 24907, 15526, 0, -15526,
	-24907, -24432, -14287, 1511, 16712, 25299, 23873, 12999,
	-3018, -17842, -25605, -23234, -11668, 4514, 18911, 25824,
	22516, 10298, -5996, -19917, -25956, -21722, -8892, 7456,
	20855, 26000, 20855, 7456, -8892, -21722, -25956, -19917,
	-5995, 10298, 22516, 25824, 18911, 4514, -11668, -23234,
	-25604, -17842, -3018, 13000, 23873, 25299, 16712, 1511,
	-14287, -24432, -24907, -15526, 0, 15526, 24907, 24431,
	14287, -1511, -16712, -25299, -23873, -12999, 3018, 17842,
	25605, 23234, 11668, -4514, -18911, -25824, -22516, -10298,
	5996, 19917, 25956, 21722, 8892, -7456, -20855, -26000,
	-20855, -7456, 8892, 21722, 25956, 19917, 5995, -10298,
	-22516, -25824, -18911, -4514, 11668, 23234, 25604, 17842,
	3018, -13000, -23873, -25299, -16712, -1511, 14287, 24432,
	24907, 15526, 0, -15526, -24907, -24431, -14287, 1511,
	16712, 25299, 23873, 12999, -3018, -17842, -25605, -23234,
	-11668, 4514, 18911, 25824, 22516, 10298, -5996, -19917,
	-25956, -21722, -8892, 7456, 20855, 26000, 20855, 7456,
	-8892, -21722, -25956, -19917, -5995, 10298, 22516, 25824,
	18911, 4514, -11668, -23234, -25604, -17842, -3018, 13000,
	23873, 25299, 16712, 1511, -14287, -24432, -24907, -15526},
	{
// Carrier 16 Phase 1
	9949, 22325, 25865, 19169, 4886, -11329, -23062, -25667,
	-18115, -3393, 12671, 23721, 25383, 17000, 1889, -13969,
	-24300, -25013, -15827, -378, 15221, 24796, 24558, 14601,
	-1134, -16421, -25209, -24020, -13326, 2642, 17565, 25536,
	23401, 12005, -4141, -18650, -25777, -22703, -10644, 5627,
	19671, 25931, 21928, 9246, -7093, -20627, -25997, -21078,
	-7818, 8536, 21512, 25975, 20158, 6363, -9949, -22325,
	-25865, -19169, -4886, 11329, 23062, 25667, 18115, 3393,
	-12671, -23721, -25383, -17000, -1889, 13969, 24300, 25013,
	15827, 378, -15221, -24796, -24558, -14601, 1134, 16421,
	25209, 24020, 13326, -2642, -17565, -25536, -23401, -12005,
	4142, 18650, 25777, 22703, 10644, -5627, -19672, -25931,
	-21928, -9246, 7093, 20627, 25997, 21078, 7818, -8536,
	-21512, -25975, -20158, -6363, 9949, 22325, 25865, 19169,
	4886, -11329, -23062, -25667, -18115, -3393, 12671, 23721,
	25383, 17000, 1889, -13969, -24300, -25013, -15827, -378,
	15221, 24796, 24558, 14601, -1134, -16421, -25209, -24020,
	-13326, 2642, 17565, 25536, 23401, 12005, -4142, -18650,
	-25777, -22703, -10644, 5627, 19672, 25931, 21928, 9246,
	-7093, -20627, -25997, -21078, -7818, 8536, 21512, 25975,
	20158, 6363, -9949, -22325, -25865, -19169, -4886, 11329,
	23062, 25667, 18115, 3393, -12671, -23721, -25383, -17000,
	-1889, 13969, 24300, 25013, 15827, 378, -15221, -24796,
	-24558, -14601, 1134, 16421, 25209, 24020, 13326, -2642,
	-17565, -25536, -23401, -12005, 4142, 18650, 25777, 22703,
	10644, -5627, -19672, -25931, -21928, -9246, 7093, 20627,
	25997, 21078, 7818, -8536, -21512, -25975, -20158, -6363},
	{
// Carrier 16 Phase 2
	18384, 25725, 22885, 10988, -5257, -19422, -25901, -22129,
	-9599, 6729, 20394, 25989, 21297, 8178, -8178, -21297,
	-25989, -20394, -6729, 9599, 22129, 25901, 19422, 5257,
	-10988, -22885, -25725, -18384, -3768, 12339, 23564, 25462,
	17284, 2266, -13649, -24163, -25114, -16126, -756, 14913,
	24680, 24680, 14912, -756, -16126, -25114, -24163, -13649,
	2266, 17284, 25462, 23563, 12339, -3768, -18384, -25725,
	-22885, -10988, 5257, 19422, 25901, 22129, 9599, -6729,
	-20394, -25989, -21297, -8178, 8178, 21297, 25989, 20394,
	6729, -9599, -22129, -25901, -19422, -5257, 10988, 22885,
	25725, 18384, 3768, -12339, -23564, -25462, -17284, -2266,
	13649, 24163, 25114, 16126, 756, -14913, -24680, -24680,
	-14912, 756, 16126, 25114, 24163, 13649, -2266, -17284,
	-25462, -23563, -12339, 3768, 18384, 25725, 22885, 10988,
	-5257, -19422, -25901, -22129, -9599, 6729, 20394, 25989,
	21297, 8178, -8178, -21297, -25989, -20394, -6729, 9599,
	22129, 25901, 19422, 5257, -10988, -22885, -25725, -18384,
	-3768, 12339, 23564, 25462, 17284, 2266, -13649, -24163,
	-25114, -16126, -756, 14913, 24680, 24680, 14912, -756,
	-16126, -25114, -24163, -13649, 2266, 17284, 25462, 23563,
	12339, -3768, -18384, -25725, -22885, -10988, 5257, 19422,
	25901, 22129, 9599, -6729, -20394, -25989, -21297, -8178,
	8178, 21297, 25988, 20394, 6729, -9599, -22129, -25901,
	-19422, -5257, 10988, 22885, 25725, 18384, 3768, -12339,
	-23564, -25462, -17284, -2265, 13649, 24163, 25114, 16126,
	756, -14913, -24680, -24680, -14912, 756, 16126, 25114,
	24163, 13649, -2266, -17284, -25462, -23563, -12339, 3768},
	{
// Carrier 16 Phase 3
	24020, 25209, 16421, 1134, -14601, -24558, -24796, -15221,
	378, 15827, 25013, 24300, 13969, -1889, -17000, -25383,
	-23721, -12671, 3393, 18115, 25667, 23062, 11329, -4886,
	-19169, -25865, -22325, -9949, 6363, 20158, 25975, 21512,
	8536, -7818, -21078, -25997, -20627, -7093, 9246, 21928,
	25931, 19671, 5627, -10644, -22703, -25777, -18650, -4141,
	12005, 23401, 25536, 17565, 2642, -13326, -24020, -25209,
	-16421, -1134, 14601, 24558, 24796, 15221, -378, -15827,
	-25013, -24300, -13969, 1889, 17000, 25383, 23721, 12671,
	-3393, -18115, -25667, -23062, -11329, 4886, 19169, 25865,
	22325, 9949, -6363, -20158, -25975, -21512, -8536, 7818,
	21078, 25997, 20627, 7093, -9246, -21928, -25931, -19671,
	-5627, 10644, 22703, 25777, 18650, 4141, -12005, -23401,
	-25536, -17565, -2642, 13326, 24020, 25209, 16421, 1134,
	-14601, -24558, -24796, -15221, 378, 15827, 25013, 24300,
	13969, -1889, -17000, -25383, -23721, -12671, 3393, 18115,
	25667, 23062, 11329, -4886, -19169, -25865, -22325, -9949,
	6363, 20158, 25975, 21512, 8536, -7818, -21078, -25997,
	-20627, -7093, 9246, 21928, 25931, 19671, 5627, -10644,
	-22703, -25777, -18650, -4141, 12005, 23401, 25536, 17565,
	2642, -13326, -24020, -25209, -16421, -1134, 14601, 24558,
	24796, 15221, -378, -15827, -25013, -24300, -13969, 1889,
	17000, 25383, 23721, 12671, -3393, -18115, -25667, -23062,
	-11329, 4886, 19169, 25865, 22325, 9949, -6363, -20158,
	-25975, -21512, -8536, 7818, 21078, 25997, 20627, 7093,
	-9246, -21928, -25931, -19671, -5627, 10644, 22703, 25777,
	18650, 4141, -12005, -23401, -25536, -17565, -2642, 13326},
	{
// Carrier 16 Phase 4
	26000, 20855, 7456, -8892, -21722, -25956, -19917, -5996,
	10298, 22516, 25824, 18911, 4514, -11668, -23234, -25605,
	-17842, -3018, 13000, 23873, 25299, 16712, 1511, -14287,
	-24432, -24907, -15526, 0, 15526, 24907, 24432, 14287,
	-1511, -16712, -25299, -23873, -12999, 3018, 17842, 25605,
	23234, 11668, -4514, -18911, -25824, -22516, -10298, 5996,
	19917, 25956, 21722, 8892, -7456, -20855, -26000, -20855,
	-7456, 8892, 21722, 25956, 19917, 5995, -10298, -22516,
	-25824, -18911, -4514, 11668, 23234, 25604, 17842, 3018,
	-13000, -23873, -25299, -16712, -1511, 14287, 24432, 24907,
	15526, 0, -15526, -24907, -24432, -14287, 1511, 16712,
	25299, 23873, 12999, -3018, -17842, -25605, -23234, -11668,
	4514, 18911, 25824, 22516, 10298, -5996, -19917, -25956,
	-21722, -8892, 7456, 20855, 26000, 20855, 7456, -8892,
	-21722, -25956, -19917, -5995, 10298, 22516, 25824, 18911,
	4514, -11668, -23234, -25604, -17842, -3018, 13000, 23873,
	25299, 16712, 1511, -14287, -24432, -24907, -15526, 0,
	15526, 24907, 24431, 14287, -1511, -16712, -25299, -23873,
	-12999, 3018, 17842, 25605, 23234, 11668, -4514, -18911,
	-25824, -22516, -10298, 5996, 19917, 25956, 21722, 8892,
	-7456, -20855, -26000, -20855, -7456, 8892, 21722, 25956,
	19917, 5995, -10298, -22516, -25824, -18911, -4514, 11668,
	23234, 25604, 17842, 3018, -13000, -23873, -25299, -16712,
	-1511, 14287, 24432, 24907, 15526, 0, -15526, -24907,
	-24431, -14287, 1511, 16712, 25299, 23873, 12999, -3018,
	-17842, -25605, -23234, -11668, 4514, 18911, 25824, 22516,
	10298, -5996, -19917, -25956, -21722, -8892, 7456, 20855},
	{
// Carrier 16 Phase 5
	24020, 13326, -2642, -17565, -25536, -23401, -12005, 4141,
	18650, 25777, 22703, 10644, -5627, -19671, -25931, -21928,
	-9246, 7093, 20627, 25997, 21078, 7818, -8536, -21512,
	-25975, -20158, -6363, 9949, 22325, 25865, 19169, 4886,
	-11329, -23062, -25667, -18115, -3393, 12671, 23721, 25383,
	17000, 1889, -13969, -24300, -25013, -15827, -378, 15221,
	24796, 24558, 14601, -1134, -16421, -25209, -24020, -13326,
	2642, 17565, 25536, 23401, 12005, -4141, -18650, -25777,
	-22703, -10644, 5627, 19672, 25931, 21928, 9246, -7093,
	-20627, -25997, -21078, -7818, 8536, 21512, 25975, 20158,
	6363, -9949, -22325, -25865, -19169, -4886, 11329, 23062,
	25667, 18115, 3393, -12671, -23721, -25383, -17000, -1889,
	13969, 24300, 25013, 15827, 378, -15221, -24796, -24558,
	-14601, 1134, 16421, 25209, 24020, 13326, -2642, -17565,
	-25536, -23401, -12005, 4142, 18650, 25777, 22703, 10644,
	-5627, -19672, -25931, -21928, -9246, 7093, 20627, 25997,
	21078, 7818, -8536, -21512, -25975, -20158, -6363, 9949,
	22325, 25865, 19169, 4886, -11329, -23062, -25667, -18115,
	-3393, 12671, 23721, 25383, 17000, 1889, -13969, -24300,
	-25013, -15827, -378, 15221, 24796, 24558, 14601, -1134,
	-16421, -25209, -24020, -13326, 2642, 17565, 25536, 23401,
	12005, -4142, -18650, -25777, -22703, -10644, 5627, 19672,
	25931, 21928, 9246, -7093, -20627, -25997, -21078, -7818,
	8536, 21512, 25975, 20158, 6363, -9949, -22325, -25865,
	-19169, -4886, 11329, 23062, 25667, 18115, 3393, -12671,
	-23721, -25383, -17000, -1889, 13969, 24300, 25013, 15827,
	378, -15221, -24796, -24558, -14601, 1134, 16421, 25209},
	{
// Carrier 16 Phase 6
	18384, 3768, -12339, -23564, -25462, -17284, -2266, 13649,
	24163, 25114, 16126, 756, -14912, -24680, -24680, -14912,
	756, 16126, 25114, 24163, 13649, -2266, -17284, -25462,
	-23563, -12339, 3768, 18384, 25725, 22885, 10988, -5257,
	-19422, -25901, -22129, -9599, 6729, 20394, 25989, 21297,
	8178, -8178, -21297, -25989, -20394, -6729, 9599, 22129,
	25901, 19422, 5257, -10988, -22885, -25725, -18384, -3768,
	12339, 23564, 25462, 17284, 2266, -13649, -24163, -25114,
	-16126, -756, 14913, 24680, 24680, 14912, -756, -16126,
	-25114, -24163, -13649, 2266, 17284, 25462, 23563, 12339,
	-3768, -18384, -25725, -22885, -10988, 5257, 19422, 25901,
	22129, 9599, -6729, -20394, -25989, -21297, -8178, 8178,
	21297, 25989, 20394, 6729, -9599, -22129, -25901, -19422,
	-5257, 10988, 22885, 25725, 18384, 3768, -12339, -23564,
	-25462, -17284, -2266, 13649, 24163, 25114, 16126, 756,
	-14913, -24680, -24680, -14912, 756, 16126, 25114, 24163,
	13649, -2266, -17284, -25462, -23563, -12339, 3768, 18384,
	25725, 22885, 10988, -5257, -19422, -25901, -22129, -9599,
	6729, 20394, 25989, 21297, 8178, -8178, -21297, -25988,
	-20394, -6729, 9599, 22129, 25901, 19422, 5257, -10988,
	-22885, -25725, -18384, -3768, 12339, 23564, 25462, 17284,
	2265, -13649, -24163, -25114, -16126, -756, 14913, 24680,
	24680, 14912, -756, -16126, -25114, -24163, -13649, 2266,
	17284, 25462, 23563, 12339, -3768, -18384, -25725, -22885,
	-10988, 5257, 19422, 25901, 22128, 9599, -6729, -20394,
	-25989, -21297, -8178, 8178, 21297, 25988, 20394, 6729,
	-9599, -22129, -25901, -19422, -5257, 10988, 22885, 25725},
	{
// Carrier 16 Phase 7
	9949, -6363, -20158, -25975, -21512, -8536, 7818, 21078,
	25997, 20627, 7093, -9246, -21928, -25931, -19671, -5627,
	10644, 22703, 25777, 18650, 4141, -12005, -23401, -25536,
	-17565, -2642, 13326, 24020, 25209, 16421, 1134, -14601,
	-24558, -24796, -15221, 378, 15827, 25013, 24300, 13969,
	-1889, -17000, -25383, -23721, -12671, 3393, 18115, 25667,
	23062, 11329, -4886, -19169, -25865, -22325, -9949, 6363,
	20158, 25975, 21512, 8536, -7818, -21078, -25997, -20627,
	-7093, 9246, 21928, 25931, 19671, 5627, -10644, -22703,
	-25777, -18650, -4141, 12005, 23401, 25536, 17565, 2642,
	-13326, -24020, -25209, -16421, -1134, 14601, 24558, 24796,
	15221, -378, -15827, -25013, -24300, -13969, 1889, 17000,
	25383, 23721, 12671, -3393, -18115, -25667, -23062, -11329,
	4886, 19169, 25865, 22325, 9949, -6363, -20158, -25975,
	-21512, -8536, 7818, 21078, 25997, 20627, 7093, -9246,
	-21928, -25931, -19671, -5627, 10644, 22703, 25777, 18650,
	4141, -12005, -23401, -25536, -17565, -2642, 13326, 24020,
	25209, 16421, 1134, -14601, -24558, -24796, -15221, 378,
	15827, 25013, 24300, 13969, -1889, -17000, -25383, -23721,
	-12671, 3393, 18115, 25667, 23062, 11329, -4886, -19169,
	-25865, -22325, -9949, 6363, 20158, 25975, 21512, 8536,
	-7818, -21078, -25997, -20627, -7093, 9246, 21928, 25931,
	19671, 5627, -10644, -22703, -25777, -18650, -4141, 12005,
	23401, 25536, 17565, 2642, -13326, -24020, -25209, -16420,
	-1134, 14601, 24558, 24796, 15221, -378, -15827, -25013,
	-24300, -13969, 1889, 17000, 25383, 23721, 12671, -3393,
	-18115, -25667, -23062, -11329, 4886, 19169, 25865, 22325},
	},{{

// Carrier 17 Phase 0
	0, 16126, 25299, 23564, 11668, -5257, -19917, -25989,
	-20855, -6729, 10298, 22885, 25604, 17284, 1511, -14913,
	-24907, -24163, -12999, 3768, 18911, 25901, 21722, 8178,
	-8892, -22129, -25824, -18384, -3018, 13649, 24432, 24680,
	14287, -2266, -17842, -25725, -22516, -9599, 7456, 21298,
	25956, 19422, 4514, -12339, -23873, -25114, -15526, 756,
	16712, 25462, 23234, 10987, -5996, -20394, -26000, -20394,
	-5995, 10988, 23234, 25462, 16712, 756, -15526, -25114,
	-23873, -12339, 4515, 19422, 25956, 21297, 7456, -9599,
	-22516, -25725, -17842, -2265, 14287, 24680, 24431, 13649,
	-3018, -18384, -25824, -22128, -8892, 8178, 21722, 25901,
	18911, 3768, -13000, -24163, -24907, -14912, 1511, 17284,
	25605, 22885, 10297, -6729, -20855, -25988, -19916, -5257,
	11669, 23564, 25299, 16125, 0, -16126, -25299, -23563,
	-11668, 5257, 19917, 25989, 20855, 6729, -10298, -22885,
	-25604, -17284, -1511, 14913, 24907, 24162, 12999, -3768,
	-18911, -25901, -21722, -8177, 8892, 22129, 25824, 18384,
	3018, -13649, -24432, -24680, -14286, 2266, 17842, 25725,
	22516, 9599, -7457, -21298, -25955, -19422, -4514, 12339,
	23873, 25113, 15525, -756, -16712, -25462, -23234, -10987,
	5996, 20395, 26000, 20394, 5995, -10988, -23234, -25462,
	-16712, -755, 15526, 25114, 23873, 12339, -4515, -19422,
	-25956, -21297, -7456, 9599, 22516, 25725, 17841, 2265,
	-14287, -24680, -24431, -13649, 3018, 18385, 25824, 22128,
	8892, -8178, -21722, -25901, -18911, -3767, 13000, 24163,
	24907, 14912, -1512, -17285, -25605, -22885, -10297, 6729,
	20855, 25988, 19916, 5257, -11669, -23564, -25299, -16125},
	{
// Carrier 17 Phase 1
	9949, 22703, 25667, 17565, 1889, -14601, -24796, -24300,
	-13326, 3393, 18650, 25865, 21928, 8536, -8536, -21928,
	-25865, -18650, -3393, 13326, 24300, 24796, 14601, -1889,
	-17565, -25667, -22703, -9949, 7093, 21078, 25975, 19671,
	4886, -12005, -23721, -25209, -15827, 378, 16421, 25383,
	23401, 11329, -5627, -20158, -25997, -20627, -6363, 10644,
	23062, 25536, 17000, 1133, -15221, -25013, -24020, -12671,
	4142, 19169, 25931, 21512, 7818, -9247, -22325, -25777,
	-18115, -2642, 13969, 24558, 24558, 13969, -2642, -18115,
	-25777, -22325, -9246, 7818, 21512, 25931, 19169, 4141,
	-12671, -24020, -25013, -15221, 1134, 17000, 25536, 23062,
	10644, -6363, -20627, -25997, -20157, -5627, 11329, 23401,
	25383, 16420, 377, -15827, -25209, -23721, -12005, 4887,
	19672, 25975, 21078, 7093, -9949, -22703, -25667, -17565,
	-1888, 14601, 24796, 24299, 13325, -3393, -18650, -25865,
	-21928, -8535, 8536, 21928, 25865, 18650, 3393, -13326,
	-24300, -24796, -14601, 1889, 17565, 25668, 22703, 9949,
	-7094, -21078, -25975, -19671, -4886, 12005, 23721, 25209,
	15827, -378, -16421, -25383, -23401, -11329, 5627, 20158,
	25997, 20626, 6362, -10644, -23062, -25536, -17000, -1133,
	15221, 25013, 24020, 12670, -4142, -19169, -25931, -21512,
	-7817, 9247, 22325, 25777, 18115, 2642, -13970, -24558,
	-24558, -13969, 2642, 18115, 25777, 22324, 9246, -7818,
	-21512, -25931, -19168, -4141, 12671, 24021, 25013, 15220,
	-1134, -17000, -25536, -23062, -10643, 6363, 20627, 25997,
	20157, 5626, -11330, -23401, -25383, -16420, -377, 15828,
	25209, 23721, 12005, -4887, -19672, -25975, -21078, -7093},
	{
// Carrier 17 Phase 2
	18384, 25824, 22129, 8892, -8178, -21722, -25901, -18911,
	-3768, 13000, 24163, 24907, 14912, -1511, -17284, -25605,
	-22885, -10298, 6729, 20855, 25989, 19917, 5257, -11668,
	-23564, -25299, -16126, 0, 16126, 25299, 23563, 11668,
	-5257, -19917, -25989, -20855, -6729, 10298, 22885, 25604,
	17284, 1511, -14913, -24907, -24163, -12999, 3768, 18911,
	25901, 21722, 8178, -8892, -22129, -25824, -18384, -3018,
	13649, 24432, 24680, 14287, -2266, -17842, -25725, -22516,
	-9599, 7457, 21298, 25956, 19422, 4514, -12339, -23873,
	-25114, -15525, 756, 16712, 25462, 23234, 10987, -5996,
	-20394, -26000, -20394, -5995, 10988, 23234, 25462, 16712,
	755, -15526, -25114, -23873, -12339, 4515, 19422, 25956,
	21297, 7456, -9599, -22516, -25725, -17842, -2265, 14287,
	24680, 24431, 13649, -3018, -18384, -25824, -22128, -8892,
	8178, 21722, 25901, 18911, 3767, -13000, -24163, -24907,
	-14912, 1512, 17284, 25605, 22885, 10297, -6729, -20855,
	-25988, -19916, -5257, 11669, 23564, 25299, 16125, 0,
	-16126, -25299, -23563, -11668, 5257, 19917, 25989, 20854,
	6728, -10298, -22885, -25604, -17284, -1511, 14913, 24907,
	24162, 12999, -3768, -18911, -25901, -21722, -8177, 8892,
	22129, 25824, 18384, 3018, -13649, -24432, -24680, -14286,
	2266, 17842, 25725, 22516, 9598, -7457, -21298, -25955,
	-19422, -4514, 12339, 23873, 25113, 15525, -756, -16712,
	-25462, -23234, -10987, 5996, 20395, 26000, 20394, 5995,
	-10988, -23234, -25462, -16712, -755, 15526, 25114, 23873,
	12339, -4515, -19422, -25956, -21297, -7456, 9599, 22516,
	25725, 17841, 2265, -14287, -24680, -24431, -13648, 3018},
	{
// Carrier 17 Phase 3
	24020, 25013, 15221, -1134, -17000, -25536, -23062, -10644,
	6363, 20627, 25997, 20158, 5627, -11329, -23401, -25383,
	-16421, -378, 15827, 25209, 23721, 12005, -4886, -19672,
	-25975, -21078, -7093, 9949, 22703, 25667, 17565, 1889,
	-14601, -24796, -24300, -13326, 3393, 18650, 25865, 21928,
	8536, -8536, -21928, -25865, -18650, -3393, 13326, 24300,
	24796, 14601, -1889, -17565, -25667, -22703, -9949, 7093,
	21078, 25975, 19671, 4886, -12005, -23721, -25209, -15827,
	378, 16421, 25383, 23401, 11329, -5627, -20158, -25997,
	-20627, -6363, 10644, 23062, 25536, 17000, 1133, -15221,
	-25013, -24020, -12670, 4142, 19169, 25931, 21512, 7818,
	-9247, -22325, -25777, -18115, -2642, 13969, 24558, 24558,
	13969, -2642, -18115, -25777, -22325, -9246, 7818, 21512,
	25931, 19169, 4141, -12671, -24020, -25013, -15220, 1134,
	17000, 25536, 23062, 10643, -6363, -20627, -25997, -20157,
	-5627, 11329, 23401, 25383, 16420, 377, -15828, -25209,
	-23721, -12005, 4887, 19672, 25975, 21078, 7093, -9950,
	-22703, -25667, -17565, -1888, 14601, 24796, 24299, 13325,
	-3394, -18650, -25865, -21927, -8535, 8536, 21928, 25865,
	18649, 3393, -13326, -24300, -24796, -14601, 1889, 17565,
	25668, 22703, 9949, -7094, -21079, -25975, -19671, -4886,
	12005, 23721, 25209, 15827, -378, -16421, -25383, -23401,
	-11329, 5627, 20158, 25997, 20626, 6362, -10644, -23062,
	-25536, -17000, -1133, 15221, 25013, 24020, 12670, -4142,
	-19169, -25931, -21512, -7817, 9247, 22325, 25777, 18115,
	2642, -13970, -24558, -24558, -13969, 2642, 18115, 25777,
	22324, 9246, -7818, -21512, -25931, -19168, -4141, 12671},
	{
// Carrier 17 Phase 4
	26000, 20394, 5996, -10988, -23234, -25462, -16712, -756,
	15526, 25114, 23873, 12339, -4514, -19422, -25956, -21297,
	-7456, 9599, 22516, 25725, 17842, 2266, -14287, -24680,
	-24431, -13649, 3018, 18384, 25824, 22129, 8892, -8178,
	-21722, -25901, -18911, -3768, 13000, 24163, 24907, 14912,
	-1511, -17284, -25605, -22885, -10297, 6729, 20855, 25988,
	19917, 5257, -11668, -23564, -25299, -16126, 0, 16126,
	25299, 23563, 11668, -5257, -19917, -25989, -20855, -6729,
	10298, 22885, 25604, 17284, 1511, -14913, -24907, -24162,
	-12999, 3768, 18911, 25901, 21722, 8178, -8892, -22129,
	-25824, -18384, -3018, 13649, 24432, 24680, 14287, -2266,
	-17842, -25725, -22516, -9599, 7457, 21298, 25956, 19422,
	4514, -12339, -23873, -25114, -15525, 756, 16712, 25462,
	23234, 10987, -5996, -20394, -26000, -20394, -5995, 10988,
	23234, 25462, 16712, 755, -15526, -25114, -23873, -12339,
	4515, 19422, 25956, 21297, 7456, -9599, -22516, -25725,
	-17842, -2265, 14287, 24680, 24431, 13649, -3018, -18384,
	-25824, -22128, -8892, 8178, 21722, 25901, 18911, 3767,
	-13000, -24163, -24907, -14912, 1512, 17284, 25605, 22885,
	10297, -6729, -20855, -25988, -19916, -5257, 11669, 23564,
	25299, 16125, 0, -16126, -25299, -23563, -11668, 5258,
	19917, 25989, 20854, 6728, -10298, -22885, -25604, -17284,
	-1511, 14913, 24907, 24162, 12999, -3768, -18912, -25901,
	-21722, -8177, 8892, 22129, 25824, 18384, 3017, -13649,
	-24432, -24680, -14286, 2266, 17842, 25725, 22516, 9598,
	-7457, -21298, -25955, -19422, -4514, 12340, 23873, 25113,
	15525, -756, -16712, -25462, -23234, -10987, 5996, 20395},
	{
// Carrier 17 Phase 5
	24020, 12671, -4141, -19169, -25931, -21512, -7818, 9246,
	22325, 25777, 18115, 2642, -13969, -24558, -24558, -13969,
	2642, 18115, 25777, 22325, 9246, -7818, -21512, -25931,
	-19169, -4141, 12671, 24020, 25013, 15221, -1134, -17000,
	-25536, -23062, -10644, 6363, 20627, 25997, 20158, 5627,
	-11329, -23401, -25383, -16420, -378, 15827, 25209, 23721,
	12005, -4886, -19672, -25975, -21078, -7093, 9949, 22703,
	25667, 17565, 1888, -14601, -24796, -24300, -13326, 3393,
	18650, 25865, 21928, 8536, -8536, -21928, -25865, -18650,
	-3393, 13326, 24300, 24796, 14601, -1889, -17565, -25667,
	-22703, -9949, 7094, 21078, 25975, 19671, 4886, -12005,
	-23721, -25209, -15827, 378, 16421, 25383, 23401, 11329,
	-5627, -20158, -25997, -20627, -6363, 10644, 23062, 25536,
	17000, 1133, -15221, -25013, -24020, -12670, 4142, 19169,
	25931, 21512, 7818, -9247, -22325, -25777, -18115, -2642,
	13970, 24558, 24558, 13969, -2642, -18115, -25777, -22325,
	-9246, 7818, 21512, 25931, 19169, 4141, -12671, -24020,
	-25013, -15220, 1134, 17000, 25536, 23062, 10643, -6363,
	-20627, -25997, -20157, -5627, 11329, 23401, 25383, 16420,
	377, -15828, -25209, -23721, -12005, 4887, 19672, 25975,
	21078, 7093, -9950, -22703, -25667, -17565, -1888, 14601,
	24796, 24299, 13325, -3394, -18650, -25865, -21927, -8535,
	8536, 21928, 25865, 18649, 3393, -13326, -24300, -24796,
	-14601, 1889, 17565, 25668, 22703, 9949, -7094, -21079,
	-25975, -19671, -4886, 12005, 23721, 25209, 15827, -378,
	-16421, -25383, -23401, -11329, 5627, 20158, 25997, 20626,
	6362, -10644, -23062, -25536, -17000, -1133, 15221, 25013},
	{
// Carrier 17 Phase 6
	18384, 3018, -13649, -24432, -24680, -14287, 2266, 17842,
	25725, 22516, 9599, -7456, -21297, -25956, -19422, -4514,
	12339, 23873, 25114, 15526, -756, -16712, -25462, -23234,
	-10988, 5996, 20394, 26000, 20394, 5995, -10988, -23234,
	-25462, -16712, -756, 15526, 25114, 23873, 12339, -4514,
	-19422, -25956, -21297, -7456, 9599, 22516, 25725, 17842,
	2265, -14287, -24680, -24431, -13649, 3018, 18384, 25824,
	22128, 8892, -8178, -21722, -25901, -18911, -3768, 13000,
	24163, 24907, 14912, -1511, -17284, -25605, -22885, -10297,
	6729, 20855, 25988, 19917, 5257, -11668, -23564, -25299,
	-16125, 0, 16126, 25299, 23563, 11668, -5257, -19917,
	-25989, -20855, -6729, 10298, 22885, 25604, 17284, 1511,
	-14913, -24907, -24162, -12999, 3768, 18911, 25901, 21722,
	8177, -8892, -22129, -25824, -18384, -3018, 13649, 24432,
	24680, 14287, -2266, -17842, -25725, -22516, -9599, 7457,
	21298, 25955, 19422, 4514, -12339, -23873, -25113, -15525,
	756, 16712, 25462, 23234, 10987, -5996, -20395, -26000,
	-20394, -5995, 10988, 23234, 25462, 16712, 755, -15526,
	-25114, -23873, -12339, 4515, 19422, 25956, 21297, 7456,
	-9599, -22516, -25725, -17842, -2265, 14287, 24680, 24431,
	13649, -3018, -18385, -25824, -22128, -8892, 8178, 21722,
	25901, 18911, 3767, -13000, -24163, -24907, -14912, 1512,
	17285, 25605, 22885, 10297, -6729, -20855, -25988, -19916,
	-5257, 11669, 23564, 25299, 16125, 0, -16126, -25299,
	-23563, -11668, 5258, 19917, 25989, 20854, 6728, -10298,
	-22885, -25604, -17284, -1511, 14913, 24907, 24162, 12999,
	-3768, -18912, -25901, -21722, -8177, 8893, 22129, 25824},
	{
// Carrier 17 Phase 7
	9949, -7093, -21078, -25975, -19671, -4886, 12005, 23721,
	25209, 15827, -378, -16421, -25383, -23401, -11329, 5627,
	20158, 25997, 20627, 6363, -10644, -23062, -25536, -17000,
	-1134, 15221, 25013, 24020, 12671, -4142, -19169, -25931,
	-21512, -7818, 9247, 22325, 25777, 18115, 2642, -13969,
	-24558, -24558, -13969, 2642, 18115, 25777, 22325, 9246,
	-7818, -21512, -25931, -19169, -4141, 12671, 24020, 25013,
	15221, -1134, -17000, -25536, -23062, -10644, 6363, 20627,
	25997, 20158, 5627, -11329, -23401, -25383, -16420, -377,
	15827, 25209, 23721, 12005, -4886, -19672, -25975, -21078,
	-7093, 9949, 22703, 25667, 17565, 1888, -14601, -24796,
	-24300, -13325, 3393, 18650, 25865, 21928, 8536, -8536,
	-21928, -25865, -18650, -3393, 13326, 24300, 24796, 14601,
	-1889, -17565, -25667, -22703, -9949, 7094, 21078, 25975,
	19671, 4886, -12005, -23721, -25209, -15827, 378, 16421,
	25383, 23401, 11329, -5627, -20158, -25997, -20627, -6363,
	10644, 23062, 25536, 17000, 1133, -15221, -25013, -24020,
	-12670, 4142, 19169, 25931, 21512, 7818, -9247, -22325,
	-25777, -18115, -2642, 13970, 24558, 24558, 13969, -2642,
	-18115, -25777, -22325, -9246, 7818, 21512, 25931, 19168,
	4141, -12671, -24021, -25013, -15220, 1134, 17000, 25536,
	23062, 10643, -6363, -20627, -25997, -20157, -5627, 11330,
	23401, 25383, 16420, 377, -15828, -25209, -23721, -12005,
	4887, 19672, 25975, 21078, 7093, -9950, -22703, -25667,
	-17565, -1888, 14602, 24796, 24299, 13325, -3394, -18650,
	-25865, -21927, -8535, 8536, 21928, 25865, 18649, 3393,
	-13326, -24300, -24796, -14601, 1889, 17565, 25668, 22703},
	},{{

// Carrier 18 Phase 0
	0, 16712, 25605, 22516, 8892, -8892, -22516, -25605,
	-16712, 0, 16712, 25604, 22516, 8892, -8892, -22516,
	-25605, -16712, 0, 16712, 25604, 22516, 8892, -8892,
	-22516, -25605, -16712, 0, 16712, 25604, 22516, 8892,
	-8892, -22516, -25605, -16712, 0, 16712, 25604, 22516,
	8892, -8892, -22516, -25605, -16712, 0, 16712, 25604,
	22516, 8892, -8892, -22516, -25605, -16712, 0, 16712,
	25604, 22516, 8892, -8892, -22516, -25605, -16712, 0,
	16712, 25604, 22516, 8892, -8892, -22516, -25605, -16712,
	0, 16712, 25604, 22516, 8892, -8892, -22516, -25605,
	-16712, 0, 16712, 25604, 22516, 8892, -8892, -22516,
	-25605, -16712, 0, 16712, 25604, 22516, 8892, -8892,
	-22516, -25605, -16712, 0, 16712, 25604, 22516, 8892,
	-8892, -22516, -25605, -16712, 0, 16712, 25604, 22516,
	8892, -8892, -22516, -25605, -16712, 0, 16712, 25604,
	22516, 8892, -8892, -22516, -25605, -16712, 0, 16712,
	25604, 22516, 8892, -8892, -22516, -25605, -16712, 0,
	16712, 25604, 22516, 8892, -8892, -22516, -25605, -16712,
	0, 16712, 25604, 22516, 8892, -8892, -22516, -25605,
	-16712, 0, 16712, 25604, 22516, 8892, -8892, -22516,
	-25605, -16712, 0, 16712, 25604, 22516, 8892, -8892,
	-22516, -25605, -16712, 0, 16712, 25604, 22516, 8892,
	-8892, -22516, -25605, -16712, 0, 16712, 25604, 22516,
	8892, -8892, -22516, -25605, -16712, 0, 16712, 25604,
	22516, 8892, -8892, -22516, -25605, -16712, 0, 16712,
	25604, 22516, 8892, -8892, -22516, -25605, -16712, 0,
	16712, 25604, 22516, 8892, -8892, -22516, -25605, -16712},
	{
// Carrier 18 Phase 1
	9949, 23062, 25383, 15827, -1134, -17565, -25777, -21928,
	-7818, 9949, 23062, 25383, 15827, -1134, -17565, -25777,
	-21928, -7818, 9949, 23062, 25383, 15827, -1134, -17565,
	-25777, -21928, -7818, 9949, 23062, 25383, 15827, -1134,
	-17565, -25777, -21928, -7818, 9949, 23062, 25383, 15827,
	-1134, -17565, -25777, -21928, -7818, 9949, 23062, 25383,
	15827, -1134, -17565, -25777, -21928, -7818, 9949, 23062,
	25383, 15827, -1134, -17565, -25777, -21928, -7818, 9949,
	23062, 25383, 15827, -1134, -17565, -25777, -21928, -7818,
	9949, 23062, 25383, 15827, -1134, -17565, -25777, -21928,
	-7818, 9949, 23062, 25383, 15827, -1133, -17565, -25777,
	-21928, -7818, 9949, 23062, 25383, 15827, -1133, -17565,
	-25777, -21928, -7818, 9949, 23062, 25383, 15827, -1133,
	-17565, -25777, -21928, -7818, 9949, 23062, 25383, 15827,
	-1133, -17565, -25777, -21928, -7818, 9949, 23062, 25383,
	15827, -1133, -17565, -25777, -21928, -7818, 9949, 23062,
	25383, 15827, -1133, -17565, -25777, -21928, -7818, 9949,
	23062, 25383, 15827, -1133, -17565, -25777, -21928, -7818,
	9949, 23062, 25383, 15827, -1133, -17565, -25777, -21928,
	-7818, 9949, 23062, 25383, 15827, -1133, -17565, -25777,
	-21928, -7818, 9949, 23062, 25383, 15827, -1133, -17565,
	-25777, -21928, -7818, 9949, 23062, 25383, 15827, -1133,
	-17565, -25777, -21928, -7818, 9949, 23062, 25383, 15827,
	-1133, -17565, -25777, -21928, -7818, 9949, 23062, 25383,
	15827, -1133, -17565, -25777, -21928, -7818, 9949, 23062,
	25383, 15828, -1133, -17565, -25777, -21928, -7818, 9949,
	23062, 25383, 15828, -1133, -17565, -25777, -21928, -7818},
	{
// Carrier 18 Phase 2
	18384, 25901, 21297, 6729, -10988, -23563, -25114, -14913,
	2266, 18384, 25901, 21297, 6729, -10988, -23563, -25114,
	-14913, 2266, 18384, 25901, 21297, 6729, -10988, -23563,
	-25114, -14913, 2266, 18384, 25901, 21297, 6729, -10988,
	-23563, -25114, -14913, 2265, 18384, 25901, 21297, 6729,
	-10988, -23563, -25114, -14913, 2265, 18384, 25901, 21297,
	6729, -10988, -23563, -25114, -14913, 2265, 18384, 25901,
	21297, 6729, -10988, -23563, -25114, -14913, 2265, 18384,
	25901, 21298, 6729, -10987, -23563, -25114, -14913, 2265,
	18384, 25901, 21298, 6729, -10987, -23563, -25114, -14913,
	2265, 18384, 25901, 21298, 6729, -10987, -23563, -25114,
	-14913, 2265, 18384, 25901, 21298, 6729, -10987, -23563,
	-25114, -14913, 2265, 18384, 25901, 21298, 6729, -10987,
	-23563, -25114, -14913, 2265, 18384, 25901, 21298, 6729,
	-10987, -23563, -25114, -14913, 2265, 18384, 25901, 21298,
	6729, -10987, -23563, -25114, -14913, 2265, 18384, 25901,
	21298, 6729, -10987, -23563, -25114, -14913, 2265, 18384,
	25901, 21298, 6729, -10987, -23563, -25114, -14913, 2265,
	18384, 25901, 21298, 6729, -10987, -23563, -25114, -14913,
	2265, 18384, 25901, 21298, 6729, -10987, -23563, -25114,
	-14913, 2265, 18384, 25901, 21298, 6729, -10987, -23563,
	-25114, -14913, 2265, 18384, 25901, 21298, 6729, -10987,
	-23563, -25114, -14913, 2265, 18384, 25901, 21298, 6729,
	-10987, -23563, -25114, -14913, 2265, 18384, 25901, 21298,
	6729, -10987, -23563, -25114, -14913, 2265, 18384, 25901,
	21298, 6729, -10987, -23563, -25114, -14913, 2265, 18384,
	25901, 21298, 6729, -10987, -23563, -25114, -14913, 2265},
	{
// Carrier 18 Phase 3
	24020, 24796, 13969, -3393, -19169, -25975, -20627, -5627,
	12005, 24020, 24796, 13969, -3393, -19169, -25975, -20627,
	-5627, 12005, 24020, 24796, 13969, -3393, -19169, -25975,
	-20627, -5627, 12005, 24020, 24796, 13969, -3393, -19169,
	-25975, -20627, -5627, 12005, 24020, 24796, 13969, -3393,
	-19169, -25975, -20627, -5627, 12005, 24020, 24796, 13969,
	-3393, -19169, -25975, -20627, -5627, 12005, 24020, 24796,
	13969, -3393, -19169, -25975, -20627, -5627, 12005, 24020,
	24796, 13969, -3393, -19169, -25975, -20627, -5627, 12005,
	24020, 24796, 13969, -3393, -19169, -25975, -20627, -5627,
	12005, 24020, 24796, 13969, -3393, -19169, -25975, -20627,
	-5627, 12005, 24020, 24796, 13969, -3393, -19169, -25975,
	-20627, -5627, 12005, 24020, 24796, 13969, -3393, -19169,
	-25975, -20627, -5627, 12005, 24020, 24796, 13969, -3393,
	-19169, -25975, -20627, -5627, 12005, 24020, 24796, 13969,
	-3393, -19169, -25975, -20627, -5627, 12005, 24020, 24796,
	13969, -3393, -19169, -25975, -20627, -5627, 12005, 24020,
	24796, 13969, -3393, -19169, -25975, -20627, -5627, 12005,
	24020, 24796, 13969, -3393, -19169, -25975, -20627, -5627,
	12005, 24020, 24796, 13969, -3393, -19169, -25975, -20627,
	-5627, 12005, 24020, 24796, 13969, -3393, -19169, -25975,
	-20627, -5627, 12005, 24020, 24796, 13969, -3393, -19169,
	-25975, -20627, -5627, 12005, 24020, 24796, 13969, -3393,
	-19169, -25975, -20627, -5627, 12005, 24020, 24796, 13970,
	-3393, -19169, -25975, -20627, -5627, 12005, 24020, 24796,
	13970, -3393, -19169, -25975, -20627, -5627, 12005, 24020,
	24796, 13970, -3393, -19169, -25975, -20627, -5627, 12005},
	{
// Carrier 18 Phase 4
	26000, 19917, 4514, -12999, -24432, -24432, -13000, 4514,
	19917, 26000, 19917, 4514, -12999, -24432, -24432, -13000,
	4514, 19917, 26000, 19917, 4514, -12999, -24431, -24432,
	-13000, 4514, 19917, 26000, 19917, 4514, -12999, -24431,
	-24432, -13000, 4514, 19917, 26000, 19917, 4514, -12999,
	-24431, -24432, -13000, 4514, 19917, 26000, 19917, 4514,
	-12999, -24431, -24432, -13000, 4514, 19917, 26000, 19917,
	4514, -12999, -24431, -24432, -13000, 4514, 19917, 26000,
	19917, 4514, -12999, -24431, -24432, -13000, 4514, 19917,
	26000, 19917, 4514, -12999, -24431, -24432, -13000, 4514,
	19917, 26000, 19917, 4514, -12999, -24431, -24432, -13000,
	4514, 19917, 26000, 19917, 4514, -12999, -24431, -24432,
	-13000, 4514, 19917, 26000, 19917, 4514, -12999, -24431,
	-24432, -13000, 4514, 19917, 26000, 19917, 4515, -12999,
	-24431, -24432, -13000, 4514, 19917, 26000, 19917, 4515,
	-12999, -24431, -24432, -13000, 4514, 19917, 26000, 19917,
	4515, -12999, -24431, -24432, -13000, 4514, 19917, 26000,
	19917, 4515, -12999, -24431, -24432, -13000, 4514, 19917,
	26000, 19917, 4515, -12999, -24431, -24432, -13000, 4514,
	19917, 26000, 19917, 4515, -12999, -24431, -24432, -13000,
	4514, 19917, 26000, 19917, 4515, -12999, -24431, -24432,
	-13000, 4514, 19917, 26000, 19917, 4515, -12999, -24431,
	-24432, -13000, 4514, 19916, 26000, 19917, 4515, -12999,
	-24431, -24432, -13000, 4514, 19916, 26000, 19917, 4515,
	-12999, -24431, -24432, -13000, 4514, 19916, 26000, 19917,
	4515, -12999, -24431, -24432, -13000, 4514, 19916, 26000,
	19917, 4515, -12999, -24431, -24432, -13000, 4514, 19916},
	{
// Carrier 18 Phase 5
	24020, 12005, -5627, -20627, -25975, -19169, -3393, 13969,
	24796, 24020, 12005, -5627, -20627, -25975, -19169, -3393,
	13969, 24796, 24020, 12005, -5627, -20627, -25975, -19169,
	-3393, 13969, 24796, 24020, 12005, -5627, -20627, -25975,
	-19169, -3393, 13969, 24796, 24020, 12005, -5627, -20627,
	-25975, -19169, -3393, 13969, 24796, 24020, 12005, -5627,
	-20627, -25975, -19169, -3393, 13969, 24796, 24020, 12005,
	-5627, -20627, -25975, -19169, -3393, 13969, 24796, 24020,
	12005, -5627, -20627, -25975, -19169, -3393, 13969, 24796,
	24020, 12005, -5627, -20627, -25975, -19169, -3393, 13969,
	24796, 24020, 12005, -5627, -20627, -25975, -19169, -3393,
	13969, 24796, 24020, 12005, -5627, -20627, -25975, -19169,
	-3393, 13969, 24796, 24020, 12005, -5627, -20627, -25975,
	-19169, -3393, 13969, 24796, 24020, 12005, -5627, -20627,
	-25975, -19169, -3393, 13969, 24796, 24020, 12005, -5627,
	-20627, -25975, -19169, -3393, 13969, 24796, 24020, 12005,
	-5627, -20627, -25975, -19169, -3393, 13969, 24796, 24020,
	12005, -5627, -20627, -25975, -19169, -3393, 13969, 24796,
	24020, 12005, -5627, -20627, -25975, -19169, -3393, 13969,
	24796, 24020, 12005, -5627, -20627, -25975, -19169, -3393,
	13969, 24796, 24020, 12005, -5627, -20627, -25975, -19169,
	-3393, 13969, 24796, 24020, 12005, -5627, -20627, -25975,
	-19169, -3393, 13969, 24796, 24020, 12005, -5627, -20627,
	-25975, -19169, -3393, 13969, 24796, 24020, 12005, -5627,
	-20627, -25975, -19169, -3393, 13969, 24796, 24020, 12005,
	-5627, -20627, -25975, -19169, -3393, 13969, 24796, 24020,
	12005, -5627, -20627, -25975, -19169, -3393, 13969, 24796},
	{
// Carrier 18 Phase 6
	18384, 2266, -14912, -25114, -23564, -10988, 6729, 21297,
	25901, 18384, 2266, -14912, -25114, -23564, -10988, 6729,
	21297, 25901, 18384, 2266, -14912, -25114, -23564, -10988,
	6729, 21297, 25901, 18384, 2266, -14912, -25114, -23564,
	-10988, 6729, 21297, 25901, 18384, 2266, -14912, -25114,
	-23564, -10988, 6729, 21297, 25901, 18384, 2266, -14912,
	-25114, -23564, -10988, 6729, 21297, 25901, 18384, 2266,
	-14912, -25114, -23564, -10988, 6729, 21297, 25901, 18384,
	2266, -14912, -25114, -23564, -10988, 6729, 21297, 25901,
	18384, 2266, -14912, -25114, -23564, -10988, 6729, 21297,
	25901, 18384, 2266, -14912, -25114, -23564, -10988, 6729,
	21297, 25901, 18384, 2266, -14912, -25114, -23564, -10988,
	6729, 21297, 25901, 18384, 2266, -14912, -25114, -23564,
	-10988, 6729, 21297, 25901, 18384, 2266, -14912, -25114,
	-23564, -10988, 6729, 21297, 25901, 18384, 2266, -14912,
	-25114, -23564, -10988, 6729, 21297, 25901, 18384, 2266,
	-14912, -25114, -23564, -10988, 6729, 21297, 25901, 18384,
	2266, -14912, -25114, -23564, -10988, 6729, 21297, 25901,
	18384, 2266, -14912, -25114, -23564, -10988, 6729, 21297,
	25901, 18384, 2266, -14912, -25114, -23564, -10988, 6729,
	21297, 25901, 18384, 2266, -14912, -25114, -23564, -10988,
	6729, 21297, 25901, 18384, 2266, -14912, -25114, -23564,
	-10988, 6729, 21297, 25901, 18384, 2266, -14912, -25114,
	-23564, -10988, 6729, 21297, 25901, 18384, 2266, -14912,
	-25114, -23564, -10988, 6729, 21297, 25901, 18384, 2266,
	-14912, -25113, -23564, -10988, 6729, 21297, 25901, 18384,
	2266, -14912, -25113, -23564, -10988, 6729, 21297, 25901},
	{
// Carrier 18 Phase 7
	9949, -7818, -21928, -25777, -17565, -1134, 15827, 25383,
	23062, 9949, -7818, -21928, -25777, -17565, -1134, 15827,
	25383, 23062, 9949, -7818, -21928, -25777, -17565, -1134,
	15827, 25383, 23062, 9949, -7818, -21928, -25777, -17565,
	-1134, 15827, 25383, 23062, 9949, -7818, -21928, -25777,
	-17565, -1134, 15827, 25383, 23062, 9949, -7818, -21928,
	-25777, -17565, -1134, 15827, 25383, 23062, 9949, -7818,
	-21928, -25777, -17565, -1134, 15827, 25383, 23062, 9949,
	-7818, -21928, -25777, -17565, -1134, 15827, 25383, 23062,
	9949, -7818, -21928, -25777, -17565, -1134, 15827, 25383,
	23062, 9949, -7818, -21928, -25777, -17565, -1134, 15827,
	25383, 23062, 9949, -7818, -21928, -25777, -17565, -1134,
	15827, 25383, 23062, 9949, -7818, -21928, -25777, -17565,
	-1134, 15827, 25383, 23062, 9949, -7818, -21928, -25777,
	-17565, -1134, 15827, 25383, 23062, 9949, -7818, -21928,
	-25777, -17565, -1134, 15827, 25383, 23062, 9949, -7818,
	-21928, -25777, -17565, -1134, 15827, 25383, 23062, 9949,
	-7818, -21928, -25777, -17565, -1134, 15827, 25383, 23062,
	9949, -7818, -21928, -25777, -17565, -1134, 15827, 25383,
	23062, 9949, -7818, -21928, -25777, -17565, -1134, 15827,
	25383, 23062, 9949, -7818, -21928, -25777, -17565, -1134,
	15827, 25383, 23062, 9949, -7818, -21928, -25777, -17565,
	-1134, 15827, 25383, 23062, 9949, -7818, -21928, -25777,
	-17565, -1134, 15827, 25383, 23062, 9950, -7818, -21928,
	-25777, -17565, -1134, 15827, 25383, 23062, 9950, -7818,
	-21928, -25777, -17565, -1134, 15827, 25383, 23062, 9950,
	-7818, -21928, -25777, -17565, -1134, 15827, 25383, 23062},
	},{{

// Carrier 19 Phase 0
	0, 17284, 25824, 21297, 5996, -12339, -24432, -24163,
	-11668, 6729, 21722, 25725, 16712, -756, -17842, -25901,
	-20855, -5257, 12999, 24680, 23873, 10988, -7456, -22129,
	-25605, -16126, 1511, 18384, 25956, 20394, 4514, -13649,
	-24907, -23564, -10298, 8178, 22516, 25462, 15526, -2266,
	-18911, -25989, -19917, -3768, 14287, 25114, 23234, 9599,
	-8892, -22885, -25299, -14912, 3018, 19422, 26000, 19422,
	3018, -14913, -25299, -22885, -8892, 9599, 23234, 25114,
	14287, -3768, -19917, -25989, -18911, -2266, 15526, 25462,
	22516, 8178, -10298, -23564, -24907, -13649, 4514, 20394,
	25956, 18384, 1511, -16126, -25605, -22129, -7456, 10988,
	23873, 24680, 12999, -5257, -20855, -25901, -17842, -756,
	16712, 25725, 21722, 6729, -11668, -24163, -24431, -12339,
	5996, 21297, 25824, 17284, 0, -17284, -25824, -21297,
	-5995, 12339, 24432, 24163, 11668, -6729, -21722, -25725,
	-16712, 756, 17842, 25901, 20855, 5257, -13000, -24680,
	-23873, -10988, 7456, 22129, 25604, 16126, -1511, -18384,
	-25956, -20394, -4514, 13649, 24907, 23563, 10297, -8178,
	-22516, -25462, -15526, 2266, 18911, 25989, 19917, 3768,
	-14287, -25114, -23234, -9599, 8892, 22885, 25299, 14912,
	-3018, -19422, -26000, -19422, -3018, 14913, 25299, 22885,
	8892, -9599, -23234, -25114, -14287, 3768, 19917, 25988,
	18911, 2265, -15526, -25462, -22516, -8178, 10298, 23564,
	24907, 13649, -4514, -20394, -25956, -18384, -1511, 16126,
	25605, 22128, 7456, -10988, -23873, -24680, -12999, 5257,
	20855, 25901, 17842, 756, -16712, -25725, -21722, -6729,
	11668, 24163, 24431, 12339, -5996, -21298, -25824, -17284},
	{
// Carrier 19 Phase 1
	9949, 23401, 25013, 13969, -4141, -20158, -25975, -18650,
	-1889, 15827, 25536, 22325, 7818, -10644, -23721, -24796,
	-13326, 4886, 20627, 25931, 18115, 1134, -16421, -25667,
	-21928, -7093, 11329, 24020, 24558, 12671, -5627, -21078,
	-25865, -17565, -378, 17000, 25777, 21512, 6363, -12005,
	-24300, -24300, -12005, 6363, 21512, 25777, 17000, -378,
	-17565, -25865, -21078, -5627, 12671, 24558, 24020, 11329,
	-7093, -21928, -25667, -16421, 1134, 18115, 25931, 20627,
	4886, -13326, -24796, -23721, -10644, 7818, 22325, 25536,
	15827, -1889, -18650, -25975, -20158, -4141, 13969, 25013,
	23401, 9949, -8536, -22703, -25383, -15221, 2642, 19169,
	25997, 19671, 3393, -14601, -25209, -23062, -9246, 9246,
	23062, 25209, 14601, -3393, -19672, -25997, -19169, -2642,
	15221, 25383, 22703, 8536, -9949, -23401, -25013, -13969,
	4142, 20158, 25975, 18650, 1889, -15827, -25536, -22325,
	-7818, 10644, 23721, 24796, 13326, -4886, -20627, -25931,
	-18115, -1134, 16421, 25667, 21928, 7093, -11329, -24020,
	-24558, -12671, 5627, 21078, 25865, 17565, 378, -17000,
	-25777, -21512, -6363, 12005, 24300, 24300, 12005, -6363,
	-21512, -25777, -17000, 378, 17565, 25865, 21078, 5627,
	-12671, -24558, -24020, -11329, 7093, 21928, 25667, 16420,
	-1134, -18115, -25931, -20627, -4886, 13326, 24796, 23721,
	10644, -7818, -22325, -25536, -15827, 1889, 18650, 25975,
	20158, 4141, -13969, -25013, -23401, -9949, 8536, 22703,
	25383, 15221, -2642, -19169, -25997, -19671, -3393, 14601,
	25209, 23062, 9246, -9247, -23062, -25209, -14601, 3393,
	19672, 25997, 19169, 2642, -15221, -25383, -22703, -8536},
	{
// Carrier 19 Phase 2
	18384, 25956, 20394, 4514, -13649, -24907, -23564, -10298,
	8178, 22516, 25462, 15526, -2266, -18911, -25989, -19917,
	-3768, 14287, 25114, 23234, 9599, -8892, -22885, -25299,
	-14912, 3018, 19422, 26000, 19422, 3018, -14913, -25299,
	-22885, -8892, 9599, 23234, 25114, 14287, -3768, -19917,
	-25989, -18911, -2266, 15526, 25462, 22516, 8178, -10298,
	-23564, -24907, -13649, 4514, 20394, 25956, 18384, 1511,
	-16126, -25605, -22129, -7456, 10988, 23873, 24680, 12999,
	-5257, -20855, -25901, -17842, -756, 16712, 25725, 21722,
	6729, -11668, -24163, -24431, -12339, 5996, 21297, 25824,
	17284, 0, -17284, -25824, -21297, -5995, 12339, 24432,
	24163, 11668, -6729, -21722, -25725, -16712, 756, 17842,
	25901, 20855, 5257, -13000, -24680, -23873, -10988, 7456,
	22129, 25604, 16126, -1511, -18384, -25956, -20394, -4514,
	13649, 24907, 23563, 10297, -8178, -22516, -25462, -15526,
	2266, 18911, 25989, 19917, 3768, -14287, -25114, -23234,
	-9599, 8892, 22885, 25299, 14912, -3018, -19422, -26000,
	-19422, -3018, 14913, 25299, 22885, 8892, -9599, -23234,
	-25114, -14287, 3768, 19917, 25988, 18911, 2265, -15526,
	-25462, -22516, -8178, 10298, 23564, 24907, 13649, -4514,
	-20394, -25956, -18384, -1511, 16126, 25605, 22128, 7456,
	-10988, -23873, -24680, -12999, 5257, 20855, 25901, 17842,
	756, -16712, -25725, -21722, -6729, 11668, 24163, 24431,
	12339, -5996, -21298, -25824, -17284, 0, 17284, 25824,
	21297, 5995, -12339, -24432, -24162, -11668, 6729, 21722,
	25725, 16712, -756, -17842, -25901, -20855, -5257, 13000,
	24680, 23873, 10987, -7457, -22129, -25604, -16126, 1511},
	{
// Carrier 19 Phase 3
	24020, 24558, 12671, -5627, -21078, -25865, -17565, -378,
	17000, 25777, 21512, 6363, -12005, -24300, -24300, -12005,
	6363, 21512, 25777, 17000, -378, -17565, -25865, -21078,
	-5627, 12671, 24558, 24020, 11329, -7093, -21928, -25667,
	-16421, 1134, 18115, 25931, 20627, 4886, -13326, -24796,
	-23721, -10644, 7818, 22325, 25536, 15827, -1889, -18650,
	-25975, -20158, -4141, 13969, 25013, 23401, 9949, -8536,
	-22703, -25383, -15221, 2642, 19169, 25997, 19671, 3393,
	-14601, -25209, -23062, -9246, 9246, 23062, 25209, 14601,
	-3393, -19672, -25997, -19169, -2642, 15221, 25383, 22703,
	8536, -9949, -23401, -25013, -13969, 4142, 20158, 25975,
	18650, 1889, -15827, -25536, -22325, -7818, 10644, 23721,
	24796, 13326, -4886, -20627, -25931, -18115, -1134, 16421,
	25667, 21928, 7093, -11329, -24020, -24558, -12671, 5627,
	21078, 25865, 17565, 378, -17000, -25777, -21512, -6363,
	12005, 24300, 24300, 12005, -6363, -21512, -25777, -17000,
	378, 17565, 25865, 21078, 5627, -12671, -24558, -24020,
	-11329, 7093, 21928, 25667, 16420, -1134, -18115, -25931,
	-20627, -4886, 13326, 24796, 23721, 10644, -7818, -22325,
	-25536, -15827, 1889, 18650, 25975, 20158, 4141, -13969,
	-25013, -23401, -9949, 8536, 22703, 25383, 15221, -2642,
	-19169, -25997, -19671, -3393, 14601, 25209, 23062, 9246,
	-9247, -23062, -25209, -14601, 3393, 19672, 25997, 19169,
	2642, -15221, -25383, -22703, -8536, 9949, 23401, 25013,
	13969, -4142, -20158, -25975, -18650, -1888, 15827, 25536,
	22325, 7818, -10644, -23721, -24796, -13325, 4886, 20627,
	25931, 18115, 1133, -16421, -25667, -21928, -7093, 11329},
	{
// Carrier 19 Phase 4
	26000, 19422, 3018, -14912, -25299, -22885, -8892, 9599,
	23234, 25114, 14287, -3768, -19917, -25989, -18911, -2266,
	15526, 25462, 22516, 8178, -10298, -23564, -24907, -13649,
	4514, 20394, 25956, 18384, 1511, -16126, -25605, -22129,
	-7456, 10988, 23873, 24680, 12999, -5257, -20855, -25901,
	-17842, -756, 16712, 25725, 21722, 6729, -11668, -24163,
	-24431, -12339, 5996, 21297, 25824, 17284, 0, -17284,
	-25824, -21297, -5995, 12339, 24432, 24163, 11668, -6729,
	-21722, -25725, -16712, 756, 17842, 25901, 20855, 5257,
	-13000, -24680, -23873, -10988, 7456, 22129, 25604, 16126,
	-1511, -18384, -25956, -20394, -4514, 13649, 24907, 23563,
	10298, -8178, -22516, -25462, -15526, 2266, 18911, 25989,
	19917, 3768, -14287, -25114, -23234, -9599, 8892, 22885,
	25299, 14912, -3018, -19422, -26000, -19422, -3018, 14913,
	25299, 22885, 8892, -9599, -23234, -25114, -14287, 3768,
	19917, 25988, 18911, 2265, -15526, -25462, -22516, -8178,
	10298, 23564, 24907, 13649, -4514, -20394, -25956, -18384,
	-1511, 16126, 25605, 22128, 7456, -10988, -23873, -24680,
	-12999, 5257, 20855, 25901, 17842, 756, -16712, -25725,
	-21722, -6729, 11668, 24163, 24431, 12339, -5996, -21298,
	-25824, -17284, 0, 17284, 25824, 21297, 5995, -12339,
	-24432, -24162, -11668, 6729, 21722, 25725, 16712, -756,
	-17842, -25901, -20855, -5257, 13000, 24680, 23873, 10987,
	-7457, -22129, -25604, -16126, 1511, 18384, 25956, 20394,
	4514, -13649, -24907, -23563, -10297, 8178, 22516, 25462,
	15526, -2266, -18911, -25989, -19917, -3768, 14287, 25114,
	23234, 9599, -8892, -22885, -25299, -14912, 3018, 19422},
	{
// Carrier 19 Phase 5
	24020, 11329, -7093, -21928, -25667, -16421, 1134, 18115,
	25931, 20627, 4886, -13326, -24796, -23721, -10644, 7818,
	22325, 25536, 15827, -1889, -18650, -25975, -20158, -4141,
	13969, 25013, 23401, 9949, -8536, -22703, -25383, -15221,
	2642, 19169, 25997, 19671, 3393, -14601, -25209, -23062,
	-9246, 9246, 23062, 25209, 14601, -3393, -19672, -25997,
	-19169, -2642, 15221, 25383, 22703, 8536, -9949, -23401,
	-25013, -13969, 4142, 20158, 25975, 18650, 1889, -15827,
	-25536, -22325, -7818, 10644, 23721, 24796, 13326, -4886,
	-20627, -25931, -18115, -1134, 16421, 25667, 21928, 7093,
	-11329, -24020, -24558, -12671, 5627, 21078, 25865, 17565,
	378, -17000, -25777, -21512, -6363, 12005, 24300, 24300,
	12005, -6363, -21512, -25777, -17000, 378, 17565, 25865,
	21078, 5627, -12671, -24558, -24020, -11329, 7093, 21928,
	25667, 16420, -1134, -18115, -25931, -20627, -4886, 13326,
	24796, 23721, 10644, -7818, -22325, -25536, -15827, 1889,
	18650, 25975, 20158, 4141, -13969, -25013, -23401, -9949,
	8536, 22703, 25383, 15221, -2642, -19169, -25997, -19671,
	-3393, 14601, 25209, 23062, 9246, -9247, -23062, -25209,
	-14601, 3393, 19672, 25997, 19169, 2642, -15221, -25383,
	-22703, -8536, 9949, 23401, 25013, 13969, -4142, -20158,
	-25975, -18650, -1888, 15827, 25536, 22325, 7818, -10644,
	-23721, -24796, -13325, 4886, 20627, 25931, 18115, 1133,
	-16421, -25667, -21928, -7093, 11329, 24020, 24558, 12671,
	-5627, -21078, -25865, -17565, -378, 17000, 25777, 21512,
	6363, -12005, -24300, -24300, -12005, 6363, 21512, 25777,
	17000, -378, -17565, -25865, -21078, -5627, 12671, 24558},
	{
// Carrier 19 Phase 6
	18384, 1511, -16126, -25605, -22129, -7456, 10988, 23873,
	24680, 12999, -5257, -20855, -25901, -17842, -756, 16712,
	25725, 21722, 6729, -11668, -24163, -24432, -12339, 5996,
	21297, 25824, 17284, 0, -17284, -25824, -21297, -5995,
	12339, 24432, 24163, 11668, -6729, -21722, -25725, -16712,
	756, 17842, 25901, 20855, 5257, -13000, -24680, -23873,
	-10988, 7456, 22129, 25604, 16126, -1511, -18384, -25956,
	-20394, -4514, 13649, 24907, 23563, 10298, -8178, -22516,
	-25462, -15526, 2266, 18911, 25989, 19917, 3768, -14287,
	-25114, -23234, -9599, 8892, 22885, 25299, 14912, -3018,
	-19422, -26000, -19422, -3018, 14913, 25299, 22885, 8892,
	-9599, -23234, -25114, -14287, 3768, 19917, 25988, 18911,
	2265, -15526, -25462, -22516, -8178, 10298, 23564, 24907,
	13649, -4514, -20394, -25956, -18384, -1511, 16126, 25605,
	22128, 7456, -10988, -23873, -24680, -12999, 5257, 20855,
	25901, 17842, 756, -16712, -25725, -21722, -6729, 11668,
	24163, 24431, 12339, -5996, -21298, -25824, -17284, 0,
	17284, 25824, 21297, 5995, -12339, -24432, -24162, -11668,
	6729, 21722, 25725, 16712, -756, -17842, -25901, -20855,
	-5257, 13000, 24680, 23873, 10987, -7456, -22129, -25604,
	-16126, 1511, 18384, 25956, 20394, 4514, -13649, -24907,
	-23563, -10297, 8178, 22516, 25462, 15526, -2266, -18911,
	-25989, -19917, -3768, 14287, 25114, 23234, 9599, -8892,
	-22885, -25299, -14912, 3018, 19422, 26000, 19422, 3018,
	-14913, -25299, -22885, -8892, 9599, 23234, 25114, 14287,
	-3768, -19917, -25988, -18911, -2265, 15526, 25462, 22516,
	8178, -10298, -23564, -24907, -13649, 4515, 20394, 25956},
	{
// Carrier 19 Phase 7
	9949, -8536, -22703, -25383, -15221, 2642, 19169, 25997,
	19671, 3393, -14601, -25209, -23062, -9246, 9246, 23062,
	25209, 14601, -3393, -19671, -25997, -19169, -2642, 15221,
	25383, 22703, 8536, -9949, -23401, -25013, -13969, 4142,
	20158, 25975, 18650, 1889, -15827, -25536, -22325, -7818,
	10644, 23721, 24796, 13326, -4886, -20627, -25931, -18115,
	-1134, 16421, 25667, 21928, 7093, -11329, -24020, -24558,
	-12671, 5627, 21078, 25865, 17565, 378, -17000, -25777,
	-21512, -6363, 12005, 24300, 24300, 12005, -6363, -21512,
	-25777, -17000, 378, 17565, 25865, 21078, 5627, -12671,
	-24558, -24020, -11329, 7093, 21928, 25667, 16420, -1134,
	-18115, -25931, -20627, -4886, 13326, 24796, 23721, 10644,
	-7818, -22325, -25536, -15827, 1889, 18650, 25975, 20158,
	4141, -13969, -25013, -23401, -9949, 8536, 22703, 25383,
	15221, -2642, -19169, -25997, -19671, -3393, 14601, 25209,
	23062, 9246, -9246, -23062, -25209, -14601, 3393, 19672,
	25997, 19169, 2642, -15221, -25383, -22703, -8536, 9949,
	23401, 25013, 13969, -4142, -20158, -25975, -18650, -1889,
	15827, 25536, 22325, 7818, -10644, -23721, -24796, -13326,
	4886, 20627, 25931, 18115, 1133, -16421, -25667, -21928,
	-7093, 11329, 24020, 24558, 12671, -5627, -21078, -25865,
	-17565, -378, 17000, 25777, 21512, 6363, -12005, -24300,
	-24300, -12005, 6363, 21512, 25777, 17000, -378, -17565,
	-25865, -21078, -5627, 12671, 24558, 24020, 11329, -7093,
	-21928, -25667, -16420, 1134, 18115, 25931, 20627, 4886,
	-13326, -24796, -23721, -10644, 7818, 22325, 25536, 15827,
	-1889, -18650, -25975, -20158, -4141, 13969, 25013, 23401},
	},{{

// Carrier 20 Phase 0
	0, 17842, 25956, 19917, 3018, -15526, -25605, -21722,
	-5996, 13000, 24907, 23234, 8892, -10298, -23873, -24432,
	-11668, 7456, 22516, 25299, 14287, -4514, -20855, -25824,
	-16712, 1511, 18911, 26000, 18911, 1511, -16712, -25824,
	-20855, -4514, 14287, 25299, 22516, 7456, -11668, -24432,
	-23873, -10297, 8892, 23234, 24907, 12999, -5996, -21722,
	-25604, -15526, 3018, 19917, 25956, 17842, 0, -17842,
	-25956, -19917, -3018, 15526, 25605, 21722, 5995, -13000,
	-24907, -23234, -8892, 10298, 23873, 24431, 11668, -7457,
	-22516, -25299, -14287, 4515, 20855, 25824, 16712, -1511,
	-18911, -26000, -18911, -1511, 16712, 25824, 20855, 4514,
	-14287, -25299, -22516, -7456, 11668, 24432, 23873, 10297,
	-8892, -23234, -24907, -12999, 5996, 21722, 25604, 15525,
	-3018, -19917, -25955, -17842, 0, 17842, 25956, 19916,
	3018, -15526, -25605, -21722, -5995, 13000, 24907, 23234,
	8892, -10298, -23873, -24431, -11668, 7457, 22516, 25299,
	14286, -4515, -20855, -25824, -16712, 1512, 18911, 26000,
	18911, 1511, -16712, -25824, -20855, -4514, 14287, 25299,
	22516, 7456, -11669, -24432, -23873, -10297, 8892, 23234,
	24907, 12999, -5996, -21722, -25604, -15525, 3018, 19917,
	25955, 17842, 0, -17842, -25956, -19916, -3018, 15526,
	25605, 21722, 5995, -13000, -24907, -23234, -8892, 10298,
	23873, 24431, 11668, -7457, -22516, -25299, -14286, 4515,
	20855, 25824, 16712, -1512, -18912, -26000, -18911, -1511,
	16712, 25824, 20854, 4514, -14287, -25299, -22516, -7456,
	11669, 24432, 23873, 10297, -8892, -23234, -24907, -12999,
	5996, 21722, 25604, 15525, -3018, -19917, -25955, -17841},
	{
// Carrier 20 Phase 1
	9949, 23721, 24558, 12005, -7093, -22325, -25383, -14601,
	4142, 20627, 25865, 17000, -1134, -18650, -25997, -19169,
	-1889, 16421, 25777, 21078, 4886, -13969, -25209, -22703,
	-7818, 11329, 24300, 24020, 10644, -8536, -23062, -25013,
	-13326, 5627, 21512, 25667, 15827, -2642, -19672, -25975,
	-18115, -378, 17565, 25931, 20158, 3393, -15221, -25536,
	-21928, -6363, 12671, 24796, 23401, 9246, -9949, -23721,
	-24558, -12005, 7093, 22325, 25383, 14601, -4142, -20627,
	-25865, -17000, 1134, 18650, 25997, 19169, 1888, -16421,
	-25777, -21078, -4886, 13969, 25209, 22703, 7818, -11329,
	-24300, -24020, -10644, 8536, 23062, 25013, 13325, -5627,
	-21512, -25667, -15827, 2642, 19672, 25975, 18115, 377,
	-17565, -25931, -20157, -3393, 15221, 25536, 21928, 6363,
	-12671, -24796, -23401, -9246, 9950, 23721, 24558, 12005,
	-7094, -22325, -25383, -14601, 4142, 20627, 25865, 17000,
	-1134, -18650, -25997, -19169, -1888, 16421, 25777, 21078,
	4886, -13970, -25209, -22703, -7818, 11329, 24300, 24020,
	10643, -8536, -23062, -25013, -13325, 5627, 21512, 25667,
	15827, -2642, -19672, -25975, -18115, -377, 17565, 25931,
	20157, 3393, -15221, -25536, -21927, -6362, 12671, 24796,
	23401, 9246, -9950, -23721, -24558, -12005, 7094, 22325,
	25383, 14601, -4142, -20627, -25865, -17000, 1134, 18650,
	25997, 19168, 1888, -16421, -25777, -21078, -4886, 13970,
	25209, 22703, 7817, -11330, -24300, -24020, -10643, 8536,
	23062, 25013, 13325, -5627, -21512, -25667, -15827, 2642,
	19672, 25975, 18115, 377, -17565, -25931, -20157, -3393,
	15221, 25536, 21927, 6362, -12671, -24796, -23401, -9246},
	{
// Carrier 20 Phase 2
	18384, 25989, 19422, 2266, -16126, -25725, -21297, -5257,
	13649, 25114, 22885, 8178, -10988, -24163, -24163, -10988,
	8178, 22885, 25114, 13649, -5257, -21297, -25725, -16126,
	2266, 19422, 25988, 18384, 756, -17284, -25901, -20394,
	-3768, 14913, 25462, 22128, 6729, -12339, -24680, -23563,
	-9599, 9599, 23564, 24680, 12339, -6729, -22129, -25462,
	-14912, 3768, 20394, 25901, 17284, -756, -18384, -25989,
	-19422, -2265, 16126, 25725, 21297, 5257, -13649, -25114,
	-22885, -8178, 10988, 24163, 24162, 10987, -8178, -22885,
	-25114, -13649, 5257, 21298, 25725, 16125, -2266, -19422,
	-25988, -18384, -756, 17284, 25901, 20394, 3768, -14913,
	-25462, -22128, -6729, 12339, 24680, 23563, 9599, -9599,
	-23564, -24680, -12339, 6729, 22129, 25462, 14912, -3768,
	-20394, -25901, -17284, 756, 18384, 25989, 19422, 2265,
	-16126, -25725, -21297, -5257, 13649, 25114, 22885, 8177,
	-10988, -24163, -24162, -10987, 8178, 22885, 25113, 13649,
	-5257, -21298, -25725, -16125, 2266, 19422, 25988, 18384,
	755, -17284, -25901, -20394, -3767, 14913, 25462, 22128,
	6728, -12339, -24680, -23563, -9599, 9599, 23564, 24680,
	12339, -6729, -22129, -25462, -14912, 3768, 20395, 25901,
	17284, -756, -18385, -25989, -19422, -2265, 16126, 25725,
	21297, 5257, -13649, -25114, -22885, -8177, 10988, 24163,
	24162, 10987, -8178, -22885, -25113, -13649, 5258, 21298,
	25725, 16125, -2266, -19422, -25988, -18384, -755, 17285,
	25901, 20394, 3767, -14913, -25462, -22128, -6728, 12340,
	24680, 23563, 9598, -9599, -23564, -24680, -12339, 6729,
	22129, 25462, 14912, -3768, -20395, -25901, -17284, 756},
	{
// Carrier 20 Phase 3
	24020, 24300, 11329, -7818, -22703, -25209, -13969, 4886,
	21078, 25777, 16421, -1889, -19169, -25997, -18650, -1134,
	17000, 25865, 20627, 4141, -14601, -25383, -22325, -7093,
	12005, 24558, 23721, 9949, -9246, -23401, -24796, -12671,
	6363, 21928, 25536, 15221, -3393, -20158, -25931, -17565,
	378, 18115, 25975, 19671, 2642, -15827, -25667, -21512,
	-5627, 13326, 25013, 23062, 8536, -10644, -24020, -24300,
	-11329, 7818, 22703, 25209, 13969, -4886, -21078, -25777,
	-16420, 1889, 19169, 25997, 18650, 1133, -17000, -25865,
	-20627, -4141, 14601, 25383, 22325, 7093, -12005, -24558,
	-23721, -9949, 9247, 23401, 24796, 12670, -6363, -21928,
	-25536, -15221, 3393, 20158, 25931, 17565, -378, -18115,
	-25975, -19671, -2642, 15827, 25667, 21512, 5627, -13326,
	-25013, -23062, -8536, 10644, 24020, 24300, 11329, -7818,
	-22703, -25209, -13969, 4887, 21078, 25777, 16420, -1889,
	-19169, -25997, -18650, -1133, 17000, 25865, 20627, 4141,
	-14601, -25383, -22325, -7093, 12005, 24558, 23721, 9949,
	-9247, -23401, -24796, -12670, 6363, 21928, 25536, 15220,
	-3393, -20158, -25931, -17565, 378, 18115, 25975, 19671,
	2642, -15828, -25668, -21512, -5627, 13326, 25013, 23062,
	8535, -10644, -24021, -24299, -11329, 7818, 22703, 25209,
	13969, -4887, -21079, -25777, -16420, 1889, 19169, 25997,
	18649, 1133, -17000, -25865, -20626, -4141, 14601, 25383,
	22324, 7093, -12005, -24558, -23721, -9949, 9247, 23401,
	24796, 12670, -6363, -21928, -25536, -15220, 3394, 20158,
	25931, 17565, -378, -18115, -25975, -19671, -2642, 15828,
	25668, 21512, 5626, -13326, -25013, -23062, -8535, 10644},
	{
// Carrier 20 Phase 4
	26000, 18911, 1511, -16712, -25824, -20855, -4514, 14287,
	25299, 22516, 7456, -11668, -24432, -23873, -10298, 8892,
	23234, 24907, 12999, -5996, -21722, -25604, -15526, 3018,
	19917, 25956, 17842, 0, -17842, -25956, -19917, -3018,
	15526, 25605, 21722, 5995, -13000, -24907, -23234, -8892,
	10298, 23873, 24431, 11668, -7456, -22516, -25299, -14287,
	4514, 20855, 25824, 16712, -1511, -18911, -26000, -18911,
	-1511, 16712, 25824, 20855, 4514, -14287, -25299, -22516,
	-7456, 11668, 24432, 23873, 10297, -8892, -23234, -24907,
	-12999, 5996, 21722, 25604, 15525, -3018, -19917, -25956,
	-17842, 0, 17842, 25956, 19917, 3018, -15526, -25605,
	-21722, -5995, 13000, 24907, 23234, 8892, -10298, -23873,
	-24431, -11668, 7457, 22516, 25299, 14287, -4515, -20855,
	-25824, -16712, 1512, 18911, 26000, 18911, 1511, -16712,
	-25824, -20855, -4514, 14287, 25299, 22516, 7456, -11669,
	-24432, -23873, -10297, 8892, 23234, 24907, 12999, -5996,
	-21722, -25604, -15525, 3018, 19917, 25955, 17842, 0,
	-17842, -25956, -19916, -3018, 15526, 25605, 21722, 5995,
	-13000, -24907, -23234, -8892, 10298, 23873, 24431, 11668,
	-7457, -22516, -25299, -14286, 4515, 20855, 25824, 16712,
	-1512, -18911, -26000, -18911, -1511, 16712, 25824, 20854,
	4514, -14287, -25299, -22516, -7456, 11669, 24432, 23873,
	10297, -8892, -23234, -24907, -12999, 5996, 21722, 25604,
	15525, -3018, -19917, -25955, -17841, 0, 17842, 25956,
	19916, 3017, -15526, -25605, -21722, -5995, 13000, 24907,
	23234, 8892, -10298, -23873, -24431, -11668, 7457, 22516,
	25299, 14286, -4515, -20855, -25824, -16712, 1512, 18912},
	{
// Carrier 20 Phase 5
	24020, 10644, -8536, -23062, -25013, -13326, 5627, 21512,
	25667, 15827, -2642, -19671, -25975, -18115, -378, 17565,
	25931, 20158, 3393, -15221, -25536, -21928, -6363, 12671,
	24796, 23401, 9246, -9949, -23721, -24558, -12005, 7093,
	22325, 25383, 14601, -4142, -20627, -25865, -17000, 1134,
	18650, 25997, 19169, 1889, -16421, -25777, -21078, -4886,
	13969, 25209, 22703, 7818, -11329, -24300, -24020, -10644,
	8536, 23062, 25013, 13325, -5627, -21512, -25667, -15827,
	2642, 19672, 25975, 18115, 377, -17565, -25931, -20158,
	-3393, 15221, 25536, 21928, 6363, -12671, -24796, -23401,
	-9246, 9949, 23721, 24558, 12005, -7094, -22325, -25383,
	-14601, 4142, 20627, 25865, 17000, -1134, -18650, -25997,
	-19169, -1888, 16421, 25777, 21078, 4886, -13969, -25209,
	-22703, -7818, 11329, 24300, 24020, 10643, -8536, -23062,
	-25013, -13325, 5627, 21512, 25667, 15827, -2642, -19672,
	-25975, -18115, -377, 17565, 25931, 20157, 3393, -15221,
	-25536, -21928, -6363, 12671, 24796, 23401, 9246, -9950,
	-23721, -24558, -12005, 7094, 22325, 25383, 14601, -4142,
	-20627, -25865, -17000, 1134, 18650, 25997, 19168, 1888,
	-16421, -25777, -21078, -4886, 13970, 25209, 22703, 7818,
	-11329, -24300, -24020, -10643, 8536, 23062, 25013, 13325,
	-5627, -21512, -25667, -15827, 2642, 19672, 25975, 18115,
	377, -17565, -25931, -20157, -3393, 15221, 25536, 21927,
	6362, -12671, -24796, -23401, -9246, 9950, 23721, 24558,
	12005, -7094, -22325, -25383, -14601, 4142, 20627, 25865,
	17000, -1134, -18650, -25997, -19168, -1888, 16421, 25777,
	21078, 4886, -13970, -25209, -22703, -7817, 11330, 24300},
	{
// Carrier 20 Phase 6
	18384, 756, -17284, -25901, -20394, -3768, 14913, 25462,
	22129, 6729, -12339, -24680, -23563, -9599, 9599, 23564,
	24680, 12339, -6729, -22129, -25462, -14912, 3768, 20394,
	25901, 17284, -756, -18384, -25989, -19422, -2265, 16126,
	25725, 21297, 5257, -13649, -25114, -22885, -8178, 10988,
	24163, 24163, 10987, -8178, -22885, -25114, -13649, 5257,
	21298, 25725, 16126, -2266, -19422, -25988, -18384, -756,
	17284, 25901, 20394, 3768, -14913, -25462, -22128, -6729,
	12339, 24680, 23563, 9599, -9599, -23564, -24680, -12339,
	6729, 22129, 25462, 14912, -3768, -20394, -25901, -17284,
	756, 18384, 25989, 19422, 2265, -16126, -25725, -21297,
	-5257, 13649, 25114, 22885, 8177, -10988, -24163, -24162,
	-10987, 8178, 22885, 25114, 13649, -5257, -21298, -25725,
	-16125, 2266, 19422, 25988, 18384, 755, -17284, -25901,
	-20394, -3767, 14913, 25462, 22128, 6729, -12339, -24680,
	-23563, -9599, 9599, 23564, 24680, 12339, -6729, -22129,
	-25462, -14912, 3768, 20394, 25901, 17284, -756, -18384,
	-25989, -19422, -2265, 16126, 25725, 21297, 5257, -13649,
	-25114, -22885, -8177, 10988, 24163, 24162, 10987, -8178,
	-22885, -25113, -13649, 5258, 21298, 25725, 16125, -2266,
	-19422, -25988, -18384, -755, 17284, 25901, 20394, 3767,
	-14913, -25462, -22128, -6728, 12339, 24680, 23563, 9598,
	-9599, -23564, -24680, -12339, 6729, 22129, 25462, 14912,
	-3768, -20395, -25901, -17284, 756, 18385, 25989, 19422,
	2265, -16126, -25725, -21297, -5257, 13649, 25114, 22885,
	8177, -10988, -24163, -24162, -10987, 8178, 22885, 25113,
	13648, -5258, -21298, -25725, -16125, 2266, 19422, 25988},
	{
// Carrier 20 Phase 7
	9949, -9246, -23401, -24796, -12671, 6363, 21928, 25536,
	15221, -3393, -20158, -25931, -17565, 378, 18115, 25975,
	19671, 2642, -15827, -25667, -21512, -5627, 13326, 25013,
	23062, 8536, -10644, -24020, -24300, -11329, 7818, 22703,
	25209, 13969, -4886, -21078, -25777, -16420, 1889, 19169,
	25997, 18650, 1134, -17000, -25865, -20627, -4141, 14601,
	25383, 22325, 7093, -12005, -24558, -23721, -9949, 9247,
	23401, 24796, 12671, -6363, -21928, -25536, -15221, 3393,
	20158, 25931, 17565, -378, -18115, -25975, -19671, -2642,
	15827, 25667, 21512, 5627, -13326, -25013, -23062, -8536,
	10644, 24020, 24300, 11329, -7818, -22703, -25209, -13969,
	4886, 21078, 25777, 16420, -1889, -19169, -25997, -18650,
	-1133, 17000, 25865, 20627, 4141, -14601, -25383, -22325,
	-7093, 12005, 24558, 23721, 9949, -9247, -23401, -24796,
	-12670, 6363, 21928, 25536, 15220, -3393, -20158, -25931,
	-17565, 378, 18115, 25975, 19671, 2642, -15828, -25668,
	-21512, -5627, 13326, 25013, 23062, 8535, -10644, -24020,
	-24299, -11329, 7818, 22703, 25209, 13969, -4887, -21078,
	-25777, -16420, 1889, 19169, 25997, 18649, 1133, -17000,
	-25865, -20626, -4141, 14601, 25383, 22325, 7093, -12005,
	-24558, -23721, -9949, 9247, 23401, 24796, 12670, -6363,
	-21928, -25536, -15220, 3394, 20158, 25931, 17565, -378,
	-18115, -25975, -19671, -2642, 15828, 25668, 21512, 5627,
	-13326, -25013, -23062, -8535, 10644, 24021, 24299, 11329,
	-7818, -22703, -25209, -13969, 4887, 21079, 25777, 16420,
	-1889, -19169, -25997, -18649, -1133, 17000, 25865, 20626,
	4141, -14602, -25383, -22324, -7093, 12005, 24558, 23721},
	},{{

// Carrier 21 Phase 0
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18385,
	0, 18384, 26000, 18385, 0, -18384, -26000, -18385},
	{
// Carrier 21 Phase 1
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9949,
	9949, 24020, 24020, 9949, -9949, -24020, -24020, -9950,
	9949, 24020, 24020, 9950, -9949, -24020, -24020, -9950,
	9949, 24020, 24020, 9950, -9949, -24020, -24020, -9950,
	9949, 24020, 24020, 9950, -9949, -24020, -24020, -9950,
	9949, 24020, 24020, 9950, -9949, -24020, -24020, -9950,
	9949, 24020, 24020, 9950, -9949, -24020, -24020, -9950,
	9949, 24020, 24020, 9950, -9949, -24020, -24020, -9950},
	{
// Carrier 21 Phase 2
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18385, 0,
	18384, 26000, 18385, 0, -18384, -26000, -18385, 0},
	{
// Carrier 21 Phase 3
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9949, 9949,
	24020, 24020, 9949, -9949, -24020, -24020, -9950, 9949,
	24020, 24020, 9950, -9949, -24020, -24020, -9950, 9949,
	24020, 24020, 9950, -9949, -24020, -24020, -9950, 9949,
	24020, 24020, 9950, -9949, -24020, -24020, -9950, 9949,
	24020, 24020, 9950, -9949, -24020, -24020, -9950, 9949,
	24020, 24020, 9950, -9949, -24020, -24020, -9950, 9949,
	24020, 24020, 9950, -9949, -24020, -24020, -9950, 9949},
	{
// Carrier 21 Phase 4
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18385, 0, 18384,
	26000, 18385, 0, -18384, -26000, -18385, 0, 18384},
	{
// Carrier 21 Phase 5
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9949, 9949, 24020,
	24020, 9949, -9949, -24020, -24020, -9950, 9949, 24020,
	24020, 9950, -9949, -24020, -24020, -9950, 9949, 24020,
	24020, 9950, -9949, -24020, -24020, -9950, 9949, 24020,
	24020, 9950, -9949, -24020, -24020, -9950, 9949, 24020,
	24020, 9950, -9949, -24020, -24020, -9950, 9949, 24020,
	24020, 9950, -9949, -24020, -24020, -9950, 9949, 24020,
	24020, 9950, -9949, -24020, -24020, -9950, 9949, 24020,
	24020, 9950, -9949, -24020, -24020, -9950, 9949, 24020},
	{
// Carrier 21 Phase 6
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18385, 0, 18384, 26000,
	18385, 0, -18384, -26000, -18385, 0, 18384, 26000},
	{
// Carrier 21 Phase 7
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9949, 9949, 24020, 24020,
	9949, -9949, -24020, -24020, -9950, 9949, 24020, 24020,
	9950, -9949, -24020, -24020, -9950, 9949, 24020, 24020,
	9950, -9949, -24020, -24020, -9950, 9949, 24020, 24020,
	9950, -9949, -24020, -24020, -9950, 9949, 24020, 24020,
	9950, -9949, -24020, -24020, -9950, 9949, 24020, 24020,
	9950, -9949, -24020, -24020, -9950, 9949, 24020, 24020,
	9950, -9949, -24020, -24020, -9950, 9949, 24020, 24020},
	},{{

// Carrier 22 Phase 0
	0, 18911, 25956, 16712, -3018, -20855, -25605, -14287,
	5996, 22516, 24907, 11668, -8892, -23873, -23873, -8892,
	11668, 24907, 22516, 5996, -14287, -25605, -20855, -3018,
	16712, 25956, 18911, 0, -18911, -25956, -16712, 3018,
	20855, 25604, 14287, -5996, -22516, -24907, -11668, 8892,
	23873, 23873, 8892, -11668, -24907, -22516, -5996, 14287,
	25605, 20855, 3018, -16712, -25956, -18911, 0, 18911,
	25956, 16712, -3018, -20855, -25604, -14287, 5996, 22516,
	24907, 11668, -8892, -23873, -23873, -8892, 11668, 24907,
	22516, 5995, -14287, -25605, -20855, -3018, 16712, 25956,
	18911, 0, -18911, -25956, -16712, 3018, 20855, 25604,
	14287, -5996, -22516, -24907, -11668, 8892, 23873, 23873,
	8892, -11668, -24907, -22516, -5995, 14287, 25605, 20855,
	3018, -16712, -25956, -18911, 0, 18911, 25956, 16712,
	-3018, -20855, -25604, -14287, 5996, 22516, 24907, 11668,
	-8892, -23873, -23873, -8892, 11668, 24907, 22516, 5995,
	-14287, -25605, -20855, -3018, 16712, 25956, 18911, 0,
	-18911, -25956, -16712, 3018, 20855, 25604, 14287, -5996,
	-22516, -24907, -11668, 8892, 23873, 23873, 8892, -11668,
	-24907, -22516, -5995, 14287, 25605, 20855, 3018, -16712,
	-25956, -18911, 0, 18911, 25956, 16712, -3018, -20855,
	-25604, -14287, 5996, 22516, 24907, 11668, -8892, -23873,
	-23873, -8892, 11668, 24907, 22516, 5995, -14287, -25605,
	-20855, -3018, 16712, 25956, 18911, 0, -18911, -25956,
	-16712, 3018, 20855, 25604, 14287, -5996, -22516, -24907,
	-11668, 8892, 23873, 23873, 8892, -11668, -24907, -22516,
	-5995, 14287, 25605, 20855, 3018, -16712, -25956, -18911},
	{
// Carrier 22 Phase 1
	9949, 24300, 23401, 7818, -12671, -25209, -21928, -4886,
	15221, 25777, 20158, 1889, -17565, -25997, -18115, 1134,
	19671, 25865, 15827, -4141, -21512, -25383, -13326, 7093,
	23062, 24558, 10644, -9949, -24300, -23401, -7818, 12671,
	25209, 21928, 4886, -15221, -25777, -20158, -1889, 17565,
	25997, 18115, -1134, -19671, -25865, -15827, 4142, 21512,
	25383, 13326, -7093, -23062, -24558, -10644, 9949, 24300,
	23401, 7818, -12671, -25209, -21928, -4886, 15221, 25777,
	20158, 1889, -17565, -25997, -18115, 1134, 19672, 25865,
	15827, -4142, -21512, -25383, -13326, 7093, 23062, 24558,
	10644, -9949, -24300, -23401, -7818, 12671, 25209, 21928,
	4886, -15221, -25777, -20158, -1889, 17565, 25997, 18115,
	-1134, -19672, -25865, -15827, 4142, 21512, 25383, 13326,
	-7093, -23062, -24558, -10644, 9949, 24300, 23401, 7818,
	-12671, -25209, -21928, -4886, 15221, 25777, 20158, 1889,
	-17565, -25997, -18115, 1134, 19672, 25865, 15827, -4142,
	-21512, -25383, -13326, 7093, 23062, 24558, 10644, -9949,
	-24300, -23401, -7818, 12671, 25209, 21928, 4886, -15221,
	-25777, -20158, -1889, 17565, 25997, 18115, -1134, -19672,
	-25865, -15827, 4142, 21512, 25383, 13326, -7093, -23062,
	-24558, -10644, 9949, 24300, 23401, 7818, -12671, -25209,
	-21928, -4886, 15221, 25777, 20158, 1889, -17565, -25997,
	-18115, 1134, 19672, 25865, 15827, -4142, -21512, -25383,
	-13326, 7093, 23062, 24558, 10644, -9949, -24300, -23401,
	-7818, 12671, 25209, 21928, 4886, -15221, -25777, -20158,
	-1889, 17565, 25997, 18115, -1134, -19672, -25865, -15827,
	4142, 21512, 25383, 13326, -7093, -23062, -24558, -10644},
	{
// Carrier 22 Phase 2
	18384, 25989, 17284, -2266, -20394, -25725, -14912, 5257,
	22129, 25114, 12339, -8178, -23564, -24163, -9599, 10988,
	24680, 22885, 6729, -13649, -25462, -21297, -3768, 16126,
	25901, 19422, 756, -18384, -25989, -17284, 2266, 20394,
	25725, 14912, -5257, -22129, -25114, -12339, 8178, 23564,
	24163, 9599, -10988, -24680, -22885, -6729, 13649, 25462,
	21297, 3768, -16126, -25901, -19422, -756, 18384, 25989,
	17284, -2266, -20394, -25725, -14912, 5257, 22129, 25114,
	12339, -8178, -23564, -24163, -9599, 10988, 24680, 22885,
	6729, -13649, -25462, -21297, -3768, 16126, 25901, 19422,
	756, -18384, -25988, -17284, 2266, 20394, 25725, 14912,
	-5257, -22129, -25114, -12339, 8178, 23564, 24163, 9599,
	-10988, -24680, -22885, -6729, 13649, 25462, 21297, 3768,
	-16126, -25901, -19422, -756, 18384, 25988, 17284, -2266,
	-20394, -25725, -14912, 5257, 22129, 25114, 12339, -8178,
	-23564, -24163, -9599, 10988, 24680, 22885, 6729, -13649,
	-25462, -21297, -3768, 16126, 25901, 19422, 756, -18384,
	-25988, -17284, 2266, 20394, 25725, 14912, -5257, -22129,
	-25114, -12339, 8178, 23564, 24163, 9599, -10988, -24680,
	-22885, -6729, 13649, 25462, 21297, 3768, -16126, -25901,
	-19422, -756, 18384, 25988, 17284, -2266, -20394, -25725,
	-14912, 5257, 22129, 25114, 12339, -8178, -23564, -24162,
	-9599, 10988, 24680, 22885, 6729, -13649, -25462, -21297,
	-3768, 16126, 25901, 19422, 756, -18384, -25988, -17284,
	2266, 20394, 25725, 14912, -5257, -22129, -25114, -12339,
	8178, 23564, 24162, 9599, -10988, -24680, -22885, -6729,
	13649, 25462, 21297, 3768, -16126, -25901, -19422, -756},
	{
// Carrier 22 Phase 3
	24020, 23721, 8536, -12005, -25013, -22325, -5627, 14601,
	25667, 20627, 2642, -17000, -25975, -18650, 378, 19169,
	25931, 16421, -3393, -21078, -25536, -13969, 6363, 22703,
	24796, 11329, -9246, -24020, -23721, -8536, 12005, 25013,
	22325, 5627, -14601, -25667, -20627, -2642, 17000, 25975,
	18650, -378, -19169, -25931, -16421, 3393, 21078, 25536,
	13969, -6363, -22703, -24796, -11329, 9246, 24020, 23721,
	8536, -12005, -25013, -22325, -5627, 14601, 25667, 20627,
	2642, -17000, -25975, -18650, 378, 19169, 25931, 16421,
	-3393, -21078, -25536, -13969, 6363, 22703, 24796, 11329,
	-9246, -24020, -23721, -8536, 12005, 25013, 22325, 5627,
	-14601, -25667, -20627, -2642, 17000, 25975, 18650, -378,
	-19169, -25931, -16421, 3393, 21078, 25536, 13969, -6363,
	-22703, -24796, -11329, 9246, 24020, 23721, 8536, -12005,
	-25013, -22325, -5627, 14601, 25667, 20627, 2642, -17000,
	-25975, -18650, 378, 19169, 25931, 16420, -3393, -21078,
	-25536, -13969, 6363, 22703, 24796, 11329, -9246, -24020,
	-23721, -8536, 12005, 25013, 22325, 5627, -14601, -25667,
	-20627, -2642, 17000, 25975, 18650, -378, -19169, -25931,
	-16420, 3393, 21078, 25536, 13969, -6363, -22703, -24796,
	-11329, 9246, 24020, 23721, 8536, -12005, -25013, -22325,
	-5627, 14601, 25667, 20627, 2642, -17000, -25975, -18650,
	378, 19169, 25931, 16420, -3393, -21078, -25536, -13969,
	6363, 22703, 24796, 11329, -9246, -24020, -23721, -8536,
	12005, 25013, 22325, 5627, -14601, -25667, -20627, -2642,
	17000, 25975, 18650, -378, -19169, -25931, -16420, 3393,
	21078, 25536, 13969, -6363, -22703, -24796, -11329, 9247},
	{
// Carrier 22 Phase 4
	26000, 17842, -1511, -19917, -25824, -15526, 4514, 21722,
	25299, 13000, -7456, -23234, -24432, -10298, 10298, 24432,
	23234, 7456, -12999, -25299, -21722, -4514, 15526, 25824,
	19917, 1511, -17842, -26000, -17842, 1511, 19917, 25824,
	15526, -4514, -21722, -25299, -13000, 7456, 23234, 24432,
	10298, -10298, -24432, -23234, -7456, 13000, 25299, 21722,
	4514, -15526, -25824, -19917, -1511, 17842, 26000, 17842,
	-1511, -19917, -25824, -15526, 4514, 21722, 25299, 12999,
	-7456, -23234, -24432, -10298, 10298, 24432, 23234, 7456,
	-13000, -25299, -21722, -4514, 15526, 25824, 19917, 1511,
	-17842, -26000, -17842, 1511, 19917, 25824, 15526, -4514,
	-21722, -25299, -12999, 7456, 23234, 24431, 10298, -10298,
	-24432, -23234, -7456, 13000, 25299, 21722, 4514, -15526,
	-25824, -19917, -1511, 17842, 26000, 17842, -1511, -19917,
	-25824, -15526, 4514, 21722, 25299, 12999, -7456, -23234,
	-24431, -10298, 10298, 24432, 23234, 7456, -13000, -25299,
	-21722, -4514, 15526, 25824, 19917, 1511, -17842, -26000,
	-17842, 1511, 19917, 25824, 15526, -4514, -21722, -25299,
	-12999, 7456, 23234, 24431, 10298, -10298, -24432, -23234,
	-7456, 13000, 25299, 21722, 4514, -15526, -25824, -19917,
	-1511, 17842, 26000, 17842, -1511, -19917, -25824, -15526,
	4514, 21722, 25299, 12999, -7456, -23234, -24431, -10298,
	10298, 24432, 23234, 7456, -13000, -25299, -21722, -4514,
	15526, 25824, 19917, 1511, -17842, -26000, -17842, 1511,
	19917, 25824, 15526, -4514, -21722, -25299, -12999, 7456,
	23234, 24431, 10298, -10298, -24432, -23234, -7456, 13000,
	25299, 21722, 4514, -15526, -25824, -19917, -1511, 17842},
	{
// Carrier 22 Phase 5
	24020, 9246, -11329, -24796, -22703, -6363, 13969, 25536,
	21078, 3393, -16421, -25931, -19169, -378, 18650, 25975,
	17000, -2642, -20627, -25667, -14601, 5627, 22325, 25013,
	12005, -8536, -23721, -24020, -9246, 11329, 24796, 22703,
	6363, -13969, -25536, -21078, -3393, 16421, 25931, 19169,
	378, -18650, -25975, -17000, 2642, 20627, 25667, 14601,
	-5627, -22325, -25013, -12005, 8536, 23721, 24020, 9246,
	-11329, -24796, -22703, -6363, 13969, 25536, 21078, 3393,
	-16421, -25931, -19169, -378, 18650, 25975, 17000, -2642,
	-20627, -25667, -14601, 5627, 22325, 25013, 12005, -8536,
	-23721, -24020, -9246, 11329, 24796, 22703, 6363, -13969,
	-25536, -21078, -3393, 16421, 25931, 19169, 378, -18650,
	-25975, -17000, 2642, 20627, 25667, 14601, -5627, -22325,
	-25013, -12005, 8536, 23721, 24020, 9246, -11329, -24796,
	-22703, -6363, 13969, 25536, 21078, 3393, -16421, -25931,
	-19169, -378, 18650, 25975, 17000, -2642, -20627, -25667,
	-14601, 5627, 22325, 25013, 12005, -8536, -23721, -24020,
	-9246, 11329, 24796, 22703, 6363, -13969, -25536, -21078,
	-3393, 16421, 25931, 19169, 378, -18650, -25975, -17000,
	2642, 20627, 25667, 14601, -5627, -22325, -25013, -12005,
	8536, 23721, 24020, 9246, -11329, -24796, -22703, -6363,
	13969, 25536, 21078, 3393, -16421, -25931, -19169, -378,
	18650, 25975, 17000, -2642, -20627, -25667, -14601, 5627,
	22325, 25013, 12005, -8536, -23721, -24020, -9246, 11329,
	24796, 22703, 6363, -13969, -25536, -21078, -3393, 16421,
	25931, 19169, 377, -18650, -25975, -17000, 2642, 20627,
	25667, 14601, -5627, -22325, -25013, -12005, 8536, 23721},
	{
// Carrier 22 Phase 6
	18384, -756, -19422, -25901, -16126, 3768, 21297, 25462,
	13649, -6729, -22885, -24680, -10988, 9599, 24163, 23564,
	8178, -12339, -25114, -22129, -5257, 14912, 25725, 20394,
	2266, -17284, -25989, -18384, 756, 19422, 25901, 16126,
	-3768, -21297, -25462, -13649, 6729, 22885, 24680, 10988,
	-9599, -24163, -23563, -8178, 12339, 25114, 22129, 5257,
	-14913, -25725, -20394, -2266, 17284, 25989, 18384, -756,
	-19422, -25901, -16126, 3768, 21297, 25462, 13649, -6729,
	-22885, -24680, -10988, 9599, 24163, 23563, 8178, -12339,
	-25114, -22129, -5257, 14913, 25725, 20394, 2266, -17284,
	-25989, -18384, 756, 19422, 25901, 16126, -3768, -21297,
	-25462, -13649, 6729, 22885, 24680, 10988, -9599, -24163,
	-23563, -8178, 12339, 25114, 22129, 5257, -14913, -25725,
	-20394, -2266, 17284, 25989, 18384, -756, -19422, -25901,
	-16126, 3768, 21297, 25462, 13649, -6729, -22885, -24680,
	-10988, 9599, 24163, 23563, 8178, -12339, -25114, -22129,
	-5257, 14913, 25725, 20394, 2265, -17284, -25989, -18384,
	756, 19422, 25901, 16126, -3768, -21297, -25462, -13649,
	6729, 22885, 24680, 10988, -9599, -24163, -23563, -8178,
	12339, 25114, 22128, 5257, -14913, -25725, -20394, -2265,
	17284, 25989, 18384, -756, -19422, -25901, -16126, 3768,
	21297, 25462, 13649, -6729, -22885, -24680, -10988, 9599,
	24163, 23563, 8178, -12339, -25114, -22128, -5257, 14913,
	25725, 20394, 2265, -17284, -25989, -18384, 756, 19422,
	25901, 16126, -3768, -21297, -25462, -13649, 6729, 22885,
	24680, 10987, -9599, -24163, -23563, -8178, 12339, 25114,
	22128, 5257, -14913, -25725, -20394, -2265, 17284, 25989},
	{
// Carrier 22 Phase 7
	9949, -10644, -24558, -23062, -7093, 13326, 25383, 21512,
	4141, -15827, -25865, -19671, -1134, 18115, 25997, 17565,
	-1889, -20158, -25777, -15221, 4886, 21928, 25209, 12671,
	-7818, -23401, -24300, -9949, 10644, 24558, 23062, 7093,
	-13326, -25383, -21512, -4141, 15827, 25865, 19671, 1134,
	-18115, -25997, -17565, 1889, 20158, 25777, 15221, -4886,
	-21928, -25209, -12671, 7818, 23401, 24300, 9949, -10644,
	-24558, -23062, -7093, 13326, 25383, 21512, 4141, -15827,
	-25865, -19671, -1134, 18115, 25997, 17565, -1889, -20158,
	-25777, -15221, 4886, 21928, 25209, 12671, -7818, -23401,
	-24300, -9949, 10644, 24558, 23062, 7093, -13326, -25383,
	-21512, -4141, 15827, 25865, 19671, 1134, -18115, -25997,
	-17565, 1889, 20158, 25777, 15221, -4886, -21928, -25209,
	-12671, 7818, 23401, 24300, 9949, -10644, -24558, -23062,
	-7093, 13326, 25383, 21512, 4141, -15827, -25865, -19671,
	-1134, 18115, 25997, 17565, -1889, -20158, -25777, -15221,
	4886, 21928, 25209, 12671, -7818, -23401, -24300, -9949,
	10644, 24558, 23062, 7093, -13326, -25383, -21512, -4141,
	15827, 25865, 19671, 1134, -18115, -25997, -17565, 1889,
	20158, 25777, 15221, -4886, -21928, -25209, -12671, 7818,
	23401, 24300, 9949, -10644, -24558, -23062, -7093, 13326,
	25383, 21512, 4141, -15827, -25865, -19671, -1133, 18115,
	25997, 17565, -1889, -20158, -25777, -15221, 4886, 21928,
	25209, 12671, -7818, -23401, -24300, -9949, 10644, 24558,
	23062, 7093, -13326, -25383, -21512, -4141, 15827, 25865,
	19671, 1133, -18115, -25997, -17565, 1889, 20158, 25777,
	15221, -4886, -21928, -25209, -12671, 7818, 23401, 24300},
	},{{

// Carrier 23 Phase 0
	0, 19422, 25824, 14912, -5996, -22885, -24432, -9599,
	11668, 25114, 21722, 3768, -16712, -25989, -17842, 2266,
	20855, 25462, 12999, -8178, -23873, -23563, -7456, 13649,
	25605, 20394, 1511, -18384, -25956, -16126, 4514, 22129,
	24907, 10988, -10298, -24680, -22516, -5257, 15526, 25901,
	18911, -756, -19917, -25725, -14287, 6729, 23234, 24163,
	8892, -12339, -25299, -21297, -3018, 17284, 26000, 17284,
	-3018, -21297, -25299, -12339, 8892, 24163, 23234, 6729,
	-14287, -25725, -19917, -756, 18911, 25901, 15526, -5257,
	-22516, -24680, -10297, 10988, 24907, 22128, 4514, -16126,
	-25956, -18384, 1511, 20394, 25604, 13649, -7457, -23564,
	-23873, -8178, 13000, 25462, 20855, 2265, -17842, -25988,
	-16712, 3768, 21722, 25114, 11668, -9599, -24432, -22885,
	-5995, 14913, 25824, 19422, 0, -19422, -25824, -14912,
	5996, 22885, 24431, 9599, -11668, -25114, -21722, -3768,
	16712, 25989, 17842, -2266, -20855, -25462, -12999, 8178,
	23873, 23563, 7456, -13649, -25605, -20394, -1511, 18384,
	25955, 16125, -4515, -22129, -24907, -10987, 10298, 24680,
	22516, 5257, -15526, -25901, -18911, 756, 19917, 25725,
	14287, -6729, -23234, -24162, -8892, 12339, 25299, 21297,
	3018, -17284, -26000, -17284, 3018, 21298, 25299, 12339,
	-8892, -24163, -23234, -6729, 14287, 25725, 19916, 755,
	-18911, -25901, -15525, 5257, 22516, 24680, 10297, -10988,
	-24907, -22128, -4514, 16126, 25956, 18384, -1512, -20394,
	-25604, -13649, 7457, 23564, 23873, 8177, -13000, -25462,
	-20855, -2265, 17842, 25988, 16712, -3768, -21722, -25113,
	-11668, 9599, 24432, 22885, 5995, -14913, -25824, -19422},
	{
// Carrier 23 Phase 1
	9949, 24558, 22703, 5627, -15221, -25865, -19169, 378,
	19671, 25777, 14601, -6363, -23062, -24300, -9246, 12005,
	25209, 21512, 3393, -17000, -25997, -17565, 2642, 21078,
	25383, 12671, -8536, -24020, -23401, -7093, 13969, 25667,
	20158, 1134, -18650, -25931, -15827, 4886, 22325, 24796,
	10644, -10644, -24796, -22325, -4886, 15827, 25931, 18650,
	-1134, -20158, -25667, -13969, 7093, 23401, 24020, 8536,
	-12671, -25383, -21078, -2642, 17565, 25997, 17000, -3393,
	-21512, -25209, -12005, 9247, 24300, 23062, 6363, -14601,
	-25777, -19671, -378, 19169, 25865, 15221, -5627, -22703,
	-24558, -9949, 11329, 25013, 21928, 4141, -16421, -25975,
	-18115, 1889, 20627, 25536, 13325, -7818, -23721, -23721,
	-7818, 13326, 25536, 20627, 1888, -18115, -25975, -16420,
	4142, 21928, 25013, 11329, -9949, -24558, -22703, -5627,
	15221, 25865, 19169, -378, -19672, -25777, -14601, 6363,
	23062, 24300, 9246, -12005, -25209, -21512, -3393, 17000,
	25997, 17565, -2642, -21078, -25383, -12670, 8536, 24020,
	23401, 7093, -13969, -25667, -20157, -1133, 18650, 25931,
	15827, -4886, -22325, -24796, -10643, 10644, 24796, 22325,
	4886, -15827, -25931, -18650, 1134, 20158, 25667, 13969,
	-7094, -23401, -24020, -8536, 12671, 25383, 21078, 2642,
	-17565, -25997, -17000, 3393, 21512, 25209, 12005, -9247,
	-24300, -23062, -6363, 14601, 25777, 19671, 377, -19169,
	-25865, -15220, 5627, 22703, 24558, 9949, -11329, -25013,
	-21928, -4141, 16421, 25975, 18115, -1889, -20627, -25536,
	-13325, 7818, 23721, 23721, 7818, -13326, -25536, -20626,
	-1888, 18115, 25975, 16420, -4142, -21928, -25013, -11329},
	{
// Carrier 23 Phase 2
	18384, 25956, 16126, -4514, -22129, -24907, -10988, 10298,
	24680, 22516, 5257, -15526, -25901, -18911, 756, 19917,
	25725, 14287, -6729, -23234, -24163, -8892, 12339, 25299,
	21297, 3018, -17284, -26000, -17284, 3018, 21297, 25299,
	12339, -8892, -24163, -23234, -6729, 14287, 25725, 19917,
	756, -18911, -25901, -15526, 5257, 22516, 24680, 10298,
	-10988, -24907, -22128, -4514, 16126, 25956, 18384, -1511,
	-20394, -25604, -13649, 7456, 23564, 23873, 8178, -13000,
	-25462, -20855, -2265, 17842, 25988, 16712, -3768, -21722,
	-25114, -11668, 9599, 24432, 22885, 5995, -14913, -25824,
	-19422, 0, 19422, 25824, 14912, -5996, -22885, -24431,
	-9599, 11668, 25114, 21722, 3768, -16712, -25989, -17842,
	2266, 20855, 25462, 12999, -8178, -23873, -23563, -7456,
	13649, 25605, 20394, 1511, -18384, -25956, -16125, 4515,
	22129, 24907, 10987, -10298, -24680, -22516, -5257, 15526,
	25901, 18911, -756, -19917, -25725, -14287, 6729, 23234,
	24162, 8892, -12339, -25299, -21297, -3018, 17284, 26000,
	17284, -3018, -21298, -25299, -12339, 8892, 24163, 23234,
	6729, -14287, -25725, -19917, -755, 18911, 25901, 15525,
	-5257, -22516, -24680, -10297, 10988, 24907, 22128, 4514,
	-16126, -25956, -18384, 1512, 20394, 25604, 13649, -7457,
	-23564, -23873, -8177, 13000, 25462, 20855, 2265, -17842,
	-25988, -16712, 3768, 21722, 25113, 11668, -9599, -24432,
	-22885, -5995, 14913, 25824, 19422, 0, -19422, -25824,
	-14912, 5996, 22885, 24431, 9599, -11669, -25114, -21722,
	-3767, 16712, 25989, 17842, -2266, -20855, -25462, -12999,
	8178, 23873, 23563, 7456, -13649, -25605, -20394, -1511},
	{
// Carrier 23 Phase 3
	24020, 23401, 7093, -13969, -25667, -20158, -1134, 18650,
	25931, 15827, -4886, -22325, -24796, -10644, 10644, 24796,
	22325, 4886, -15827, -25931, -18650, 1134, 20158, 25667,
	13969, -7093, -23401, -24020, -8536, 12671, 25383, 21078,
	2642, -17565, -25997, -17000, 3393, 21512, 25209, 12005,
	-9246, -24300, -23062, -6363, 14601, 25777, 19671, 378,
	-19169, -25865, -15221, 5627, 22703, 24558, 9949, -11329,
	-25013, -21928, -4141, 16421, 25975, 18115, -1889, -20627,
	-25536, -13326, 7818, 23721, 23721, 7818, -13326, -25536,
	-20627, -1889, 18115, 25975, 16420, -4142, -21928, -25013,
	-11329, 9949, 24558, 22703, 5627, -15221, -25865, -19169,
	378, 19672, 25777, 14601, -6363, -23062, -24300, -9246,
	12005, 25209, 21512, 3393, -17000, -25997, -17565, 2642,
	21078, 25383, 12671, -8536, -24020, -23401, -7093, 13969,
	25667, 20158, 1133, -18650, -25931, -15827, 4886, 22325,
	24796, 10644, -10644, -24796, -22325, -4886, 15827, 25931,
	18650, -1134, -20158, -25667, -13969, 7094, 23401, 24020,
	8536, -12671, -25383, -21078, -2642, 17565, 25997, 17000,
	-3393, -21512, -25209, -12005, 9247, 24300, 23062, 6363,
	-14601, -25777, -19671, -377, 19169, 25865, 15220, -5627,
	-22703, -24558, -9949, 11329, 25013, 21928, 4141, -16421,
	-25975, -18115, 1889, 20627, 25536, 13325, -7818, -23721,
	-23721, -7818, 13326, 25536, 20627, 1888, -18115, -25975,
	-16420, 4142, 21928, 25013, 11329, -9950, -24558, -22703,
	-5627, 15221, 25865, 19169, -378, -19672, -25777, -14601,
	6363, 23062, 24299, 9246, -12005, -25209, -21512, -3393,
	17000, 25997, 17565, -2642, -21078, -25383, -12670, 8536},
	{
// Carrier 23 Phase 4
	26000, 17284, -3018, -21297, -25299, -12339, 8892, 24163,
	23234, 6729, -14287, -25725, -19917, -756, 18911, 25901,
	15526, -5257, -22516, -24680, -10298, 10988, 24907, 22129,
	4514, -16126, -25956, -18384, 1511, 20394, 25604, 13649,
	-7456, -23564, -23873, -8178, 13000, 25462, 20855, 2265,
	-17842, -25988, -16712, 3768, 21722, 25114, 11668, -9599,
	-24432, -22885, -5995, 14913, 25824, 19422, 0, -19422,
	-25824, -14912, 5996, 22885, 24431, 9599, -11668, -25114,
	-21722, -3768, 16712, 25989, 17842, -2266, -20855, -25462,
	-12999, 8178, 23873, 23563, 7456, -13649, -25605, -20394,
	-1511, 18384, 25956, 16126, -4514, -22129, -24907, -10987,
	10298, 24680, 22516, 5257, -15526, -25901, -18911, 756,
	19917, 25725, 14287, -6729, -23234, -24162, -8892, 12339,
	25299, 21297, 3018, -17284, -26000, -17284, 3018, 21298,
	25299, 12339, -8892, -24163, -23234, -6729, 14287, 25725,
	19917, 756, -18911, -25901, -15525, 5257, 22516, 24680,
	10297, -10988, -24907, -22128, -4514, 16126, 25956, 18384,
	-1511, -20394, -25604, -13649, 7457, 23564, 23873, 8177,
	-13000, -25462, -20855, -2265, 17842, 25988, 16712, -3768,
	-21722, -25114, -11668, 9599, 24432, 22885, 5995, -14913,
	-25824, -19422, 0, 19422, 25824, 14912, -5996, -22885,
	-24431, -9599, 11669, 25114, 21722, 3767, -16712, -25989,
	-17842, 2266, 20855, 25462, 12999, -8178, -23873, -23563,
	-7456, 13649, 25605, 20394, 1511, -18384, -25955, -16125,
	4515, 22129, 24907, 10987, -10298, -24680, -22516, -5257,
	15526, 25901, 18911, -756, -19917, -25725, -14286, 6729,
	23234, 24162, 8892, -12339, -25299, -21297, -3018, 17284},
	{
// Carrier 23 Phase 5
	24020, 8536, -12671, -25383, -21078, -2642, 17565, 25997,
	17000, -3393, -21512, -25209, -12005, 9246, 24300, 23062,
	6363, -14601, -25777, -19671, -378, 19169, 25865, 15221,
	-5627, -22703, -24558, -9949, 11329, 25013, 21928, 4141,
	-16421, -25975, -18115, 1889, 20627, 25536, 13326, -7818,
	-23721, -23721, -7818, 13326, 25536, 20627, 1889, -18115,
	-25975, -16420, 4142, 21928, 25013, 11329, -9949, -24558,
	-22703, -5627, 15221, 25865, 19169, -378, -19672, -25777,
	-14601, 6363, 23062, 24300, 9246, -12005, -25209, -21512,
	-3393, 17000, 25997, 17565, -2642, -21078, -25383, -12671,
	8536, 24020, 23401, 7093, -13969, -25667, -20158, -1133,
	18650, 25931, 15827, -4886, -22325, -24796, -10644, 10644,
	24796, 22325, 4886, -15827, -25931, -18650, 1134, 20158,
	25667, 13969, -7093, -23401, -24020, -8536, 12671, 25383,
	21078, 2642, -17565, -25997, -17000, 3393, 21512, 25209,
	12005, -9247, -24300, -23062, -6363, 14601, 25777, 19671,
	377, -19169, -25865, -15220, 5627, 22703, 24558, 9949,
	-11329, -25013, -21928, -4141, 16421, 25975, 18115, -1889,
	-20627, -25536, -13325, 7818, 23721, 23721, 7818, -13326,
	-25536, -20627, -1888, 18115, 25975, 16420, -4142, -21928,
	-25013, -11329, 9950, 24558, 22703, 5627, -15221, -25865,
	-19169, 378, 19672, 25777, 14601, -6363, -23062, -24299,
	-9246, 12005, 25209, 21512, 3393, -17000, -25997, -17565,
	2642, 21078, 25383, 12670, -8536, -24020, -23401, -7093,
	13970, 25668, 20157, 1133, -18650, -25931, -15827, 4887,
	22325, 24796, 10643, -10644, -24796, -22325, -4886, 15828,
	25931, 18649, -1134, -20158, -25667, -13969, 7094, 23401},
	{
// Carrier 23 Phase 6
	18384, -1511, -20394, -25605, -13649, 7456, 23564, 23873,
	8178, -13000, -25462, -20855, -2266, 17842, 25989, 16712,
	-3768, -21722, -25114, -11668, 9599, 24432, 22885, 5995,
	-14913, -25824, -19422, 0, 19422, 25824, 14912, -5996,
	-22885, -24431, -9599, 11668, 25114, 21722, 3768, -16712,
	-25989, -17842, 2266, 20855, 25462, 12999, -8178, -23873,
	-23563, -7456, 13649, 25605, 20394, 1511, -18384, -25956,
	-16126, 4514, 22129, 24907, 10987, -10298, -24680, -22516,
	-5257, 15526, 25901, 18911, -756, -19917, -25725, -14287,
	6729, 23234, 24162, 8892, -12339, -25299, -21297, -3018,
	17284, 26000, 17284, -3018, -21298, -25299, -12339, 8892,
	24163, 23234, 6729, -14287, -25725, -19917, -756, 18911,
	25901, 15525, -5257, -22516, -24680, -10297, 10988, 24907,
	22128, 4514, -16126, -25956, -18384, 1511, 20394, 25604,
	13649, -7457, -23564, -23873, -8177, 13000, 25462, 20855,
	2265, -17842, -25988, -16712, 3768, 21722, 25114, 11668,
	-9599, -24432, -22885, -5995, 14913, 25824, 19422, 0,
	-19422, -25824, -14912, 5996, 22885, 24431, 9599, -11668,
	-25114, -21722, -3767, 16712, 25989, 17842, -2266, -20855,
	-25462, -12999, 8178, 23873, 23563, 7456, -13649, -25605,
	-20394, -1511, 18384, 25955, 16125, -4515, -22129, -24907,
	-10987, 10298, 24680, 22516, 5257, -15526, -25901, -18911,
	756, 19917, 25725, 14286, -6729, -23234, -24162, -8892,
	12339, 25299, 21297, 3018, -17284, -26000, -17284, 3018,
	21298, 25299, 12339, -8892, -24163, -23234, -6728, 14287,
	25725, 19916, 755, -18911, -25901, -15525, 5257, 22516,
	24680, 10297, -10988, -24907, -22128, -4514, 16126, 25956},
	{
// Carrier 23 Phase 7
	9949, -11329, -25013, -21928, -4141, 16421, 25975, 18115,
	-1889, -20627, -25536, -13326, 7818, 23721, 23721, 7818,
	-13326, -25536, -20627, -1889, 18115, 25975, 16421, -4142,
	-21928, -25013, -11329, 9949, 24558, 22703, 5627, -15221,
	-25865, -19169, 378, 19672, 25777, 14601, -6363, -23062,
	-24300, -9246, 12005, 25209, 21512, 3393, -17000, -25997,
	-17565, 2642, 21078, 25383, 12671, -8536, -24020, -23401,
	-7093, 13969, 25667, 20158, 1134, -18650, -25931, -15827,
	4886, 22325, 24796, 10644, -10644, -24796, -22325, -4886,
	15827, 25931, 18650, -1134, -20158, -25667, -13969, 7093,
	23401, 24020, 8536, -12671, -25383, -21078, -2642, 17565,
	25997, 17000, -3393, -21512, -25209, -12005, 9247, 24300,
	23062, 6363, -14601, -25777, -19671, -377, 19169, 25865,
	15221, -5627, -22703, -24558, -9949, 11329, 25013, 21928,
	4141, -16421, -25975, -18115, 1889, 20627, 25536, 13325,
	-7818, -23721, -23721, -7818, 13326, 25536, 20627, 1888,
	-18115, -25975, -16420, 4142, 21928, 25013, 11329, -9949,
	-24558, -22703, -5627, 15221, 25865, 19169, -378, -19672,
	-25777, -14601, 6363, 23062, 24300, 9246, -12005, -25209,
	-21512, -3393, 17000, 25997, 17565, -2642, -21078, -25383,
	-12670, 8536, 24020, 23401, 7093, -13970, -25667, -20157,
	-1133, 18650, 25931, 15827, -4887, -22325, -24796, -10643,
	10644, 24796, 22325, 4886, -15828, -25931, -18650, 1134,
	20158, 25667, 13969, -7094, -23401, -24020, -8535, 12671,
	25383, 21078, 2642, -17565, -25997, -17000, 3394, 21512,
	25209, 12005, -9247, -24300, -23062, -6363, 14601, 25777,
	19671, 377, -19169, -25865, -15220, 5627, 22703, 24558},
	},{{

// Carrier 24 Phase 0
	0, 19917, 25605, 13000, -8892, -24432, -22516, -4514,
	16712, 26000, 16712, -4514, -22516, -24432, -8892, 12999,
	25604, 19917, 0, -19917, -25605, -13000, 8892, 24431,
	22516, 4514, -16712, -26000, -16712, 4514, 22516, 24432,
	8892, -12999, -25604, -19917, 0, 19917, 25605, 13000,
	-8892, -24431, -22516, -4514, 16712, 26000, 16712, -4514,
	-22516, -24432, -8892, 12999, 25604, 19917, 0, -19917,
	-25605, -13000, 8892, 24431, 22516, 4514, -16712, -26000,
	-16712, 4514, 22516, 24432, 8892, -12999, -25604, -19917,
	0, 19917, 25605, 13000, -8892, -24431, -22516, -4514,
	16712, 26000, 16712, -4514, -22516, -24432, -8892, 12999,
	25604, 19917, 0, -19917, -25605, -13000, 8892, 24431,
	22516, 4515, -16712, -26000, -16712, 4514, 22516, 24432,
	8892, -12999, -25604, -19917, 0, 19917, 25605, 13000,
	-8892, -24431, -22516, -4515, 16712, 26000, 16712, -4514,
	-22516, -24432, -8892, 12999, 25604, 19917, 0, -19917,
	-25605, -13000, 8892, 24431, 22516, 4515, -16712, -26000,
	-16712, 4514, 22516, 24432, 8892, -12999, -25604, -19917,
	0, 19916, 25605, 13000, -8892, -24431, -22516, -4515,
	16712, 26000, 16712, -4514, -22516, -24432, -8892, 12999,
	25604, 19917, 0, -19916, -25605, -13000, 8892, 24431,
	22516, 4515, -16712, -26000, -16712, 4514, 22516, 24432,
	8892, -12999, -25604, -19917, 0, 19916, 25605, 13000,
	-8892, -24431, -22516, -4515, 16712, 26000, 16712, -4514,
	-22516, -24432, -8892, 12999, 25604, 19917, 0, -19916,
	-25605, -13000, 8892, 24431, 22516, 4515, -16712, -26000,
	-16712, 4514, 22516, 24432, 8892, -12999, -25604, -19917},
	{
// Carrier 24 Phase 1
	9949, 24796, 21928, 3393, -17565, -25975, -15827, 5627,
	23062, 24020, 7818, -13969, -25777, -19169, 1134, 20627,
	25383, 12005, -9949, -24796, -21928, -3393, 17565, 25975,
	15827, -5627, -23062, -24020, -7818, 13969, 25777, 19169,
	-1134, -20627, -25383, -12005, 9949, 24796, 21928, 3393,
	-17565, -25975, -15827, 5627, 23062, 24020, 7818, -13969,
	-25777, -19169, 1134, 20627, 25383, 12005, -9949, -24796,
	-21928, -3393, 17565, 25975, 15827, -5627, -23062, -24020,
	-7818, 13969, 25777, 19169, -1133, -20627, -25383, -12005,
	9949, 24796, 21928, 3393, -17565, -25975, -15827, 5627,
	23062, 24020, 7818, -13969, -25777, -19169, 1133, 20627,
	25383, 12005, -9949, -24796, -21928, -3393, 17565, 25975,
	15827, -5627, -23062, -24020, -7818, 13969, 25777, 19169,
	-1133, -20627, -25383, -12005, 9949, 24796, 21928, 3393,
	-17565, -25975, -15827, 5627, 23062, 24020, 7818, -13969,
	-25777, -19169, 1133, 20627, 25383, 12005, -9949, -24796,
	-21928, -3393, 17565, 25975, 15827, -5627, -23062, -24020,
	-7818, 13969, 25777, 19169, -1133, -20627, -25383, -12005,
	9949, 24796, 21928, 3393, -17565, -25975, -15828, 5627,
	23062, 24020, 7818, -13969, -25777, -19169, 1133, 20627,
	25383, 12005, -9949, -24796, -21928, -3393, 17565, 25975,
	15828, -5627, -23062, -24020, -7818, 13969, 25777, 19169,
	-1133, -20626, -25383, -12005, 9949, 24796, 21928, 3393,
	-17565, -25975, -15828, 5627, 23062, 24020, 7818, -13969,
	-25777, -19169, 1133, 20626, 25383, 12005, -9949, -24796,
	-21928, -3394, 17565, 25975, 15828, -5627, -23062, -24021,
	-7818, 13969, 25777, 19169, -1133, -20626, -25383, -12005},
	{
// Carrier 24 Phase 2
	18384, 25901, 14912, -6729, -23563, -23564, -6729, 14912,
	25901, 18384, -2266, -21297, -25114, -10988, 10988, 25114,
	21297, 2266, -18384, -25901, -14913, 6729, 23563, 23564,
	6729, -14912, -25901, -18384, 2265, 21297, 25114, 10988,
	-10988, -25114, -21297, -2266, 18384, 25901, 14913, -6729,
	-23563, -23564, -6729, 14912, 25901, 18384, -2265, -21297,
	-25114, -10988, 10987, 25114, 21298, 2266, -18384, -25901,
	-14913, 6729, 23563, 23564, 6729, -14912, -25901, -18384,
	2265, 21297, 25114, 10988, -10987, -25114, -21298, -2266,
	18384, 25901, 14913, -6729, -23563, -23564, -6729, 14912,
	25901, 18384, -2265, -21297, -25114, -10988, 10987, 25114,
	21298, 2266, -18384, -25901, -14913, 6729, 23563, 23564,
	6729, -14912, -25901, -18384, 2265, 21297, 25114, 10988,
	-10987, -25114, -21298, -2266, 18384, 25901, 14913, -6729,
	-23563, -23564, -6729, 14912, 25901, 18384, -2265, -21297,
	-25114, -10988, 10987, 25114, 21298, 2266, -18384, -25901,
	-14913, 6729, 23563, 23564, 6729, -14912, -25901, -18384,
	2265, 21297, 25114, 10988, -10987, -25114, -21298, -2266,
	18384, 25901, 14913, -6729, -23563, -23564, -6729, 14912,
	25901, 18384, -2265, -21297, -25114, -10988, 10987, 25113,
	21298, 2266, -18384, -25901, -14913, 6729, 23563, 23564,
	6729, -14912, -25901, -18384, 2265, 21297, 25114, 10988,
	-10987, -25113, -21298, -2266, 18384, 25901, 14913, -6728,
	-23563, -23564, -6729, 14912, 25901, 18385, -2265, -21297,
	-25114, -10988, 10987, 25113, 21298, 2266, -18384, -25901,
	-14913, 6728, 23563, 23564, 6729, -14912, -25901, -18385,
	2265, 21297, 25114, 10988, -10987, -25113, -21298, -2266},
	{
// Carrier 24 Phase 3
	24020, 23062, 5627, -15827, -25975, -17565, 3393, 21928,
	24796, 9949, -12005, -25383, -20627, -1134, 19169, 25777,
	13969, -7818, -24020, -23062, -5627, 15827, 25975, 17565,
	-3393, -21928, -24796, -9949, 12005, 25383, 20627, 1134,
	-19169, -25777, -13969, 7818, 24020, 23062, 5627, -15827,
	-25975, -17565, 3393, 21928, 24796, 9949, -12005, -25383,
	-20627, -1134, 19169, 25777, 13969, -7818, -24020, -23062,
	-5627, 15827, 25975, 17565, -3393, -21928, -24796, -9949,
	12005, 25383, 20627, 1134, -19169, -25777, -13969, 7818,
	24020, 23062, 5627, -15827, -25975, -17565, 3393, 21928,
	24796, 9949, -12005, -25383, -20627, -1134, 19169, 25777,
	13969, -7818, -24020, -23062, -5627, 15827, 25975, 17565,
	-3393, -21928, -24796, -9949, 12005, 25383, 20627, 1134,
	-19169, -25777, -13969, 7818, 24020, 23062, 5627, -15827,
	-25975, -17565, 3393, 21928, 24796, 9949, -12005, -25383,
	-20627, -1134, 19169, 25777, 13969, -7818, -24020, -23062,
	-5627, 15827, 25975, 17565, -3393, -21928, -24796, -9949,
	12005, 25383, 20627, 1134, -19169, -25777, -13970, 7818,
	24020, 23062, 5627, -15827, -25975, -17565, 3393, 21928,
	24796, 9950, -12005, -25383, -20627, -1134, 19169, 25777,
	13970, -7818, -24020, -23062, -5627, 15827, 25975, 17565,
	-3393, -21928, -24796, -9950, 12005, 25383, 20627, 1134,
	-19168, -25777, -13970, 7818, 24020, 23062, 5627, -15827,
	-25975, -17565, 3393, 21928, 24796, 9950, -12005, -25383,
	-20627, -1134, 19168, 25777, 13970, -7818, -24020, -23062,
	-5627, 15827, 25975, 17565, -3393, -21927, -24796, -9950,
	12005, 25383, 20627, 1134, -19168, -25777, -13970, 7817},
	{
// Carrier 24 Phase 4
	26000, 16712, -4514, -22516, -24432, -8892, 12999, 25604,
	19917, 0, -19917, -25605, -13000, 8892, 24431, 22516,
	4514, -16712, -26000, -16712, 4514, 22516, 24432, 8892,
	-12999, -25604, -19917, 0, 19917, 25605, 13000, -8892,
	-24431, -22516, -4514, 16712, 26000, 16712, -4514, -22516,
	-24432, -8892, 12999, 25604, 19917, 0, -19917, -25605,
	-13000, 8892, 24431, 22516, 4514, -16712, -26000, -16712,
	4514, 22516, 24432, 8892, -12999, -25604, -19917, 0,
	19917, 25605, 13000, -8892, -24431, -22516, -4514, 16712,
	26000, 16712, -4514, -22516, -24432, -8892, 12999, 25604,
	19917, 0, -19917, -25605, -13000, 8892, 24431, 22516,
	4515, -16712, -26000, -16712, 4514, 22516, 24432, 8892,
	-12999, -25604, -19917, 0, 19917, 25605, 13000, -8892,
	-24431, -22516, -4515, 16712, 26000, 16712, -4514, -22516,
	-24432, -8892, 12999, 25604, 19917, 0, -19917, -25605,
	-13000, 8892, 24431, 22516, 4515, -16712, -26000, -16712,
	4514, 22516, 24432, 8892, -12999, -25604, -19917, 0,
	19917, 25605, 13000, -8892, -24431, -22516, -4515, 16712,
	26000, 16712, -4514, -22516, -24432, -8892, 12999, 25604,
	19917, 0, -19916, -25605, -13000, 8892, 24431, 22516,
	4515, -16712, -26000, -16712, 4514, 22516, 24432, 8892,
	-12999, -25604, -19917, 0, 19916, 25605, 13000, -8892,
	-24431, -22516, -4515, 16712, 26000, 16712, -4514, -22516,
	-24432, -8892, 12999, 25604, 19917, 0, -19916, -25605,
	-13000, 8892, 24431, 22516, 4515, -16712, -26000, -16712,
	4514, 22516, 24432, 8892, -12999, -25604, -19917, 0,
	19916, 25605, 13000, -8892, -24431, -22516, -4515, 16712},
	{
// Carrier 24 Phase 5
	24020, 7818, -13969, -25777, -19169, 1134, 20627, 25383,
	12005, -9949, -24796, -21928, -3393, 17565, 25975, 15827,
	-5627, -23062, -24020, -7818, 13969, 25777, 19169, -1134,
	-20627, -25383, -12005, 9949, 24796, 21928, 3393, -17565,
	-25975, -15827, 5627, 23062, 24020, 7818, -13969, -25777,
	-19169, 1134, 20627, 25383, 12005, -9949, -24796, -21928,
	-3393, 17565, 25975, 15827, -5627, -23062, -24020, -7818,
	13969, 25777, 19169, -1133, -20627, -25383, -12005, 9949,
	24796, 21928, 3393, -17565, -25975, -15827, 5627, 23062,
	24020, 7818, -13969, -25777, -19169, 1133, 20627, 25383,
	12005, -9949, -24796, -21928, -3393, 17565, 25975, 15827,
	-5627, -23062, -24020, -7818, 13969, 25777, 19169, -1133,
	-20627, -25383, -12005, 9949, 24796, 21928, 3393, -17565,
	-25975, -15827, 5627, 23062, 24020, 7818, -13969, -25777,
	-19169, 1133, 20627, 25383, 12005, -9949, -24796, -21928,
	-3393, 17565, 25975, 15827, -5627, -23062, -24020, -7818,
	13969, 25777, 19169, -1133, -20627, -25383, -12005, 9949,
	24796, 21928, 3393, -17565, -25975, -15828, 5627, 23062,
	24020, 7818, -13969, -25777, -19169, 1133, 20627, 25383,
	12005, -9949, -24796, -21928, -3393, 17565, 25975, 15828,
	-5627, -23062, -24020, -7818, 13969, 25777, 19169, -1133,
	-20627, -25383, -12005, 9949, 24796, 21928, 3393, -17565,
	-25975, -15828, 5627, 23062, 24020, 7818, -13969, -25777,
	-19169, 1133, 20626, 25383, 12005, -9949, -24796, -21928,
	-3394, 17565, 25975, 15828, -5627, -23062, -24021, -7818,
	13969, 25777, 19169, -1133, -20626, -25383, -12005, 9949,
	24796, 21928, 3394, -17565, -25975, -15828, 5627, 23062},
	{
// Carrier 24 Phase 6
	18384, -2266, -21297, -25114, -10988, 10988, 25114, 21297,
	2266, -18384, -25901, -14913, 6729, 23563, 23564, 6729,
	-14912, -25901, -18384, 2266, 21297, 25114, 10988, -10988,
	-25114, -21297, -2266, 18384, 25901, 14913, -6729, -23563,
	-23564, -6729, 14912, 25901, 18384, -2265, -21297, -25114,
	-10988, 10988, 25114, 21297, 2266, -18384, -25901, -14913,
	6729, 23563, 23564, 6729, -14912, -25901, -18384, 2265,
	21297, 25114, 10988, -10987, -25114, -21298, -2266, 18384,
	25901, 14913, -6729, -23563, -23564, -6729, 14912, 25901,
	18384, -2265, -21297, -25114, -10988, 10987, 25114, 21298,
	2266, -18384, -25901, -14913, 6729, 23563, 23564, 6729,
	-14912, -25901, -18384, 2265, 21297, 25114, 10988, -10987,
	-25114, -21298, -2266, 18384, 25901, 14913, -6729, -23563,
	-23564, -6729, 14912, 25901, 18384, -2265, -21297, -25114,
	-10988, 10987, 25114, 21298, 2266, -18384, -25901, -14913,
	6729, 23563, 23564, 6729, -14912, -25901, -18384, 2265,
	21297, 25114, 10988, -10987, -25114, -21298, -2266, 18384,
	25901, 14913, -6729, -23563, -23564, -6729, 14912, 25901,
	18384, -2265, -21297, -25114, -10988, 10987, 25114, 21298,
	2266, -18384, -25901, -14913, 6729, 23563, 23564, 6729,
	-14912, -25901, -18384, 2265, 21297, 25114, 10988, -10987,
	-25113, -21298, -2266, 18384, 25901, 14913, -6729, -23563,
	-23564, -6729, 14912, 25901, 18384, -2265, -21297, -25114,
	-10988, 10987, 25113, 21298, 2266, -18384, -25901, -14913,
	6728, 23563, 23564, 6729, -14912, -25901, -18385, 2265,
	21297, 25114, 10988, -10987, -25113, -21298, -2266, 18384,
	25901, 14913, -6728, -23563, -23564, -6729, 14912, 25901},
	{
// Carrier 24 Phase 7
	9949, -12005, -25383, -20627, -1134, 19169, 25777, 13969,
	-7818, -24020, -23062, -5627, 15827, 25975, 17565, -3393,
	-21928, -24796, -9949, 12005, 25383, 20627, 1134, -19169,
	-25777, -13969, 7818, 24020, 23062, 5627, -15827, -25975,
	-17565, 3393, 21928, 24796, 9949, -12005, -25383, -20627,
	-1134, 19169, 25777, 13969, -7818, -24020, -23062, -5627,
	15827, 25975, 17565, -3393, -21928, -24796, -9949, 12005,
	25383, 20627, 1134, -19169, -25777, -13969, 7818, 24020,
	23062, 5627, -15827, -25975, -17565, 3393, 21928, 24796,
	9949, -12005, -25383, -20627, -1134, 19169, 25777, 13969,
	-7818, -24020, -23062, -5627, 15827, 25975, 17565, -3393,
	-21928, -24796, -9949, 12005, 25383, 20627, 1134, -19169,
	-25777, -13969, 7818, 24020, 23062, 5627, -15827, -25975,
	-17565, 3393, 21928, 24796, 9949, -12005, -25383, -20627,
	-1134, 19169, 25777, 13969, -7818, -24020, -23062, -5627,
	15827, 25975, 17565, -3393, -21928, -24796, -9949, 12005,
	25383, 20627, 1134, -19169, -25777, -13969, 7818, 24020,
	23062, 5627, -15827, -25975, -17565, 3393, 21928, 24796,
	9949, -12005, -25383, -20627, -1134, 19169, 25777, 13970,
	-7818, -24020, -23062, -5627, 15827, 25975, 17565, -3393,
	-21928, -24796, -9950, 12005, 25383, 20627, 1134, -19169,
	-25777, -13970, 7818, 24020, 23062, 5627, -15827, -25975,
	-17565, 3393, 21928, 24796, 9950, -12005, -25383, -20627,
	-1134, 19168, 25777, 13970, -7818, -24020, -23062, -5627,
	15827, 25975, 17565, -3393, -21927, -24796, -9950, 12005,
	25383, 20627, 1134, -19168, -25777, -13970, 7818, 24020,
	23062, 5627, -15827, -25975, -17565, 3393, 21927, 24796},
	},{{

// Carrier 25 Phase 0
	0, 20394, 25299, 10988, -11668, -25462, -19917, 756,
	20855, 25114, 10298, -12339, -25604, -19422, 1511, 21297,
	24907, 9599, -12999, -25725, -18911, 2266, 21722, 24680,
	8892, -13649, -25824, -18384, 3018, 22129, 24432, 8178,
	-14287, -25901, -17842, 3768, 22516, 24163, 7456, -14912,
	-25956, -17284, 4514, 22885, 23873, 6729, -15526, -25989,
	-16712, 5257, 23234, 23564, 5996, -16126, -26000, -16126,
	5995, 23563, 23234, 5257, -16712, -25989, -15526, 6729,
	23873, 22885, 4514, -17284, -25956, -14913, 7456, 24163,
	22516, 3768, -17842, -25901, -14287, 8178, 24432, 22129,
	3018, -18384, -25824, -13649, 8892, 24680, 21722, 2266,
	-18911, -25725, -13000, 9599, 24907, 21297, 1511, -19422,
	-25605, -12339, 10298, 25114, 20855, 756, -19917, -25462,
	-11668, 10988, 25299, 20394, 0, -20394, -25299, -10988,
	11668, 25462, 19917, -756, -20855, -25114, -10298, 12339,
	25605, 19422, -1511, -21297, -24907, -9599, 13000, 25725,
	18911, -2266, -21722, -24680, -8892, 13649, 25824, 18384,
	-3018, -22129, -24432, -8178, 14287, 25901, 17842, -3768,
	-22516, -24163, -7456, 14913, 25956, 17284, -4514, -22885,
	-23873, -6729, 15526, 25989, 16712, -5257, -23234, -23563,
	-5995, 16126, 26000, 16126, -5996, -23564, -23234, -5257,
	16712, 25989, 15526, -6729, -23873, -22885, -4514, 17284,
	25956, 14912, -7456, -24163, -22516, -3768, 17842, 25901,
	14287, -8178, -24432, -22129, -3018, 18384, 25824, 13649,
	-8892, -24680, -21722, -2265, 18911, 25725, 12999, -9599,
	-24907, -21297, -1511, 19422, 25604, 12339, -10298, -25114,
	-20855, -756, 19917, 25462, 11668, -10988, -25299, -20394},
	{
// Carrier 25 Phase 1
	9949, 25013, 21078, 1134, -19671, -25536, -12005, 10644,
	25209, 20627, 378, -20158, -25383, -11329, 11329, 25383,
	20158, -378, -20627, -25209, -10644, 12005, 25536, 19671,
	-1134, -21078, -25013, -9949, 12671, 25667, 19169, -1889,
	-21512, -24796, -9246, 13326, 25777, 18650, -2642, -21928,
	-24558, -8536, 13969, 25865, 18115, -3393, -22325, -24300,
	-7818, 14601, 25931, 17565, -4141, -22703, -24020, -7093,
	15221, 25975, 17000, -4886, -23062, -23721, -6363, 15827,
	25997, 16421, -5627, -23401, -23401, -5627, 16421, 25997,
	15827, -6363, -23721, -23062, -4886, 17000, 25975, 15221,
	-7093, -24020, -22703, -4141, 17565, 25931, 14601, -7818,
	-24300, -22325, -3393, 18115, 25865, 13969, -8536, -24558,
	-21928, -2642, 18650, 25777, 13326, -9246, -24796, -21512,
	-1889, 19169, 25667, 12671, -9949, -25013, -21078, -1134,
	19672, 25536, 12005, -10644, -25209, -20627, -378, 20158,
	25383, 11329, -11329, -25383, -20158, 378, 20627, 25209,
	10644, -12005, -25536, -19671, 1134, 21078, 25013, 9949,
	-12671, -25667, -19169, 1889, 21512, 24796, 9246, -13326,
	-25777, -18650, 2642, 21928, 24558, 8536, -13969, -25865,
	-18115, 3393, 22325, 24300, 7818, -14601, -25931, -17565,
	4142, 22703, 24020, 7093, -15221, -25975, -17000, 4886,
	23062, 23721, 6363, -15827, -25997, -16421, 5627, 23401,
	23401, 5627, -16421, -25997, -15827, 6363, 23721, 23062,
	4886, -17000, -25975, -15221, 7093, 24020, 22703, 4141,
	-17565, -25931, -14601, 7818, 24300, 22325, 3393, -18115,
	-25865, -13969, 8536, 24558, 21928, 2642, -18650, -25777,
	-13326, 9246, 24796, 21512, 1889, -19169, -25667, -12671},
	{
// Carrier 25 Phase 2
	18384, 25824, 13649, -8892, -24680, -21722, -2266, 18911,
	25725, 13000, -9599, -24907, -21297, -1511, 19422, 25605,
	12339, -10298, -25114, -20855, -756, 19917, 25462, 11668,
	-10988, -25299, -20394, 0, 20394, 25299, 10988, -11668,
	-25462, -19917, 756, 20855, 25114, 10298, -12339, -25604,
	-19422, 1511, 21297, 24907, 9599, -12999, -25725, -18911,
	2266, 21722, 24680, 8892, -13649, -25824, -18384, 3018,
	22129, 24432, 8178, -14287, -25901, -17842, 3768, 22516,
	24163, 7456, -14912, -25956, -17284, 4514, 22885, 23873,
	6729, -15526, -25989, -16712, 5257, 23234, 23564, 5996,
	-16126, -26000, -16126, 5996, 23564, 23234, 5257, -16712,
	-25989, -15526, 6729, 23873, 22885, 4514, -17284, -25956,
	-14912, 7456, 24163, 22516, 3768, -17842, -25901, -14287,
	8178, 24432, 22129, 3018, -18384, -25824, -13649, 8892,
	24680, 21722, 2266, -18911, -25725, -12999, 9599, 24907,
	21297, 1511, -19422, -25604, -12339, 10298, 25114, 20855,
	756, -19917, -25462, -11668, 10988, 25299, 20394, 0,
	-20394, -25299, -10988, 11668, 25462, 19917, -756, -20855,
	-25114, -10298, 12339, 25605, 19422, -1511, -21297, -24907,
	-9599, 13000, 25725, 18911, -2266, -21722, -24680, -8892,
	13649, 25824, 18384, -3018, -22129, -24431, -8178, 14287,
	25901, 17842, -3768, -22516, -24163, -7456, 14913, 25956,
	17284, -4514, -22885, -23873, -6729, 15526, 25989, 16712,
	-5257, -23234, -23563, -5995, 16126, 26000, 16126, -5996,
	-23564, -23234, -5257, 16712, 25988, 15526, -6729, -23873,
	-22885, -4514, 17284, 25956, 14912, -7456, -24163, -22516,
	-3768, 17842, 25901, 14287, -8178, -24432, -22129, -3018},
	{
// Carrier 25 Phase 3
	24020, 22703, 4141, -17565, -25931, -14601, 7818, 24300,
	22325, 3393, -18115, -25865, -13969, 8536, 24558, 21928,
	2642, -18650, -25777, -13326, 9246, 24796, 21512, 1889,
	-19169, -25667, -12671, 9949, 25013, 21078, 1134, -19671,
	-25536, -12005, 10644, 25209, 20627, 378, -20158, -25383,
	-11329, 11329, 25383, 20158, -378, -20627, -25209, -10644,
	12005, 25536, 19671, -1134, -21078, -25013, -9949, 12671,
	25667, 19169, -1889, -21512, -24796, -9246, 13326, 25777,
	18650, -2642, -21928, -24558, -8536, 13969, 25865, 18115,
	-3393, -22325, -24300, -7818, 14601, 25931, 17565, -4142,
	-22703, -24020, -7093, 15221, 25975, 17000, -4886, -23062,
	-23721, -6363, 15827, 25997, 16420, -5627, -23401, -23401,
	-5627, 16421, 25997, 15827, -6363, -23721, -23062, -4886,
	17000, 25975, 15221, -7093, -24020, -22703, -4141, 17565,
	25931, 14601, -7818, -24300, -22325, -3393, 18115, 25865,
	13969, -8536, -24558, -21928, -2642, 18650, 25777, 13326,
	-9246, -24796, -21512, -1889, 19169, 25667, 12671, -9949,
	-25013, -21078, -1134, 19672, 25536, 12005, -10644, -25209,
	-20627, -378, 20158, 25383, 11329, -11329, -25383, -20158,
	378, 20627, 25209, 10644, -12005, -25536, -19671, 1134,
	21078, 25013, 9949, -12671, -25667, -19169, 1889, 21512,
	24796, 9246, -13326, -25777, -18650, 2642, 21928, 24558,
	8536, -13969, -25865, -18115, 3393, 22325, 24300, 7818,
	-14601, -25931, -17565, 4142, 22703, 24020, 7093, -15221,
	-25975, -17000, 4886, 23062, 23721, 6363, -15827, -25997,
	-16420, 5627, 23401, 23401, 5627, -16421, -25997, -15827,
	6363, 23721, 23062, 4886, -17000, -25975, -15221, 7093},
	{
// Carrier 25 Phase 4
	26000, 16126, -5996, -23563, -23234, -5257, 16712, 25989,
	15526, -6729, -23873, -22885, -4514, 17284, 25956, 14912,
	-7456, -24163, -22516, -3768, 17842, 25901, 14287, -8178,
	-24432, -22129, -3018, 18384, 25824, 13649, -8892, -24680,
	-21722, -2266, 18911, 25725, 12999, -9599, -24907, -21297,
	-1511, 19422, 25604, 12339, -10298, -25114, -20855, -756,
	19917, 25462, 11668, -10988, -25299, -20394, 0, 20394,
	25299, 10988, -11668, -25462, -19917, 756, 20855, 25114,
	10298, -12339, -25605, -19422, 1511, 21297, 24907, 9599,
	-12999, -25725, -18911, 2266, 21722, 24680, 8892, -13649,
	-25824, -18384, 3018, 22129, 24432, 8178, -14287, -25901,
	-17842, 3768, 22516, 24163, 7456, -14912, -25956, -17284,
	4514, 22885, 23873, 6729, -15526, -25989, -16712, 5257,
	23234, 23564, 5996, -16126, -26000, -16126, 5996, 23564,
	23234, 5257, -16712, -25989, -15526, 6729, 23873, 22885,
	4514, -17284, -25956, -14912, 7456, 24163, 22516, 3768,
	-17842, -25901, -14287, 8178, 24432, 22129, 3018, -18384,
	-25824, -13649, 8892, 24680, 21722, 2266, -18911, -25725,
	-12999, 9599, 24907, 21297, 1511, -19422, -25604, -12339,
	10298, 25114, 20855, 756, -19917, -25462, -11668, 10988,
	25299, 20394, 0, -20394, -25299, -10988, 11668, 25462,
	19917, -756, -20855, -25114, -10298, 12339, 25605, 19422,
	-1511, -21297, -24907, -9599, 13000, 25725, 18911, -2266,
	-21722, -24680, -8892, 13649, 25824, 18384, -3018, -22129,
	-24431, -8178, 14287, 25901, 17842, -3768, -22516, -24163,
	-7456, 14913, 25956, 17284, -4514, -22885, -23873, -6729,
	15526, 25989, 16712, -5257, -23234, -23563, -5995, 16126},
	{
// Carrier 25 Phase 5
	24020, 7093, -15221, -25975, -17000, 4886, 23062, 23721,
	6363, -15827, -25997, -16421, 5627, 23401, 23401, 5627,
	-16421, -25997, -15827, 6363, 23721, 23062, 4886, -17000,
	-25975, -15221, 7093, 24020, 22703, 4141, -17565, -25931,
	-14601, 7818, 24300, 22325, 3393, -18115, -25865, -13969,
	8536, 24558, 21928, 2642, -18650, -25777, -13326, 9246,
	24796, 21512, 1889, -19169, -25667, -12671, 9949, 25013,
	21078, 1134, -19672, -25536, -12005, 10644, 25209, 20627,
	378, -20158, -25383, -11329, 11329, 25383, 20158, -378,
	-20627, -25209, -10644, 12005, 25536, 19671, -1134, -21078,
	-25013, -9949, 12671, 25667, 19169, -1889, -21512, -24796,
	-9246, 13326, 25777, 18650, -2642, -21928, -24558, -8536,
	13969, 25865, 18115, -3393, -22325, -24300, -7818, 14601,
	25931, 17565, -4142, -22703, -24020, -7093, 15221, 25975,
	17000, -4886, -23062, -23721, -6363, 15827, 25997, 16420,
	-5627, -23401, -23401, -5627, 16421, 25997, 15827, -6363,
	-23721, -23062, -4886, 17000, 25975, 15221, -7093, -24020,
	-22703, -4141, 17565, 25931, 14601, -7818, -24300, -22325,
	-3393, 18115, 25865, 13969, -8536, -24558, -21928, -2642,
	18650, 25777, 13326, -9246, -24796, -21512, -1889, 19169,
	25667, 12671, -9949, -25013, -21078, -1134, 19672, 25536,
	12005, -10644, -25209, -20627, -378, 20158, 25383, 11329,
	-11329, -25383, -20158, 378, 20627, 25209, 10644, -12005,
	-25536, -19671, 1134, 21078, 25013, 9949, -12671, -25667,
	-19169, 1889, 21512, 24796, 9246, -13326, -25777, -18650,
	2642, 21928, 24558, 8536, -13969, -25865, -18115, 3393,
	22325, 24300, 7818, -14601, -25931, -17565, 4142, 22703},
	{
// Carrier 25 Phase 6
	18384, -3018, -22129, -24432, -8178, 14287, 25901, 17842,
	-3768, -22516, -24163, -7456, 14912, 25956, 17284, -4514,
	-22885, -23873, -6729, 15526, 25989, 16712, -5257, -23234,
	-23563, -5996, 16126, 26000, 16126, -5996, -23564, -23234,
	-5257, 16712, 25989, 15526, -6729, -23873, -22885, -4514,
	17284, 25956, 14912, -7456, -24163, -22516, -3768, 17842,
	25901, 14287, -8178, -24432, -22129, -3018, 18384, 25824,
	13649, -8892, -24680, -21722, -2266, 18911, 25725, 12999,
	-9599, -24907, -21297, -1511, 19422, 25604, 12339, -10298,
	-25114, -20855, -756, 19917, 25462, 11668, -10988, -25299,
	-20394, 0, 20394, 25299, 10988, -11668, -25462, -19917,
	756, 20855, 25114, 10298, -12339, -25605, -19422, 1511,
	21297, 24907, 9599, -13000, -25725, -18911, 2266, 21722,
	24680, 8892, -13649, -25824, -18384, 3018, 22129, 24432,
	8178, -14287, -25901, -17842, 3768, 22516, 24163, 7456,
	-14913, -25956, -17284, 4514, 22885, 23873, 6729, -15526,
	-25989, -16712, 5257, 23234, 23563, 5995, -16126, -26000,
	-16126, 5996, 23564, 23234, 5257, -16712, -25989, -15526,
	6729, 23873, 22885, 4514, -17284, -25956, -14912, 7456,
	24163, 22516, 3768, -17842, -25901, -14287, 8178, 24432,
	22129, 3018, -18384, -25824, -13649, 8892, 24680, 21722,
	2266, -18911, -25725, -12999, 9599, 24907, 21297, 1511,
	-19422, -25604, -12339, 10298, 25114, 20855, 756, -19917,
	-25462, -11668, 10988, 25299, 20394, 0, -20394, -25299,
	-10988, 11668, 25462, 19917, -756, -20855, -25114, -10298,
	12339, 25605, 19422, -1511, -21297, -24907, -9599, 13000,
	25725, 18911, -2266, -21722, -24680, -8892, 13649, 25824},
	{
// Carrier 25 Phase 7
	9949, -12671, -25667, -19169, 1889, 21512, 24796, 9246,
	-13326, -25777, -18650, 2642, 21928, 24558, 8536, -13969,
	-25865, -18115, 3393, 22325, 24300, 7818, -14601, -25931,
	-17565, 4141, 22703, 24020, 7093, -15221, -25975, -17000,
	4886, 23062, 23721, 6363, -15827, -25997, -16421, 5627,
	23401, 23401, 5627, -16421, -25997, -15827, 6363, 23721,
	23062, 4886, -17000, -25975, -15221, 7093, 24020, 22703,
	4141, -17565, -25931, -14601, 7818, 24300, 22325, 3393,
	-18115, -25865, -13969, 8536, 24558, 21928, 2642, -18650,
	-25777, -13326, 9246, 24796, 21512, 1889, -19169, -25667,
	-12671, 9949, 25013, 21078, 1134, -19672, -25536, -12005,
	10644, 25209, 20627, 378, -20158, -25383, -11329, 11329,
	25383, 20158, -378, -20627, -25209, -10644, 12005, 25536,
	19671, -1134, -21078, -25013, -9949, 12671, 25667, 19169,
	-1889, -21512, -24796, -9246, 13326, 25777, 18650, -2642,
	-21928, -24558, -8536, 13969, 25865, 18115, -3393, -22325,
	-24300, -7818, 14601, 25931, 17565, -4142, -22703, -24020,
	-7093, 15221, 25975, 17000, -4886, -23062, -23721, -6363,
	15827, 25997, 16420, -5627, -23401, -23401, -5627, 16421,
	25997, 15827, -6363, -23721, -23062, -4886, 17000, 25975,
	15221, -7093, -24020, -22703, -4141, 17565, 25931, 14601,
	-7818, -24300, -22325, -3393, 18115, 25865, 13969, -8536,
	-24558, -21928, -2642, 18650, 25777, 13326, -9246, -24796,
	-21512, -1889, 19169, 25667, 12671, -9949, -25013, -21078,
	-1134, 19672, 25536, 12005, -10644, -25209, -20627, -378,
	20158, 25383, 11329, -11329, -25383, -20158, 378, 20627,
	25209, 10644, -12005, -25536, -19671, 1134, 21078, 25013},
	},{{

// Carrier 26 Phase 0
	0, 20855, 24907, 8892, -14287, -25956, -16712, 5996,
	23873, 22516, 3018, -18911, -25604, -11668, 11668, 25605,
	18911, -3018, -22516, -23873, -5995, 16712, 25956, 14287,
	-8892, -24907, -20855, 0, 20855, 24907, 8892, -14287,
	-25956, -16712, 5996, 23873, 22516, 3018, -18911, -25604,
	-11668, 11668, 25605, 18911, -3018, -22516, -23873, -5995,
	16712, 25956, 14287, -8892, -24907, -20855, 0, 20855,
	24907, 8892, -14287, -25956, -16712, 5996, 23873, 22516,
	3018, -18911, -25604, -11668, 11668, 25605, 18911, -3018,
	-22516, -23873, -5995, 16712, 25956, 14287, -8892, -24907,
	-20855, 0, 20855, 24907, 8892, -14287, -25956, -16712,
	5996, 23873, 22516, 3018, -18911, -25604, -11668, 11669,
	25605, 18911, -3018, -22516, -23873, -5995, 16712, 25955,
	14286, -8892, -24907, -20855, 0, 20855, 24907, 8892,
	-14287, -25956, -16712, 5996, 23873, 22516, 3018, -18911,
	-25604, -11668, 11669, 25605, 18911, -3018, -22516, -23873,
	-5995, 16712, 25955, 14286, -8892, -24907, -20854, 0,
	20855, 24907, 8892, -14287, -25956, -16712, 5996, 23873,
	22516, 3018, -18911, -25604, -11668, 11669, 25605, 18911,
	-3018, -22516, -23873, -5995, 16712, 25955, 14286, -8892,
	-24907, -20854, 0, 20855, 24907, 8892, -14287, -25956,
	-16712, 5996, 23873, 22516, 3017, -18912, -25604, -11668,
	11669, 25605, 18911, -3018, -22516, -23873, -5995, 16712,
	25955, 14286, -8892, -24907, -20854, 0, 20855, 24907,
	8892, -14287, -25956, -16712, 5996, 23873, 22516, 3017,
	-18912, -25604, -11668, 11669, 25605, 18911, -3018, -22516,
	-23873, -5995, 16712, 25955, 14286, -8893, -24907, -20854},
	{
// Carrier 26 Phase 1
	9949, 25209, 20158, -1134, -21512, -24558, -7818, 15221,
	25997, 15827, -7093, -24300, -21928, -1889, 19672, 25383,
	10644, -12671, -25777, -18115, 4142, 23062, 23401, 4886,
	-17565, -25865, -13326, 9949, 25209, 20158, -1134, -21512,
	-24558, -7818, 15221, 25997, 15827, -7093, -24300, -21928,
	-1889, 19672, 25383, 10644, -12671, -25777, -18115, 4142,
	23062, 23401, 4886, -17565, -25865, -13325, 9949, 25209,
	20158, -1134, -21512, -24558, -7818, 15221, 25997, 15827,
	-7094, -24300, -21928, -1888, 19672, 25383, 10644, -12671,
	-25777, -18115, 4142, 23062, 23401, 4886, -17565, -25865,
	-13325, 9949, 25209, 20157, -1134, -21512, -24558, -7818,
	15221, 25997, 15827, -7094, -24300, -21928, -1888, 19672,
	25383, 10643, -12671, -25777, -18115, 4142, 23062, 23401,
	4886, -17565, -25865, -13325, 9950, 25209, 20157, -1134,
	-21512, -24558, -7818, 15221, 25997, 15827, -7094, -24300,
	-21928, -1888, 19672, 25383, 10643, -12671, -25777, -18115,
	4142, 23062, 23401, 4886, -17565, -25865, -13325, 9950,
	25209, 20157, -1134, -21512, -24558, -7817, 15221, 25997,
	15827, -7094, -24300, -21927, -1888, 19672, 25383, 10643,
	-12671, -25777, -18115, 4142, 23062, 23401, 4886, -17565,
	-25865, -13325, 9950, 25209, 20157, -1134, -21512, -24558,
	-7817, 15221, 25997, 15827, -7094, -24300, -21927, -1888,
	19672, 25383, 10643, -12671, -25777, -18115, 4142, 23062,
	23401, 4886, -17565, -25865, -13325, 9950, 25209, 20157,
	-1134, -21512, -24558, -7817, 15221, 25997, 15827, -7094,
	-24300, -21927, -1888, 19672, 25383, 10643, -12671, -25777,
	-18115, 4142, 23062, 23401, 4886, -17565, -25865, -13325},
	{
// Carrier 26 Phase 2
	18384, 25725, 12339, -10988, -25462, -19422, 2266, 22129,
	24163, 6729, -16126, -25989, -14912, 8178, 24680, 21297,
	756, -20394, -25114, -9599, 13649, 25901, 17284, -5257,
	-23564, -22885, -3768, 18384, 25725, 12339, -10988, -25462,
	-19422, 2266, 22129, 24162, 6729, -16126, -25988, -14912,
	8178, 24680, 21297, 756, -20394, -25114, -9599, 13649,
	25901, 17284, -5257, -23564, -22885, -3768, 18384, 25725,
	12339, -10988, -25462, -19422, 2266, 22129, 24162, 6729,
	-16126, -25988, -14912, 8178, 24680, 21297, 756, -20394,
	-25114, -9599, 13649, 25901, 17284, -5257, -23564, -22885,
	-3768, 18384, 25725, 12339, -10988, -25462, -19422, 2266,
	22129, 24162, 6729, -16126, -25988, -14912, 8178, 24680,
	21297, 755, -20394, -25114, -9599, 13649, 25901, 17284,
	-5257, -23564, -22885, -3767, 18384, 25725, 12339, -10988,
	-25462, -19422, 2266, 22129, 24162, 6728, -16126, -25988,
	-14912, 8178, 24680, 21297, 755, -20395, -25113, -9599,
	13649, 25901, 17284, -5258, -23564, -22885, -3767, 18385,
	25725, 12339, -10988, -25462, -19422, 2266, 22129, 24162,
	6728, -16126, -25988, -14912, 8178, 24680, 21297, 755,
	-20395, -25113, -9598, 13649, 25901, 17284, -5258, -23564,
	-22885, -3767, 18385, 25725, 12339, -10988, -25462, -19422,
	2266, 22129, 24162, 6728, -16126, -25988, -14912, 8178,
	24680, 21297, 755, -20395, -25113, -9598, 13649, 25901,
	17284, -5258, -23564, -22884, -3767, 18385, 25725, 12339,
	-10988, -25462, -19422, 2266, 22129, 24162, 6728, -16126,
	-25988, -14912, 8178, 24680, 21297, 755, -20395, -25113,
	-9598, 13649, 25901, 17284, -5258, -23564, -22884, -3767},
	{
// Carrier 26 Phase 3
	24020, 22325, 2642, -19169, -25536, -11329, 12005, 25667,
	18650, -3393, -22703, -23721, -5627, 17000, 25931, 13969,
	-9246, -25013, -20627, 378, 21078, 24796, 8536, -14601,
	-25975, -16420, 6363, 24020, 22325, 2642, -19169, -25536,
	-11329, 12005, 25667, 18650, -3393, -22703, -23721, -5627,
	17000, 25931, 13969, -9247, -25013, -20627, 378, 21078,
	24796, 8536, -14601, -25975, -16420, 6363, 24020, 22325,
	2642, -19169, -25536, -11329, 12005, 25667, 18650, -3393,
	-22703, -23721, -5627, 17000, 25931, 13969, -9247, -25013,
	-20627, 378, 21078, 24796, 8536, -14601, -25975, -16420,
	6363, 24020, 22325, 2642, -19169, -25536, -11329, 12005,
	25667, 18650, -3393, -22703, -23721, -5627, 17000, 25931,
	13969, -9247, -25013, -20627, 378, 21078, 24796, 8535,
	-14601, -25975, -16420, 6363, 24020, 22325, 2642, -19169,
	-25536, -11329, 12005, 25668, 18649, -3394, -22703, -23721,
	-5627, 17000, 25931, 13969, -9247, -25013, -20626, 378,
	21079, 24796, 8535, -14601, -25975, -16420, 6363, 24021,
	22325, 2642, -19169, -25536, -11329, 12005, 25668, 18649,
	-3394, -22703, -23721, -5627, 17000, 25931, 13969, -9247,
	-25013, -20626, 378, 21079, 24796, 8535, -14602, -25975,
	-16420, 6363, 24021, 22324, 2642, -19169, -25536, -11329,
	12005, 25668, 18649, -3394, -22703, -23721, -5626, 17000,
	25931, 13969, -9247, -25013, -20626, 378, 21079, 24796,
	8535, -14602, -25975, -16420, 6363, 24021, 22324, 2641,
	-19169, -25536, -11329, 12005, 25668, 18649, -3394, -22703,
	-23721, -5626, 17000, 25931, 13969, -9247, -25013, -20626,
	378, 21079, 24796, 8535, -14602, -25975, -16420, 6363},
	{
// Carrier 26 Phase 4
	26000, 15526, -7456, -24432, -21722, -1511, 19917, 25299,
	10298, -13000, -25824, -17842, 4514, 23234, 23234, 4514,
	-17842, -25824, -12999, 10298, 25299, 19917, -1511, -21722,
	-24431, -7456, 15526, 26000, 15526, -7456, -24432, -21722,
	-1511, 19917, 25299, 10297, -13000, -25824, -17842, 4514,
	23234, 23234, 4514, -17842, -25824, -12999, 10298, 25299,
	19917, -1511, -21722, -24431, -7456, 15526, 26000, 15526,
	-7457, -24432, -21722, -1511, 19917, 25299, 10297, -13000,
	-25824, -17842, 4515, 23234, 23234, 4514, -17842, -25824,
	-12999, 10298, 25299, 19917, -1511, -21722, -24431, -7456,
	15526, 26000, 15525, -7457, -24432, -21722, -1511, 19917,
	25299, 10297, -13000, -25824, -17842, 4515, 23234, 23234,
	4514, -17842, -25824, -12999, 10298, 25299, 19916, -1512,
	-21722, -24431, -7456, 15526, 26000, 15525, -7457, -24432,
	-21722, -1511, 19917, 25299, 10297, -13000, -25824, -17842,
	4515, 23234, 23234, 4514, -17842, -25824, -12999, 10298,
	25299, 19916, -1512, -21722, -24431, -7456, 15526, 26000,
	15525, -7457, -24432, -21722, -1511, 19917, 25299, 10297,
	-13000, -25824, -17841, 4515, 23234, 23234, 4514, -17842,
	-25824, -12999, 10298, 25299, 19916, -1512, -21722, -24431,
	-7456, 15526, 26000, 15525, -7457, -24432, -21722, -1511,
	19917, 25299, 10297, -13000, -25824, -17841, 4515, 23234,
	23234, 4514, -17842, -25824, -12999, 10298, 25299, 19916,
	-1512, -21722, -24431, -7456, 15526, 26000, 15525, -7457,
	-24432, -21722, -1511, 19917, 25299, 10297, -13000, -25824,
	-17841, 4515, 23234, 23234, 4514, -17842, -25824, -12999,
	10298, 25299, 19916, -1512, -21723, -24431, -7456, 15526},
	{
// Carrier 26 Phase 5
	24020, 6363, -16421, -25975, -14601, 8536, 24796, 21078,
	378, -20627, -25013, -9246, 13969, 25931, 17000, -5627,
	-23721, -22703, -3393, 18650, 25667, 12005, -11329, -25536,
	-19169, 2642, 22325, 24020, 6363, -16421, -25975, -14601,
	8536, 24796, 21078, 378, -20627, -25013, -9246, 13969,
	25931, 17000, -5627, -23721, -22703, -3393, 18650, 25667,
	12005, -11329, -25536, -19169, 2642, 22325, 24020, 6363,
	-16421, -25975, -14601, 8536, 24796, 21078, 377, -20627,
	-25013, -9246, 13969, 25931, 17000, -5627, -23721, -22703,
	-3393, 18650, 25667, 12005, -11329, -25536, -19169, 2642,
	22325, 24020, 6363, -16421, -25975, -14601, 8536, 24796,
	21078, 377, -20627, -25013, -9246, 13970, 25931, 17000,
	-5627, -23721, -22703, -3393, 18650, 25667, 12005, -11329,
	-25536, -19169, 2642, 22325, 24020, 6363, -16421, -25975,
	-14601, 8536, 24796, 21078, 377, -20627, -25013, -9246,
	13970, 25931, 17000, -5627, -23721, -22703, -3393, 18650,
	25667, 12005, -11329, -25536, -19168, 2642, 22325, 24020,
	6362, -16421, -25975, -14601, 8536, 24796, 21078, 377,
	-20627, -25013, -9246, 13970, 25931, 17000, -5627, -23721,
	-22703, -3393, 18650, 25667, 12005, -11330, -25536, -19168,
	2642, 22325, 24020, 6362, -16421, -25975, -14601, 8536,
	24796, 21078, 377, -20627, -25013, -9246, 13970, 25931,
	17000, -5627, -23721, -22703, -3393, 18650, 25667, 12005,
	-11330, -25536, -19168, 2643, 22325, 24020, 6362, -16421,
	-25975, -14601, 8536, 24796, 21078, 377, -20627, -25013,
	-9246, 13970, 25931, 16999, -5627, -23721, -22703, -3393,
	18650, 25667, 12004, -11330, -25536, -19168, 2643, 22325},
	{
// Carrier 26 Phase 6
	18384, -3768, -22885, -23563, -5257, 17284, 25901, 13649,
	-9599, -25114, -20394, 756, 21297, 24680, 8178, -14913,
	-25989, -16126, 6729, 24163, 22129, 2265, -19422, -25462,
	-10988, 12339, 25725, 18384, -3768, -22885, -23563, -5257,
	17284, 25901, 13649, -9599, -25114, -20394, 756, 21298,
	24680, 8178, -14913, -25989, -16126, 6729, 24163, 22128,
	2265, -19422, -25462, -10987, 12339, 25725, 18384, -3768,
	-22885, -23563, -5257, 17284, 25901, 13649, -9599, -25114,
	-20394, 756, 21298, 24680, 8177, -14913, -25989, -16125,
	6729, 24163, 22128, 2265, -19422, -25462, -10987, 12339,
	25725, 18384, -3768, -22885, -23563, -5257, 17284, 25901,
	13649, -9599, -25114, -20394, 756, 21298, 24680, 8177,
	-14913, -25989, -16125, 6729, 24163, 22128, 2265, -19422,
	-25462, -10987, 12339, 25725, 18384, -3768, -22885, -23563,
	-5257, 17284, 25901, 13649, -9599, -25114, -20394, 756,
	21298, 24680, 8177, -14913, -25989, -16125, 6729, 24163,
	22128, 2265, -19422, -25462, -10987, 12339, 25725, 18384,
	-3768, -22885, -23563, -5257, 17284, 25901, 13649, -9599,
	-25114, -20394, 756, 21298, 24680, 8177, -14913, -25989,
	-16125, 6729, 24163, 22128, 2265, -19422, -25462, -10987,
	12340, 25725, 18384, -3768, -22885, -23563, -5257, 17285,
	25901, 13648, -9599, -25114, -20394, 756, 21298, 24680,
	8177, -14913, -25989, -16125, 6729, 24163, 22128, 2265,
	-19422, -25462, -10987, 12340, 25725, 18384, -3768, -22885,
	-23563, -5257, 17285, 25901, 13648, -9599, -25114, -20394,
	756, 21298, 24680, 8177, -14913, -25989, -16125, 6729,
	24163, 22128, 2265, -19423, -25462, -10987, 12340, 25725},
	{
// Carrier 26 Phase 7
	9949, -13326, -25865, -17565, 4886, 23401, 23062, 4141,
	-18115, -25777, -12671, 10644, 25383, 19671, -1889, -21928,
	-24300, -7093, 15827, 25997, 15221, -7818, -24558, -21512,
	-1134, 20158, 25209, 9949, -13326, -25865, -17565, 4886,
	23401, 23062, 4141, -18115, -25777, -12671, 10644, 25383,
	19671, -1889, -21928, -24300, -7093, 15827, 25997, 15221,
	-7818, -24558, -21512, -1133, 20158, 25209, 9949, -13326,
	-25865, -17565, 4886, 23401, 23062, 4141, -18115, -25777,
	-12670, 10644, 25383, 19671, -1889, -21928, -24300, -7093,
	15827, 25997, 15221, -7818, -24558, -21512, -1133, 20158,
	25209, 9949, -13326, -25865, -17565, 4887, 23401, 23062,
	4141, -18115, -25777, -12670, 10644, 25383, 19671, -1889,
	-21928, -24299, -7093, 15828, 25997, 15220, -7818, -24558,
	-21512, -1133, 20158, 25209, 9949, -13326, -25865, -17565,
	4887, 23401, 23062, 4141, -18115, -25777, -12670, 10644,
	25383, 19671, -1889, -21928, -24299, -7093, 15828, 25997,
	15220, -7818, -24558, -21512, -1133, 20158, 25209, 9949,
	-13326, -25865, -17565, 4887, 23401, 23062, 4141, -18115,
	-25777, -12670, 10644, 25383, 19671, -1889, -21928, -24299,
	-7093, 15828, 25997, 15220, -7818, -24558, -21512, -1133,
	20158, 25209, 9949, -13326, -25865, -17565, 4887, 23401,
	23062, 4141, -18115, -25777, -12670, 10644, 25383, 19671,
	-1889, -21928, -24299, -7093, 15828, 25997, 15220, -7818,
	-24558, -21512, -1133, 20158, 25209, 9949, -13326, -25865,
	-17564, 4887, 23401, 23062, 4141, -18115, -25777, -12670,
	10644, 25383, 19671, -1889, -21928, -24299, -7093, 15828,
	25997, 15220, -7818, -24558, -21512, -1133, 20158, 25209},
	},{{

// Carrier 27 Phase 0
	0, 21297, 24432, 6729, -16712, -25901, -13000, 10988,
	25605, 18384, -4514, -23564, -22516, -2266, 19917, 25114,
	8892, -14912, -26000, -14912, 8892, 25114, 19917, -2266,
	-22516, -23564, -4514, 18384, 25605, 10988, -12999, -25901,
	-16712, 6729, 24432, 21297, 0, -21297, -24432, -6729,
	16712, 25901, 13000, -10988, -25605, -18384, 4514, 23564,
	22516, 2266, -19917, -25114, -8892, 14912, 26000, 14912,
	-8892, -25114, -19917, 2266, 22516, 23564, 4514, -18384,
	-25605, -10988, 12999, 25901, 16712, -6729, -24432, -21297,
	0, 21297, 24432, 6729, -16712, -25901, -13000, 10988,
	25605, 18384, -4514, -23564, -22516, -2266, 19917, 25114,
	8892, -14912, -26000, -14912, 8892, 25114, 19917, -2266,
	-22516, -23564, -4514, 18384, 25605, 10988, -12999, -25901,
	-16712, 6729, 24432, 21297, 0, -21297, -24432, -6729,
	16712, 25901, 13000, -10988, -25605, -18384, 4514, 23564,
	22516, 2266, -19917, -25114, -8892, 14912, 26000, 14912,
	-8892, -25114, -19917, 2266, 22516, 23564, 4514, -18384,
	-25605, -10988, 12999, 25901, 16712, -6729, -24432, -21297,
	0, 21297, 24432, 6729, -16712, -25901, -13000, 10988,
	25605, 18384, -4514, -23564, -22516, -2266, 19917, 25114,
	8892, -14912, -26000, -14912, 8892, 25114, 19917, -2266,
	-22516, -23564, -4514, 18384, 25605, 10988, -12999, -25901,
	-16712, 6729, 24432, 21297, 0, -21297, -24432, -6729,
	16712, 25901, 13000, -10988, -25605, -18384, 4514, 23564,
	22516, 2266, -19917, -25114, -8892, 14912, 26000, 14912,
	-8892, -25114, -19917, 2266, 22516, 23564, 4514, -18384,
	-25605, -10988, 12999, 25901, 16712, -6729, -24432, -21297},
	{
// Carrier 27 Phase 1
	9949, 25383, 19169, -3393, -23062, -23062, -3393, 19169,
	25383, 9949, -13969, -25975, -15827, 7818, 24796, 20627,
	-1134, -21928, -24020, -5627, 17565, 25777, 12005, -12005,
	-25777, -17565, 5627, 24020, 21928, 1134, -20627, -24796,
	-7818, 15827, 25975, 13969, -9949, -25383, -19169, 3393,
	23062, 23062, 3393, -19169, -25383, -9949, 13969, 25975,
	15827, -7818, -24796, -20627, 1134, 21928, 24020, 5627,
	-17565, -25777, -12005, 12005, 25777, 17565, -5627, -24020,
	-21928, -1134, 20627, 24796, 7818, -15827, -25975, -13969,
	9949, 25383, 19169, -3393, -23062, -23062, -3393, 19169,
	25383, 9949, -13969, -25975, -15827, 7818, 24796, 20627,
	-1134, -21928, -24020, -5627, 17565, 25777, 12005, -12005,
	-25777, -17565, 5627, 24020, 21928, 1134, -20627, -24796,
	-7818, 15827, 25975, 13969, -9949, -25383, -19169, 3393,
	23062, 23062, 3393, -19169, -25383, -9949, 13969, 25975,
	15827, -7818, -24796, -20627, 1134, 21928, 24020, 5627,
	-17565, -25777, -12005, 12005, 25777, 17565, -5627, -24020,
	-21928, -1134, 20627, 24796, 7818, -15827, -25975, -13969,
	9949, 25383, 19169, -3393, -23062, -23062, -3393, 19169,
	25383, 9949, -13969, -25975, -15827, 7818, 24796, 20627,
	-1134, -21928, -24020, -5627, 17565, 25777, 12005, -12005,
	-25777, -17565, 5627, 24020, 21928, 1134, -20627, -24796,
	-7818, 15827, 25975, 13969, -9949, -25383, -19169, 3393,
	23062, 23062, 3393, -19169, -25383, -9949, 13969, 25975,
	15827, -7818, -24796, -20627, 1134, 21928, 24020, 5627,
	-17565, -25777, -12005, 12005, 25777, 17565, -5627, -24020,
	-21928, -1134, 20627, 24796, 7818, -15827, -25975, -13969},
	{
// Carrier 27 Phase 2
	18384, 25605, 10988, -12999, -25901, -16712, 6729, 24432,
	21297, 0, -21297, -24432, -6729, 16712, 25901, 13000,
	-10988, -25605, -18384, 4514, 23564, 22516, 2266, -19917,
	-25114, -8892, 14912, 26000, 14912, -8892, -25114, -19917,
	2266, 22516, 23564, 4514, -18384, -25605, -10988, 12999,
	25901, 16712, -6729, -24432, -21297, 0, 21297, 24432,
	6729, -16712, -25901, -13000, 10988, 25605, 18384, -4514,
	-23564, -22516, -2266, 19917, 25114, 8892, -14912, -26000,
	-14912, 8892, 25114, 19917, -2266, -22516, -23564, -4514,
	18384, 25605, 10988, -12999, -25901, -16712, 6729, 24432,
	21297, 0, -21297, -24432, -6729, 16712, 25901, 13000,
	-10988, -25605, -18384, 4514, 23564, 22516, 2266, -19917,
	-25114, -8892, 14912, 26000, 14912, -8892, -25114, -19917,
	2266, 22516, 23564, 4514, -18384, -25605, -10988, 12999,
	25901, 16712, -6729, -24432, -21297, 0, 21297, 24432,
	6729, -16712, -25901, -13000, 10988, 25605, 18384, -4514,
	-23564, -22516, -2266, 19917, 25114, 8892, -14912, -26000,
	-14912, 8892, 25114, 19917, -2266, -22516, -23564, -4514,
	18384, 25605, 10988, -12999, -25901, -16712, 6729, 24432,
	21297, 0, -21297, -24432, -6729, 16712, 25901, 13000,
	-10988, -25605, -18384, 4514, 23564, 22516, 2266, -19917,
	-25114, -8892, 14912, 26000, 14912, -8892, -25114, -19917,
	2266, 22516, 23564, 4514, -18384, -25605, -10988, 12999,
	25901, 16712, -6729, -24432, -21297, 0, 21297, 24432,
	6729, -16712, -25901, -13000, 10988, 25605, 18384, -4514,
	-23564, -22516, -2266, 19917, 25114, 8892, -14912, -26000,
	-14912, 8892, 25114, 19917, -2266, -22516, -23564, -4514},
	{
// Carrier 27 Phase 3
	24020, 21928, 1134, -20627, -24796, -7818, 15827, 25975,
	13969, -9949, -25383, -19169, 3393, 23062, 23062, 3393,
	-19169, -25383, -9949, 13969, 25975, 15827, -7818, -24796,
	-20627, 1134, 21928, 24020, 5627, -17565, -25777, -12005,
	12005, 25777, 17565, -5627, -24020, -21928, -1134, 20627,
	24796, 7818, -15827, -25975, -13969, 9949, 25383, 19169,
	-3393, -23062, -23062, -3393, 19169, 25383, 9949, -13969,
	-25975, -15827, 7818, 24796, 20627, -1134, -21928, -24020,
	-5627, 17565, 25777, 12005, -12005, -25777, -17565, 5627,
	24020, 21928, 1134, -20627, -24796, -7818, 15827, 25975,
	13969, -9949, -25383, -19169, 3393, 23062, 23062, 3393,
	-19169, -25383, -9949, 13969, 25975, 15827, -7818, -24796,
	-20627, 1134, 21928, 24020, 5627, -17565, -25777, -12005,
	12005, 25777, 17565, -5627, -24020, -21928, -1134, 20627,
	24796, 7818, -15827, -25975, -13969, 9949, 25383, 19169,
	-3393, -23062, -23062, -3393, 19169, 25383, 9949, -13969,
	-25975, -15827, 7818, 24796, 20627, -1134, -21928, -24020,
	-5627, 17565, 25777, 12005, -12005, -25777, -17565, 5627,
	24020, 21928, 1134, -20627, -24796, -7818, 15827, 25975,
	13969, -9949, -25383, -19169, 3393, 23062, 23062, 3393,
	-19169, -25383, -9949, 13969, 25975, 15827, -7818, -24796,
	-20627, 1134, 21928, 24020, 5627, -17565, -25777, -12005,
	12005, 25777, 17565, -5627, -24020, -21928, -1134, 20627,
	24796, 7818, -15827, -25975, -13969, 9949, 25383, 19169,
	-3393, -23062, -23062, -3393, 19169, 25383, 9949, -13969,
	-25975, -15827, 7818, 24796, 20627, -1134, -21928, -24020,
	-5627, 17565, 25777, 12005, -12005, -25777, -17565, 5627},
	{
// Carrier 27 Phase 4
	26000, 14912, -8892, -25114, -19917, 2266, 22516, 23564,
	4514, -18384, -25605, -10988, 12999, 25901, 16712, -6729,
	-24432, -21297, 0, 21297, 24432, 6729, -16712, -25901,
	-13000, 10988, 25605, 18384, -4514, -23564, -22516, -2266,
	19917, 25114, 8892, -14912, -26000, -14912, 8892, 25114,
	19917, -2266, -22516, -23564, -4514, 18384, 25605, 10988,
	-12999, -25901, -16712, 6729, 24432, 21297, 0, -21297,
	-24432, -6729, 16712, 25901, 13000, -10988, -25605, -18384,
	4514, 23564, 22516, 2266, -19917, -25114, -8892, 14912,
	26000, 14912, -8892, -25114, -19917, 2266, 22516, 23564,
	4514, -18384, -25605, -10988, 12999, 25901, 16712, -6729,
	-24432, -21297, 0, 21297, 24432, 6729, -16712, -25901,
	-13000, 10988, 25605, 18384, -4514, -23564, -22516, -2266,
	19917, 25114, 8892, -14912, -26000, -14912, 8892, 25114,
	19917, -2266, -22516, -23564, -4514, 18384, 25605, 10988,
	-12999, -25901, -16712, 6729, 24432, 21297, 0, -21297,
	-24432, -6729, 16712, 25901, 13000, -10988, -25605, -18384,
	4514, 23564, 22516, 2266, -19917, -25114, -8892, 14912,
	26000, 14912, -8892, -25114, -19917, 2266, 22516, 23564,
	4514, -18384, -25605, -10988, 12999, 25901, 16712, -6729,
	-24432, -21297, 0, 21297, 24432, 6729, -16712, -25901,
	-13000, 10988, 25605, 18384, -4514, -23564, -22516, -2266,
	19917, 25114, 8892, -14912, -26000, -14912, 8892, 25114,
	19917, -2266, -22516, -23564, -4514, 18384, 25605, 10988,
	-12999, -25901, -16712, 6729, 24432, 21297, 0, -21297,
	-24432, -6729, 16712, 25901, 13000, -10988, -25605, -18384,
	4514, 23564, 22516, 2266, -19917, -25114, -8892, 14912},
	{
// Carrier 27 Phase 5
	24020, 5627, -17565, -25777, -12005, 12005, 25777, 17565,
	-5627, -24020, -21928, -1134, 20627, 24796, 7818, -15827,
	-25975, -13969, 9949, 25383, 19169, -3393, -23062, -23062,
	-3393, 19169, 25383, 9949, -13969, -25975, -15827, 7818,
	24796, 20627, -1134, -21928, -24020, -5627, 17565, 25777,
	12005, -12005, -25777, -17565, 5627, 24020, 21928, 1134,
	-20627, -24796, -7818, 15827, 25975, 13969, -9949, -25383,
	-19169, 3393, 23062, 23062, 3393, -19169, -25383, -9949,
	13969, 25975, 15827, -7818, -24796, -20627, 1134, 21928,
	24020, 5627, -17565, -25777, -12005, 12005, 25777, 17565,
	-5627, -24020, -21928, -1134, 20627, 24796, 7818, -15827,
	-25975, -13969, 9949, 25383, 19169, -3393, -23062, -23062,
	-3393, 19169, 25383, 9949, -13969, -25975, -15827, 7818,
	24796, 20627, -1134, -21928, -24020, -5627, 17565, 25777,
	12005, -12005, -25777, -17565, 5627, 24020, 21928, 1134,
	-20627, -24796, -7818, 15827, 25975, 13969, -9949, -25383,
	-19169, 3393, 23062, 23062, 3393, -19169, -25383, -9949,
	13969, 25975, 15827, -7818, -24796, -20627, 1134, 21928,
	24020, 5627, -17565, -25777, -12005, 12005, 25777, 17565,
	-5627, -24020, -21928, -1134, 20627, 24796, 7818, -15827,
	-25975, -13969, 9949, 25383, 19169, -3393, -23062, -23062,
	-3393, 19169, 25383, 9949, -13969, -25975, -15827, 7818,
	24796, 20627, -1134, -21928, -24020, -5627, 17565, 25777,
	12005, -12005, -25777, -17565, 5627, 24020, 21928, 1134,
	-20627, -24796, -7818, 15827, 25975, 13969, -9949, -25383,
	-19169, 3393, 23062, 23062, 3393, -19169, -25383, -9949,
	13969, 25975, 15827, -7818, -24796, -20627, 1134, 21928},
	{
// Carrier 27 Phase 6
	18384, -4514, -23564, -22516, -2266, 19917, 25114, 8892,
	-14912, -26000, -14912, 8892, 25114, 19917, -2266, -22516,
	-23564, -4514, 18384, 25605, 10988, -12999, -25901, -16712,
	6729, 24432, 21297, 0, -21297, -24432, -6729, 16712,
	25901, 13000, -10988, -25605, -18384, 4514, 23564, 22516,
	2266, -19917, -25114, -8892, 14912, 26000, 14912, -8892,
	-25114, -19917, 2266, 22516, 23564, 4514, -18384, -25605,
	-10988, 12999, 25901, 16712, -6729, -24432, -21297, 0,
	21297, 24432, 6729, -16712, -25901, -13000, 10988, 25605,
	18384, -4514, -23564, -22516, -2266, 19917, 25114, 8892,
	-14912, -26000, -14912, 8892, 25114, 19917, -2266, -22516,
	-23564, -4514, 18384, 25605, 10988, -12999, -25901, -16712,
	6729, 24432, 21297, 0, -21297, -24432, -6729, 16712,
	25901, 13000, -10988, -25605, -18384, 4514, 23564, 22516,
	2266, -19917, -25114, -8892, 14912, 26000, 14912, -8892,
	-25114, -19917, 2266, 22516, 23564, 4514, -18384, -25605,
	-10988, 12999, 25901, 16712, -6729, -24432, -21297, 0,
	21297, 24432, 6729, -16712, -25901, -13000, 10988, 25605,
	18384, -4514, -23564, -22516, -2266, 19917, 25114, 8892,
	-14912, -26000, -14912, 8892, 25114, 19917, -2266, -22516,
	-23564, -4514, 18384, 25605, 10988, -12999, -25901, -16712,
	6729, 24432, 21297, 0, -21297, -24432, -6729, 16712,
	25901, 13000, -10988, -25605, -18384, 4514, 23564, 22516,
	2266, -19917, -25114, -8892, 14912, 26000, 14912, -8892,
	-25114, -19917, 2266, 22516, 23564, 4514, -18384, -25605,
	-10988, 12999, 25901, 16712, -6729, -24432, -21297, 0,
	21297, 24432, 6729, -16712, -25901, -13000, 10988, 25605},
	{
// Carrier 27 Phase 7
	9949, -13969, -25975, -15827, 7818, 24796, 20627, -1134,
	-21928, -24020, -5627, 17565, 25777, 12005, -12005, -25777,
	-17565, 5627, 24020, 21928, 1134, -20627, -24796, -7818,
	15827, 25975, 13969, -9949, -25383, -19169, 3393, 23062,
	23062, 3393, -19169, -25383, -9949, 13969, 25975, 15827,
	-7818, -24796, -20627, 1134, 21928, 24020, 5627, -17565,
	-25777, -12005, 12005, 25777, 17565, -5627, -24020, -21928,
	-1134, 20627, 24796, 7818, -15827, -25975, -13969, 9949,
	25383, 19169, -3393, -23062, -23062, -3393, 19169, 25383,
	9949, -13969, -25975, -15827, 7818, 24796, 20627, -1134,
	-21928, -24020, -5627, 17565, 25777, 12005, -12005, -25777,
	-17565, 5627, 24020, 21928, 1134, -20627, -24796, -7818,
	15827, 25975, 13969, -9949, -25383, -19169, 3393, 23062,
	23062, 3393, -19169, -25383, -9949, 13969, 25975, 15827,
	-7818, -24796, -20627, 1134, 21928, 24020, 5627, -17565,
	-25777, -12005, 12005, 25777, 17565, -5627, -24020, -21928,
	-1134, 20627, 24796, 7818, -15827, -25975, -13969, 9949,
	25383, 19169, -3393, -23062, -23062, -3393, 19169, 25383,
	9949, -13969, -25975, -15827, 7818, 24796, 20627, -1134,
	-21928, -24020, -5627, 17565, 25777, 12005, -12005, -25777,
	-17565, 5627, 24020, 21928, 1134, -20627, -24796, -7818,
	15827, 25975, 13969, -9949, -25383, -19169, 3393, 23062,
	23062, 3393, -19169, -25383, -9949, 13969, 25975, 15827,
	-7818, -24796, -20627, 1134, 21928, 24020, 5627, -17565,
	-25777, -12005, 12005, 25777, 17565, -5627, -24020, -21928,
	-1134, 20627, 24796, 7818, -15827, -25975, -13969, 9949,
	25383, 19169, -3393, -23062, -23062, -3393, 19169, 25383},
	},{{

// Carrier 28 Phase 0
	0, 21722, 23873, 4514, -18911, -25299, -8892, 15526,
	25956, 13000, -11668, -25824, -16712, 7456, 24907, 19917,
	-3018, -23234, -22516, -1511, 20855, 24432, 5996, -17842,
	-25605, -10298, 14287, 26000, 14287, -10298, -25605, -17842,
	5996, 24432, 20855, -1511, -22516, -23234, -3018, 19917,
	24907, 7456, -16712, -25824, -11668, 13000, 25956, 15526,
	-8892, -25299, -18911, 4514, 23873, 21722, 0, -21722,
	-23873, -4514, 18911, 25299, 8892, -15526, -25956, -12999,
	11668, 25824, 16712, -7456, -24907, -19917, 3018, 23234,
	22516, 1511, -20855, -24432, -5996, 17842, 25604, 10298,
	-14287, -26000, -14287, 10298, 25605, 17842, -5996, -24432,
	-20855, 1511, 22516, 23234, 3018, -19917, -24907, -7456,
	16712, 25824, 11668, -13000, -25956, -15526, 8892, 25299,
	18911, -4514, -23873, -21722, 0, 21722, 23873, 4514,
	-18911, -25299, -8892, 15526, 25956, 12999, -11668, -25824,
	-16712, 7456, 24907, 19917, -3018, -23234, -22516, -1511,
	20855, 24431, 5995, -17842, -25604, -10298, 14287, 26000,
	14287, -10298, -25605, -17842, 5996, 24432, 20855, -1511,
	-22516, -23234, -3018, 19917, 24907, 7456, -16712, -25824,
	-11668, 13000, 25956, 15526, -8892, -25299, -18911, 4514,
	23873, 21722, 0, -21722, -23873, -4514, 18911, 25299,
	8892, -15526, -25956, -12999, 11668, 25824, 16712, -7456,
	-24907, -19917, 3018, 23234, 22516, 1511, -20855, -24431,
	-5995, 17842, 25604, 10298, -14287, -26000, -14287, 10298,
	25605, 17842, -5996, -24432, -20855, 1511, 22516, 23234,
	3018, -19917, -24907, -7456, 16712, 25824, 11668, -13000,
	-25956, -15526, 8892, 25299, 18911, -4514, -23873, -21722},
	{
// Carrier 28 Phase 1
	9949, 25536, 18115, -5627, -24300, -21078, 1134, 22325,
	23401, 3393, -19671, -25013, -7818, 16421, 25865, 12005,
	-12671, -25931, -15827, 8536, 25209, 19169, -4141, -23721,
	-21928, -378, 21512, 24020, 4886, -18650, -25383, -9246,
	15221, 25975, 13326, -11329, -25777, -17000, 7093, 24796,
	20158, -2642, -23062, -22703, -1889, 20627, 24558, 6363,
	-17565, -25667, -10644, 13969, 25997, 14601, -9949, -25536,
	-18115, 5627, 24300, 21078, -1134, -22325, -23401, -3393,
	19671, 25013, 7818, -16421, -25865, -12005, 12671, 25931,
	15827, -8536, -25209, -19169, 4142, 23721, 21928, 378,
	-21512, -24020, -4886, 18650, 25383, 9246, -15221, -25975,
	-13326, 11329, 25777, 17000, -7093, -24796, -20158, 2642,
	23062, 22703, 1889, -20627, -24558, -6363, 17565, 25667,
	10644, -13969, -25997, -14601, 9949, 25536, 18115, -5627,
	-24300, -21078, 1134, 22325, 23401, 3393, -19672, -25013,
	-7818, 16421, 25865, 12005, -12671, -25931, -15827, 8536,
	25209, 19169, -4142, -23721, -21928, -378, 21512, 24020,
	4886, -18650, -25383, -9246, 15221, 25975, 13326, -11329,
	-25777, -17000, 7093, 24796, 20158, -2642, -23062, -22703,
	-1889, 20627, 24558, 6363, -17565, -25667, -10644, 13969,
	25997, 14601, -9949, -25536, -18115, 5627, 24300, 21078,
	-1134, -22325, -23401, -3393, 19672, 25013, 7818, -16421,
	-25865, -12005, 12671, 25931, 15827, -8536, -25209, -19169,
	4142, 23721, 21928, 378, -21512, -24020, -4886, 18650,
	25383, 9246, -15221, -25975, -13326, 11329, 25777, 17000,
	-7093, -24796, -20158, 2642, 23062, 22703, 1889, -20627,
	-24558, -6363, 17565, 25667, 10644, -13969, -25997, -14601},
	{
// Carrier 28 Phase 2
	18384, 25462, 9599, -14912, -25989, -13649, 10988, 25725,
	17284, -6729, -24680, -20394, 2266, 22885, 22885, 2266,
	-20394, -24680, -6729, 17284, 25725, 10988, -13649, -25989,
	-14912, 9599, 25462, 18384, -5257, -24163, -21297, 756,
	22129, 23564, 3768, -19422, -25114, -8178, 16126, 25901,
	12339, -12339, -25901, -16126, 8178, 25114, 19422, -3768,
	-23564, -22129, -756, 21297, 24163, 5257, -18384, -25462,
	-9599, 14912, 25989, 13649, -10988, -25725, -17284, 6729,
	24680, 20394, -2266, -22885, -22885, -2266, 20394, 24680,
	6729, -17284, -25725, -10988, 13649, 25989, 14912, -9599,
	-25462, -18384, 5257, 24163, 21297, -756, -22129, -23563,
	-3768, 19422, 25114, 8178, -16126, -25901, -12339, 12339,
	25901, 16126, -8178, -25114, -19422, 3768, 23564, 22129,
	756, -21297, -24163, -5257, 18384, 25462, 9599, -14913,
	-25989, -13649, 10988, 25725, 17284, -6729, -24680, -20394,
	2266, 22885, 22885, 2266, -20394, -24680, -6729, 17284,
	25725, 10988, -13649, -25989, -14912, 9599, 25462, 18384,
	-5257, -24163, -21297, 756, 22129, 23563, 3768, -19422,
	-25114, -8178, 16126, 25901, 12339, -12339, -25901, -16126,
	8178, 25114, 19422, -3768, -23564, -22129, -756, 21297,
	24163, 5257, -18384, -25462, -9599, 14913, 25989, 13649,
	-10988, -25725, -17284, 6729, 24680, 20394, -2266, -22885,
	-22885, -2266, 20394, 24680, 6729, -17284, -25725, -10988,
	13649, 25989, 14912, -9599, -25462, -18384, 5257, 24163,
	21297, -756, -22129, -23563, -3768, 19422, 25114, 8178,
	-16126, -25901, -12339, 12339, 25901, 16126, -8178, -25114,
	-19422, 3768, 23564, 22129, 756, -21297, -24163, -5257},
	{
// Carrier 28 Phase 3
	24020, 21512, -378, -21928, -23721, -4141, 19169, 25209,
	8536, -15827, -25931, -12671, 12005, 25865, 16421, -7818,
	-25013, -19671, 3393, 23401, 22325, 1134, -21078, -24300,
	-5627, 18115, 25536, 9949, -14601, -25997, -13969, 10644,
	25667, 17565, -6363, -24558, -20627, 1889, 22703, 23062,
	2642, -20158, -24796, -7093, 17000, 25777, 11329, -13326,
	-25975, -15221, 9246, 25383, 18650, -4886, -24020, -21512,
	378, 21928, 23721, 4141, -19169, -25209, -8536, 15827,
	25931, 12671, -12005, -25865, -16421, 7818, 25013, 19671,
	-3393, -23401, -22325, -1134, 21078, 24300, 5627, -18115,
	-25536, -9949, 14601, 25997, 13969, -10644, -25667, -17565,
	6363, 24558, 20627, -1889, -22703, -23062, -2642, 20158,
	24796, 7093, -17000, -25777, -11329, 13326, 25975, 15221,
	-9246, -25383, -18650, 4886, 24020, 21512, -378, -21928,
	-23721, -4141, 19169, 25209, 8536, -15827, -25931, -12671,
	12005, 25865, 16421, -7818, -25013, -19671, 3393, 23401,
	22325, 1134, -21078, -24300, -5627, 18115, 25536, 9949,
	-14601, -25997, -13969, 10644, 25667, 17565, -6363, -24558,
	-20627, 1889, 22703, 23062, 2642, -20158, -24796, -7093,
	17000, 25777, 11329, -13326, -25975, -15221, 9246, 25383,
	18650, -4886, -24020, -21512, 378, 21928, 23721, 4141,
	-19169, -25209, -8536, 15827, 25931, 12671, -12005, -25865,
	-16421, 7818, 25013, 19671, -3393, -23401, -22325, -1134,
	21078, 24300, 5627, -18115, -25536, -9949, 14601, 25997,
	13969, -10644, -25667, -17565, 6363, 24558, 20627, -1889,
	-22703, -23062, -2642, 20158, 24796, 7093, -17000, -25777,
	-11329, 13326, 25975, 15221, -9246, -25383, -18650, 4886},
	{
// Carrier 28 Phase 4
	26000, 14287, -10298, -25605, -17842, 5996, 24432, 20855,
	-1511, -22516, -23234, -3018, 19917, 24907, 7456, -16712,
	-25824, -11668, 13000, 25956, 15526, -8892, -25299, -18911,
	4514, 23873, 21722, 0, -21722, -23873, -4514, 18911,
	25299, 8892, -15526, -25956, -12999, 11668, 25824, 16712,
	-7456, -24907, -19917, 3018, 23234, 22516, 1511, -20855,
	-24432, -5996, 17842, 25604, 10298, -14287, -26000, -14287,
	10298, 25605, 17842, -5996, -24432, -20855, 1511, 22516,
	23234, 3018, -19917, -24907, -7456, 16712, 25824, 11668,
	-13000, -25956, -15526, 8892, 25299, 18911, -4514, -23873,
	-21722, 0, 21722, 23873, 4514, -18911, -25299, -8892,
	15526, 25956, 12999, -11668, -25824, -16712, 7456, 24907,
	19917, -3018, -23234, -22516, -1511, 20855, 24431, 5995,
	-17842, -25604, -10298, 14287, 26000, 14287, -10298, -25605,
	-17842, 5996, 24432, 20855, -1511, -22516, -23234, -3018,
	19917, 24907, 7456, -16712, -25824, -11668, 13000, 25956,
	15526, -8892, -25299, -18911, 4514, 23873, 21722, 0,
	-21722, -23873, -4514, 18911, 25299, 8892, -15526, -25956,
	-12999, 11668, 25824, 16712, -7456, -24907, -19917, 3018,
	23234, 22516, 1511, -20855, -24431, -5995, 17842, 25604,
	10298, -14287, -26000, -14287, 10298, 25605, 17842, -5996,
	-24432, -20855, 1511, 22516, 23234, 3018, -19917, -24907,
	-7456, 16712, 25824, 11668, -13000, -25956, -15526, 8892,
	25299, 18911, -4514, -23873, -21722, 0, 21722, 23873,
	4514, -18911, -25299, -8892, 15526, 25956, 12999, -11668,
	-25824, -16712, 7456, 24907, 19917, -3018, -23234, -22516,
	-1511, 20855, 24431, 5995, -17842, -25604, -10298, 14287},
	{
// Carrier 28 Phase 5
	24020, 4886, -18650, -25383, -9246, 15221, 25975, 13326,
	-11329, -25777, -17000, 7093, 24796, 20158, -2642, -23062,
	-22703, -1889, 20627, 24558, 6363, -17565, -25667, -10644,
	13969, 25997, 14601, -9949, -25536, -18115, 5627, 24300,
	21078, -1134, -22325, -23401, -3393, 19671, 25013, 7818,
	-16421, -25865, -12005, 12671, 25931, 15827, -8536, -25209,
	-19169, 4141, 23721, 21928, 378, -21512, -24020, -4886,
	18650, 25383, 9246, -15221, -25975, -13326, 11329, 25777,
	17000, -7093, -24796, -20158, 2642, 23062, 22703, 1889,
	-20627, -24558, -6363, 17565, 25667, 10644, -13969, -25997,
	-14601, 9949, 25536, 18115, -5627, -24300, -21078, 1134,
	22325, 23401, 3393, -19671, -25013, -7818, 16421, 25865,
	12005, -12671, -25931, -15827, 8536, 25209, 19169, -4141,
	-23721, -21928, -378, 21512, 24020, 4886, -18650, -25383,
	-9246, 15221, 25975, 13326, -11329, -25777, -17000, 7093,
	24796, 20158, -2642, -23062, -22703, -1889, 20627, 24558,
	6363, -17565, -25667, -10644, 13969, 25997, 14601, -9949,
	-25536, -18115, 5627, 24300, 21078, -1134, -22325, -23401,
	-3393, 19672, 25013, 7818, -16421, -25865, -12005, 12671,
	25931, 15827, -8536, -25209, -19169, 4142, 23721, 21928,
	378, -21512, -24020, -4886, 18650, 25383, 9246, -15221,
	-25975, -13326, 11329, 25777, 17000, -7093, -24796, -20158,
	2642, 23062, 22703, 1889, -20627, -24558, -6363, 17565,
	25667, 10644, -13969, -25997, -14601, 9949, 25536, 18115,
	-5627, -24300, -21078, 1134, 22325, 23401, 3393, -19672,
	-25013, -7818, 16421, 25865, 12005, -12671, -25931, -15827,
	8536, 25209, 19169, -4142, -23721, -21928, -378, 21512},
	{
// Carrier 28 Phase 6
	18384, -5257, -24163, -21297, 756, 22129, 23564, 3768,
	-19422, -25114, -8178, 16126, 25901, 12339, -12339, -25901,
	-16126, 8178, 25114, 19422, -3768, -23564, -22129, -756,
	21297, 24163, 5257, -18384, -25462, -9599, 14912, 25989,
	13649, -10988, -25725, -17284, 6729, 24680, 20394, -2266,
	-22885, -22885, -2266, 20394, 24680, 6729, -17284, -25725,
	-10988, 13649, 25989, 14912, -9599, -25462, -18384, 5257,
	24163, 21297, -756, -22129, -23563, -3768, 19422, 25114,
	8178, -16126, -25901, -12339, 12339, 25901, 16126, -8178,
	-25114, -19422, 3768, 23564, 22129, 756, -21297, -24163,
	-5257, 18384, 25462, 9599, -14913, -25989, -13649, 10988,
	25725, 17284, -6729, -24680, -20394, 2266, 22885, 22885,
	2266, -20394, -24680, -6729, 17284, 25725, 10988, -13649,
	-25989, -14912, 9599, 25462, 18384, -5257, -24163, -21297,
	756, 22129, 23563, 3768, -19422, -25114, -8178, 16126,
	25901, 12339, -12339, -25901, -16126, 8178, 25114, 19422,
	-3768, -23564, -22129, -756, 21297, 24163, 5257, -18384,
	-25462, -9599, 14913, 25989, 13649, -10988, -25725, -17284,
	6729, 24680, 20394, -2266, -22885, -22885, -2266, 20394,
	24680, 6729, -17284, -25725, -10988, 13649, 25989, 14912,
	-9599, -25462, -18384, 5257, 24163, 21297, -756, -22129,
	-23563, -3768, 19422, 25114, 8178, -16126, -25901, -12339,
	12339, 25901, 16126, -8178, -25114, -19422, 3768, 23564,
	22129, 756, -21297, -24163, -5257, 18384, 25462, 9599,
	-14913, -25989, -13649, 10988, 25725, 17284, -6729, -24680,
	-20394, 2266, 22885, 22885, 2266, -20394, -24680, -6729,
	17284, 25725, 10988, -13649, -25989, -14912, 9599, 25462},
	{
// Carrier 28 Phase 7
	9949, -14601, -25997, -13969, 10644, 25667, 17565, -6363,
	-24558, -20627, 1889, 22703, 23062, 2642, -20158, -24796,
	-7093, 17000, 25777, 11329, -13326, -25975, -15221, 9246,
	25383, 18650, -4886, -24020, -21512, 378, 21928, 23721,
	4141, -19169, -25209, -8536, 15827, 25931, 12671, -12005,
	-25865, -16421, 7818, 25013, 19671, -3393, -23401, -22325,
	-1134, 21078, 24300, 5627, -18115, -25536, -9949, 14601,
	25997, 13969, -10644, -25667, -17565, 6363, 24558, 20627,
	-1889, -22703, -23062, -2642, 20158, 24796, 7093, -17000,
	-25777, -11329, 13326, 25975, 15221, -9246, -25383, -18650,
	4886, 24020, 21512, -378, -21928, -23721, -4141, 19169,
	25209, 8536, -15827, -25931, -12671, 12005, 25865, 16421,
	-7818, -25013, -19671, 3393, 23401, 22325, 1134, -21078,
	-24300, -5627, 18115, 25536, 9949, -14601, -25997, -13969,
	10644, 25667, 17565, -6363, -24558, -20627, 1889, 22703,
	23062, 2642, -20158, -24796, -7093, 17000, 25777, 11329,
	-13326, -25975, -15221, 9246, 25383, 18650, -4886, -24020,
	-21512, 378, 21928, 23721, 4141, -19169, -25209, -8536,
	15827, 25931, 12671, -12005, -25865, -16421, 7818, 25013,
	19671, -3393, -23401, -22325, -1134, 21078, 24300, 5627,
	-18115, -25536, -9949, 14601, 25997, 13969, -10644, -25667,
	-17565, 6363, 24558, 20627, -1889, -22703, -23062, -2642,
	20158, 24796, 7093, -17000, -25777, -11329, 13326, 25975,
	15221, -9246, -25383, -18650, 4886, 24020, 21512, -378,
	-21928, -23721, -4141, 19169, 25209, 8536, -15827, -25931,
	-12671, 12005, 25865, 16420, -7818, -25013, -19671, 3393,
	23401, 22325, 1134, -21078, -24300, -5627, 18115, 25536},
	},{{

// Carrier 29 Phase 0
	0, 22129, 23234, 2266, -20855, -24163, -4514, 19422,
	24907, 6729, -17842, -25462, -8892, 16126, 25824, 10988,
	-14287, -25989, -12999, 12339, 25956, 14912, -10298, -25725,
	-16712, 8178, 25299, 18384, -5996, -24680, -19917, 3768,
	23873, 21297, -1511, -22885, -22516, -756, 21722, 23563,
	3018, -20394, -24431, -5257, 18911, 25114, 7456, -17284,
	-25604, -9599, 15526, 25901, 11668, -13649, -26000, -13649,
	11668, 25901, 15526, -9599, -25605, -17284, 7457, 25114,
	18911, -5257, -24432, -20394, 3018, 23564, 21722, -756,
	-22516, -22885, -1511, 21298, 23873, 3768, -19917, -24680,
	-5995, 18384, 25299, 8177, -16712, -25725, -10297, 14913,
	25956, 12339, -13000, -25989, -14287, 10988, 25824, 16125,
	-8892, -25462, -17842, 6729, 24907, 19422, -4515, -24163,
	-20855, 2266, 23234, 22128, 0, -22129, -23234, -2265,
	20855, 24162, 4514, -19422, -24907, -6729, 17842, 25462,
	8892, -16126, -25824, -10987, 14287, 25988, 12999, -12339,
	-25956, -14912, 10298, 25725, 16712, -8178, -25299, -18384,
	5996, 24680, 19916, -3768, -23873, -21297, 1512, 22885,
	22516, 755, -21722, -23563, -3018, 20395, 24431, 5257,
	-18911, -25113, -7456, 17284, 25604, 9599, -15526, -25901,
	-11668, 13649, 26000, 13649, -11669, -25901, -15525, 9599,
	25605, 17284, -7457, -25114, -18911, 5258, 24432, 20394,
	-3018, -23564, -21722, 756, 22516, 22885, 1511, -21298,
	-23873, -3767, 19917, 24680, 5995, -18385, -25299, -8177,
	16712, 25725, 10297, -14913, -25955, -12339, 13000, 25989,
	14286, -10988, -25824, -16125, 8892, 25462, 17841, -6729,
	-24907, -19422, 4515, 24163, 20854, -2266, -23234, -22128},
	{
// Carrier 29 Phase 1
	9949, 25667, 17000, -7818, -25209, -18650, 5627, 24558,
	20158, -3393, -23721, -21512, 1134, 22703, 22703, 1134,
	-21512, -23721, -3393, 20158, 24558, 5627, -18650, -25209,
	-7818, 17000, 25667, 9949, -15221, -25931, -12005, 13326,
	25997, 13969, -11329, -25865, -15827, 9247, 25536, 17565,
	-7093, -25013, -19169, 4886, 24300, 20627, -2642, -23401,
	-21928, 378, 22325, 23062, 1888, -21078, -24020, -4141,
	19672, 24796, 6363, -18115, -25383, -8536, 16421, 25777,
	10644, -14601, -25975, -12671, 12671, 25975, 14601, -10644,
	-25777, -16420, 8536, 25383, 18115, -6363, -24796, -19671,
	4142, 24020, 21078, -1889, -23062, -22325, -377, 21928,
	23401, 2642, -20627, -24300, -4886, 19169, 25013, 7093,
	-17565, -25536, -9246, 15827, 25865, 11329, -13969, -25997,
	-13325, 12005, 25931, 15220, -9949, -25667, -17000, 7818,
	25209, 18650, -5627, -24558, -20157, 3393, 23721, 21512,
	-1134, -22703, -22703, -1133, 21512, 23721, 3393, -20158,
	-24558, -5627, 18650, 25209, 7818, -17000, -25667, -9949,
	15221, 25931, 12005, -13326, -25997, -13969, 11329, 25865,
	15827, -9247, -25536, -17565, 7094, 25013, 19168, -4887,
	-24300, -20626, 2642, 23401, 21927, -378, -22325, -23062,
	-1888, 21079, 24020, 4141, -19672, -24796, -6362, 18115,
	25383, 8535, -16421, -25777, -10643, 14601, 25975, 12670,
	-12671, -25975, -14601, 10644, 25777, 16420, -8536, -25383,
	-18115, 6363, 24796, 19671, -4142, -24021, -21078, 1889,
	23062, 22324, 377, -21928, -23401, -2642, 20627, 24299,
	4886, -19169, -25013, -7093, 17565, 25536, 9246, -15828,
	-25865, -11329, 13970, 25997, 13325, -12005, -25931, -15220},
	{
// Carrier 29 Phase 2
	18384, 25299, 8178, -16712, -25725, -10298, 14913, 25956,
	12339, -13000, -25989, -14287, 10988, 25824, 16126, -8892,
	-25462, -17842, 6729, 24907, 19422, -4514, -24163, -20855,
	2266, 23234, 22129, 0, -22129, -23234, -2265, 20855,
	24163, 4514, -19422, -24907, -6729, 17842, 25462, 8892,
	-16126, -25824, -10987, 14287, 25988, 12999, -12339, -25956,
	-14912, 10298, 25725, 16712, -8178, -25299, -18384, 5996,
	24680, 19917, -3768, -23873, -21297, 1511, 22885, 22516,
	756, -21722, -23563, -3018, 20394, 24431, 5257, -18911,
	-25114, -7456, 17284, 25604, 9599, -15526, -25901, -11668,
	13649, 26000, 13649, -11668, -25901, -15525, 9599, 25605,
	17284, -7457, -25114, -18911, 5257, 24432, 20394, -3018,
	-23564, -21722, 756, 22516, 22885, 1511, -21298, -23873,
	-3767, 19917, 24680, 5995, -18384, -25299, -8177, 16712,
	25725, 10297, -14913, -25955, -12339, 13000, 25989, 14287,
	-10988, -25824, -16125, 8892, 25462, 17842, -6729, -24907,
	-19422, 4515, 24163, 20855, -2266, -23234, -22128, 0,
	22129, 23234, 2265, -20855, -24162, -4514, 19422, 24907,
	6728, -17842, -25462, -8892, 16126, 25824, 10987, -14287,
	-25988, -12999, 12339, 25956, 14912, -10298, -25725, -16712,
	8178, 25299, 18384, -5996, -24680, -19916, 3768, 23873,
	21297, -1512, -22885, -22516, -755, 21722, 23563, 3018,
	-20395, -24431, -5257, 18912, 25113, 7456, -17285, -25604,
	-9598, 15526, 25901, 11668, -13649, -26000, -13649, 11669,
	25901, 15525, -9599, -25605, -17284, 7457, 25114, 18911,
	-5258, -24432, -20394, 3018, 23564, 21722, -756, -22516,
	-22885, -1511, 21298, 23873, 3767, -19917, -24680, -5995},
	{
// Carrier 29 Phase 3
	24020, 21078, -1889, -23062, -22325, -378, 21928, 23401,
	2642, -20627, -24300, -4886, 19169, 25013, 7093, -17565,
	-25536, -9246, 15827, 25865, 11329, -13969, -25997, -13326,
	12005, 25931, 15221, -9949, -25667, -17000, 7818, 25209,
	18650, -5627, -24558, -20158, 3393, 23721, 21512, -1134,
	-22703, -22703, -1133, 21512, 23721, 3393, -20158, -24558,
	-5627, 18650, 25209, 7818, -17000, -25667, -9949, 15221,
	25931, 12005, -13326, -25997, -13969, 11329, 25865, 15827,
	-9247, -25536, -17565, 7094, 25013, 19169, -4886, -24300,
	-20627, 2642, 23401, 21928, -378, -22325, -23062, -1888,
	21078, 24020, 4141, -19672, -24796, -6363, 18115, 25383,
	8536, -16421, -25777, -10643, 14601, 25975, 12670, -12671,
	-25975, -14601, 10644, 25777, 16420, -8536, -25383, -18115,
	6363, 24796, 19671, -4142, -24020, -21078, 1889, 23062,
	22325, 377, -21928, -23401, -2642, 20627, 24299, 4886,
	-19169, -25013, -7093, 17565, 25536, 9246, -15828, -25865,
	-11329, 13970, 25997, 13325, -12005, -25931, -15220, 9950,
	25668, 17000, -7818, -25209, -18649, 5627, 24558, 20157,
	-3394, -23721, -21512, 1134, 22703, 22703, 1133, -21512,
	-23721, -3393, 20158, 24558, 5627, -18650, -25209, -7817,
	17000, 25667, 9949, -15221, -25931, -12005, 13326, 25997,
	13969, -11329, -25865, -15827, 9247, 25536, 17565, -7094,
	-25013, -19168, 4887, 24300, 20626, -2642, -23401, -21927,
	378, 22325, 23062, 1888, -21079, -24020, -4141, 19672,
	24796, 6362, -18115, -25383, -8535, 16421, 25777, 10643,
	-14602, -25975, -12670, 12671, 25975, 14601, -10644, -25777,
	-16420, 8536, 25383, 18115, -6363, -24796, -19671, 4142},
	{
// Carrier 29 Phase 4
	26000, 13649, -11668, -25901, -15526, 9599, 25605, 17284,
	-7456, -25114, -18911, 5257, 24432, 20394, -3018, -23564,
	-21722, 756, 22516, 22885, 1511, -21297, -23873, -3768,
	19917, 24680, 5995, -18384, -25299, -8178, 16712, 25725,
	10298, -14913, -25956, -12339, 13000, 25989, 14287, -10988,
	-25824, -16126, 8892, 25462, 17842, -6729, -24907, -19422,
	4514, 24163, 20855, -2266, -23234, -22128, 0, 22129,
	23234, 2265, -20855, -24162, -4514, 19422, 24907, 6729,
	-17842, -25462, -8892, 16126, 25824, 10987, -14287, -25988,
	-12999, 12339, 25956, 14912, -10298, -25725, -16712, 8178,
	25299, 18384, -5996, -24680, -19917, 3768, 23873, 21297,
	-1511, -22885, -22516, -756, 21722, 23563, 3018, -20394,
	-24431, -5257, 18911, 25114, 7456, -17284, -25604, -9599,
	15526, 25901, 11668, -13649, -26000, -13649, 11669, 25901,
	15525, -9599, -25605, -17284, 7457, 25114, 18911, -5257,
	-24432, -20394, 3018, 23564, 21722, -756, -22516, -22885,
	-1511, 21298, 23873, 3767, -19917, -24680, -5995, 18385,
	25299, 8177, -16712, -25725, -10297, 14913, 25955, 12339,
	-13000, -25989, -14286, 10988, 25824, 16125, -8892, -25462,
	-17842, 6729, 24907, 19422, -4515, -24163, -20854, 2266,
	23234, 22128, 0, -22129, -23234, -2265, 20855, 24162,
	4514, -19422, -24907, -6728, 17842, 25462, 8892, -16126,
	-25824, -10987, 14287, 25988, 12999, -12339, -25956, -14912,
	10298, 25725, 16712, -8178, -25299, -18384, 5996, 24680,
	19916, -3768, -23873, -21297, 1512, 22885, 22516, 755,
	-21722, -23563, -3017, 20395, 24431, 5257, -18912, -25113,
	-7456, 17285, 25604, 9598, -15526, -25901, -11668, 13649},
	{
// Carrier 29 Phase 5
	24020, 4141, -19671, -24796, -6363, 18115, 25383, 8536,
	-16421, -25777, -10644, 14601, 25975, 12671, -12671, -25975,
	-14601, 10644, 25777, 16421, -8536, -25383, -18115, 6363,
	24796, 19671, -4142, -24020, -21078, 1889, 23062, 22325,
	378, -21928, -23401, -2642, 20627, 24300, 4886, -19169,
	-25013, -7093, 17565, 25536, 9246, -15827, -25865, -11329,
	13969, 25997, 13326, -12005, -25931, -15221, 9949, 25667,
	17000, -7818, -25209, -18650, 5627, 24558, 20158, -3393,
	-23721, -21512, 1134, 22703, 22703, 1133, -21512, -23721,
	-3393, 20158, 24558, 5627, -18650, -25209, -7818, 17000,
	25667, 9949, -15221, -25931, -12005, 13326, 25997, 13969,
	-11329, -25865, -15827, 9247, 25536, 17565, -7094, -25013,
	-19169, 4886, 24300, 20627, -2642, -23401, -21928, 378,
	22325, 23062, 1888, -21078, -24020, -4141, 19672, 24796,
	6363, -18115, -25383, -8536, 16421, 25777, 10643, -14601,
	-25975, -12670, 12671, 25975, 14601, -10644, -25777, -16420,
	8536, 25383, 18115, -6363, -24796, -19671, 4142, 24020,
	21078, -1889, -23062, -22325, -377, 21928, 23401, 2642,
	-20627, -24299, -4886, 19169, 25013, 7093, -17565, -25536,
	-9246, 15828, 25865, 11329, -13970, -25997, -13325, 12005,
	25931, 15220, -9950, -25668, -17000, 7818, 25209, 18649,
	-5627, -24558, -20157, 3394, 23721, 21512, -1134, -22703,
	-22703, -1133, 21512, 23721, 3393, -20158, -24558, -5627,
	18650, 25209, 7817, -17000, -25667, -9949, 15221, 25931,
	12005, -13326, -25997, -13969, 11330, 25865, 15827, -9247,
	-25536, -17565, 7094, 25013, 19168, -4887, -24300, -20626,
	2642, 23401, 21927, -378, -22325, -23062, -1888, 21079},
	{
// Carrier 29 Phase 6
	18384, -5996, -24680, -19917, 3768, 23873, 21297, -1511,
	-22885, -22516, -756, 21722, 23563, 3018, -20394, -24431,
	-5257, 18911, 25114, 7456, -17284, -25604, -9599, 15526,
	25901, 11668, -13649, -26000, -13649, 11668, 25901, 15526,
	-9599, -25605, -17284, 7456, 25114, 18911, -5257, -24432,
	-20394, 3018, 23564, 21722, -756, -22516, -22885, -1511,
	21298, 23873, 3768, -19917, -24680, -5995, 18384, 25299,
	8178, -16712, -25725, -10297, 14913, 25956, 12339, -13000,
	-25989, -14287, 10988, 25824, 16125, -8892, -25462, -17842,
	6729, 24907, 19422, -4515, -24163, -20855, 2266, 23234,
	22128, 0, -22129, -23234, -2265, 20855, 24162, 4514,
	-19422, -24907, -6729, 17842, 25462, 8892, -16126, -25824,
	-10987, 14287, 25988, 12999, -12339, -25956, -14912, 10298,
	25725, 16712, -8178, -25299, -18384, 5996, 24680, 19916,
	-3768, -23873, -21297, 1512, 22885, 22516, 755, -21722,
	-23563, -3018, 20394, 24431, 5257, -18911, -25113, -7456,
	17284, 25604, 9599, -15526, -25901, -11668, 13649, 26000,
	13649, -11669, -25901, -15525, 9599, 25605, 17284, -7457,
	-25114, -18911, 5257, 24432, 20394, -3018, -23564, -21722,
	756, 22516, 22885, 1511, -21298, -23873, -3767, 19917,
	24680, 5995, -18385, -25299, -8177, 16712, 25725, 10297,
	-14913, -25955, -12339, 13000, 25989, 14286, -10988, -25824,
	-16125, 8892, 25462, 17841, -6729, -24907, -19422, 4515,
	24163, 20854, -2266, -23234, -22128, 0, 22129, 23234,
	2265, -20855, -24162, -4514, 19422, 24907, 6728, -17842,
	-25462, -8892, 16126, 25824, 10987, -14287, -25988, -12999,
	12340, 25956, 14912, -10298, -25725, -16712, 8178, 25299},
	{
// Carrier 29 Phase 7
	9949, -15221, -25931, -12005, 13326, 25997, 13969, -11329,
	-25865, -15827, 9246, 25536, 17565, -7093, -25013, -19169,
	4886, 24300, 20627, -2642, -23401, -21928, 378, 22325,
	23062, 1889, -21078, -24020, -4141, 19672, 24796, 6363,
	-18115, -25383, -8536, 16421, 25777, 10644, -14601, -25975,
	-12671, 12671, 25975, 14601, -10644, -25777, -16420, 8536,
	25383, 18115, -6363, -24796, -19671, 4142, 24020, 21078,
	-1889, -23062, -22325, -378, 21928, 23401, 2642, -20627,
	-24300, -4886, 19169, 25013, 7093, -17565, -25536, -9246,
	15827, 25865, 11329, -13969, -25997, -13325, 12005, 25931,
	15221, -9949, -25667, -17000, 7818, 25209, 18650, -5627,
	-24558, -20157, 3393, 23721, 21512, -1134, -22703, -22703,
	-1133, 21512, 23721, 3393, -20158, -24558, -5627, 18650,
	25209, 7818, -17000, -25667, -9949, 15221, 25931, 12005,
	-13326, -25997, -13969, 11329, 25865, 15827, -9247, -25536,
	-17565, 7094, 25013, 19169, -4887, -24300, -20627, 2642,
	23401, 21928, -378, -22325, -23062, -1888, 21078, 24020,
	4141, -19672, -24796, -6363, 18115, 25383, 8535, -16421,
	-25777, -10643, 14601, 25975, 12670, -12671, -25975, -14601,
	10644, 25777, 16420, -8536, -25383, -18115, 6363, 24796,
	19671, -4142, -24021, -21078, 1889, 23062, 22325, 377,
	-21928, -23401, -2642, 20627, 24299, 4886, -19169, -25013,
	-7093, 17565, 25536, 9246, -15828, -25865, -11329, 13970,
	25997, 13325, -12005, -25931, -15220, 9950, 25668, 17000,
	-7818, -25209, -18649, 5627, 24558, 20157, -3394, -23721,
	-21512, 1134, 22703, 22703, 1133, -21512, -23721, -3393,
	20158, 24558, 5626, -18650, -25209, -7817, 17000, 25667},
	},{{

// Carrier 30 Phase 0
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22517,
	0, 22516, 22517, 0, -22516, -22517, 0, 22516,
	22517, 0, -22516, -22517, 0, 22516, 22517, 0,
	-22516, -22517, 0, 22516, 22517, 0, -22516, -22517,
	0, 22516, 22517, 0, -22516, -22517, 0, 22516,
	22517, 0, -22516, -22517, 0, 22516, 22517, 0,
	-22516, -22517, 0, 22516, 22517, 0, -22516, -22517},
	{
// Carrier 30 Phase 1
	9949, 25777, 15827, -9949, -25777, -15827, 9949, 25777,
	15827, -9949, -25777, -15827, 9949, 25777, 15827, -9949,
	-25777, -15827, 9949, 25777, 15827, -9949, -25777, -15827,
	9949, 25777, 15827, -9949, -25777, -15827, 9949, 25777,
	15827, -9949, -25777, -15827, 9949, 25777, 15827, -9949,
	-25777, -15827, 9949, 25777, 15827, -9949, -25777, -15827,
	9949, 25777, 15827, -9949, -25777, -15827, 9949, 25777,
	15827, -9949, -25777, -15827, 9949, 25777, 15827, -9949,
	-25777, -15827, 9949, 25777, 15827, -9949, -25777, -15827,
	9949, 25777, 15827, -9949, -25777, -15827, 9949, 25777,
	15827, -9949, -25777, -15827, 9949, 25777, 15827, -9949,
	-25777, -15827, 9949, 25777, 15827, -9949, -25777, -15827,
	9949, 25777, 15827, -9949, -25777, -15827, 9949, 25777,
	15827, -9949, -25777, -15827, 9949, 25777, 15827, -9949,
	-25777, -15827, 9949, 25777, 15827, -9949, -25777, -15828,
	9949, 25777, 15828, -9949, -25777, -15828, 9949, 25777,
	15828, -9949, -25777, -15828, 9949, 25777, 15828, -9949,
	-25777, -15828, 9949, 25777, 15828, -9949, -25777, -15828,
	9949, 25777, 15828, -9949, -25777, -15828, 9949, 25777,
	15828, -9949, -25777, -15828, 9949, 25777, 15828, -9949,
	-25777, -15828, 9949, 25777, 15828, -9949, -25777, -15828,
	9949, 25777, 15828, -9949, -25777, -15828, 9949, 25777,
	15828, -9949, -25777, -15828, 9949, 25777, 15828, -9949,
	-25777, -15828, 9949, 25777, 15828, -9949, -25777, -15828,
	9949, 25777, 15828, -9949, -25777, -15828, 9949, 25777,
	15828, -9949, -25777, -15828, 9949, 25777, 15828, -9949,
	-25777, -15828, 9949, 25777, 15828, -9949, -25777, -15828},
	{
// Carrier 30 Phase 2
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729},
	{
// Carrier 30 Phase 3
	24020, 20627, -3393, -24020, -20627, 3393, 24020, 20627,
	-3393, -24020, -20627, 3393, 24020, 20627, -3393, -24020,
	-20627, 3393, 24020, 20627, -3393, -24020, -20627, 3393,
	24020, 20627, -3393, -24020, -20627, 3393, 24020, 20627,
	-3393, -24020, -20627, 3393, 24020, 20627, -3393, -24020,
	-20627, 3393, 24020, 20627, -3393, -24020, -20627, 3393,
	24020, 20627, -3393, -24020, -20627, 3393, 24020, 20627,
	-3393, -24020, -20627, 3393, 24020, 20627, -3393, -24020,
	-20627, 3393, 24020, 20627, -3393, -24020, -20627, 3393,
	24020, 20627, -3393, -24020, -20627, 3393, 24020, 20627,
	-3393, -24020, -20627, 3393, 24020, 20627, -3393, -24020,
	-20627, 3393, 24020, 20627, -3393, -24020, -20627, 3393,
	24020, 20627, -3393, -24020, -20627, 3393, 24020, 20627,
	-3393, -24020, -20627, 3393, 24020, 20627, -3393, -24020,
	-20627, 3393, 24020, 20627, -3393, -24020, -20627, 3393,
	24020, 20627, -3393, -24020, -20627, 3393, 24020, 20627,
	-3393, -24020, -20627, 3393, 24020, 20627, -3393, -24020,
	-20627, 3393, 24020, 20627, -3393, -24020, -20627, 3393,
	24020, 20627, -3393, -24020, -20627, 3393, 24020, 20627,
	-3393, -24020, -20627, 3393, 24020, 20627, -3393, -24020,
	-20627, 3393, 24020, 20627, -3393, -24020, -20627, 3393,
	24020, 20627, -3393, -24020, -20627, 3393, 24020, 20627,
	-3393, -24020, -20627, 3393, 24020, 20627, -3393, -24020,
	-20627, 3393, 24020, 20627, -3393, -24020, -20627, 3393,
	24020, 20627, -3393, -24020, -20627, 3393, 24020, 20627,
	-3393, -24020, -20627, 3393, 24020, 20627, -3393, -24020,
	-20627, 3393, 24020, 20627, -3393, -24020, -20627, 3393},
	{
// Carrier 30 Phase 4
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999},
	{
// Carrier 30 Phase 5
	24020, 3393, -20627, -24020, -3393, 20627, 24020, 3393,
	-20627, -24020, -3393, 20627, 24020, 3393, -20627, -24020,
	-3393, 20627, 24020, 3393, -20627, -24020, -3393, 20627,
	24020, 3393, -20627, -24020, -3393, 20627, 24020, 3393,
	-20627, -24020, -3393, 20627, 24020, 3393, -20627, -24020,
	-3393, 20627, 24020, 3393, -20627, -24020, -3393, 20627,
	24020, 3393, -20627, -24020, -3393, 20627, 24020, 3393,
	-20627, -24020, -3393, 20627, 24020, 3393, -20627, -24020,
	-3393, 20627, 24020, 3393, -20627, -24020, -3393, 20627,
	24020, 3393, -20627, -24020, -3393, 20627, 24020, 3393,
	-20627, -24020, -3393, 20627, 24020, 3393, -20627, -24020,
	-3393, 20627, 24020, 3393, -20627, -24020, -3393, 20627,
	24020, 3393, -20627, -24020, -3393, 20627, 24020, 3393,
	-20627, -24020, -3393, 20627, 24020, 3393, -20627, -24020,
	-3393, 20627, 24020, 3393, -20627, -24020, -3393, 20627,
	24020, 3393, -20627, -24020, -3393, 20627, 24020, 3393,
	-20627, -24020, -3393, 20627, 24020, 3393, -20627, -24020,
	-3393, 20627, 24020, 3393, -20627, -24020, -3393, 20626,
	24020, 3393, -20626, -24020, -3394, 20626, 24020, 3394,
	-20626, -24020, -3394, 20626, 24020, 3394, -20626, -24020,
	-3394, 20626, 24021, 3394, -20626, -24021, -3394, 20626,
	24021, 3394, -20626, -24021, -3394, 20626, 24021, 3394,
	-20626, -24021, -3394, 20626, 24021, 3394, -20626, -24021,
	-3394, 20626, 24021, 3394, -20626, -24021, -3394, 20626,
	24021, 3394, -20626, -24021, -3394, 20626, 24021, 3394,
	-20626, -24021, -3394, 20626, 24021, 3394, -20626, -24021,
	-3394, 20626, 24021, 3394, -20626, -24021, -3394, 20626},
	{
// Carrier 30 Phase 6
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25113, 18384, -6729, -25113, -18384,
	6729, 25113, 18384, -6729, -25113, -18384, 6729, 25113,
	18384, -6729, -25113, -18384, 6728, 25113, 18384, -6728,
	-25113, -18385, 6728, 25113, 18385, -6728, -25113, -18385,
	6728, 25113, 18385, -6728, -25113, -18385, 6728, 25113,
	18385, -6728, -25113, -18385, 6728, 25113, 18385, -6728,
	-25113, -18385, 6728, 25113, 18385, -6728, -25113, -18385,
	6728, 25113, 18385, -6728, -25113, -18385, 6728, 25113,
	18385, -6728, -25113, -18385, 6728, 25113, 18385, -6728,
	-25113, -18385, 6728, 25113, 18385, -6728, -25113, -18385,
	6728, 25113, 18385, -6728, -25113, -18385, 6728, 25113},
	{
// Carrier 30 Phase 7
	9949, -15827, -25777, -9949, 15827, 25777, 9949, -15827,
	-25777, -9949, 15827, 25777, 9949, -15827, -25777, -9949,
	15827, 25777, 9949, -15827, -25777, -9949, 15827, 25777,
	9949, -15827, -25777, -9949, 15827, 25777, 9949, -15827,
	-25777, -9949, 15827, 25777, 9949, -15827, -25777, -9949,
	15827, 25777, 9949, -15827, -25777, -9949, 15827, 25777,
	9949, -15827, -25777, -9949, 15827, 25777, 9949, -15827,
	-25777, -9949, 15827, 25777, 9949, -15827, -25777, -9949,
	15827, 25777, 9949, -15827, -25777, -9949, 15827, 25777,
	9949, -15827, -25777, -9949, 15827, 25777, 9949, -15827,
	-25777, -9949, 15827, 25777, 9949, -15827, -25777, -9949,
	15827, 25777, 9949, -15827, -25777, -9949, 15827, 25777,
	9949, -15827, -25777, -9949, 15827, 25777, 9949, -15827,
	-25777, -9949, 15827, 25777, 9949, -15827, -25777, -9949,
	15827, 25777, 9949, -15827, -25777, -9949, 15827, 25777,
	9949, -15827, -25777, -9950, 15827, 25777, 9950, -15827,
	-25777, -9950, 15827, 25777, 9950, -15827, -25777, -9950,
	15827, 25777, 9950, -15827, -25777, -9950, 15827, 25777,
	9950, -15827, -25777, -9950, 15827, 25777, 9950, -15827,
	-25777, -9950, 15827, 25777, 9950, -15827, -25777, -9950,
	15827, 25777, 9950, -15827, -25777, -9950, 15827, 25777,
	9950, -15827, -25777, -9950, 15827, 25777, 9950, -15827,
	-25777, -9950, 15827, 25777, 9950, -15827, -25777, -9950,
	15827, 25777, 9950, -15827, -25777, -9950, 15827, 25777,
	9950, -15827, -25777, -9950, 15827, 25777, 9950, -15827,
	-25777, -9950, 15827, 25777, 9950, -15827, -25777, -9950,
	15827, 25777, 9950, -15827, -25777, -9950, 15827, 25777},
	},{{

// Carrier 31 Phase 0
	0, 22885, 21722, -2266, -23873, -20394, 4514, 24680,
	18911, -6729, -25299, -17284, 8892, 25725, 15526, -10988,
	-25956, -13649, 13000, 25989, 11668, -14913, -25824, -9599,
	16712, 25462, 7456, -18384, -24907, -5257, 19917, 24163,
	3018, -21297, -23234, -756, 22516, 22128, -1511, -23564,
	-20855, 3768, 24432, 19422, -5996, -25114, -17842, 8178,
	25605, 16126, -10298, -25901, -14287, 12339, 26000, 12339,
	-14287, -25901, -10297, 16126, 25604, 8178, -17842, -25114,
	-5995, 19422, 24431, 3768, -20855, -23563, -1511, 22129,
	22516, -756, -23234, -21297, 3018, 24163, 19917, -5257,
	-24907, -18384, 7457, 25462, 16712, -9599, -25824, -14912,
	11668, 25989, 12999, -13649, -25956, -10987, 15526, 25725,
	8892, -17284, -25299, -6729, 18911, 24680, 4514, -20394,
	-23873, -2265, 21722, 22885, 0, -22885, -21722, 2266,
	23873, 20394, -4515, -24680, -18911, 6729, 25299, 17284,
	-8892, -25725, -15525, 10988, 25956, 13649, -13000, -25988,
	-11668, 14913, 25824, 9599, -16712, -25462, -7456, 18384,
	24907, 5257, -19917, -24162, -3018, 21298, 23234, 755,
	-22516, -22128, 1512, 23564, 20855, -3768, -24432, -19422,
	5996, 25114, 17842, -8178, -25605, -16125, 10298, 25901,
	14287, -12339, -26000, -12339, 14287, 25901, 10297, -16126,
	-25604, -8177, 17842, 25113, 5995, -19422, -24431, -3767,
	20855, 23563, 1511, -22129, -22516, 756, 23234, 21297,
	-3018, -24163, -19916, 5257, 24907, 18384, -7457, -25462,
	-16712, 9599, 25824, 14912, -11669, -25989, -12999, 13649,
	25955, 10987, -15526, -25725, -8892, 17284, 25299, 6728,
	-18911, -24680, -4514, 20395, 23873, 2265, -21722, -22885},
	{
// Carrier 31 Phase 1
	9949, 25865, 14601, -12005, -25997, -12671, 13969, 25931,
	10644, -15827, -25667, -8536, 17565, 25209, 6363, -19169,
	-24558, -4141, 20627, 23721, 1889, -21928, -22703, 378,
	23062, 21512, -2642, -24020, -20158, 4886, 24796, 18650,
	-7093, -25383, -17000, 9246, 25777, 15221, -11329, -25975,
	-13326, 13326, 25975, 11329, -15221, -25777, -9246, 17000,
	25383, 7093, -18650, -24796, -4886, 20158, 24020, 2642,
	-21512, -23062, -378, 22703, 21928, -1889, -23721, -20627,
	4142, 24558, 19169, -6363, -25209, -17565, 8536, 25667,
	15827, -10644, -25931, -13969, 12671, 25997, 12005, -14601,
	-25865, -9949, 16421, 25536, 7818, -18115, -25013, -5627,
	19672, 24300, 3393, -21078, -23401, -1133, 22325, 22325,
	-1134, -23401, -21078, 3393, 24300, 19671, -5627, -25013,
	-18115, 7818, 25536, 16420, -9949, -25865, -14601, 12005,
	25997, 12670, -13969, -25931, -10644, 15827, 25667, 8536,
	-17565, -25209, -6363, 19169, 24558, 4141, -20627, -23721,
	-1888, 21928, 22703, -378, -23062, -21512, 2642, 24020,
	20157, -4887, -24796, -18650, 7094, 25383, 17000, -9247,
	-25777, -15220, 11329, 25975, 13325, -13326, -25975, -11329,
	15221, 25777, 9246, -17000, -25383, -7093, 18650, 24796,
	4886, -20158, -24020, -2642, 21512, 23062, 377, -22703,
	-21928, 1889, 23721, 20627, -4142, -24558, -19169, 6363,
	25209, 17565, -8536, -25668, -15827, 10644, 25931, 13969,
	-12671, -25997, -12005, 14601, 25865, 9949, -16421, -25536,
	-7818, 18115, 25013, 5627, -19672, -24299, -3393, 21079,
	23401, 1133, -22325, -22325, 1134, 23401, 21078, -3394,
	-24300, -19671, 5627, 25013, 18115, -7818, -25536, -16420},
	{
// Carrier 31 Phase 2
	18384, 24907, 5257, -19917, -24163, -3018, 21297, 23234,
	756, -22516, -22129, 1511, 23564, 20855, -3768, -24432,
	-19422, 5996, 25114, 17842, -8178, -25605, -16126, 10298,
	25901, 14287, -12339, -26000, -12339, 14287, 25901, 10298,
	-16126, -25604, -8178, 17842, 25114, 5995, -19422, -24431,
	-3768, 20855, 23563, 1511, -22129, -22516, 756, 23234,
	21297, -3018, -24163, -19917, 5257, 24907, 18384, -7456,
	-25462, -16712, 9599, 25824, 14912, -11668, -25989, -12999,
	13649, 25956, 10987, -15526, -25725, -8892, 17284, 25299,
	6729, -18911, -24680, -4514, 20394, 23873, 2265, -21722,
	-22885, 0, 22885, 21722, -2266, -23873, -20394, 4514,
	24680, 18911, -6729, -25299, -17284, 8892, 25725, 15525,
	-10988, -25956, -13649, 13000, 25988, 11668, -14913, -25824,
	-9599, 16712, 25462, 7456, -18384, -24907, -5257, 19917,
	24162, 3018, -21298, -23234, -756, 22516, 22128, -1511,
	-23564, -20855, 3768, 24432, 19422, -5996, -25114, -17842,
	8178, 25605, 16125, -10298, -25901, -14287, 12339, 26000,
	12339, -14287, -25901, -10297, 16126, 25604, 8177, -17842,
	-25114, -5995, 19422, 24431, 3767, -20855, -23563, -1511,
	22129, 22516, -756, -23234, -21297, 3018, 24163, 19916,
	-5257, -24907, -18384, 7457, 25462, 16712, -9599, -25824,
	-14912, 11669, 25989, 12999, -13649, -25955, -10987, 15526,
	25725, 8892, -17284, -25299, -6729, 18911, 24680, 4514,
	-20395, -23873, -2265, 21722, 22885, 0, -22885, -21722,
	2266, 23873, 20394, -4515, -24680, -18911, 6729, 25299,
	17284, -8892, -25725, -15525, 10988, 25956, 13649, -13000,
	-25988, -11668, 14913, 25824, 9599, -16712, -25462, -7456},
	{
// Carrier 31 Phase 3
	24020, 20158, -4886, -24796, -18650, 7093, 25383, 17000,
	-9246, -25777, -15221, 11329, 25975, 13326, -13326, -25975,
	-11329, 15221, 25777, 9246, -17000, -25383, -7093, 18650,
	24796, 4886, -20158, -24020, -2642, 21512, 23062, 378,
	-22703, -21928, 1889, 23721, 20627, -4142, -24558, -19169,
	6363, 25209, 17565, -8536, -25667, -15827, 10644, 25931,
	13969, -12671, -25997, -12005, 14601, 25865, 9949, -16421,
	-25536, -7818, 18115, 25013, 5627, -19672, -24300, -3393,
	21078, 23401, 1134, -22325, -22325, 1134, 23401, 21078,
	-3393, -24300, -19671, 5627, 25013, 18115, -7818, -25536,
	-16420, 9949, 25865, 14601, -12005, -25997, -12671, 13969,
	25931, 10644, -15827, -25667, -8536, 17565, 25209, 6363,
	-19169, -24558, -4141, 20627, 23721, 1888, -21928, -22703,
	378, 23062, 21512, -2642, -24020, -20157, 4886, 24796,
	18650, -7094, -25383, -17000, 9247, 25777, 15221, -11329,
	-25975, -13325, 13326, 25975, 11329, -15221, -25777, -9246,
	17000, 25383, 7093, -18650, -24796, -4886, 20158, 24020,
	2642, -21512, -23062, -377, 22703, 21928, -1889, -23721,
	-20627, 4142, 24558, 19169, -6363, -25209, -17565, 8536,
	25667, 15827, -10644, -25931, -13969, 12671, 25997, 12005,
	-14601, -25865, -9949, 16421, 25536, 7818, -18115, -25013,
	-5627, 19672, 24299, 3393, -21078, -23401, -1133, 22325,
	22325, -1134, -23401, -21078, 3393, 24300, 19671, -5627,
	-25013, -18115, 7818, 25536, 16420, -9950, -25865, -14601,
	12005, 25997, 12670, -13970, -25931, -10643, 15828, 25667,
	8535, -17565, -25209, -6362, 19169, 24558, 4141, -20627,
	-23721, -1888, 21928, 22703, -378, -23062, -21512, 2642},
	{
// Carrier 31 Phase 4
	26000, 12339, -14287, -25901, -10298, 16126, 25605, 8178,
	-17842, -25114, -5996, 19422, 24432, 3768, -20855, -23563,
	-1511, 22129, 22516, -756, -23234, -21297, 3018, 24163,
	19917, -5257, -24907, -18384, 7456, 25462, 16712, -9599,
	-25824, -14912, 11668, 25989, 12999, -13649, -25956, -10988,
	15526, 25725, 8892, -17284, -25299, -6729, 18911, 24680,
	4514, -20394, -23873, -2265, 21722, 22885, 0, -22885,
	-21722, 2266, 23873, 20394, -4514, -24680, -18911, 6729,
	25299, 17284, -8892, -25725, -15526, 10988, 25956, 13649,
	-13000, -25988, -11668, 14913, 25824, 9599, -16712, -25462,
	-7456, 18384, 24907, 5257, -19917, -24162, -3018, 21298,
	23234, 756, -22516, -22128, 1511, 23564, 20855, -3768,
	-24432, -19422, 5996, 25114, 17842, -8178, -25605, -16125,
	10298, 25901, 14287, -12339, -26000, -12339, 14287, 25901,
	10297, -16126, -25604, -8177, 17842, 25114, 5995, -19422,
	-24431, -3768, 20855, 23563, 1511, -22129, -22516, 756,
	23234, 21297, -3018, -24163, -19917, 5257, 24907, 18384,
	-7457, -25462, -16712, 9599, 25824, 14912, -11668, -25989,
	-12999, 13649, 25955, 10987, -15526, -25725, -8892, 17284,
	25299, 6729, -18911, -24680, -4514, 20394, 23873, 2265,
	-21722, -22885, 0, 22885, 21722, -2266, -23873, -20394,
	4515, 24680, 18911, -6729, -25299, -17284, 8892, 25725,
	15525, -10988, -25956, -13649, 13000, 25988, 11668, -14913,
	-25824, -9599, 16712, 25462, 7456, -18385, -24907, -5257,
	19917, 24162, 3018, -21298, -23234, -755, 22516, 22128,
	-1512, -23564, -20855, 3768, 24432, 19422, -5996, -25114,
	-17842, 8178, 25605, 16125, -10298, -25901, -14286, 12339},
	{
// Carrier 31 Phase 5
	24020, 2642, -21512, -23062, -378, 22703, 21928, -1889,
	-23721, -20627, 4141, 24558, 19169, -6363, -25209, -17565,
	8536, 25667, 15827, -10644, -25931, -13969, 12671, 25997,
	12005, -14601, -25865, -9949, 16421, 25536, 7818, -18115,
	-25013, -5627, 19672, 24300, 3393, -21078, -23401, -1134,
	22325, 22325, -1134, -23401, -21078, 3393, 24300, 19671,
	-5627, -25013, -18115, 7818, 25536, 16420, -9949, -25865,
	-14601, 12005, 25997, 12671, -13969, -25931, -10644, 15827,
	25667, 8536, -17565, -25209, -6363, 19169, 24558, 4141,
	-20627, -23721, -1889, 21928, 22703, -378, -23062, -21512,
	2642, 24020, 20158, -4886, -24796, -18650, 7093, 25383,
	17000, -9247, -25777, -15221, 11329, 25975, 13325, -13326,
	-25975, -11329, 15221, 25777, 9246, -17000, -25383, -7093,
	18650, 24796, 4886, -20158, -24020, -2642, 21512, 23062,
	377, -22703, -21928, 1889, 23721, 20627, -4142, -24558,
	-19169, 6363, 25209, 17565, -8536, -25667, -15827, 10644,
	25931, 13969, -12671, -25997, -12005, 14601, 25865, 9949,
	-16421, -25536, -7818, 18115, 25013, 5627, -19672, -24300,
	-3393, 21078, 23401, 1133, -22325, -22325, 1134, 23401,
	21078, -3393, -24300, -19671, 5627, 25013, 18115, -7818,
	-25536, -16420, 9950, 25865, 14601, -12005, -25997, -12670,
	13970, 25931, 10643, -15828, -25667, -8535, 17565, 25209,
	6363, -19169, -24558, -4141, 20627, 23721, 1888, -21928,
	-22703, 378, 23062, 21512, -2642, -24020, -20157, 4887,
	24796, 18649, -7094, -25383, -17000, 9247, 25777, 15220,
	-11329, -25975, -13325, 13326, 25975, 11329, -15221, -25777,
	-9246, 17000, 25383, 7093, -18650, -24796, -4886, 20158},
	{
// Carrier 31 Phase 6
	18384, -7456, -25462, -16712, 9599, 25824, 14912, -11668,
	-25989, -12999, 13649, 25956, 10988, -15526, -25725, -8892,
	17284, 25299, 6729, -18911, -24680, -4514, 20394, 23873,
	2266, -21722, -22885, 0, 22885, 21722, -2266, -23873,
	-20394, 4514, 24680, 18911, -6729, -25299, -17284, 8892,
	25725, 15526, -10988, -25956, -13649, 13000, 25988, 11668,
	-14913, -25824, -9599, 16712, 25462, 7456, -18384, -24907,
	-5257, 19917, 24162, 3018, -21298, -23234, -756, 22516,
	22128, -1511, -23564, -20855, 3768, 24432, 19422, -5996,
	-25114, -17842, 8178, 25605, 16126, -10298, -25901, -14287,
	12339, 26000, 12339, -14287, -25901, -10297, 16126, 25604,
	8178, -17842, -25114, -5995, 19422, 24431, 3768, -20855,
	-23563, -1511, 22129, 22516, -756, -23234, -21297, 3018,
	24163, 19917, -5257, -24907, -18384, 7457, 25462, 16712,
	-9599, -25824, -14912, 11668, 25989, 12999, -13649, -25956,
	-10987, 15526, 25725, 8892, -17284, -25299, -6729, 18911,
	24680, 4514, -20394, -23873, -2265, 21722, 22885, 0,
	-22885, -21722, 2266, 23873, 20394, -4515, -24680, -18911,
	6729, 25299, 17284, -8892, -25725, -15525, 10988, 25956,
	13649, -13000, -25988, -11668, 14913, 25824, 9599, -16712,
	-25462, -7456, 18384, 24907, 5257, -19917, -24162, -3018,
	21298, 23234, 755, -22516, -22128, 1512, 23564, 20855,
	-3768, -24432, -19422, 5996, 25114, 17842, -8178, -25605,
	-16125, 10298, 25901, 14286, -12339, -26000, -12339, 14287,
	25901, 10297, -16126, -25604, -8177, 17842, 25113, 5995,
	-19422, -24431, -3767, 20855, 23563, 1511, -22129, -22516,
	756, 23234, 21297, -3018, -24163, -19916, 5258, 24907},
	{
// Carrier 31 Phase 7
	9949, -16421, -25536, -7818, 18115, 25013, 5627, -19671,
	-24300, -3393, 21078, 23401, 1134, -22325, -22325, 1134,
	23401, 21078, -3393, -24300, -19671, 5627, 25013, 18115,
	-7818, -25536, -16421, 9949, 25865, 14601, -12005, -25997,
	-12671, 13969, 25931, 10644, -15827, -25667, -8536, 17565,
	25209, 6363, -19169, -24558, -4141, 20627, 23721, 1889,
	-21928, -22703, 378, 23062, 21512, -2642, -24020, -20158,
	4886, 24796, 18650, -7093, -25383, -17000, 9247, 25777,
	15221, -11329, -25975, -13326, 13326, 25975, 11329, -15221,
	-25777, -9246, 17000, 25383, 7093, -18650, -24796, -4886,
	20158, 24020, 2642, -21512, -23062, -377, 22703, 21928,
	-1889, -23721, -20627, 4142, 24558, 19169, -6363, -25209,
	-17565, 8536, 25667, 15827, -10644, -25931, -13969, 12671,
	25997, 12005, -14601, -25865, -9949, 16421, 25536, 7818,
	-18115, -25013, -5627, 19672, 24300, 3393, -21078, -23401,
	-1133, 22325, 22325, -1134, -23401, -21078, 3393, 24300,
	19671, -5627, -25013, -18115, 7818, 25536, 16420, -9949,
	-25865, -14601, 12005, 25997, 12670, -13969, -25931, -10643,
	15827, 25667, 8536, -17565, -25209, -6363, 19169, 24558,
	4141, -20627, -23721, -1888, 21928, 22703, -378, -23062,
	-21512, 2642, 24020, 20157, -4887, -24796, -18650, 7094,
	25383, 17000, -9247, -25777, -15220, 11329, 25975, 13325,
	-13326, -25975, -11329, 15221, 25777, 9246, -17000, -25383,
	-7093, 18650, 24796, 4886, -20158, -24020, -2642, 21512,
	23062, 377, -22703, -21928, 1889, 23721, 20626, -4142,
	-24558, -19168, 6363, 25209, 17565, -8536, -25668, -15827,
	10644, 25931, 13969, -12671, -25997, -12005, 14601, 25865},
	},{{

// Carrier 32 Phase 0
	0, 23234, 20855, -4514, -24907, -17842, 8892, 25824,
	14287, -13000, -25956, -10298, 16712, 25299, 5995, -19917,
	-23873, -1511, 22516, 21722, -3018, -24432, -18911, 7456,
	25605, 15526, -11668, -26000, -11668, 15526, 25604, 7456,
	-18911, -24431, -3018, 21722, 22516, -1511, -23873, -19917,
	5996, 25299, 16712, -10298, -25956, -12999, 14287, 25824,
	8892, -17842, -24907, -4514, 20855, 23234, 0, -23234,
	-20855, 4514, 24907, 17842, -8892, -25824, -14287, 13000,
	25956, 10297, -16712, -25299, -5995, 19917, 23873, 1511,
	-22516, -21722, 3018, 24432, 18911, -7457, -25605, -15525,
	11668, 26000, 11668, -15526, -25604, -7456, 18911, 24431,
	3018, -21722, -22516, 1511, 23873, 19917, -5996, -25299,
	-16712, 10298, 25956, 12999, -14287, -25824, -8892, 17842,
	24907, 4514, -20855, -23234, 0, 23234, 20855, -4515,
	-24907, -17842, 8892, 25824, 14287, -13000, -25955, -10297,
	16712, 25299, 5995, -19917, -23873, -1511, 22516, 21722,
	-3018, -24432, -18911, 7457, 25605, 15525, -11669, -26000,
	-11668, 15526, 25604, 7456, -18911, -24431, -3018, 21722,
	22516, -1512, -23873, -19916, 5996, 25299, 16712, -10298,
	-25956, -12999, 14287, 25824, 8892, -17842, -24907, -4514,
	20855, 23234, 0, -23234, -20854, 4515, 24907, 17842,
	-8892, -25824, -14286, 13000, 25955, 10297, -16712, -25299,
	-5995, 19917, 23873, 1511, -22516, -21722, 3018, 24432,
	18911, -7457, -25605, -15525, 11669, 26000, 11668, -15526,
	-25604, -7456, 18911, 24431, 3018, -21722, -22516, 1512,
	23873, 19916, -5996, -25299, -16712, 10298, 25956, 12999,
	-14287, -25824, -8892, 17842, 24907, 4514, -20855, -23234},
	{
// Carrier 32 Phase 1
	9949, 25931, 13326, -13969, -25865, -9246, 17565, 25013,
	4886, -20627, -23401, -378, 23062, 21078, -4142, -24796,
	-18115, 8536, 25777, 14601, -12671, -25975, -10644, 16421,
	25383, 6363, -19672, -24020, -1889, 22325, 21928, -2642,
	-24300, -19169, 7093, 25536, 15827, -11329, -25997, -12005,
	15221, 25667, 7818, -18650, -24558, -3393, 21512, 22703,
	-1134, -23721, -20158, 5627, 25209, 17000, -9949, -25931,
	-13325, 13969, 25865, 9246, -17565, -25013, -4886, 20627,
	23401, 377, -23062, -21078, 4142, 24796, 18115, -8536,
	-25777, -14601, 12671, 25975, 10644, -16421, -25383, -6363,
	19672, 24020, 1888, -22325, -21928, 2642, 24300, 19169,
	-7094, -25536, -15827, 11329, 25997, 12005, -15221, -25667,
	-7818, 18650, 24558, 3393, -21512, -22703, 1134, 23721,
	20157, -5627, -25209, -17000, 9949, 25931, 13325, -13969,
	-25865, -9246, 17565, 25013, 4886, -20627, -23401, -377,
	23062, 21078, -4142, -24796, -18115, 8536, 25777, 14601,
	-12671, -25975, -10643, 16421, 25383, 6363, -19672, -24020,
	-1888, 22325, 21928, -2642, -24300, -19168, 7094, 25536,
	15827, -11329, -25997, -12005, 15221, 25667, 7818, -18650,
	-24558, -3393, 21512, 22703, -1134, -23721, -20157, 5627,
	25209, 17000, -9950, -25931, -13325, 13970, 25865, 9246,
	-17565, -25013, -4886, 20627, 23401, 377, -23062, -21078,
	4142, 24796, 18115, -8536, -25777, -14601, 12671, 25975,
	10643, -16421, -25383, -6362, 19672, 24020, 1888, -22325,
	-21927, 2642, 24300, 19168, -7094, -25536, -15827, 11330,
	25997, 12005, -15221, -25667, -7817, 18650, 24558, 3393,
	-21512, -22703, 1134, 23721, 20157, -5627, -25209, -17000},
	{
// Carrier 32 Phase 2
	18384, 24680, 3768, -21297, -22885, 756, 23564, 20394,
	-5257, -25114, -17284, 9599, 25901, 13649, -13649, -25901,
	-9599, 17284, 25114, 5257, -20394, -23563, -756, 22885,
	21297, -3768, -24680, -18384, 8178, 25725, 14912, -12339,
	-25988, -10988, 16126, 25462, 6729, -19422, -24163, -2265,
	22129, 22128, -2266, -24163, -19422, 6729, 25462, 16126,
	-10988, -25989, -12339, 14913, 25725, 8178, -18384, -24680,
	-3768, 21298, 22885, -756, -23564, -20394, 5257, 25114,
	17284, -9599, -25901, -13649, 13649, 25901, 9599, -17284,
	-25114, -5257, 20394, 23563, 756, -22885, -21297, 3768,
	24680, 18384, -8178, -25725, -14912, 12339, 25988, 10987,
	-16126, -25462, -6729, 19422, 24162, 2265, -22129, -22128,
	2266, 24163, 19422, -6729, -25462, -16125, 10988, 25989,
	12339, -14913, -25725, -8177, 18384, 24680, 3767, -21298,
	-22885, 756, 23564, 20394, -5257, -25114, -17284, 9599,
	25901, 13649, -13649, -25901, -9599, 17284, 25114, 5257,
	-20394, -23563, -755, 22885, 21297, -3768, -24680, -18384,
	8178, 25725, 14912, -12339, -25988, -10987, 16126, 25462,
	6728, -19422, -24162, -2265, 22129, 22128, -2266, -24163,
	-19422, 6729, 25462, 16125, -10988, -25989, -12339, 14913,
	25725, 8177, -18385, -24680, -3767, 21298, 22885, -756,
	-23564, -20394, 5258, 25114, 17284, -9599, -25901, -13649,
	13649, 25901, 9598, -17284, -25113, -5257, 20395, 23563,
	755, -22885, -21297, 3768, 24680, 18384, -8178, -25725,
	-14912, 12339, 25988, 10987, -16126, -25462, -6728, 19422,
	24162, 2265, -22129, -22128, 2266, 24163, 19422, -6729,
	-25462, -16125, 10988, 25989, 12339, -14913, -25725, -8177},
	{
// Carrier 32 Phase 3
	24020, 19671, -6363, -25383, -16421, 10644, 25975, 12671,
	-14601, -25777, -8536, 18115, 24796, 4141, -21078, -23062,
	378, 23401, 20627, -4886, -25013, -17565, 9246, 25865,
	13969, -13326, -25931, -9949, 17000, 25209, 5627, -20158,
	-23721, -1134, 22703, 21512, -3393, -24558, -18650, 7818,
	25667, 15221, -12005, -25997, -11329, 15827, 25536, 7093,
	-19169, -24300, -2642, 21928, 22325, -1889, -24020, -19671,
	6363, 25383, 16420, -10644, -25975, -12671, 14601, 25777,
	8536, -18115, -24796, -4141, 21078, 23062, -378, -23401,
	-20627, 4886, 25013, 17565, -9247, -25865, -13969, 13326,
	25931, 9949, -17000, -25209, -5627, 20158, 23721, 1133,
	-22703, -21512, 3393, 24558, 18650, -7818, -25667, -15220,
	12005, 25997, 11329, -15827, -25536, -7093, 19169, 24300,
	2642, -21928, -22325, 1889, 24020, 19671, -6363, -25383,
	-16420, 10644, 25975, 12670, -14601, -25777, -8536, 18115,
	24796, 4141, -21078, -23062, 378, 23401, 20627, -4887,
	-25013, -17565, 9247, 25865, 13969, -13326, -25931, -9949,
	17000, 25209, 5627, -20158, -23721, -1133, 22703, 21512,
	-3393, -24558, -18650, 7818, 25668, 15220, -12005, -25997,
	-11329, 15828, 25536, 7093, -19169, -24299, -2642, 21928,
	22325, -1889, -24020, -19671, 6363, 25383, 16420, -10644,
	-25975, -12670, 14601, 25777, 8535, -18115, -24796, -4141,
	21079, 23062, -378, -23401, -20626, 4887, 25013, 17565,
	-9247, -25865, -13969, 13326, 25931, 9949, -17000, -25209,
	-5627, 20158, 23721, 1133, -22703, -21512, 3394, 24558,
	18649, -7818, -25668, -15220, 12005, 25997, 11329, -15828,
	-25536, -7093, 19169, 24299, 2642, -21928, -22324, 1889},
	{
// Carrier 32 Phase 4
	26000, 11668, -15526, -25605, -7456, 18911, 24432, 3018,
	-21722, -22516, 1511, 23873, 19917, -5996, -25299, -16712,
	10298, 25956, 12999, -14287, -25824, -8892, 17842, 24907,
	4514, -20855, -23234, 0, 23234, 20855, -4514, -24907,
	-17842, 8892, 25824, 14287, -13000, -25956, -10298, 16712,
	25299, 5995, -19917, -23873, -1511, 22516, 21722, -3018,
	-24432, -18911, 7456, 25605, 15526, -11668, -26000, -11668,
	15526, 25604, 7456, -18911, -24431, -3018, 21722, 22516,
	-1511, -23873, -19917, 5996, 25299, 16712, -10298, -25956,
	-12999, 14287, 25824, 8892, -17842, -24907, -4514, 20855,
	23234, 0, -23234, -20855, 4515, 24907, 17842, -8892,
	-25824, -14287, 13000, 25956, 10297, -16712, -25299, -5995,
	19917, 23873, 1511, -22516, -21722, 3018, 24432, 18911,
	-7457, -25605, -15525, 11668, 26000, 11668, -15526, -25604,
	-7456, 18911, 24431, 3018, -21722, -22516, 1512, 23873,
	19917, -5996, -25299, -16712, 10298, 25956, 12999, -14287,
	-25824, -8892, 17842, 24907, 4514, -20855, -23234, 0,
	23234, 20855, -4515, -24907, -17842, 8892, 25824, 14286,
	-13000, -25955, -10297, 16712, 25299, 5995, -19917, -23873,
	-1511, 22516, 21722, -3018, -24432, -18911, 7457, 25605,
	15525, -11669, -26000, -11668, 15526, 25604, 7456, -18911,
	-24431, -3018, 21722, 22516, -1512, -23873, -19916, 5996,
	25299, 16712, -10298, -25956, -12999, 14287, 25824, 8892,
	-17842, -24907, -4514, 20855, 23234, 0, -23234, -20854,
	4515, 24907, 17841, -8892, -25824, -14286, 13000, 25955,
	10297, -16712, -25299, -5995, 19917, 23873, 1511, -22516,
	-21722, 3018, 24432, 18911, -7457, -25605, -15525, 11669},
	{
// Carrier 32 Phase 5
	24020, 1889, -22325, -21928, 2642, 24300, 19169, -7093,
	-25536, -15827, 11329, 25997, 12005, -15221, -25667, -7818,
	18650, 24558, 3393, -21512, -22703, 1134, 23721, 20158,
	-5627, -25209, -17000, 9949, 25931, 13326, -13969, -25865,
	-9246, 17565, 25013, 4886, -20627, -23401, -378, 23062,
	21078, -4142, -24796, -18115, 8536, 25777, 14601, -12671,
	-25975, -10644, 16421, 25383, 6363, -19672, -24020, -1889,
	22325, 21928, -2642, -24300, -19169, 7093, 25536, 15827,
	-11329, -25997, -12005, 15221, 25667, 7818, -18650, -24558,
	-3393, 21512, 22703, -1134, -23721, -20158, 5627, 25209,
	17000, -9949, -25931, -13325, 13969, 25865, 9246, -17565,
	-25013, -4886, 20627, 23401, 377, -23062, -21078, 4142,
	24796, 18115, -8536, -25777, -14601, 12671, 25975, 10643,
	-16421, -25383, -6363, 19672, 24020, 1888, -22325, -21928,
	2642, 24300, 19169, -7094, -25536, -15827, 11329, 25997,
	12005, -15221, -25667, -7818, 18650, 24558, 3393, -21512,
	-22703, 1134, 23721, 20157, -5627, -25209, -17000, 9950,
	25931, 13325, -13970, -25865, -9246, 17565, 25013, 4886,
	-20627, -23401, -377, 23062, 21078, -4142, -24796, -18115,
	8536, 25777, 14601, -12671, -25975, -10643, 16421, 25383,
	6362, -19672, -24020, -1888, 22325, 21927, -2642, -24300,
	-19168, 7094, 25536, 15827, -11329, -25997, -12005, 15221,
	25667, 7817, -18650, -24558, -3393, 21512, 22703, -1134,
	-23721, -20157, 5627, 25209, 17000, -9950, -25931, -13325,
	13970, 25865, 9246, -17565, -25013, -4886, 20627, 23401,
	377, -23062, -21078, 4142, 24796, 18115, -8536, -25777,
	-14601, 12671, 25975, 10643, -16421, -25383, -6362, 19672},
	{
// Carrier 32 Phase 6
	18384, -8178, -25725, -14912, 12339, 25989, 10988, -16126,
	-25462, -6729, 19422, 24163, 2266, -22129, -22129, 2266,
	24163, 19422, -6729, -25462, -16126, 10988, 25989, 12339,
	-14913, -25725, -8178, 18384, 24680, 3768, -21297, -22885,
	756, 23564, 20394, -5257, -25114, -17284, 9599, 25901,
	13649, -13649, -25901, -9599, 17284, 25114, 5257, -20394,
	-23563, -756, 22885, 21297, -3768, -24680, -18384, 8178,
	25725, 14912, -12339, -25988, -10987, 16126, 25462, 6729,
	-19422, -24162, -2265, 22129, 22128, -2266, -24163, -19422,
	6729, 25462, 16125, -10988, -25989, -12339, 14913, 25725,
	8178, -18384, -24680, -3768, 21298, 22885, -756, -23564,
	-20394, 5257, 25114, 17284, -9599, -25901, -13649, 13649,
	25901, 9599, -17284, -25114, -5257, 20394, 23563, 755,
	-22885, -21297, 3768, 24680, 18384, -8178, -25725, -14912,
	12339, 25988, 10987, -16126, -25462, -6729, 19422, 24162,
	2265, -22129, -22128, 2266, 24163, 19422, -6729, -25462,
	-16125, 10988, 25989, 12339, -14913, -25725, -8177, 18384,
	24680, 3767, -21298, -22885, 756, 23564, 20394, -5257,
	-25114, -17284, 9599, 25901, 13649, -13649, -25901, -9599,
	17284, 25113, 5257, -20395, -23563, -755, 22885, 21297,
	-3768, -24680, -18384, 8178, 25725, 14912, -12339, -25988,
	-10987, 16126, 25462, 6728, -19422, -24162, -2265, 22129,
	22128, -2266, -24163, -19422, 6729, 25462, 16125, -10988,
	-25989, -12339, 14913, 25725, 8177, -18385, -24680, -3767,
	21298, 22885, -756, -23564, -20394, 5258, 25114, 17284,
	-9599, -25901, -13649, 13649, 25901, 9598, -17285, -25113,
	-5257, 20395, 23563, 755, -22885, -21297, 3768, 24680},
	{
// Carrier 32 Phase 7
	9949, -17000, -25209, -5627, 20158, 23721, 1134, -22703,
	-21512, 3393, 24558, 18650, -7818, -25667, -15221, 12005,
	25997, 11329, -15827, -25536, -7093, 19169, 24300, 2642,
	-21928, -22325, 1889, 24020, 19671, -6363, -25383, -16421,
	10644, 25975, 12671, -14601, -25777, -8536, 18115, 24796,
	4141, -21078, -23062, 378, 23401, 20627, -4886, -25013,
	-17565, 9247, 25865, 13969, -13326, -25931, -9949, 17000,
	25209, 5627, -20158, -23721, -1134, 22703, 21512, -3393,
	-24558, -18650, 7818, 25667, 15221, -12005, -25997, -11329,
	15827, 25536, 7093, -19169, -24300, -2642, 21928, 22325,
	-1889, -24020, -19671, 6363, 25383, 16420, -10644, -25975,
	-12670, 14601, 25777, 8536, -18115, -24796, -4141, 21078,
	23062, -378, -23401, -20627, 4886, 25013, 17565, -9247,
	-25865, -13969, 13326, 25931, 9949, -17000, -25209, -5627,
	20158, 23721, 1133, -22703, -21512, 3393, 24558, 18650,
	-7818, -25667, -15220, 12005, 25997, 11329, -15827, -25536,
	-7093, 19169, 24299, 2642, -21928, -22325, 1889, 24020,
	19671, -6363, -25383, -16420, 10644, 25975, 12670, -14601,
	-25777, -8535, 18115, 24796, 4141, -21078, -23062, 378,
	23401, 20627, -4887, -25013, -17565, 9247, 25865, 13969,
	-13326, -25931, -9949, 17000, 25209, 5627, -20158, -23721,
	-1133, 22703, 21512, -3394, -24558, -18649, 7818, 25668,
	15220, -12005, -25997, -11329, 15828, 25536, 7093, -19169,
	-24299, -2642, 21928, 22325, -1889, -24021, -19671, 6363,
	25383, 16420, -10644, -25975, -12670, 14601, 25777, 8535,
	-18115, -24796, -4141, 21079, 23062, -378, -23401, -20626,
	4887, 25013, 17565, -9247, -25865, -13969, 13326, 25931},
	},{{

// Carrier 33 Phase 0
	0, 23564, 19917, -6729, -25605, -14912, 13000, 25901,
	8892, -18384, -24432, -2266, 22516, 21297, -4514, -25114,
	-16712, 10988, 26000, 10988, -16712, -25114, -4514, 21297,
	22516, -2266, -24432, -18384, 8892, 25901, 12999, -14913,
	-25604, -6729, 19917, 23563, 0, -23564, -19917, 6729,
	25605, 14912, -13000, -25901, -8892, 18384, 24431, 2265,
	-22516, -21297, 4515, 25114, 16712, -10988, -26000, -10987,
	16712, 25114, 4514, -21298, -22516, 2266, 24432, 18384,
	-8892, -25901, -12999, 14913, 25604, 6729, -19917, -23563,
	0, 23564, 19916, -6729, -25605, -14912, 13000, 25901,
	8892, -18384, -24431, -2265, 22516, 21297, -4515, -25114,
	-16712, 10988, 26000, 10987, -16712, -25113, -4514, 21298,
	22516, -2266, -24432, -18384, 8892, 25901, 12999, -14913,
	-25604, -6728, 19917, 23563, 0, -23564, -19916, 6729,
	25605, 14912, -13000, -25901, -8892, 18385, 24431, 2265,
	-22516, -21297, 4515, 25114, 16712, -10988, -26000, -10987,
	16712, 25113, 4514, -21298, -22516, 2266, 24432, 18384,
	-8892, -25901, -12999, 14913, 25604, 6728, -19917, -23563,
	0, 23564, 19916, -6729, -25605, -14912, 13000, 25901,
	8892, -18385, -24431, -2265, 22516, 21297, -4515, -25114,
	-16712, 10988, 26000, 10987, -16712, -25113, -4514, 21298,
	22516, -2266, -24432, -18384, 8893, 25901, 12999, -14913,
	-25604, -6728, 19917, 23563, 0, -23564, -19916, 6729,
	25605, 14912, -13000, -25901, -8891, 18385, 24431, 2265,
	-22516, -21297, 4515, 25114, 16711, -10988, -26000, -10987,
	16713, 25113, 4514, -21298, -22516, 2266, 24432, 18384,
	-8893, -25901, -12999, 14913, 25604, 6728, -19917, -23563},
	{
// Carrier 33 Phase 1
	9949, 25975, 12005, -15827, -25383, -5627, 20627, 23062,
	-1134, -24020, -19169, 7818, 25777, 13969, -13969, -25777,
	-7818, 19169, 24020, 1134, -23062, -20627, 5627, 25383,
	15827, -12005, -25975, -9949, 17565, 24796, 3393, -21928,
	-21928, 3393, 24796, 17565, -9949, -25975, -12005, 15827,
	25383, 5627, -20627, -23062, 1134, 24020, 19169, -7818,
	-25777, -13969, 13969, 25777, 7818, -19169, -24020, -1133,
	23062, 20627, -5627, -25383, -15827, 12005, 25975, 9949,
	-17565, -24796, -3393, 21928, 21928, -3393, -24796, -17565,
	9950, 25975, 12005, -15827, -25383, -5627, 20627, 23062,
	-1134, -24020, -19169, 7818, 25777, 13969, -13970, -25777,
	-7818, 19169, 24020, 1133, -23062, -20626, 5627, 25383,
	15827, -12005, -25975, -9949, 17565, 24796, 3393, -21928,
	-21927, 3394, 24796, 17565, -9950, -25975, -12005, 15828,
	25383, 5627, -20627, -23062, 1134, 24021, 19168, -7818,
	-25777, -13969, 13970, 25777, 7817, -19169, -24020, -1133,
	23062, 20626, -5627, -25383, -15827, 12005, 25975, 9949,
	-17565, -24796, -3393, 21928, 21927, -3394, -24796, -17564,
	9950, 25975, 12005, -15828, -25383, -5626, 20627, 23062,
	-1134, -24021, -19168, 7818, 25777, 13969, -13970, -25777,
	-7817, 19169, 24020, 1133, -23062, -20626, 5627, 25383,
	15827, -12005, -25975, -9949, 17565, 24796, 3393, -21928,
	-21927, 3394, 24796, 17564, -9950, -25975, -12004, 15828,
	25383, 5626, -20627, -23061, 1134, 24021, 19168, -7818,
	-25777, -13969, 13970, 25777, 7817, -19169, -24020, -1133,
	23062, 20626, -5628, -25383, -15827, 12006, 25975, 9949,
	-17565, -24796, -3392, 21928, 21927, -3394, -24796, -17564},
	{
// Carrier 33 Phase 2
	18384, 24432, 2266, -22516, -21297, 4514, 25114, 16712,
	-10988, -26000, -10988, 16712, 25114, 4514, -21297, -22516,
	2266, 24432, 18384, -8892, -25901, -12999, 14913, 25604,
	6729, -19917, -23563, 0, 23564, 19917, -6729, -25605,
	-14912, 13000, 25901, 8892, -18384, -24431, -2265, 22516,
	21297, -4514, -25114, -16712, 10988, 26000, 10987, -16712,
	-25114, -4514, 21298, 22516, -2266, -24432, -18384, 8892,
	25901, 12999, -14913, -25604, -6729, 19917, 23563, 0,
	-23564, -19917, 6729, 25605, 14912, -13000, -25901, -8892,
	18384, 24431, 2265, -22516, -21297, 4515, 25114, 16712,
	-10988, -26000, -10987, 16712, 25113, 4514, -21298, -22516,
	2266, 24432, 18384, -8892, -25901, -12999, 14913, 25604,
	6728, -19917, -23563, 0, 23564, 19916, -6729, -25605,
	-14912, 13000, 25901, 8892, -18385, -24431, -2265, 22516,
	21297, -4515, -25114, -16712, 10988, 26000, 10987, -16712,
	-25113, -4514, 21298, 22516, -2266, -24432, -18384, 8892,
	25901, 12999, -14913, -25604, -6728, 19917, 23563, 0,
	-23564, -19916, 6729, 25605, 14912, -13000, -25901, -8892,
	18385, 24431, 2265, -22516, -21297, 4515, 25114, 16712,
	-10988, -26000, -10987, 16712, 25113, 4514, -21298, -22516,
	2266, 24432, 18384, -8893, -25901, -12999, 14913, 25604,
	6728, -19917, -23563, 0, 23564, 19916, -6729, -25605,
	-14912, 13000, 25901, 8891, -18385, -24431, -2265, 22516,
	21297, -4515, -25114, -16711, 10988, 26000, 10987, -16712,
	-25113, -4514, 21298, 22516, -2266, -24432, -18384, 8893,
	25901, 12999, -14913, -25604, -6728, 19917, 23563, 0,
	-23564, -19916, 6730, 25605, 14912, -13000, -25900, -8891},
	{
// Carrier 33 Phase 3
	24020, 19169, -7818, -25777, -13969, 13969, 25777, 7818,
	-19169, -24020, -1134, 23062, 20627, -5627, -25383, -15827,
	12005, 25975, 9949, -17565, -24796, -3393, 21928, 21928,
	-3393, -24796, -17565, 9949, 25975, 12005, -15827, -25383,
	-5627, 20627, 23062, -1134, -24020, -19169, 7818, 25777,
	13969, -13969, -25777, -7818, 19169, 24020, 1133, -23062,
	-20627, 5627, 25383, 15827, -12005, -25975, -9949, 17565,
	24796, 3393, -21928, -21928, 3393, 24796, 17565, -9949,
	-25975, -12005, 15827, 25383, 5627, -20627, -23062, 1134,
	24020, 19169, -7818, -25777, -13969, 13970, 25777, 7818,
	-19169, -24020, -1133, 23062, 20627, -5627, -25383, -15827,
	12005, 25975, 9949, -17565, -24796, -3393, 21928, 21927,
	-3394, -24796, -17565, 9950, 25975, 12005, -15828, -25383,
	-5627, 20627, 23062, -1134, -24021, -19168, 7818, 25777,
	13969, -13970, -25777, -7817, 19169, 24020, 1133, -23062,
	-20626, 5627, 25383, 15827, -12005, -25975, -9949, 17565,
	24796, 3393, -21928, -21927, 3394, 24796, 17565, -9950,
	-25975, -12005, 15828, 25383, 5626, -20627, -23062, 1134,
	24021, 19168, -7818, -25777, -13969, 13970, 25777, 7817,
	-19169, -24020, -1133, 23062, 20626, -5627, -25383, -15827,
	12005, 25975, 9949, -17565, -24796, -3393, 21928, 21927,
	-3394, -24796, -17564, 9950, 25975, 12004, -15828, -25383,
	-5626, 20627, 23061, -1134, -24021, -19168, 7818, 25777,
	13969, -13970, -25777, -7817, 19169, 24020, 1133, -23062,
	-20626, 5628, 25383, 15827, -12006, -25975, -9949, 17565,
	24796, 3392, -21928, -21927, 3394, 24796, 17564, -9950,
	-25975, -12004, 15828, 25383, 5626, -20627, -23061, 1134},
	{
// Carrier 33 Phase 4
	26000, 10988, -16712, -25114, -4514, 21297, 22516, -2266,
	-24432, -18384, 8892, 25901, 12999, -14913, -25604, -6729,
	19917, 23563, 0, -23564, -19917, 6729, 25605, 14912,
	-13000, -25901, -8892, 18384, 24431, 2265, -22516, -21297,
	4514, 25114, 16712, -10988, -26000, -10987, 16712, 25114,
	4514, -21298, -22516, 2266, 24432, 18384, -8892, -25901,
	-12999, 14913, 25604, 6729, -19917, -23563, 0, 23564,
	19917, -6729, -25605, -14912, 13000, 25901, 8892, -18384,
	-24431, -2265, 22516, 21297, -4515, -25114, -16712, 10988,
	26000, 10987, -16712, -25114, -4514, 21298, 22516, -2266,
	-24432, -18384, 8892, 25901, 12999, -14913, -25604, -6729,
	19917, 23563, 0, -23564, -19916, 6729, 25605, 14912,
	-13000, -25901, -8892, 18385, 24431, 2265, -22516, -21297,
	4515, 25114, 16712, -10988, -26000, -10987, 16712, 25113,
	4514, -21298, -22516, 2266, 24432, 18384, -8892, -25901,
	-12999, 14913, 25604, 6728, -19917, -23563, 0, 23564,
	19916, -6729, -25605, -14912, 13000, 25901, 8892, -18385,
	-24431, -2265, 22516, 21297, -4515, -25114, -16712, 10988,
	26000, 10987, -16712, -25113, -4514, 21298, 22516, -2266,
	-24432, -18384, 8893, 25901, 12999, -14913, -25604, -6728,
	19917, 23563, 0, -23564, -19916, 6729, 25605, 14912,
	-13000, -25901, -8891, 18385, 24431, 2265, -22516, -21297,
	4515, 25114, 16712, -10988, -26000, -10987, 16712, 25113,
	4514, -21298, -22516, 2266, 24432, 18384, -8893, -25901,
	-12999, 14913, 25604, 6728, -19917, -23563, 0, 23564,
	19916, -6729, -25605, -14912, 13000, 25901, 8891, -18385,
	-24431, -2265, 22517, 21297, -4515, -25114, -16711, 10988},
	{
// Carrier 33 Phase 5
	24020, 1134, -23062, -20627, 5627, 25383, 15827, -12005,
	-25975, -9949, 17565, 24796, 3393, -21928, -21928, 3393,
	24796, 17565, -9949, -25975, -12005, 15827, 25383, 5627,
	-20627, -23062, 1134, 24020, 19169, -7818, -25777, -13969,
	13969, 25777, 7818, -19169, -24020, -1133, 23062, 20627,
	-5627, -25383, -15827, 12005, 25975, 9949, -17565, -24796,
	-3393, 21928, 21928, -3393, -24796, -17565, 9949, 25975,
	12005, -15827, -25383, -5627, 20627, 23062, -1134, -24020,
	-19169, 7818, 25777, 13969, -13969, -25777, -7818, 19169,
	24020, 1133, -23062, -20627, 5627, 25383, 15827, -12005,
	-25975, -9949, 17565, 24796, 3393, -21928, -21928, 3393,
	24796, 17565, -9950, -25975, -12005, 15828, 25383, 5627,
	-20627, -23062, 1134, 24020, 19168, -7818, -25777, -13969,
	13970, 25777, 7818, -19169, -24020, -1133, 23062, 20626,
	-5627, -25383, -15827, 12005, 25975, 9949, -17565, -24796,
	-3393, 21928, 21927, -3394, -24796, -17565, 9950, 25975,
	12005, -15828, -25383, -5627, 20627, 23062, -1134, -24021,
	-19168, 7818, 25777, 13969, -13970, -25777, -7817, 19169,
	24020, 1133, -23062, -20626, 5627, 25383, 15827, -12005,
	-25975, -9949, 17565, 24796, 3393, -21928, -21927, 3394,
	24796, 17564, -9950, -25975, -12004, 15828, 25383, 5626,
	-20627, -23062, 1134, 24021, 19168, -7818, -25777, -13969,
	13970, 25777, 7817, -19169, -24020, -1133, 23062, 20626,
	-5628, -25383, -15827, 12006, 25975, 9949, -17565, -24796,
	-3393, 21928, 21927, -3394, -24796, -17564, 9950, 25975,
	12004, -15828, -25383, -5626, 20627, 23061, -1134, -24021,
	-19168, 7819, 25777, 13969, -13970, -25777, -7817, 19169},
	{
// Carrier 33 Phase 6
	18384, -8892, -25901, -13000, 14912, 25604, 6729, -19917,
	-23563, 0, 23564, 19917, -6729, -25605, -14912, 13000,
	25901, 8892, -18384, -24431, -2265, 22516, 21297, -4514,
	-25114, -16712, 10988, 26000, 10987, -16712, -25114, -4514,
	21298, 22516, -2266, -24432, -18384, 8892, 25901, 12999,
	-14913, -25604, -6729, 19917, 23563, 0, -23564, -19917,
	6729, 25605, 14912, -13000, -25901, -8892, 18384, 24431,
	2265, -22516, -21297, 4515, 25114, 16712, -10988, -26000,
	-10987, 16712, 25114, 4514, -21298, -22516, 2266, 24432,
	18384, -8892, -25901, -12999, 14913, 25604, 6729, -19917,
	-23563, 0, 23564, 19916, -6729, -25605, -14912, 13000,
	25901, 8892, -18384, -24431, -2265, 22516, 21297, -4515,
	-25114, -16712, 10988, 26000, 10987, -16712, -25113, -4514,
	21298, 22516, -2266, -24432, -18384, 8892, 25901, 12999,
	-14913, -25604, -6728, 19917, 23563, 0, -23564, -19916,
	6729, 25605, 14912, -13000, -25901, -8892, 18385, 24431,
	2265, -22516, -21297, 4515, 25114, 16712, -10988, -26000,
	-10987, 16712, 25113, 4514, -21298, -22516, 2266, 24432,
	18384, -8892, -25901, -12999, 14913, 25604, 6728, -19917,
	-23563, 0, 23564, 19916, -6729, -25605, -14912, 13000,
	25901, 8892, -18385, -24431, -2265, 22516, 21297, -4515,
	-25114, -16712, 10988, 26000, 10987, -16712, -25113, -4514,
	21298, 22516, -2266, -24432, -18384, 8893, 25901, 12999,
	-14913, -25604, -6728, 19917, 23563, 0, -23564, -19916,
	6729, 25605, 14912, -13000, -25901, -8891, 18385, 24431,
	2265, -22516, -21297, 4515, 25114, 16711, -10988, -26000,
	-10987, 16713, 25113, 4514, -21298, -22516, 2266, 24432},
	{
// Carrier 33 Phase 7
	9949, -17565, -24796, -3393, 21928, 21928, -3393, -24796,
	-17565, 9949, 25975, 12005, -15827, -25383, -5627, 20627,
	23062, -1134, -24020, -19169, 7818, 25777, 13969, -13969,
	-25777, -7818, 19169, 24020, 1134, -23062, -20627, 5627,
	25383, 15827, -12005, -25975, -9949, 17565, 24796, 3393,
	-21928, -21928, 3393, 24796, 17565, -9949, -25975, -12005,
	15827, 25383, 5627, -20627, -23062, 1134, 24020, 19169,
	-7818, -25777, -13969, 13969, 25777, 7818, -19169, -24020,
	-1133, 23062, 20627, -5627, -25383, -15827, 12005, 25975,
	9949, -17565, -24796, -3393, 21928, 21928, -3393, -24796,
	-17565, 9950, 25975, 12005, -15828, -25383, -5627, 20627,
	23062, -1134, -24020, -19169, 7818, 25777, 13969, -13970,
	-25777, -7818, 19169, 24020, 1133, -23062, -20626, 5627,
	25383, 15827, -12005, -25975, -9949, 17565, 24796, 3393,
	-21928, -21927, 3394, 24796, 17565, -9950, -25975, -12005,
	15828, 25383, 5627, -20627, -23062, 1134, 24021, 19168,
	-7818, -25777, -13969, 13970, 25777, 7817, -19169, -24020,
	-1133, 23062, 20626, -5627, -25383, -15827, 12005, 25975,
	9949, -17565, -24796, -3393, 21928, 21927, -3394, -24796,
	-17564, 9950, 25975, 12004, -15828, -25383, -5626, 20627,
	23062, -1134, -24021, -19168, 7818, 25777, 13969, -13970,
	-25777, -7817, 19169, 24020, 1133, -23062, -20626, 5628,
	25383, 15827, -12005, -25975, -9949, 17565, 24796, 3393,
	-21928, -21927, 3394, 24796, 17564, -9950, -25975, -12004,
	15828, 25383, 5626, -20627, -23061, 1134, 24021, 19168,
	-7818, -25777, -13969, 13970, 25777, 7817, -19169, -24020,
	-1133, 23062, 20626, -5628, -25383, -15827, 12006, 25975},
	},{{

// Carrier 34 Phase 0
	0, 23873, 18911, -8892, -25956, -11668, 16712, 24907,
	3018, -22516, -20855, 5996, 25605, 14287, -14287, -25605,
	-5996, 20855, 22516, -3018, -24907, -16712, 11668, 25956,
	8892, -18911, -23873, 0, 23873, 18911, -8892, -25956,
	-11668, 16712, 24907, 3018, -22516, -20855, 5995, 25604,
	14287, -14287, -25605, -5996, 20855, 22516, -3018, -24907,
	-16712, 11668, 25956, 8892, -18911, -23873, 0, 23873,
	18911, -8892, -25956, -11668, 16712, 24907, 3018, -22516,
	-20855, 5995, 25604, 14287, -14287, -25605, -5996, 20855,
	22516, -3018, -24907, -16712, 11668, 25956, 8892, -18911,
	-23873, 0, 23873, 18911, -8892, -25956, -11668, 16712,
	24907, 3018, -22516, -20855, 5995, 25604, 14287, -14287,
	-25605, -5996, 20855, 22516, -3018, -24907, -16712, 11668,
	25956, 8892, -18911, -23873, 0, 23873, 18911, -8892,
	-25956, -11668, 16712, 24907, 3018, -22516, -20855, 5995,
	25604, 14287, -14287, -25605, -5996, 20855, 22516, -3018,
	-24907, -16712, 11668, 25956, 8892, -18911, -23873, 0,
	23873, 18911, -8892, -25956, -11668, 16712, 24907, 3018,
	-22516, -20855, 5995, 25604, 14287, -14287, -25605, -5996,
	20855, 22516, -3018, -24907, -16712, 11668, 25956, 8892,
	-18911, -23873, 0, 23873, 18911, -8892, -25956, -11668,
	16712, 24907, 3018, -22516, -20855, 5995, 25604, 14287,
	-14287, -25605, -5996, 20855, 22516, -3018, -24907, -16712,
	11668, 25956, 8892, -18911, -23873, 0, 23873, 18911,
	-8892, -25956, -11668, 16712, 24907, 3018, -22516, -20855,
	5995, 25604, 14287, -14287, -25605, -5996, 20855, 22516,
	-3018, -24907, -16712, 11668, 25956, 8892, -18911, -23873},
	{
// Carrier 34 Phase 1
	9949, 25997, 10644, -17565, -24558, -1889, 23062, 20158,
	-7093, -25777, -13326, 15221, 25383, 4886, -21512, -21928,
	4141, 25209, 15827, -12671, -25865, -7818, 19671, 23401,
	-1134, -24300, -18115, 9949, 25997, 10644, -17565, -24558,
	-1889, 23062, 20158, -7093, -25777, -13326, 15221, 25383,
	4886, -21512, -21928, 4141, 25209, 15827, -12671, -25865,
	-7818, 19671, 23401, -1134, -24300, -18115, 9949, 25997,
	10644, -17565, -24558, -1889, 23062, 20158, -7093, -25777,
	-13326, 15221, 25383, 4886, -21512, -21928, 4141, 25209,
	15827, -12671, -25865, -7818, 19671, 23401, -1134, -24300,
	-18115, 9949, 25997, 10644, -17565, -24558, -1889, 23062,
	20158, -7093, -25777, -13326, 15221, 25383, 4886, -21512,
	-21928, 4141, 25209, 15827, -12671, -25865, -7818, 19671,
	23401, -1134, -24300, -18115, 9949, 25997, 10644, -17565,
	-24558, -1889, 23062, 20158, -7093, -25777, -13326, 15221,
	25383, 4886, -21512, -21928, 4141, 25209, 15827, -12671,
	-25865, -7818, 19671, 23401, -1134, -24300, -18115, 9949,
	25997, 10644, -17565, -24558, -1889, 23062, 20158, -7093,
	-25777, -13326, 15221, 25383, 4886, -21512, -21928, 4141,
	25209, 15827, -12671, -25865, -7818, 19671, 23401, -1134,
	-24300, -18115, 9949, 25997, 10644, -17565, -24558, -1889,
	23062, 20158, -7093, -25777, -13326, 15221, 25383, 4886,
	-21512, -21928, 4141, 25209, 15827, -12671, -25865, -7818,
	19671, 23401, -1134, -24300, -18115, 9949, 25997, 10644,
	-17565, -24558, -1889, 23062, 20158, -7093, -25777, -13326,
	15221, 25383, 4886, -21512, -21928, 4141, 25209, 15827,
	-12671, -25865, -7818, 19671, 23401, -1134, -24300, -18115},
	{
// Carrier 34 Phase 2
	18384, 24163, 756, -23563, -19422, 8178, 25901, 12339,
	-16126, -25114, -3768, 22129, 21297, -5257, -25462, -14913,
	13649, 25725, 6729, -20394, -22885, 2266, 24680, 17284,
	-10988, -25989, -9599, 18384, 24163, 756, -23563, -19422,
	8178, 25901, 12339, -16126, -25114, -3768, 22129, 21297,
	-5257, -25462, -14913, 13649, 25725, 6729, -20394, -22885,
	2266, 24680, 17284, -10988, -25989, -9599, 18384, 24163,
	756, -23563, -19422, 8178, 25901, 12339, -16126, -25114,
	-3768, 22129, 21297, -5257, -25462, -14913, 13649, 25725,
	6729, -20394, -22885, 2266, 24680, 17284, -10988, -25989,
	-9599, 18384, 24163, 756, -23563, -19422, 8178, 25901,
	12339, -16126, -25114, -3768, 22129, 21297, -5257, -25462,
	-14913, 13649, 25725, 6729, -20394, -22885, 2265, 24680,
	17284, -10988, -25989, -9599, 18384, 24163, 756, -23563,
	-19422, 8178, 25901, 12339, -16126, -25114, -3768, 22129,
	21297, -5257, -25462, -14913, 13649, 25725, 6729, -20394,
	-22885, 2265, 24680, 17284, -10988, -25989, -9599, 18384,
	24163, 756, -23563, -19422, 8178, 25901, 12339, -16126,
	-25114, -3768, 22128, 21297, -5257, -25462, -14913, 13649,
	25725, 6729, -20394, -22885, 2265, 24680, 17284, -10988,
	-25989, -9599, 18384, 24163, 756, -23563, -19422, 8178,
	25901, 12339, -16126, -25114, -3768, 22128, 21298, -5257,
	-25462, -14913, 13649, 25725, 6729, -20394, -22885, 2265,
	24680, 17284, -10987, -25989, -9599, 18384, 24163, 756,
	-23563, -19422, 8178, 25901, 12339, -16126, -25114, -3768,
	22128, 21298, -5257, -25462, -14913, 13649, 25725, 6729,
	-20394, -22885, 2265, 24680, 17284, -10987, -25989, -9599},
	{
// Carrier 34 Phase 3
	24020, 18650, -9246, -25975, -11329, 17000, 24796, 2642,
	-22703, -20627, 6363, 25667, 13969, -14601, -25536, -5627,
	21078, 22325, -3393, -25013, -16421, 12005, 25931, 8536,
	-19169, -23721, 378, 24020, 18650, -9246, -25975, -11329,
	17000, 24796, 2642, -22703, -20627, 6363, 25667, 13969,
	-14601, -25536, -5627, 21078, 22325, -3393, -25013, -16421,
	12005, 25931, 8536, -19169, -23721, 378, 24020, 18650,
	-9246, -25975, -11329, 17000, 24796, 2642, -22703, -20627,
	6363, 25667, 13969, -14601, -25536, -5627, 21078, 22325,
	-3393, -25013, -16421, 12005, 25931, 8536, -19169, -23721,
	378, 24020, 18650, -9246, -25975, -11329, 17000, 24796,
	2642, -22703, -20627, 6363, 25667, 13969, -14601, -25536,
	-5627, 21078, 22325, -3393, -25013, -16421, 12005, 25931,
	8536, -19169, -23721, 378, 24020, 18650, -9246, -25975,
	-11329, 17000, 24796, 2642, -22703, -20627, 6363, 25667,
	13969, -14601, -25536, -5627, 21078, 22325, -3393, -25013,
	-16421, 12005, 25931, 8536, -19169, -23721, 378, 24020,
	18650, -9246, -25975, -11329, 17000, 24796, 2642, -22703,
	-20627, 6363, 25667, 13969, -14601, -25536, -5627, 21078,
	22325, -3393, -25013, -16421, 12005, 25931, 8536, -19169,
	-23721, 378, 24020, 18650, -9246, -25975, -11329, 17000,
	24796, 2642, -22703, -20627, 6363, 25667, 13969, -14601,
	-25536, -5627, 21078, 22325, -3393, -25013, -16421, 12005,
	25931, 8536, -19169, -23721, 378, 24020, 18650, -9246,
	-25975, -11329, 17000, 24796, 2642, -22703, -20627, 6363,
	25667, 13969, -14601, -25536, -5627, 21078, 22325, -3393,
	-25013, -16421, 12005, 25931, 8536, -19169, -23721, 378},
	{
// Carrier 34 Phase 4
	26000, 10298, -17842, -24432, -1511, 23234, 19917, -7456,
	-25824, -13000, 15526, 25299, 4514, -21722, -21722, 4514,
	25299, 15526, -12999, -25824, -7456, 19917, 23234, -1511,
	-24432, -17842, 10298, 26000, 10298, -17842, -24432, -1511,
	23234, 19917, -7456, -25824, -13000, 15526, 25299, 4514,
	-21722, -21722, 4514, 25299, 15526, -12999, -25824, -7456,
	19917, 23234, -1511, -24432, -17842, 10298, 26000, 10298,
	-17842, -24432, -1511, 23234, 19917, -7456, -25824, -13000,
	15526, 25299, 4514, -21722, -21722, 4514, 25299, 15526,
	-12999, -25824, -7456, 19917, 23234, -1511, -24431, -17842,
	10298, 26000, 10298, -17842, -24432, -1511, 23234, 19917,
	-7456, -25824, -13000, 15526, 25299, 4514, -21722, -21722,
	4514, 25299, 15526, -12999, -25824, -7456, 19917, 23234,
	-1511, -24431, -17842, 10298, 26000, 10298, -17842, -24432,
	-1511, 23234, 19917, -7456, -25824, -13000, 15526, 25299,
	4514, -21722, -21722, 4514, 25299, 15526, -12999, -25824,
	-7456, 19917, 23234, -1511, -24431, -17842, 10298, 26000,
	10298, -17842, -24432, -1511, 23234, 19917, -7456, -25824,
	-13000, 15526, 25299, 4514, -21722, -21722, 4514, 25299,
	15526, -12999, -25824, -7456, 19917, 23234, -1511, -24431,
	-17842, 10298, 26000, 10298, -17842, -24432, -1511, 23234,
	19917, -7456, -25824, -13000, 15526, 25299, 4514, -21722,
	-21722, 4514, 25299, 15526, -12999, -25824, -7456, 19917,
	23234, -1511, -24431, -17842, 10297, 26000, 10298, -17842,
	-24432, -1511, 23234, 19917, -7456, -25824, -13000, 15526,
	25299, 4514, -21722, -21722, 4514, 25299, 15526, -12999,
	-25824, -7456, 19917, 23234, -1511, -24431, -17842, 10297},
	{
// Carrier 34 Phase 5
	24020, 378, -23721, -19169, 8536, 25931, 12005, -16421,
	-25013, -3393, 22325, 21078, -5627, -25536, -14601, 13969,
	25667, 6363, -20627, -22703, 2642, 24796, 17000, -11329,
	-25975, -9246, 18650, 24020, 378, -23721, -19169, 8536,
	25931, 12005, -16421, -25013, -3393, 22325, 21078, -5627,
	-25536, -14601, 13969, 25667, 6363, -20627, -22703, 2642,
	24796, 17000, -11329, -25975, -9246, 18650, 24020, 378,
	-23721, -19169, 8536, 25931, 12005, -16421, -25013, -3393,
	22325, 21078, -5627, -25536, -14601, 13969, 25667, 6363,
	-20627, -22703, 2642, 24796, 17000, -11329, -25975, -9246,
	18650, 24020, 378, -23721, -19169, 8536, 25931, 12005,
	-16421, -25013, -3393, 22325, 21078, -5627, -25536, -14601,
	13969, 25667, 6363, -20627, -22703, 2642, 24796, 17000,
	-11329, -25975, -9246, 18650, 24020, 378, -23721, -19169,
	8536, 25931, 12005, -16420, -25013, -3393, 22325, 21078,
	-5627, -25536, -14601, 13969, 25667, 6363, -20627, -22703,
	2642, 24796, 17000, -11329, -25975, -9246, 18650, 24020,
	378, -23721, -19169, 8536, 25931, 12005, -16420, -25013,
	-3393, 22325, 21078, -5627, -25536, -14601, 13969, 25667,
	6363, -20627, -22703, 2642, 24796, 17000, -11329, -25975,
	-9246, 18650, 24020, 378, -23721, -19169, 8536, 25931,
	12005, -16420, -25013, -3393, 22325, 21078, -5627, -25536,
	-14601, 13969, 25667, 6363, -20627, -22703, 2642, 24796,
	17000, -11329, -25975, -9247, 18650, 24020, 378, -23721,
	-19169, 8536, 25931, 12005, -16420, -25013, -3393, 22325,
	21078, -5627, -25536, -14601, 13969, 25667, 6363, -20627,
	-22703, 2642, 24796, 17000, -11329, -25975, -9247, 18650},
	{
// Carrier 34 Phase 6
	18384, -9599, -25989, -10988, 17284, 24680, 2266, -22885,
	-20394, 6729, 25725, 13649, -14912, -25462, -5257, 21297,
	22129, -3768, -25114, -16126, 12339, 25901, 8178, -19422,
	-23564, 756, 24163, 18384, -9599, -25989, -10988, 17284,
	24680, 2266, -22885, -20394, 6729, 25725, 13649, -14912,
	-25462, -5257, 21297, 22129, -3768, -25114, -16126, 12339,
	25901, 8178, -19422, -23564, 756, 24163, 18384, -9599,
	-25989, -10988, 17284, 24680, 2266, -22885, -20394, 6729,
	25725, 13649, -14912, -25462, -5257, 21297, 22129, -3768,
	-25114, -16126, 12339, 25901, 8178, -19422, -23564, 756,
	24163, 18384, -9599, -25989, -10988, 17284, 24680, 2266,
	-22885, -20394, 6729, 25725, 13649, -14912, -25462, -5257,
	21297, 22129, -3768, -25114, -16126, 12339, 25901, 8178,
	-19422, -23564, 756, 24163, 18384, -9599, -25988, -10988,
	17284, 24680, 2266, -22885, -20394, 6729, 25725, 13649,
	-14912, -25462, -5257, 21297, 22129, -3768, -25114, -16126,
	12339, 25901, 8178, -19422, -23564, 756, 24163, 18384,
	-9599, -25988, -10988, 17284, 24680, 2266, -22885, -20394,
	6729, 25725, 13649, -14912, -25462, -5257, 21297, 22129,
	-3768, -25114, -16126, 12339, 25901, 8178, -19422, -23564,
	756, 24163, 18384, -9599, -25988, -10988, 17284, 24680,
	2266, -22885, -20394, 6729, 25725, 13649, -14912, -25462,
	-5257, 21297, 22129, -3768, -25114, -16126, 12339, 25901,
	8178, -19422, -23564, 756, 24163, 18384, -9599, -25988,
	-10988, 17284, 24680, 2266, -22885, -20394, 6729, 25725,
	13649, -14912, -25462, -5257, 21297, 22129, -3768, -25114,
	-16126, 12339, 25901, 8178, -19422, -23564, 756, 24162},
	{
// Carrier 34 Phase 7
	9949, -18115, -24300, -1134, 23401, 19671, -7818, -25865,
	-12671, 15827, 25209, 4141, -21928, -21512, 4886, 25383,
	15221, -13326, -25777, -7093, 20158, 23062, -1889, -24558,
	-17565, 10644, 25997, 9949, -18115, -24300, -1134, 23401,
	19671, -7818, -25865, -12671, 15827, 25209, 4141, -21928,
	-21512, 4886, 25383, 15221, -13326, -25777, -7093, 20158,
	23062, -1889, -24558, -17565, 10644, 25997, 9949, -18115,
	-24300, -1134, 23401, 19671, -7818, -25865, -12671, 15827,
	25209, 4142, -21928, -21512, 4886, 25383, 15221, -13326,
	-25777, -7093, 20158, 23062, -1889, -24558, -17565, 10644,
	25997, 9949, -18115, -24300, -1134, 23401, 19672, -7818,
	-25865, -12671, 15827, 25209, 4142, -21928, -21512, 4886,
	25383, 15221, -13326, -25777, -7093, 20158, 23062, -1889,
	-24558, -17565, 10644, 25997, 9949, -18115, -24300, -1134,
	23401, 19672, -7818, -25865, -12671, 15827, 25209, 4142,
	-21928, -21512, 4886, 25383, 15221, -13326, -25777, -7093,
	20158, 23062, -1889, -24558, -17565, 10644, 25997, 9949,
	-18115, -24300, -1134, 23401, 19672, -7818, -25865, -12671,
	15827, 25209, 4142, -21928, -21512, 4886, 25383, 15221,
	-13326, -25777, -7093, 20158, 23062, -1889, -24558, -17565,
	10644, 25997, 9949, -18115, -24300, -1134, 23401, 19672,
	-7818, -25865, -12671, 15827, 25209, 4142, -21928, -21512,
	4886, 25383, 15221, -13326, -25777, -7093, 20158, 23062,
	-1889, -24558, -17565, 10644, 25997, 9949, -18115, -24300,
	-1134, 23401, 19672, -7818, -25865, -12671, 15827, 25209,
	4142, -21928, -21512, 4886, 25383, 15221, -13326, -25777,
	-7093, 20158, 23062, -1889, -24558, -17565, 10644, 25997},
	},{{

// Carrier 35 Phase 0
	0, 24163, 17842, -10988, -25956, -8178, 19917, 22885,
	-3018, -25114, -15526, 13649, 25604, 5257, -21722, -21297,
	5996, 25725, 12999, -16126, -24907, -2266, 23234, 19422,
	-8892, -25989, -10298, 18384, 23873, -756, -24432, -17284,
	11668, 25901, 7456, -20394, -22516, 3768, 25299, 14912,
	-14287, -25462, -4514, 22129, 20855, -6729, -25824, -12339,
	16712, 24680, 1511, -23564, -18911, 9599, 26000, 9599,
	-18911, -23563, 1511, 24680, 16712, -12339, -25824, -6729,
	20855, 22128, -4514, -25462, -14287, 14913, 25299, 3768,
	-22516, -20394, 7457, 25901, 11668, -17284, -24431, -756,
	23873, 18384, -10298, -25988, -8892, 19422, 23234, -2266,
	-24907, -16125, 13000, 25725, 5995, -21298, -21722, 5257,
	25605, 13649, -15526, -25114, -3018, 22885, 19917, -8178,
	-25956, -10987, 17842, 24162, 0, -24163, -17842, 10988,
	25955, 8177, -19917, -22885, 3018, 25114, 15525, -13649,
	-25604, -5257, 21722, 21297, -5996, -25725, -12999, 16126,
	24907, 2265, -23234, -19422, 8892, 25989, 10297, -18384,
	-23873, 756, 24432, 17284, -11669, -25901, -7456, 20394,
	22516, -3768, -25299, -14912, 14287, 25462, 4514, -22129,
	-20855, 6729, 25824, 12339, -16712, -24680, -1511, 23564,
	18911, -9599, -26000, -9599, 18911, 23563, -1512, -24680,
	-16712, 12339, 25824, 6728, -20855, -22128, 4515, 25462,
	14286, -14913, -25299, -3767, 22516, 20394, -7457, -25901,
	-11668, 17284, 24431, 755, -23873, -18384, 10298, 25988,
	8892, -19422, -23234, 2266, 24907, 16125, -13000, -25725,
	-5995, 21298, 21722, -5258, -25605, -13649, 15526, 25113,
	3018, -22885, -19916, 8178, 25956, 10987, -17842, -24162},
	{
// Carrier 35 Phase 1
	9949, 25997, 9246, -19169, -23401, 1889, 24796, 16421,
	-12671, -25777, -6363, 21078, 21928, -4886, -25536, -13969,
	15221, 25209, 3393, -22703, -20158, 7818, 25931, 11329,
	-17565, -24300, -378, 24020, 18115, -10644, -25975, -8536,
	19672, 23062, -2642, -25013, -15827, 13326, 25667, 5627,
	-21512, -21512, 5627, 25667, 13326, -15827, -25013, -2642,
	23062, 19671, -8536, -25975, -10644, 18115, 24020, -378,
	-24300, -17565, 11329, 25931, 7818, -20158, -22703, 3393,
	25209, 15221, -13969, -25536, -4886, 21928, 21078, -6363,
	-25777, -12671, 16421, 24796, 1888, -23401, -19169, 9247,
	25997, 9949, -18650, -23721, 1134, 24558, 17000, -12005,
	-25865, -7093, 20627, 22325, -4142, -25383, -14601, 14601,
	25383, 4141, -22325, -20627, 7094, 25865, 12005, -17000,
	-24558, -1133, 23721, 18650, -9949, -25997, -9246, 19169,
	23401, -1889, -24796, -16420, 12671, 25777, 6363, -21078,
	-21928, 4887, 25536, 13969, -15221, -25209, -3393, 22703,
	20157, -7818, -25931, -11329, 17565, 24299, 377, -24020,
	-18115, 10644, 25975, 8535, -19672, -23062, 2642, 25013,
	15827, -13326, -25667, -5627, 21512, 21512, -5627, -25668,
	-13325, 15828, 25013, 2642, -23062, -19671, 8536, 25975,
	10643, -18115, -24020, 378, 24300, 17565, -11329, -25931,
	-7818, 20158, 22703, -3394, -25209, -15220, 13970, 25536,
	4886, -21928, -21078, 6363, 25777, 12670, -16421, -24796,
	-1888, 23401, 19168, -9247, -25997, -9949, 18650, 23721,
	-1134, -24558, -17000, 12005, 25865, 7093, -20627, -22325,
	4142, 25383, 14601, -14601, -25383, -4141, 22325, 20626,
	-7094, -25865, -12005, 17000, 24558, 1133, -23721, -18649},
	{
// Carrier 35 Phase 2
	18384, 23873, -756, -24432, -17284, 11668, 25901, 7456,
	-20394, -22516, 3768, 25299, 14912, -14287, -25462, -4514,
	22129, 20855, -6729, -25824, -12339, 16712, 24680, 1511,
	-23564, -18911, 9599, 26000, 9599, -18911, -23563, 1511,
	24680, 16712, -12339, -25824, -6729, 20855, 22128, -4514,
	-25462, -14287, 14913, 25299, 3768, -22516, -20394, 7456,
	25901, 11668, -17284, -24431, -756, 23873, 18384, -10298,
	-25988, -8892, 19422, 23234, -2266, -24907, -16126, 13000,
	25725, 5995, -21298, -21722, 5257, 25605, 13649, -15526,
	-25114, -3018, 22885, 19917, -8178, -25956, -10987, 17842,
	24162, 0, -24163, -17842, 10988, 25956, 8178, -19917,
	-22885, 3018, 25114, 15525, -13649, -25604, -5257, 21722,
	21297, -5996, -25725, -12999, 16126, 24907, 2265, -23234,
	-19422, 8892, 25989, 10297, -18384, -23873, 756, 24432,
	17284, -11668, -25901, -7456, 20394, 22516, -3768, -25299,
	-14912, 14287, 25462, 4514, -22129, -20855, 6729, 25824,
	12339, -16712, -24680, -1511, 23564, 18911, -9599, -26000,
	-9599, 18911, 23563, -1512, -24680, -16712, 12339, 25824,
	6729, -20855, -22128, 4515, 25462, 14286, -14913, -25299,
	-3767, 22516, 20394, -7457, -25901, -11668, 17284, 24431,
	755, -23873, -18384, 10298, 25988, 8892, -19422, -23234,
	2266, 24907, 16125, -13000, -25725, -5995, 21298, 21722,
	-5257, -25605, -13649, 15526, 25113, 3018, -22885, -19916,
	8178, 25956, 10987, -17842, -24162, 0, 24163, 17842,
	-10988, -25955, -8177, 19917, 22885, -3018, -25114, -15525,
	13649, 25604, 5257, -21722, -21297, 5996, 25725, 12999,
	-16126, -24907, -2265, 23234, 19422, -8892, -25989, -10297},
	{
// Carrier 35 Phase 3
	24020, 18115, -10644, -25975, -8536, 19671, 23062, -2642,
	-25013, -15827, 13326, 25667, 5627, -21512, -21512, 5627,
	25667, 13326, -15827, -25013, -2642, 23062, 19671, -8536,
	-25975, -10644, 18115, 24020, -378, -24300, -17565, 11329,
	25931, 7818, -20158, -22703, 3393, 25209, 15221, -13969,
	-25536, -4886, 21928, 21078, -6363, -25777, -12671, 16421,
	24796, 1889, -23401, -19169, 9247, 25997, 9949, -18650,
	-23721, 1134, 24558, 17000, -12005, -25865, -7093, 20627,
	22325, -4142, -25383, -14601, 14601, 25383, 4141, -22325,
	-20627, 7093, 25865, 12005, -17000, -24558, -1133, 23721,
	18650, -9949, -25997, -9246, 19169, 23401, -1889, -24796,
	-16420, 12671, 25777, 6363, -21078, -21928, 4886, 25536,
	13969, -15221, -25209, -3393, 22703, 20157, -7818, -25931,
	-11329, 17565, 24300, 377, -24020, -18115, 10644, 25975,
	8536, -19672, -23062, 2642, 25013, 15827, -13326, -25667,
	-5627, 21512, 21512, -5627, -25667, -13325, 15828, 25013,
	2642, -23062, -19671, 8536, 25975, 10643, -18115, -24020,
	378, 24300, 17565, -11329, -25931, -7818, 20158, 22703,
	-3393, -25209, -15220, 13970, 25536, 4886, -21928, -21078,
	6363, 25777, 12670, -16421, -24796, -1888, 23401, 19168,
	-9247, -25997, -9949, 18650, 23721, -1134, -24558, -17000,
	12005, 25865, 7093, -20627, -22325, 4142, 25383, 14601,
	-14601, -25383, -4141, 22325, 20626, -7094, -25865, -12005,
	17000, 24558, 1133, -23721, -18649, 9950, 25997, 9246,
	-19169, -23401, 1889, 24796, 16420, -12671, -25777, -6362,
	21079, 21927, -4887, -25536, -13969, 15221, 25209, 3393,
	-22703, -20157, 7818, 25931, 11329, -17565, -24299, -377},
	{
// Carrier 35 Phase 4
	26000, 9599, -18911, -23564, 1511, 24680, 16712, -12339,
	-25824, -6729, 20855, 22129, -4514, -25462, -14287, 14913,
	25299, 3768, -22516, -20394, 7456, 25901, 11668, -17284,
	-24431, -756, 23873, 18384, -10298, -25988, -8892, 19422,
	23234, -2266, -24907, -16126, 13000, 25725, 5995, -21297,
	-21722, 5257, 25605, 13649, -15526, -25114, -3018, 22885,
	19917, -8178, -25956, -10987, 17842, 24162, 0, -24163,
	-17842, 10988, 25956, 8178, -19917, -22885, 3018, 25114,
	15526, -13649, -25604, -5257, 21722, 21297, -5996, -25725,
	-12999, 16126, 24907, 2265, -23234, -19422, 8892, 25989,
	10297, -18384, -23873, 756, 24432, 17284, -11668, -25901,
	-7456, 20394, 22516, -3768, -25299, -14912, 14287, 25462,
	4514, -22129, -20855, 6729, 25824, 12339, -16712, -24680,
	-1511, 23564, 18911, -9599, -26000, -9599, 18911, 23563,
	-1511, -24680, -16712, 12339, 25824, 6729, -20855, -22128,
	4515, 25462, 14287, -14913, -25299, -3767, 22516, 20394,
	-7457, -25901, -11668, 17284, 24431, 755, -23873, -18384,
	10298, 25988, 8892, -19422, -23234, 2266, 24907, 16125,
	-13000, -25725, -5995, 21298, 21722, -5257, -25605, -13649,
	15526, 25113, 3018, -22885, -19916, 8178, 25956, 10987,
	-17842, -24162, 0, 24163, 17842, -10988, -25955, -8177,
	19917, 22885, -3018, -25114, -15525, 13649, 25604, 5257,
	-21722, -21297, 5996, 25725, 12999, -16126, -24907, -2265,
	23234, 19422, -8892, -25989, -10297, 18385, 23873, -756,
	-24432, -17284, 11669, 25901, 7456, -20395, -22516, 3768,
	25299, 14912, -14287, -25462, -4514, 22129, 20854, -6729,
	-25824, -12339, 16712, 24680, 1511, -23564, -18911, 9599},
	{
// Carrier 35 Phase 5
	24020, -378, -24300, -17565, 11329, 25931, 7818, -20158,
	-22703, 3393, 25209, 15221, -13969, -25536, -4886, 21928,
	21078, -6363, -25777, -12671, 16421, 24796, 1889, -23401,
	-19169, 9246, 25997, 9949, -18650, -23721, 1134, 24558,
	17000, -12005, -25865, -7093, 20627, 22325, -4142, -25383,
	-14601, 14601, 25383, 4141, -22325, -20627, 7093, 25865,
	12005, -17000, -24558, -1134, 23721, 18650, -9949, -25997,
	-9246, 19169, 23401, -1889, -24796, -16420, 12671, 25777,
	6363, -21078, -21928, 4886, 25536, 13969, -15221, -25209,
	-3393, 22703, 20158, -7818, -25931, -11329, 17565, 24300,
	377, -24020, -18115, 10644, 25975, 8536, -19672, -23062,
	2642, 25013, 15827, -13326, -25667, -5627, 21512, 21512,
	-5627, -25667, -13325, 15827, 25013, 2642, -23062, -19671,
	8536, 25975, 10644, -18115, -24020, 378, 24300, 17565,
	-11329, -25931, -7818, 20158, 22703, -3393, -25209, -15220,
	13969, 25536, 4886, -21928, -21078, 6363, 25777, 12670,
	-16421, -24796, -1888, 23401, 19169, -9247, -25997, -9949,
	18650, 23721, -1134, -24558, -17000, 12005, 25865, 7093,
	-20627, -22325, 4142, 25383, 14601, -14601, -25383, -4141,
	22325, 20627, -7094, -25865, -12005, 17000, 24558, 1133,
	-23721, -18650, 9950, 25997, 9246, -19169, -23401, 1889,
	24796, 16420, -12671, -25777, -6363, 21078, 21928, -4887,
	-25536, -13969, 15221, 25209, 3393, -22703, -20157, 7818,
	25931, 11329, -17565, -24299, -377, 24021, 18115, -10644,
	-25975, -8535, 19672, 23062, -2642, -25013, -15827, 13326,
	25667, 5627, -21512, -21512, 5627, 25668, 13325, -15828,
	-25013, -2642, 23062, 19671, -8536, -25975, -10643, 18115},
	{
// Carrier 35 Phase 6
	18384, -10298, -25989, -8892, 19422, 23234, -2266, -24907,
	-16126, 13000, 25725, 5995, -21297, -21722, 5257, 25605,
	13649, -15526, -25114, -3018, 22885, 19917, -8178, -25956,
	-10988, 17842, 24163, 0, -24163, -17842, 10988, 25956,
	8178, -19917, -22885, 3018, 25114, 15526, -13649, -25604,
	-5257, 21722, 21297, -5996, -25725, -12999, 16126, 24907,
	2265, -23234, -19422, 8892, 25989, 10297, -18384, -23873,
	756, 24432, 17284, -11668, -25901, -7456, 20394, 22516,
	-3768, -25299, -14912, 14287, 25462, 4514, -22129, -20855,
	6729, 25824, 12339, -16712, -24680, -1511, 23564, 18911,
	-9599, -26000, -9599, 18911, 23563, -1511, -24680, -16712,
	12339, 25824, 6729, -20855, -22128, 4515, 25462, 14287,
	-14913, -25299, -3768, 22516, 20394, -7457, -25901, -11668,
	17284, 24431, 755, -23873, -18384, 10298, 25988, 8892,
	-19422, -23234, 2266, 24907, 16125, -13000, -25725, -5995,
	21298, 21722, -5257, -25605, -13649, 15526, 25114, 3018,
	-22885, -19916, 8178, 25956, 10987, -17842, -24162, 0,
	24163, 17842, -10988, -25955, -8177, 19917, 22885, -3018,
	-25114, -15525, 13649, 25604, 5257, -21722, -21297, 5996,
	25725, 12999, -16126, -24907, -2265, 23234, 19422, -8892,
	-25989, -10297, 18385, 23873, -756, -24432, -17284, 11669,
	25901, 7456, -20395, -22516, 3768, 25299, 14912, -14287,
	-25462, -4514, 22129, 20854, -6729, -25824, -12339, 16712,
	24680, 1511, -23564, -18911, 9599, 26000, 9599, -18911,
	-23563, 1512, 24680, 16712, -12339, -25824, -6728, 20855,
	22128, -4515, -25462, -14286, 14913, 25299, 3767, -22516,
	-20394, 7457, 25901, 11668, -17284, -24431, -755, 23873},
	{
// Carrier 35 Phase 7
	9949, -18650, -23721, 1134, 24558, 17000, -12005, -25865,
	-7093, 20627, 22325, -4141, -25383, -14601, 14601, 25383,
	4141, -22325, -20627, 7093, 25865, 12005, -17000, -24558,
	-1134, 23721, 18650, -9949, -25997, -9246, 19169, 23401,
	-1889, -24796, -16420, 12671, 25777, 6363, -21078, -21928,
	4886, 25536, 13969, -15221, -25209, -3393, 22703, 20158,
	-7818, -25931, -11329, 17565, 24300, 378, -24020, -18115,
	10644, 25975, 8536, -19672, -23062, 2642, 25013, 15827,
	-13326, -25667, -5627, 21512, 21512, -5627, -25667, -13325,
	15827, 25013, 2642, -23062, -19671, 8536, 25975, 10644,
	-18115, -24020, 378, 24300, 17565, -11329, -25931, -7818,
	20158, 22703, -3393, -25209, -15221, 13969, 25536, 4886,
	-21928, -21078, 6363, 25777, 12670, -16421, -24796, -1888,
	23401, 19169, -9247, -25997, -9949, 18650, 23721, -1134,
	-24558, -17000, 12005, 25865, 7093, -20627, -22325, 4142,
	25383, 14601, -14601, -25383, -4141, 22325, 20627, -7094,
	-25865, -12005, 17000, 24558, 1133, -23721, -18650, 9950,
	25997, 9246, -19169, -23401, 1889, 24796, 16420, -12671,
	-25777, -6363, 21078, 21928, -4887, -25536, -13969, 15221,
	25209, 3393, -22703, -20157, 7818, 25931, 11329, -17565,
	-24299, -377, 24020, 18115, -10644, -25975, -8535, 19672,
	23062, -2642, -25013, -15827, 13326, 25667, 5627, -21512,
	-21512, 5627, 25668, 13325, -15828, -25013, -2642, 23062,
	19671, -8536, -25975, -10643, 18115, 24020, -378, -24300,
	-17565, 11329, 25931, 7817, -20158, -22703, 3394, 25209,
	15220, -13970, -25536, -4886, 21928, 21078, -6363, -25777,
	-12670, 16421, 24796, 1888, -23401, -19168, 9247, 25997},
	},{{

// Carrier 36 Phase 0
	0, 24432, 16712, -12999, -25605, -4514, 22516, 19917,
	-8892, -26000, -8892, 19917, 22516, -4514, -25604, -13000,
	16712, 24432, 0, -24431, -16712, 12999, 25605, 4514,
	-22516, -19917, 8892, 26000, 8892, -19917, -22516, 4514,
	25604, 13000, -16712, -24432, 0, 24431, 16712, -12999,
	-25605, -4514, 22516, 19917, -8892, -26000, -8892, 19917,
	22516, -4514, -25604, -13000, 16712, 24432, 0, -24431,
	-16712, 12999, 25605, 4515, -22516, -19917, 8892, 26000,
	8892, -19917, -22516, 4514, 25604, 13000, -16712, -24432,
	0, 24431, 16712, -12999, -25605, -4515, 22516, 19917,
	-8892, -26000, -8892, 19916, 22516, -4514, -25604, -13000,
	16712, 24432, 0, -24431, -16712, 12999, 25605, 4515,
	-22516, -19917, 8892, 26000, 8892, -19916, -22516, 4514,
	25604, 13000, -16712, -24432, 0, 24431, 16712, -12999,
	-25605, -4515, 22516, 19917, -8892, -26000, -8892, 19916,
	22516, -4514, -25604, -13000, 16712, 24432, 0, -24431,
	-16712, 12999, 25605, 4515, -22516, -19917, 8892, 26000,
	8892, -19916, -22516, 4514, 25604, 13000, -16712, -24432,
	0, 24431, 16712, -12999, -25605, -4515, 22516, 19917,
	-8892, -26000, -8893, 19916, 22516, -4514, -25604, -13000,
	16712, 24432, 0, -24431, -16712, 12999, 25605, 4515,
	-22516, -19917, 8891, 26000, 8893, -19916, -22516, 4514,
	25604, 13000, -16712, -24432, 0, 24431, 16712, -12999,
	-25605, -4515, 22516, 19917, -8891, -26000, -8893, 19916,
	22516, -4514, -25604, -13000, 16711, 24432, 0, -24431,
	-16713, 12999, 25605, 4515, -22516, -19917, 8891, 26000,
	8893, -19916, -22517, 4514, 25604, 13000, -16711, -24432},
	{
// Carrier 36 Phase 1
	9949, 25975, 7818, -20627, -21928, 5627, 25777, 12005,
	-17565, -24020, 1134, 24796, 15827, -13969, -25383, -3393,
	23062, 19169, -9949, -25975, -7818, 20627, 21928, -5627,
	-25777, -12005, 17565, 24020, -1134, -24796, -15827, 13969,
	25383, 3393, -23062, -19169, 9949, 25975, 7818, -20627,
	-21928, 5627, 25777, 12005, -17565, -24020, 1133, 24796,
	15827, -13969, -25383, -3393, 23062, 19169, -9949, -25975,
	-7818, 20627, 21928, -5627, -25777, -12005, 17565, 24020,
	-1133, -24796, -15827, 13969, 25383, 3393, -23062, -19169,
	9949, 25975, 7818, -20627, -21928, 5627, 25777, 12005,
	-17565, -24020, 1133, 24796, 15828, -13969, -25383, -3393,
	23062, 19169, -9949, -25975, -7818, 20627, 21928, -5627,
	-25777, -12005, 17565, 24020, -1133, -24796, -15828, 13969,
	25383, 3394, -23062, -19169, 9949, 25975, 7818, -20626,
	-21928, 5627, 25777, 12005, -17565, -24021, 1133, 24796,
	15828, -13969, -25383, -3394, 23062, 19169, -9949, -25975,
	-7818, 20626, 21928, -5627, -25777, -12005, 17565, 24021,
	-1133, -24796, -15828, 13969, 25383, 3394, -23062, -19169,
	9949, 25975, 7818, -20626, -21928, 5626, 25777, 12005,
	-17564, -24021, 1133, 24796, 15828, -13969, -25383, -3394,
	23062, 19169, -9949, -25975, -7818, 20626, 21928, -5626,
	-25777, -12005, 17564, 24021, -1133, -24796, -15828, 13969,
	25383, 3394, -23062, -19169, 9949, 25975, 7818, -20626,
	-21928, 5626, 25777, 12005, -17564, -24021, 1133, 24796,
	15828, -13969, -25383, -3394, 23062, 19169, -9949, -25975,
	-7818, 20626, 21928, -5626, -25777, -12006, 17564, 24021,
	-1133, -24796, -15828, 13969, 25383, 3394, -23061, -19169},
	{
// Carrier 36 Phase 2
	18384, 23564, -2266, -25114, -14913, 14912, 25114, 2266,
	-23563, -18384, 10988, 25901, 6729, -21297, -21297, 6729,
	25901, 10988, -18384, -23564, 2265, 25114, 14913, -14912,
	-25114, -2266, 23563, 18384, -10988, -25901, -6729, 21297,
	21298, -6729, -25901, -10988, 18384, 23564, -2265, -25114,
	-14913, 14912, 25114, 2266, -23563, -18384, 10987, 25901,
	6729, -21297, -21298, 6729, 25901, 10988, -18384, -23564,
	2265, 25114, 14913, -14912, -25114, -2266, 23563, 18384,
	-10987, -25901, -6729, 21297, 21298, -6729, -25901, -10988,
	18384, 23564, -2265, -25114, -14913, 14912, 25114, 2266,
	-23563, -18384, 10987, 25901, 6729, -21297, -21298, 6729,
	25901, 10988, -18384, -23564, 2265, 25113, 14913, -14912,
	-25114, -2266, 23563, 18385, -10987, -25901, -6729, 21297,
	21298, -6728, -25901, -10988, 18384, 23564, -2265, -25113,
	-14913, 14912, 25114, 2266, -23563, -18385, 10987, 25901,
	6729, -21297, -21298, 6728, 25901, 10988, -18384, -23564,
	2265, 25113, 14913, -14912, -25114, -2266, 23563, 18385,
	-10987, -25901, -6729, 21297, 21298, -6728, -25901, -10988,
	18384, 23564, -2265, -25113, -14913, 14912, 25114, 2266,
	-23563, -18385, 10987, 25901, 6729, -21297, -21298, 6728,
	25901, 10988, -18384, -23564, 2265, 25113, 14913, -14912,
	-25114, -2266, 23563, 18385, -10987, -25901, -6729, 21297,
	21298, -6728, -25901, -10988, 18384, 23564, -2265, -25113,
	-14913, 14912, 25114, 2266, -23563, -18385, 10987, 25901,
	6729, -21297, -21298, 6728, 25901, 10988, -18384, -23564,
	2265, 25113, 14913, -14912, -25114, -2266, 23563, 18385,
	-10987, -25901, -6729, 21297, 21298, -6728, -25900, -10988},
	{
// Carrier 36 Phase 3
	24020, 17565, -12005, -25777, -5627, 21928, 20627, -7818,
	-25975, -9949, 19169, 23062, -3393, -25383, -13969, 15827,
	24796, 1134, -24020, -17565, 12005, 25777, 5627, -21928,
	-20627, 7818, 25975, 9949, -19169, -23062, 3393, 25383,
	13969, -15827, -24796, -1134, 24020, 17565, -12005, -25777,
	-5627, 21928, 20627, -7818, -25975, -9949, 19169, 23062,
	-3393, -25383, -13969, 15827, 24796, 1134, -24020, -17565,
	12005, 25777, 5627, -21928, -20627, 7818, 25975, 9949,
	-19169, -23062, 3393, 25383, 13969, -15827, -24796, -1134,
	24020, 17565, -12005, -25777, -5627, 21928, 20627, -7818,
	-25975, -9950, 19169, 23062, -3393, -25383, -13970, 15827,
	24796, 1134, -24020, -17565, 12005, 25777, 5627, -21927,
	-20627, 7818, 25975, 9950, -19168, -23062, 3393, 25383,
	13970, -15827, -24796, -1134, 24020, 17565, -12005, -25777,
	-5627, 21927, 20627, -7817, -25975, -9950, 19168, 23062,
	-3393, -25383, -13970, 15827, 24796, 1134, -24020, -17565,
	12005, 25777, 5627, -21927, -20627, 7817, 25975, 9950,
	-19168, -23062, 3393, 25383, 13970, -15827, -24796, -1134,
	24020, 17565, -12005, -25777, -5627, 21927, 20627, -7817,
	-25975, -9950, 19168, 23062, -3393, -25383, -13970, 15827,
	24796, 1134, -24020, -17565, 12004, 25777, 5628, -21927,
	-20627, 7817, 25975, 9950, -19168, -23062, 3393, 25383,
	13970, -15827, -24796, -1134, 24020, 17565, -12004, -25777,
	-5628, 21927, 20627, -7817, -25975, -9950, 19168, 23062,
	-3393, -25383, -13970, 15827, 24796, 1134, -24020, -17565,
	12004, 25777, 5628, -21927, -20627, 7817, 25975, 9950,
	-19168, -23062, 3392, 25383, 13970, -15827, -24796, -1134},
	{
// Carrier 36 Phase 4
	26000, 8892, -19917, -22516, 4514, 25604, 13000, -16712,
	-24432, 0, 24431, 16712, -12999, -25605, -4514, 22516,
	19917, -8892, -26000, -8892, 19917, 22516, -4514, -25604,
	-13000, 16712, 24432, 0, -24431, -16712, 12999, 25605,
	4514, -22516, -19917, 8892, 26000, 8892, -19917, -22516,
	4514, 25604, 13000, -16712, -24432, 0, 24431, 16712,
	-12999, -25605, -4515, 22516, 19917, -8892, -26000, -8892,
	19917, 22516, -4514, -25604, -13000, 16712, 24432, 0,
	-24431, -16712, 12999, 25605, 4515, -22516, -19917, 8892,
	26000, 8892, -19916, -22516, 4514, 25604, 13000, -16712,
	-24432, 0, 24431, 16712, -12999, -25605, -4515, 22516,
	19917, -8892, -26000, -8892, 19916, 22516, -4514, -25604,
	-13000, 16712, 24432, 0, -24431, -16712, 12999, 25605,
	4515, -22516, -19917, 8892, 26000, 8892, -19916, -22516,
	4514, 25604, 13000, -16712, -24432, 0, 24431, 16712,
	-12999, -25605, -4515, 22516, 19917, -8892, -26000, -8892,
	19916, 22516, -4514, -25604, -13000, 16712, 24432, 0,
	-24431, -16712, 12999, 25605, 4515, -22516, -19917, 8892,
	26000, 8892, -19916, -22516, 4514, 25604, 13000, -16712,
	-24432, 0, 24431, 16712, -12999, -25605, -4515, 22516,
	19917, -8891, -26000, -8893, 19916, 22516, -4514, -25604,
	-13000, 16712, 24432, 0, -24431, -16712, 12999, 25605,
	4515, -22516, -19917, 8891, 26000, 8893, -19916, -22516,
	4514, 25604, 13000, -16711, -24432, 0, 24431, 16712,
	-12999, -25605, -4515, 22516, 19917, -8891, -26000, -8893,
	19916, 22517, -4514, -25604, -13000, 16711, 24432, 0,
	-24431, -16713, 12999, 25605, 4515, -22516, -19917, 8891},
	{
// Carrier 36 Phase 5
	24020, -1134, -24796, -15827, 13969, 25383, 3393, -23062,
	-19169, 9949, 25975, 7818, -20627, -21928, 5627, 25777,
	12005, -17565, -24020, 1134, 24796, 15827, -13969, -25383,
	-3393, 23062, 19169, -9949, -25975, -7818, 20627, 21928,
	-5627, -25777, -12005, 17565, 24020, -1133, -24796, -15827,
	13969, 25383, 3393, -23062, -19169, 9949, 25975, 7818,
	-20627, -21928, 5627, 25777, 12005, -17565, -24020, 1133,
	24796, 15827, -13969, -25383, -3393, 23062, 19169, -9949,
	-25975, -7818, 20627, 21928, -5627, -25777, -12005, 17565,
	24020, -1133, -24796, -15827, 13969, 25383, 3393, -23062,
	-19169, 9949, 25975, 7818, -20627, -21928, 5627, 25777,
	12005, -17565, -24020, 1133, 24796, 15828, -13969, -25383,
	-3393, 23062, 19169, -9949, -25975, -7818, 20626, 21928,
	-5627, -25777, -12005, 17565, 24021, -1133, -24796, -15828,
	13969, 25383, 3394, -23062, -19169, 9949, 25975, 7818,
	-20626, -21928, 5627, 25777, 12005, -17565, -24021, 1133,
	24796, 15828, -13969, -25383, -3394, 23062, 19169, -9949,
	-25975, -7818, 20626, 21928, -5626, -25777, -12005, 17565,
	24021, -1133, -24796, -15828, 13969, 25383, 3394, -23062,
	-19169, 9949, 25975, 7818, -20626, -21928, 5626, 25777,
	12005, -17564, -24021, 1133, 24796, 15828, -13969, -25383,
	-3394, 23062, 19169, -9949, -25975, -7818, 20626, 21928,
	-5626, -25777, -12005, 17564, 24021, -1133, -24796, -15828,
	13969, 25383, 3394, -23062, -19169, 9949, 25975, 7818,
	-20626, -21928, 5626, 25777, 12006, -17564, -24021, 1133,
	24796, 15828, -13969, -25383, -3394, 23061, 19169, -9949,
	-25975, -7818, 20626, 21928, -5626, -25777, -12006, 17564},
	{
// Carrier 36 Phase 6
	18384, -10988, -25901, -6729, 21297, 21297, -6729, -25901,
	-10988, 18384, 23564, -2265, -25114, -14913, 14912, 25114,
	2266, -23563, -18384, 10988, 25901, 6729, -21297, -21298,
	6729, 25901, 10988, -18384, -23564, 2265, 25114, 14913,
	-14912, -25114, -2266, 23563, 18384, -10987, -25901, -6729,
	21297, 21298, -6729, -25901, -10988, 18384, 23564, -2265,
	-25114, -14913, 14912, 25114, 2266, -23563, -18384, 10987,
	25901, 6729, -21297, -21298, 6729, 25901, 10988, -18384,
	-23564, 2265, 25114, 14913, -14912, -25114, -2266, 23563,
	18384, -10987, -25901, -6729, 21297, 21298, -6729, -25901,
	-10988, 18384, 23564, -2265, -25113, -14913, 14912, 25114,
	2266, -23563, -18385, 10987, 25901, 6729, -21297, -21298,
	6728, 25901, 10988, -18384, -23564, 2265, 25113, 14913,
	-14912, -25114, -2266, 23563, 18385, -10987, -25901, -6729,
	21297, 21298, -6728, -25901, -10988, 18384, 23564, -2265,
	-25113, -14913, 14912, 25114, 2266, -23563, -18385, 10987,
	25901, 6729, -21297, -21298, 6728, 25901, 10988, -18384,
	-23564, 2265, 25113, 14913, -14912, -25114, -2266, 23563,
	18385, -10987, -25901, -6729, 21297, 21298, -6728, -25901,
	-10988, 18384, 23564, -2265, -25113, -14913, 14912, 25114,
	2266, -23563, -18385, 10987, 25901, 6729, -21297, -21298,
	6728, 25901, 10988, -18384, -23564, 2265, 25113, 14913,
	-14912, -25114, -2266, 23563, 18385, -10987, -25901, -6729,
	21297, 21298, -6728, -25901, -10988, 18384, 23564, -2265,
	-25113, -14913, 14912, 25114, 2266, -23563, -18385, 10987,
	25901, 6729, -21297, -21298, 6728, 25901, 10988, -18384,
	-23564, 2265, 25113, 14913, -14912, -25114, -2266, 23563},
	{
// Carrier 36 Phase 7
	9949, -19169, -23062, 3393, 25383, 13969, -15827, -24796,
	-1134, 24020, 17565, -12005, -25777, -5627, 21928, 20627,
	-7818, -25975, -9949, 19169, 23062, -3393, -25383, -13969,
	15827, 24796, 1134, -24020, -17565, 12005, 25777, 5627,
	-21928, -20627, 7818, 25975, 9949, -19169, -23062, 3393,
	25383, 13969, -15827, -24796, -1134, 24020, 17565, -12005,
	-25777, -5627, 21928, 20627, -7818, -25975, -9949, 19169,
	23062, -3393, -25383, -13969, 15827, 24796, 1134, -24020,
	-17565, 12005, 25777, 5627, -21928, -20627, 7818, 25975,
	9949, -19169, -23062, 3393, 25383, 13970, -15827, -24796,
	-1134, 24020, 17565, -12005, -25777, -5627, 21928, 20627,
	-7818, -25975, -9950, 19168, 23062, -3393, -25383, -13970,
	15827, 24796, 1134, -24020, -17565, 12005, 25777, 5627,
	-21927, -20627, 7818, 25975, 9950, -19168, -23062, 3393,
	25383, 13970, -15827, -24796, -1134, 24020, 17565, -12005,
	-25777, -5627, 21927, 20627, -7817, -25975, -9950, 19168,
	23062, -3393, -25383, -13970, 15827, 24796, 1134, -24020,
	-17565, 12005, 25777, 5627, -21927, -20627, 7817, 25975,
	9950, -19168, -23062, 3393, 25383, 13970, -15827, -24796,
	-1134, 24020, 17565, -12004, -25777, -5627, 21927, 20627,
	-7817, -25975, -9950, 19168, 23062, -3393, -25383, -13970,
	15827, 24796, 1134, -24020, -17565, 12004, 25777, 5628,
	-21927, -20627, 7817, 25975, 9950, -19168, -23062, 3393,
	25383, 13970, -15827, -24796, -1134, 24020, 17565, -12004,
	-25777, -5628, 21927, 20627, -7817, -25975, -9950, 19168,
	23062, -3392, -25383, -13970, 15827, 24796, 1134, -24020,
	-17565, 12004, 25777, 5628, -21927, -20627, 7817, 25975},
	},{{

// Carrier 37 Phase 0
	0, 24680, 15526, -14912, -24907, -756, 24432, 16126,
	-14287, -25114, -1511, 24163, 16712, -13649, -25299, -2266,
	23873, 17284, -12999, -25462, -3018, 23563, 17842, -12339,
	-25605, -3768, 23234, 18384, -11668, -25725, -4514, 22885,
	18911, -10988, -25824, -5257, 22516, 19422, -10298, -25901,
	-5996, 22129, 19917, -9599, -25956, -6729, 21722, 20394,
	-8892, -25989, -7456, 21297, 20855, -8178, -26000, -8178,
	20855, 21297, -7456, -25988, -8892, 20394, 21722, -6729,
	-25956, -9599, 19917, 22129, -5995, -25901, -10298, 19422,
	22516, -5257, -25824, -10988, 18911, 22885, -4514, -25725,
	-11668, 18384, 23234, -3768, -25604, -12339, 17842, 23564,
	-3018, -25462, -13000, 17284, 23873, -2265, -25299, -13649,
	16712, 24163, -1511, -25114, -14287, 16126, 24432, -756,
	-24907, -14913, 15526, 24680, 0, -24680, -15526, 14912,
	24907, 756, -24431, -16126, 14287, 25114, 1511, -24162,
	-16712, 13649, 25299, 2266, -23873, -17284, 12999, 25462,
	3018, -23563, -17842, 12339, 25605, 3768, -23234, -18384,
	11668, 25725, 4514, -22885, -18911, 10987, 25824, 5257,
	-22516, -19422, 10297, 25901, 5996, -22128, -19917, 9599,
	25956, 6729, -21722, -20394, 8892, 25989, 7457, -21297,
	-20855, 8178, 26000, 8178, -20855, -21298, 7456, 25988,
	8892, -20394, -21722, 6729, 25956, 9599, -19917, -22129,
	5995, 25901, 10298, -19422, -22516, 5257, 25824, 10988,
	-18911, -22885, 4514, 25725, 11668, -18384, -23234, 3768,
	25604, 12339, -17842, -23564, 3018, 25462, 13000, -17284,
	-23873, 2265, 25299, 13649, -16712, -24163, 1511, 25114,
	14287, -16125, -24432, 756, 24907, 14913, -15525, -24680},
	{
// Carrier 37 Phase 1
	9949, 25931, 6363, -21928, -20158, 9246, 25975, 7093,
	-21512, -20627, 8536, 25997, 7818, -21078, -21078, 7818,
	25997, 8536, -20627, -21512, 7093, 25975, 9246, -20158,
	-21928, 6363, 25931, 9949, -19671, -22325, 5627, 25865,
	10644, -19169, -22703, 4886, 25777, 11329, -18650, -23062,
	4141, 25667, 12005, -18115, -23401, 3393, 25536, 12671,
	-17565, -23721, 2642, 25383, 13326, -17000, -24020, 1889,
	25209, 13969, -16421, -24300, 1134, 25013, 14601, -15827,
	-24558, 378, 24796, 15221, -15221, -24796, -378, 24558,
	15827, -14601, -25013, -1134, 24300, 16421, -13969, -25209,
	-1889, 24020, 17000, -13326, -25383, -2642, 23721, 17565,
	-12671, -25536, -3393, 23401, 18115, -12005, -25667, -4142,
	23062, 18650, -11329, -25777, -4886, 22703, 19169, -10644,
	-25865, -5627, 22325, 19672, -9949, -25931, -6363, 21928,
	20158, -9246, -25975, -7093, 21512, 20627, -8536, -25997,
	-7818, 21078, 21078, -7818, -25997, -8536, 20627, 21512,
	-7093, -25975, -9247, 20158, 21928, -6363, -25931, -9949,
	19671, 22325, -5627, -25865, -10644, 19169, 22703, -4886,
	-25777, -11329, 18650, 23062, -4141, -25667, -12005, 18115,
	23401, -3393, -25536, -12671, 17565, 23721, -2642, -25383,
	-13326, 17000, 24020, -1888, -25209, -13969, 16420, 24300,
	-1133, -25013, -14601, 15827, 24558, -378, -24796, -15221,
	15221, 24796, 378, -24558, -15827, 14601, 25013, 1134,
	-24300, -16421, 13969, 25209, 1889, -24020, -17000, 13325,
	25383, 2642, -23721, -17565, 12671, 25536, 3393, -23401,
	-18115, 12005, 25667, 4142, -23062, -18650, 11329, 25777,
	4886, -22703, -19169, 10644, 25865, 5627, -22325, -19672},
	{
// Carrier 37 Phase 2
	18384, 23234, -3768, -25604, -12339, 17842, 23564, -3018,
	-25462, -13000, 17284, 23873, -2266, -25299, -13649, 16712,
	24163, -1511, -25114, -14287, 16126, 24432, -756, -24907,
	-14913, 15526, 24680, 0, -24680, -15526, 14912, 24907,
	756, -24431, -16126, 14287, 25114, 1511, -24163, -16712,
	13649, 25299, 2266, -23873, -17284, 12999, 25462, 3018,
	-23563, -17842, 12339, 25605, 3768, -23234, -18384, 11668,
	25725, 4514, -22885, -18911, 10988, 25824, 5257, -22516,
	-19422, 10298, 25901, 5996, -22129, -19917, 9599, 25956,
	6729, -21722, -20394, 8892, 25989, 7456, -21297, -20855,
	8178, 26000, 8178, -20855, -21297, 7456, 25988, 8892,
	-20394, -21722, 6729, 25956, 9599, -19917, -22129, 5995,
	25901, 10298, -19422, -22516, 5257, 25824, 10988, -18911,
	-22885, 4514, 25725, 11668, -18384, -23234, 3768, 25604,
	12339, -17842, -23564, 3018, 25462, 13000, -17284, -23873,
	2265, 25299, 13649, -16712, -24163, 1511, 25114, 14287,
	-16126, -24432, 756, 24907, 14913, -15526, -24680, 0,
	24680, 15526, -14912, -24907, -756, 24431, 16126, -14287,
	-25114, -1511, 24162, 16712, -13649, -25299, -2266, 23873,
	17284, -12999, -25462, -3018, 23563, 17842, -12339, -25605,
	-3768, 23234, 18384, -11668, -25725, -4514, 22885, 18911,
	-10987, -25824, -5257, 22516, 19422, -10297, -25901, -5996,
	22128, 19917, -9599, -25956, -6729, 21722, 20394, -8892,
	-25989, -7457, 21297, 20855, -8178, -26000, -8178, 20855,
	21298, -7456, -25988, -8892, 20394, 21722, -6729, -25956,
	-9599, 19917, 22129, -5995, -25901, -10298, 19422, 22516,
	-5257, -25824, -10988, 18911, 22885, -4514, -25725, -11668},
	{
// Carrier 37 Phase 3
	24020, 17000, -13326, -25383, -2642, 23721, 17565, -12671,
	-25536, -3393, 23401, 18115, -12005, -25667, -4141, 23062,
	18650, -11329, -25777, -4886, 22703, 19169, -10644, -25865,
	-5627, 22325, 19671, -9949, -25931, -6363, 21928, 20158,
	-9246, -25975, -7093, 21512, 20627, -8536, -25997, -7818,
	21078, 21078, -7818, -25997, -8536, 20627, 21512, -7093,
	-25975, -9246, 20158, 21928, -6363, -25931, -9949, 19671,
	22325, -5627, -25865, -10644, 19169, 22703, -4886, -25777,
	-11329, 18650, 23062, -4141, -25667, -12005, 18115, 23401,
	-3393, -25536, -12671, 17565, 23721, -2642, -25383, -13326,
	17000, 24020, -1889, -25209, -13969, 16420, 24300, -1134,
	-25013, -14601, 15827, 24558, -378, -24796, -15221, 15221,
	24796, 378, -24558, -15827, 14601, 25013, 1134, -24300,
	-16421, 13969, 25209, 1889, -24020, -17000, 13326, 25383,
	2642, -23721, -17565, 12671, 25536, 3393, -23401, -18115,
	12005, 25667, 4142, -23062, -18650, 11329, 25777, 4886,
	-22703, -19169, 10644, 25865, 5627, -22325, -19672, 9949,
	25931, 6363, -21928, -20158, 9246, 25975, 7093, -21512,
	-20627, 8536, 25997, 7818, -21078, -21078, 7818, 25997,
	8536, -20627, -21512, 7093, 25975, 9247, -20158, -21928,
	6363, 25931, 9949, -19671, -22325, 5627, 25865, 10644,
	-19169, -22703, 4886, 25777, 11329, -18650, -23062, 4141,
	25667, 12005, -18115, -23401, 3393, 25536, 12671, -17565,
	-23721, 2642, 25383, 13326, -17000, -24020, 1888, 25209,
	13969, -16420, -24300, 1133, 25013, 14601, -15827, -24558,
	377, 24796, 15221, -15221, -24796, -378, 24558, 15827,
	-14601, -25013, -1134, 24300, 16421, -13969, -25209, -1889},
	{
// Carrier 37 Phase 4
	26000, 8178, -20855, -21297, 7456, 25989, 8892, -20394,
	-21722, 6729, 25956, 9599, -19917, -22129, 5995, 25901,
	10298, -19422, -22516, 5257, 25824, 10988, -18911, -22885,
	4514, 25725, 11668, -18384, -23234, 3768, 25604, 12339,
	-17842, -23564, 3018, 25462, 13000, -17284, -23873, 2266,
	25299, 13649, -16712, -24163, 1511, 25114, 14287, -16126,
	-24432, 756, 24907, 14913, -15526, -24680, 0, 24680,
	15526, -14912, -24907, -756, 24431, 16126, -14287, -25114,
	-1511, 24163, 16712, -13649, -25299, -2266, 23873, 17284,
	-12999, -25462, -3018, 23563, 17842, -12339, -25605, -3768,
	23234, 18384, -11668, -25725, -4514, 22885, 18911, -10988,
	-25824, -5257, 22516, 19422, -10297, -25901, -5996, 22128,
	19917, -9599, -25956, -6729, 21722, 20394, -8892, -25989,
	-7456, 21297, 20855, -8178, -26000, -8178, 20855, 21298,
	-7456, -25988, -8892, 20394, 21722, -6729, -25956, -9599,
	19917, 22129, -5995, -25901, -10298, 19422, 22516, -5257,
	-25824, -10988, 18911, 22885, -4514, -25725, -11668, 18384,
	23234, -3768, -25604, -12339, 17842, 23564, -3018, -25462,
	-13000, 17284, 23873, -2265, -25299, -13649, 16712, 24163,
	-1511, -25114, -14287, 16126, 24432, -756, -24907, -14913,
	15526, 24680, 0, -24680, -15526, 14912, 24907, 756,
	-24431, -16126, 14287, 25114, 1511, -24162, -16712, 13649,
	25299, 2266, -23873, -17284, 12999, 25462, 3018, -23563,
	-17842, 12339, 25605, 3768, -23234, -18384, 11668, 25725,
	4515, -22885, -18911, 10987, 25824, 5257, -22516, -19422,
	10297, 25901, 5996, -22128, -19917, 9599, 25956, 6729,
	-21722, -20394, 8892, 25989, 7457, -21297, -20855, 8177},
	{
// Carrier 37 Phase 5
	24020, -1889, -25209, -13969, 16421, 24300, -1134, -25013,
	-14601, 15827, 24558, -378, -24796, -15221, 15221, 24796,
	378, -24558, -15827, 14601, 25013, 1134, -24300, -16421,
	13969, 25209, 1889, -24020, -17000, 13326, 25383, 2642,
	-23721, -17565, 12671, 25536, 3393, -23401, -18115, 12005,
	25667, 4142, -23062, -18650, 11329, 25777, 4886, -22703,
	-19169, 10644, 25865, 5627, -22325, -19672, 9949, 25931,
	6363, -21928, -20158, 9246, 25975, 7093, -21512, -20627,
	8536, 25997, 7818, -21078, -21078, 7818, 25997, 8536,
	-20627, -21512, 7093, 25975, 9246, -20158, -21928, 6363,
	25931, 9949, -19671, -22325, 5627, 25865, 10644, -19169,
	-22703, 4886, 25777, 11329, -18650, -23062, 4141, 25667,
	12005, -18115, -23401, 3393, 25536, 12671, -17565, -23721,
	2642, 25383, 13326, -17000, -24020, 1889, 25209, 13969,
	-16420, -24300, 1134, 25013, 14601, -15827, -24558, 378,
	24796, 15221, -15221, -24796, -378, 24558, 15827, -14601,
	-25013, -1134, 24300, 16421, -13969, -25209, -1889, 24020,
	17000, -13326, -25383, -2642, 23721, 17565, -12671, -25536,
	-3393, 23401, 18115, -12005, -25667, -4142, 23062, 18650,
	-11329, -25777, -4886, 22703, 19169, -10644, -25865, -5627,
	22325, 19672, -9949, -25931, -6363, 21928, 20158, -9246,
	-25975, -7093, 21512, 20627, -8536, -25997, -7818, 21078,
	21078, -7818, -25997, -8536, 20627, 21512, -7093, -25975,
	-9247, 20158, 21928, -6363, -25931, -9949, 19671, 22325,
	-5627, -25865, -10644, 19169, 22703, -4886, -25777, -11329,
	18650, 23062, -4141, -25667, -12005, 18115, 23401, -3393,
	-25536, -12671, 17565, 23721, -2642, -25383, -13326, 17000},
	{
// Carrier 37 Phase 6
	18384, -11668, -25725, -4514, 22885, 18911, -10988, -25824,
	-5257, 22516, 19422, -10298, -25901, -5996, 22129, 19917,
	-9599, -25956, -6729, 21722, 20394, -8892, -25989, -7456,
	21297, 20855, -8178, -26000, -8178, 20855, 21297, -7456,
	-25989, -8892, 20394, 21722, -6729, -25956, -9599, 19917,
	22129, -5995, -25901, -10298, 19422, 22516, -5257, -25824,
	-10988, 18911, 22885, -4514, -25725, -11668, 18384, 23234,
	-3768, -25604, -12339, 17842, 23564, -3018, -25462, -13000,
	17284, 23873, -2265, -25299, -13649, 16712, 24163, -1511,
	-25114, -14287, 16126, 24432, -756, -24907, -14913, 15526,
	24680, 0, -24680, -15526, 14912, 24907, 756, -24431,
	-16126, 14287, 25114, 1511, -24163, -16712, 13649, 25299,
	2266, -23873, -17284, 12999, 25462, 3018, -23563, -17842,
	12339, 25605, 3768, -23234, -18384, 11668, 25725, 4514,
	-22885, -18911, 10987, 25824, 5257, -22516, -19422, 10297,
	25901, 5996, -22128, -19917, 9599, 25956, 6729, -21722,
	-20394, 8892, 25989, 7456, -21297, -20855, 8178, 26000,
	8178, -20855, -21298, 7456, 25988, 8892, -20394, -21722,
	6729, 25956, 9599, -19917, -22129, 5995, 25901, 10298,
	-19422, -22516, 5257, 25824, 10988, -18911, -22885, 4514,
	25725, 11668, -18384, -23234, 3768, 25604, 12339, -17842,
	-23564, 3018, 25462, 13000, -17284, -23873, 2265, 25299,
	13649, -16712, -24163, 1511, 25114, 14287, -16126, -24432,
	756, 24907, 14913, -15526, -24680, 0, 24680, 15526,
	-14912, -24907, -756, 24431, 16126, -14287, -25114, -1511,
	24162, 16712, -13649, -25299, -2266, 23873, 17284, -12999,
	-25462, -3018, 23563, 17842, -12339, -25605, -3768, 23234},
	{
// Carrier 37 Phase 7
	9949, -19671, -22325, 5627, 25865, 10644, -19169, -22703,
	4886, 25777, 11329, -18650, -23062, 4141, 25667, 12005,
	-18115, -23401, 3393, 25536, 12671, -17565, -23721, 2642,
	25383, 13326, -17000, -24020, 1889, 25209, 13969, -16421,
	-24300, 1134, 25013, 14601, -15827, -24558, 378, 24796,
	15221, -15221, -24796, -378, 24558, 15827, -14601, -25013,
	-1134, 24300, 16421, -13969, -25209, -1889, 24020, 17000,
	-13326, -25383, -2642, 23721, 17565, -12671, -25536, -3393,
	23401, 18115, -12005, -25667, -4142, 23062, 18650, -11329,
	-25777, -4886, 22703, 19169, -10644, -25865, -5627, 22325,
	19672, -9949, -25931, -6363, 21928, 20158, -9246, -25975,
	-7093, 21512, 20627, -8536, -25997, -7818, 21078, 21078,
	-7818, -25997, -8536, 20627, 21512, -7093, -25975, -9246,
	20158, 21928, -6363, -25931, -9949, 19671, 22325, -5627,
	-25865, -10644, 19169, 22703, -4886, -25777, -11329, 18650,
	23062, -4141, -25667, -12005, 18115, 23401, -3393, -25536,
	-12671, 17565, 23721, -2642, -25383, -13326, 17000, 24020,
	-1889, -25209, -13969, 16420, 24300, -1133, -25013, -14601,
	15827, 24558, -378, -24796, -15221, 15221, 24796, 378,
	-24558, -15827, 14601, 25013, 1134, -24300, -16421, 13969,
	25209, 1889, -24020, -17000, 13325, 25383, 2642, -23721,
	-17565, 12671, 25536, 3393, -23401, -18115, 12005, 25667,
	4142, -23062, -18650, 11329, 25777, 4886, -22703, -19169,
	10644, 25865, 5627, -22325, -19672, 9949, 25931, 6363,
	-21928, -20158, 9246, 25975, 7093, -21512, -20627, 8536,
	25997, 7818, -21078, -21078, 7818, 25997, 8536, -20627,
	-21512, 7093, 25975, 9247, -20158, -21928, 6363, 25931},
	},{{

// Carrier 38 Phase 0
	0, 24907, 14287, -16712, -23873, 3018, 25605, 11668,
	-18911, -22516, 5996, 25956, 8892, -20855, -20855, 8892,
	25956, 5995, -22516, -18911, 11668, 25604, 3018, -23873,
	-16712, 14287, 24907, 0, -24907, -14287, 16712, 23873,
	-3018, -25605, -11668, 18911, 22516, -5996, -25956, -8892,
	20855, 20855, -8892, -25956, -5995, 22516, 18911, -11668,
	-25604, -3018, 23873, 16712, -14287, -24907, 0, 24907,
	14287, -16712, -23873, 3018, 25605, 11668, -18911, -22516,
	5996, 25956, 8892, -20855, -20855, 8892, 25955, 5995,
	-22516, -18911, 11668, 25604, 3018, -23873, -16712, 14287,
	24907, 0, -24907, -14287, 16712, 23873, -3018, -25605,
	-11668, 18911, 22516, -5996, -25956, -8892, 20855, 20855,
	-8892, -25955, -5995, 22516, 18911, -11669, -25604, -3018,
	23873, 16712, -14287, -24907, 0, 24907, 14286, -16712,
	-23873, 3018, 25605, 11668, -18911, -22516, 5996, 25956,
	8892, -20855, -20854, 8892, 25955, 5995, -22516, -18911,
	11669, 25604, 3018, -23873, -16712, 14287, 24907, 0,
	-24907, -14286, 16712, 23873, -3018, -25605, -11668, 18912,
	22516, -5996, -25956, -8892, 20855, 20854, -8892, -25955,
	-5995, 22516, 18911, -11669, -25604, -3017, 23873, 16712,
	-14287, -24907, 0, 24907, 14286, -16712, -23873, 3018,
	25605, 11668, -18912, -22516, 5996, 25956, 8892, -20855,
	-20854, 8893, 25955, 5995, -22516, -18911, 11669, 25604,
	3017, -23873, -16712, 14287, 24907, 0, -24907, -14286,
	16712, 23873, -3019, -25605, -11668, 18912, 22516, -5996,
	-25956, -8891, 20855, 20854, -8893, -25955, -5995, 22516,
	18911, -11669, -25604, -3017, 23873, 16711, -14287, -24907},
	{
// Carrier 38 Phase 1
	9949, 25865, 4886, -23062, -18115, 12671, 25383, 1889,
	-24300, -15827, 15221, 24558, -1134, -25209, -13326, 17565,
	23401, -4142, -25777, -10644, 19672, 21928, -7093, -25997,
	-7818, 21512, 20158, -9949, -25865, -4886, 23062, 18115,
	-12671, -25383, -1889, 24300, 15827, -15221, -24558, 1134,
	25209, 13325, -17565, -23401, 4142, 25777, 10644, -19672,
	-21928, 7093, 25997, 7818, -21512, -20158, 9949, 25865,
	4886, -23062, -18115, 12671, 25383, 1888, -24300, -15827,
	15221, 24558, -1134, -25209, -13325, 17565, 23401, -4142,
	-25777, -10643, 19672, 21928, -7094, -25997, -7818, 21512,
	20157, -9950, -25865, -4886, 23062, 18115, -12671, -25383,
	-1888, 24300, 15827, -15221, -24558, 1134, 25209, 13325,
	-17565, -23401, 4142, 25777, 10643, -19672, -21928, 7094,
	25997, 7818, -21512, -20157, 9950, 25865, 4886, -23062,
	-18115, 12671, 25383, 1888, -24300, -15827, 15221, 24558,
	-1134, -25209, -13325, 17565, 23401, -4142, -25777, -10643,
	19672, 21927, -7094, -25997, -7817, 21512, 20157, -9950,
	-25865, -4886, 23062, 18115, -12671, -25383, -1888, 24300,
	15827, -15221, -24558, 1134, 25209, 13325, -17565, -23401,
	4142, 25777, 10643, -19672, -21927, 7094, 25997, 7817,
	-21512, -20157, 9950, 25865, 4886, -23062, -18115, 12671,
	25383, 1888, -24300, -15827, 15221, 24558, -1134, -25209,
	-13325, 17565, 23401, -4142, -25777, -10643, 19672, 21927,
	-7094, -25997, -7817, 21512, 20157, -9950, -25865, -4886,
	23062, 18114, -12671, -25383, -1888, 24300, 15827, -15221,
	-24558, 1134, 25209, 13325, -17565, -23401, 4142, 25777,
	10643, -19672, -21927, 7094, 25997, 7817, -21512, -20157},
	{
// Carrier 38 Phase 2
	18384, 22885, -5257, -25901, -9599, 20394, 21297, -8178,
	-25989, -6729, 22129, 19422, -10988, -25725, -3768, 23564,
	17284, -13649, -25114, -756, 24680, 14912, -16126, -24163,
	2266, 25462, 12339, -18384, -22885, 5257, 25901, 9599,
	-20394, -21297, 8178, 25988, 6729, -22129, -19422, 10988,
	25725, 3768, -23564, -17284, 13649, 25114, 756, -24680,
	-14912, 16126, 24162, -2266, -25462, -12339, 18384, 22885,
	-5257, -25901, -9599, 20394, 21297, -8178, -25988, -6729,
	22129, 19422, -10988, -25725, -3768, 23564, 17284, -13649,
	-25114, -755, 24680, 14912, -16126, -24162, 2266, 25462,
	12339, -18384, -22885, 5257, 25901, 9599, -20394, -21297,
	8178, 25988, 6729, -22129, -19422, 10988, 25725, 3767,
	-23564, -17284, 13649, 25113, 755, -24680, -14912, 16126,
	24162, -2266, -25462, -12339, 18385, 22885, -5257, -25901,
	-9599, 20395, 21297, -8178, -25988, -6728, 22129, 19422,
	-10988, -25725, -3767, 23564, 17284, -13649, -25113, -755,
	24680, 14912, -16126, -24162, 2266, 25462, 12339, -18385,
	-22885, 5258, 25901, 9598, -20395, -21297, 8178, 25988,
	6728, -22129, -19422, 10988, 25725, 3767, -23564, -17284,
	13649, 25113, 755, -24680, -14912, 16126, 24162, -2266,
	-25462, -12339, 18385, 22884, -5258, -25901, -9598, 20395,
	21297, -8178, -25988, -6728, 22129, 19422, -10988, -25725,
	-3767, 23564, 17284, -13649, -25113, -755, 24680, 14912,
	-16126, -24162, 2266, 25462, 12339, -18385, -22884, 5258,
	25901, 9598, -20395, -21297, 8178, 25988, 6728, -22129,
	-19422, 10988, 25725, 3767, -23564, -17284, 13649, 25113,
	755, -24680, -14912, 16126, 24162, -2266, -25462, -12339},
	{
// Carrier 38 Phase 3
	24020, 16421, -14601, -24796, 378, 25013, 13969, -17000,
	-23721, 3393, 25667, 11329, -19169, -22325, 6363, 25975,
	8536, -21078, -20627, 9246, 25931, 5627, -22703, -18650,
	12005, 25536, 2642, -24020, -16420, 14601, 24796, -378,
	-25013, -13969, 17000, 23721, -3393, -25667, -11329, 19169,
	22325, -6363, -25975, -8536, 21078, 20627, -9247, -25931,
	-5627, 22703, 18650, -12005, -25536, -2642, 24020, 16420,
	-14601, -24796, 378, 25013, 13969, -17000, -23721, 3393,
	25667, 11329, -19169, -22325, 6363, 25975, 8536, -21078,
	-20627, 9247, 25931, 5627, -22703, -18650, 12005, 25536,
	2642, -24020, -16420, 14601, 24796, -378, -25013, -13969,
	17000, 23721, -3393, -25668, -11329, 19169, 22325, -6363,
	-25975, -8535, 21078, 20626, -9247, -25931, -5627, 22703,
	18649, -12005, -25536, -2642, 24021, 16420, -14601, -24796,
	378, 25013, 13969, -17000, -23721, 3394, 25668, 11329,
	-19169, -22325, 6363, 25975, 8535, -21079, -20626, 9247,
	25931, 5627, -22703, -18649, 12005, 25536, 2642, -24021,
	-16420, 14602, 24796, -378, -25013, -13969, 17000, 23721,
	-3394, -25668, -11329, 19169, 22324, -6363, -25975, -8535,
	21079, 20626, -9247, -25931, -5626, 22703, 18649, -12005,
	-25536, -2642, 24021, 16420, -14602, -24796, 378, 25013,
	13969, -17000, -23721, 3394, 25668, 11329, -19169, -22324,
	6363, 25975, 8535, -21079, -20626, 9247, 25931, 5626,
	-22703, -18649, 12005, 25536, 2641, -24021, -16420, 14602,
	24796, -378, -25013, -13969, 17000, 23721, -3394, -25668,
	-11329, 19169, 22324, -6363, -25975, -8535, 21079, 20626,
	-9247, -25931, -5626, 22703, 18649, -12006, -25536, -2641},
	{
// Carrier 38 Phase 4
	26000, 7456, -21722, -19917, 10298, 25824, 4514, -23234,
	-17842, 13000, 25299, 1511, -24432, -15526, 15526, 24431,
	-1511, -25299, -12999, 17842, 23234, -4514, -25824, -10298,
	19917, 21722, -7456, -26000, -7456, 21722, 19917, -10298,
	-25824, -4514, 23234, 17842, -13000, -25299, -1511, 24432,
	15526, -15526, -24431, 1511, 25299, 12999, -17842, -23234,
	4514, 25824, 10297, -19917, -21722, 7457, 26000, 7456,
	-21722, -19917, 10298, 25824, 4514, -23234, -17842, 13000,
	25299, 1511, -24432, -15525, 15526, 24431, -1511, -25299,
	-12999, 17842, 23234, -4515, -25824, -10297, 19917, 21722,
	-7457, -26000, -7456, 21722, 19916, -10298, -25824, -4514,
	23234, 17842, -13000, -25299, -1511, 24432, 15525, -15526,
	-24431, 1512, 25299, 12999, -17842, -23234, 4515, 25824,
	10297, -19917, -21722, 7457, 26000, 7456, -21722, -19916,
	10298, 25824, 4514, -23234, -17842, 13000, 25299, 1511,
	-24432, -15525, 15526, 24431, -1512, -25299, -12999, 17842,
	23234, -4515, -25824, -10297, 19917, 21722, -7457, -26000,
	-7456, 21722, 19916, -10298, -25824, -4514, 23234, 17841,
	-13000, -25299, -1511, 24432, 15525, -15526, -24431, 1512,
	25299, 12999, -17842, -23234, 4515, 25824, 10297, -19917,
	-21722, 7457, 26000, 7456, -21722, -19916, 10298, 25824,
	4514, -23234, -17841, 13000, 25299, 1511, -24432, -15525,
	15526, 24431, -1512, -25299, -12999, 17842, 23234, -4515,
	-25824, -10297, 19917, 21722, -7457, -26000, -7456, 21723,
	19916, -10298, -25824, -4514, 23234, 17841, -13000, -25299,
	-1511, 24432, 15525, -15526, -24431, 1512, 25299, 12999,
	-17842, -23234, 4515, 25824, 10297, -19917, -21722, 7457},
	{
// Carrier 38 Phase 5
	24020, -2642, -25536, -12005, 18650, 22703, -5627, -25931,
	-9246, 20627, 21078, -8536, -25975, -6363, 22325, 19169,
	-11329, -25667, -3393, 23721, 17000, -13969, -25013, -378,
	24796, 14601, -16421, -24020, 2642, 25536, 12005, -18650,
	-22703, 5627, 25931, 9246, -20627, -21078, 8536, 25975,
	6363, -22325, -19169, 11329, 25667, 3393, -23721, -17000,
	13969, 25013, 377, -24796, -14601, 16421, 24020, -2642,
	-25536, -12005, 18650, 22703, -5627, -25931, -9246, 20627,
	21078, -8536, -25975, -6363, 22325, 19169, -11329, -25667,
	-3393, 23721, 17000, -13969, -25013, -377, 24796, 14601,
	-16421, -24020, 2642, 25536, 12005, -18650, -22703, 5627,
	25931, 9246, -20627, -21078, 8536, 25975, 6363, -22325,
	-19169, 11329, 25667, 3393, -23721, -17000, 13970, 25013,
	377, -24796, -14601, 16421, 24020, -2642, -25536, -12005,
	18650, 22703, -5627, -25931, -9246, 20627, 21078, -8536,
	-25975, -6362, 22325, 19168, -11329, -25667, -3393, 23721,
	17000, -13970, -25013, -377, 24796, 14601, -16421, -24020,
	2642, 25536, 12005, -18650, -22703, 5627, 25931, 9246,
	-20627, -21078, 8536, 25975, 6362, -22325, -19168, 11330,
	25667, 3393, -23721, -17000, 13970, 25013, 377, -24796,
	-14601, 16421, 24020, -2643, -25536, -12005, 18650, 22703,
	-5627, -25931, -9246, 20627, 21078, -8536, -25975, -6362,
	22325, 19168, -11330, -25667, -3393, 23721, 16999, -13970,
	-25013, -377, 24796, 14601, -16421, -24020, 2643, 25536,
	12004, -18650, -22703, 5628, 25931, 9246, -20627, -21078,
	8536, 25975, 6362, -22325, -19168, 11330, 25667, 3393,
	-23721, -16999, 13970, 25013, 377, -24796, -14601, 16421},
	{
// Carrier 38 Phase 6
	18384, -12339, -25462, -2266, 24163, 16126, -14913, -24680,
	756, 25114, 13649, -17284, -23563, 3768, 25725, 10988,
	-19422, -22129, 6729, 25989, 8178, -21297, -20394, 9599,
	25901, 5257, -22885, -18384, 12339, 25462, 2265, -24163,
	-16126, 14913, 24680, -756, -25114, -13649, 17284, 23563,
	-3768, -25725, -10987, 19422, 22128, -6729, -25989, -8178,
	21298, 20394, -9599, -25901, -5257, 22885, 18384, -12339,
	-25462, -2265, 24163, 16125, -14913, -24680, 756, 25114,
	13649, -17284, -23563, 3768, 25725, 10987, -19422, -22128,
	6729, 25989, 8177, -21298, -20394, 9599, 25901, 5257,
	-22885, -18384, 12339, 25462, 2265, -24163, -16125, 14913,
	24680, -756, -25114, -13649, 17284, 23563, -3768, -25725,
	-10987, 19422, 22128, -6729, -25989, -8177, 21298, 20394,
	-9599, -25901, -5257, 22885, 18384, -12339, -25462, -2265,
	24163, 16125, -14913, -24680, 756, 25114, 13649, -17284,
	-23563, 3768, 25725, 10987, -19422, -22128, 6729, 25989,
	8177, -21298, -20394, 9599, 25901, 5257, -22885, -18384,
	12339, 25462, 2265, -24163, -16125, 14913, 24680, -756,
	-25114, -13648, 17285, 23563, -3768, -25725, -10987, 19422,
	22128, -6729, -25989, -8177, 21298, 20394, -9599, -25901,
	-5257, 22885, 18384, -12340, -25462, -2265, 24163, 16125,
	-14913, -24680, 756, 25114, 13648, -17285, -23563, 3768,
	25725, 10987, -19423, -22128, 6729, 25989, 8177, -21298,
	-20394, 9599, 25901, 5257, -22885, -18384, 12340, 25462,
	2265, -24163, -16125, 14913, 24680, -756, -25114, -13648,
	17285, 23563, -3768, -25725, -10987, 19423, 22128, -6729,
	-25989, -8177, 21298, 20394, -9599, -25901, -5256, 22885},
	{
// Carrier 38 Phase 7
	9949, -20158, -21512, 7818, 25997, 7093, -21928, -19671,
	10644, 25777, 4141, -23401, -17565, 13326, 25209, 1134,
	-24558, -15221, 15827, 24300, -1889, -25383, -12671, 18115,
	23062, -4886, -25865, -9949, 20158, 21512, -7818, -25997,
	-7093, 21928, 19671, -10644, -25777, -4141, 23401, 17565,
	-13326, -25209, -1133, 24558, 15221, -15827, -24300, 1889,
	25383, 12671, -18115, -23062, 4886, 25865, 9949, -20158,
	-21512, 7818, 25997, 7093, -21928, -19671, 10644, 25777,
	4141, -23401, -17565, 13326, 25209, 1133, -24558, -15220,
	15827, 24300, -1889, -25383, -12670, 18115, 23062, -4887,
	-25865, -9949, 20158, 21512, -7818, -25997, -7093, 21928,
	19671, -10644, -25777, -4141, 23401, 17565, -13326, -25209,
	-1133, 24558, 15220, -15828, -24299, 1889, 25383, 12670,
	-18115, -23062, 4887, 25865, 9949, -20158, -21512, 7818,
	25997, 7093, -21928, -19671, 10644, 25777, 4141, -23401,
	-17565, 13326, 25209, 1133, -24558, -15220, 15828, 24299,
	-1889, -25383, -12670, 18115, 23062, -4887, -25865, -9949,
	20158, 21512, -7818, -25997, -7093, 21928, 19671, -10644,
	-25777, -4141, 23401, 17564, -13326, -25209, -1133, 24558,
	15220, -15828, -24299, 1889, 25383, 12670, -18115, -23062,
	4887, 25865, 9949, -20158, -21512, 7818, 25997, 7093,
	-21928, -19671, 10644, 25777, 4141, -23401, -17564, 13326,
	25209, 1133, -24558, -15220, 15828, 24299, -1889, -25383,
	-12670, 18115, 23062, -4887, -25865, -9949, 20158, 21512,
	-7818, -25997, -7093, 21928, 19671, -10644, -25777, -4141,
	23401, 17564, -13326, -25209, -1133, 24558, 15220, -15828,
	-24299, 1889, 25383, 12670, -18115, -23061, 4887, 25865},
	},{{

// Carrier 39 Phase 0
	0, 25114, 13000, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25113,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6728,
	-22516, -18384, 13000, 25113, 0, -25114, -12999, 18385,
	22516, -6729, -26000, -6728, 22516, 18384, -13000, -25113,
	0, 25114, 12999, -18385, -22516, 6729, 26000, 6728,
	-22516, -18384, 13000, 25113, 0, -25114, -12999, 18385,
	22516, -6729, -26000, -6728, 22516, 18384, -13000, -25113,
	0, 25114, 12999, -18385, -22516, 6729, 26000, 6728,
	-22516, -18384, 13000, 25113, 0, -25114, -12999, 18385,
	22516, -6729, -26000, -6728, 22516, 18384, -13000, -25113},
	{
// Carrier 39 Phase 1
	9949, 25777, 3393, -24020, -15827, 15827, 24020, -3393,
	-25777, -9949, 20627, 20627, -9949, -25777, -3393, 24020,
	15827, -15827, -24020, 3393, 25777, 9949, -20627, -20627,
	9949, 25777, 3393, -24020, -15827, 15827, 24020, -3393,
	-25777, -9949, 20627, 20627, -9949, -25777, -3393, 24020,
	15827, -15827, -24020, 3393, 25777, 9949, -20627, -20627,
	9949, 25777, 3393, -24020, -15827, 15827, 24020, -3393,
	-25777, -9949, 20627, 20627, -9949, -25777, -3393, 24020,
	15827, -15827, -24020, 3393, 25777, 9949, -20627, -20627,
	9949, 25777, 3393, -24020, -15827, 15827, 24020, -3393,
	-25777, -9949, 20627, 20627, -9949, -25777, -3393, 24020,
	15827, -15827, -24020, 3393, 25777, 9949, -20627, -20627,
	9949, 25777, 3393, -24020, -15827, 15827, 24020, -3393,
	-25777, -9949, 20627, 20627, -9949, -25777, -3393, 24020,
	15827, -15827, -24020, 3393, 25777, 9949, -20627, -20627,
	9950, 25777, 3393, -24020, -15827, 15828, 24020, -3393,
	-25777, -9949, 20627, 20627, -9950, -25777, -3393, 24020,
	15827, -15828, -24020, 3393, 25777, 9949, -20627, -20627,
	9950, 25777, 3393, -24020, -15827, 15828, 24020, -3393,
	-25777, -9949, 20627, 20626, -9950, -25777, -3393, 24020,
	15827, -15828, -24020, 3394, 25777, 9949, -20627, -20626,
	9950, 25777, 3393, -24020, -15827, 15828, 24020, -3394,
	-25777, -9949, 20627, 20626, -9950, -25777, -3393, 24021,
	15827, -15828, -24020, 3394, 25777, 9949, -20627, -20626,
	9950, 25777, 3393, -24021, -15827, 15828, 24020, -3394,
	-25777, -9949, 20627, 20626, -9950, -25777, -3393, 24021,
	15827, -15828, -24020, 3394, 25777, 9949, -20627, -20626},
	{
// Carrier 39 Phase 2
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25113, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25113, 0, 25114, 12999, -18385, -22516, 6729, 26000,
	6728, -22516, -18384, 13000, 25113, 0, -25114, -12999,
	18385, 22516, -6729, -26000, -6728, 22516, 18384, -13000,
	-25113, 0, 25114, 12999, -18385, -22516, 6729, 26000,
	6728, -22516, -18384, 13000, 25113, 0, -25114, -12999,
	18385, 22516, -6729, -26000, -6728, 22516, 18384, -13000,
	-25113, 0, 25114, 12999, -18385, -22516, 6729, 26000,
	6728, -22516, -18384, 13000, 25113, 0, -25114, -12999},
	{
// Carrier 39 Phase 3
	24020, 15827, -15827, -24020, 3393, 25777, 9949, -20627,
	-20627, 9949, 25777, 3393, -24020, -15827, 15827, 24020,
	-3393, -25777, -9949, 20627, 20627, -9949, -25777, -3393,
	24020, 15827, -15827, -24020, 3393, 25777, 9949, -20627,
	-20627, 9949, 25777, 3393, -24020, -15827, 15827, 24020,
	-3393, -25777, -9949, 20627, 20627, -9949, -25777, -3393,
	24020, 15827, -15827, -24020, 3393, 25777, 9949, -20627,
	-20627, 9949, 25777, 3393, -24020, -15827, 15827, 24020,
	-3393, -25777, -9949, 20627, 20627, -9949, -25777, -3393,
	24020, 15827, -15827, -24020, 3393, 25777, 9949, -20627,
	-20627, 9949, 25777, 3393, -24020, -15827, 15827, 24020,
	-3393, -25777, -9949, 20627, 20627, -9949, -25777, -3393,
	24020, 15827, -15827, -24020, 3393, 25777, 9949, -20627,
	-20627, 9949, 25777, 3393, -24020, -15827, 15827, 24020,
	-3393, -25777, -9949, 20627, 20627, -9949, -25777, -3393,
	24020, 15827, -15828, -24020, 3393, 25777, 9949, -20627,
	-20627, 9950, 25777, 3393, -24020, -15827, 15828, 24020,
	-3393, -25777, -9949, 20627, 20627, -9950, -25777, -3393,
	24020, 15827, -15828, -24020, 3393, 25777, 9949, -20627,
	-20626, 9950, 25777, 3393, -24020, -15827, 15828, 24020,
	-3394, -25777, -9949, 20627, 20626, -9950, -25777, -3393,
	24021, 15827, -15828, -24020, 3394, 25777, 9949, -20627,
	-20626, 9950, 25777, 3393, -24021, -15827, 15828, 24020,
	-3394, -25777, -9949, 20627, 20626, -9950, -25777, -3393,
	24021, 15827, -15828, -24020, 3394, 25777, 9949, -20627,
	-20626, 9950, 25777, 3393, -24021, -15827, 15828, 24020,
	-3394, -25777, -9949, 20627, 20626, -9950, -25777, -3393},
	{
// Carrier 39 Phase 4
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25113, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6728, -22516, -18384, 13000, 25113, 0, -25114,
	-12999, 18385, 22516, -6729, -26000, -6728, 22516, 18384,
	-13000, -25113, 0, 25114, 12999, -18385, -22516, 6729,
	26000, 6728, -22516, -18384, 13000, 25113, 0, -25114,
	-12999, 18385, 22516, -6729, -26000, -6728, 22516, 18384,
	-13000, -25113, 0, 25114, 12999, -18385, -22516, 6729,
	26000, 6728, -22516, -18384, 13000, 25113, 0, -25114,
	-12999, 18385, 22516, -6729, -26000, -6728, 22516, 18384,
	-13000, -25113, 0, 25114, 12999, -18385, -22516, 6729},
	{
// Carrier 39 Phase 5
	24020, -3393, -25777, -9949, 20627, 20627, -9949, -25777,
	-3393, 24020, 15827, -15827, -24020, 3393, 25777, 9949,
	-20627, -20627, 9949, 25777, 3393, -24020, -15827, 15827,
	24020, -3393, -25777, -9949, 20627, 20627, -9949, -25777,
	-3393, 24020, 15827, -15827, -24020, 3393, 25777, 9949,
	-20627, -20627, 9949, 25777, 3393, -24020, -15827, 15827,
	24020, -3393, -25777, -9949, 20627, 20627, -9949, -25777,
	-3393, 24020, 15827, -15827, -24020, 3393, 25777, 9949,
	-20627, -20627, 9949, 25777, 3393, -24020, -15827, 15827,
	24020, -3393, -25777, -9949, 20627, 20627, -9949, -25777,
	-3393, 24020, 15827, -15827, -24020, 3393, 25777, 9949,
	-20627, -20627, 9949, 25777, 3393, -24020, -15827, 15827,
	24020, -3393, -25777, -9949, 20627, 20627, -9949, -25777,
	-3393, 24020, 15827, -15827, -24020, 3393, 25777, 9949,
	-20627, -20627, 9949, 25777, 3393, -24020, -15827, 15827,
	24020, -3393, -25777, -9949, 20627, 20627, -9949, -25777,
	-3393, 24020, 15827, -15828, -24020, 3393, 25777, 9949,
	-20627, -20627, 9950, 25777, 3393, -24020, -15827, 15828,
	24020, -3393, -25777, -9949, 20627, 20627, -9950, -25777,
	-3393, 24020, 15827, -15828, -24020, 3393, 25777, 9949,
	-20627, -20626, 9950, 25777, 3393, -24020, -15827, 15828,
	24020, -3394, -25777, -9949, 20627, 20626, -9950, -25777,
	-3393, 24021, 15827, -15828, -24020, 3394, 25777, 9949,
	-20627, -20626, 9950, 25777, 3393, -24021, -15827, 15828,
	24020, -3394, -25777, -9949, 20627, 20626, -9950, -25777,
	-3393, 24021, 15827, -15828, -24020, 3394, 25777, 9949,
	-20627, -20626, 9950, 25777, 3393, -24021, -15827, 15828},
	{
// Carrier 39 Phase 6
	18384, -12999, -25114, 0, 25114, 13000, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25113, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6728, -22516, -18384, 13000, 25113, 0,
	-25114, -12999, 18385, 22516, -6729, -26000, -6728, 22516,
	18384, -13000, -25113, 0, 25114, 12999, -18385, -22516,
	6729, 26000, 6728, -22516, -18384, 13000, 25113, 0,
	-25114, -12999, 18385, 22516, -6729, -26000, -6728, 22516,
	18384, -13000, -25113, 0, 25114, 12999, -18385, -22516,
	6729, 26000, 6728, -22516, -18384, 13000, 25113, 0,
	-25114, -12999, 18385, 22516, -6729, -26000, -6728, 22516},
	{
// Carrier 39 Phase 7
	9949, -20627, -20627, 9949, 25777, 3393, -24020, -15827,
	15827, 24020, -3393, -25777, -9949, 20627, 20627, -9949,
	-25777, -3393, 24020, 15827, -15827, -24020, 3393, 25777,
	9949, -20627, -20627, 9949, 25777, 3393, -24020, -15827,
	15827, 24020, -3393, -25777, -9949, 20627, 20627, -9949,
	-25777, -3393, 24020, 15827, -15827, -24020, 3393, 25777,
	9949, -20627, -20627, 9949, 25777, 3393, -24020, -15827,
	15827, 24020, -3393, -25777, -9949, 20627, 20627, -9949,
	-25777, -3393, 24020, 15827, -15827, -24020, 3393, 25777,
	9949, -20627, -20627, 9949, 25777, 3393, -24020, -15827,
	15827, 24020, -3393, -25777, -9949, 20627, 20627, -9949,
	-25777, -3393, 24020, 15827, -15827, -24020, 3393, 25777,
	9949, -20627, -20627, 9949, 25777, 3393, -24020, -15827,
	15827, 24020, -3393, -25777, -9949, 20627, 20627, -9949,
	-25777, -3393, 24020, 15827, -15827, -24020, 3393, 25777,
	9949, -20627, -20627, 9950, 25777, 3393, -24020, -15827,
	15828, 24020, -3393, -25777, -9949, 20627, 20627, -9950,
	-25777, -3393, 24020, 15827, -15828, -24020, 3393, 25777,
	9949, -20627, -20627, 9950, 25777, 3393, -24020, -15827,
	15828, 24020, -3393, -25777, -9949, 20627, 20626, -9950,
	-25777, -3393, 24020, 15827, -15828, -24020, 3394, 25777,
	9949, -20627, -20626, 9950, 25777, 3393, -24020, -15827,
	15828, 24020, -3394, -25777, -9949, 20627, 20626, -9950,
	-25777, -3393, 24021, 15827, -15828, -24020, 3394, 25777,
	9949, -20627, -20626, 9950, 25777, 3393, -24021, -15827,
	15828, 24020, -3394, -25777, -9949, 20627, 20626, -9950,
	-25777, -3393, 24021, 15827, -15828, -24020, 3394, 25777},
	},{{

// Carrier 40 Phase 0
	0, 25299, 11668, -19917, -20855, 10298, 25605, 1511,
	-24907, -12999, 18911, 21722, -8892, -25824, -3018, 24432,
	14287, -17842, -22516, 7456, 25956, 4514, -23873, -15526,
	16712, 23234, -5996, -26000, -5996, 23234, 16712, -15526,
	-23873, 4514, 25956, 7456, -22516, -17842, 14287, 24432,
	-3018, -25824, -8892, 21722, 18911, -13000, -24907, 1511,
	25605, 10298, -20855, -19917, 11668, 25299, 0, -25299,
	-11668, 19917, 20855, -10298, -25604, -1511, 24907, 12999,
	-18911, -21722, 8892, 25824, 3018, -24432, -14287, 17842,
	22516, -7456, -25956, -4514, 23873, 15526, -16712, -23234,
	5996, 26000, 5996, -23234, -16712, 15526, 23873, -4514,
	-25956, -7456, 22516, 17842, -14287, -24432, 3018, 25824,
	8892, -21722, -18911, 13000, 24907, -1511, -25605, -10298,
	20855, 19917, -11668, -25299, 0, 25299, 11668, -19917,
	-20855, 10298, 25604, 1511, -24907, -12999, 18911, 21722,
	-8892, -25824, -3018, 24432, 14287, -17842, -22516, 7456,
	25956, 4514, -23873, -15526, 16712, 23234, -5996, -26000,
	-5995, 23234, 16712, -15526, -23873, 4514, 25956, 7456,
	-22516, -17842, 14287, 24431, -3018, -25824, -8892, 21722,
	18911, -13000, -24907, 1511, 25605, 10298, -20855, -19917,
	11668, 25299, 0, -25299, -11668, 19917, 20855, -10298,
	-25604, -1511, 24907, 12999, -18911, -21722, 8892, 25824,
	3018, -24432, -14287, 17842, 22516, -7456, -25956, -4514,
	23873, 15526, -16712, -23234, 5996, 26000, 5995, -23234,
	-16712, 15526, 23873, -4514, -25956, -7456, 22516, 17842,
	-14287, -24431, 3018, 25824, 8892, -21722, -18911, 13000,
	24907, -1511, -25605, -10298, 20855, 19917, -11668, -25299},
	{
// Carrier 40 Phase 1
	9949, 25667, 1889, -24796, -13326, 18650, 21928, -8536,
	-25865, -3393, 24300, 14601, -17565, -22703, 7093, 25975,
	4886, -23721, -15827, 16421, 23401, -5627, -25997, -6363,
	23062, 17000, -15221, -24020, 4141, 25931, 7818, -22325,
	-18115, 13969, 24558, -2642, -25777, -9246, 21512, 19169,
	-12671, -25013, 1134, 25536, 10644, -20627, -20158, 11329,
	25383, 378, -25209, -12005, 19671, 21078, -9949, -25667,
	-1889, 24796, 13326, -18650, -21928, 8536, 25865, 3393,
	-24300, -14601, 17565, 22703, -7093, -25975, -4886, 23721,
	15827, -16421, -23401, 5627, 25997, 6363, -23062, -17000,
	15221, 24020, -4141, -25931, -7818, 22325, 18115, -13969,
	-24558, 2642, 25777, 9246, -21512, -19169, 12671, 25013,
	-1134, -25536, -10644, 20627, 20158, -11329, -25383, -378,
	25209, 12005, -19671, -21078, 9949, 25667, 1889, -24796,
	-13326, 18650, 21928, -8536, -25865, -3393, 24300, 14601,
	-17565, -22703, 7093, 25975, 4886, -23721, -15827, 16421,
	23401, -5627, -25997, -6363, 23062, 17000, -15221, -24020,
	4141, 25931, 7818, -22325, -18115, 13969, 24558, -2642,
	-25777, -9246, 21512, 19169, -12671, -25013, 1134, 25536,
	10644, -20627, -20158, 11329, 25383, 378, -25209, -12005,
	19671, 21078, -9949, -25667, -1889, 24796, 13326, -18650,
	-21928, 8536, 25865, 3393, -24300, -14601, 17565, 22703,
	-7093, -25975, -4886, 23721, 15827, -16421, -23401, 5627,
	25997, 6363, -23062, -17000, 15221, 24020, -4141, -25931,
	-7818, 22325, 18115, -13969, -24558, 2642, 25777, 9246,
	-21512, -19169, 12671, 25013, -1134, -25536, -10644, 20627,
	20158, -11329, -25383, -378, 25209, 12005, -19671, -21078},
	{
// Carrier 40 Phase 2
	18384, 22129, -8178, -25901, -3768, 24163, 14912, -17284,
	-22885, 6729, 25989, 5257, -23564, -16126, 16126, 23564,
	-5257, -25989, -6729, 22885, 17284, -14912, -24163, 3768,
	25901, 8178, -22129, -18384, 13649, 24680, -2266, -25725,
	-9599, 21297, 19422, -12339, -25114, 756, 25462, 10988,
	-20394, -20394, 10988, 25462, 756, -25114, -12339, 19422,
	21297, -9599, -25725, -2266, 24680, 13649, -18384, -22129,
	8178, 25901, 3768, -24163, -14912, 17284, 22885, -6729,
	-25989, -5257, 23564, 16126, -16126, -23564, 5257, 25989,
	6729, -22885, -17284, 14912, 24163, -3768, -25901, -8178,
	22129, 18384, -13649, -24680, 2266, 25725, 9599, -21297,
	-19422, 12339, 25114, -756, -25462, -10988, 20394, 20394,
	-10988, -25462, -756, 25114, 12339, -19422, -21297, 9599,
	25725, 2266, -24680, -13649, 18384, 22129, -8178, -25901,
	-3768, 24163, 14912, -17284, -22885, 6729, 25989, 5257,
	-23564, -16126, 16126, 23563, -5257, -25989, -6729, 22885,
	17284, -14912, -24163, 3768, 25901, 8178, -22129, -18384,
	13649, 24680, -2266, -25725, -9599, 21297, 19422, -12339,
	-25114, 756, 25462, 10988, -20394, -20394, 10988, 25462,
	756, -25114, -12339, 19422, 21297, -9599, -25725, -2266,
	24680, 13649, -18384, -22129, 8178, 25901, 3768, -24163,
	-14912, 17284, 22885, -6729, -25989, -5257, 23564, 16126,
	-16126, -23563, 5257, 25989, 6729, -22885, -17284, 14913,
	24163, -3768, -25901, -8178, 22129, 18384, -13649, -24680,
	2266, 25725, 9599, -21297, -19422, 12339, 25114, -756,
	-25462, -10988, 20394, 20394, -10988, -25462, -756, 25114,
	12339, -19422, -21297, 9599, 25725, 2266, -24680, -13649},
	{
// Carrier 40 Phase 3
	24020, 15221, -17000, -23062, 6363, 25997, 5627, -23401,
	-16421, 15827, 23721, -4886, -25975, -7093, 22703, 17565,
	-14601, -24300, 3393, 25865, 8536, -21928, -18650, 13326,
	24796, -1889, -25667, -9949, 21078, 19671, -12005, -25209,
	378, 25383, 11329, -20158, -20627, 10644, 25536, 1134,
	-25013, -12671, 19169, 21512, -9246, -25777, -2642, 24558,
	13969, -18115, -22325, 7818, 25931, 4141, -24020, -15221,
	17000, 23062, -6363, -25997, -5627, 23401, 16421, -15827,
	-23721, 4886, 25975, 7093, -22703, -17565, 14601, 24300,
	-3393, -25865, -8536, 21928, 18650, -13326, -24796, 1889,
	25667, 9949, -21078, -19671, 12005, 25209, -378, -25383,
	-11329, 20158, 20627, -10644, -25536, -1134, 25013, 12671,
	-19169, -21512, 9246, 25777, 2642, -24558, -13969, 18115,
	22325, -7818, -25931, -4141, 24020, 15221, -17000, -23062,
	6363, 25997, 5627, -23401, -16421, 15827, 23721, -4886,
	-25975, -7093, 22703, 17565, -14601, -24300, 3393, 25865,
	8536, -21928, -18650, 13326, 24796, -1889, -25667, -9949,
	21078, 19671, -12005, -25209, 378, 25383, 11329, -20158,
	-20627, 10644, 25536, 1134, -25013, -12671, 19169, 21512,
	-9246, -25777, -2642, 24558, 13969, -18115, -22325, 7818,
	25931, 4141, -24020, -15221, 17000, 23062, -6363, -25997,
	-5627, 23401, 16421, -15827, -23721, 4886, 25975, 7093,
	-22703, -17565, 14601, 24300, -3393, -25865, -8536, 21928,
	18650, -13326, -24796, 1889, 25667, 9949, -21078, -19671,
	12005, 25209, -378, -25383, -11329, 20158, 20627, -10644,
	-25536, -1134, 25013, 12671, -19169, -21512, 9246, 25777,
	2642, -24558, -13969, 18115, 22325, -7818, -25931, -4141},
	{
// Carrier 40 Phase 4
	26000, 5996, -23234, -16712, 15526, 23873, -4514, -25956,
	-7456, 22516, 17842, -14287, -24432, 3018, 25824, 8892,
	-21722, -18911, 13000, 24907, -1511, -25605, -10298, 20855,
	19917, -11668, -25299, 0, 25299, 11668, -19917, -20855,
	10298, 25604, 1511, -24907, -12999, 18911, 21722, -8892,
	-25824, -3018, 24432, 14287, -17842, -22516, 7456, 25956,
	4514, -23873, -15526, 16712, 23234, -5996, -26000, -5996,
	23234, 16712, -15526, -23873, 4514, 25956, 7456, -22516,
	-17842, 14287, 24432, -3018, -25824, -8892, 21722, 18911,
	-13000, -24907, 1511, 25605, 10298, -20855, -19917, 11668,
	25299, 0, -25299, -11668, 19917, 20855, -10298, -25604,
	-1511, 24907, 12999, -18911, -21722, 8892, 25824, 3018,
	-24432, -14287, 17842, 22516, -7456, -25956, -4514, 23873,
	15526, -16712, -23234, 5996, 26000, 5995, -23234, -16712,
	15526, 23873, -4514, -25956, -7456, 22516, 17842, -14287,
	-24432, 3018, 25824, 8892, -21722, -18911, 13000, 24907,
	-1511, -25605, -10298, 20855, 19917, -11668, -25299, 0,
	25299, 11668, -19917, -20855, 10298, 25604, 1511, -24907,
	-12999, 18911, 21722, -8892, -25824, -3018, 24432, 14287,
	-17842, -22516, 7456, 25956, 4514, -23873, -15526, 16712,
	23234, -5996, -26000, -5995, 23234, 16712, -15526, -23873,
	4514, 25956, 7456, -22516, -17842, 14287, 24431, -3018,
	-25824, -8892, 21722, 18911, -13000, -24907, 1511, 25605,
	10298, -20855, -19917, 11668, 25299, 0, -25299, -11668,
	19917, 20855, -10298, -25604, -1511, 24907, 12999, -18911,
	-21722, 8892, 25824, 3018, -24432, -14287, 17842, 22516,
	-7456, -25956, -4514, 23873, 15526, -16712, -23234, 5996},
	{
// Carrier 40 Phase 5
	24020, -4141, -25931, -7818, 22325, 18115, -13969, -24558,
	2642, 25777, 9246, -21512, -19169, 12671, 25013, -1134,
	-25536, -10644, 20627, 20158, -11329, -25383, -378, 25209,
	12005, -19671, -21078, 9949, 25667, 1889, -24796, -13326,
	18650, 21928, -8536, -25865, -3393, 24300, 14601, -17565,
	-22703, 7093, 25975, 4886, -23721, -15827, 16421, 23401,
	-5627, -25997, -6363, 23062, 17000, -15221, -24020, 4141,
	25931, 7818, -22325, -18115, 13969, 24558, -2642, -25777,
	-9246, 21512, 19169, -12671, -25013, 1134, 25536, 10644,
	-20627, -20158, 11329, 25383, 378, -25209, -12005, 19671,
	21078, -9949, -25667, -1889, 24796, 13326, -18650, -21928,
	8536, 25865, 3393, -24300, -14601, 17565, 22703, -7093,
	-25975, -4886, 23721, 15827, -16421, -23401, 5627, 25997,
	6363, -23062, -17000, 15221, 24020, -4141, -25931, -7818,
	22325, 18115, -13969, -24558, 2642, 25777, 9246, -21512,
	-19169, 12671, 25013, -1134, -25536, -10644, 20627, 20158,
	-11329, -25383, -378, 25209, 12005, -19671, -21078, 9949,
	25667, 1889, -24796, -13326, 18650, 21928, -8536, -25865,
	-3393, 24300, 14601, -17565, -22703, 7093, 25975, 4886,
	-23721, -15827, 16421, 23401, -5627, -25997, -6363, 23062,
	17000, -15221, -24020, 4141, 25931, 7818, -22325, -18115,
	13969, 24558, -2642, -25777, -9246, 21512, 19169, -12671,
	-25013, 1134, 25536, 10644, -20627, -20158, 11329, 25383,
	378, -25209, -12005, 19671, 21078, -9949, -25667, -1889,
	24796, 13326, -18650, -21928, 8536, 25865, 3393, -24300,
	-14601, 17565, 22703, -7093, -25975, -4886, 23721, 15827,
	-16421, -23401, 5627, 25997, 6363, -23062, -17000, 15221},
	{
// Carrier 40 Phase 6
	18384, -13649, -24680, 2266, 25725, 9599, -21297, -19422,
	12339, 25114, -756, -25462, -10988, 20394, 20394, -10988,
	-25462, -756, 25114, 12339, -19422, -21297, 9599, 25725,
	2266, -24680, -13649, 18384, 22129, -8178, -25901, -3768,
	24163, 14912, -17284, -22885, 6729, 25989, 5257, -23564,
	-16126, 16126, 23564, -5257, -25989, -6729, 22885, 17284,
	-14912, -24163, 3768, 25901, 8178, -22129, -18384, 13649,
	24680, -2266, -25725, -9599, 21297, 19422, -12339, -25114,
	756, 25462, 10988, -20394, -20394, 10988, 25462, 756,
	-25114, -12339, 19422, 21297, -9599, -25725, -2266, 24680,
	13649, -18384, -22129, 8178, 25901, 3768, -24163, -14912,
	17284, 22885, -6729, -25989, -5257, 23564, 16126, -16126,
	-23564, 5257, 25989, 6729, -22885, -17284, 14912, 24163,
	-3768, -25901, -8178, 22129, 18384, -13649, -24680, 2266,
	25725, 9599, -21297, -19422, 12339, 25114, -756, -25462,
	-10988, 20394, 20394, -10988, -25462, -756, 25114, 12339,
	-19422, -21297, 9599, 25725, 2266, -24680, -13649, 18384,
	22129, -8178, -25901, -3768, 24163, 14912, -17284, -22885,
	6729, 25989, 5257, -23564, -16126, 16126, 23563, -5257,
	-25989, -6729, 22885, 17284, -14912, -24163, 3768, 25901,
	8178, -22129, -18384, 13649, 24680, -2266, -25725, -9599,
	21297, 19422, -12339, -25114, 756, 25462, 10988, -20394,
	-20394, 10988, 25462, 756, -25114, -12339, 19422, 21297,
	-9599, -25725, -2266, 24680, 13649, -18384, -22129, 8178,
	25901, 3768, -24163, -14912, 17284, 22885, -6729, -25989,
	-5257, 23564, 16126, -16126, -23563, 5257, 25989, 6729,
	-22885, -17284, 14913, 24163, -3768, -25901, -8178, 22129},
	{
// Carrier 40 Phase 7
	9949, -21078, -19671, 12005, 25209, -378, -25383, -11329,
	20158, 20627, -10644, -25536, -1134, 25013, 12671, -19169,
	-21512, 9246, 25777, 2642, -24558, -13969, 18115, 22325,
	-7818, -25931, -4141, 24020, 15221, -17000, -23062, 6363,
	25997, 5627, -23401, -16421, 15827, 23721, -4886, -25975,
	-7093, 22703, 17565, -14601, -24300, 3393, 25865, 8536,
	-21928, -18650, 13326, 24796, -1889, -25667, -9949, 21078,
	19671, -12005, -25209, 378, 25383, 11329, -20158, -20627,
	10644, 25536, 1134, -25013, -12671, 19169, 21512, -9246,
	-25777, -2642, 24558, 13969, -18115, -22325, 7818, 25931,
	4141, -24020, -15221, 17000, 23062, -6363, -25997, -5627,
	23401, 16421, -15827, -23721, 4886, 25975, 7093, -22703,
	-17565, 14601, 24300, -3393, -25865, -8536, 21928, 18650,
	-13326, -24796, 1889, 25667, 9949, -21078, -19671, 12005,
	25209, -378, -25383, -11329, 20158, 20627, -10644, -25536,
	-1134, 25013, 12671, -19169, -21512, 9246, 25777, 2642,
	-24558, -13969, 18115, 22325, -7818, -25931, -4141, 24020,
	15221, -17000, -23062, 6363, 25997, 5627, -23401, -16421,
	15827, 23721, -4886, -25975, -7093, 22703, 17565, -14601,
	-24300, 3393, 25865, 8536, -21928, -18650, 13326, 24796,
	-1889, -25667, -9949, 21078, 19671, -12005, -25209, 378,
	25383, 11329, -20158, -20627, 10644, 25536, 1134, -25013,
	-12671, 19169, 21512, -9246, -25777, -2642, 24558, 13969,
	-18115, -22325, 7818, 25931, 4141, -24020, -15221, 17000,
	23062, -6363, -25997, -5627, 23401, 16421, -15827, -23721,
	4886, 25975, 7093, -22703, -17565, 14601, 24300, -3393,
	-25865, -8536, 21928, 18650, -13326, -24796, 1889, 25667},
	},{{

// Carrier 41 Phase 0
	0, 25462, 10298, -21297, -18911, 13649, 24432, -3768,
	-25956, -6729, 23234, 16126, -16712, -22885, 7456, 25901,
	3018, -24680, -12999, 19422, 20855, -10988, -25299, 756,
	25605, 9599, -21722, -18384, 14287, 24163, -4514, -25989,
	-5995, 23564, 15526, -17284, -22516, 8178, 25824, 2266,
	-24907, -12339, 19917, 20394, -11668, -25114, 1511, 25725,
	8892, -22129, -17842, 14913, 23873, -5257, -26000, -5257,
	23873, 14912, -17842, -22129, 8892, 25725, 1511, -25114,
	-11668, 20394, 19917, -12339, -24907, 2266, 25824, 8178,
	-22516, -17284, 15526, 23563, -5996, -25988, -4514, 24163,
	14287, -18384, -21722, 9599, 25604, 756, -25299, -10987,
	20855, 19422, -13000, -24680, 3018, 25901, 7456, -22885,
	-16712, 16126, 23234, -6729, -25956, -3768, 24432, 13649,
	-18911, -21297, 10298, 25462, 0, -25462, -10297, 21298,
	18911, -13649, -24431, 3768, 25956, 6729, -23234, -16125,
	16712, 22885, -7457, -25901, -3018, 24680, 12999, -19422,
	-20855, 10988, 25299, -756, -25605, -9599, 21722, 18384,
	-14287, -24162, 4515, 25989, 5995, -23564, -15525, 17284,
	22516, -8178, -25824, -2265, 24907, 12339, -19917, -20394,
	11668, 25114, -1511, -25725, -8892, 22129, 17842, -14913,
	-23873, 5257, 26000, 5257, -23873, -14912, 17842, 22128,
	-8892, -25725, -1511, 25114, 11668, -20394, -19916, 12339,
	24907, -2266, -25824, -8177, 22516, 17284, -15526, -23563,
	5996, 25988, 4514, -24163, -14286, 18384, 21722, -9599,
	-25604, -755, 25299, 10987, -20855, -19422, 13000, 24680,
	-3018, -25901, -7456, 22885, 16712, -16126, -23234, 6729,
	25955, 3767, -24432, -13649, 18911, 21297, -10298, -25462},
	{
// Carrier 41 Phase 1
	9949, 25536, 378, -25383, -10644, 21078, 19169, -13326,
	-24558, 3393, 25931, 7093, -23062, -16421, 16421, 23062,
	-7093, -25931, -3393, 24558, 13326, -19169, -21078, 10644,
	25383, -378, -25536, -9949, 21512, 18650, -13969, -24300,
	4142, 25975, 6363, -23401, -15827, 17000, 22703, -7818,
	-25865, -2642, 24796, 12671, -19672, -20627, 11329, 25209,
	-1134, -25667, -9246, 21928, 18115, -14601, -24020, 4886,
	25997, 5627, -23721, -15221, 17565, 22325, -8536, -25777,
	-1889, 25013, 12005, -20158, -20158, 12005, 25013, -1889,
	-25777, -8536, 22325, 17565, -15221, -23721, 5627, 25997,
	4886, -24020, -14601, 18115, 21928, -9247, -25667, -1133,
	25209, 11329, -20627, -19671, 12671, 24796, -2642, -25865,
	-7818, 22703, 17000, -15827, -23401, 6363, 25975, 4141,
	-24300, -13969, 18650, 21512, -9949, -25536, -377, 25383,
	10644, -21078, -19169, 13326, 24558, -3393, -25931, -7093,
	23062, 16420, -16421, -23062, 7094, 25931, 3393, -24558,
	-13325, 19169, 21078, -10644, -25383, 378, 25536, 9949,
	-21512, -18650, 13969, 24300, -4142, -25975, -6363, 23401,
	15827, -17000, -22703, 7818, 25865, 2642, -24796, -12670,
	19672, 20627, -11329, -25209, 1134, 25667, 9246, -21928,
	-18115, 14601, 24020, -4887, -25997, -5627, 23721, 15220,
	-17565, -22325, 8536, 25777, 1888, -25013, -12005, 20158,
	20157, -12005, -25013, 1889, 25777, 8535, -22325, -17565,
	15221, 23721, -5627, -25997, -4886, 24020, 14601, -18115,
	-21928, 9247, 25667, 1133, -25209, -11329, 20627, 19671,
	-12671, -24796, 2642, 25865, 7818, -22703, -17000, 15828,
	23401, -6363, -25975, -4141, 24300, 13969, -18650, -21512},
	{
// Carrier 41 Phase 2
	18384, 21722, -9599, -25605, -756, 25299, 10988, -20855,
	-19422, 13000, 24680, -3018, -25901, -7456, 22885, 16712,
	-16126, -23234, 6729, 25956, 3768, -24432, -13649, 18911,
	21297, -10298, -25462, 0, 25462, 10298, -21297, -18911,
	13649, 24431, -3768, -25956, -6729, 23234, 16126, -16712,
	-22885, 7456, 25901, 3018, -24680, -12999, 19422, 20855,
	-10988, -25299, 756, 25605, 9599, -21722, -18384, 14287,
	24163, -4514, -25989, -5995, 23564, 15526, -17284, -22516,
	8178, 25824, 2265, -24907, -12339, 19917, 20394, -11668,
	-25114, 1511, 25725, 8892, -22129, -17842, 14913, 23873,
	-5257, -26000, -5257, 23873, 14912, -17842, -22128, 8892,
	25725, 1511, -25114, -11668, 20394, 19917, -12339, -24907,
	2266, 25824, 8178, -22516, -17284, 15526, 23563, -5996,
	-25988, -4514, 24163, 14287, -18384, -21722, 9599, 25604,
	756, -25299, -10987, 20855, 19422, -13000, -24680, 3018,
	25901, 7456, -22885, -16712, 16126, 23234, -6729, -25956,
	-3768, 24432, 13649, -18911, -21297, 10298, 25462, 0,
	-25462, -10297, 21298, 18911, -13649, -24431, 3768, 25956,
	6729, -23234, -16125, 16712, 22885, -7457, -25901, -3018,
	24680, 12999, -19422, -20855, 10988, 25299, -756, -25605,
	-9599, 21722, 18384, -14287, -24162, 4515, 25989, 5995,
	-23564, -15525, 17284, 22516, -8178, -25824, -2265, 24907,
	12339, -19917, -20394, 11669, 25113, -1512, -25725, -8892,
	22129, 17842, -14913, -23873, 5257, 26000, 5257, -23873,
	-14912, 17842, 22128, -8892, -25725, -1511, 25114, 11668,
	-20395, -19916, 12339, 24907, -2266, -25824, -8177, 22516,
	17284, -15526, -23563, 5996, 25988, 4514, -24163, -14286},
	{
// Carrier 41 Phase 3
	24020, 14601, -18115, -21928, 9246, 25667, 1134, -25209,
	-11329, 20627, 19671, -12671, -24796, 2642, 25865, 7818,
	-22703, -17000, 15827, 23401, -6363, -25975, -4141, 24300,
	13969, -18650, -21512, 9949, 25536, 378, -25383, -10644,
	21078, 19169, -13326, -24558, 3393, 25931, 7093, -23062,
	-16420, 16421, 23062, -7093, -25931, -3393, 24558, 13326,
	-19169, -21078, 10644, 25383, -378, -25536, -9949, 21512,
	18650, -13969, -24300, 4142, 25975, 6363, -23401, -15827,
	17000, 22703, -7818, -25865, -2642, 24796, 12671, -19672,
	-20627, 11329, 25209, -1134, -25667, -9246, 21928, 18115,
	-14601, -24020, 4886, 25997, 5627, -23721, -15221, 17565,
	22325, -8536, -25777, -1888, 25013, 12005, -20158, -20158,
	12005, 25013, -1889, -25777, -8536, 22325, 17565, -15221,
	-23721, 5627, 25997, 4886, -24020, -14601, 18115, 21928,
	-9247, -25667, -1133, 25209, 11329, -20627, -19671, 12671,
	24796, -2642, -25865, -7818, 22703, 17000, -15827, -23401,
	6363, 25975, 4141, -24300, -13969, 18650, 21512, -9949,
	-25536, -377, 25383, 10643, -21078, -19169, 13326, 24558,
	-3393, -25931, -7093, 23062, 16420, -16421, -23062, 7094,
	25931, 3393, -24558, -13325, 19169, 21078, -10644, -25383,
	378, 25536, 9949, -21512, -18650, 13970, 24299, -4142,
	-25975, -6363, 23401, 15827, -17000, -22703, 7818, 25865,
	2642, -24796, -12670, 19672, 20627, -11329, -25209, 1134,
	25668, 9246, -21928, -18115, 14601, 24020, -4887, -25997,
	-5627, 23721, 15220, -17565, -22325, 8536, 25777, 1888,
	-25013, -12005, 20158, 20157, -12005, -25013, 1889, 25777,
	8535, -22325, -17565, 15221, 23721, -5627, -25997, -4886},
	{
// Carrier 41 Phase 4
	26000, 5257, -23873, -14912, 17842, 22129, -8892, -25725,
	-1511, 25114, 11668, -20394, -19917, 12339, 24907, -2266,
	-25824, -8178, 22516, 17284, -15526, -23563, 5996, 25989,
	4514, -24163, -14287, 18384, 21722, -9599, -25604, -756,
	25299, 10988, -20855, -19422, 13000, 24680, -3018, -25901,
	-7456, 22885, 16712, -16126, -23234, 6729, 25956, 3768,
	-24432, -13649, 18911, 21297, -10298, -25462, 0, 25462,
	10297, -21298, -18911, 13649, 24431, -3768, -25956, -6729,
	23234, 16126, -16712, -22885, 7456, 25901, 3018, -24680,
	-12999, 19422, 20855, -10988, -25299, 756, 25605, 9599,
	-21722, -18384, 14287, 24162, -4514, -25989, -5995, 23564,
	15526, -17284, -22516, 8178, 25824, 2265, -24907, -12339,
	19917, 20394, -11668, -25114, 1511, 25725, 8892, -22129,
	-17842, 14913, 23873, -5257, -26000, -5257, 23873, 14912,
	-17842, -22128, 8892, 25725, 1511, -25114, -11668, 20394,
	19917, -12339, -24907, 2266, 25824, 8177, -22516, -17284,
	15526, 23563, -5996, -25988, -4514, 24163, 14287, -18384,
	-21722, 9599, 25604, 755, -25299, -10987, 20855, 19422,
	-13000, -24680, 3018, 25901, 7456, -22885, -16712, 16126,
	23234, -6729, -25955, -3767, 24432, 13649, -18911, -21297,
	10298, 25462, 0, -25462, -10297, 21298, 18911, -13649,
	-24431, 3768, 25956, 6729, -23234, -16125, 16712, 22885,
	-7457, -25901, -3018, 24680, 12999, -19422, -20855, 10988,
	25299, -756, -25605, -9599, 21722, 18384, -14287, -24162,
	4515, 25989, 5995, -23564, -15525, 17284, 22516, -8178,
	-25824, -2265, 24907, 12339, -19917, -20394, 11669, 25113,
	-1512, -25725, -8892, 22129, 17842, -14913, -23873, 5257},
	{
// Carrier 41 Phase 5
	24020, -4886, -25997, -5627, 23721, 15221, -17565, -22325,
	8536, 25777, 1889, -25013, -12005, 20158, 20158, -12005,
	-25013, 1889, 25777, 8536, -22325, -17565, 15221, 23721,
	-5627, -25997, -4886, 24020, 14601, -18115, -21928, 9246,
	25667, 1134, -25209, -11329, 20627, 19671, -12671, -24796,
	2642, 25865, 7818, -22703, -17000, 15827, 23401, -6363,
	-25975, -4141, 24300, 13969, -18650, -21512, 9949, 25536,
	378, -25383, -10644, 21078, 19169, -13326, -24558, 3393,
	25931, 7093, -23062, -16420, 16421, 23062, -7093, -25931,
	-3393, 24558, 13326, -19169, -21078, 10644, 25383, -378,
	-25536, -9949, 21512, 18650, -13969, -24300, 4142, 25975,
	6363, -23401, -15827, 17000, 22703, -7818, -25865, -2642,
	24796, 12671, -19672, -20627, 11329, 25209, -1134, -25667,
	-9246, 21928, 18115, -14601, -24020, 4886, 25997, 5627,
	-23721, -15221, 17565, 22325, -8536, -25777, -1888, 25013,
	12005, -20158, -20157, 12005, 25013, -1889, -25777, -8536,
	22325, 17565, -15221, -23721, 5627, 25997, 4886, -24020,
	-14601, 18115, 21928, -9247, -25667, -1133, 25209, 11329,
	-20627, -19671, 12671, 24796, -2642, -25865, -7818, 22703,
	17000, -15828, -23401, 6363, 25975, 4141, -24300, -13969,
	18650, 21512, -9950, -25536, -377, 25383, 10643, -21078,
	-19169, 13326, 24558, -3393, -25931, -7093, 23062, 16420,
	-16421, -23062, 7094, 25931, 3393, -24558, -13325, 19169,
	21078, -10644, -25383, 378, 25536, 9949, -21512, -18649,
	13970, 24299, -4142, -25975, -6363, 23401, 15827, -17000,
	-22703, 7818, 25865, 2642, -24796, -12670, 19672, 20626,
	-11329, -25209, 1134, 25668, 9246, -21928, -18115, 14601},
	{
// Carrier 41 Phase 6
	18384, -14287, -24163, 4514, 25989, 5996, -23564, -15526,
	17284, 22516, -8178, -25824, -2266, 24907, 12339, -19917,
	-20394, 11668, 25114, -1511, -25725, -8892, 22129, 17842,
	-14913, -23873, 5257, 26000, 5257, -23873, -14912, 17842,
	22129, -8892, -25725, -1511, 25114, 11668, -20394, -19917,
	12339, 24907, -2266, -25824, -8178, 22516, 17284, -15526,
	-23563, 5996, 25988, 4514, -24163, -14287, 18384, 21722,
	-9599, -25604, -756, 25299, 10987, -20855, -19422, 13000,
	24680, -3018, -25901, -7456, 22885, 16712, -16126, -23234,
	6729, 25956, 3768, -24432, -13649, 18911, 21297, -10298,
	-25462, 0, 25462, 10297, -21298, -18911, 13649, 24431,
	-3768, -25956, -6729, 23234, 16126, -16712, -22885, 7457,
	25901, 3018, -24680, -12999, 19422, 20855, -10988, -25299,
	756, 25605, 9599, -21722, -18384, 14287, 24162, -4515,
	-25989, -5995, 23564, 15525, -17284, -22516, 8178, 25824,
	2265, -24907, -12339, 19917, 20394, -11668, -25114, 1511,
	25725, 8892, -22129, -17842, 14913, 23873, -5257, -26000,
	-5257, 23873, 14912, -17842, -22128, 8892, 25725, 1511,
	-25114, -11668, 20394, 19917, -12339, -24907, 2266, 25824,
	8177, -22516, -17284, 15526, 23563, -5996, -25988, -4514,
	24163, 14287, -18384, -21722, 9599, 25604, 755, -25299,
	-10987, 20855, 19422, -13000, -24680, 3018, 25901, 7456,
	-22885, -16712, 16126, 23234, -6729, -25955, -3767, 24432,
	13649, -18911, -21297, 10298, 25462, 0, -25462, -10297,
	21298, 18911, -13649, -24431, 3768, 25956, 6728, -23234,
	-16125, 16712, 22885, -7457, -25901, -3018, 24680, 12999,
	-19422, -20855, 10988, 25299, -756, -25605, -9599, 21722},
	{
// Carrier 41 Phase 7
	9949, -21512, -18650, 13969, 24300, -4141, -25975, -6363,
	23401, 15827, -17000, -22703, 7818, 25865, 2642, -24796,
	-12671, 19671, 20627, -11329, -25209, 1134, 25667, 9246,
	-21928, -18115, 14601, 24020, -4886, -25997, -5627, 23721,
	15221, -17565, -22325, 8536, 25777, 1889, -25013, -12005,
	20158, 20158, -12005, -25013, 1889, 25777, 8536, -22325,
	-17565, 15221, 23721, -5627, -25997, -4886, 24020, 14601,
	-18115, -21928, 9246, 25667, 1134, -25209, -11329, 20627,
	19671, -12671, -24796, 2642, 25865, 7818, -22703, -17000,
	15827, 23401, -6363, -25975, -4141, 24300, 13969, -18650,
	-21512, 9949, 25536, 378, -25383, -10644, 21078, 19169,
	-13326, -24558, 3393, 25931, 7093, -23062, -16420, 16421,
	23062, -7093, -25931, -3393, 24558, 13325, -19169, -21078,
	10644, 25383, -378, -25536, -9949, 21512, 18650, -13969,
	-24300, 4142, 25975, 6363, -23401, -15827, 17000, 22703,
	-7818, -25865, -2642, 24796, 12670, -19672, -20627, 11329,
	25209, -1134, -25667, -9246, 21928, 18115, -14601, -24020,
	4886, 25997, 5627, -23721, -15220, 17565, 22325, -8536,
	-25777, -1888, 25013, 12005, -20158, -20157, 12005, 25013,
	-1889, -25777, -8536, 22325, 17565, -15221, -23721, 5627,
	25997, 4886, -24020, -14601, 18115, 21928, -9247, -25667,
	-1133, 25209, 11329, -20627, -19671, 12671, 24796, -2642,
	-25865, -7818, 22703, 17000, -15828, -23401, 6363, 25975,
	4141, -24300, -13969, 18650, 21512, -9950, -25536, -377,
	25383, 10643, -21078, -19168, 13326, 24558, -3393, -25931,
	-7093, 23062, 16420, -16421, -23062, 7094, 25931, 3393,
	-24558, -13325, 19169, 21078, -10644, -25383, 378, 25536},
	},{{

// Carrier 42 Phase 0
	0, 25605, 8892, -22516, -16712, 16712, 22516, -8892,
	-25605, 0, 25605, 8892, -22516, -16712, 16712, 22516,
	-8892, -25605, 0, 25605, 8892, -22516, -16712, 16712,
	22516, -8892, -25605, 0, 25605, 8892, -22516, -16712,
	16712, 22516, -8892, -25605, 0, 25605, 8892, -22516,
	-16712, 16712, 22516, -8892, -25605, 0, 25605, 8892,
	-22516, -16712, 16712, 22516, -8892, -25605, 0, 25605,
	8892, -22516, -16712, 16712, 22516, -8892, -25605, 0,
	25605, 8892, -22516, -16712, 16712, 22516, -8892, -25605,
	0, 25605, 8892, -22516, -16712, 16712, 22516, -8892,
	-25605, 0, 25605, 8892, -22516, -16712, 16712, 22516,
	-8892, -25605, 0, 25605, 8892, -22516, -16712, 16712,
	22516, -8892, -25605, 0, 25605, 8892, -22516, -16712,
	16712, 22516, -8892, -25605, 0, 25605, 8892, -22516,
	-16712, 16712, 22516, -8892, -25605, 0, 25605, 8892,
	-22516, -16712, 16712, 22516, -8892, -25605, 0, 25605,
	8892, -22516, -16712, 16712, 22516, -8892, -25605, 0,
	25605, 8892, -22516, -16712, 16712, 22516, -8892, -25605,
	0, 25605, 8892, -22516, -16712, 16712, 22516, -8892,
	-25605, 0, 25605, 8892, -22516, -16712, 16712, 22516,
	-8892, -25605, 0, 25605, 8892, -22516, -16712, 16712,
	22516, -8892, -25605, 0, 25605, 8892, -22516, -16712,
	16712, 22516, -8892, -25605, 0, 25605, 8892, -22516,
	-16712, 16712, 22516, -8892, -25605, 0, 25605, 8892,
	-22516, -16712, 16712, 22516, -8892, -25605, 0, 25605,
	8892, -22516, -16712, 16712, 22516, -8892, -25605, 0,
	25605, 8892, -22516, -16712, 16712, 22516, -8892, -25605},
	{
// Carrier 42 Phase 1
	9949, 25383, -1134, -25777, -7818, 23062, 15827, -17565,
	-21928, 9949, 25383, -1134, -25777, -7818, 23062, 15827,
	-17565, -21928, 9949, 25383, -1134, -25777, -7818, 23062,
	15827, -17565, -21928, 9949, 25383, -1134, -25777, -7818,
	23062, 15827, -17565, -21928, 9949, 25383, -1134, -25777,
	-7818, 23062, 15827, -17565, -21928, 9949, 25383, -1134,
	-25777, -7818, 23062, 15827, -17565, -21928, 9949, 25383,
	-1134, -25777, -7818, 23062, 15827, -17565, -21928, 9949,
	25383, -1134, -25777, -7818, 23062, 15827, -17565, -21928,
	9949, 25383, -1134, -25777, -7818, 23062, 15827, -17565,
	-21928, 9949, 25383, -1134, -25777, -7818, 23062, 15827,
	-17565, -21928, 9949, 25383, -1134, -25777, -7818, 23062,
	15827, -17565, -21928, 9949, 25383, -1134, -25777, -7818,
	23062, 15827, -17565, -21928, 9949, 25383, -1134, -25777,
	-7818, 23062, 15827, -17565, -21928, 9949, 25383, -1134,
	-25777, -7818, 23062, 15827, -17565, -21928, 9949, 25383,
	-1134, -25777, -7818, 23062, 15827, -17565, -21928, 9949,
	25383, -1134, -25777, -7818, 23062, 15827, -17565, -21928,
	9949, 25383, -1134, -25777, -7818, 23062, 15827, -17565,
	-21928, 9949, 25383, -1134, -25777, -7818, 23062, 15827,
	-17565, -21928, 9949, 25383, -1134, -25777, -7818, 23062,
	15827, -17565, -21928, 9949, 25383, -1134, -25777, -7818,
	23062, 15827, -17565, -21928, 9949, 25383, -1134, -25777,
	-7818, 23062, 15827, -17565, -21928, 9949, 25383, -1134,
	-25777, -7818, 23062, 15827, -17565, -21928, 9949, 25383,
	-1134, -25777, -7818, 23062, 15827, -17565, -21928, 9949,
	25383, -1134, -25777, -7818, 23062, 15827, -17565, -21928},
	{
// Carrier 42 Phase 2
	18384, 21297, -10988, -25114, 2266, 25901, 6729, -23564,
	-14912, 18384, 21297, -10988, -25114, 2266, 25901, 6729,
	-23564, -14912, 18384, 21297, -10988, -25114, 2266, 25901,
	6729, -23564, -14912, 18384, 21297, -10988, -25114, 2266,
	25901, 6729, -23564, -14912, 18384, 21297, -10988, -25114,
	2266, 25901, 6729, -23564, -14912, 18384, 21297, -10988,
	-25114, 2266, 25901, 6729, -23564, -14912, 18384, 21297,
	-10988, -25114, 2266, 25901, 6729, -23564, -14912, 18384,
	21297, -10988, -25114, 2266, 25901, 6729, -23564, -14912,
	18384, 21297, -10988, -25114, 2266, 25901, 6729, -23564,
	-14912, 18384, 21297, -10988, -25114, 2266, 25901, 6729,
	-23564, -14912, 18384, 21297, -10988, -25114, 2266, 25901,
	6729, -23564, -14912, 18384, 21297, -10988, -25114, 2266,
	25901, 6729, -23564, -14912, 18384, 21297, -10988, -25114,
	2266, 25901, 6729, -23564, -14912, 18384, 21297, -10988,
	-25114, 2266, 25901, 6729, -23564, -14912, 18384, 21297,
	-10988, -25114, 2266, 25901, 6729, -23564, -14912, 18384,
	21297, -10988, -25114, 2266, 25901, 6729, -23564, -14912,
	18384, 21297, -10988, -25114, 2266, 25901, 6729, -23564,
	-14912, 18384, 21297, -10988, -25114, 2266, 25901, 6729,
	-23564, -14912, 18384, 21297, -10988, -25114, 2266, 25901,
	6729, -23564, -14912, 18384, 21297, -10988, -25114, 2266,
	25901, 6729, -23564, -14912, 18384, 21297, -10988, -25114,
	2266, 25901, 6729, -23564, -14912, 18384, 21297, -10988,
	-25114, 2266, 25901, 6729, -23564, -14912, 18384, 21297,
	-10988, -25114, 2266, 25901, 6729, -23564, -14912, 18384,
	21297, -10988, -25114, 2266, 25901, 6729, -23564, -14912},
	{
// Carrier 42 Phase 3
	24020, 13969, -19169, -20627, 12005, 24796, -3393, -25975,
	-5627, 24020, 13969, -19169, -20627, 12005, 24796, -3393,
	-25975, -5627, 24020, 13969, -19169, -20627, 12005, 24796,
	-3393, -25975, -5627, 24020, 13969, -19169, -20627, 12005,
	24796, -3393, -25975, -5627, 24020, 13969, -19169, -20627,
	12005, 24796, -3393, -25975, -5627, 24020, 13969, -19169,
	-20627, 12005, 24796, -3393, -25975, -5627, 24020, 13969,
	-19169, -20627, 12005, 24796, -3393, -25975, -5627, 24020,
	13969, -19169, -20627, 12005, 24796, -3393, -25975, -5627,
	24020, 13969, -19169, -20627, 12005, 24796, -3393, -25975,
	-5627, 24020, 13969, -19169, -20627, 12005, 24796, -3393,
	-25975, -5627, 24020, 13969, -19169, -20627, 12005, 24796,
	-3393, -25975, -5627, 24020, 13969, -19169, -20627, 12005,
	24796, -3393, -25975, -5627, 24020, 13969, -19169, -20627,
	12005, 24796, -3393, -25975, -5627, 24020, 13969, -19169,
	-20627, 12005, 24796, -3393, -25975, -5627, 24020, 13969,
	-19169, -20627, 12005, 24796, -3393, -25975, -5627, 24020,
	13969, -19169, -20627, 12005, 24796, -3393, -25975, -5627,
	24020, 13969, -19169, -20627, 12005, 24796, -3393, -25975,
	-5627, 24020, 13969, -19169, -20627, 12005, 24796, -3393,
	-25975, -5627, 24020, 13969, -19169, -20627, 12005, 24796,
	-3393, -25975, -5627, 24020, 13969, -19169, -20627, 12005,
	24796, -3393, -25975, -5627, 24020, 13969, -19169, -20627,
	12005, 24796, -3393, -25975, -5627, 24020, 13969, -19169,
	-20627, 12005, 24796, -3393, -25975, -5627, 24020, 13969,
	-19169, -20627, 12005, 24796, -3393, -25975, -5627, 24020,
	13969, -19169, -20627, 12005, 24796, -3393, -25975, -5627},
	{
// Carrier 42 Phase 4
	26000, 4514, -24432, -13000, 19917, 19917, -12999, -24432,
	4514, 26000, 4514, -24432, -13000, 19917, 19917, -12999,
	-24432, 4514, 26000, 4514, -24432, -13000, 19917, 19917,
	-12999, -24432, 4514, 26000, 4514, -24432, -13000, 19917,
	19917, -12999, -24432, 4514, 26000, 4514, -24432, -13000,
	19917, 19917, -12999, -24432, 4514, 26000, 4514, -24432,
	-13000, 19917, 19917, -12999, -24432, 4514, 26000, 4514,
	-24432, -13000, 19917, 19917, -12999, -24432, 4514, 26000,
	4514, -24432, -13000, 19917, 19917, -12999, -24432, 4514,
	26000, 4514, -24432, -13000, 19917, 19917, -12999, -24432,
	4514, 26000, 4514, -24432, -13000, 19917, 19917, -12999,
	-24432, 4514, 26000, 4514, -24432, -13000, 19917, 19917,
	-12999, -24432, 4514, 26000, 4514, -24432, -13000, 19917,
	19917, -12999, -24432, 4514, 26000, 4514, -24432, -13000,
	19917, 19917, -12999, -24432, 4514, 26000, 4514, -24432,
	-13000, 19917, 19917, -12999, -24432, 4514, 26000, 4514,
	-24432, -13000, 19917, 19917, -12999, -24432, 4514, 26000,
	4514, -24432, -13000, 19917, 19917, -12999, -24432, 4514,
	26000, 4514, -24432, -13000, 19917, 19917, -12999, -24432,
	4514, 26000, 4514, -24432, -13000, 19917, 19917, -12999,
	-24432, 4514, 26000, 4514, -24432, -13000, 19917, 19917,
	-12999, -24432, 4514, 26000, 4514, -24432, -13000, 19917,
	19917, -12999, -24432, 4514, 26000, 4514, -24432, -13000,
	19917, 19917, -12999, -24432, 4514, 26000, 4514, -24432,
	-13000, 19917, 19917, -12999, -24432, 4514, 26000, 4514,
	-24432, -13000, 19917, 19917, -12999, -24432, 4514, 26000,
	4514, -24432, -13000, 19917, 19917, -12999, -24432, 4514},
	{
// Carrier 42 Phase 5
	24020, -5627, -25975, -3393, 24796, 12005, -20627, -19169,
	13969, 24020, -5627, -25975, -3393, 24796, 12005, -20627,
	-19169, 13969, 24020, -5627, -25975, -3393, 24796, 12005,
	-20627, -19169, 13969, 24020, -5627, -25975, -3393, 24796,
	12005, -20627, -19169, 13969, 24020, -5627, -25975, -3393,
	24796, 12005, -20627, -19169, 13969, 24020, -5627, -25975,
	-3393, 24796, 12005, -20627, -19169, 13969, 24020, -5627,
	-25975, -3393, 24796, 12005, -20627, -19169, 13969, 24020,
	-5627, -25975, -3393, 24796, 12005, -20627, -19169, 13969,
	24020, -5627, -25975, -3393, 24796, 12005, -20627, -19169,
	13969, 24020, -5627, -25975, -3393, 24796, 12005, -20627,
	-19169, 13969, 24020, -5627, -25975, -3393, 24796, 12005,
	-20627, -19169, 13969, 24020, -5627, -25975, -3393, 24796,
	12005, -20627, -19169, 13969, 24020, -5627, -25975, -3393,
	24796, 12005, -20627, -19169, 13969, 24020, -5627, -25975,
	-3393, 24796, 12005, -20627, -19169, 13969, 24020, -5627,
	-25975, -3393, 24796, 12005, -20627, -19169, 13969, 24020,
	-5627, -25975, -3393, 24796, 12005, -20627, -19169, 13969,
	24020, -5627, -25975, -3393, 24796, 12005, -20627, -19169,
	13969, 24020, -5627, -25975, -3393, 24796, 12005, -20627,
	-19169, 13969, 24020, -5627, -25975, -3393, 24796, 12005,
	-20627, -19169, 13969, 24020, -5627, -25975, -3393, 24796,
	12005, -20627, -19169, 13969, 24020, -5627, -25975, -3393,
	24796, 12005, -20627, -19169, 13969, 24020, -5627, -25975,
	-3393, 24796, 12005, -20627, -19169, 13969, 24020, -5627,
	-25975, -3393, 24796, 12005, -20627, -19169, 13969, 24020,
	-5627, -25975, -3393, 24796, 12005, -20627, -19169, 13969},
	{
// Carrier 42 Phase 6
	18384, -14912, -23564, 6729, 25901, 2266, -25114, -10988,
	21297, 18384, -14912, -23563, 6729, 25901, 2266, -25114,
	-10988, 21297, 18384, -14912, -23563, 6729, 25901, 2266,
	-25114, -10988, 21297, 18384, -14912, -23563, 6729, 25901,
	2266, -25114, -10988, 21297, 18384, -14912, -23563, 6729,
	25901, 2266, -25114, -10988, 21297, 18384, -14912, -23563,
	6729, 25901, 2266, -25114, -10988, 21297, 18384, -14912,
	-23563, 6729, 25901, 2266, -25114, -10988, 21297, 18384,
	-14912, -23563, 6729, 25901, 2266, -25114, -10988, 21297,
	18384, -14912, -23563, 6729, 25901, 2266, -25114, -10988,
	21297, 18384, -14912, -23563, 6729, 25901, 2266, -25114,
	-10988, 21297, 18384, -14912, -23563, 6729, 25901, 2266,
	-25114, -10988, 21297, 18384, -14912, -23563, 6729, 25901,
	2266, -25114, -10988, 21297, 18384, -14912, -23563, 6729,
	25901, 2266, -25114, -10988, 21297, 18384, -14912, -23563,
	6729, 25901, 2266, -25114, -10988, 21297, 18384, -14912,
	-23563, 6729, 25901, 2266, -25114, -10988, 21297, 18384,
	-14912, -23563, 6729, 25901, 2266, -25114, -10988, 21297,
	18384, -14912, -23563, 6729, 25901, 2266, -25114, -10988,
	21297, 18384, -14912, -23563, 6729, 25901, 2266, -25114,
	-10988, 21297, 18384, -14912, -23563, 6729, 25901, 2266,
	-25114, -10988, 21297, 18384, -14912, -23563, 6729, 25901,
	2266, -25114, -10988, 21297, 18384, -14912, -23563, 6729,
	25901, 2266, -25114, -10988, 21297, 18384, -14912, -23563,
	6729, 25901, 2266, -25114, -10988, 21297, 18384, -14912,
	-23563, 6729, 25901, 2266, -25114, -10988, 21297, 18384,
	-14912, -23563, 6729, 25901, 2266, -25114, -10988, 21297},
	{
// Carrier 42 Phase 7
	9949, -21928, -17565, 15827, 23062, -7818, -25777, -1134,
	25383, 9949, -21928, -17565, 15827, 23062, -7818, -25777,
	-1134, 25383, 9949, -21928, -17565, 15827, 23062, -7818,
	-25777, -1134, 25383, 9949, -21928, -17565, 15827, 23062,
	-7818, -25777, -1134, 25383, 9949, -21928, -17565, 15827,
	23062, -7818, -25777, -1134, 25383, 9949, -21928, -17565,
	15827, 23062, -7818, -25777, -1134, 25383, 9949, -21928,
	-17565, 15827, 23062, -7818, -25777, -1134, 25383, 9949,
	-21928, -17565, 15827, 23062, -7818, -25777, -1134, 25383,
	9949, -21928, -17565, 15827, 23062, -7818, -25777, -1134,
	25383, 9949, -21928, -17565, 15827, 23062, -7818, -25777,
	-1134, 25383, 9949, -21928, -17565, 15827, 23062, -7818,
	-25777, -1134, 25383, 9949, -21928, -17565, 15827, 23062,
	-7818, -25777, -1134, 25383, 9949, -21928, -17565, 15827,
	23062, -7818, -25777, -1134, 25383, 9949, -21928, -17565,
	15827, 23062, -7818, -25777, -1134, 25383, 9949, -21928,
	-17565, 15827, 23062, -7818, -25777, -1134, 25383, 9949,
	-21928, -17565, 15827, 23062, -7818, -25777, -1134, 25383,
	9949, -21928, -17565, 15827, 23062, -7818, -25777, -1134,
	25383, 9949, -21928, -17565, 15827, 23062, -7818, -25777,
	-1134, 25383, 9949, -21928, -17565, 15827, 23062, -7818,
	-25777, -1134, 25383, 9949, -21928, -17565, 15827, 23062,
	-7818, -25777, -1134, 25383, 9949, -21928, -17565, 15827,
	23062, -7818, -25777, -1134, 25383, 9949, -21928, -17565,
	15827, 23062, -7818, -25777, -1134, 25383, 9949, -21928,
	-17565, 15827, 23062, -7818, -25777, -1134, 25383, 9949,
	-21928, -17565, 15827, 23062, -7818, -25777, -1134, 25383}}};


/*

8psk values

// Carrier 0 Phase 0
	0, 4514, 8892, 12999, 16712, 19917, 22516, 24432,
	25605, 26000, 25605, 24432, 22516, 19917, 16712, 13000,
	8892, 4514, 0, -4514, -8892, -12999, -16712, -19917,
	-22516, -24432, -25604, -26000, -25605, -24432, -22516, -19917,
	-16712, -13000, -8892, -4514, 0, 4514, 8892, 12999,
	16712, 19917, 22516, 24432, 25604, 26000, 25605, 24432,
	22516, 19917, 16712, 13000, 8892, 4514, 0, -4514,
	-8892, -12999, -16712, -19917, -22516, -24431, -25604, -26000,
	-25605, -24432, -22516, -19917, -16712, -13000, -8892, -4514,
	0, 4514, 8892, 12999, 16712, 19917, 22516, 24431,
	25604, 26000, 25605, 24432, 22516, 19917, 16712, 13000,
	8892, 4514, 0, -4514, -8892, -12999, -16712, -19917,
	-22516, -24431, -25604, -26000, -25605, -24432, -22516, -19917,
	-16712, -13000, -8892, -4514, 0, 4514, 8892, 12999,
	16712, 19917, 22516, 24431, 25604, 26000, 25605, 24432,
	22516, 19917, 16712, 13000, 8892, 4514, 0, -4514,
	-8892, -12999, -16712, -19917, -22516, -24431, -25604, -26000,
	-25605, -24432, -22516, -19917, -16712, -13000, -8892, -4514,
	0, 4514, 8892, 12999, 16712, 19917, 22516, 24431,
	25604, 26000, 25605, 24432, 22516, 19917, 16712, 13000,
	8892, 4514, 0, -4514, -8892, -12999, -16712, -19917,
	-22516, -24431, -25604, -26000, -25605, -24432, -22516, -19917,
	-16712, -13000, -8892, -4514, 0, 4514, 8892, 12999,
	16712, 19917, 22516, 24431, 25604, 26000, 25605, 24432,
	22516, 19917, 16712, 13000, 8892, 4514, 0, -4514,
	-8892, -12999, -16712, -19917, -22516, -24431, -25604, -26000,
	-25605, -24432, -22516, -19917, -16712, -13000, -8892, -4514},
	{
// Carrier 0 Phase 1
	18384, 21297, 23564, 25114, 25901, 25901, 25114, 23564,
	21297, 18384, 14912, 10988, 6729, 2266, -2266, -6729,
	-10988, -14912, -18384, -21297, -23563, -25114, -25901, -25901,
	-25114, -23564, -21297, -18384, -14913, -10988, -6729, -2266,
	2266, 6729, 10988, 14912, 18384, 21297, 23563, 25114,
	25901, 25901, 25114, 23564, 21297, 18384, 14913, 10988,
	6729, 2266, -2266, -6729, -10988, -14912, -18384, -21297,
	-23563, -25114, -25901, -25901, -25114, -23564, -21297, -18384,
	-14913, -10988, -6729, -2266, 2266, 6729, 10988, 14912,
	18384, 21297, 23563, 25114, 25901, 25901, 25114, 23564,
	21297, 18384, 14913, 10988, 6729, 2266, -2265, -6729,
	-10988, -14912, -18384, -21297, -23563, -25114, -25901, -25901,
	-25114, -23564, -21297, -18384, -14913, -10988, -6729, -2266,
	2265, 6729, 10988, 14912, 18384, 21297, 23563, 25114,
	25901, 25901, 25114, 23564, 21297, 18384, 14913, 10988,
	6729, 2266, -2265, -6729, -10988, -14912, -18384, -21297,
	-23563, -25114, -25901, -25901, -25114, -23564, -21298, -18384,
	-14913, -10988, -6729, -2266, 2265, 6729, 10987, 14912,
	18384, 21297, 23563, 25114, 25901, 25901, 25114, 23564,
	21298, 18384, 14913, 10988, 6729, 2266, -2265, -6729,
	-10987, -14912, -18384, -21297, -23563, -25114, -25901, -25901,
	-25114, -23564, -21298, -18384, -14913, -10988, -6729, -2266,
	2265, 6729, 10987, 14912, 18384, 21297, 23563, 25114,
	25901, 25901, 25114, 23564, 21298, 18384, 14913, 10988,
	6729, 2266, -2265, -6729, -10987, -14912, -18384, -21297,
	-23563, -25114, -25901, -25901, -25114, -23564, -21298, -18384,
	-14913, -10988, -6729, -2266, 2265, 6729, 10987, 14912},
	{
// Carrier 0 Phase 2
	26000, 25605, 24432, 22516, 19917, 16712, 13000, 8892,
	4514, 0, -4514, -8892, -12999, -16712, -19917, -22516,
	-24432, -25604, -26000, -25605, -24432, -22516, -19917, -16712,
	-13000, -8892, -4514, 0, 4514, 8892, 12999, 16712,
	19917, 22516, 24432, 25604, 26000, 25605, 24432, 22516,
	19917, 16712, 13000, 8892, 4514, 0, -4514, -8892,
	-12999, -16712, -19917, -22516, -24431, -25604, -26000, -25605,
	-24432, -22516, -19917, -16712, -13000, -8892, -4514, 0,
	4514, 8892, 12999, 16712, 19917, 22516, 24431, 25604,
	26000, 25605, 24432, 22516, 19917, 16712, 13000, 8892,
	4514, 0, -4514, -8892, -12999, -16712, -19917, -22516,
	-24431, -25604, -26000, -25605, -24432, -22516, -19917, -16712,
	-13000, -8892, -4514, 0, 4514, 8892, 12999, 16712,
	19917, 22516, 24431, 25604, 26000, 25605, 24432, 22516,
	19917, 16712, 13000, 8892, 4514, 0, -4514, -8892,
	-12999, -16712, -19917, -22516, -24431, -25604, -26000, -25605,
	-24432, -22516, -19917, -16712, -13000, -8892, -4514, 0,
	4514, 8892, 12999, 16712, 19917, 22516, 24431, 25604,
	26000, 25605, 24432, 22516, 19917, 16712, 13000, 8892,
	4514, 0, -4514, -8892, -12999, -16712, -19917, -22516,
	-24431, -25604, -26000, -25605, -24432, -22516, -19917, -16712,
	-13000, -8892, -4514, 0, 4514, 8892, 12999, 16712,
	19917, 22516, 24431, 25604, 26000, 25605, 24432, 22516,
	19917, 16712, 13000, 8892, 4514, 0, -4514, -8892,
	-12999, -16712, -19917, -22516, -24431, -25604, -26000, -25605,
	-24432, -22516, -19917, -16712, -13000, -8892, -4514, 0,
	4514, 8892, 12999, 16712, 19917, 22516, 24431, 25604},
	{
// Carrier 0 Phase 3
	18384, 14912, 10988, 6729, 2266, -2266, -6729, -10988,
	-14912, -18384, -21297, -23563, -25114, -25901, -25901, -25114,
	-23564, -21297, -18384, -14913, -10988, -6729, -2266, 2266,
	6729, 10988, 14912, 18384, 21297, 23563, 25114, 25901,
	25901, 25114, 23564, 21297, 18384, 14913, 10988, 6729,
	2266, -2266, -6729, -10988, -14912, -18384, -21297, -23563,
	-25114, -25901, -25901, -25114, -23564, -21297, -18384, -14913,
	-10988, -6729, -2266, 2266, 6729, 10988, 14912, 18384,
	21297, 23563, 25114, 25901, 25901, 25114, 23564, 21297,
	18384, 14913, 10988, 6729, 2266, -2265, -6729, -10988,
	-14912, -18384, -21297, -23563, -25114, -25901, -25901, -25114,
	-23564, -21297, -18384, -14913, -10988, -6729, -2266, 2265,
	6729, 10988, 14912, 18384, 21297, 23563, 25114, 25901,
	25901, 25114, 23564, 21297, 18384, 14913, 10988, 6729,
	2266, -2265, -6729, -10988, -14912, -18384, -21297, -23563,
	-25114, -25901, -25901, -25114, -23564, -21298, -18384, -14913,
	-10988, -6729, -2266, 2265, 6729, 10987, 14912, 18384,
	21297, 23563, 25114, 25901, 25901, 25114, 23564, 21298,
	18384, 14913, 10988, 6729, 2266, -2265, -6729, -10987,
	-14912, -18384, -21297, -23563, -25114, -25901, -25901, -25114,
	-23564, -21298, -18384, -14913, -10988, -6729, -2266, 2265,
	6729, 10987, 14912, 18384, 21297, 23563, 25114, 25901,
	25901, 25114, 23564, 21298, 18384, 14913, 10988, 6729,
	2266, -2265, -6729, -10987, -14912, -18384, -21297, -23563,
	-25114, -25901, -25901, -25114, -23564, -21298, -18384, -14913,
	-10988, -6729, -2266, 2265, 6729, 10987, 14912, 18384,
	21297, 23563, 25114, 25901, 25901, 25114, 23564, 21298},
	},{{

// Carrier 1 Phase 0
	0, 5257, 10298, 14912, 18911, 22129, 24432, 25725,
	25956, 25114, 23234, 20394, 16712, 12339, 7456, 2266,
	-3018, -8178, -12999, -17284, -20855, -23563, -25299, -25989,
	-25605, -24163, -21722, -18384, -14287, -9599, -4514, 756,
	5996, 10988, 15526, 19422, 22516, 24680, 25824, 25901,
	24907, 22885, 19917, 16126, 11668, 6729, 1511, -3768,
	-8892, -13649, -17842, -21297, -23873, -25462, -26000, -25462,
	-23873, -21297, -17842, -13649, -8892, -3768, 1511, 6729,
	11668, 16126, 19917, 22885, 24907, 25901, 25824, 24680,
	22516, 19422, 15526, 10988, 5996, 756, -4514, -9599,
	-14287, -18384, -21722, -24163, -25604, -25989, -25299, -23564,
	-20855, -17284, -13000, -8178, -3018, 2266, 7456, 12339,
	16712, 20394, 23234, 25114, 25956, 25725, 24432, 22129,
	18911, 14912, 10298, 5257, 0, -5257, -10298, -14912,
	-18911, -22129, -24432, -25725, -25956, -25114, -23234, -20394,
	-16712, -12339, -7456, -2266, 3018, 8178, 13000, 17284,
	20855, 23564, 25299, 25989, 25604, 24163, 21722, 18384,
	14287, 9599, 4514, -756, -5996, -10988, -15526, -19422,
	-22516, -24680, -25824, -25901, -24907, -22885, -19917, -16126,
	-11668, -6729, -1511, 3768, 8892, 13649, 17842, 21297,
	23873, 25462, 26000, 25462, 23873, 21297, 17842, 13649,
	8892, 3768, -1511, -6729, -11668, -16126, -19917, -22885,
	-24907, -25901, -25824, -24680, -22516, -19422, -15526, -10988,
	-5995, -756, 4514, 9599, 14287, 18384, 21722, 24163,
	25605, 25989, 25299, 23563, 20855, 17284, 12999, 8178,
	3018, -2266, -7456, -12339, -16712, -20394, -23234, -25114,
	-25956, -25725, -24432, -22129, -18911, -14912, -10298, -5257},
	{
// Carrier 1 Phase 1
	18384, 21722, 24163, 25605, 25989, 25299, 23564, 20855,
	17284, 13000, 8178, 3018, -2266, -7456, -12339, -16712,
	-20394, -23234, -25114, -25956, -25725, -24432, -22129, -18911,
	-14912, -10298, -5257, 0, 5257, 10298, 14912, 18911,
	22129, 24432, 25725, 25956, 25114, 23234, 20394, 16712,
	12339, 7456, 2266, -3018, -8178, -12999, -17284, -20855,
	-23563, -25299, -25989, -25605, -24163, -21722, -18384, -14287,
	-9599, -4514, 756, 5996, 10988, 15526, 19422, 22516,
	24680, 25824, 25901, 24907, 22885, 19917, 16126, 11668,
	6729, 1511, -3768, -8892, -13649, -17842, -21297, -23873,
	-25462, -26000, -25462, -23873, -21297, -17842, -13649, -8892,
	-3768, 1511, 6729, 11668, 16126, 19917, 22885, 24907,
	25901, 25824, 24680, 22516, 19422, 15526, 10988, 5996,
	756, -4514, -9599, -14287, -18384, -21722, -24163, -25604,
	-25989, -25299, -23564, -20855, -17284, -12999, -8178, -3018,
	2266, 7456, 12339, 16712, 20394, 23234, 25114, 25956,
	25725, 24432, 22129, 18911, 14912, 10298, 5257, 0,
	-5257, -10298, -14912, -18911, -22129, -24432, -25725, -25956,
	-25114, -23234, -20394, -16712, -12339, -7456, -2266, 3018,
	8178, 13000, 17284, 20855, 23564, 25299, 25989, 25604,
	24163, 21722, 18384, 14287, 9599, 4514, -756, -5996,
	-10988, -15526, -19422, -22516, -24680, -25824, -25901, -24907,
	-22885, -19917, -16126, -11668, -6729, -1511, 3768, 8892,
	13649, 17842, 21297, 23873, 25462, 26000, 25462, 23873,
	21297, 17842, 13649, 8892, 3768, -1511, -6729, -11668,
	-16126, -19917, -22885, -24907, -25901, -25824, -24680, -22516,
	-19422, -15526, -10988, -5995, -756, 4514, 9599, 14287},
	{
// Carrier 1 Phase 2
	26000, 25462, 23873, 21297, 17842, 13649, 8892, 3768,
	-1511, -6729, -11668, -16126, -19917, -22885, -24907, -25901,
	-25824, -24680, -22516, -19422, -15526, -10988, -5996, -756,
	4514, 9599, 14287, 18384, 21722, 24163, 25605, 25989,
	25299, 23563, 20855, 17284, 13000, 8178, 3018, -2266,
	-7456, -12339, -16712, -20394, -23234, -25114, -25956, -25725,
	-24432, -22129, -18911, -14912, -10298, -5257, 0, 5257,
	10298, 14913, 18911, 22129, 24432, 25725, 25956, 25114,
	23234, 20394, 16712, 12339, 7456, 2266, -3018, -8178,
	-12999, -17284, -20855, -23563, -25299, -25989, -25605, -24163,
	-21722, -18384, -14287, -9599, -4514, 756, 5996, 10988,
	15526, 19422, 22516, 24680, 25824, 25901, 24907, 22885,
	19917, 16126, 11668, 6729, 1511, -3768, -8892, -13649,
	-17842, -21297, -23873, -25462, -26000, -25462, -23873, -21297,
	-17842, -13649, -8892, -3768, 1511, 6729, 11668, 16126,
	19917, 22885, 24907, 25901, 25824, 24680, 22516, 19422,
	15526, 10988, 5995, 756, -4514, -9599, -14287, -18384,
	-21722, -24163, -25605, -25989, -25299, -23563, -20855, -17284,
	-12999, -8178, -3018, 2266, 7456, 12339, 16712, 20394,
	23234, 25114, 25956, 25725, 24431, 22129, 18911, 14912,
	10298, 5257, 0, -5257, -10298, -14912, -18911, -22129,
	-24432, -25725, -25956, -25114, -23234, -20394, -16712, -12339,
	-7456, -2266, 3018, 8178, 13000, 17284, 20855, 23564,
	25299, 25989, 25604, 24163, 21722, 18384, 14287, 9599,
	4514, -756, -5996, -10988, -15526, -19422, -22516, -24680,
	-25824, -25901, -24907, -22885, -19917, -16126, -11668, -6729,
	-1511, 3768, 8892, 13649, 17842, 21297, 23873, 25462},
	{
// Carrier 1 Phase 3
	18384, 14287, 9599, 4514, -756, -5995, -10988, -15526,
	-19422, -22516, -24680, -25824, -25901, -24907, -22885, -19917,
	-16126, -11668, -6729, -1511, 3768, 8892, 13649, 17842,
	21297, 23873, 25462, 26000, 25462, 23873, 21297, 17842,
	13649, 8892, 3768, -1511, -6729, -11668, -16126, -19917,
	-22885, -24907, -25901, -25824, -24680, -22516, -19422, -15526,
	-10988, -5995, -756, 4514, 9599, 14287, 18384, 21722,
	24163, 25605, 25989, 25299, 23563, 20855, 17284, 12999,
	8178, 3018, -2266, -7456, -12339, -16712, -20394, -23234,
	-25114, -25956, -25725, -24432, -22129, -18911, -14912, -10298,
	-5257, 0, 5257, 10298, 14913, 18911, 22129, 24432,
	25725, 25956, 25114, 23234, 20394, 16712, 12339, 7456,
	2266, -3018, -8178, -13000, -17284, -20855, -23564, -25299,
	-25989, -25604, -24163, -21722, -18384, -14287, -9599, -4514,
	756, 5996, 10988, 15526, 19422, 22516, 24680, 25824,
	25901, 24907, 22885, 19917, 16126, 11668, 6729, 1511,
	-3768, -8892, -13649, -17842, -21297, -23873, -25462, -26000,
	-25462, -23873, -21297, -17842, -13649, -8892, -3768, 1511,
	6729, 11668, 16126, 19917, 22885, 24907, 25901, 25824,
	24680, 22516, 19422, 15526, 10988, 5995, 756, -4514,
	-9599, -14287, -18384, -21722, -24163, -25605, -25989, -25299,
	-23563, -20855, -17284, -12999, -8178, -3018, 2266, 7456,
	12339, 16712, 20394, 23234, 25114, 25956, 25725, 24431,
	22129, 18911, 14912, 10298, 5257, 0, -5257, -10298,
	-14913, -18911, -22129, -24432, -25725, -25956, -25114, -23234,
	-20394, -16712, -12339, -7456, -2265, 3018, 8178, 13000,
	17284, 20855, 23564, 25299, 25989, 25604, 24163, 21722},
	},{{

// Carrier 2 Phase 0
	0, 5996, 11668, 16712, 20855, 23873, 25605, 25956,
	24907, 22516, 18911, 14287, 8892, 3018, -3018, -8892,
	-14287, -18911, -22516, -24907, -25956, -25605, -23873, -20855,
	-16712, -11668, -5996, 0, 5995, 11668, 16712, 20855,
	23873, 25604, 25956, 24907, 22516, 18911, 14287, 8892,
	3018, -3018, -8892, -14287, -18911, -22516, -24907, -25956,
	-25605, -23873, -20855, -16712, -11668, -5996, 0, 5995,
	11668, 16712, 20855, 23873, 25604, 25956, 24907, 22516,
	18911, 14287, 8892, 3018, -3018, -8892, -14287, -18911,
	-22516, -24907, -25956, -25605, -23873, -20855, -16712, -11668,
	-5996, 0, 5995, 11668, 16712, 20855, 23873, 25604,
	25956, 24907, 22516, 18911, 14287, 8892, 3018, -3018,
	-8892, -14287, -18911, -22516, -24907, -25956, -25605, -23873,
	-20855, -16712, -11668, -5996, 0, 5995, 11668, 16712,
	20855, 23873, 25604, 25956, 24907, 22516, 18911, 14287,
	8892, 3018, -3018, -8892, -14287, -18911, -22516, -24907,
	-25955, -25605, -23873, -20855, -16712, -11668, -5996, 0,
	5995, 11668, 16712, 20855, 23873, 25604, 25956, 24907,
	22516, 18911, 14287, 8892, 3018, -3018, -8892, -14287,
	-18911, -22516, -24907, -25955, -25605, -23873, -20855, -16712,
	-11669, -5996, 0, 5995, 11668, 16712, 20855, 23873,
	25604, 25956, 24907, 22516, 18911, 14287, 8892, 3018,
	-3018, -8892, -14286, -18911, -22516, -24907, -25955, -25605,
	-23873, -20855, -16712, -11669, -5996, 0, 5995, 11668,
	16712, 20854, 23873, 25604, 25956, 24907, 22516, 18911,
	14287, 8892, 3018, -3018, -8892, -14286, -18911, -22516,
	-24907, -25955, -25605, -23873, -20855, -16712, -11669, -5996},
	{
// Carrier 2 Phase 1
	18384, 22129, 24680, 25901, 25725, 24163, 21297, 17284,
	12339, 6729, 756, -5257, -10988, -16126, -20394, -23563,
	-25462, -25989, -25114, -22885, -19422, -14913, -9599, -3768,
	2265, 8178, 13649, 18384, 22129, 24680, 25901, 25725,
	24163, 21297, 17284, 12339, 6729, 756, -5257, -10988,
	-16126, -20394, -23563, -25462, -25989, -25114, -22885, -19422,
	-14913, -9599, -3768, 2265, 8178, 13649, 18384, 22128,
	24680, 25901, 25725, 24163, 21298, 17284, 12339, 6729,
	756, -5257, -10987, -16126, -20394, -23563, -25462, -25989,
	-25114, -22885, -19422, -14913, -9599, -3768, 2265, 8178,
	13649, 18384, 22128, 24680, 25901, 25725, 24163, 21298,
	17284, 12339, 6729, 756, -5257, -10987, -16126, -20394,
	-23563, -25462, -25989, -25114, -22885, -19422, -14913, -9599,
	-3768, 2265, 8177, 13649, 18384, 22128, 24680, 25901,
	25725, 24163, 21298, 17284, 12339, 6729, 756, -5257,
	-10987, -16125, -20394, -23563, -25462, -25989, -25114, -22885,
	-19422, -14913, -9599, -3768, 2265, 8177, 13649, 18384,
	22128, 24680, 25901, 25725, 24163, 21298, 17284, 12339,
	6729, 756, -5257, -10987, -16125, -20394, -23563, -25462,
	-25989, -25114, -22885, -19422, -14913, -9599, -3768, 2265,
	8177, 13649, 18384, 22128, 24680, 25901, 25725, 24163,
	21298, 17284, 12339, 6729, 756, -5257, -10987, -16125,
	-20394, -23563, -25462, -25989, -25114, -22885, -19422, -14913,
	-9599, -3768, 2265, 8177, 13649, 18384, 22128, 24680,
	25901, 25725, 24163, 21298, 17284, 12339, 6729, 756,
	-5257, -10987, -16125, -20394, -23563, -25462, -25989, -25114,
	-22885, -19422, -14913, -9599, -3768, 2265, 8177, 13649},
	{
// Carrier 2 Phase 2
	26000, 25299, 23234, 19917, 15526, 10298, 4514, -1511,
	-7456, -12999, -17842, -21722, -24432, -25824, -25824, -24432,
	-21722, -17842, -13000, -7456, -1511, 4514, 10298, 15526,
	19917, 23234, 25299, 26000, 25299, 23234, 19917, 15526,
	10298, 4514, -1511, -7456, -12999, -17842, -21722, -24431,
	-25824, -25824, -24432, -21722, -17842, -13000, -7456, -1511,
	4514, 10297, 15526, 19917, 23234, 25299, 26000, 25299,
	23234, 19917, 15526, 10298, 4514, -1511, -7456, -12999,
	-17842, -21722, -24431, -25824, -25824, -24432, -21722, -17842,
	-13000, -7457, -1511, 4514, 10297, 15526, 19917, 23234,
	25299, 26000, 25299, 23234, 19917, 15526, 10298, 4515,
	-1511, -7456, -12999, -17842, -21722, -24431, -25824, -25824,
	-24432, -21722, -17842, -13000, -7457, -1511, 4514, 10297,
	15525, 19917, 23234, 25299, 26000, 25299, 23234, 19917,
	15526, 10298, 4515, -1511, -7456, -12999, -17842, -21722,
	-24431, -25824, -25824, -24432, -21722, -17842, -13000, -7457,
	-1512, 4514, 10297, 15525, 19916, 23234, 25299, 26000,
	25299, 23234, 19917, 15526, 10298, 4515, -1511, -7456,
	-12999, -17842, -21722, -24431, -25824, -25824, -24432, -21722,
	-17842, -13000, -7457, -1512, 4514, 10297, 15525, 19916,
	23234, 25299, 26000, 25299, 23234, 19917, 15526, 10298,
	4515, -1511, -7456, -12999, -17842, -21722, -24431, -25824,
	-25824, -24432, -21722, -17842, -13000, -7457, -1512, 4514,
	10297, 15525, 19916, 23234, 25299, 26000, 25299, 23234,
	19917, 15526, 10298, 4515, -1511, -7456, -12999, -17842,
	-21722, -24431, -25824, -25824, -24432, -21722, -17842, -13000,
	-7457, -1512, 4514, 10297, 15525, 19916, 23234, 25299},
	{
// Carrier 2 Phase 3
	18384, 13649, 8178, 2266, -3768, -9599, -14912, -19422,
	-22885, -25114, -25989, -25462, -23564, -20394, -16126, -10988,
	-5257, 756, 6729, 12339, 17284, 21297, 24163, 25725,
	25901, 24680, 22129, 18384, 13649, 8178, 2266, -3768,
	-9599, -14912, -19422, -22885, -25114, -25988, -25462, -23564,
	-20394, -16126, -10988, -5257, 756, 6729, 12339, 17284,
	21297, 24163, 25725, 25901, 24680, 22129, 18384, 13649,
	8178, 2266, -3768, -9599, -14912, -19422, -22885, -25114,
	-25988, -25462, -23564, -20394, -16126, -10988, -5257, 756,
	6729, 12339, 17284, 21297, 24162, 25725, 25901, 24680,
	22129, 18384, 13649, 8178, 2266, -3768, -9599, -14912,
	-19422, -22885, -25114, -25988, -25462, -23564, -20394, -16126,
	-10988, -5257, 756, 6729, 12339, 17284, 21297, 24162,
	25725, 25901, 24680, 22129, 18384, 13649, 8178, 2266,
	-3768, -9599, -14912, -19422, -22885, -25114, -25988, -25462,
	-23564, -20394, -16126, -10988, -5257, 755, 6729, 12339,
	17284, 21297, 24162, 25725, 25901, 24680, 22129, 18384,
	13649, 8178, 2266, -3767, -9599, -14912, -19422, -22885,
	-25114, -25988, -25462, -23564, -20394, -16126, -10988, -5257,
	755, 6729, 12339, 17284, 21297, 24162, 25725, 25901,
	24680, 22129, 18384, 13649, 8178, 2266, -3767, -9599,
	-14912, -19422, -22885, -25113, -25988, -25462, -23564, -20395,
	-16126, -10988, -5257, 755, 6728, 12339, 17284, 21297,
	24162, 25725, 25901, 24680, 22129, 18385, 13649, 8178,
	2266, -3767, -9599, -14912, -19422, -22885, -25113, -25988,
	-25462, -23564, -20395, -16126, -10988, -5258, 755, 6728,
	12339, 17284, 21297, 24162, 25725, 25901, 24680, 22129},
	},{{

// Carrier 3 Phase 0
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729,
	0, 6729, 12999, 18384, 22516, 25114, 26000, 25114,
	22516, 18384, 13000, 6729, 0, -6729, -12999, -18384,
	-22516, -25114, -26000, -25114, -22516, -18384, -13000, -6729},
	{
// Carrier 3 Phase 1
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999,
	18384, 22516, 25114, 26000, 25114, 22516, 18384, 13000,
	6729, 0, -6729, -12999, -18384, -22516, -25114, -26000,
	-25114, -22516, -18384, -13000, -6729, 0, 6729, 12999},
	{
// Carrier 3 Phase 2
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114,
	26000, 25114, 22516, 18384, 13000, 6729, 0, -6729,
	-12999, -18384, -22516, -25114, -26000, -25114, -22516, -18384,
	-13000, -6729, 0, 6729, 12999, 18384, 22516, 25114},
	{
// Carrier 3 Phase 3
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516,
	18384, 13000, 6729, 0, -6729, -12999, -18384, -22516,
	-25114, -26000, -25114, -22516, -18384, -13000, -6729, 0,
	6729, 12999, 18384, 22516, 25114, 26000, 25114, 22516},
	},{{

// Carrier 4 Phase 0
	0, 7456, 14287, 19917, 23873, 25824, 25605, 23234,
	18911, 13000, 5996, -1511, -8892, -15526, -20855, -24432,
	-25956, -25299, -22516, -17842, -11668, -4514, 3018, 10298,
	16712, 21722, 24907, 26000, 24907, 21722, 16712, 10298,
	3018, -4514, -11668, -17842, -22516, -25299, -25956, -24431,
	-20855, -15526, -8892, -1511, 5996, 13000, 18911, 23234,
	25605, 25824, 23873, 19917, 14287, 7456, 0, -7456,
	-14287, -19917, -23873, -25824, -25604, -23234, -18911, -12999,
	-5995, 1511, 8892, 15526, 20855, 24432, 25956, 25299,
	22516, 17842, 11668, 4514, -3018, -10298, -16712, -21722,
	-24907, -26000, -24907, -21722, -16712, -10297, -3018, 4515,
	11668, 17842, 22516, 25299, 25956, 24431, 20855, 15525,
	8892, 1511, -5996, -13000, -18911, -23234, -25605, -25824,
	-23873, -19917, -14287, -7456, 0, 7457, 14287, 19917,
	23873, 25824, 25604, 23234, 18911, 12999, 5995, -1511,
	-8892, -15526, -20855, -24432, -25956, -25299, -22516, -17842,
	-11668, -4514, 3018, 10298, 16712, 21722, 24907, 26000,
	24907, 21722, 16712, 10297, 3018, -4515, -11668, -17842,
	-22516, -25299, -25955, -24431, -20855, -15525, -8892, -1511,
	5996, 13000, 18911, 23234, 25605, 25824, 23873, 19916,
	14287, 7456, 0, -7457, -14287, -19917, -23873, -25824,
	-25604, -23234, -18911, -12999, -5995, 1512, 8892, 15526,
	20855, 24432, 25956, 25299, 22516, 17842, 11668, 4514,
	-3018, -10298, -16712, -21722, -24907, -26000, -24907, -21722,
	-16712, -10297, -3018, 4515, 11669, 17842, 22516, 25299,
	25955, 24431, 20854, 15525, 8892, 1511, -5996, -13000,
	-18911, -23234, -25605, -25824, -23873, -19916, -14286, -7456},
	{
// Carrier 4 Phase 1
	18384, 22885, 25462, 25901, 24163, 20394, 14912, 8178,
	756, -6729, -13649, -19422, -23564, -25725, -25725, -23563,
	-19422, -13649, -6729, 756, 8178, 14913, 20394, 24163,
	25901, 25462, 22885, 18384, 12339, 5257, -2266, -9599,
	-16126, -21297, -24680, -25989, -25114, -22129, -17284, -10988,
	-3768, 3768, 10988, 17284, 22129, 25114, 25988, 24680,
	21297, 16126, 9599, 2265, -5257, -12339, -18384, -22885,
	-25462, -25901, -24162, -20394, -14912, -8178, -756, 6729,
	13649, 19422, 23564, 25725, 25725, 23563, 19422, 13649,
	6729, -756, -8178, -14913, -20394, -24163, -25901, -25462,
	-22885, -18384, -12339, -5257, 2266, 9599, 16126, 21298,
	24680, 25989, 25114, 22128, 17284, 10987, 3768, -3768,
	-10988, -17284, -22129, -25114, -25988, -24680, -21297, -16125,
	-9599, -2265, 5257, 12339, 18384, 22885, 25462, 25901,
	24162, 20394, 14912, 8177, 755, -6729, -13649, -19422,
	-23564, -25725, -25725, -23563, -19422, -13649, -6729, 756,
	8178, 14913, 20394, 24163, 25901, 25462, 22885, 18384,
	12339, 5257, -2266, -9599, -16126, -21298, -24680, -25989,
	-25114, -22128, -17284, -10987, -3767, 3768, 10988, 17284,
	22129, 25114, 25988, 24680, 21297, 16125, 9599, 2265,
	-5257, -12339, -18384, -22885, -25462, -25901, -24162, -20394,
	-14912, -8177, -755, 6729, 13649, 19422, 23564, 25725,
	25725, 23563, 19422, 13649, 6728, -756, -8178, -14913,
	-20395, -24163, -25901, -25462, -22885, -18384, -12339, -5257,
	2266, 9599, 16126, 21298, 24680, 25989, 25113, 22128,
	17284, 10987, 3767, -3768, -10988, -17284, -22129, -25114,
	-25988, -24680, -21297, -16125, -9599, -2265, 5258, 12339},
	{
// Carrier 4 Phase 2
	26000, 24907, 21722, 16712, 10298, 3018, -4514, -11668,
	-17842, -22516, -25299, -25956, -24432, -20855, -15526, -8892,
	-1511, 5996, 13000, 18911, 23234, 25605, 25824, 23873,
	19917, 14287, 7456, 0, -7456, -14287, -19917, -23873,
	-25824, -25604, -23234, -18911, -12999, -5995, 1511, 8892,
	15526, 20855, 24432, 25956, 25299, 22516, 17842, 11668,
	4514, -3018, -10298, -16712, -21722, -24907, -26000, -24907,
	-21722, -16712, -10297, -3018, 4514, 11668, 17842, 22516,
	25299, 25956, 24431, 20855, 15526, 8892, 1511, -5996,
	-13000, -18911, -23234, -25605, -25824, -23873, -19917, -14287,
	-7456, 0, 7457, 14287, 19917, 23873, 25824, 25604,
	23234, 18911, 12999, 5995, -1511, -8892, -15526, -20855,
	-24432, -25956, -25299, -22516, -17842, -11668, -4514, 3018,
	10298, 16712, 21722, 24907, 26000, 24907, 21722, 16712,
	10297, 3018, -4515, -11668, -17842, -22516, -25299, -25955,
	-24431, -20855, -15525, -8892, -1511, 5996, 13000, 18911,
	23234, 25605, 25824, 23873, 19917, 14287, 7456, 0,
	-7457, -14287, -19917, -23873, -25824, -25604, -23234, -18911,
	-12999, -5995, 1512, 8892, 15526, 20855, 24432, 25956,
	25299, 22516, 17842, 11668, 4514, -3018, -10298, -16712,
	-21722, -24907, -26000, -24907, -21722, -16712, -10297, -3018,
	4515, 11669, 17842, 22516, 25299, 25955, 24431, 20855,
	15525, 8892, 1511, -5996, -13000, -18911, -23234, -25605,
	-25824, -23873, -19916, -14286, -7456, 0, 7457, 14287,
	19917, 23873, 25824, 25604, 23234, 18911, 12999, 5995,
	-1512, -8892, -15526, -20855, -24432, -25956, -25299, -22516,
	-17842, -11668, -4514, 3018, 10298, 16712, 21722, 24907},
	{
// Carrier 4 Phase 3
	18384, 12339, 5257, -2266, -9599, -16126, -21297, -24680,
	-25989, -25114, -22129, -17284, -10988, -3768, 3768, 10988,
	17284, 22129, 25114, 25989, 24680, 21297, 16126, 9599,
	2266, -5257, -12339, -18384, -22885, -25462, -25901, -24163,
	-20394, -14912, -8178, -756, 6729, 13649, 19422, 23564,
	25725, 25725, 23563, 19422, 13649, 6729, -756, -8178,
	-14913, -20394, -24163, -25901, -25462, -22885, -18384, -12339,
	-5257, 2266, 9599, 16126, 21298, 24680, 25989, 25114,
	22128, 17284, 10987, 3768, -3768, -10988, -17284, -22129,
	-25114, -25988, -24680, -21297, -16126, -9599, -2265, 5257,
	12339, 18384, 22885, 25462, 25901, 24162, 20394, 14912,
	8178, 756, -6729, -13649, -19422, -23564, -25725, -25725,
	-23563, -19422, -13649, -6729, 756, 8178, 14913, 20394,
	24163, 25901, 25462, 22885, 18384, 12339, 5257, -2266,
	-9599, -16126, -21298, -24680, -25989, -25114, -22128, -17284,
	-10987, -3767, 3768, 10988, 17284, 22129, 25114, 25988,
	24680, 21297, 16125, 9599, 2265, -5257, -12339, -18384,
	-22885, -25462, -25901, -24162, -20394, -14912, -8177, -755,
	6729, 13649, 19422, 23564, 25725, 25725, 23563, 19422,
	13649, 6729, -756, -8178, -14913, -20394, -24163, -25901,
	-25462, -22885, -18384, -12339, -5257, 2266, 9599, 16126,
	21298, 24680, 25989, 25113, 22128, 17284, 10987, 3767,
	-3768, -10988, -17284, -22129, -25114, -25988, -24680, -21297,
	-16125, -9599, -2265, 5258, 12339, 18385, 22885, 25462,
	25901, 24162, 20394, 14912, 8177, 755, -6729, -13649,
	-19422, -23564, -25725, -25725, -23563, -19422, -13649, -6728,
	756, 8178, 14913, 20395, 24163, 25901, 25462, 22885},
	},{{

// Carrier 5 Phase 0
	0, 8178, 15526, 21297, 24907, 25989, 24432, 20394,
	14287, 6729, -1511, -9599, -16712, -22129, -25299, -25901,
	-23873, -19422, -13000, -5257, 3018, 10988, 17842, 22885,
	25604, 25725, 23234, 18384, 11668, 3768, -4514, -12339,
	-18911, -23563, -25824, -25462, -22516, -17284, -10298, -2266,
	5995, 13649, 19917, 24163, 25956, 25114, 21722, 16126,
	8892, 756, -7456, -14912, -20855, -24680, -26000, -24680,
	-20855, -14913, -7456, 756, 8892, 16126, 21722, 25114,
	25956, 24163, 19917, 13649, 5996, -2265, -10297, -17284,
	-22516, -25462, -25824, -23564, -18911, -12339, -4514, 3768,
	11668, 18384, 23234, 25725, 25605, 22885, 17842, 10988,
	3018, -5257, -12999, -19422, -23873, -25901, -25299, -22129,
	-16712, -9599, -1511, 6729, 14287, 20394, 24431, 25988,
	24907, 21298, 15526, 8178, 0, -8177, -15525, -21297,
	-24907, -25989, -24432, -20394, -14287, -6729, 1511, 9599,
	16712, 22128, 25299, 25901, 23873, 19422, 13000, 5257,
	-3018, -10987, -17842, -22885, -25604, -25725, -23234, -18384,
	-11668, -3768, 4514, 12339, 18911, 23563, 25824, 25462,
	22516, 17284, 10298, 2266, -5995, -13649, -19916, -24162,
	-25955, -25114, -21722, -16126, -8892, -756, 7456, 14912,
	20855, 24680, 26000, 24680, 20855, 14913, 7457, -755,
	-8892, -16125, -21722, -25113, -25956, -24163, -19917, -13649,
	-5996, 2265, 10297, 17284, 22516, 25462, 25824, 23564,
	18911, 12339, 4515, -3767, -11668, -18384, -23234, -25725,
	-25605, -22885, -17842, -10988, -3018, 5257, 12999, 19422,
	23873, 25901, 25299, 22129, 16712, 9599, 1512, -6728,
	-14286, -20394, -24431, -25988, -24907, -21298, -15526, -8178},
	{
// Carrier 5 Phase 1
	18384, 23234, 25725, 25605, 22885, 17842, 10988, 3018,
	-5257, -12999, -19422, -23873, -25901, -25299, -22129, -16712,
	-9599, -1511, 6729, 14287, 20394, 24431, 25989, 24907,
	21297, 15526, 8178, 0, -8178, -15526, -21297, -24907,
	-25989, -24432, -20394, -14287, -6729, 1511, 9599, 16712,
	22128, 25299, 25901, 23873, 19422, 13000, 5257, -3018,
	-10988, -17842, -22885, -25604, -25725, -23234, -18384, -11668,
	-3768, 4514, 12339, 18911, 23563, 25824, 25462, 22516,
	17284, 10298, 2266, -5995, -13649, -19917, -24162, -25956,
	-25114, -21722, -16126, -8892, -756, 7456, 14912, 20855,
	24680, 26000, 24680, 20855, 14913, 7457, -756, -8892,
	-16125, -21722, -25114, -25956, -24163, -19917, -13649, -5996,
	2265, 10297, 17284, 22516, 25462, 25824, 23564, 18911,
	12339, 4515, -3768, -11668, -18384, -23234, -25725, -25605,
	-22885, -17842, -10988, -3018, 5257, 12999, 19422, 23873,
	25901, 25299, 22129, 16712, 9599, 1512, -6729, -14287,
	-20394, -24431, -25988, -24907, -21298, -15526, -8178, 0,
	8177, 15525, 21297, 24907, 25989, 24432, 20394, 14287,
	6729, -1511, -9599, -16712, -22128, -25299, -25901, -23873,
	-19422, -13000, -5257, 3018, 10987, 17842, 22885, 25604,
	25725, 23234, 18385, 11669, 3768, -4514, -12339, -18911,
	-23563, -25824, -25462, -22516, -17284, -10298, -2266, 5995,
	13649, 19916, 24162, 25955, 25114, 21722, 16126, 8892,
	756, -7456, -14912, -20854, -24680, -26000, -24680, -20855,
	-14913, -7457, 755, 8892, 16125, 21722, 25113, 25956,
	24163, 19917, 13649, 5996, -2265, -10297, -17284, -22516,
	-25462, -25824, -23564, -18912, -12339, -4515, 3767, 11668},
	{
// Carrier 5 Phase 2
	26000, 24680, 20855, 14912, 7456, -756, -8892, -16126,
	-21722, -25114, -25956, -24163, -19917, -13649, -5996, 2266,
	10298, 17284, 22516, 25462, 25824, 23564, 18911, 12339,
	4514, -3768, -11668, -18384, -23234, -25725, -25605, -22885,
	-17842, -10988, -3018, 5257, 12999, 19422, 23873, 25901,
	25299, 22129, 16712, 9599, 1511, -6729, -14287, -20394,
	-24431, -25988, -24907, -21298, -15526, -8178, 0, 8178,
	15526, 21297, 24907, 25989, 24432, 20394, 14287, 6729,
	-1511, -9599, -16712, -22128, -25299, -25901, -23873, -19422,
	-13000, -5257, 3018, 10987, 17842, 22885, 25604, 25725,
	23234, 18384, 11668, 3768, -4514, -12339, -18911, -23563,
	-25824, -25462, -22516, -17284, -10298, -2266, 5995, 13649,
	19917, 24162, 25956, 25114, 21722, 16126, 8892, 756,
	-7456, -14912, -20855, -24680, -26000, -24680, -20855, -14913,
	-7457, 755, 8892, 16125, 21722, 25114, 25956, 24163,
	19917, 13649, 5996, -2265, -10297, -17284, -22516, -25462,
	-25824, -23564, -18911, -12339, -4515, 3767, 11668, 18384,
	23234, 25725, 25605, 22885, 17842, 10988, 3018, -5257,
	-12999, -19422, -23873, -25901, -25299, -22129, -16712, -9599,
	-1512, 6729, 14286, 20394, 24431, 25988, 24907, 21298,
	15526, 8178, 0, -8177, -15525, -21297, -24907, -25989,
	-24432, -20395, -14287, -6729, 1511, 9599, 16712, 22128,
	25299, 25901, 23873, 19422, 13000, 5257, -3018, -10987,
	-17842, -22885, -25604, -25725, -23234, -18385, -11669, -3768,
	4514, 12339, 18911, 23563, 25824, 25462, 22516, 17284,
	10298, 2266, -5995, -13649, -19916, -24162, -25955, -25114,
	-21722, -16126, -8892, -756, 7456, 14912, 20854, 24680},
	{
// Carrier 5 Phase 3
	18384, 11668, 3768, -4514, -12339, -18911, -23564, -25824,
	-25462, -22516, -17284, -10298, -2266, 5995, 13649, 19917,
	24163, 25956, 25114, 21722, 16126, 8892, 756, -7456,
	-14912, -20855, -24680, -26000, -24680, -20855, -14913, -7456,
	756, 8892, 16126, 21722, 25114, 25956, 24163, 19917,
	13649, 5996, -2265, -10298, -17284, -22516, -25462, -25824,
	-23564, -18911, -12339, -4514, 3768, 11668, 18384, 23234,
	25725, 25605, 22885, 17842, 10988, 3018, -5257, -12999,
	-19422, -23873, -25901, -25299, -22129, -16712, -9599, -1511,
	6729, 14287, 20394, 24431, 25988, 24907, 21298, 15526,
	8178, 0, -8178, -15526, -21297, -24907, -25989, -24432,
	-20394, -14287, -6729, 1511, 9599, 16712, 22128, 25299,
	25901, 23873, 19422, 13000, 5257, -3018, -10987, -17842,
	-22885, -25604, -25725, -23234, -18384, -11668, -3768, 4514,
	12339, 18911, 23563, 25824, 25462, 22516, 17284, 10298,
	2266, -5995, -13649, -19917, -24162, -25955, -25114, -21722,
	-16126, -8892, -756, 7456, 14912, 20855, 24680, 26000,
	24680, 20855, 14913, 7457, -755, -8892, -16125, -21722,
	-25114, -25956, -24163, -19917, -13649, -5996, 2265, 10297,
	17284, 22516, 25462, 25824, 23564, 18911, 12339, 4515,
	-3767, -11668, -18384, -23234, -25725, -25605, -22885, -17842,
	-10988, -3018, 5257, 12999, 19422, 23873, 25901, 25299,
	22129, 16712, 9599, 1512, -6728, -14286, -20394, -24431,
	-25988, -24907, -21298, -15526, -8178, 0, 8177, 15525,
	21297, 24907, 25989, 24432, 20395, 14287, 6729, -1511,
	-9599, -16712, -22128, -25299, -25901, -23873, -19422, -13000,
	-5258, 3018, 10987, 17841, 22885, 25604, 25725, 23234},
	},{{

// Carrier 6 Phase 0
	0, 8892, 16712, 22516, 25605, 25605, 22516, 16712,
	8892, 0, -8892, -16712, -22516, -25604, -25605, -22516,
	-16712, -8892, 0, 8892, 16712, 22516, 25604, 25605,
	22516, 16712, 8892, 0, -8892, -16712, -22516, -25604,
	-25605, -22516, -16712, -8892, 0, 8892, 16712, 22516,
	25604, 25605, 22516, 16712, 8892, 0, -8892, -16712,
	-22516, -25604, -25605, -22516, -16712, -8892, 0, 8892,
	16712, 22516, 25604, 25605, 22516, 16712, 8892, 0,
	-8892, -16712, -22516, -25604, -25605, -22516, -16712, -8892,
	0, 8892, 16712, 22516, 25604, 25605, 22516, 16712,
	8892, 0, -8892, -16712, -22516, -25604, -25605, -22516,
	-16712, -8892, 0, 8892, 16712, 22516, 25604, 25605,
	22516, 16712, 8892, 0, -8892, -16712, -22516, -25604,
	-25605, -22516, -16712, -8892, 0, 8892, 16712, 22516,
	25604, 25605, 22516, 16712, 8892, 0, -8892, -16712,
	-22516, -25604, -25605, -22516, -16712, -8892, 0, 8892,
	16712, 22516, 25604, 25605, 22516, 16712, 8892, 0,
	-8892, -16712, -22516, -25604, -25605, -22516, -16712, -8892,
	0, 8892, 16712, 22516, 25604, 25605, 22516, 16712,
	8892, 0, -8892, -16712, -22516, -25604, -25605, -22516,
	-16712, -8892, 0, 8892, 16712, 22516, 25604, 25605,
	22516, 16712, 8892, 0, -8892, -16712, -22516, -25604,
	-25605, -22516, -16712, -8892, 0, 8892, 16712, 22516,
	25604, 25605, 22516, 16712, 8892, 0, -8892, -16712,
	-22516, -25604, -25605, -22516, -16712, -8892, 0, 8892,
	16712, 22516, 25604, 25605, 22516, 16712, 8892, 0,
	-8892, -16712, -22516, -25604, -25605, -22516, -16712, -8892},
	{
// Carrier 6 Phase 1
	18384, 23564, 25901, 25114, 21297, 14912, 6729, -2266,
	-10988, -18384, -23563, -25901, -25114, -21297, -14913, -6729,
	2266, 10988, 18384, 23563, 25901, 25114, 21297, 14913,
	6729, -2266, -10988, -18384, -23563, -25901, -25114, -21297,
	-14913, -6729, 2266, 10988, 18384, 23563, 25901, 25114,
	21297, 14913, 6729, -2266, -10988, -18384, -23563, -25901,
	-25114, -21297, -14913, -6729, 2266, 10988, 18384, 23563,
	25901, 25114, 21297, 14913, 6729, -2266, -10988, -18384,
	-23563, -25901, -25114, -21297, -14913, -6729, 2265, 10988,
	18384, 23563, 25901, 25114, 21297, 14913, 6729, -2265,
	-10988, -18384, -23563, -25901, -25114, -21297, -14913, -6729,
	2265, 10988, 18384, 23563, 25901, 25114, 21297, 14913,
	6729, -2265, -10988, -18384, -23563, -25901, -25114, -21297,
	-14913, -6729, 2265, 10988, 18384, 23563, 25901, 25114,
	21297, 14913, 6729, -2265, -10987, -18384, -23563, -25901,
	-25114, -21298, -14913, -6729, 2265, 10987, 18384, 23563,
	25901, 25114, 21298, 14913, 6729, -2265, -10987, -18384,
	-23563, -25901, -25114, -21298, -14913, -6729, 2265, 10987,
	18384, 23563, 25901, 25114, 21298, 14913, 6729, -2265,
	-10987, -18384, -23563, -25901, -25114, -21298, -14913, -6729,
	2265, 10987, 18384, 23563, 25901, 25114, 21298, 14913,
	6729, -2265, -10987, -18384, -23563, -25901, -25114, -21298,
	-14913, -6729, 2265, 10987, 18384, 23563, 25901, 25114,
	21298, 14913, 6729, -2265, -10987, -18384, -23563, -25901,
	-25114, -21298, -14913, -6729, 2265, 10987, 18384, 23563,
	25901, 25114, 21298, 14913, 6729, -2265, -10987, -18384,
	-23563, -25901, -25114, -21298, -14913, -6729, 2265, 10987},
	{
// Carrier 6 Phase 2
	26000, 24432, 19917, 13000, 4514, -4514, -12999, -19917,
	-24432, -26000, -24432, -19917, -13000, -4514, 4514, 12999,
	19917, 24432, 26000, 24432, 19917, 13000, 4514, -4514,
	-12999, -19917, -24431, -26000, -24432, -19917, -13000, -4514,
	4514, 12999, 19917, 24431, 26000, 24432, 19917, 13000,
	4514, -4514, -12999, -19917, -24431, -26000, -24432, -19917,
	-13000, -4514, 4514, 12999, 19917, 24431, 26000, 24432,
	19917, 13000, 4514, -4514, -12999, -19917, -24431, -26000,
	-24432, -19917, -13000, -4514, 4514, 12999, 19917, 24431,
	26000, 24432, 19917, 13000, 4514, -4514, -12999, -19917,
	-24431, -26000, -24432, -19917, -13000, -4514, 4514, 12999,
	19917, 24431, 26000, 24432, 19917, 13000, 4514, -4514,
	-12999, -19917, -24431, -26000, -24432, -19917, -13000, -4514,
	4514, 12999, 19917, 24431, 26000, 24432, 19917, 13000,
	4515, -4514, -12999, -19917, -24431, -26000, -24432, -19917,
	-13000, -4515, 4514, 12999, 19917, 24431, 26000, 24432,
	19917, 13000, 4515, -4514, -12999, -19917, -24431, -26000,
	-24432, -19917, -13000, -4515, 4514, 12999, 19917, 24431,
	26000, 24432, 19917, 13000, 4515, -4514, -12999, -19917,
	-24431, -26000, -24432, -19917, -13000, -4515, 4514, 12999,
	19917, 24431, 26000, 24432, 19917, 13000, 4515, -4514,
	-12999, -19917, -24431, -26000, -24432, -19917, -13000, -4515,
	4514, 12999, 19917, 24431, 26000, 24432, 19917, 13000,
	4515, -4514, -12999, -19916, -24431, -26000, -24432, -19917,
	-13000, -4515, 4514, 12999, 19916, 24431, 26000, 24432,
	19917, 13000, 4515, -4514, -12999, -19916, -24431, -26000,
	-24432, -19917, -13000, -4515, 4514, 12999, 19916, 24431},
	{
// Carrier 6 Phase 3
	18384, 10988, 2266, -6729, -14912, -21297, -25114, -25901,
	-23564, -18384, -10988, -2266, 6729, 14912, 21297, 25114,
	25901, 23564, 18384, 10988, 2266, -6729, -14912, -21297,
	-25114, -25901, -23564, -18384, -10988, -2266, 6729, 14912,
	21297, 25114, 25901, 23564, 18384, 10988, 2266, -6729,
	-14912, -21297, -25114, -25901, -23564, -18384, -10988, -2266,
	6729, 14912, 21297, 25114, 25901, 23564, 18384, 10988,
	2266, -6729, -14912, -21297, -25114, -25901, -23564, -18384,
	-10988, -2266, 6729, 14912, 21297, 25114, 25901, 23564,
	18384, 10988, 2266, -6729, -14912, -21297, -25114, -25901,
	-23564, -18384, -10988, -2266, 6729, 14912, 21297, 25114,
	25901, 23564, 18384, 10988, 2266, -6729, -14912, -21297,
	-25114, -25901, -23564, -18384, -10988, -2266, 6729, 14912,
	21297, 25114, 25901, 23564, 18384, 10988, 2266, -6729,
	-14912, -21297, -25114, -25901, -23564, -18384, -10988, -2266,
	6729, 14912, 21297, 25114, 25901, 23564, 18384, 10988,
	2266, -6729, -14912, -21297, -25114, -25901, -23564, -18384,
	-10988, -2266, 6729, 14912, 21297, 25114, 25901, 23564,
	18384, 10988, 2266, -6729, -14912, -21297, -25114, -25901,
	-23564, -18384, -10988, -2266, 6729, 14912, 21297, 25114,
	25901, 23564, 18384, 10988, 2266, -6729, -14912, -21297,
	-25114, -25901, -23564, -18384, -10988, -2266, 6729, 14912,
	21297, 25114, 25901, 23564, 18384, 10988, 2266, -6729,
	-14912, -21297, -25114, -25901, -23564, -18384, -10988, -2266,
	6729, 14912, 21297, 25114, 25901, 23564, 18384, 10988,
	2266, -6729, -14912, -21297, -25113, -25901, -23564, -18384,
	-10988, -2266, 6729, 14912, 21297, 25113, 25901, 23564},
	},{{

// Carrier 7 Phase 0
	0, 9599, 17842, 23564, 25956, 24680, 19917, 12339,
	3018, -6729, -15526, -22129, -25605, -25462, -21722, -14912,
	-5996, 3768, 13000, 20394, 24907, 25901, 23234, 17284,
	8892, -756, -10298, -18384, -23873, -25989, -24431, -19422,
	-11668, -2266, 7456, 16126, 22516, 25725, 25299, 21297,
	14287, 5257, -4514, -13649, -20855, -25114, -25824, -22885,
	-16712, -8178, 1511, 10988, 18911, 24163, 26000, 24163,
	18911, 10988, 1511, -8178, -16712, -22885, -25824, -25114,
	-20855, -13649, -4514, 5257, 14287, 21298, 25299, 25725,
	22516, 16126, 7456, -2266, -11668, -19422, -24432, -25988,
	-23873, -18384, -10297, -756, 8892, 17284, 23234, 25901,
	24907, 20394, 12999, 3768, -5996, -14913, -21722, -25462,
	-25604, -22128, -15526, -6729, 3018, 12339, 19917, 24680,
	25956, 23563, 17842, 9599, 0, -9599, -17842, -23564,
	-25956, -24680, -19917, -12339, -3018, 6729, 15526, 22129,
	25605, 25462, 21722, 14912, 5995, -3768, -13000, -20394,
	-24907, -25901, -23234, -17284, -8892, 756, 10298, 18384,
	23873, 25989, 24431, 19422, 11668, 2265, -7457, -16126,
	-22516, -25725, -25299, -21297, -14287, -5257, 4515, 13649,
	20855, 25114, 25824, 22885, 16712, 8177, -1512, -10988,
	-18911, -24163, -26000, -24162, -18911, -10987, -1511, 8178,
	16712, 22885, 25824, 25113, 20855, 13649, 4514, -5257,
	-14287, -21298, -25299, -25725, -22516, -16125, -7456, 2266,
	11669, 19422, 24432, 25988, 23873, 18384, 10297, 755,
	-8892, -17284, -23234, -25901, -24907, -20394, -12999, -3767,
	5996, 14913, 21722, 25462, 25604, 22128, 15525, 6728,
	-3018, -12339, -19917, -24680, -25955, -23563, -17842, -9599},
	{
// Carrier 7 Phase 1
	18384, 23873, 25989, 24432, 19422, 11668, 2266, -7456,
	-16126, -22516, -25725, -25299, -21297, -14287, -5257, 4514,
	13649, 20855, 25114, 25824, 22885, 16712, 8178, -1511,
	-10988, -18911, -24163, -26000, -24163, -18911, -10988, -1511,
	8178, 16712, 22885, 25824, 25114, 20855, 13649, 4514,
	-5257, -14287, -21297, -25299, -25725, -22516, -16126, -7456,
	2266, 11668, 19422, 24432, 25988, 23873, 18384, 10298,
	756, -8892, -17284, -23234, -25901, -24907, -20394, -12999,
	-3768, 5996, 14913, 21722, 25462, 25604, 22128, 15526,
	6729, -3018, -12339, -19917, -24680, -25956, -23563, -17842,
	-9599, 0, 9599, 17842, 23564, 25956, 24680, 19917,
	12339, 3018, -6729, -15526, -22129, -25605, -25462, -21722,
	-14912, -5995, 3768, 13000, 20394, 24907, 25901, 23234,
	17284, 8892, -756, -10298, -18384, -23873, -25989, -24431,
	-19422, -11668, -2265, 7457, 16126, 22516, 25725, 25299,
	21297, 14287, 5257, -4515, -13649, -20855, -25114, -25824,
	-22885, -16712, -8177, 1511, 10988, 18911, 24163, 26000,
	24162, 18911, 10987, 1511, -8178, -16712, -22885, -25824,
	-25114, -20855, -13649, -4514, 5257, 14287, 21298, 25299,
	25725, 22516, 16125, 7456, -2266, -11668, -19422, -24432,
	-25988, -23873, -18384, -10297, -755, 8892, 17284, 23234,
	25901, 24907, 20394, 12999, 3767, -5996, -14913, -21722,
	-25462, -25604, -22128, -15525, -6729, 3018, 12339, 19917,
	24680, 25955, 23563, 17842, 9599, 0, -9599, -17842,
	-23564, -25956, -24680, -19916, -12339, -3018, 6729, 15526,
	22129, 25605, 25462, 21722, 14912, 5995, -3768, -13000,
	-20395, -24907, -25901, -23234, -17284, -8892, 756, 10298},
	{
// Carrier 7 Phase 2
	26000, 24163, 18911, 10988, 1511, -8178, -16712, -22885,
	-25824, -25114, -20855, -13649, -4514, 5257, 14287, 21297,
	25299, 25725, 22516, 16126, 7456, -2266, -11668, -19422,
	-24432, -25989, -23873, -18384, -10298, -756, 8892, 17284,
	23234, 25901, 24907, 20394, 12999, 3768, -5996, -14913,
	-21722, -25462, -25604, -22128, -15526, -6729, 3018, 12339,
	19917, 24680, 25956, 23563, 17842, 9599, 0, -9599,
	-17842, -23564, -25956, -24680, -19917, -12339, -3018, 6729,
	15526, 22129, 25605, 25462, 21722, 14912, 5995, -3768,
	-13000, -20394, -24907, -25901, -23234, -17284, -8892, 756,
	10298, 18384, 23873, 25989, 24431, 19422, 11668, 2265,
	-7457, -16126, -22516, -25725, -25299, -21297, -14287, -5257,
	4515, 13649, 20855, 25114, 25824, 22885, 16712, 8177,
	-1511, -10988, -18911, -24163, -26000, -24162, -18911, -10987,
	-1511, 8178, 16712, 22885, 25824, 25114, 20855, 13649,
	4514, -5257, -14287, -21298, -25299, -25725, -22516, -16125,
	-7456, 2266, 11668, 19422, 24432, 25988, 23873, 18384,
	10297, 755, -8892, -17284, -23234, -25901, -24907, -20394,
	-12999, -3767, 5996, 14913, 21722, 25462, 25604, 22128,
	15525, 6729, -3018, -12339, -19917, -24680, -25955, -23563,
	-17842, -9599, 0, 9599, 17842, 23564, 25956, 24680,
	19916, 12339, 3018, -6729, -15526, -22129, -25605, -25462,
	-21722, -14912, -5995, 3768, 13000, 20394, 24907, 25901,
	23234, 17284, 8892, -756, -10298, -18384, -23873, -25989,
	-24431, -19422, -11668, -2265, 7457, 16126, 22516, 25725,
	25299, 21297, 14286, 5257, -4515, -13649, -20855, -25114,
	-25824, -22885, -16712, -8177, 1512, 10988, 18911, 24163},
	{
// Carrier 7 Phase 3
	18384, 10298, 756, -8892, -17284, -23234, -25901, -24907,
	-20394, -12999, -3768, 5996, 14913, 21722, 25462, 25604,
	22129, 15526, 6729, -3018, -12339, -19917, -24680, -25956,
	-23563, -17842, -9599, 0, 9599, 17842, 23564, 25956,
	24680, 19917, 12339, 3018, -6729, -15526, -22129, -25605,
	-25462, -21722, -14912, -5995, 3768, 13000, 20394, 24907,
	25901, 23234, 17284, 8892, -756, -10298, -18384, -23873,
	-25989, -24431, -19422, -11668, -2265, 7456, 16126, 22516,
	25725, 25299, 21297, 14287, 5257, -4514, -13649, -20855,
	-25114, -25824, -22885, -16712, -8178, 1511, 10988, 18911,
	24163, 26000, 24162, 18911, 10987, 1511, -8178, -16712,
	-22885, -25824, -25114, -20855, -13649, -4514, 5257, 14287,
	21298, 25299, 25725, 22516, 16125, 7456, -2266, -11668,
	-19422, -24432, -25988, -23873, -18384, -10297, -756, 8892,
	17284, 23234, 25901, 24907, 20394, 12999, 3768, -5996,
	-14913, -21722, -25462, -25604, -22128, -15525, -6729, 3018,
	12339, 19917, 24680, 25955, 23563, 17842, 9599, 0,
	-9599, -17842, -23564, -25956, -24680, -19916, -12339, -3018,
	6729, 15526, 22129, 25605, 25462, 21722, 14912, 5995,
	-3768, -13000, -20394, -24907, -25901, -23234, -17284, -8892,
	756, 10298, 18384, 23873, 25989, 24431, 19422, 11668,
	2265, -7457, -16126, -22516, -25725, -25299, -21297, -14286,
	-5257, 4515, 13649, 20855, 25114, 25824, 22885, 16712,
	8177, -1512, -10988, -18911, -24163, -26000, -24162, -18911,
	-10987, -1511, 8178, 16712, 22885, 25824, 25113, 20854,
	13649, 4514, -5257, -14287, -21298, -25299, -25725, -22516,
	-16125, -7456, 2266, 11669, 19422, 24432, 25988, 23873},
	},{{

// Carrier 8 Phase 0
	0, 10298, 18911, 24432, 25956, 23234, 16712, 7456,
	-3018, -12999, -20855, -25299, -25605, -21722, -14287, -4514,
	5995, 15526, 22516, 25824, 24907, 19917, 11668, 1511,
	-8892, -17842, -23873, -26000, -23873, -17842, -8892, 1511,
	11668, 19917, 24907, 25824, 22516, 15526, 5996, -4514,
	-14287, -21722, -25604, -25299, -20855, -13000, -3018, 7456,
	16712, 23234, 25956, 24432, 18911, 10298, 0, -10297,
	-18911, -24431, -25956, -23234, -16712, -7457, 3018, 12999,
	20855, 25299, 25605, 21722, 14287, 4514, -5995, -15526,
	-22516, -25824, -24907, -19917, -11668, -1511, 8892, 17842,
	23873, 26000, 23873, 17842, 8892, -1511, -11668, -19917,
	-24907, -25824, -22516, -15526, -5996, 4514, 14287, 21722,
	25604, 25299, 20855, 13000, 3018, -7456, -16712, -23234,
	-25956, -24432, -18911, -10298, 0, 10297, 18911, 24431,
	25956, 23234, 16712, 7457, -3018, -12999, -20855, -25299,
	-25605, -21722, -14287, -4515, 5995, 15525, 22516, 25824,
	24907, 19917, 11669, 1512, -8892, -17842, -23873, -26000,
	-23873, -17842, -8892, 1511, 11668, 19916, 24907, 25824,
	22516, 15526, 5996, -4514, -14286, -21722, -25604, -25299,
	-20855, -13000, -3018, 7456, 16712, 23234, 25955, 24432,
	18911, 10298, 0, -10297, -18911, -24431, -25956, -23234,
	-16712, -7457, 3018, 12999, 20854, 25299, 25605, 21722,
	14287, 4515, -5995, -15525, -22516, -25824, -24907, -19917,
	-11669, -1512, 8892, 17842, 23873, 26000, 23873, 17842,
	8892, -1511, -11668, -19916, -24907, -25824, -22516, -15526,
	-5996, 4514, 14286, 21722, 25604, 25299, 20855, 13000,
	3018, -7456, -16712, -23234, -25955, -24432, -18912, -10298},
	{
// Carrier 8 Phase 1
	18384, 24163, 25989, 23564, 17284, 8178, -2266, -12339,
	-20394, -25114, -25725, -22129, -14913, -5257, 5257, 14912,
	22129, 25725, 25114, 20394, 12339, 2266, -8178, -17284,
	-23563, -25989, -24163, -18384, -9599, 756, 10988, 19422,
	24680, 25901, 22885, 16126, 6729, -3768, -13649, -21297,
	-25462, -25462, -21298, -13649, -3768, 6729, 16126, 22885,
	25901, 24680, 19422, 10988, 756, -9599, -18384, -24162,
	-25989, -23564, -17284, -8178, 2265, 12339, 20394, 25114,
	25725, 22129, 14913, 5257, -5257, -14912, -22128, -25725,
	-25114, -20394, -12339, -2266, 8178, 17284, 23563, 25988,
	24163, 18384, 9599, -756, -10987, -19422, -24680, -25901,
	-22885, -16126, -6729, 3768, 13649, 21297, 25462, 25462,
	21298, 13649, 3768, -6729, -16125, -22885, -25901, -24680,
	-19422, -10988, -756, 9599, 18384, 24162, 25989, 23564,
	17284, 8178, -2265, -12339, -20394, -25114, -25725, -22129,
	-14913, -5257, 5257, 14912, 22128, 25725, 25114, 20394,
	12339, 2266, -8177, -17284, -23563, -25988, -24163, -18384,
	-9599, 755, 10987, 19422, 24680, 25901, 22885, 16126,
	6729, -3767, -13649, -21297, -25462, -25462, -21298, -13649,
	-3768, 6728, 16125, 22885, 25901, 24680, 19422, 10988,
	756, -9599, -18384, -24162, -25989, -23564, -17284, -8178,
	2265, 12339, 20394, 25113, 25725, 22129, 14913, 5258,
	-5257, -14912, -22128, -25725, -25114, -20395, -12339, -2266,
	8177, 17284, 23563, 25988, 24163, 18385, 9599, -755,
	-10987, -19422, -24680, -25901, -22885, -16126, -6729, 3767,
	13649, 21297, 25462, 25462, 21298, 13649, 3768, -6728,
	-16125, -22885, -25901, -24680, -19422, -10988, -756, 9598},
	{
// Carrier 8 Phase 2
	26000, 23873, 17842, 8892, -1511, -11668, -19917, -24907,
	-25824, -22516, -15526, -5996, 4514, 14287, 21722, 25604,
	25299, 20855, 13000, 3018, -7456, -16712, -23234, -25956,
	-24432, -18911, -10298, 0, 10298, 18911, 24431, 25956,
	23234, 16712, 7456, -3018, -12999, -20855, -25299, -25605,
	-21722, -14287, -4514, 5995, 15526, 22516, 25824, 24907,
	19917, 11668, 1511, -8892, -17842, -23873, -26000, -23873,
	-17842, -8892, 1511, 11668, 19917, 24907, 25824, 22516,
	15526, 5996, -4514, -14287, -21722, -25604, -25299, -20855,
	-13000, -3018, 7456, 16712, 23234, 25956, 24432, 18911,
	10298, 0, -10297, -18911, -24431, -25956, -23234, -16712,
	-7457, 3018, 12999, 20855, 25299, 25605, 21722, 14287,
	4515, -5995, -15525, -22516, -25824, -24907, -19917, -11668,
	-1511, 8892, 17842, 23873, 26000, 23873, 17842, 8892,
	-1511, -11668, -19917, -24907, -25824, -22516, -15526, -5996,
	4514, 14287, 21722, 25604, 25299, 20855, 13000, 3018,
	-7456, -16712, -23234, -25955, -24432, -18911, -10298, 0,
	10297, 18911, 24431, 25956, 23234, 16712, 7457, -3018,
	-12999, -20855, -25299, -25605, -21722, -14287, -4515, 5995,
	15525, 22516, 25824, 24907, 19917, 11669, 1512, -8892,
	-17842, -23873, -26000, -23873, -17842, -8892, 1511, 11668,
	19916, 24907, 25824, 22516, 15526, 5996, -4514, -14286,
	-21722, -25604, -25299, -20855, -13000, -3018, 7456, 16712,
	23234, 25955, 24432, 18911, 10298, 0, -10297, -18911,
	-24431, -25956, -23234, -16712, -7457, 3018, 12999, 20854,
	25299, 25605, 21722, 14287, 4515, -5995, -15525, -22516,
	-25824, -24907, -19917, -11669, -1512, 8892, 17841, 23873},
	{
// Carrier 8 Phase 3
	18384, 9599, -756, -10988, -19422, -24680, -25901, -22885,
	-16126, -6729, 3768, 13649, 21297, 25462, 25462, 21297,
	13649, 3768, -6729, -16126, -22885, -25901, -24680, -19422,
	-10988, -756, 9599, 18384, 24163, 25989, 23564, 17284,
	8178, -2265, -12339, -20394, -25114, -25725, -22129, -14913,
	-5257, 5257, 14912, 22128, 25725, 25114, 20394, 12339,
	2266, -8178, -17284, -23563, -25988, -24163, -18384, -9599,
	756, 10987, 19422, 24680, 25901, 22885, 16126, 6729,
	-3768, -13649, -21297, -25462, -25462, -21298, -13649, -3768,
	6729, 16125, 22885, 25901, 24680, 19422, 10988, 756,
	-9599, -18384, -24162, -25989, -23564, -17284, -8178, 2265,
	12339, 20394, 25114, 25725, 22129, 14913, 5257, -5257,
	-14912, -22128, -25725, -25114, -20394, -12339, -2266, 8177,
	17284, 23563, 25988, 24163, 18384, 9599, -755, -10987,
	-19422, -24680, -25901, -22885, -16126, -6729, 3767, 13649,
	21297, 25462, 25462, 21298, 13649, 3768, -6729, -16125,
	-22885, -25901, -24680, -19422, -10988, -756, 9599, 18384,
	24162, 25989, 23564, 17284, 8178, -2265, -12339, -20394,
	-25113, -25725, -22129, -14913, -5257, 5257, 14912, 22128,
	25725, 25114, 20395, 12339, 2266, -8177, -17284, -23563,
	-25988, -24163, -18385, -9599, 755, 10987, 19422, 24680,
	25901, 22885, 16126, 6729, -3767, -13649, -21297, -25462,
	-25462, -21298, -13649, -3768, 6728, 16125, 22885, 25901,
	24680, 19422, 10988, 756, -9599, -18384, -24162, -25989,
	-23564, -17284, -8178, 2265, 12339, 20394, 25113, 25725,
	22129, 14913, 5258, -5257, -14912, -22128, -25725, -25114,
	-20395, -12340, -2266, 8177, 17284, 23563, 25988, 24163},
	},{{

// Carrier 9 Phase 0
	0, 10988, 19917, 25114, 25605, 21297, 13000, 2266,
	-8892, -18384, -24432, -25901, -22516, -14913, -4514, 6729,
	16712, 23563, 26000, 23564, 16712, 6729, -4514, -14912,
	-22516, -25901, -24432, -18384, -8892, 2266, 12999, 21297,
	25604, 25114, 19917, 10988, 0, -10988, -19917, -25114,
	-25605, -21297, -13000, -2266, 8892, 18384, 24431, 25901,
	22516, 14913, 4514, -6729, -16712, -23563, -26000, -23564,
	-16712, -6729, 4514, 14912, 22516, 25901, 24432, 18384,
	8892, -2265, -12999, -21297, -25604, -25114, -19917, -10988,
	0, 10988, 19917, 25114, 25605, 21297, 13000, 2266,
	-8892, -18384, -24431, -25901, -22516, -14913, -4514, 6729,
	16712, 23563, 26000, 23564, 16712, 6729, -4514, -14912,
	-22516, -25901, -24432, -18384, -8892, 2265, 12999, 21297,
	25604, 25114, 19917, 10988, 0, -10987, -19917, -25114,
	-25605, -21298, -13000, -2266, 8892, 18384, 24431, 25901,
	22516, 14913, 4514, -6729, -16712, -23563, -26000, -23564,
	-16712, -6729, 4514, 14912, 22516, 25901, 24432, 18384,
	8892, -2265, -12999, -21297, -25604, -25114, -19917, -10988,
	0, 10987, 19917, 25114, 25605, 21298, 13000, 2266,
	-8892, -18384, -24431, -25901, -22516, -14913, -4514, 6729,
	16712, 23563, 26000, 23564, 16712, 6729, -4514, -14912,
	-22516, -25901, -24432, -18384, -8892, 2265, 12999, 21297,
	25604, 25114, 19917, 10988, 0, -10987, -19917, -25114,
	-25605, -21298, -13000, -2266, 8892, 18384, 24431, 25901,
	22516, 14913, 4515, -6729, -16712, -23563, -26000, -23564,
	-16712, -6729, 4514, 14912, 22516, 25901, 24432, 18384,
	8892, -2265, -12999, -21297, -25604, -25114, -19917, -10988},
	{
// Carrier 9 Phase 1
	18384, 24432, 25901, 22516, 14912, 4514, -6729, -16712,
	-23563, -26000, -23564, -16712, -6729, 4514, 14912, 22516,
	25901, 24432, 18384, 8892, -2266, -12999, -21297, -25604,
	-25114, -19917, -10988, 0, 10988, 19917, 25114, 25605,
	21297, 13000, 2266, -8892, -18384, -24431, -25901, -22516,
	-14913, -4514, 6729, 16712, 23563, 26000, 23564, 16712,
	6729, -4514, -14912, -22516, -25901, -24432, -18384, -8892,
	2265, 12999, 21297, 25604, 25114, 19917, 10988, 0,
	-10988, -19917, -25114, -25605, -21297, -13000, -2266, 8892,
	18384, 24431, 25901, 22516, 14913, 4514, -6729, -16712,
	-23563, -26000, -23564, -16712, -6729, 4514, 14912, 22516,
	25901, 24432, 18384, 8892, -2265, -12999, -21297, -25604,
	-25114, -19917, -10988, 0, 10987, 19917, 25114, 25605,
	21298, 13000, 2266, -8892, -18384, -24431, -25901, -22516,
	-14913, -4514, 6729, 16712, 23563, 26000, 23564, 16712,
	6729, -4514, -14912, -22516, -25901, -24432, -18384, -8892,
	2265, 12999, 21297, 25604, 25114, 19917, 10988, 0,
	-10987, -19917, -25114, -25605, -21298, -13000, -2266, 8892,
	18384, 24431, 25901, 22516, 14913, 4514, -6729, -16712,
	-23563, -26000, -23564, -16712, -6729, 4514, 14912, 22516,
	25901, 24432, 18384, 8892, -2265, -12999, -21297, -25604,
	-25114, -19917, -10988, 0, 10987, 19917, 25114, 25605,
	21298, 13000, 2266, -8892, -18384, -24431, -25901, -22516,
	-14913, -4515, 6729, 16712, 23563, 26000, 23564, 16712,
	6729, -4514, -14912, -22516, -25901, -24432, -18384, -8892,
	2265, 12999, 21297, 25604, 25114, 19917, 10988, 0,
	-10987, -19917, -25114, -25605, -21298, -13000, -2266, 8892},
	{
// Carrier 9 Phase 2
	26000, 23564, 16712, 6729, -4514, -14912, -22516, -25901,
	-24432, -18384, -8892, 2266, 12999, 21297, 25604, 25114,
	19917, 10988, 0, -10988, -19917, -25114, -25605, -21297,
	-13000, -2266, 8892, 18384, 24431, 25901, 22516, 14913,
	4514, -6729, -16712, -23563, -26000, -23564, -16712, -6729,
	4514, 14912, 22516, 25901, 24432, 18384, 8892, -2266,
	-12999, -21297, -25604, -25114, -19917, -10988, 0, 10988,
	19917, 25114, 25605, 21297, 13000, 2266, -8892, -18384,
	-24431, -25901, -22516, -14913, -4514, 6729, 16712, 23563,
	26000, 23564, 16712, 6729, -4514, -14912, -22516, -25901,
	-24432, -18384, -8892, 2265, 12999, 21297, 25604, 25114,
	19917, 10988, 0, -10987, -19917, -25114, -25605, -21298,
	-13000, -2266, 8892, 18384, 24431, 25901, 22516, 14913,
	4514, -6729, -16712, -23563, -26000, -23564, -16712, -6729,
	4514, 14912, 22516, 25901, 24432, 18384, 8892, -2265,
	-12999, -21297, -25604, -25114, -19917, -10988, 0, 10987,
	19917, 25114, 25605, 21298, 13000, 2266, -8892, -18384,
	-24431, -25901, -22516, -14913, -4514, 6729, 16712, 23563,
	26000, 23564, 16712, 6729, -4514, -14912, -22516, -25901,
	-24432, -18384, -8892, 2265, 12999, 21297, 25604, 25114,
	19917, 10988, 0, -10987, -19917, -25114, -25605, -21298,
	-13000, -2266, 8892, 18384, 24431, 25901, 22516, 14913,
	4515, -6729, -16712, -23563, -26000, -23564, -16712, -6729,
	4514, 14912, 22516, 25901, 24432, 18384, 8892, -2265,
	-12999, -21297, -25604, -25114, -19917, -10988, 0, 10987,
	19917, 25114, 25605, 21298, 13000, 2266, -8892, -18384,
	-24431, -25901, -22516, -14913, -4515, 6729, 16712, 23563},
	{
// Carrier 9 Phase 3
	18384, 8892, -2266, -12999, -21297, -25604, -25114, -19917,
	-10988, 0, 10988, 19917, 25114, 25605, 21297, 13000,
	2266, -8892, -18384, -24432, -25901, -22516, -14913, -4514,
	6729, 16712, 23563, 26000, 23564, 16712, 6729, -4514,
	-14912, -22516, -25901, -24432, -18384, -8892, 2266, 12999,
	21297, 25604, 25114, 19917, 10988, 0, -10988, -19917,
	-25114, -25605, -21297, -13000, -2266, 8892, 18384, 24431,
	25901, 22516, 14913, 4514, -6729, -16712, -23563, -26000,
	-23564, -16712, -6729, 4514, 14912, 22516, 25901, 24432,
	18384, 8892, -2265, -12999, -21297, -25604, -25114, -19917,
	-10988, 0, 10988, 19917, 25114, 25605, 21297, 13000,
	2266, -8892, -18384, -24431, -25901, -22516, -14913, -4514,
	6729, 16712, 23563, 26000, 23564, 16712, 6729, -4514,
	-14912, -22516, -25901, -24432, -18384, -8892, 2265, 12999,
	21297, 25604, 25114, 19917, 10988, 0, -10987, -19917,
	-25114, -25605, -21298, -13000, -2266, 8892, 18384, 24431,
	25901, 22516, 14913, 4514, -6729, -16712, -23563, -26000,
	-23564, -16712, -6729, 4514, 14912, 22516, 25901, 24432,
	18384, 8892, -2265, -12999, -21297, -25604, -25114, -19917,
	-10988, 0, 10987, 19917, 25114, 25605, 21298, 13000,
	2266, -8892, -18384, -24431, -25901, -22516, -14913, -4515,
	6729, 16712, 23563, 26000, 23564, 16712, 6729, -4514,
	-14912, -22516, -25901, -24432, -18384, -8892, 2265, 12999,
	21297, 25604, 25114, 19917, 10988, 0, -10987, -19917,
	-25114, -25605, -21298, -13000, -2266, 8892, 18384, 24431,
	25901, 22516, 14913, 4515, -6729, -16712, -23563, -26000,
	-23564, -16712, -6729, 4514, 14912, 22516, 25901, 24432},
	},{{

// Carrier 10 Phase 0
	0, 11668, 20855, 25605, 24907, 18911, 8892, -3018,
	-14287, -22516, -25956, -23873, -16712, -5996, 5996, 16712,
	23873, 25956, 22516, 14287, 3018, -8892, -18911, -24907,
	-25604, -20855, -11668, 0, 11668, 20855, 25605, 24907,
	18911, 8892, -3018, -14287, -22516, -25956, -23873, -16712,
	-5995, 5996, 16712, 23873, 25956, 22516, 14287, 3018,
	-8892, -18911, -24907, -25604, -20855, -11668, 0, 11668,
	20855, 25605, 24907, 18911, 8892, -3018, -14287, -22516,
	-25956, -23873, -16712, -5995, 5996, 16712, 23873, 25956,
	22516, 14287, 3018, -8892, -18911, -24907, -25604, -20855,
	-11668, 0, 11668, 20855, 25605, 24907, 18911, 8892,
	-3018, -14287, -22516, -25956, -23873, -16712, -5995, 5996,
	16712, 23873, 25956, 22516, 14287, 3018, -8892, -18911,
	-24907, -25604, -20855, -11668, 0, 11668, 20855, 25605,
	24907, 18911, 8892, -3018, -14287, -22516, -25956, -23873,
	-16712, -5995, 5996, 16712, 23873, 25956, 22516, 14287,
	3018, -8892, -18911, -24907, -25604, -20855, -11668, 0,
	11668, 20855, 25605, 24907, 18911, 8892, -3018, -14287,
	-22516, -25956, -23873, -16712, -5995, 5996, 16712, 23873,
	25956, 22516, 14287, 3018, -8892, -18911, -24907, -25604,
	-20855, -11668, 0, 11668, 20855, 25605, 24907, 18911,
	8892, -3018, -14287, -22516, -25956, -23873, -16712, -5995,
	5996, 16712, 23873, 25955, 22516, 14287, 3018, -8892,
	-18911, -24907, -25604, -20855, -11668, 0, 11669, 20855,
	25605, 24907, 18911, 8892, -3018, -14287, -22516, -25956,
	-23873, -16712, -5995, 5996, 16712, 23873, 25955, 22516,
	14287, 3018, -8892, -18911, -24907, -25604, -20855, -11668},
	{
// Carrier 10 Phase 1
	18384, 24680, 25725, 21297, 12339, 756, -10988, -20394,
	-25462, -25114, -19422, -9599, 2266, 13649, 22129, 25901,
	24163, 17284, 6729, -5257, -16126, -23564, -25989, -22885,
	-14912, -3768, 8178, 18384, 24680, 25725, 21297, 12339,
	756, -10988, -20394, -25462, -25114, -19422, -9599, 2266,
	13649, 22129, 25901, 24163, 17284, 6729, -5257, -16126,
	-23564, -25988, -22885, -14912, -3768, 8178, 18384, 24680,
	25725, 21297, 12339, 756, -10988, -20394, -25462, -25114,
	-19422, -9599, 2266, 13649, 22129, 25901, 24163, 17284,
	6729, -5257, -16126, -23564, -25988, -22885, -14912, -3768,
	8178, 18384, 24680, 25725, 21297, 12339, 756, -10988,
	-20394, -25462, -25114, -19422, -9599, 2266, 13649, 22129,
	25901, 24162, 17284, 6729, -5257, -16126, -23564, -25988,
	-22885, -14912, -3768, 8178, 18384, 24680, 25725, 21297,
	12339, 756, -10988, -20394, -25462, -25114, -19422, -9599,
	2266, 13649, 22129, 25901, 24162, 17284, 6729, -5257,
	-16126, -23564, -25988, -22885, -14912, -3768, 8178, 18384,
	24680, 25725, 21297, 12339, 756, -10988, -20394, -25462,
	-25114, -19422, -9599, 2266, 13649, 22129, 25901, 24162,
	17284, 6729, -5257, -16126, -23564, -25988, -22885, -14912,
	-3768, 8178, 18384, 24680, 25725, 21297, 12339, 755,
	-10988, -20394, -25462, -25114, -19422, -9599, 2266, 13649,
	22129, 25901, 24162, 17284, 6729, -5257, -16126, -23564,
	-25988, -22885, -14912, -3767, 8178, 18384, 24680, 25725,
	21297, 12339, 755, -10988, -20394, -25462, -25114, -19422,
	-9599, 2266, 13649, 22129, 25901, 24162, 17284, 6729,
	-5257, -16126, -23564, -25988, -22885, -14912, -3767, 8178},
	{
// Carrier 10 Phase 2
	26000, 23234, 15526, 4514, -7456, -17842, -24432, -25824,
	-21722, -12999, -1511, 10298, 19917, 25299, 25299, 19917,
	10298, -1511, -13000, -21722, -25824, -24432, -17842, -7456,
	4514, 15526, 23234, 26000, 23234, 15526, 4514, -7456,
	-17842, -24432, -25824, -21722, -12999, -1511, 10298, 19917,
	25299, 25299, 19917, 10298, -1511, -13000, -21722, -25824,
	-24431, -17842, -7456, 4514, 15526, 23234, 26000, 23234,
	15526, 4514, -7456, -17842, -24432, -25824, -21722, -12999,
	-1511, 10298, 19917, 25299, 25299, 19917, 10297, -1511,
	-13000, -21722, -25824, -24431, -17842, -7456, 4514, 15526,
	23234, 26000, 23234, 15526, 4514, -7456, -17842, -24432,
	-25824, -21722, -12999, -1511, 10298, 19917, 25299, 25299,
	19917, 10297, -1511, -13000, -21722, -25824, -24431, -17842,
	-7456, 4514, 15526, 23234, 26000, 23234, 15526, 4514,
	-7457, -17842, -24432, -25824, -21722, -12999, -1511, 10298,
	19917, 25299, 25299, 19917, 10297, -1511, -13000, -21722,
	-25824, -24431, -17842, -7456, 4515, 15526, 23234, 26000,
	23234, 15525, 4514, -7457, -17842, -24432, -25824, -21722,
	-12999, -1511, 10298, 19917, 25299, 25299, 19917, 10297,
	-1511, -13000, -21722, -25824, -24431, -17842, -7456, 4515,
	15526, 23234, 26000, 23234, 15525, 4514, -7457, -17842,
	-24432, -25824, -21722, -12999, -1511, 10298, 19917, 25299,
	25299, 19917, 10297, -1512, -13000, -21722, -25824, -24431,
	-17842, -7456, 4515, 15526, 23234, 26000, 23234, 15525,
	4514, -7457, -17842, -24432, -25824, -21722, -12999, -1511,
	10298, 19917, 25299, 25299, 19916, 10297, -1512, -13000,
	-21722, -25824, -24431, -17842, -7456, 4515, 15526, 23234},
	{
// Carrier 10 Phase 3
	18384, 8178, -3768, -14912, -22885, -25989, -23563, -16126,
	-5257, 6729, 17284, 24163, 25901, 22129, 13649, 2266,
	-9599, -19422, -25114, -25462, -20394, -10988, 756, 12339,
	21297, 25725, 24680, 18384, 8178, -3768, -14913, -22885,
	-25989, -23563, -16126, -5257, 6729, 17284, 24163, 25901,
	22129, 13649, 2265, -9599, -19422, -25114, -25462, -20394,
	-10988, 756, 12339, 21297, 25725, 24680, 18384, 8178,
	-3768, -14913, -22885, -25989, -23563, -16126, -5257, 6729,
	17284, 24163, 25901, 22128, 13649, 2265, -9599, -19422,
	-25114, -25462, -20394, -10987, 756, 12339, 21298, 25725,
	24680, 18384, 8178, -3768, -14913, -22885, -25989, -23563,
	-16126, -5257, 6729, 17284, 24163, 25901, 22128, 13649,
	2265, -9599, -19422, -25114, -25462, -20394, -10987, 756,
	12339, 21298, 25725, 24680, 18384, 8178, -3768, -14913,
	-22885, -25989, -23563, -16125, -5257, 6729, 17284, 24163,
	25901, 22128, 13649, 2265, -9599, -19422, -25114, -25462,
	-20394, -10987, 756, 12339, 21298, 25725, 24680, 18384,
	8177, -3768, -14913, -22885, -25989, -23563, -16125, -5257,
	6729, 17284, 24163, 25901, 22128, 13649, 2265, -9599,
	-19422, -25114, -25462, -20394, -10987, 756, 12339, 21298,
	25725, 24680, 18384, 8177, -3768, -14913, -22885, -25989,
	-23563, -16125, -5257, 6729, 17284, 24163, 25901, 22128,
	13649, 2265, -9599, -19422, -25114, -25462, -20394, -10987,
	756, 12339, 21298, 25725, 24680, 18384, 8177, -3768,
	-14913, -22885, -25989, -23563, -16125, -5257, 6729, 17284,
	24163, 25901, 22128, 13649, 2265, -9599, -19422, -25114,
	-25462, -20394, -10987, 756, 12339, 21298, 25725, 24680},
	},{{

// Carrier 11 Phase 0
	0, 12339, 21722, 25901, 23873, 16126, 4514, -8178,
	-18911, -25114, -25299, -19422, -8892, 3768, 15526, 23563,
	25956, 22129, 13000, 756, -11668, -21297, -25824, -24163,
	-16712, -5257, 7456, 18384, 24907, 25462, 19917, 9599,
	-3018, -14912, -23234, -25989, -22516, -13649, -1511, 10987,
	20855, 25725, 24432, 17284, 5996, -6729, -17842, -24680,
	-25605, -20394, -10298, 2265, 14287, 22885, 26000, 22885,
	14287, 2266, -10297, -20394, -25604, -24680, -17842, -6729,
	5995, 17284, 24431, 25725, 20855, 10988, -1511, -13649,
	-22516, -25988, -23234, -14913, -3018, 9599, 19917, 25462,
	24907, 18384, 7457, -5257, -16712, -24162, -25824, -21298,
	-11668, 756, 12999, 22128, 25956, 23564, 15526, 3768,
	-8892, -19422, -25299, -25114, -18911, -8178, 4514, 16125,
	23873, 25901, 21722, 12339, 0, -12339, -21722, -25901,
	-23873, -16126, -4515, 8177, 18911, 25114, 25299, 19422,
	8892, -3767, -15525, -23563, -25956, -22129, -13000, -756,
	11668, 21297, 25824, 24163, 16712, 5257, -7456, -18384,
	-24907, -25462, -19917, -9599, 3018, 14912, 23234, 25989,
	22516, 13649, 1512, -10987, -20855, -25725, -24432, -17284,
	-5996, 6728, 17842, 24680, 25605, 20395, 10298, -2265,
	-14286, -22885, -26000, -22885, -14287, -2266, 10297, 20394,
	25604, 24680, 17842, 6729, -5995, -17284, -24431, -25725,
	-20855, -10988, 1511, 13649, 22516, 25988, 23234, 14913,
	3018, -9598, -19916, -25462, -24907, -18385, -7457, 5257,
	16712, 24162, 25824, 21298, 11669, -755, -12999, -22128,
	-25955, -23564, -15526, -3768, 8892, 19422, 25299, 25114,
	18912, 8178, -4514, -16125, -23873, -25901, -21722, -12340},
	{
// Carrier 11 Phase 1
	18384, 24907, 25462, 19917, 9599, -3018, -14912, -23234,
	-25989, -22516, -13649, -1511, 10988, 20855, 25725, 24432,
	17284, 5996, -6729, -17842, -24680, -25605, -20394, -10298,
	2266, 14287, 22885, 26000, 22885, 14287, 2266, -10298,
	-20394, -25604, -24680, -17842, -6729, 5995, 17284, 24431,
	25725, 20855, 10988, -1511, -13649, -22516, -25988, -23234,
	-14913, -3018, 9599, 19917, 25462, 24907, 18384, 7456,
	-5257, -16712, -24162, -25824, -21298, -11668, 756, 12999,
	22128, 25956, 23564, 15526, 3768, -8892, -19422, -25299,
	-25114, -18911, -8178, 4514, 16126, 23873, 25901, 21722,
	12339, 0, -12339, -21722, -25901, -23873, -16126, -4515,
	8177, 18911, 25114, 25299, 19422, 8892, -3768, -15525,
	-23563, -25956, -22129, -13000, -756, 11668, 21297, 25824,
	24163, 16712, 5257, -7456, -18384, -24907, -25462, -19917,
	-9599, 3018, 14912, 23234, 25989, 22516, 13649, 1512,
	-10987, -20855, -25725, -24432, -17284, -5996, 6729, 17842,
	24680, 25605, 20394, 10298, -2265, -14287, -22885, -26000,
	-22885, -14287, -2266, 10297, 20394, 25604, 24680, 17842,
	6729, -5995, -17284, -24431, -25725, -20855, -10988, 1511,
	13649, 22516, 25988, 23234, 14913, 3018, -9599, -19916,
	-25462, -24907, -18385, -7457, 5257, 16712, 24162, 25824,
	21298, 11669, -755, -12999, -22128, -25955, -23564, -15526,
	-3768, 8892, 19422, 25299, 25114, 18911, 8178, -4514,
	-16125, -23873, -25901, -21722, -12339, 0, 12339, 21722,
	25901, 23873, 16126, 4515, -8177, -18911, -25113, -25299,
	-19422, -8892, 3767, 15525, 23563, 25956, 22129, 13000,
	756, -11668, -21297, -25824, -24163, -16712, -5258, 7456},
	{
// Carrier 11 Phase 2
	26000, 22885, 14287, 2266, -10298, -20394, -25605, -24680,
	-17842, -6729, 5995, 17284, 24432, 25725, 20855, 10988,
	-1511, -13649, -22516, -25989, -23234, -14913, -3018, 9599,
	19917, 25462, 24907, 18384, 7456, -5257, -16712, -24163,
	-25824, -21297, -11668, 756, 12999, 22128, 25956, 23564,
	15526, 3768, -8892, -19422, -25299, -25114, -18911, -8178,
	4514, 16126, 23873, 25901, 21722, 12339, 0, -12339,
	-21722, -25901, -23873, -16126, -4514, 8178, 18911, 25114,
	25299, 19422, 8892, -3768, -15526, -23563, -25956, -22129,
	-13000, -756, 11668, 21297, 25824, 24163, 16712, 5257,
	-7456, -18384, -24907, -25462, -19917, -9599, 3018, 14912,
	23234, 25989, 22516, 13649, 1511, -10987, -20855, -25725,
	-24432, -17284, -5996, 6729, 17842, 24680, 25605, 20394,
	10298, -2265, -14287, -22885, -26000, -22885, -14287, -2266,
	10297, 20394, 25604, 24680, 17842, 6729, -5995, -17284,
	-24431, -25725, -20855, -10988, 1511, 13649, 22516, 25988,
	23234, 14913, 3018, -9599, -19916, -25462, -24907, -18384,
	-7457, 5257, 16712, 24162, 25824, 21298, 11669, -755,
	-12999, -22128, -25955, -23564, -15526, -3768, 8892, 19422,
	25299, 25114, 18911, 8178, -4514, -16125, -23873, -25901,
	-21722, -12339, 0, 12339, 21722, 25901, 23873, 16126,
	4515, -8177, -18911, -25113, -25299, -19422, -8892, 3767,
	15525, 23563, 25956, 22129, 13000, 756, -11668, -21297,
	-25824, -24163, -16712, -5258, 7456, 18384, 24907, 25462,
	19917, 9599, -3018, -14912, -23234, -25989, -22516, -13649,
	-1512, 10987, 20854, 25725, 24432, 17285, 5996, -6728,
	-17841, -24680, -25605, -20395, -10298, 2265, 14286, 22885},
	{
// Carrier 11 Phase 3
	18384, 7456, -5257, -16712, -24163, -25824, -21297, -11668,
	756, 12999, 22129, 25956, 23564, 15526, 3768, -8892,
	-19422, -25299, -25114, -18911, -8178, 4514, 16126, 23873,
	25901, 21722, 12339, 0, -12339, -21722, -25901, -23873,
	-16126, -4514, 8178, 18911, 25114, 25299, 19422, 8892,
	-3768, -15526, -23563, -25956, -22129, -13000, -756, 11668,
	21297, 25824, 24163, 16712, 5257, -7456, -18384, -24907,
	-25462, -19917, -9599, 3018, 14912, 23234, 25989, 22516,
	13649, 1511, -10987, -20855, -25725, -24432, -17284, -5996,
	6729, 17842, 24680, 25605, 20394, 10298, -2265, -14287,
	-22885, -26000, -22885, -14287, -2266, 10297, 20394, 25604,
	24680, 17842, 6729, -5995, -17284, -24431, -25725, -20855,
	-10988, 1511, 13649, 22516, 25988, 23234, 14913, 3018,
	-9599, -19917, -25462, -24907, -18384, -7457, 5257, 16712,
	24162, 25824, 21298, 11668, -755, -12999, -22128, -25955,
	-23564, -15526, -3768, 8892, 19422, 25299, 25114, 18911,
	8178, -4514, -16125, -23873, -25901, -21722, -12339, 0,
	12339, 21722, 25901, 23873, 16126, 4515, -8177, -18911,
	-25113, -25299, -19422, -8892, 3767, 15525, 23563, 25956,
	22129, 13000, 756, -11668, -21297, -25824, -24163, -16712,
	-5258, 7456, 18384, 24907, 25462, 19917, 9599, -3018,
	-14912, -23234, -25989, -22516, -13649, -1512, 10987, 20854,
	25725, 24432, 17284, 5996, -6728, -17841, -24680, -25605,
	-20395, -10298, 2265, 14286, 22885, 26000, 22885, 14287,
	2266, -10297, -20394, -25604, -24680, -17842, -6729, 5995,
	17284, 24431, 25725, 20855, 10988, -1511, -13649, -22516,
	-25988, -23234, -14913, -3018, 9598, 19916, 25462, 24907},
	},{{

// Carrier 12 Phase 0
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000,
	0, 12999, 22516, 26000, 22516, 13000, 0, -12999,
	-22516, -26000, -22516, -13000, 0, 12999, 22516, 26000,
	22516, 13000, 0, -12999, -22516, -26000, -22516, -13000},
	{
// Carrier 12 Phase 1
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729,
	18384, 25114, 25114, 18384, 6729, -6729, -18384, -25114,
	-25114, -18384, -6729, 6729, 18384, 25114, 25114, 18384,
	6729, -6729, -18384, -25114, -25114, -18384, -6729, 6729},
	{
// Carrier 12 Phase 2
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516,
	26000, 22516, 13000, 0, -12999, -22516, -26000, -22516,
	-13000, 0, 12999, 22516, 26000, 22516, 13000, 0,
	-12999, -22516, -26000, -22516, -13000, 0, 12999, 22516},
	{
// Carrier 12 Phase 3
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114,
	18384, 6729, -6729, -18384, -25114, -25114, -18384, -6729,
	6729, 18384, 25114, 25114, 18384, 6729, -6729, -18384,
	-25114, -25114, -18384, -6729, 6729, 18384, 25114, 25114},
	},{{

// Carrier 13 Phase 0
	0, 13649, 23234, 25901, 20855, 9599, -4514, -17284,
	-24907, -25114, -17842, -5257, 8892, 20394, 25824, 23563,
	14287, 756, -13000, -22885, -25956, -21297, -10298, 3768,
	16712, 24680, 25299, 18384, 5995, -8178, -19917, -25725,
	-23873, -14912, -1511, 12339, 22516, 25989, 21722, 10988,
	-3018, -16126, -24432, -25462, -18911, -6729, 7456, 19422,
	25605, 24163, 15526, 2265, -11668, -22129, -26000, -22129,
	-11668, 2266, 15526, 24163, 25604, 19422, 7456, -6729,
	-18911, -25462, -24431, -16126, -3018, 10988, 21722, 25989,
	22516, 12339, -1511, -14913, -23873, -25725, -19917, -8178,
	5996, 18384, 25299, 24680, 16712, 3768, -10298, -21297,
	-25956, -22885, -12999, 756, 14287, 23564, 25824, 20394,
	8892, -5257, -17842, -25114, -24907, -17284, -4514, 9599,
	20855, 25901, 23234, 13649, 0, -13649, -23234, -25901,
	-20855, -9599, 4514, 17284, 24907, 25114, 17842, 5257,
	-8892, -20394, -25824, -23563, -14287, -756, 13000, 22885,
	25956, 21297, 10297, -3768, -16712, -24680, -25299, -18384,
	-5995, 8178, 19917, 25725, 23873, 14912, 1511, -12339,
	-22516, -25988, -21722, -10987, 3018, 16126, 24432, 25462,
	18911, 6729, -7457, -19422, -25605, -24162, -15526, -2265,
	11668, 22129, 26000, 22128, 11668, -2266, -15526, -24163,
	-25604, -19422, -7456, 6729, 18911, 25462, 24431, 16125,
	3018, -10988, -21722, -25989, -22516, -12339, 1511, 14913,
	23873, 25725, 19917, 8177, -5996, -18384, -25299, -24680,
	-16712, -3768, 10298, 21298, 25956, 22885, 12999, -756,
	-14287, -23564, -25824, -20394, -8892, 5257, 17842, 25114,
	24907, 17284, 4514, -9599, -20855, -25901, -23234, -13649},
	{
// Carrier 13 Phase 1
	18384, 25299, 24680, 16712, 3768, -10298, -21297, -25956,
	-22885, -12999, 756, 14287, 23564, 25824, 20394, 8892,
	-5257, -17842, -25114, -24907, -17284, -4514, 9599, 20855,
	25901, 23234, 13649, 0, -13649, -23234, -25901, -20855,
	-9599, 4514, 17284, 24907, 25114, 17842, 5257, -8892,
	-20394, -25824, -23563, -14287, -756, 13000, 22885, 25956,
	21297, 10298, -3768, -16712, -24680, -25299, -18384, -5995,
	8178, 19917, 25725, 23873, 14912, 1511, -12339, -22516,
	-25988, -21722, -10988, 3018, 16126, 24432, 25462, 18911,
	6729, -7456, -19422, -25605, -24163, -15526, -2265, 11668,
	22129, 26000, 22128, 11668, -2266, -15526, -24163, -25604,
	-19422, -7456, 6729, 18911, 25462, 24431, 16126, 3018,
	-10988, -21722, -25989, -22516, -12339, 1511, 14913, 23873,
	25725, 19917, 8178, -5996, -18384, -25299, -24680, -16712,
	-3768, 10298, 21298, 25956, 22885, 12999, -756, -14287,
	-23564, -25824, -20394, -8892, 5257, 17842, 25114, 24907,
	17284, 4514, -9599, -20855, -25901, -23234, -13649, 0,
	13649, 23234, 25901, 20855, 9599, -4515, -17284, -24907,
	-25114, -17842, -5257, 8892, 20394, 25824, 23563, 14287,
	756, -13000, -22885, -25956, -21297, -10297, 3768, 16712,
	24680, 25299, 18384, 5995, -8178, -19917, -25725, -23873,
	-14912, -1511, 12339, 22516, 25988, 21722, 10987, -3018,
	-16126, -24432, -25462, -18911, -6729, 7457, 19422, 25605,
	24162, 15525, 2265, -11668, -22129, -26000, -22128, -11668,
	2266, 15526, 24163, 25604, 19422, 7456, -6729, -18911,
	-25462, -24431, -16125, -3018, 10988, 21722, 25989, 22516,
	12339, -1511, -14913, -23873, -25725, -19917, -8177, 5996},
	{
// Carrier 13 Phase 2
	26000, 22129, 11668, -2266, -15526, -24163, -25605, -19422,
	-7456, 6729, 18911, 25462, 24432, 16126, 3018, -10988,
	-21722, -25989, -22516, -12339, 1511, 14913, 23873, 25725,
	19917, 8178, -5996, -18384, -25299, -24680, -16712, -3768,
	10298, 21297, 25956, 22885, 12999, -756, -14287, -23564,
	-25824, -20394, -8892, 5257, 17842, 25114, 24907, 17284,
	4514, -9599, -20855, -25901, -23234, -13649, 0, 13649,
	23234, 25901, 20855, 9599, -4514, -17284, -24907, -25114,
	-17842, -5257, 8892, 20394, 25824, 23563, 14287, 756,
	-13000, -22885, -25956, -21297, -10298, 3768, 16712, 24680,
	25299, 18384, 5995, -8178, -19917, -25725, -23873, -14912,
	-1511, 12339, 22516, 25988, 21722, 10987, -3018, -16126,
	-24432, -25462, -18911, -6729, 7456, 19422, 25605, 24162,
	15526, 2265, -11668, -22129, -26000, -22128, -11668, 2266,
	15526, 24163, 25604, 19422, 7456, -6729, -18911, -25462,
	-24431, -16126, -3018, 10988, 21722, 25989, 22516, 12339,
	-1511, -14913, -23873, -25725, -19917, -8178, 5996, 18384,
	25299, 24680, 16712, 3768, -10298, -21298, -25956, -22885,
	-12999, 756, 14287, 23564, 25824, 20394, 8892, -5257,
	-17842, -25114, -24907, -17284, -4514, 9599, 20855, 25901,
	23234, 13649, 0, -13649, -23234, -25901, -20855, -9599,
	4515, 17284, 24907, 25114, 17842, 5257, -8892, -20394,
	-25824, -23563, -14287, -756, 13000, 22885, 25956, 21297,
	10297, -3768, -16712, -24680, -25299, -18384, -5995, 8178,
	19917, 25725, 23873, 14912, 1511, -12339, -22516, -25988,
	-21722, -10987, 3018, 16126, 24432, 25462, 18911, 6729,
	-7457, -19422, -25605, -24162, -15525, -2265, 11668, 22129},
	{
// Carrier 13 Phase 3
	18384, 5996, -8178, -19917, -25725, -23873, -14912, -1511,
	12339, 22516, 25989, 21722, 10988, -3018, -16126, -24432,
	-25462, -18911, -6729, 7456, 19422, 25605, 24163, 15526,
	2266, -11668, -22129, -26000, -22129, -11668, 2266, 15526,
	24163, 25604, 19422, 7456, -6729, -18911, -25462, -24431,
	-16126, -3018, 10988, 21722, 25989, 22516, 12339, -1511,
	-14913, -23873, -25725, -19917, -8178, 5996, 18384, 25299,
	24680, 16712, 3768, -10298, -21297, -25956, -22885, -12999,
	756, 14287, 23564, 25824, 20394, 8892, -5257, -17842,
	-25114, -24907, -17284, -4514, 9599, 20855, 25901, 23234,
	13649, 0, -13649, -23234, -25901, -20855, -9599, 4514,
	17284, 24907, 25114, 17842, 5257, -8892, -20394, -25824,
	-23563, -14287, -756, 13000, 22885, 25956, 21297, 10297,
	-3768, -16712, -24680, -25299, -18384, -5995, 8178, 19917,
	25725, 23873, 14912, 1511, -12339, -22516, -25988, -21722,
	-10987, 3018, 16126, 24432, 25462, 18911, 6729, -7457,
	-19422, -25605, -24162, -15526, -2265, 11668, 22129, 26000,
	22128, 11668, -2266, -15526, -24163, -25604, -19422, -7456,
	6729, 18911, 25462, 24431, 16125, 3018, -10988, -21722,
	-25989, -22516, -12339, 1511, 14913, 23873, 25725, 19917,
	8177, -5996, -18384, -25299, -24680, -16712, -3768, 10298,
	21298, 25956, 22885, 12999, -756, -14287, -23564, -25824,
	-20394, -8892, 5257, 17842, 25114, 24907, 17284, 4514,
	-9599, -20855, -25901, -23234, -13649, 0, 13649, 23234,
	25901, 20855, 9599, -4515, -17284, -24907, -25114, -17842,
	-5257, 8892, 20394, 25824, 23563, 14287, 755, -13000,
	-22885, -25955, -21297, -10297, 3768, 16712, 24680, 25299},
	},{{

// Carrier 14 Phase 0
	0, 14287, 23873, 25605, 18911, 5996, -8892, -20855,
	-25956, -22516, -11668, 3018, 16712, 24907, 24907, 16712,
	3018, -11668, -22516, -25956, -20855, -8892, 5996, 18911,
	25605, 23873, 14287, 0, -14287, -23873, -25604, -18911,
	-5995, 8892, 20855, 25956, 22516, 11668, -3018, -16712,
	-24907, -24907, -16712, -3018, 11668, 22516, 25956, 20855,
	8892, -5996, -18911, -25605, -23873, -14287, 0, 14287,
	23873, 25604, 18911, 5995, -8892, -20855, -25956, -22516,
	-11668, 3018, 16712, 24907, 24907, 16712, 3018, -11668,
	-22516, -25956, -20855, -8892, 5996, 18911, 25605, 23873,
	14287, 0, -14287, -23873, -25604, -18911, -5995, 8892,
	20855, 25956, 22516, 11668, -3018, -16712, -24907, -24907,
	-16712, -3018, 11668, 22516, 25956, 20855, 8892, -5996,
	-18911, -25605, -23873, -14287, 0, 14287, 23873, 25604,
	18911, 5995, -8892, -20855, -25956, -22516, -11668, 3018,
	16712, 24907, 24907, 16712, 3018, -11668, -22516, -25956,
	-20855, -8892, 5996, 18911, 25605, 23873, 14287, 0,
	-14287, -23873, -25604, -18911, -5995, 8892, 20855, 25956,
	22516, 11668, -3018, -16712, -24907, -24907, -16712, -3018,
	11668, 22516, 25956, 20855, 8892, -5996, -18911, -25605,
	-23873, -14287, 0, 14287, 23873, 25604, 18911, 5995,
	-8892, -20855, -25956, -22516, -11668, 3018, 16712, 24907,
	24907, 16712, 3018, -11668, -22516, -25955, -20855, -8892,
	5996, 18911, 25605, 23873, 14287, 0, -14287, -23873,
	-25604, -18911, -5995, 8892, 20855, 25956, 22516, 11668,
	-3018, -16712, -24907, -24907, -16712, -3018, 11669, 22516,
	25955, 20855, 8892, -5996, -18911, -25605, -23873, -14286},
	{
// Carrier 14 Phase 1
	18384, 25462, 24163, 14912, 756, -13649, -23563, -25725,
	-19422, -6729, 8178, 20394, 25901, 22885, 12339, -2266,
	-16126, -24680, -25114, -17284, -3768, 10988, 22129, 25989,
	21297, 9599, -5257, -18384, -25462, -24163, -14912, -756,
	13649, 23564, 25725, 19422, 6729, -8178, -20394, -25901,
	-22885, -12339, 2266, 16126, 24680, 25114, 17284, 3768,
	-10988, -22129, -25988, -21297, -9599, 5257, 18384, 25462,
	24163, 14912, 756, -13649, -23564, -25725, -19422, -6729,
	8178, 20394, 25901, 22885, 12339, -2266, -16126, -24680,
	-25114, -17284, -3768, 10988, 22129, 25988, 21297, 9599,
	-5257, -18384, -25462, -24162, -14912, -756, 13649, 23564,
	25725, 19422, 6729, -8178, -20394, -25901, -22885, -12339,
	2266, 16126, 24680, 25114, 17284, 3768, -10988, -22129,
	-25988, -21297, -9599, 5257, 18384, 25462, 24162, 14912,
	756, -13649, -23564, -25725, -19422, -6729, 8178, 20394,
	25901, 22885, 12339, -2266, -16126, -24680, -25114, -17284,
	-3768, 10988, 22129, 25988, 21297, 9599, -5257, -18384,
	-25462, -24162, -14912, -756, 13649, 23564, 25725, 19422,
	6729, -8178, -20394, -25901, -22885, -12339, 2266, 16126,
	24680, 25114, 17284, 3768, -10988, -22129, -25988, -21297,
	-9599, 5257, 18384, 25462, 24162, 14912, 755, -13649,
	-23564, -25725, -19422, -6729, 8178, 20394, 25901, 22885,
	12339, -2266, -16126, -24680, -25114, -17284, -3767, 10988,
	22129, 25988, 21297, 9599, -5257, -18384, -25462, -24162,
	-14912, -755, 13649, 23564, 25725, 19422, 6729, -8178,
	-20394, -25901, -22885, -12339, 2266, 16126, 24680, 25113,
	17284, 3767, -10988, -22129, -25988, -21297, -9599, 5257},
	{
// Carrier 14 Phase 2
	26000, 21722, 10298, -4514, -17842, -25299, -24432, -15526,
	-1511, 13000, 23234, 25824, 19917, 7456, -7456, -19917,
	-25824, -23234, -12999, 1511, 15526, 24432, 25299, 17842,
	4514, -10298, -21722, -26000, -21722, -10298, 4514, 17842,
	25299, 24431, 15526, 1511, -13000, -23234, -25824, -19917,
	-7456, 7456, 19917, 25824, 23234, 12999, -1511, -15526,
	-24432, -25299, -17842, -4514, 10298, 21722, 26000, 21722,
	10298, -4514, -17842, -25299, -24431, -15526, -1511, 13000,
	23234, 25824, 19917, 7456, -7456, -19917, -25824, -23234,
	-12999, 1511, 15526, 24432, 25299, 17842, 4514, -10298,
	-21722, -26000, -21722, -10297, 4514, 17842, 25299, 24431,
	15526, 1511, -13000, -23234, -25824, -19917, -7456, 7457,
	19917, 25824, 23234, 12999, -1511, -15526, -24432, -25299,
	-17842, -4514, 10298, 21722, 26000, 21722, 10297, -4515,
	-17842, -25299, -24431, -15526, -1511, 13000, 23234, 25824,
	19917, 7456, -7457, -19917, -25824, -23234, -12999, 1511,
	15526, 24432, 25299, 17842, 4514, -10298, -21722, -26000,
	-21722, -10297, 4515, 17842, 25299, 24431, 15525, 1511,
	-13000, -23234, -25824, -19917, -7456, 7457, 19917, 25824,
	23234, 12999, -1511, -15526, -24432, -25299, -17842, -4514,
	10298, 21722, 26000, 21722, 10297, -4515, -17842, -25299,
	-24431, -15525, -1511, 13000, 23234, 25824, 19917, 7456,
	-7457, -19917, -25824, -23234, -12999, 1512, 15526, 24432,
	25299, 17842, 4514, -10298, -21722, -26000, -21722, -10297,
	4515, 17842, 25299, 24431, 15525, 1511, -13000, -23234,
	-25824, -19916, -7456, 7457, 19917, 25824, 23234, 12999,
	-1512, -15526, -24432, -25299, -17842, -4514, 10298, 21722},
	{
// Carrier 14 Phase 3
	18384, 5257, -9599, -21297, -25989, -22129, -10988, 3768,
	17284, 25114, 24680, 16126, 2266, -12339, -22885, -25901,
	-20394, -8178, 6729, 19422, 25725, 23563, 13649, -756,
	-14913, -24163, -25462, -18384, -5257, 9599, 21297, 25989,
	22129, 10988, -3768, -17284, -25114, -24680, -16126, -2265,
	12339, 22885, 25901, 20394, 8178, -6729, -19422, -25725,
	-23563, -13649, 756, 14913, 24163, 25462, 18384, 5257,
	-9599, -21297, -25989, -22128, -10988, 3768, 17284, 25114,
	24680, 16126, 2265, -12339, -22885, -25901, -20394, -8178,
	6729, 19422, 25725, 23563, 13649, -756, -14913, -24163,
	-25462, -18384, -5257, 9599, 21298, 25989, 22128, 10987,
	-3768, -17284, -25114, -24680, -16126, -2265, 12339, 22885,
	25901, 20394, 8178, -6729, -19422, -25725, -23563, -13649,
	756, 14913, 24163, 25462, 18384, 5257, -9599, -21298,
	-25989, -22128, -10987, 3768, 17284, 25114, 24680, 16125,
	2265, -12339, -22885, -25901, -20394, -8178, 6729, 19422,
	25725, 23563, 13649, -756, -14913, -24163, -25462, -18384,
	-5257, 9599, 21298, 25989, 22128, 10987, -3768, -17284,
	-25114, -24680, -16125, -2265, 12339, 22885, 25901, 20394,
	8177, -6729, -19422, -25725, -23563, -13649, 756, 14913,
	24163, 25462, 18384, 5257, -9599, -21298, -25989, -22128,
	-10987, 3768, 17284, 25114, 24680, 16125, 2265, -12339,
	-22885, -25901, -20394, -8177, 6729, 19422, 25725, 23563,
	13649, -756, -14913, -24163, -25462, -18384, -5257, 9599,
	21298, 25989, 22128, 10987, -3768, -17284, -25114, -24680,
	-16125, -2265, 12339, 22885, 25901, 20394, 8177, -6729,
	-19422, -25725, -23563, -13649, 756, 14913, 24163, 25462},
	},{{

// Carrier 15 Phase 0
	0, 14912, 24432, 25114, 16712, 2266, -12999, -23563,
	-25605, -18384, -4514, 10988, 22516, 25901, 19917, 6729,
	-8892, -21297, -26000, -21297, -8892, 6729, 19917, 25901,
	22516, 10988, -4514, -18384, -25604, -23564, -13000, 2265,
	16712, 25114, 24432, 14913, 0, -14912, -24431, -25114,
	-16712, -2266, 12999, 23563, 25605, 18384, 4514, -10988,
	-22516, -25901, -19917, -6729, 8892, 21297, 26000, 21298,
	8892, -6729, -19917, -25901, -22516, -10988, 4514, 18384,
	25604, 23564, 13000, -2265, -16712, -25114, -24432, -14913,
	0, 14912, 24431, 25114, 16712, 2266, -12999, -23563,
	-25605, -18384, -4514, 10987, 22516, 25901, 19917, 6729,
	-8892, -21297, -26000, -21298, -8892, 6729, 19917, 25901,
	22516, 10988, -4514, -18384, -25604, -23564, -13000, 2265,
	16712, 25114, 24432, 14913, 0, -14912, -24431, -25114,
	-16712, -2266, 12999, 23563, 25605, 18384, 4515, -10987,
	-22516, -25901, -19917, -6729, 8892, 21297, 26000, 21298,
	8892, -6729, -19917, -25901, -22516, -10988, 4514, 18384,
	25604, 23564, 13000, -2265, -16712, -25114, -24432, -14913,
	0, 14912, 24431, 25114, 16712, 2266, -12999, -23563,
	-25605, -18384, -4515, 10987, 22516, 25901, 19917, 6729,
	-8892, -21297, -26000, -21298, -8892, 6729, 19916, 25901,
	22516, 10988, -4514, -18384, -25604, -23564, -13000, 2265,
	16712, 25113, 24432, 14913, 0, -14912, -24431, -25114,
	-16712, -2266, 12999, 23563, 25605, 18385, 4515, -10987,
	-22516, -25901, -19917, -6729, 8892, 21297, 26000, 21298,
	8892, -6728, -19916, -25901, -22516, -10988, 4514, 18384,
	25604, 23564, 13000, -2265, -16712, -25113, -24432, -14913},
	{
// Carrier 15 Phase 1
	18384, 25605, 23564, 13000, -2266, -16712, -25114, -24432,
	-14913, 0, 14912, 24432, 25114, 16712, 2266, -12999,
	-23563, -25605, -18384, -4514, 10988, 22516, 25901, 19917,
	6729, -8892, -21297, -26000, -21297, -8892, 6729, 19917,
	25901, 22516, 10988, -4514, -18384, -25604, -23564, -13000,
	2265, 16712, 25114, 24432, 14913, 0, -14912, -24431,
	-25114, -16712, -2266, 12999, 23563, 25605, 18384, 4514,
	-10987, -22516, -25901, -19917, -6729, 8892, 21297, 26000,
	21298, 8892, -6729, -19917, -25901, -22516, -10988, 4514,
	18384, 25604, 23564, 13000, -2265, -16712, -25114, -24432,
	-14913, 0, 14912, 24431, 25114, 16712, 2266, -12999,
	-23563, -25605, -18384, -4515, 10987, 22516, 25901, 19917,
	6729, -8892, -21297, -26000, -21298, -8892, 6729, 19917,
	25901, 22516, 10988, -4514, -18384, -25604, -23564, -13000,
	2265, 16712, 25114, 24432, 14913, 0, -14912, -24431,
	-25114, -16712, -2266, 12999, 23563, 25605, 18384, 4515,
	-10987, -22516, -25901, -19917, -6729, 8892, 21297, 26000,
	21298, 8892, -6729, -19916, -25901, -22516, -10988, 4514,
	18384, 25604, 23564, 13000, -2265, -16712, -25114, -24432,
	-14913, 0, 14912, 24431, 25114, 16712, 2266, -12999,
	-23563, -25605, -18384, -4515, 10987, 22516, 25901, 19917,
	6729, -8892, -21297, -26000, -21298, -8892, 6728, 19916,
	25901, 22516, 10988, -4514, -18384, -25604, -23564, -13000,
	2265, 16712, 25113, 24432, 14913, 0, -14912, -24431,
	-25114, -16712, -2266, 12999, 23563, 25605, 18385, 4515,
	-10987, -22516, -25901, -19917, -6729, 8892, 21297, 26000,
	21298, 8892, -6728, -19916, -25901, -22516, -10988, 4514},
	{
// Carrier 15 Phase 2
	26000, 21297, 8892, -6729, -19917, -25901, -22516, -10988,
	4514, 18384, 25604, 23564, 13000, -2266, -16712, -25114,
	-24432, -14913, 0, 14912, 24431, 25114, 16712, 2266,
	-12999, -23563, -25605, -18384, -4514, 10988, 22516, 25901,
	19917, 6729, -8892, -21297, -26000, -21297, -8892, 6729,
	19917, 25901, 22516, 10988, -4514, -18384, -25604, -23564,
	-13000, 2265, 16712, 25114, 24432, 14913, 0, -14912,
	-24431, -25114, -16712, -2266, 12999, 23563, 25605, 18384,
	4514, -10987, -22516, -25901, -19917, -6729, 8892, 21297,
	26000, 21298, 8892, -6729, -19917, -25901, -22516, -10988,
	4514, 18384, 25604, 23564, 13000, -2265, -16712, -25114,
	-24432, -14913, 0, 14912, 24431, 25114, 16712, 2266,
	-12999, -23563, -25605, -18384, -4515, 10987, 22516, 25901,
	19917, 6729, -8892, -21297, -26000, -21298, -8892, 6729,
	19917, 25901, 22516, 10988, -4514, -18384, -25604, -23564,
	-13000, 2265, 16712, 25114, 24432, 14913, 0, -14912,
	-24431, -25114, -16712, -2266, 12999, 23563, 25605, 18384,
	4515, -10987, -22516, -25901, -19917, -6729, 8892, 21297,
	26000, 21298, 8892, -6729, -19916, -25901, -22516, -10988,
	4514, 18384, 25604, 23564, 13000, -2265, -16712, -25114,
	-24432, -14913, 0, 14912, 24431, 25114, 16712, 2266,
	-12999, -23563, -25605, -18384, -4515, 10987, 22516, 25901,
	19917, 6729, -8892, -21297, -26000, -21298, -8892, 6728,
	19916, 25901, 22516, 10988, -4514, -18384, -25604, -23564,
	-13000, 2265, 16712, 25113, 24432, 14913, 0, -14912,
	-24431, -25114, -16712, -2266, 12999, 23563, 25605, 18385,
	4515, -10987, -22516, -25901, -19917, -6729, 8892, 21297},
	{
// Carrier 15 Phase 3
	18384, 4514, -10988, -22516, -25901, -19917, -6729, 8892,
	21297, 26000, 21297, 8892, -6729, -19917, -25901, -22516,
	-10988, 4514, 18384, 25604, 23564, 13000, -2266, -16712,
	-25114, -24432, -14913, 0, 14912, 24431, 25114, 16712,
	2266, -12999, -23563, -25605, -18384, -4514, 10988, 22516,
	25901, 19917, 6729, -8892, -21297, -26000, -21298, -8892,
	6729, 19917, 25901, 22516, 10988, -4514, -18384, -25604,
	-23564, -13000, 2265, 16712, 25114, 24432, 14913, 0,
	-14912, -24431, -25114, -16712, -2266, 12999, 23563, 25605,
	18384, 4514, -10987, -22516, -25901, -19917, -6729, 8892,
	21297, 26000, 21298, 8892, -6729, -19917, -25901, -22516,
	-10988, 4514, 18384, 25604, 23564, 13000, -2265, -16712,
	-25114, -24432, -14913, 0, 14912, 24431, 25114, 16712,
	2266, -12999, -23563, -25605, -18384, -4515, 10987, 22516,
	25901, 19917, 6729, -8892, -21297, -26000, -21298, -8892,
	6729, 19917, 25901, 22516, 10988, -4514, -18384, -25604,
	-23564, -13000, 2265, 16712, 25114, 24432, 14913, 0,
	-14912, -24431, -25114, -16712, -2266, 12999, 23563, 25605,
	18384, 4515, -10987, -22516, -25901, -19917, -6729, 8892,
	21297, 26000, 21298, 8892, -6729, -19916, -25901, -22516,
	-10988, 4514, 18384, 25604, 23564, 13000, -2265, -16712,
	-25113, -24432, -14913, 0, 14912, 24431, 25114, 16712,
	2266, -12999, -23563, -25605, -18384, -4515, 10987, 22516,
	25901, 19917, 6729, -8892, -21297, -26000, -21298, -8892,
	6728, 19916, 25901, 22516, 10988, -4514, -18384, -25604,
	-23564, -13000, 2265, 16712, 25113, 24432, 14913, 0,
	-14912, -24431, -25114, -16712, -2266, 12999, 23563, 25605},
	},{{

// Carrier 16 Phase 0
	0, 15526, 24907, 24432, 14287, -1511, -16712, -25299,
	-23873, -13000, 3018, 17842, 25605, 23234, 11668, -4514,
	-18911, -25824, -22516, -10298, 5996, 19917, 25956, 21722,
	8892, -7456, -20855, -26000, -20855, -7456, 8892, 21722,
	25956, 19917, 5996, -10298, -22516, -25824, -18911, -4514,
	11668, 23234, 25604, 17842, 3018, -13000, -23873, -25299,
	-16712, -1511, 14287, 24432, 24907, 15526, 0, -15526,
	-24907, -24432, -14287, 1511, 16712, 25299, 23873, 12999,
	-3018, -17842, -25605, -23234, -11668, 4514, 18911, 25824,
	22516, 10298, -5996, -19917, -25956, -21722, -8892, 7456,
	20855, 26000, 20855, 7456, -8892, -21722, -25956, -19917,
	-5995, 10298, 22516, 25824, 18911, 4514, -11668, -23234,
	-25604, -17842, -3018, 13000, 23873, 25299, 16712, 1511,
	-14287, -24432, -24907, -15526, 0, 15526, 24907, 24431,
	14287, -1511, -16712, -25299, -23873, -12999, 3018, 17842,
	25605, 23234, 11668, -4514, -18911, -25824, -22516, -10298,
	5996, 19917, 25956, 21722, 8892, -7456, -20855, -26000,
	-20855, -7456, 8892, 21722, 25956, 19917, 5995, -10298,
	-22516, -25824, -18911, -4514, 11668, 23234, 25604, 17842,
	3018, -13000, -23873, -25299, -16712, -1511, 14287, 24432,
	24907, 15526, 0, -15526, -24907, -24431, -14287, 1511,
	16712, 25299, 23873, 12999, -3018, -17842, -25605, -23234,
	-11668, 4514, 18911, 25824, 22516, 10298, -5996, -19917,
	-25956, -21722, -8892, 7456, 20855, 26000, 20855, 7456,
	-8892, -21722, -25956, -19917, -5995, 10298, 22516, 25824,
	18911, 4514, -11668, -23234, -25604, -17842, -3018, 13000,
	23873, 25299, 16712, 1511, -14287, -24432, -24907, -15526},
	{
// Carrier 16 Phase 1
	18384, 25725, 22885, 10988, -5257, -19422, -25901, -22129,
	-9599, 6729, 20394, 25989, 21297, 8178, -8178, -21297,
	-25989, -20394, -6729, 9599, 22129, 25901, 19422, 5257,
	-10988, -22885, -25725, -18384, -3768, 12339, 23564, 25462,
	17284, 2266, -13649, -24163, -25114, -16126, -756, 14913,
	24680, 24680, 14912, -756, -16126, -25114, -24163, -13649,
	2266, 17284, 25462, 23563, 12339, -3768, -18384, -25725,
	-22885, -10988, 5257, 19422, 25901, 22129, 9599, -6729,
	-20394, -25989, -21297, -8178, 8178, 21297, 25989, 20394,
	6729, -9599, -22129, -25901, -19422, -5257, 10988, 22885,
	25725, 18384, 3768, -12339, -23564, -25462, -17284, -2266,
	13649, 24163, 25114, 16126, 756, -14913, -24680, -24680,
	-14912, 756, 16126, 25114, 24163, 13649, -2266, -17284,
	-25462, -23563, -12339, 3768, 18384, 25725, 22885, 10988,
	-5257, -19422, -25901, -22129, -9599, 6729, 20394, 25989,
	21297, 8178, -8178, -21297, -25989, -20394, -6729, 9599,
	22129, 25901, 19422, 5257, -10988, -22885, -25725, -18384,
	-3768, 12339, 23564, 25462, 17284, 2266, -13649, -24163,
	-25114, -16126, -756, 14913, 24680, 24680, 14912, -756,
	-16126, -25114, -24163, -13649, 2266, 17284, 25462, 23563,
	12339, -3768, -18384, -25725, -22885, -10988, 5257, 19422,
	25901, 22129, 9599, -6729, -20394, -25989, -21297, -8178,
	8178, 21297, 25988, 20394, 6729, -9599, -22129, -25901,
	-19422, -5257, 10988, 22885, 25725, 18384, 3768, -12339,
	-23564, -25462, -17284, -2265, 13649, 24163, 25114, 16126,
	756, -14913, -24680, -24680, -14912, 756, 16126, 25114,
	24163, 13649, -2266, -17284, -25462, -23563, -12339, 3768},
	{
// Carrier 16 Phase 2
	26000, 20855, 7456, -8892, -21722, -25956, -19917, -5996,
	10298, 22516, 25824, 18911, 4514, -11668, -23234, -25605,
	-17842, -3018, 13000, 23873, 25299, 16712, 1511, -14287,
	-24432, -24907, -15526, 0, 15526, 24907, 24432, 14287,
	-1511, -16712, -25299, -23873, -12999, 3018, 17842, 25605,
	23234, 11668, -4514, -18911, -25824, -22516, -10298, 5996,
	19917, 25956, 21722, 8892, -7456, -20855, -26000, -20855,
	-7456, 8892, 21722, 25956, 19917, 5995, -10298, -22516,
	-25824, -18911, -4514, 11668, 23234, 25604, 17842, 3018,
	-13000, -23873, -25299, -16712, -1511, 14287, 24432, 24907,
	15526, 0, -15526, -24907, -24432, -14287, 1511, 16712,
	25299, 23873, 12999, -3018, -17842, -25605, -23234, -11668,
	4514, 18911, 25824, 22516, 10298, -5996, -19917, -25956,
	-21722, -8892, 7456, 20855, 26000, 20855, 7456, -8892,
	-21722, -25956, -19917, -5995, 10298, 22516, 25824, 18911,
	4514, -11668, -23234, -25604, -17842, -3018, 13000, 23873,
	25299, 16712, 1511, -14287, -24432, -24907, -15526, 0,
	15526, 24907, 24431, 14287, -1511, -16712, -25299, -23873,
	-12999, 3018, 17842, 25605, 23234, 11668, -4514, -18911,
	-25824, -22516, -10298, 5996, 19917, 25956, 21722, 8892,
	-7456, -20855, -26000, -20855, -7456, 8892, 21722, 25956,
	19917, 5995, -10298, -22516, -25824, -18911, -4514, 11668,
	23234, 25604, 17842, 3018, -13000, -23873, -25299, -16712,
	-1511, 14287, 24432, 24907, 15526, 0, -15526, -24907,
	-24431, -14287, 1511, 16712, 25299, 23873, 12999, -3018,
	-17842, -25605, -23234, -11668, 4514, 18911, 25824, 22516,
	10298, -5996, -19917, -25956, -21722, -8892, 7456, 20855},
	{
// Carrier 16 Phase 3
	18384, 3768, -12339, -23564, -25462, -17284, -2266, 13649,
	24163, 25114, 16126, 756, -14912, -24680, -24680, -14912,
	756, 16126, 25114, 24163, 13649, -2266, -17284, -25462,
	-23563, -12339, 3768, 18384, 25725, 22885, 10988, -5257,
	-19422, -25901, -22129, -9599, 6729, 20394, 25989, 21297,
	8178, -8178, -21297, -25989, -20394, -6729, 9599, 22129,
	25901, 19422, 5257, -10988, -22885, -25725, -18384, -3768,
	12339, 23564, 25462, 17284, 2266, -13649, -24163, -25114,
	-16126, -756, 14913, 24680, 24680, 14912, -756, -16126,
	-25114, -24163, -13649, 2266, 17284, 25462, 23563, 12339,
	-3768, -18384, -25725, -22885, -10988, 5257, 19422, 25901,
	22129, 9599, -6729, -20394, -25989, -21297, -8178, 8178,
	21297, 25989, 20394, 6729, -9599, -22129, -25901, -19422,
	-5257, 10988, 22885, 25725, 18384, 3768, -12339, -23564,
	-25462, -17284, -2266, 13649, 24163, 25114, 16126, 756,
	-14913, -24680, -24680, -14912, 756, 16126, 25114, 24163,
	13649, -2266, -17284, -25462, -23563, -12339, 3768, 18384,
	25725, 22885, 10988, -5257, -19422, -25901, -22129, -9599,
	6729, 20394, 25989, 21297, 8178, -8178, -21297, -25988,
	-20394, -6729, 9599, 22129, 25901, 19422, 5257, -10988,
	-22885, -25725, -18384, -3768, 12339, 23564, 25462, 17284,
	2265, -13649, -24163, -25114, -16126, -756, 14913, 24680,
	24680, 14912, -756, -16126, -25114, -24163, -13649, 2266,
	17284, 25462, 23563, 12339, -3768, -18384, -25725, -22885,
	-10988, 5257, 19422, 25901, 22128, 9599, -6729, -20394,
	-25989, -21297, -8178, 8178, 21297, 25988, 20394, 6729,
	-9599, -22129, -25901, -19422, -5257, 10988, 22885, 25725},
	},{{

// Carrier 17 Phase 0
	0, 16126, 25299, 23564, 11668, -5257, -19917, -25989,
	-20855, -6729, 10298, 22885, 25604, 17284, 1511, -14913,
	-24907, -24163, -12999, 3768, 18911, 25901, 21722, 8178,
	-8892, -22129, -25824, -18384, -3018, 13649, 24432, 24680,
	14287, -2266, -17842, -25725, -22516, -9599, 7456, 21298,
	25956, 19422, 4514, -12339, -23873, -25114, -15526, 756,
	16712, 25462, 23234, 10987, -5996, -20394, -26000, -20394,
	-5995, 10988, 23234, 25462, 16712, 756, -15526, -25114,
	-23873, -12339, 4515, 19422, 25956, 21297, 7456, -9599,
	-22516, -25725, -17842, -2265, 14287, 24680, 24431, 13649,
	-3018, -18384, -25824, -22128, -8892, 8178, 21722, 25901,
	18911, 3768, -13000, -24163, -24907, -14912, 1511, 17284,
	25605, 22885, 10297, -6729, -20855, -25988, -19916, -5257,
	11669, 23564, 25299, 16125, 0, -16126, -25299, -23563,
	-11668, 5257, 19917, 25989, 20855, 6729, -10298, -22885,
	-25604, -17284, -1511, 14913, 24907, 24162, 12999, -3768,
	-18911, -25901, -21722, -8177, 8892, 22129, 25824, 18384,
	3018, -13649, -24432, -24680, -14286, 2266, 17842, 25725,
	22516, 9599, -7457, -21298, -25955, -19422, -4514, 12339,
	23873, 25113, 15525, -756, -16712, -25462, -23234, -10987,
	5996, 20395, 26000, 20394, 5995, -10988, -23234, -25462,
	-16712, -755, 15526, 25114, 23873, 12339, -4515, -19422,
	-25956, -21297, -7456, 9599, 22516, 25725, 17841, 2265,
	-14287, -24680, -24431, -13649, 3018, 18385, 25824, 22128,
	8892, -8178, -21722, -25901, -18911, -3767, 13000, 24163,
	24907, 14912, -1512, -17285, -25605, -22885, -10297, 6729,
	20855, 25988, 19916, 5257, -11669, -23564, -25299, -16125},
	{
// Carrier 17 Phase 1
	18384, 25824, 22129, 8892, -8178, -21722, -25901, -18911,
	-3768, 13000, 24163, 24907, 14912, -1511, -17284, -25605,
	-22885, -10298, 6729, 20855, 25989, 19917, 5257, -11668,
	-23564, -25299, -16126, 0, 16126, 25299, 23563, 11668,
	-5257, -19917, -25989, -20855, -6729, 10298, 22885, 25604,
	17284, 1511, -14913, -24907, -24163, -12999, 3768, 18911,
	25901, 21722, 8178, -8892, -22129, -25824, -18384, -3018,
	13649, 24432, 24680, 14287, -2266, -17842, -25725, -22516,
	-9599, 7457, 21298, 25956, 19422, 4514, -12339, -23873,
	-25114, -15525, 756, 16712, 25462, 23234, 10987, -5996,
	-20394, -26000, -20394, -5995, 10988, 23234, 25462, 16712,
	755, -15526, -25114, -23873, -12339, 4515, 19422, 25956,
	21297, 7456, -9599, -22516, -25725, -17842, -2265, 14287,
	24680, 24431, 13649, -3018, -18384, -25824, -22128, -8892,
	8178, 21722, 25901, 18911, 3767, -13000, -24163, -24907,
	-14912, 1512, 17284, 25605, 22885, 10297, -6729, -20855,
	-25988, -19916, -5257, 11669, 23564, 25299, 16125, 0,
	-16126, -25299, -23563, -11668, 5257, 19917, 25989, 20854,
	6728, -10298, -22885, -25604, -17284, -1511, 14913, 24907,
	24162, 12999, -3768, -18911, -25901, -21722, -8177, 8892,
	22129, 25824, 18384, 3018, -13649, -24432, -24680, -14286,
	2266, 17842, 25725, 22516, 9598, -7457, -21298, -25955,
	-19422, -4514, 12339, 23873, 25113, 15525, -756, -16712,
	-25462, -23234, -10987, 5996, 20395, 26000, 20394, 5995,
	-10988, -23234, -25462, -16712, -755, 15526, 25114, 23873,
	12339, -4515, -19422, -25956, -21297, -7456, 9599, 22516,
	25725, 17841, 2265, -14287, -24680, -24431, -13648, 3018},
	{
// Carrier 17 Phase 2
	26000, 20394, 5996, -10988, -23234, -25462, -16712, -756,
	15526, 25114, 23873, 12339, -4514, -19422, -25956, -21297,
	-7456, 9599, 22516, 25725, 17842, 2266, -14287, -24680,
	-24431, -13649, 3018, 18384, 25824, 22129, 8892, -8178,
	-21722, -25901, -18911, -3768, 13000, 24163, 24907, 14912,
	-1511, -17284, -25605, -22885, -10297, 6729, 20855, 25988,
	19917, 5257, -11668, -23564, -25299, -16126, 0, 16126,
	25299, 23563, 11668, -5257, -19917, -25989, -20855, -6729,
	10298, 22885, 25604, 17284, 1511, -14913, -24907, -24162,
	-12999, 3768, 18911, 25901, 21722, 8178, -8892, -22129,
	-25824, -18384, -3018, 13649, 24432, 24680, 14287, -2266,
	-17842, -25725, -22516, -9599, 7457, 21298, 25956, 19422,
	4514, -12339, -23873, -25114, -15525, 756, 16712, 25462,
	23234, 10987, -5996, -20394, -26000, -20394, -5995, 10988,
	23234, 25462, 16712, 755, -15526, -25114, -23873, -12339,
	4515, 19422, 25956, 21297, 7456, -9599, -22516, -25725,
	-17842, -2265, 14287, 24680, 24431, 13649, -3018, -18384,
	-25824, -22128, -8892, 8178, 21722, 25901, 18911, 3767,
	-13000, -24163, -24907, -14912, 1512, 17284, 25605, 22885,
	10297, -6729, -20855, -25988, -19916, -5257, 11669, 23564,
	25299, 16125, 0, -16126, -25299, -23563, -11668, 5258,
	19917, 25989, 20854, 6728, -10298, -22885, -25604, -17284,
	-1511, 14913, 24907, 24162, 12999, -3768, -18912, -25901,
	-21722, -8177, 8892, 22129, 25824, 18384, 3017, -13649,
	-24432, -24680, -14286, 2266, 17842, 25725, 22516, 9598,
	-7457, -21298, -25955, -19422, -4514, 12340, 23873, 25113,
	15525, -756, -16712, -25462, -23234, -10987, 5996, 20395},
	{
// Carrier 17 Phase 3
	18384, 3018, -13649, -24432, -24680, -14287, 2266, 17842,
	25725, 22516, 9599, -7456, -21297, -25956, -19422, -4514,
	12339, 23873, 25114, 15526, -756, -16712, -25462, -23234,
	-10988, 5996, 20394, 26000, 20394, 5995, -10988, -23234,
	-25462, -16712, -756, 15526, 25114, 23873, 12339, -4514,
	-19422, -25956, -21297, -7456, 9599, 22516, 25725, 17842,
	2265, -14287, -24680, -24431, -13649, 3018, 18384, 25824,
	22128, 8892, -8178, -21722, -25901, -18911, -3768, 13000,
	24163, 24907, 14912, -1511, -17284, -25605, -22885, -10297,
	6729, 20855, 25988, 19917, 5257, -11668, -23564, -25299,
	-16125, 0, 16126, 25299, 23563, 11668, -5257, -19917,
	-25989, -20855, -6729, 10298, 22885, 25604, 17284, 1511,
	-14913, -24907, -24162, -12999, 3768, 18911, 25901, 21722,
	8177, -8892, -22129, -25824, -18384, -3018, 13649, 24432,
	24680, 14287, -2266, -17842, -25725, -22516, -9599, 7457,
	21298, 25955, 19422, 4514, -12339, -23873, -25113, -15525,
	756, 16712, 25462, 23234, 10987, -5996, -20395, -26000,
	-20394, -5995, 10988, 23234, 25462, 16712, 755, -15526,
	-25114, -23873, -12339, 4515, 19422, 25956, 21297, 7456,
	-9599, -22516, -25725, -17842, -2265, 14287, 24680, 24431,
	13649, -3018, -18385, -25824, -22128, -8892, 8178, 21722,
	25901, 18911, 3767, -13000, -24163, -24907, -14912, 1512,
	17285, 25605, 22885, 10297, -6729, -20855, -25988, -19916,
	-5257, 11669, 23564, 25299, 16125, 0, -16126, -25299,
	-23563, -11668, 5258, 19917, 25989, 20854, 6728, -10298,
	-22885, -25604, -17284, -1511, 14913, 24907, 24162, 12999,
	-3768, -18912, -25901, -21722, -8177, 8893, 22129, 25824},
	},{{

// Carrier 18 Phase 0
	0, 16712, 25605, 22516, 8892, -8892, -22516, -25605,
	-16712, 0, 16712, 25604, 22516, 8892, -8892, -22516,
	-25605, -16712, 0, 16712, 25604, 22516, 8892, -8892,
	-22516, -25605, -16712, 0, 16712, 25604, 22516, 8892,
	-8892, -22516, -25605, -16712, 0, 16712, 25604, 22516,
	8892, -8892, -22516, -25605, -16712, 0, 16712, 25604,
	22516, 8892, -8892, -22516, -25605, -16712, 0, 16712,
	25604, 22516, 8892, -8892, -22516, -25605, -16712, 0,
	16712, 25604, 22516, 8892, -8892, -22516, -25605, -16712,
	0, 16712, 25604, 22516, 8892, -8892, -22516, -25605,
	-16712, 0, 16712, 25604, 22516, 8892, -8892, -22516,
	-25605, -16712, 0, 16712, 25604, 22516, 8892, -8892,
	-22516, -25605, -16712, 0, 16712, 25604, 22516, 8892,
	-8892, -22516, -25605, -16712, 0, 16712, 25604, 22516,
	8892, -8892, -22516, -25605, -16712, 0, 16712, 25604,
	22516, 8892, -8892, -22516, -25605, -16712, 0, 16712,
	25604, 22516, 8892, -8892, -22516, -25605, -16712, 0,
	16712, 25604, 22516, 8892, -8892, -22516, -25605, -16712,
	0, 16712, 25604, 22516, 8892, -8892, -22516, -25605,
	-16712, 0, 16712, 25604, 22516, 8892, -8892, -22516,
	-25605, -16712, 0, 16712, 25604, 22516, 8892, -8892,
	-22516, -25605, -16712, 0, 16712, 25604, 22516, 8892,
	-8892, -22516, -25605, -16712, 0, 16712, 25604, 22516,
	8892, -8892, -22516, -25605, -16712, 0, 16712, 25604,
	22516, 8892, -8892, -22516, -25605, -16712, 0, 16712,
	25604, 22516, 8892, -8892, -22516, -25605, -16712, 0,
	16712, 25604, 22516, 8892, -8892, -22516, -25605, -16712},
	{
// Carrier 18 Phase 1
	18384, 25901, 21297, 6729, -10988, -23563, -25114, -14913,
	2266, 18384, 25901, 21297, 6729, -10988, -23563, -25114,
	-14913, 2266, 18384, 25901, 21297, 6729, -10988, -23563,
	-25114, -14913, 2266, 18384, 25901, 21297, 6729, -10988,
	-23563, -25114, -14913, 2265, 18384, 25901, 21297, 6729,
	-10988, -23563, -25114, -14913, 2265, 18384, 25901, 21297,
	6729, -10988, -23563, -25114, -14913, 2265, 18384, 25901,
	21297, 6729, -10988, -23563, -25114, -14913, 2265, 18384,
	25901, 21298, 6729, -10987, -23563, -25114, -14913, 2265,
	18384, 25901, 21298, 6729, -10987, -23563, -25114, -14913,
	2265, 18384, 25901, 21298, 6729, -10987, -23563, -25114,
	-14913, 2265, 18384, 25901, 21298, 6729, -10987, -23563,
	-25114, -14913, 2265, 18384, 25901, 21298, 6729, -10987,
	-23563, -25114, -14913, 2265, 18384, 25901, 21298, 6729,
	-10987, -23563, -25114, -14913, 2265, 18384, 25901, 21298,
	6729, -10987, -23563, -25114, -14913, 2265, 18384, 25901,
	21298, 6729, -10987, -23563, -25114, -14913, 2265, 18384,
	25901, 21298, 6729, -10987, -23563, -25114, -14913, 2265,
	18384, 25901, 21298, 6729, -10987, -23563, -25114, -14913,
	2265, 18384, 25901, 21298, 6729, -10987, -23563, -25114,
	-14913, 2265, 18384, 25901, 21298, 6729, -10987, -23563,
	-25114, -14913, 2265, 18384, 25901, 21298, 6729, -10987,
	-23563, -25114, -14913, 2265, 18384, 25901, 21298, 6729,
	-10987, -23563, -25114, -14913, 2265, 18384, 25901, 21298,
	6729, -10987, -23563, -25114, -14913, 2265, 18384, 25901,
	21298, 6729, -10987, -23563, -25114, -14913, 2265, 18384,
	25901, 21298, 6729, -10987, -23563, -25114, -14913, 2265},
	{
// Carrier 18 Phase 2
	26000, 19917, 4514, -12999, -24432, -24432, -13000, 4514,
	19917, 26000, 19917, 4514, -12999, -24432, -24432, -13000,
	4514, 19917, 26000, 19917, 4514, -12999, -24431, -24432,
	-13000, 4514, 19917, 26000, 19917, 4514, -12999, -24431,
	-24432, -13000, 4514, 19917, 26000, 19917, 4514, -12999,
	-24431, -24432, -13000, 4514, 19917, 26000, 19917, 4514,
	-12999, -24431, -24432, -13000, 4514, 19917, 26000, 19917,
	4514, -12999, -24431, -24432, -13000, 4514, 19917, 26000,
	19917, 4514, -12999, -24431, -24432, -13000, 4514, 19917,
	26000, 19917, 4514, -12999, -24431, -24432, -13000, 4514,
	19917, 26000, 19917, 4514, -12999, -24431, -24432, -13000,
	4514, 19917, 26000, 19917, 4514, -12999, -24431, -24432,
	-13000, 4514, 19917, 26000, 19917, 4514, -12999, -24431,
	-24432, -13000, 4514, 19917, 26000, 19917, 4515, -12999,
	-24431, -24432, -13000, 4514, 19917, 26000, 19917, 4515,
	-12999, -24431, -24432, -13000, 4514, 19917, 26000, 19917,
	4515, -12999, -24431, -24432, -13000, 4514, 19917, 26000,
	19917, 4515, -12999, -24431, -24432, -13000, 4514, 19917,
	26000, 19917, 4515, -12999, -24431, -24432, -13000, 4514,
	19917, 26000, 19917, 4515, -12999, -24431, -24432, -13000,
	4514, 19917, 26000, 19917, 4515, -12999, -24431, -24432,
	-13000, 4514, 19917, 26000, 19917, 4515, -12999, -24431,
	-24432, -13000, 4514, 19916, 26000, 19917, 4515, -12999,
	-24431, -24432, -13000, 4514, 19916, 26000, 19917, 4515,
	-12999, -24431, -24432, -13000, 4514, 19916, 26000, 19917,
	4515, -12999, -24431, -24432, -13000, 4514, 19916, 26000,
	19917, 4515, -12999, -24431, -24432, -13000, 4514, 19916},
	{
// Carrier 18 Phase 3
	18384, 2266, -14912, -25114, -23564, -10988, 6729, 21297,
	25901, 18384, 2266, -14912, -25114, -23564, -10988, 6729,
	21297, 25901, 18384, 2266, -14912, -25114, -23564, -10988,
	6729, 21297, 25901, 18384, 2266, -14912, -25114, -23564,
	-10988, 6729, 21297, 25901, 18384, 2266, -14912, -25114,
	-23564, -10988, 6729, 21297, 25901, 18384, 2266, -14912,
	-25114, -23564, -10988, 6729, 21297, 25901, 18384, 2266,
	-14912, -25114, -23564, -10988, 6729, 21297, 25901, 18384,
	2266, -14912, -25114, -23564, -10988, 6729, 21297, 25901,
	18384, 2266, -14912, -25114, -23564, -10988, 6729, 21297,
	25901, 18384, 2266, -14912, -25114, -23564, -10988, 6729,
	21297, 25901, 18384, 2266, -14912, -25114, -23564, -10988,
	6729, 21297, 25901, 18384, 2266, -14912, -25114, -23564,
	-10988, 6729, 21297, 25901, 18384, 2266, -14912, -25114,
	-23564, -10988, 6729, 21297, 25901, 18384, 2266, -14912,
	-25114, -23564, -10988, 6729, 21297, 25901, 18384, 2266,
	-14912, -25114, -23564, -10988, 6729, 21297, 25901, 18384,
	2266, -14912, -25114, -23564, -10988, 6729, 21297, 25901,
	18384, 2266, -14912, -25114, -23564, -10988, 6729, 21297,
	25901, 18384, 2266, -14912, -25114, -23564, -10988, 6729,
	21297, 25901, 18384, 2266, -14912, -25114, -23564, -10988,
	6729, 21297, 25901, 18384, 2266, -14912, -25114, -23564,
	-10988, 6729, 21297, 25901, 18384, 2266, -14912, -25114,
	-23564, -10988, 6729, 21297, 25901, 18384, 2266, -14912,
	-25114, -23564, -10988, 6729, 21297, 25901, 18384, 2266,
	-14912, -25113, -23564, -10988, 6729, 21297, 25901, 18384,
	2266, -14912, -25113, -23564, -10988, 6729, 21297, 25901},
	},{{

// Carrier 19 Phase 0
	0, 17284, 25824, 21297, 5996, -12339, -24432, -24163,
	-11668, 6729, 21722, 25725, 16712, -756, -17842, -25901,
	-20855, -5257, 12999, 24680, 23873, 10988, -7456, -22129,
	-25605, -16126, 1511, 18384, 25956, 20394, 4514, -13649,
	-24907, -23564, -10298, 8178, 22516, 25462, 15526, -2266,
	-18911, -25989, -19917, -3768, 14287, 25114, 23234, 9599,
	-8892, -22885, -25299, -14912, 3018, 19422, 26000, 19422,
	3018, -14913, -25299, -22885, -8892, 9599, 23234, 25114,
	14287, -3768, -19917, -25989, -18911, -2266, 15526, 25462,
	22516, 8178, -10298, -23564, -24907, -13649, 4514, 20394,
	25956, 18384, 1511, -16126, -25605, -22129, -7456, 10988,
	23873, 24680, 12999, -5257, -20855, -25901, -17842, -756,
	16712, 25725, 21722, 6729, -11668, -24163, -24431, -12339,
	5996, 21297, 25824, 17284, 0, -17284, -25824, -21297,
	-5995, 12339, 24432, 24163, 11668, -6729, -21722, -25725,
	-16712, 756, 17842, 25901, 20855, 5257, -13000, -24680,
	-23873, -10988, 7456, 22129, 25604, 16126, -1511, -18384,
	-25956, -20394, -4514, 13649, 24907, 23563, 10297, -8178,
	-22516, -25462, -15526, 2266, 18911, 25989, 19917, 3768,
	-14287, -25114, -23234, -9599, 8892, 22885, 25299, 14912,
	-3018, -19422, -26000, -19422, -3018, 14913, 25299, 22885,
	8892, -9599, -23234, -25114, -14287, 3768, 19917, 25988,
	18911, 2265, -15526, -25462, -22516, -8178, 10298, 23564,
	24907, 13649, -4514, -20394, -25956, -18384, -1511, 16126,
	25605, 22128, 7456, -10988, -23873, -24680, -12999, 5257,
	20855, 25901, 17842, 756, -16712, -25725, -21722, -6729,
	11668, 24163, 24431, 12339, -5996, -21298, -25824, -17284},
	{
// Carrier 19 Phase 1
	18384, 25956, 20394, 4514, -13649, -24907, -23564, -10298,
	8178, 22516, 25462, 15526, -2266, -18911, -25989, -19917,
	-3768, 14287, 25114, 23234, 9599, -8892, -22885, -25299,
	-14912, 3018, 19422, 26000, 19422, 3018, -14913, -25299,
	-22885, -8892, 9599, 23234, 25114, 14287, -3768, -19917,
	-25989, -18911, -2266, 15526, 25462, 22516, 8178, -10298,
	-23564, -24907, -13649, 4514, 20394, 25956, 18384, 1511,
	-16126, -25605, -22129, -7456, 10988, 23873, 24680, 12999,
	-5257, -20855, -25901, -17842, -756, 16712, 25725, 21722,
	6729, -11668, -24163, -24431, -12339, 5996, 21297, 25824,
	17284, 0, -17284, -25824, -21297, -5995, 12339, 24432,
	24163, 11668, -6729, -21722, -25725, -16712, 756, 17842,
	25901, 20855, 5257, -13000, -24680, -23873, -10988, 7456,
	22129, 25604, 16126, -1511, -18384, -25956, -20394, -4514,
	13649, 24907, 23563, 10297, -8178, -22516, -25462, -15526,
	2266, 18911, 25989, 19917, 3768, -14287, -25114, -23234,
	-9599, 8892, 22885, 25299, 14912, -3018, -19422, -26000,
	-19422, -3018, 14913, 25299, 22885, 8892, -9599, -23234,
	-25114, -14287, 3768, 19917, 25988, 18911, 2265, -15526,
	-25462, -22516, -8178, 10298, 23564, 24907, 13649, -4514,
	-20394, -25956, -18384, -1511, 16126, 25605, 22128, 7456,
	-10988, -23873, -24680, -12999, 5257, 20855, 25901, 17842,
	756, -16712, -25725, -21722, -6729, 11668, 24163, 24431,
	12339, -5996, -21298, -25824, -17284, 0, 17284, 25824,
	21297, 5995, -12339, -24432, -24162, -11668, 6729, 21722,
	25725, 16712, -756, -17842, -25901, -20855, -5257, 13000,
	24680, 23873, 10987, -7457, -22129, -25604, -16126, 1511},
	{
// Carrier 19 Phase 2
	26000, 19422, 3018, -14912, -25299, -22885, -8892, 9599,
	23234, 25114, 14287, -3768, -19917, -25989, -18911, -2266,
	15526, 25462, 22516, 8178, -10298, -23564, -24907, -13649,
	4514, 20394, 25956, 18384, 1511, -16126, -25605, -22129,
	-7456, 10988, 23873, 24680, 12999, -5257, -20855, -25901,
	-17842, -756, 16712, 25725, 21722, 6729, -11668, -24163,
	-24431, -12339, 5996, 21297, 25824, 17284, 0, -17284,
	-25824, -21297, -5995, 12339, 24432, 24163, 11668, -6729,
	-21722, -25725, -16712, 756, 17842, 25901, 20855, 5257,
	-13000, -24680, -23873, -10988, 7456, 22129, 25604, 16126,
	-1511, -18384, -25956, -20394, -4514, 13649, 24907, 23563,
	10298, -8178, -22516, -25462, -15526, 2266, 18911, 25989,
	19917, 3768, -14287, -25114, -23234, -9599, 8892, 22885,
	25299, 14912, -3018, -19422, -26000, -19422, -3018, 14913,
	25299, 22885, 8892, -9599, -23234, -25114, -14287, 3768,
	19917, 25988, 18911, 2265, -15526, -25462, -22516, -8178,
	10298, 23564, 24907, 13649, -4514, -20394, -25956, -18384,
	-1511, 16126, 25605, 22128, 7456, -10988, -23873, -24680,
	-12999, 5257, 20855, 25901, 17842, 756, -16712, -25725,
	-21722, -6729, 11668, 24163, 24431, 12339, -5996, -21298,
	-25824, -17284, 0, 17284, 25824, 21297, 5995, -12339,
	-24432, -24162, -11668, 6729, 21722, 25725, 16712, -756,
	-17842, -25901, -20855, -5257, 13000, 24680, 23873, 10987,
	-7457, -22129, -25604, -16126, 1511, 18384, 25956, 20394,
	4514, -13649, -24907, -23563, -10297, 8178, 22516, 25462,
	15526, -2266, -18911, -25989, -19917, -3768, 14287, 25114,
	23234, 9599, -8892, -22885, -25299, -14912, 3018, 19422},
	{
// Carrier 19 Phase 3
	18384, 1511, -16126, -25605, -22129, -7456, 10988, 23873,
	24680, 12999, -5257, -20855, -25901, -17842, -756, 16712,
	25725, 21722, 6729, -11668, -24163, -24432, -12339, 5996,
	21297, 25824, 17284, 0, -17284, -25824, -21297, -5995,
	12339, 24432, 24163, 11668, -6729, -21722, -25725, -16712,
	756, 17842, 25901, 20855, 5257, -13000, -24680, -23873,
	-10988, 7456, 22129, 25604, 16126, -1511, -18384, -25956,
	-20394, -4514, 13649, 24907, 23563, 10298, -8178, -22516,
	-25462, -15526, 2266, 18911, 25989, 19917, 3768, -14287,
	-25114, -23234, -9599, 8892, 22885, 25299, 14912, -3018,
	-19422, -26000, -19422, -3018, 14913, 25299, 22885, 8892,
	-9599, -23234, -25114, -14287, 3768, 19917, 25988, 18911,
	2265, -15526, -25462, -22516, -8178, 10298, 23564, 24907,
	13649, -4514, -20394, -25956, -18384, -1511, 16126, 25605,
	22128, 7456, -10988, -23873, -24680, -12999, 5257, 20855,
	25901, 17842, 756, -16712, -25725, -21722, -6729, 11668,
	24163, 24431, 12339, -5996, -21298, -25824, -17284, 0,
	17284, 25824, 21297, 5995, -12339, -24432, -24162, -11668,
	6729, 21722, 25725, 16712, -756, -17842, -25901, -20855,
	-5257, 13000, 24680, 23873, 10987, -7456, -22129, -25604,
	-16126, 1511, 18384, 25956, 20394, 4514, -13649, -24907,
	-23563, -10297, 8178, 22516, 25462, 15526, -2266, -18911,
	-25989, -19917, -3768, 14287, 25114, 23234, 9599, -8892,
	-22885, -25299, -14912, 3018, 19422, 26000, 19422, 3018,
	-14913, -25299, -22885, -8892, 9599, 23234, 25114, 14287,
	-3768, -19917, -25988, -18911, -2265, 15526, 25462, 22516,
	8178, -10298, -23564, -24907, -13649, 4515, 20394, 25956},
	},{{

// Carrier 20 Phase 0
	0, 17842, 25956, 19917, 3018, -15526, -25605, -21722,
	-5996, 13000, 24907, 23234, 8892, -10298, -23873, -24432,
	-11668, 7456, 22516, 25299, 14287, -4514, -20855, -25824,
	-16712, 1511, 18911, 26000, 18911, 1511, -16712, -25824,
	-20855, -4514, 14287, 25299, 22516, 7456, -11668, -24432,
	-23873, -10297, 8892, 23234, 24907, 12999, -5996, -21722,
	-25604, -15526, 3018, 19917, 25956, 17842, 0, -17842,
	-25956, -19917, -3018, 15526, 25605, 21722, 5995, -13000,
	-24907, -23234, -8892, 10298, 23873, 24431, 11668, -7457,
	-22516, -25299, -14287, 4515, 20855, 25824, 16712, -1511,
	-18911, -26000, -18911, -1511, 16712, 25824, 20855, 4514,
	-14287, -25299, -22516, -7456, 11668, 24432, 23873, 10297,
	-8892, -23234, -24907, -12999, 5996, 21722, 25604, 15525,
	-3018, -19917, -25955, -17842, 0, 17842, 25956, 19916,
	3018, -15526, -25605, -21722, -5995, 13000, 24907, 23234,
	8892, -10298, -23873, -24431, -11668, 7457, 22516, 25299,
	14286, -4515, -20855, -25824, -16712, 1512, 18911, 26000,
	18911, 1511, -16712, -25824, -20855, -4514, 14287, 25299,
	22516, 7456, -11669, -24432, -23873, -10297, 8892, 23234,
	24907, 12999, -5996, -21722, -25604, -15525, 3018, 19917,
	25955, 17842, 0, -17842, -25956, -19916, -3018, 15526,
	25605, 21722, 5995, -13000, -24907, -23234, -8892, 10298,
	23873, 24431, 11668, -7457, -22516, -25299, -14286, 4515,
	20855, 25824, 16712, -1512, -18912, -26000, -18911, -1511,
	16712, 25824, 20854, 4514, -14287, -25299, -22516, -7456,
	11669, 24432, 23873, 10297, -8892, -23234, -24907, -12999,
	5996, 21722, 25604, 15525, -3018, -19917, -25955, -17841},
	{
// Carrier 20 Phase 1
	18384, 25989, 19422, 2266, -16126, -25725, -21297, -5257,
	13649, 25114, 22885, 8178, -10988, -24163, -24163, -10988,
	8178, 22885, 25114, 13649, -5257, -21297, -25725, -16126,
	2266, 19422, 25988, 18384, 756, -17284, -25901, -20394,
	-3768, 14913, 25462, 22128, 6729, -12339, -24680, -23563,
	-9599, 9599, 23564, 24680, 12339, -6729, -22129, -25462,
	-14912, 3768, 20394, 25901, 17284, -756, -18384, -25989,
	-19422, -2265, 16126, 25725, 21297, 5257, -13649, -25114,
	-22885, -8178, 10988, 24163, 24162, 10987, -8178, -22885,
	-25114, -13649, 5257, 21298, 25725, 16125, -2266, -19422,
	-25988, -18384, -756, 17284, 25901, 20394, 3768, -14913,
	-25462, -22128, -6729, 12339, 24680, 23563, 9599, -9599,
	-23564, -24680, -12339, 6729, 22129, 25462, 14912, -3768,
	-20394, -25901, -17284, 756, 18384, 25989, 19422, 2265,
	-16126, -25725, -21297, -5257, 13649, 25114, 22885, 8177,
	-10988, -24163, -24162, -10987, 8178, 22885, 25113, 13649,
	-5257, -21298, -25725, -16125, 2266, 19422, 25988, 18384,
	755, -17284, -25901, -20394, -3767, 14913, 25462, 22128,
	6728, -12339, -24680, -23563, -9599, 9599, 23564, 24680,
	12339, -6729, -22129, -25462, -14912, 3768, 20395, 25901,
	17284, -756, -18385, -25989, -19422, -2265, 16126, 25725,
	21297, 5257, -13649, -25114, -22885, -8177, 10988, 24163,
	24162, 10987, -8178, -22885, -25113, -13649, 5258, 21298,
	25725, 16125, -2266, -19422, -25988, -18384, -755, 17285,
	25901, 20394, 3767, -14913, -25462, -22128, -6728, 12340,
	24680, 23563, 9598, -9599, -23564, -24680, -12339, 6729,
	22129, 25462, 14912, -3768, -20395, -25901, -17284, 756},
	{
// Carrier 20 Phase 2
	26000, 18911, 1511, -16712, -25824, -20855, -4514, 14287,
	25299, 22516, 7456, -11668, -24432, -23873, -10298, 8892,
	23234, 24907, 12999, -5996, -21722, -25604, -15526, 3018,
	19917, 25956, 17842, 0, -17842, -25956, -19917, -3018,
	15526, 25605, 21722, 5995, -13000, -24907, -23234, -8892,
	10298, 23873, 24431, 11668, -7456, -22516, -25299, -14287,
	4514, 20855, 25824, 16712, -1511, -18911, -26000, -18911,
	-1511, 16712, 25824, 20855, 4514, -14287, -25299, -22516,
	-7456, 11668, 24432, 23873, 10297, -8892, -23234, -24907,
	-12999, 5996, 21722, 25604, 15525, -3018, -19917, -25956,
	-17842, 0, 17842, 25956, 19917, 3018, -15526, -25605,
	-21722, -5995, 13000, 24907, 23234, 8892, -10298, -23873,
	-24431, -11668, 7457, 22516, 25299, 14287, -4515, -20855,
	-25824, -16712, 1512, 18911, 26000, 18911, 1511, -16712,
	-25824, -20855, -4514, 14287, 25299, 22516, 7456, -11669,
	-24432, -23873, -10297, 8892, 23234, 24907, 12999, -5996,
	-21722, -25604, -15525, 3018, 19917, 25955, 17842, 0,
	-17842, -25956, -19916, -3018, 15526, 25605, 21722, 5995,
	-13000, -24907, -23234, -8892, 10298, 23873, 24431, 11668,
	-7457, -22516, -25299, -14286, 4515, 20855, 25824, 16712,
	-1512, -18911, -26000, -18911, -1511, 16712, 25824, 20854,
	4514, -14287, -25299, -22516, -7456, 11669, 24432, 23873,
	10297, -8892, -23234, -24907, -12999, 5996, 21722, 25604,
	15525, -3018, -19917, -25955, -17841, 0, 17842, 25956,
	19916, 3017, -15526, -25605, -21722, -5995, 13000, 24907,
	23234, 8892, -10298, -23873, -24431, -11668, 7457, 22516,
	25299, 14286, -4515, -20855, -25824, -16712, 1512, 18912},
	{
// Carrier 20 Phase 3
	18384, 756, -17284, -25901, -20394, -3768, 14913, 25462,
	22129, 6729, -12339, -24680, -23563, -9599, 9599, 23564,
	24680, 12339, -6729, -22129, -25462, -14912, 3768, 20394,
	25901, 17284, -756, -18384, -25989, -19422, -2265, 16126,
	25725, 21297, 5257, -13649, -25114, -22885, -8178, 10988,
	24163, 24163, 10987, -8178, -22885, -25114, -13649, 5257,
	21298, 25725, 16126, -2266, -19422, -25988, -18384, -756,
	17284, 25901, 20394, 3768, -14913, -25462, -22128, -6729,
	12339, 24680, 23563, 9599, -9599, -23564, -24680, -12339,
	6729, 22129, 25462, 14912, -3768, -20394, -25901, -17284,
	756, 18384, 25989, 19422, 2265, -16126, -25725, -21297,
	-5257, 13649, 25114, 22885, 8177, -10988, -24163, -24162,
	-10987, 8178, 22885, 25114, 13649, -5257, -21298, -25725,
	-16125, 2266, 19422, 25988, 18384, 755, -17284, -25901,
	-20394, -3767, 14913, 25462, 22128, 6729, -12339, -24680,
	-23563, -9599, 9599, 23564, 24680, 12339, -6729, -22129,
	-25462, -14912, 3768, 20394, 25901, 17284, -756, -18384,
	-25989, -19422, -2265, 16126, 25725, 21297, 5257, -13649,
	-25114, -22885, -8177, 10988, 24163, 24162, 10987, -8178,
	-22885, -25113, -13649, 5258, 21298, 25725, 16125, -2266,
	-19422, -25988, -18384, -755, 17284, 25901, 20394, 3767,
	-14913, -25462, -22128, -6728, 12339, 24680, 23563, 9598,
	-9599, -23564, -24680, -12339, 6729, 22129, 25462, 14912,
	-3768, -20395, -25901, -17284, 756, 18385, 25989, 19422,
	2265, -16126, -25725, -21297, -5257, 13649, 25114, 22885,
	8177, -10988, -24163, -24162, -10987, 8178, 22885, 25113,
	13648, -5258, -21298, -25725, -16125, 2266, 19422, 25988},
	},{{

// Carrier 21 Phase 0
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18384,
	0, 18384, 26000, 18384, 0, -18384, -26000, -18385,
	0, 18384, 26000, 18385, 0, -18384, -26000, -18385},
	{
// Carrier 21 Phase 1
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18384, 0,
	18384, 26000, 18384, 0, -18384, -26000, -18385, 0,
	18384, 26000, 18385, 0, -18384, -26000, -18385, 0},
	{
// Carrier 21 Phase 2
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18384, 0, 18384,
	26000, 18384, 0, -18384, -26000, -18385, 0, 18384,
	26000, 18385, 0, -18384, -26000, -18385, 0, 18384},
	{
// Carrier 21 Phase 3
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18384, 0, 18384, 26000,
	18384, 0, -18384, -26000, -18385, 0, 18384, 26000,
	18385, 0, -18384, -26000, -18385, 0, 18384, 26000},
	},{{

// Carrier 22 Phase 0
	0, 18911, 25956, 16712, -3018, -20855, -25605, -14287,
	5996, 22516, 24907, 11668, -8892, -23873, -23873, -8892,
	11668, 24907, 22516, 5996, -14287, -25605, -20855, -3018,
	16712, 25956, 18911, 0, -18911, -25956, -16712, 3018,
	20855, 25604, 14287, -5996, -22516, -24907, -11668, 8892,
	23873, 23873, 8892, -11668, -24907, -22516, -5996, 14287,
	25605, 20855, 3018, -16712, -25956, -18911, 0, 18911,
	25956, 16712, -3018, -20855, -25604, -14287, 5996, 22516,
	24907, 11668, -8892, -23873, -23873, -8892, 11668, 24907,
	22516, 5995, -14287, -25605, -20855, -3018, 16712, 25956,
	18911, 0, -18911, -25956, -16712, 3018, 20855, 25604,
	14287, -5996, -22516, -24907, -11668, 8892, 23873, 23873,
	8892, -11668, -24907, -22516, -5995, 14287, 25605, 20855,
	3018, -16712, -25956, -18911, 0, 18911, 25956, 16712,
	-3018, -20855, -25604, -14287, 5996, 22516, 24907, 11668,
	-8892, -23873, -23873, -8892, 11668, 24907, 22516, 5995,
	-14287, -25605, -20855, -3018, 16712, 25956, 18911, 0,
	-18911, -25956, -16712, 3018, 20855, 25604, 14287, -5996,
	-22516, -24907, -11668, 8892, 23873, 23873, 8892, -11668,
	-24907, -22516, -5995, 14287, 25605, 20855, 3018, -16712,
	-25956, -18911, 0, 18911, 25956, 16712, -3018, -20855,
	-25604, -14287, 5996, 22516, 24907, 11668, -8892, -23873,
	-23873, -8892, 11668, 24907, 22516, 5995, -14287, -25605,
	-20855, -3018, 16712, 25956, 18911, 0, -18911, -25956,
	-16712, 3018, 20855, 25604, 14287, -5996, -22516, -24907,
	-11668, 8892, 23873, 23873, 8892, -11668, -24907, -22516,
	-5995, 14287, 25605, 20855, 3018, -16712, -25956, -18911},
	{
// Carrier 22 Phase 1
	18384, 25989, 17284, -2266, -20394, -25725, -14912, 5257,
	22129, 25114, 12339, -8178, -23564, -24163, -9599, 10988,
	24680, 22885, 6729, -13649, -25462, -21297, -3768, 16126,
	25901, 19422, 756, -18384, -25989, -17284, 2266, 20394,
	25725, 14912, -5257, -22129, -25114, -12339, 8178, 23564,
	24163, 9599, -10988, -24680, -22885, -6729, 13649, 25462,
	21297, 3768, -16126, -25901, -19422, -756, 18384, 25989,
	17284, -2266, -20394, -25725, -14912, 5257, 22129, 25114,
	12339, -8178, -23564, -24163, -9599, 10988, 24680, 22885,
	6729, -13649, -25462, -21297, -3768, 16126, 25901, 19422,
	756, -18384, -25988, -17284, 2266, 20394, 25725, 14912,
	-5257, -22129, -25114, -12339, 8178, 23564, 24163, 9599,
	-10988, -24680, -22885, -6729, 13649, 25462, 21297, 3768,
	-16126, -25901, -19422, -756, 18384, 25988, 17284, -2266,
	-20394, -25725, -14912, 5257, 22129, 25114, 12339, -8178,
	-23564, -24163, -9599, 10988, 24680, 22885, 6729, -13649,
	-25462, -21297, -3768, 16126, 25901, 19422, 756, -18384,
	-25988, -17284, 2266, 20394, 25725, 14912, -5257, -22129,
	-25114, -12339, 8178, 23564, 24163, 9599, -10988, -24680,
	-22885, -6729, 13649, 25462, 21297, 3768, -16126, -25901,
	-19422, -756, 18384, 25988, 17284, -2266, -20394, -25725,
	-14912, 5257, 22129, 25114, 12339, -8178, -23564, -24162,
	-9599, 10988, 24680, 22885, 6729, -13649, -25462, -21297,
	-3768, 16126, 25901, 19422, 756, -18384, -25988, -17284,
	2266, 20394, 25725, 14912, -5257, -22129, -25114, -12339,
	8178, 23564, 24162, 9599, -10988, -24680, -22885, -6729,
	13649, 25462, 21297, 3768, -16126, -25901, -19422, -756},
	{
// Carrier 22 Phase 2
	26000, 17842, -1511, -19917, -25824, -15526, 4514, 21722,
	25299, 13000, -7456, -23234, -24432, -10298, 10298, 24432,
	23234, 7456, -12999, -25299, -21722, -4514, 15526, 25824,
	19917, 1511, -17842, -26000, -17842, 1511, 19917, 25824,
	15526, -4514, -21722, -25299, -13000, 7456, 23234, 24432,
	10298, -10298, -24432, -23234, -7456, 13000, 25299, 21722,
	4514, -15526, -25824, -19917, -1511, 17842, 26000, 17842,
	-1511, -19917, -25824, -15526, 4514, 21722, 25299, 12999,
	-7456, -23234, -24432, -10298, 10298, 24432, 23234, 7456,
	-13000, -25299, -21722, -4514, 15526, 25824, 19917, 1511,
	-17842, -26000, -17842, 1511, 19917, 25824, 15526, -4514,
	-21722, -25299, -12999, 7456, 23234, 24431, 10298, -10298,
	-24432, -23234, -7456, 13000, 25299, 21722, 4514, -15526,
	-25824, -19917, -1511, 17842, 26000, 17842, -1511, -19917,
	-25824, -15526, 4514, 21722, 25299, 12999, -7456, -23234,
	-24431, -10298, 10298, 24432, 23234, 7456, -13000, -25299,
	-21722, -4514, 15526, 25824, 19917, 1511, -17842, -26000,
	-17842, 1511, 19917, 25824, 15526, -4514, -21722, -25299,
	-12999, 7456, 23234, 24431, 10298, -10298, -24432, -23234,
	-7456, 13000, 25299, 21722, 4514, -15526, -25824, -19917,
	-1511, 17842, 26000, 17842, -1511, -19917, -25824, -15526,
	4514, 21722, 25299, 12999, -7456, -23234, -24431, -10298,
	10298, 24432, 23234, 7456, -13000, -25299, -21722, -4514,
	15526, 25824, 19917, 1511, -17842, -26000, -17842, 1511,
	19917, 25824, 15526, -4514, -21722, -25299, -12999, 7456,
	23234, 24431, 10298, -10298, -24432, -23234, -7456, 13000,
	25299, 21722, 4514, -15526, -25824, -19917, -1511, 17842},
	{
// Carrier 22 Phase 3
	18384, -756, -19422, -25901, -16126, 3768, 21297, 25462,
	13649, -6729, -22885, -24680, -10988, 9599, 24163, 23564,
	8178, -12339, -25114, -22129, -5257, 14912, 25725, 20394,
	2266, -17284, -25989, -18384, 756, 19422, 25901, 16126,
	-3768, -21297, -25462, -13649, 6729, 22885, 24680, 10988,
	-9599, -24163, -23563, -8178, 12339, 25114, 22129, 5257,
	-14913, -25725, -20394, -2266, 17284, 25989, 18384, -756,
	-19422, -25901, -16126, 3768, 21297, 25462, 13649, -6729,
	-22885, -24680, -10988, 9599, 24163, 23563, 8178, -12339,
	-25114, -22129, -5257, 14913, 25725, 20394, 2266, -17284,
	-25989, -18384, 756, 19422, 25901, 16126, -3768, -21297,
	-25462, -13649, 6729, 22885, 24680, 10988, -9599, -24163,
	-23563, -8178, 12339, 25114, 22129, 5257, -14913, -25725,
	-20394, -2266, 17284, 25989, 18384, -756, -19422, -25901,
	-16126, 3768, 21297, 25462, 13649, -6729, -22885, -24680,
	-10988, 9599, 24163, 23563, 8178, -12339, -25114, -22129,
	-5257, 14913, 25725, 20394, 2265, -17284, -25989, -18384,
	756, 19422, 25901, 16126, -3768, -21297, -25462, -13649,
	6729, 22885, 24680, 10988, -9599, -24163, -23563, -8178,
	12339, 25114, 22128, 5257, -14913, -25725, -20394, -2265,
	17284, 25989, 18384, -756, -19422, -25901, -16126, 3768,
	21297, 25462, 13649, -6729, -22885, -24680, -10988, 9599,
	24163, 23563, 8178, -12339, -25114, -22128, -5257, 14913,
	25725, 20394, 2265, -17284, -25989, -18384, 756, 19422,
	25901, 16126, -3768, -21297, -25462, -13649, 6729, 22885,
	24680, 10987, -9599, -24163, -23563, -8178, 12339, 25114,
	22128, 5257, -14913, -25725, -20394, -2265, 17284, 25989},
	},{{

// Carrier 23 Phase 0
	0, 19422, 25824, 14912, -5996, -22885, -24432, -9599,
	11668, 25114, 21722, 3768, -16712, -25989, -17842, 2266,
	20855, 25462, 12999, -8178, -23873, -23563, -7456, 13649,
	25605, 20394, 1511, -18384, -25956, -16126, 4514, 22129,
	24907, 10988, -10298, -24680, -22516, -5257, 15526, 25901,
	18911, -756, -19917, -25725, -14287, 6729, 23234, 24163,
	8892, -12339, -25299, -21297, -3018, 17284, 26000, 17284,
	-3018, -21297, -25299, -12339, 8892, 24163, 23234, 6729,
	-14287, -25725, -19917, -756, 18911, 25901, 15526, -5257,
	-22516, -24680, -10297, 10988, 24907, 22128, 4514, -16126,
	-25956, -18384, 1511, 20394, 25604, 13649, -7457, -23564,
	-23873, -8178, 13000, 25462, 20855, 2265, -17842, -25988,
	-16712, 3768, 21722, 25114, 11668, -9599, -24432, -22885,
	-5995, 14913, 25824, 19422, 0, -19422, -25824, -14912,
	5996, 22885, 24431, 9599, -11668, -25114, -21722, -3768,
	16712, 25989, 17842, -2266, -20855, -25462, -12999, 8178,
	23873, 23563, 7456, -13649, -25605, -20394, -1511, 18384,
	25955, 16125, -4515, -22129, -24907, -10987, 10298, 24680,
	22516, 5257, -15526, -25901, -18911, 756, 19917, 25725,
	14287, -6729, -23234, -24162, -8892, 12339, 25299, 21297,
	3018, -17284, -26000, -17284, 3018, 21298, 25299, 12339,
	-8892, -24163, -23234, -6729, 14287, 25725, 19916, 755,
	-18911, -25901, -15525, 5257, 22516, 24680, 10297, -10988,
	-24907, -22128, -4514, 16126, 25956, 18384, -1512, -20394,
	-25604, -13649, 7457, 23564, 23873, 8177, -13000, -25462,
	-20855, -2265, 17842, 25988, 16712, -3768, -21722, -25113,
	-11668, 9599, 24432, 22885, 5995, -14913, -25824, -19422},
	{
// Carrier 23 Phase 1
	18384, 25956, 16126, -4514, -22129, -24907, -10988, 10298,
	24680, 22516, 5257, -15526, -25901, -18911, 756, 19917,
	25725, 14287, -6729, -23234, -24163, -8892, 12339, 25299,
	21297, 3018, -17284, -26000, -17284, 3018, 21297, 25299,
	12339, -8892, -24163, -23234, -6729, 14287, 25725, 19917,
	756, -18911, -25901, -15526, 5257, 22516, 24680, 10298,
	-10988, -24907, -22128, -4514, 16126, 25956, 18384, -1511,
	-20394, -25604, -13649, 7456, 23564, 23873, 8178, -13000,
	-25462, -20855, -2265, 17842, 25988, 16712, -3768, -21722,
	-25114, -11668, 9599, 24432, 22885, 5995, -14913, -25824,
	-19422, 0, 19422, 25824, 14912, -5996, -22885, -24431,
	-9599, 11668, 25114, 21722, 3768, -16712, -25989, -17842,
	2266, 20855, 25462, 12999, -8178, -23873, -23563, -7456,
	13649, 25605, 20394, 1511, -18384, -25956, -16125, 4515,
	22129, 24907, 10987, -10298, -24680, -22516, -5257, 15526,
	25901, 18911, -756, -19917, -25725, -14287, 6729, 23234,
	24162, 8892, -12339, -25299, -21297, -3018, 17284, 26000,
	17284, -3018, -21298, -25299, -12339, 8892, 24163, 23234,
	6729, -14287, -25725, -19917, -755, 18911, 25901, 15525,
	-5257, -22516, -24680, -10297, 10988, 24907, 22128, 4514,
	-16126, -25956, -18384, 1512, 20394, 25604, 13649, -7457,
	-23564, -23873, -8177, 13000, 25462, 20855, 2265, -17842,
	-25988, -16712, 3768, 21722, 25113, 11668, -9599, -24432,
	-22885, -5995, 14913, 25824, 19422, 0, -19422, -25824,
	-14912, 5996, 22885, 24431, 9599, -11669, -25114, -21722,
	-3767, 16712, 25989, 17842, -2266, -20855, -25462, -12999,
	8178, 23873, 23563, 7456, -13649, -25605, -20394, -1511},
	{
// Carrier 23 Phase 2
	26000, 17284, -3018, -21297, -25299, -12339, 8892, 24163,
	23234, 6729, -14287, -25725, -19917, -756, 18911, 25901,
	15526, -5257, -22516, -24680, -10298, 10988, 24907, 22129,
	4514, -16126, -25956, -18384, 1511, 20394, 25604, 13649,
	-7456, -23564, -23873, -8178, 13000, 25462, 20855, 2265,
	-17842, -25988, -16712, 3768, 21722, 25114, 11668, -9599,
	-24432, -22885, -5995, 14913, 25824, 19422, 0, -19422,
	-25824, -14912, 5996, 22885, 24431, 9599, -11668, -25114,
	-21722, -3768, 16712, 25989, 17842, -2266, -20855, -25462,
	-12999, 8178, 23873, 23563, 7456, -13649, -25605, -20394,
	-1511, 18384, 25956, 16126, -4514, -22129, -24907, -10987,
	10298, 24680, 22516, 5257, -15526, -25901, -18911, 756,
	19917, 25725, 14287, -6729, -23234, -24162, -8892, 12339,
	25299, 21297, 3018, -17284, -26000, -17284, 3018, 21298,
	25299, 12339, -8892, -24163, -23234, -6729, 14287, 25725,
	19917, 756, -18911, -25901, -15525, 5257, 22516, 24680,
	10297, -10988, -24907, -22128, -4514, 16126, 25956, 18384,
	-1511, -20394, -25604, -13649, 7457, 23564, 23873, 8177,
	-13000, -25462, -20855, -2265, 17842, 25988, 16712, -3768,
	-21722, -25114, -11668, 9599, 24432, 22885, 5995, -14913,
	-25824, -19422, 0, 19422, 25824, 14912, -5996, -22885,
	-24431, -9599, 11669, 25114, 21722, 3767, -16712, -25989,
	-17842, 2266, 20855, 25462, 12999, -8178, -23873, -23563,
	-7456, 13649, 25605, 20394, 1511, -18384, -25955, -16125,
	4515, 22129, 24907, 10987, -10298, -24680, -22516, -5257,
	15526, 25901, 18911, -756, -19917, -25725, -14286, 6729,
	23234, 24162, 8892, -12339, -25299, -21297, -3018, 17284},
	{
// Carrier 23 Phase 3
	18384, -1511, -20394, -25605, -13649, 7456, 23564, 23873,
	8178, -13000, -25462, -20855, -2266, 17842, 25989, 16712,
	-3768, -21722, -25114, -11668, 9599, 24432, 22885, 5995,
	-14913, -25824, -19422, 0, 19422, 25824, 14912, -5996,
	-22885, -24431, -9599, 11668, 25114, 21722, 3768, -16712,
	-25989, -17842, 2266, 20855, 25462, 12999, -8178, -23873,
	-23563, -7456, 13649, 25605, 20394, 1511, -18384, -25956,
	-16126, 4514, 22129, 24907, 10987, -10298, -24680, -22516,
	-5257, 15526, 25901, 18911, -756, -19917, -25725, -14287,
	6729, 23234, 24162, 8892, -12339, -25299, -21297, -3018,
	17284, 26000, 17284, -3018, -21298, -25299, -12339, 8892,
	24163, 23234, 6729, -14287, -25725, -19917, -756, 18911,
	25901, 15525, -5257, -22516, -24680, -10297, 10988, 24907,
	22128, 4514, -16126, -25956, -18384, 1511, 20394, 25604,
	13649, -7457, -23564, -23873, -8177, 13000, 25462, 20855,
	2265, -17842, -25988, -16712, 3768, 21722, 25114, 11668,
	-9599, -24432, -22885, -5995, 14913, 25824, 19422, 0,
	-19422, -25824, -14912, 5996, 22885, 24431, 9599, -11668,
	-25114, -21722, -3767, 16712, 25989, 17842, -2266, -20855,
	-25462, -12999, 8178, 23873, 23563, 7456, -13649, -25605,
	-20394, -1511, 18384, 25955, 16125, -4515, -22129, -24907,
	-10987, 10298, 24680, 22516, 5257, -15526, -25901, -18911,
	756, 19917, 25725, 14286, -6729, -23234, -24162, -8892,
	12339, 25299, 21297, 3018, -17284, -26000, -17284, 3018,
	21298, 25299, 12339, -8892, -24163, -23234, -6728, 14287,
	25725, 19916, 755, -18911, -25901, -15525, 5257, 22516,
	24680, 10297, -10988, -24907, -22128, -4514, 16126, 25956},
	},{{

// Carrier 24 Phase 0
	0, 19917, 25605, 13000, -8892, -24432, -22516, -4514,
	16712, 26000, 16712, -4514, -22516, -24432, -8892, 12999,
	25604, 19917, 0, -19917, -25605, -13000, 8892, 24431,
	22516, 4514, -16712, -26000, -16712, 4514, 22516, 24432,
	8892, -12999, -25604, -19917, 0, 19917, 25605, 13000,
	-8892, -24431, -22516, -4514, 16712, 26000, 16712, -4514,
	-22516, -24432, -8892, 12999, 25604, 19917, 0, -19917,
	-25605, -13000, 8892, 24431, 22516, 4514, -16712, -26000,
	-16712, 4514, 22516, 24432, 8892, -12999, -25604, -19917,
	0, 19917, 25605, 13000, -8892, -24431, -22516, -4514,
	16712, 26000, 16712, -4514, -22516, -24432, -8892, 12999,
	25604, 19917, 0, -19917, -25605, -13000, 8892, 24431,
	22516, 4515, -16712, -26000, -16712, 4514, 22516, 24432,
	8892, -12999, -25604, -19917, 0, 19917, 25605, 13000,
	-8892, -24431, -22516, -4515, 16712, 26000, 16712, -4514,
	-22516, -24432, -8892, 12999, 25604, 19917, 0, -19917,
	-25605, -13000, 8892, 24431, 22516, 4515, -16712, -26000,
	-16712, 4514, 22516, 24432, 8892, -12999, -25604, -19917,
	0, 19916, 25605, 13000, -8892, -24431, -22516, -4515,
	16712, 26000, 16712, -4514, -22516, -24432, -8892, 12999,
	25604, 19917, 0, -19916, -25605, -13000, 8892, 24431,
	22516, 4515, -16712, -26000, -16712, 4514, 22516, 24432,
	8892, -12999, -25604, -19917, 0, 19916, 25605, 13000,
	-8892, -24431, -22516, -4515, 16712, 26000, 16712, -4514,
	-22516, -24432, -8892, 12999, 25604, 19917, 0, -19916,
	-25605, -13000, 8892, 24431, 22516, 4515, -16712, -26000,
	-16712, 4514, 22516, 24432, 8892, -12999, -25604, -19917},
	{
// Carrier 24 Phase 1
	18384, 25901, 14912, -6729, -23563, -23564, -6729, 14912,
	25901, 18384, -2266, -21297, -25114, -10988, 10988, 25114,
	21297, 2266, -18384, -25901, -14913, 6729, 23563, 23564,
	6729, -14912, -25901, -18384, 2265, 21297, 25114, 10988,
	-10988, -25114, -21297, -2266, 18384, 25901, 14913, -6729,
	-23563, -23564, -6729, 14912, 25901, 18384, -2265, -21297,
	-25114, -10988, 10987, 25114, 21298, 2266, -18384, -25901,
	-14913, 6729, 23563, 23564, 6729, -14912, -25901, -18384,
	2265, 21297, 25114, 10988, -10987, -25114, -21298, -2266,
	18384, 25901, 14913, -6729, -23563, -23564, -6729, 14912,
	25901, 18384, -2265, -21297, -25114, -10988, 10987, 25114,
	21298, 2266, -18384, -25901, -14913, 6729, 23563, 23564,
	6729, -14912, -25901, -18384, 2265, 21297, 25114, 10988,
	-10987, -25114, -21298, -2266, 18384, 25901, 14913, -6729,
	-23563, -23564, -6729, 14912, 25901, 18384, -2265, -21297,
	-25114, -10988, 10987, 25114, 21298, 2266, -18384, -25901,
	-14913, 6729, 23563, 23564, 6729, -14912, -25901, -18384,
	2265, 21297, 25114, 10988, -10987, -25114, -21298, -2266,
	18384, 25901, 14913, -6729, -23563, -23564, -6729, 14912,
	25901, 18384, -2265, -21297, -25114, -10988, 10987, 25113,
	21298, 2266, -18384, -25901, -14913, 6729, 23563, 23564,
	6729, -14912, -25901, -18384, 2265, 21297, 25114, 10988,
	-10987, -25113, -21298, -2266, 18384, 25901, 14913, -6728,
	-23563, -23564, -6729, 14912, 25901, 18385, -2265, -21297,
	-25114, -10988, 10987, 25113, 21298, 2266, -18384, -25901,
	-14913, 6728, 23563, 23564, 6729, -14912, -25901, -18385,
	2265, 21297, 25114, 10988, -10987, -25113, -21298, -2266},
	{
// Carrier 24 Phase 2
	26000, 16712, -4514, -22516, -24432, -8892, 12999, 25604,
	19917, 0, -19917, -25605, -13000, 8892, 24431, 22516,
	4514, -16712, -26000, -16712, 4514, 22516, 24432, 8892,
	-12999, -25604, -19917, 0, 19917, 25605, 13000, -8892,
	-24431, -22516, -4514, 16712, 26000, 16712, -4514, -22516,
	-24432, -8892, 12999, 25604, 19917, 0, -19917, -25605,
	-13000, 8892, 24431, 22516, 4514, -16712, -26000, -16712,
	4514, 22516, 24432, 8892, -12999, -25604, -19917, 0,
	19917, 25605, 13000, -8892, -24431, -22516, -4514, 16712,
	26000, 16712, -4514, -22516, -24432, -8892, 12999, 25604,
	19917, 0, -19917, -25605, -13000, 8892, 24431, 22516,
	4515, -16712, -26000, -16712, 4514, 22516, 24432, 8892,
	-12999, -25604, -19917, 0, 19917, 25605, 13000, -8892,
	-24431, -22516, -4515, 16712, 26000, 16712, -4514, -22516,
	-24432, -8892, 12999, 25604, 19917, 0, -19917, -25605,
	-13000, 8892, 24431, 22516, 4515, -16712, -26000, -16712,
	4514, 22516, 24432, 8892, -12999, -25604, -19917, 0,
	19917, 25605, 13000, -8892, -24431, -22516, -4515, 16712,
	26000, 16712, -4514, -22516, -24432, -8892, 12999, 25604,
	19917, 0, -19916, -25605, -13000, 8892, 24431, 22516,
	4515, -16712, -26000, -16712, 4514, 22516, 24432, 8892,
	-12999, -25604, -19917, 0, 19916, 25605, 13000, -8892,
	-24431, -22516, -4515, 16712, 26000, 16712, -4514, -22516,
	-24432, -8892, 12999, 25604, 19917, 0, -19916, -25605,
	-13000, 8892, 24431, 22516, 4515, -16712, -26000, -16712,
	4514, 22516, 24432, 8892, -12999, -25604, -19917, 0,
	19916, 25605, 13000, -8892, -24431, -22516, -4515, 16712},
	{
// Carrier 24 Phase 3
	18384, -2266, -21297, -25114, -10988, 10988, 25114, 21297,
	2266, -18384, -25901, -14913, 6729, 23563, 23564, 6729,
	-14912, -25901, -18384, 2266, 21297, 25114, 10988, -10988,
	-25114, -21297, -2266, 18384, 25901, 14913, -6729, -23563,
	-23564, -6729, 14912, 25901, 18384, -2265, -21297, -25114,
	-10988, 10988, 25114, 21297, 2266, -18384, -25901, -14913,
	6729, 23563, 23564, 6729, -14912, -25901, -18384, 2265,
	21297, 25114, 10988, -10987, -25114, -21298, -2266, 18384,
	25901, 14913, -6729, -23563, -23564, -6729, 14912, 25901,
	18384, -2265, -21297, -25114, -10988, 10987, 25114, 21298,
	2266, -18384, -25901, -14913, 6729, 23563, 23564, 6729,
	-14912, -25901, -18384, 2265, 21297, 25114, 10988, -10987,
	-25114, -21298, -2266, 18384, 25901, 14913, -6729, -23563,
	-23564, -6729, 14912, 25901, 18384, -2265, -21297, -25114,
	-10988, 10987, 25114, 21298, 2266, -18384, -25901, -14913,
	6729, 23563, 23564, 6729, -14912, -25901, -18384, 2265,
	21297, 25114, 10988, -10987, -25114, -21298, -2266, 18384,
	25901, 14913, -6729, -23563, -23564, -6729, 14912, 25901,
	18384, -2265, -21297, -25114, -10988, 10987, 25114, 21298,
	2266, -18384, -25901, -14913, 6729, 23563, 23564, 6729,
	-14912, -25901, -18384, 2265, 21297, 25114, 10988, -10987,
	-25113, -21298, -2266, 18384, 25901, 14913, -6729, -23563,
	-23564, -6729, 14912, 25901, 18384, -2265, -21297, -25114,
	-10988, 10987, 25113, 21298, 2266, -18384, -25901, -14913,
	6728, 23563, 23564, 6729, -14912, -25901, -18385, 2265,
	21297, 25114, 10988, -10987, -25113, -21298, -2266, 18384,
	25901, 14913, -6728, -23563, -23564, -6729, 14912, 25901},
	},{{

// Carrier 25 Phase 0
	0, 20394, 25299, 10988, -11668, -25462, -19917, 756,
	20855, 25114, 10298, -12339, -25604, -19422, 1511, 21297,
	24907, 9599, -12999, -25725, -18911, 2266, 21722, 24680,
	8892, -13649, -25824, -18384, 3018, 22129, 24432, 8178,
	-14287, -25901, -17842, 3768, 22516, 24163, 7456, -14912,
	-25956, -17284, 4514, 22885, 23873, 6729, -15526, -25989,
	-16712, 5257, 23234, 23564, 5996, -16126, -26000, -16126,
	5995, 23563, 23234, 5257, -16712, -25989, -15526, 6729,
	23873, 22885, 4514, -17284, -25956, -14913, 7456, 24163,
	22516, 3768, -17842, -25901, -14287, 8178, 24432, 22129,
	3018, -18384, -25824, -13649, 8892, 24680, 21722, 2266,
	-18911, -25725, -13000, 9599, 24907, 21297, 1511, -19422,
	-25605, -12339, 10298, 25114, 20855, 756, -19917, -25462,
	-11668, 10988, 25299, 20394, 0, -20394, -25299, -10988,
	11668, 25462, 19917, -756, -20855, -25114, -10298, 12339,
	25605, 19422, -1511, -21297, -24907, -9599, 13000, 25725,
	18911, -2266, -21722, -24680, -8892, 13649, 25824, 18384,
	-3018, -22129, -24432, -8178, 14287, 25901, 17842, -3768,
	-22516, -24163, -7456, 14913, 25956, 17284, -4514, -22885,
	-23873, -6729, 15526, 25989, 16712, -5257, -23234, -23563,
	-5995, 16126, 26000, 16126, -5996, -23564, -23234, -5257,
	16712, 25989, 15526, -6729, -23873, -22885, -4514, 17284,
	25956, 14912, -7456, -24163, -22516, -3768, 17842, 25901,
	14287, -8178, -24432, -22129, -3018, 18384, 25824, 13649,
	-8892, -24680, -21722, -2265, 18911, 25725, 12999, -9599,
	-24907, -21297, -1511, 19422, 25604, 12339, -10298, -25114,
	-20855, -756, 19917, 25462, 11668, -10988, -25299, -20394},
	{
// Carrier 25 Phase 1
	18384, 25824, 13649, -8892, -24680, -21722, -2266, 18911,
	25725, 13000, -9599, -24907, -21297, -1511, 19422, 25605,
	12339, -10298, -25114, -20855, -756, 19917, 25462, 11668,
	-10988, -25299, -20394, 0, 20394, 25299, 10988, -11668,
	-25462, -19917, 756, 20855, 25114, 10298, -12339, -25604,
	-19422, 1511, 21297, 24907, 9599, -12999, -25725, -18911,
	2266, 21722, 24680, 8892, -13649, -25824, -18384, 3018,
	22129, 24432, 8178, -14287, -25901, -17842, 3768, 22516,
	24163, 7456, -14912, -25956, -17284, 4514, 22885, 23873,
	6729, -15526, -25989, -16712, 5257, 23234, 23564, 5996,
	-16126, -26000, -16126, 5996, 23564, 23234, 5257, -16712,
	-25989, -15526, 6729, 23873, 22885, 4514, -17284, -25956,
	-14912, 7456, 24163, 22516, 3768, -17842, -25901, -14287,
	8178, 24432, 22129, 3018, -18384, -25824, -13649, 8892,
	24680, 21722, 2266, -18911, -25725, -12999, 9599, 24907,
	21297, 1511, -19422, -25604, -12339, 10298, 25114, 20855,
	756, -19917, -25462, -11668, 10988, 25299, 20394, 0,
	-20394, -25299, -10988, 11668, 25462, 19917, -756, -20855,
	-25114, -10298, 12339, 25605, 19422, -1511, -21297, -24907,
	-9599, 13000, 25725, 18911, -2266, -21722, -24680, -8892,
	13649, 25824, 18384, -3018, -22129, -24431, -8178, 14287,
	25901, 17842, -3768, -22516, -24163, -7456, 14913, 25956,
	17284, -4514, -22885, -23873, -6729, 15526, 25989, 16712,
	-5257, -23234, -23563, -5995, 16126, 26000, 16126, -5996,
	-23564, -23234, -5257, 16712, 25988, 15526, -6729, -23873,
	-22885, -4514, 17284, 25956, 14912, -7456, -24163, -22516,
	-3768, 17842, 25901, 14287, -8178, -24432, -22129, -3018},
	{
// Carrier 25 Phase 2
	26000, 16126, -5996, -23563, -23234, -5257, 16712, 25989,
	15526, -6729, -23873, -22885, -4514, 17284, 25956, 14912,
	-7456, -24163, -22516, -3768, 17842, 25901, 14287, -8178,
	-24432, -22129, -3018, 18384, 25824, 13649, -8892, -24680,
	-21722, -2266, 18911, 25725, 12999, -9599, -24907, -21297,
	-1511, 19422, 25604, 12339, -10298, -25114, -20855, -756,
	19917, 25462, 11668, -10988, -25299, -20394, 0, 20394,
	25299, 10988, -11668, -25462, -19917, 756, 20855, 25114,
	10298, -12339, -25605, -19422, 1511, 21297, 24907, 9599,
	-12999, -25725, -18911, 2266, 21722, 24680, 8892, -13649,
	-25824, -18384, 3018, 22129, 24432, 8178, -14287, -25901,
	-17842, 3768, 22516, 24163, 7456, -14912, -25956, -17284,
	4514, 22885, 23873, 6729, -15526, -25989, -16712, 5257,
	23234, 23564, 5996, -16126, -26000, -16126, 5996, 23564,
	23234, 5257, -16712, -25989, -15526, 6729, 23873, 22885,
	4514, -17284, -25956, -14912, 7456, 24163, 22516, 3768,
	-17842, -25901, -14287, 8178, 24432, 22129, 3018, -18384,
	-25824, -13649, 8892, 24680, 21722, 2266, -18911, -25725,
	-12999, 9599, 24907, 21297, 1511, -19422, -25604, -12339,
	10298, 25114, 20855, 756, -19917, -25462, -11668, 10988,
	25299, 20394, 0, -20394, -25299, -10988, 11668, 25462,
	19917, -756, -20855, -25114, -10298, 12339, 25605, 19422,
	-1511, -21297, -24907, -9599, 13000, 25725, 18911, -2266,
	-21722, -24680, -8892, 13649, 25824, 18384, -3018, -22129,
	-24431, -8178, 14287, 25901, 17842, -3768, -22516, -24163,
	-7456, 14913, 25956, 17284, -4514, -22885, -23873, -6729,
	15526, 25989, 16712, -5257, -23234, -23563, -5995, 16126},
	{
// Carrier 25 Phase 3
	18384, -3018, -22129, -24432, -8178, 14287, 25901, 17842,
	-3768, -22516, -24163, -7456, 14912, 25956, 17284, -4514,
	-22885, -23873, -6729, 15526, 25989, 16712, -5257, -23234,
	-23563, -5996, 16126, 26000, 16126, -5996, -23564, -23234,
	-5257, 16712, 25989, 15526, -6729, -23873, -22885, -4514,
	17284, 25956, 14912, -7456, -24163, -22516, -3768, 17842,
	25901, 14287, -8178, -24432, -22129, -3018, 18384, 25824,
	13649, -8892, -24680, -21722, -2266, 18911, 25725, 12999,
	-9599, -24907, -21297, -1511, 19422, 25604, 12339, -10298,
	-25114, -20855, -756, 19917, 25462, 11668, -10988, -25299,
	-20394, 0, 20394, 25299, 10988, -11668, -25462, -19917,
	756, 20855, 25114, 10298, -12339, -25605, -19422, 1511,
	21297, 24907, 9599, -13000, -25725, -18911, 2266, 21722,
	24680, 8892, -13649, -25824, -18384, 3018, 22129, 24432,
	8178, -14287, -25901, -17842, 3768, 22516, 24163, 7456,
	-14913, -25956, -17284, 4514, 22885, 23873, 6729, -15526,
	-25989, -16712, 5257, 23234, 23563, 5995, -16126, -26000,
	-16126, 5996, 23564, 23234, 5257, -16712, -25989, -15526,
	6729, 23873, 22885, 4514, -17284, -25956, -14912, 7456,
	24163, 22516, 3768, -17842, -25901, -14287, 8178, 24432,
	22129, 3018, -18384, -25824, -13649, 8892, 24680, 21722,
	2266, -18911, -25725, -12999, 9599, 24907, 21297, 1511,
	-19422, -25604, -12339, 10298, 25114, 20855, 756, -19917,
	-25462, -11668, 10988, 25299, 20394, 0, -20394, -25299,
	-10988, 11668, 25462, 19917, -756, -20855, -25114, -10298,
	12339, 25605, 19422, -1511, -21297, -24907, -9599, 13000,
	25725, 18911, -2266, -21722, -24680, -8892, 13649, 25824},
	},{{

// Carrier 26 Phase 0
	0, 20855, 24907, 8892, -14287, -25956, -16712, 5996,
	23873, 22516, 3018, -18911, -25604, -11668, 11668, 25605,
	18911, -3018, -22516, -23873, -5995, 16712, 25956, 14287,
	-8892, -24907, -20855, 0, 20855, 24907, 8892, -14287,
	-25956, -16712, 5996, 23873, 22516, 3018, -18911, -25604,
	-11668, 11668, 25605, 18911, -3018, -22516, -23873, -5995,
	16712, 25956, 14287, -8892, -24907, -20855, 0, 20855,
	24907, 8892, -14287, -25956, -16712, 5996, 23873, 22516,
	3018, -18911, -25604, -11668, 11668, 25605, 18911, -3018,
	-22516, -23873, -5995, 16712, 25956, 14287, -8892, -24907,
	-20855, 0, 20855, 24907, 8892, -14287, -25956, -16712,
	5996, 23873, 22516, 3018, -18911, -25604, -11668, 11669,
	25605, 18911, -3018, -22516, -23873, -5995, 16712, 25955,
	14286, -8892, -24907, -20855, 0, 20855, 24907, 8892,
	-14287, -25956, -16712, 5996, 23873, 22516, 3018, -18911,
	-25604, -11668, 11669, 25605, 18911, -3018, -22516, -23873,
	-5995, 16712, 25955, 14286, -8892, -24907, -20854, 0,
	20855, 24907, 8892, -14287, -25956, -16712, 5996, 23873,
	22516, 3018, -18911, -25604, -11668, 11669, 25605, 18911,
	-3018, -22516, -23873, -5995, 16712, 25955, 14286, -8892,
	-24907, -20854, 0, 20855, 24907, 8892, -14287, -25956,
	-16712, 5996, 23873, 22516, 3017, -18912, -25604, -11668,
	11669, 25605, 18911, -3018, -22516, -23873, -5995, 16712,
	25955, 14286, -8892, -24907, -20854, 0, 20855, 24907,
	8892, -14287, -25956, -16712, 5996, 23873, 22516, 3017,
	-18912, -25604, -11668, 11669, 25605, 18911, -3018, -22516,
	-23873, -5995, 16712, 25955, 14286, -8893, -24907, -20854},
	{
// Carrier 26 Phase 1
	18384, 25725, 12339, -10988, -25462, -19422, 2266, 22129,
	24163, 6729, -16126, -25989, -14912, 8178, 24680, 21297,
	756, -20394, -25114, -9599, 13649, 25901, 17284, -5257,
	-23564, -22885, -3768, 18384, 25725, 12339, -10988, -25462,
	-19422, 2266, 22129, 24162, 6729, -16126, -25988, -14912,
	8178, 24680, 21297, 756, -20394, -25114, -9599, 13649,
	25901, 17284, -5257, -23564, -22885, -3768, 18384, 25725,
	12339, -10988, -25462, -19422, 2266, 22129, 24162, 6729,
	-16126, -25988, -14912, 8178, 24680, 21297, 756, -20394,
	-25114, -9599, 13649, 25901, 17284, -5257, -23564, -22885,
	-3768, 18384, 25725, 12339, -10988, -25462, -19422, 2266,
	22129, 24162, 6729, -16126, -25988, -14912, 8178, 24680,
	21297, 755, -20394, -25114, -9599, 13649, 25901, 17284,
	-5257, -23564, -22885, -3767, 18384, 25725, 12339, -10988,
	-25462, -19422, 2266, 22129, 24162, 6728, -16126, -25988,
	-14912, 8178, 24680, 21297, 755, -20395, -25113, -9599,
	13649, 25901, 17284, -5258, -23564, -22885, -3767, 18385,
	25725, 12339, -10988, -25462, -19422, 2266, 22129, 24162,
	6728, -16126, -25988, -14912, 8178, 24680, 21297, 755,
	-20395, -25113, -9598, 13649, 25901, 17284, -5258, -23564,
	-22885, -3767, 18385, 25725, 12339, -10988, -25462, -19422,
	2266, 22129, 24162, 6728, -16126, -25988, -14912, 8178,
	24680, 21297, 755, -20395, -25113, -9598, 13649, 25901,
	17284, -5258, -23564, -22884, -3767, 18385, 25725, 12339,
	-10988, -25462, -19422, 2266, 22129, 24162, 6728, -16126,
	-25988, -14912, 8178, 24680, 21297, 755, -20395, -25113,
	-9598, 13649, 25901, 17284, -5258, -23564, -22884, -3767},
	{
// Carrier 26 Phase 2
	26000, 15526, -7456, -24432, -21722, -1511, 19917, 25299,
	10298, -13000, -25824, -17842, 4514, 23234, 23234, 4514,
	-17842, -25824, -12999, 10298, 25299, 19917, -1511, -21722,
	-24431, -7456, 15526, 26000, 15526, -7456, -24432, -21722,
	-1511, 19917, 25299, 10297, -13000, -25824, -17842, 4514,
	23234, 23234, 4514, -17842, -25824, -12999, 10298, 25299,
	19917, -1511, -21722, -24431, -7456, 15526, 26000, 15526,
	-7457, -24432, -21722, -1511, 19917, 25299, 10297, -13000,
	-25824, -17842, 4515, 23234, 23234, 4514, -17842, -25824,
	-12999, 10298, 25299, 19917, -1511, -21722, -24431, -7456,
	15526, 26000, 15525, -7457, -24432, -21722, -1511, 19917,
	25299, 10297, -13000, -25824, -17842, 4515, 23234, 23234,
	4514, -17842, -25824, -12999, 10298, 25299, 19916, -1512,
	-21722, -24431, -7456, 15526, 26000, 15525, -7457, -24432,
	-21722, -1511, 19917, 25299, 10297, -13000, -25824, -17842,
	4515, 23234, 23234, 4514, -17842, -25824, -12999, 10298,
	25299, 19916, -1512, -21722, -24431, -7456, 15526, 26000,
	15525, -7457, -24432, -21722, -1511, 19917, 25299, 10297,
	-13000, -25824, -17841, 4515, 23234, 23234, 4514, -17842,
	-25824, -12999, 10298, 25299, 19916, -1512, -21722, -24431,
	-7456, 15526, 26000, 15525, -7457, -24432, -21722, -1511,
	19917, 25299, 10297, -13000, -25824, -17841, 4515, 23234,
	23234, 4514, -17842, -25824, -12999, 10298, 25299, 19916,
	-1512, -21722, -24431, -7456, 15526, 26000, 15525, -7457,
	-24432, -21722, -1511, 19917, 25299, 10297, -13000, -25824,
	-17841, 4515, 23234, 23234, 4514, -17842, -25824, -12999,
	10298, 25299, 19916, -1512, -21723, -24431, -7456, 15526},
	{
// Carrier 26 Phase 3
	18384, -3768, -22885, -23563, -5257, 17284, 25901, 13649,
	-9599, -25114, -20394, 756, 21297, 24680, 8178, -14913,
	-25989, -16126, 6729, 24163, 22129, 2265, -19422, -25462,
	-10988, 12339, 25725, 18384, -3768, -22885, -23563, -5257,
	17284, 25901, 13649, -9599, -25114, -20394, 756, 21298,
	24680, 8178, -14913, -25989, -16126, 6729, 24163, 22128,
	2265, -19422, -25462, -10987, 12339, 25725, 18384, -3768,
	-22885, -23563, -5257, 17284, 25901, 13649, -9599, -25114,
	-20394, 756, 21298, 24680, 8177, -14913, -25989, -16125,
	6729, 24163, 22128, 2265, -19422, -25462, -10987, 12339,
	25725, 18384, -3768, -22885, -23563, -5257, 17284, 25901,
	13649, -9599, -25114, -20394, 756, 21298, 24680, 8177,
	-14913, -25989, -16125, 6729, 24163, 22128, 2265, -19422,
	-25462, -10987, 12339, 25725, 18384, -3768, -22885, -23563,
	-5257, 17284, 25901, 13649, -9599, -25114, -20394, 756,
	21298, 24680, 8177, -14913, -25989, -16125, 6729, 24163,
	22128, 2265, -19422, -25462, -10987, 12339, 25725, 18384,
	-3768, -22885, -23563, -5257, 17284, 25901, 13649, -9599,
	-25114, -20394, 756, 21298, 24680, 8177, -14913, -25989,
	-16125, 6729, 24163, 22128, 2265, -19422, -25462, -10987,
	12340, 25725, 18384, -3768, -22885, -23563, -5257, 17285,
	25901, 13648, -9599, -25114, -20394, 756, 21298, 24680,
	8177, -14913, -25989, -16125, 6729, 24163, 22128, 2265,
	-19422, -25462, -10987, 12340, 25725, 18384, -3768, -22885,
	-23563, -5257, 17285, 25901, 13648, -9599, -25114, -20394,
	756, 21298, 24680, 8177, -14913, -25989, -16125, 6729,
	24163, 22128, 2265, -19423, -25462, -10987, 12340, 25725},
	},{{

// Carrier 27 Phase 0
	0, 21297, 24432, 6729, -16712, -25901, -13000, 10988,
	25605, 18384, -4514, -23564, -22516, -2266, 19917, 25114,
	8892, -14912, -26000, -14912, 8892, 25114, 19917, -2266,
	-22516, -23564, -4514, 18384, 25605, 10988, -12999, -25901,
	-16712, 6729, 24432, 21297, 0, -21297, -24432, -6729,
	16712, 25901, 13000, -10988, -25605, -18384, 4514, 23564,
	22516, 2266, -19917, -25114, -8892, 14912, 26000, 14912,
	-8892, -25114, -19917, 2266, 22516, 23564, 4514, -18384,
	-25605, -10988, 12999, 25901, 16712, -6729, -24432, -21297,
	0, 21297, 24432, 6729, -16712, -25901, -13000, 10988,
	25605, 18384, -4514, -23564, -22516, -2266, 19917, 25114,
	8892, -14912, -26000, -14912, 8892, 25114, 19917, -2266,
	-22516, -23564, -4514, 18384, 25605, 10988, -12999, -25901,
	-16712, 6729, 24432, 21297, 0, -21297, -24432, -6729,
	16712, 25901, 13000, -10988, -25605, -18384, 4514, 23564,
	22516, 2266, -19917, -25114, -8892, 14912, 26000, 14912,
	-8892, -25114, -19917, 2266, 22516, 23564, 4514, -18384,
	-25605, -10988, 12999, 25901, 16712, -6729, -24432, -21297,
	0, 21297, 24432, 6729, -16712, -25901, -13000, 10988,
	25605, 18384, -4514, -23564, -22516, -2266, 19917, 25114,
	8892, -14912, -26000, -14912, 8892, 25114, 19917, -2266,
	-22516, -23564, -4514, 18384, 25605, 10988, -12999, -25901,
	-16712, 6729, 24432, 21297, 0, -21297, -24432, -6729,
	16712, 25901, 13000, -10988, -25605, -18384, 4514, 23564,
	22516, 2266, -19917, -25114, -8892, 14912, 26000, 14912,
	-8892, -25114, -19917, 2266, 22516, 23564, 4514, -18384,
	-25605, -10988, 12999, 25901, 16712, -6729, -24432, -21297},
	{
// Carrier 27 Phase 1
	18384, 25605, 10988, -12999, -25901, -16712, 6729, 24432,
	21297, 0, -21297, -24432, -6729, 16712, 25901, 13000,
	-10988, -25605, -18384, 4514, 23564, 22516, 2266, -19917,
	-25114, -8892, 14912, 26000, 14912, -8892, -25114, -19917,
	2266, 22516, 23564, 4514, -18384, -25605, -10988, 12999,
	25901, 16712, -6729, -24432, -21297, 0, 21297, 24432,
	6729, -16712, -25901, -13000, 10988, 25605, 18384, -4514,
	-23564, -22516, -2266, 19917, 25114, 8892, -14912, -26000,
	-14912, 8892, 25114, 19917, -2266, -22516, -23564, -4514,
	18384, 25605, 10988, -12999, -25901, -16712, 6729, 24432,
	21297, 0, -21297, -24432, -6729, 16712, 25901, 13000,
	-10988, -25605, -18384, 4514, 23564, 22516, 2266, -19917,
	-25114, -8892, 14912, 26000, 14912, -8892, -25114, -19917,
	2266, 22516, 23564, 4514, -18384, -25605, -10988, 12999,
	25901, 16712, -6729, -24432, -21297, 0, 21297, 24432,
	6729, -16712, -25901, -13000, 10988, 25605, 18384, -4514,
	-23564, -22516, -2266, 19917, 25114, 8892, -14912, -26000,
	-14912, 8892, 25114, 19917, -2266, -22516, -23564, -4514,
	18384, 25605, 10988, -12999, -25901, -16712, 6729, 24432,
	21297, 0, -21297, -24432, -6729, 16712, 25901, 13000,
	-10988, -25605, -18384, 4514, 23564, 22516, 2266, -19917,
	-25114, -8892, 14912, 26000, 14912, -8892, -25114, -19917,
	2266, 22516, 23564, 4514, -18384, -25605, -10988, 12999,
	25901, 16712, -6729, -24432, -21297, 0, 21297, 24432,
	6729, -16712, -25901, -13000, 10988, 25605, 18384, -4514,
	-23564, -22516, -2266, 19917, 25114, 8892, -14912, -26000,
	-14912, 8892, 25114, 19917, -2266, -22516, -23564, -4514},
	{
// Carrier 27 Phase 2
	26000, 14912, -8892, -25114, -19917, 2266, 22516, 23564,
	4514, -18384, -25605, -10988, 12999, 25901, 16712, -6729,
	-24432, -21297, 0, 21297, 24432, 6729, -16712, -25901,
	-13000, 10988, 25605, 18384, -4514, -23564, -22516, -2266,
	19917, 25114, 8892, -14912, -26000, -14912, 8892, 25114,
	19917, -2266, -22516, -23564, -4514, 18384, 25605, 10988,
	-12999, -25901, -16712, 6729, 24432, 21297, 0, -21297,
	-24432, -6729, 16712, 25901, 13000, -10988, -25605, -18384,
	4514, 23564, 22516, 2266, -19917, -25114, -8892, 14912,
	26000, 14912, -8892, -25114, -19917, 2266, 22516, 23564,
	4514, -18384, -25605, -10988, 12999, 25901, 16712, -6729,
	-24432, -21297, 0, 21297, 24432, 6729, -16712, -25901,
	-13000, 10988, 25605, 18384, -4514, -23564, -22516, -2266,
	19917, 25114, 8892, -14912, -26000, -14912, 8892, 25114,
	19917, -2266, -22516, -23564, -4514, 18384, 25605, 10988,
	-12999, -25901, -16712, 6729, 24432, 21297, 0, -21297,
	-24432, -6729, 16712, 25901, 13000, -10988, -25605, -18384,
	4514, 23564, 22516, 2266, -19917, -25114, -8892, 14912,
	26000, 14912, -8892, -25114, -19917, 2266, 22516, 23564,
	4514, -18384, -25605, -10988, 12999, 25901, 16712, -6729,
	-24432, -21297, 0, 21297, 24432, 6729, -16712, -25901,
	-13000, 10988, 25605, 18384, -4514, -23564, -22516, -2266,
	19917, 25114, 8892, -14912, -26000, -14912, 8892, 25114,
	19917, -2266, -22516, -23564, -4514, 18384, 25605, 10988,
	-12999, -25901, -16712, 6729, 24432, 21297, 0, -21297,
	-24432, -6729, 16712, 25901, 13000, -10988, -25605, -18384,
	4514, 23564, 22516, 2266, -19917, -25114, -8892, 14912},
	{
// Carrier 27 Phase 3
	18384, -4514, -23564, -22516, -2266, 19917, 25114, 8892,
	-14912, -26000, -14912, 8892, 25114, 19917, -2266, -22516,
	-23564, -4514, 18384, 25605, 10988, -12999, -25901, -16712,
	6729, 24432, 21297, 0, -21297, -24432, -6729, 16712,
	25901, 13000, -10988, -25605, -18384, 4514, 23564, 22516,
	2266, -19917, -25114, -8892, 14912, 26000, 14912, -8892,
	-25114, -19917, 2266, 22516, 23564, 4514, -18384, -25605,
	-10988, 12999, 25901, 16712, -6729, -24432, -21297, 0,
	21297, 24432, 6729, -16712, -25901, -13000, 10988, 25605,
	18384, -4514, -23564, -22516, -2266, 19917, 25114, 8892,
	-14912, -26000, -14912, 8892, 25114, 19917, -2266, -22516,
	-23564, -4514, 18384, 25605, 10988, -12999, -25901, -16712,
	6729, 24432, 21297, 0, -21297, -24432, -6729, 16712,
	25901, 13000, -10988, -25605, -18384, 4514, 23564, 22516,
	2266, -19917, -25114, -8892, 14912, 26000, 14912, -8892,
	-25114, -19917, 2266, 22516, 23564, 4514, -18384, -25605,
	-10988, 12999, 25901, 16712, -6729, -24432, -21297, 0,
	21297, 24432, 6729, -16712, -25901, -13000, 10988, 25605,
	18384, -4514, -23564, -22516, -2266, 19917, 25114, 8892,
	-14912, -26000, -14912, 8892, 25114, 19917, -2266, -22516,
	-23564, -4514, 18384, 25605, 10988, -12999, -25901, -16712,
	6729, 24432, 21297, 0, -21297, -24432, -6729, 16712,
	25901, 13000, -10988, -25605, -18384, 4514, 23564, 22516,
	2266, -19917, -25114, -8892, 14912, 26000, 14912, -8892,
	-25114, -19917, 2266, 22516, 23564, 4514, -18384, -25605,
	-10988, 12999, 25901, 16712, -6729, -24432, -21297, 0,
	21297, 24432, 6729, -16712, -25901, -13000, 10988, 25605},
	},{{

// Carrier 28 Phase 0
	0, 21722, 23873, 4514, -18911, -25299, -8892, 15526,
	25956, 13000, -11668, -25824, -16712, 7456, 24907, 19917,
	-3018, -23234, -22516, -1511, 20855, 24432, 5996, -17842,
	-25605, -10298, 14287, 26000, 14287, -10298, -25605, -17842,
	5996, 24432, 20855, -1511, -22516, -23234, -3018, 19917,
	24907, 7456, -16712, -25824, -11668, 13000, 25956, 15526,
	-8892, -25299, -18911, 4514, 23873, 21722, 0, -21722,
	-23873, -4514, 18911, 25299, 8892, -15526, -25956, -12999,
	11668, 25824, 16712, -7456, -24907, -19917, 3018, 23234,
	22516, 1511, -20855, -24432, -5996, 17842, 25604, 10298,
	-14287, -26000, -14287, 10298, 25605, 17842, -5996, -24432,
	-20855, 1511, 22516, 23234, 3018, -19917, -24907, -7456,
	16712, 25824, 11668, -13000, -25956, -15526, 8892, 25299,
	18911, -4514, -23873, -21722, 0, 21722, 23873, 4514,
	-18911, -25299, -8892, 15526, 25956, 12999, -11668, -25824,
	-16712, 7456, 24907, 19917, -3018, -23234, -22516, -1511,
	20855, 24431, 5995, -17842, -25604, -10298, 14287, 26000,
	14287, -10298, -25605, -17842, 5996, 24432, 20855, -1511,
	-22516, -23234, -3018, 19917, 24907, 7456, -16712, -25824,
	-11668, 13000, 25956, 15526, -8892, -25299, -18911, 4514,
	23873, 21722, 0, -21722, -23873, -4514, 18911, 25299,
	8892, -15526, -25956, -12999, 11668, 25824, 16712, -7456,
	-24907, -19917, 3018, 23234, 22516, 1511, -20855, -24431,
	-5995, 17842, 25604, 10298, -14287, -26000, -14287, 10298,
	25605, 17842, -5996, -24432, -20855, 1511, 22516, 23234,
	3018, -19917, -24907, -7456, 16712, 25824, 11668, -13000,
	-25956, -15526, 8892, 25299, 18911, -4514, -23873, -21722},
	{
// Carrier 28 Phase 1
	18384, 25462, 9599, -14912, -25989, -13649, 10988, 25725,
	17284, -6729, -24680, -20394, 2266, 22885, 22885, 2266,
	-20394, -24680, -6729, 17284, 25725, 10988, -13649, -25989,
	-14912, 9599, 25462, 18384, -5257, -24163, -21297, 756,
	22129, 23564, 3768, -19422, -25114, -8178, 16126, 25901,
	12339, -12339, -25901, -16126, 8178, 25114, 19422, -3768,
	-23564, -22129, -756, 21297, 24163, 5257, -18384, -25462,
	-9599, 14912, 25989, 13649, -10988, -25725, -17284, 6729,
	24680, 20394, -2266, -22885, -22885, -2266, 20394, 24680,
	6729, -17284, -25725, -10988, 13649, 25989, 14912, -9599,
	-25462, -18384, 5257, 24163, 21297, -756, -22129, -23563,
	-3768, 19422, 25114, 8178, -16126, -25901, -12339, 12339,
	25901, 16126, -8178, -25114, -19422, 3768, 23564, 22129,
	756, -21297, -24163, -5257, 18384, 25462, 9599, -14913,
	-25989, -13649, 10988, 25725, 17284, -6729, -24680, -20394,
	2266, 22885, 22885, 2266, -20394, -24680, -6729, 17284,
	25725, 10988, -13649, -25989, -14912, 9599, 25462, 18384,
	-5257, -24163, -21297, 756, 22129, 23563, 3768, -19422,
	-25114, -8178, 16126, 25901, 12339, -12339, -25901, -16126,
	8178, 25114, 19422, -3768, -23564, -22129, -756, 21297,
	24163, 5257, -18384, -25462, -9599, 14913, 25989, 13649,
	-10988, -25725, -17284, 6729, 24680, 20394, -2266, -22885,
	-22885, -2266, 20394, 24680, 6729, -17284, -25725, -10988,
	13649, 25989, 14912, -9599, -25462, -18384, 5257, 24163,
	21297, -756, -22129, -23563, -3768, 19422, 25114, 8178,
	-16126, -25901, -12339, 12339, 25901, 16126, -8178, -25114,
	-19422, 3768, 23564, 22129, 756, -21297, -24163, -5257},
	{
// Carrier 28 Phase 2
	26000, 14287, -10298, -25605, -17842, 5996, 24432, 20855,
	-1511, -22516, -23234, -3018, 19917, 24907, 7456, -16712,
	-25824, -11668, 13000, 25956, 15526, -8892, -25299, -18911,
	4514, 23873, 21722, 0, -21722, -23873, -4514, 18911,
	25299, 8892, -15526, -25956, -12999, 11668, 25824, 16712,
	-7456, -24907, -19917, 3018, 23234, 22516, 1511, -20855,
	-24432, -5996, 17842, 25604, 10298, -14287, -26000, -14287,
	10298, 25605, 17842, -5996, -24432, -20855, 1511, 22516,
	23234, 3018, -19917, -24907, -7456, 16712, 25824, 11668,
	-13000, -25956, -15526, 8892, 25299, 18911, -4514, -23873,
	-21722, 0, 21722, 23873, 4514, -18911, -25299, -8892,
	15526, 25956, 12999, -11668, -25824, -16712, 7456, 24907,
	19917, -3018, -23234, -22516, -1511, 20855, 24431, 5995,
	-17842, -25604, -10298, 14287, 26000, 14287, -10298, -25605,
	-17842, 5996, 24432, 20855, -1511, -22516, -23234, -3018,
	19917, 24907, 7456, -16712, -25824, -11668, 13000, 25956,
	15526, -8892, -25299, -18911, 4514, 23873, 21722, 0,
	-21722, -23873, -4514, 18911, 25299, 8892, -15526, -25956,
	-12999, 11668, 25824, 16712, -7456, -24907, -19917, 3018,
	23234, 22516, 1511, -20855, -24431, -5995, 17842, 25604,
	10298, -14287, -26000, -14287, 10298, 25605, 17842, -5996,
	-24432, -20855, 1511, 22516, 23234, 3018, -19917, -24907,
	-7456, 16712, 25824, 11668, -13000, -25956, -15526, 8892,
	25299, 18911, -4514, -23873, -21722, 0, 21722, 23873,
	4514, -18911, -25299, -8892, 15526, 25956, 12999, -11668,
	-25824, -16712, 7456, 24907, 19917, -3018, -23234, -22516,
	-1511, 20855, 24431, 5995, -17842, -25604, -10298, 14287},
	{
// Carrier 28 Phase 3
	18384, -5257, -24163, -21297, 756, 22129, 23564, 3768,
	-19422, -25114, -8178, 16126, 25901, 12339, -12339, -25901,
	-16126, 8178, 25114, 19422, -3768, -23564, -22129, -756,
	21297, 24163, 5257, -18384, -25462, -9599, 14912, 25989,
	13649, -10988, -25725, -17284, 6729, 24680, 20394, -2266,
	-22885, -22885, -2266, 20394, 24680, 6729, -17284, -25725,
	-10988, 13649, 25989, 14912, -9599, -25462, -18384, 5257,
	24163, 21297, -756, -22129, -23563, -3768, 19422, 25114,
	8178, -16126, -25901, -12339, 12339, 25901, 16126, -8178,
	-25114, -19422, 3768, 23564, 22129, 756, -21297, -24163,
	-5257, 18384, 25462, 9599, -14913, -25989, -13649, 10988,
	25725, 17284, -6729, -24680, -20394, 2266, 22885, 22885,
	2266, -20394, -24680, -6729, 17284, 25725, 10988, -13649,
	-25989, -14912, 9599, 25462, 18384, -5257, -24163, -21297,
	756, 22129, 23563, 3768, -19422, -25114, -8178, 16126,
	25901, 12339, -12339, -25901, -16126, 8178, 25114, 19422,
	-3768, -23564, -22129, -756, 21297, 24163, 5257, -18384,
	-25462, -9599, 14913, 25989, 13649, -10988, -25725, -17284,
	6729, 24680, 20394, -2266, -22885, -22885, -2266, 20394,
	24680, 6729, -17284, -25725, -10988, 13649, 25989, 14912,
	-9599, -25462, -18384, 5257, 24163, 21297, -756, -22129,
	-23563, -3768, 19422, 25114, 8178, -16126, -25901, -12339,
	12339, 25901, 16126, -8178, -25114, -19422, 3768, 23564,
	22129, 756, -21297, -24163, -5257, 18384, 25462, 9599,
	-14913, -25989, -13649, 10988, 25725, 17284, -6729, -24680,
	-20394, 2266, 22885, 22885, 2266, -20394, -24680, -6729,
	17284, 25725, 10988, -13649, -25989, -14912, 9599, 25462},
	},{{

// Carrier 29 Phase 0
	0, 22129, 23234, 2266, -20855, -24163, -4514, 19422,
	24907, 6729, -17842, -25462, -8892, 16126, 25824, 10988,
	-14287, -25989, -12999, 12339, 25956, 14912, -10298, -25725,
	-16712, 8178, 25299, 18384, -5996, -24680, -19917, 3768,
	23873, 21297, -1511, -22885, -22516, -756, 21722, 23563,
	3018, -20394, -24431, -5257, 18911, 25114, 7456, -17284,
	-25604, -9599, 15526, 25901, 11668, -13649, -26000, -13649,
	11668, 25901, 15526, -9599, -25605, -17284, 7457, 25114,
	18911, -5257, -24432, -20394, 3018, 23564, 21722, -756,
	-22516, -22885, -1511, 21298, 23873, 3768, -19917, -24680,
	-5995, 18384, 25299, 8177, -16712, -25725, -10297, 14913,
	25956, 12339, -13000, -25989, -14287, 10988, 25824, 16125,
	-8892, -25462, -17842, 6729, 24907, 19422, -4515, -24163,
	-20855, 2266, 23234, 22128, 0, -22129, -23234, -2265,
	20855, 24162, 4514, -19422, -24907, -6729, 17842, 25462,
	8892, -16126, -25824, -10987, 14287, 25988, 12999, -12339,
	-25956, -14912, 10298, 25725, 16712, -8178, -25299, -18384,
	5996, 24680, 19916, -3768, -23873, -21297, 1512, 22885,
	22516, 755, -21722, -23563, -3018, 20395, 24431, 5257,
	-18911, -25113, -7456, 17284, 25604, 9599, -15526, -25901,
	-11668, 13649, 26000, 13649, -11669, -25901, -15525, 9599,
	25605, 17284, -7457, -25114, -18911, 5258, 24432, 20394,
	-3018, -23564, -21722, 756, 22516, 22885, 1511, -21298,
	-23873, -3767, 19917, 24680, 5995, -18385, -25299, -8177,
	16712, 25725, 10297, -14913, -25955, -12339, 13000, 25989,
	14286, -10988, -25824, -16125, 8892, 25462, 17841, -6729,
	-24907, -19422, 4515, 24163, 20854, -2266, -23234, -22128},
	{
// Carrier 29 Phase 1
	18384, 25299, 8178, -16712, -25725, -10298, 14913, 25956,
	12339, -13000, -25989, -14287, 10988, 25824, 16126, -8892,
	-25462, -17842, 6729, 24907, 19422, -4514, -24163, -20855,
	2266, 23234, 22129, 0, -22129, -23234, -2265, 20855,
	24163, 4514, -19422, -24907, -6729, 17842, 25462, 8892,
	-16126, -25824, -10987, 14287, 25988, 12999, -12339, -25956,
	-14912, 10298, 25725, 16712, -8178, -25299, -18384, 5996,
	24680, 19917, -3768, -23873, -21297, 1511, 22885, 22516,
	756, -21722, -23563, -3018, 20394, 24431, 5257, -18911,
	-25114, -7456, 17284, 25604, 9599, -15526, -25901, -11668,
	13649, 26000, 13649, -11668, -25901, -15525, 9599, 25605,
	17284, -7457, -25114, -18911, 5257, 24432, 20394, -3018,
	-23564, -21722, 756, 22516, 22885, 1511, -21298, -23873,
	-3767, 19917, 24680, 5995, -18384, -25299, -8177, 16712,
	25725, 10297, -14913, -25955, -12339, 13000, 25989, 14287,
	-10988, -25824, -16125, 8892, 25462, 17842, -6729, -24907,
	-19422, 4515, 24163, 20855, -2266, -23234, -22128, 0,
	22129, 23234, 2265, -20855, -24162, -4514, 19422, 24907,
	6728, -17842, -25462, -8892, 16126, 25824, 10987, -14287,
	-25988, -12999, 12339, 25956, 14912, -10298, -25725, -16712,
	8178, 25299, 18384, -5996, -24680, -19916, 3768, 23873,
	21297, -1512, -22885, -22516, -755, 21722, 23563, 3018,
	-20395, -24431, -5257, 18912, 25113, 7456, -17285, -25604,
	-9598, 15526, 25901, 11668, -13649, -26000, -13649, 11669,
	25901, 15525, -9599, -25605, -17284, 7457, 25114, 18911,
	-5258, -24432, -20394, 3018, 23564, 21722, -756, -22516,
	-22885, -1511, 21298, 23873, 3767, -19917, -24680, -5995},
	{
// Carrier 29 Phase 2
	26000, 13649, -11668, -25901, -15526, 9599, 25605, 17284,
	-7456, -25114, -18911, 5257, 24432, 20394, -3018, -23564,
	-21722, 756, 22516, 22885, 1511, -21297, -23873, -3768,
	19917, 24680, 5995, -18384, -25299, -8178, 16712, 25725,
	10298, -14913, -25956, -12339, 13000, 25989, 14287, -10988,
	-25824, -16126, 8892, 25462, 17842, -6729, -24907, -19422,
	4514, 24163, 20855, -2266, -23234, -22128, 0, 22129,
	23234, 2265, -20855, -24162, -4514, 19422, 24907, 6729,
	-17842, -25462, -8892, 16126, 25824, 10987, -14287, -25988,
	-12999, 12339, 25956, 14912, -10298, -25725, -16712, 8178,
	25299, 18384, -5996, -24680, -19917, 3768, 23873, 21297,
	-1511, -22885, -22516, -756, 21722, 23563, 3018, -20394,
	-24431, -5257, 18911, 25114, 7456, -17284, -25604, -9599,
	15526, 25901, 11668, -13649, -26000, -13649, 11669, 25901,
	15525, -9599, -25605, -17284, 7457, 25114, 18911, -5257,
	-24432, -20394, 3018, 23564, 21722, -756, -22516, -22885,
	-1511, 21298, 23873, 3767, -19917, -24680, -5995, 18385,
	25299, 8177, -16712, -25725, -10297, 14913, 25955, 12339,
	-13000, -25989, -14286, 10988, 25824, 16125, -8892, -25462,
	-17842, 6729, 24907, 19422, -4515, -24163, -20854, 2266,
	23234, 22128, 0, -22129, -23234, -2265, 20855, 24162,
	4514, -19422, -24907, -6728, 17842, 25462, 8892, -16126,
	-25824, -10987, 14287, 25988, 12999, -12339, -25956, -14912,
	10298, 25725, 16712, -8178, -25299, -18384, 5996, 24680,
	19916, -3768, -23873, -21297, 1512, 22885, 22516, 755,
	-21722, -23563, -3017, 20395, 24431, 5257, -18912, -25113,
	-7456, 17285, 25604, 9598, -15526, -25901, -11668, 13649},
	{
// Carrier 29 Phase 3
	18384, -5996, -24680, -19917, 3768, 23873, 21297, -1511,
	-22885, -22516, -756, 21722, 23563, 3018, -20394, -24431,
	-5257, 18911, 25114, 7456, -17284, -25604, -9599, 15526,
	25901, 11668, -13649, -26000, -13649, 11668, 25901, 15526,
	-9599, -25605, -17284, 7456, 25114, 18911, -5257, -24432,
	-20394, 3018, 23564, 21722, -756, -22516, -22885, -1511,
	21298, 23873, 3768, -19917, -24680, -5995, 18384, 25299,
	8178, -16712, -25725, -10297, 14913, 25956, 12339, -13000,
	-25989, -14287, 10988, 25824, 16125, -8892, -25462, -17842,
	6729, 24907, 19422, -4515, -24163, -20855, 2266, 23234,
	22128, 0, -22129, -23234, -2265, 20855, 24162, 4514,
	-19422, -24907, -6729, 17842, 25462, 8892, -16126, -25824,
	-10987, 14287, 25988, 12999, -12339, -25956, -14912, 10298,
	25725, 16712, -8178, -25299, -18384, 5996, 24680, 19916,
	-3768, -23873, -21297, 1512, 22885, 22516, 755, -21722,
	-23563, -3018, 20394, 24431, 5257, -18911, -25113, -7456,
	17284, 25604, 9599, -15526, -25901, -11668, 13649, 26000,
	13649, -11669, -25901, -15525, 9599, 25605, 17284, -7457,
	-25114, -18911, 5257, 24432, 20394, -3018, -23564, -21722,
	756, 22516, 22885, 1511, -21298, -23873, -3767, 19917,
	24680, 5995, -18385, -25299, -8177, 16712, 25725, 10297,
	-14913, -25955, -12339, 13000, 25989, 14286, -10988, -25824,
	-16125, 8892, 25462, 17841, -6729, -24907, -19422, 4515,
	24163, 20854, -2266, -23234, -22128, 0, 22129, 23234,
	2265, -20855, -24162, -4514, 19422, 24907, 6728, -17842,
	-25462, -8892, 16126, 25824, 10987, -14287, -25988, -12999,
	12340, 25956, 14912, -10298, -25725, -16712, 8178, 25299},
	},{{

// Carrier 30 Phase 0
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22516,
	0, 22516, 22516, 0, -22516, -22516, 0, 22516,
	22516, 0, -22516, -22516, 0, 22516, 22516, 0,
	-22516, -22516, 0, 22516, 22516, 0, -22516, -22517,
	0, 22516, 22517, 0, -22516, -22517, 0, 22516,
	22517, 0, -22516, -22517, 0, 22516, 22517, 0,
	-22516, -22517, 0, 22516, 22517, 0, -22516, -22517,
	0, 22516, 22517, 0, -22516, -22517, 0, 22516,
	22517, 0, -22516, -22517, 0, 22516, 22517, 0,
	-22516, -22517, 0, 22516, 22517, 0, -22516, -22517},
	{
// Carrier 30 Phase 1
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729,
	18384, 25114, 6729, -18384, -25114, -6729, 18384, 25114,
	6729, -18384, -25114, -6729, 18384, 25114, 6729, -18384,
	-25114, -6729, 18384, 25114, 6729, -18384, -25114, -6729},
	{
// Carrier 30 Phase 2
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999,
	26000, 13000, -12999, -26000, -13000, 12999, 26000, 13000,
	-12999, -26000, -13000, 12999, 26000, 13000, -12999, -26000,
	-13000, 12999, 26000, 13000, -12999, -26000, -13000, 12999},
	{
// Carrier 30 Phase 3
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25114, 18384, -6729, -25114, -18384,
	6729, 25114, 18384, -6729, -25114, -18384, 6729, 25114,
	18384, -6729, -25114, -18384, 6729, 25114, 18384, -6729,
	-25114, -18384, 6729, 25113, 18384, -6729, -25113, -18384,
	6729, 25113, 18384, -6729, -25113, -18384, 6729, 25113,
	18384, -6729, -25113, -18384, 6728, 25113, 18384, -6728,
	-25113, -18385, 6728, 25113, 18385, -6728, -25113, -18385,
	6728, 25113, 18385, -6728, -25113, -18385, 6728, 25113,
	18385, -6728, -25113, -18385, 6728, 25113, 18385, -6728,
	-25113, -18385, 6728, 25113, 18385, -6728, -25113, -18385,
	6728, 25113, 18385, -6728, -25113, -18385, 6728, 25113,
	18385, -6728, -25113, -18385, 6728, 25113, 18385, -6728,
	-25113, -18385, 6728, 25113, 18385, -6728, -25113, -18385,
	6728, 25113, 18385, -6728, -25113, -18385, 6728, 25113},
	},{{

// Carrier 31 Phase 0
	0, 22885, 21722, -2266, -23873, -20394, 4514, 24680,
	18911, -6729, -25299, -17284, 8892, 25725, 15526, -10988,
	-25956, -13649, 13000, 25989, 11668, -14913, -25824, -9599,
	16712, 25462, 7456, -18384, -24907, -5257, 19917, 24163,
	3018, -21297, -23234, -756, 22516, 22128, -1511, -23564,
	-20855, 3768, 24432, 19422, -5996, -25114, -17842, 8178,
	25605, 16126, -10298, -25901, -14287, 12339, 26000, 12339,
	-14287, -25901, -10297, 16126, 25604, 8178, -17842, -25114,
	-5995, 19422, 24431, 3768, -20855, -23563, -1511, 22129,
	22516, -756, -23234, -21297, 3018, 24163, 19917, -5257,
	-24907, -18384, 7457, 25462, 16712, -9599, -25824, -14912,
	11668, 25989, 12999, -13649, -25956, -10987, 15526, 25725,
	8892, -17284, -25299, -6729, 18911, 24680, 4514, -20394,
	-23873, -2265, 21722, 22885, 0, -22885, -21722, 2266,
	23873, 20394, -4515, -24680, -18911, 6729, 25299, 17284,
	-8892, -25725, -15525, 10988, 25956, 13649, -13000, -25988,
	-11668, 14913, 25824, 9599, -16712, -25462, -7456, 18384,
	24907, 5257, -19917, -24162, -3018, 21298, 23234, 755,
	-22516, -22128, 1512, 23564, 20855, -3768, -24432, -19422,
	5996, 25114, 17842, -8178, -25605, -16125, 10298, 25901,
	14287, -12339, -26000, -12339, 14287, 25901, 10297, -16126,
	-25604, -8177, 17842, 25113, 5995, -19422, -24431, -3767,
	20855, 23563, 1511, -22129, -22516, 756, 23234, 21297,
	-3018, -24163, -19916, 5257, 24907, 18384, -7457, -25462,
	-16712, 9599, 25824, 14912, -11669, -25989, -12999, 13649,
	25955, 10987, -15526, -25725, -8892, 17284, 25299, 6728,
	-18911, -24680, -4514, 20395, 23873, 2265, -21722, -22885},
	{
// Carrier 31 Phase 1
	18384, 24907, 5257, -19917, -24163, -3018, 21297, 23234,
	756, -22516, -22129, 1511, 23564, 20855, -3768, -24432,
	-19422, 5996, 25114, 17842, -8178, -25605, -16126, 10298,
	25901, 14287, -12339, -26000, -12339, 14287, 25901, 10298,
	-16126, -25604, -8178, 17842, 25114, 5995, -19422, -24431,
	-3768, 20855, 23563, 1511, -22129, -22516, 756, 23234,
	21297, -3018, -24163, -19917, 5257, 24907, 18384, -7456,
	-25462, -16712, 9599, 25824, 14912, -11668, -25989, -12999,
	13649, 25956, 10987, -15526, -25725, -8892, 17284, 25299,
	6729, -18911, -24680, -4514, 20394, 23873, 2265, -21722,
	-22885, 0, 22885, 21722, -2266, -23873, -20394, 4514,
	24680, 18911, -6729, -25299, -17284, 8892, 25725, 15525,
	-10988, -25956, -13649, 13000, 25988, 11668, -14913, -25824,
	-9599, 16712, 25462, 7456, -18384, -24907, -5257, 19917,
	24162, 3018, -21298, -23234, -756, 22516, 22128, -1511,
	-23564, -20855, 3768, 24432, 19422, -5996, -25114, -17842,
	8178, 25605, 16125, -10298, -25901, -14287, 12339, 26000,
	12339, -14287, -25901, -10297, 16126, 25604, 8177, -17842,
	-25114, -5995, 19422, 24431, 3767, -20855, -23563, -1511,
	22129, 22516, -756, -23234, -21297, 3018, 24163, 19916,
	-5257, -24907, -18384, 7457, 25462, 16712, -9599, -25824,
	-14912, 11669, 25989, 12999, -13649, -25955, -10987, 15526,
	25725, 8892, -17284, -25299, -6729, 18911, 24680, 4514,
	-20395, -23873, -2265, 21722, 22885, 0, -22885, -21722,
	2266, 23873, 20394, -4515, -24680, -18911, 6729, 25299,
	17284, -8892, -25725, -15525, 10988, 25956, 13649, -13000,
	-25988, -11668, 14913, 25824, 9599, -16712, -25462, -7456},
	{
// Carrier 31 Phase 2
	26000, 12339, -14287, -25901, -10298, 16126, 25605, 8178,
	-17842, -25114, -5996, 19422, 24432, 3768, -20855, -23563,
	-1511, 22129, 22516, -756, -23234, -21297, 3018, 24163,
	19917, -5257, -24907, -18384, 7456, 25462, 16712, -9599,
	-25824, -14912, 11668, 25989, 12999, -13649, -25956, -10988,
	15526, 25725, 8892, -17284, -25299, -6729, 18911, 24680,
	4514, -20394, -23873, -2265, 21722, 22885, 0, -22885,
	-21722, 2266, 23873, 20394, -4514, -24680, -18911, 6729,
	25299, 17284, -8892, -25725, -15526, 10988, 25956, 13649,
	-13000, -25988, -11668, 14913, 25824, 9599, -16712, -25462,
	-7456, 18384, 24907, 5257, -19917, -24162, -3018, 21298,
	23234, 756, -22516, -22128, 1511, 23564, 20855, -3768,
	-24432, -19422, 5996, 25114, 17842, -8178, -25605, -16125,
	10298, 25901, 14287, -12339, -26000, -12339, 14287, 25901,
	10297, -16126, -25604, -8177, 17842, 25114, 5995, -19422,
	-24431, -3768, 20855, 23563, 1511, -22129, -22516, 756,
	23234, 21297, -3018, -24163, -19917, 5257, 24907, 18384,
	-7457, -25462, -16712, 9599, 25824, 14912, -11668, -25989,
	-12999, 13649, 25955, 10987, -15526, -25725, -8892, 17284,
	25299, 6729, -18911, -24680, -4514, 20394, 23873, 2265,
	-21722, -22885, 0, 22885, 21722, -2266, -23873, -20394,
	4515, 24680, 18911, -6729, -25299, -17284, 8892, 25725,
	15525, -10988, -25956, -13649, 13000, 25988, 11668, -14913,
	-25824, -9599, 16712, 25462, 7456, -18385, -24907, -5257,
	19917, 24162, 3018, -21298, -23234, -755, 22516, 22128,
	-1512, -23564, -20855, 3768, 24432, 19422, -5996, -25114,
	-17842, 8178, 25605, 16125, -10298, -25901, -14286, 12339},
	{
// Carrier 31 Phase 3
	18384, -7456, -25462, -16712, 9599, 25824, 14912, -11668,
	-25989, -12999, 13649, 25956, 10988, -15526, -25725, -8892,
	17284, 25299, 6729, -18911, -24680, -4514, 20394, 23873,
	2266, -21722, -22885, 0, 22885, 21722, -2266, -23873,
	-20394, 4514, 24680, 18911, -6729, -25299, -17284, 8892,
	25725, 15526, -10988, -25956, -13649, 13000, 25988, 11668,
	-14913, -25824, -9599, 16712, 25462, 7456, -18384, -24907,
	-5257, 19917, 24162, 3018, -21298, -23234, -756, 22516,
	22128, -1511, -23564, -20855, 3768, 24432, 19422, -5996,
	-25114, -17842, 8178, 25605, 16126, -10298, -25901, -14287,
	12339, 26000, 12339, -14287, -25901, -10297, 16126, 25604,
	8178, -17842, -25114, -5995, 19422, 24431, 3768, -20855,
	-23563, -1511, 22129, 22516, -756, -23234, -21297, 3018,
	24163, 19917, -5257, -24907, -18384, 7457, 25462, 16712,
	-9599, -25824, -14912, 11668, 25989, 12999, -13649, -25956,
	-10987, 15526, 25725, 8892, -17284, -25299, -6729, 18911,
	24680, 4514, -20394, -23873, -2265, 21722, 22885, 0,
	-22885, -21722, 2266, 23873, 20394, -4515, -24680, -18911,
	6729, 25299, 17284, -8892, -25725, -15525, 10988, 25956,
	13649, -13000, -25988, -11668, 14913, 25824, 9599, -16712,
	-25462, -7456, 18384, 24907, 5257, -19917, -24162, -3018,
	21298, 23234, 755, -22516, -22128, 1512, 23564, 20855,
	-3768, -24432, -19422, 5996, 25114, 17842, -8178, -25605,
	-16125, 10298, 25901, 14286, -12339, -26000, -12339, 14287,
	25901, 10297, -16126, -25604, -8177, 17842, 25113, 5995,
	-19422, -24431, -3767, 20855, 23563, 1511, -22129, -22516,
	756, 23234, 21297, -3018, -24163, -19916, 5258, 24907},
	},{{

// Carrier 32 Phase 0
	0, 23234, 20855, -4514, -24907, -17842, 8892, 25824,
	14287, -13000, -25956, -10298, 16712, 25299, 5995, -19917,
	-23873, -1511, 22516, 21722, -3018, -24432, -18911, 7456,
	25605, 15526, -11668, -26000, -11668, 15526, 25604, 7456,
	-18911, -24431, -3018, 21722, 22516, -1511, -23873, -19917,
	5996, 25299, 16712, -10298, -25956, -12999, 14287, 25824,
	8892, -17842, -24907, -4514, 20855, 23234, 0, -23234,
	-20855, 4514, 24907, 17842, -8892, -25824, -14287, 13000,
	25956, 10297, -16712, -25299, -5995, 19917, 23873, 1511,
	-22516, -21722, 3018, 24432, 18911, -7457, -25605, -15525,
	11668, 26000, 11668, -15526, -25604, -7456, 18911, 24431,
	3018, -21722, -22516, 1511, 23873, 19917, -5996, -25299,
	-16712, 10298, 25956, 12999, -14287, -25824, -8892, 17842,
	24907, 4514, -20855, -23234, 0, 23234, 20855, -4515,
	-24907, -17842, 8892, 25824, 14287, -13000, -25955, -10297,
	16712, 25299, 5995, -19917, -23873, -1511, 22516, 21722,
	-3018, -24432, -18911, 7457, 25605, 15525, -11669, -26000,
	-11668, 15526, 25604, 7456, -18911, -24431, -3018, 21722,
	22516, -1512, -23873, -19916, 5996, 25299, 16712, -10298,
	-25956, -12999, 14287, 25824, 8892, -17842, -24907, -4514,
	20855, 23234, 0, -23234, -20854, 4515, 24907, 17842,
	-8892, -25824, -14286, 13000, 25955, 10297, -16712, -25299,
	-5995, 19917, 23873, 1511, -22516, -21722, 3018, 24432,
	18911, -7457, -25605, -15525, 11669, 26000, 11668, -15526,
	-25604, -7456, 18911, 24431, 3018, -21722, -22516, 1512,
	23873, 19916, -5996, -25299, -16712, 10298, 25956, 12999,
	-14287, -25824, -8892, 17842, 24907, 4514, -20855, -23234},
	{
// Carrier 32 Phase 1
	18384, 24680, 3768, -21297, -22885, 756, 23564, 20394,
	-5257, -25114, -17284, 9599, 25901, 13649, -13649, -25901,
	-9599, 17284, 25114, 5257, -20394, -23563, -756, 22885,
	21297, -3768, -24680, -18384, 8178, 25725, 14912, -12339,
	-25988, -10988, 16126, 25462, 6729, -19422, -24163, -2265,
	22129, 22128, -2266, -24163, -19422, 6729, 25462, 16126,
	-10988, -25989, -12339, 14913, 25725, 8178, -18384, -24680,
	-3768, 21298, 22885, -756, -23564, -20394, 5257, 25114,
	17284, -9599, -25901, -13649, 13649, 25901, 9599, -17284,
	-25114, -5257, 20394, 23563, 756, -22885, -21297, 3768,
	24680, 18384, -8178, -25725, -14912, 12339, 25988, 10987,
	-16126, -25462, -6729, 19422, 24162, 2265, -22129, -22128,
	2266, 24163, 19422, -6729, -25462, -16125, 10988, 25989,
	12339, -14913, -25725, -8177, 18384, 24680, 3767, -21298,
	-22885, 756, 23564, 20394, -5257, -25114, -17284, 9599,
	25901, 13649, -13649, -25901, -9599, 17284, 25114, 5257,
	-20394, -23563, -755, 22885, 21297, -3768, -24680, -18384,
	8178, 25725, 14912, -12339, -25988, -10987, 16126, 25462,
	6728, -19422, -24162, -2265, 22129, 22128, -2266, -24163,
	-19422, 6729, 25462, 16125, -10988, -25989, -12339, 14913,
	25725, 8177, -18385, -24680, -3767, 21298, 22885, -756,
	-23564, -20394, 5258, 25114, 17284, -9599, -25901, -13649,
	13649, 25901, 9598, -17284, -25113, -5257, 20395, 23563,
	755, -22885, -21297, 3768, 24680, 18384, -8178, -25725,
	-14912, 12339, 25988, 10987, -16126, -25462, -6728, 19422,
	24162, 2265, -22129, -22128, 2266, 24163, 19422, -6729,
	-25462, -16125, 10988, 25989, 12339, -14913, -25725, -8177},
	{
// Carrier 32 Phase 2
	26000, 11668, -15526, -25605, -7456, 18911, 24432, 3018,
	-21722, -22516, 1511, 23873, 19917, -5996, -25299, -16712,
	10298, 25956, 12999, -14287, -25824, -8892, 17842, 24907,
	4514, -20855, -23234, 0, 23234, 20855, -4514, -24907,
	-17842, 8892, 25824, 14287, -13000, -25956, -10298, 16712,
	25299, 5995, -19917, -23873, -1511, 22516, 21722, -3018,
	-24432, -18911, 7456, 25605, 15526, -11668, -26000, -11668,
	15526, 25604, 7456, -18911, -24431, -3018, 21722, 22516,
	-1511, -23873, -19917, 5996, 25299, 16712, -10298, -25956,
	-12999, 14287, 25824, 8892, -17842, -24907, -4514, 20855,
	23234, 0, -23234, -20855, 4515, 24907, 17842, -8892,
	-25824, -14287, 13000, 25956, 10297, -16712, -25299, -5995,
	19917, 23873, 1511, -22516, -21722, 3018, 24432, 18911,
	-7457, -25605, -15525, 11668, 26000, 11668, -15526, -25604,
	-7456, 18911, 24431, 3018, -21722, -22516, 1512, 23873,
	19917, -5996, -25299, -16712, 10298, 25956, 12999, -14287,
	-25824, -8892, 17842, 24907, 4514, -20855, -23234, 0,
	23234, 20855, -4515, -24907, -17842, 8892, 25824, 14286,
	-13000, -25955, -10297, 16712, 25299, 5995, -19917, -23873,
	-1511, 22516, 21722, -3018, -24432, -18911, 7457, 25605,
	15525, -11669, -26000, -11668, 15526, 25604, 7456, -18911,
	-24431, -3018, 21722, 22516, -1512, -23873, -19916, 5996,
	25299, 16712, -10298, -25956, -12999, 14287, 25824, 8892,
	-17842, -24907, -4514, 20855, 23234, 0, -23234, -20854,
	4515, 24907, 17841, -8892, -25824, -14286, 13000, 25955,
	10297, -16712, -25299, -5995, 19917, 23873, 1511, -22516,
	-21722, 3018, 24432, 18911, -7457, -25605, -15525, 11669},
	{
// Carrier 32 Phase 3
	18384, -8178, -25725, -14912, 12339, 25989, 10988, -16126,
	-25462, -6729, 19422, 24163, 2266, -22129, -22129, 2266,
	24163, 19422, -6729, -25462, -16126, 10988, 25989, 12339,
	-14913, -25725, -8178, 18384, 24680, 3768, -21297, -22885,
	756, 23564, 20394, -5257, -25114, -17284, 9599, 25901,
	13649, -13649, -25901, -9599, 17284, 25114, 5257, -20394,
	-23563, -756, 22885, 21297, -3768, -24680, -18384, 8178,
	25725, 14912, -12339, -25988, -10987, 16126, 25462, 6729,
	-19422, -24162, -2265, 22129, 22128, -2266, -24163, -19422,
	6729, 25462, 16125, -10988, -25989, -12339, 14913, 25725,
	8178, -18384, -24680, -3768, 21298, 22885, -756, -23564,
	-20394, 5257, 25114, 17284, -9599, -25901, -13649, 13649,
	25901, 9599, -17284, -25114, -5257, 20394, 23563, 755,
	-22885, -21297, 3768, 24680, 18384, -8178, -25725, -14912,
	12339, 25988, 10987, -16126, -25462, -6729, 19422, 24162,
	2265, -22129, -22128, 2266, 24163, 19422, -6729, -25462,
	-16125, 10988, 25989, 12339, -14913, -25725, -8177, 18384,
	24680, 3767, -21298, -22885, 756, 23564, 20394, -5257,
	-25114, -17284, 9599, 25901, 13649, -13649, -25901, -9599,
	17284, 25113, 5257, -20395, -23563, -755, 22885, 21297,
	-3768, -24680, -18384, 8178, 25725, 14912, -12339, -25988,
	-10987, 16126, 25462, 6728, -19422, -24162, -2265, 22129,
	22128, -2266, -24163, -19422, 6729, 25462, 16125, -10988,
	-25989, -12339, 14913, 25725, 8177, -18385, -24680, -3767,
	21298, 22885, -756, -23564, -20394, 5258, 25114, 17284,
	-9599, -25901, -13649, 13649, 25901, 9598, -17285, -25113,
	-5257, 20395, 23563, 755, -22885, -21297, 3768, 24680},
	},{{

// Carrier 33 Phase 0
	0, 23564, 19917, -6729, -25605, -14912, 13000, 25901,
	8892, -18384, -24432, -2266, 22516, 21297, -4514, -25114,
	-16712, 10988, 26000, 10988, -16712, -25114, -4514, 21297,
	22516, -2266, -24432, -18384, 8892, 25901, 12999, -14913,
	-25604, -6729, 19917, 23563, 0, -23564, -19917, 6729,
	25605, 14912, -13000, -25901, -8892, 18384, 24431, 2265,
	-22516, -21297, 4515, 25114, 16712, -10988, -26000, -10987,
	16712, 25114, 4514, -21298, -22516, 2266, 24432, 18384,
	-8892, -25901, -12999, 14913, 25604, 6729, -19917, -23563,
	0, 23564, 19916, -6729, -25605, -14912, 13000, 25901,
	8892, -18384, -24431, -2265, 22516, 21297, -4515, -25114,
	-16712, 10988, 26000, 10987, -16712, -25113, -4514, 21298,
	22516, -2266, -24432, -18384, 8892, 25901, 12999, -14913,
	-25604, -6728, 19917, 23563, 0, -23564, -19916, 6729,
	25605, 14912, -13000, -25901, -8892, 18385, 24431, 2265,
	-22516, -21297, 4515, 25114, 16712, -10988, -26000, -10987,
	16712, 25113, 4514, -21298, -22516, 2266, 24432, 18384,
	-8892, -25901, -12999, 14913, 25604, 6728, -19917, -23563,
	0, 23564, 19916, -6729, -25605, -14912, 13000, 25901,
	8892, -18385, -24431, -2265, 22516, 21297, -4515, -25114,
	-16712, 10988, 26000, 10987, -16712, -25113, -4514, 21298,
	22516, -2266, -24432, -18384, 8893, 25901, 12999, -14913,
	-25604, -6728, 19917, 23563, 0, -23564, -19916, 6729,
	25605, 14912, -13000, -25901, -8891, 18385, 24431, 2265,
	-22516, -21297, 4515, 25114, 16711, -10988, -26000, -10987,
	16713, 25113, 4514, -21298, -22516, 2266, 24432, 18384,
	-8893, -25901, -12999, 14913, 25604, 6728, -19917, -23563},
	{
// Carrier 33 Phase 1
	18384, 24432, 2266, -22516, -21297, 4514, 25114, 16712,
	-10988, -26000, -10988, 16712, 25114, 4514, -21297, -22516,
	2266, 24432, 18384, -8892, -25901, -12999, 14913, 25604,
	6729, -19917, -23563, 0, 23564, 19917, -6729, -25605,
	-14912, 13000, 25901, 8892, -18384, -24431, -2265, 22516,
	21297, -4514, -25114, -16712, 10988, 26000, 10987, -16712,
	-25114, -4514, 21298, 22516, -2266, -24432, -18384, 8892,
	25901, 12999, -14913, -25604, -6729, 19917, 23563, 0,
	-23564, -19917, 6729, 25605, 14912, -13000, -25901, -8892,
	18384, 24431, 2265, -22516, -21297, 4515, 25114, 16712,
	-10988, -26000, -10987, 16712, 25113, 4514, -21298, -22516,
	2266, 24432, 18384, -8892, -25901, -12999, 14913, 25604,
	6728, -19917, -23563, 0, 23564, 19916, -6729, -25605,
	-14912, 13000, 25901, 8892, -18385, -24431, -2265, 22516,
	21297, -4515, -25114, -16712, 10988, 26000, 10987, -16712,
	-25113, -4514, 21298, 22516, -2266, -24432, -18384, 8892,
	25901, 12999, -14913, -25604, -6728, 19917, 23563, 0,
	-23564, -19916, 6729, 25605, 14912, -13000, -25901, -8892,
	18385, 24431, 2265, -22516, -21297, 4515, 25114, 16712,
	-10988, -26000, -10987, 16712, 25113, 4514, -21298, -22516,
	2266, 24432, 18384, -8893, -25901, -12999, 14913, 25604,
	6728, -19917, -23563, 0, 23564, 19916, -6729, -25605,
	-14912, 13000, 25901, 8891, -18385, -24431, -2265, 22516,
	21297, -4515, -25114, -16711, 10988, 26000, 10987, -16712,
	-25113, -4514, 21298, 22516, -2266, -24432, -18384, 8893,
	25901, 12999, -14913, -25604, -6728, 19917, 23563, 0,
	-23564, -19916, 6730, 25605, 14912, -13000, -25900, -8891},
	{
// Carrier 33 Phase 2
	26000, 10988, -16712, -25114, -4514, 21297, 22516, -2266,
	-24432, -18384, 8892, 25901, 12999, -14913, -25604, -6729,
	19917, 23563, 0, -23564, -19917, 6729, 25605, 14912,
	-13000, -25901, -8892, 18384, 24431, 2265, -22516, -21297,
	4514, 25114, 16712, -10988, -26000, -10987, 16712, 25114,
	4514, -21298, -22516, 2266, 24432, 18384, -8892, -25901,
	-12999, 14913, 25604, 6729, -19917, -23563, 0, 23564,
	19917, -6729, -25605, -14912, 13000, 25901, 8892, -18384,
	-24431, -2265, 22516, 21297, -4515, -25114, -16712, 10988,
	26000, 10987, -16712, -25114, -4514, 21298, 22516, -2266,
	-24432, -18384, 8892, 25901, 12999, -14913, -25604, -6729,
	19917, 23563, 0, -23564, -19916, 6729, 25605, 14912,
	-13000, -25901, -8892, 18385, 24431, 2265, -22516, -21297,
	4515, 25114, 16712, -10988, -26000, -10987, 16712, 25113,
	4514, -21298, -22516, 2266, 24432, 18384, -8892, -25901,
	-12999, 14913, 25604, 6728, -19917, -23563, 0, 23564,
	19916, -6729, -25605, -14912, 13000, 25901, 8892, -18385,
	-24431, -2265, 22516, 21297, -4515, -25114, -16712, 10988,
	26000, 10987, -16712, -25113, -4514, 21298, 22516, -2266,
	-24432, -18384, 8893, 25901, 12999, -14913, -25604, -6728,
	19917, 23563, 0, -23564, -19916, 6729, 25605, 14912,
	-13000, -25901, -8891, 18385, 24431, 2265, -22516, -21297,
	4515, 25114, 16712, -10988, -26000, -10987, 16712, 25113,
	4514, -21298, -22516, 2266, 24432, 18384, -8893, -25901,
	-12999, 14913, 25604, 6728, -19917, -23563, 0, 23564,
	19916, -6729, -25605, -14912, 13000, 25901, 8891, -18385,
	-24431, -2265, 22517, 21297, -4515, -25114, -16711, 10988},
	{
// Carrier 33 Phase 3
	18384, -8892, -25901, -13000, 14912, 25604, 6729, -19917,
	-23563, 0, 23564, 19917, -6729, -25605, -14912, 13000,
	25901, 8892, -18384, -24431, -2265, 22516, 21297, -4514,
	-25114, -16712, 10988, 26000, 10987, -16712, -25114, -4514,
	21298, 22516, -2266, -24432, -18384, 8892, 25901, 12999,
	-14913, -25604, -6729, 19917, 23563, 0, -23564, -19917,
	6729, 25605, 14912, -13000, -25901, -8892, 18384, 24431,
	2265, -22516, -21297, 4515, 25114, 16712, -10988, -26000,
	-10987, 16712, 25114, 4514, -21298, -22516, 2266, 24432,
	18384, -8892, -25901, -12999, 14913, 25604, 6729, -19917,
	-23563, 0, 23564, 19916, -6729, -25605, -14912, 13000,
	25901, 8892, -18384, -24431, -2265, 22516, 21297, -4515,
	-25114, -16712, 10988, 26000, 10987, -16712, -25113, -4514,
	21298, 22516, -2266, -24432, -18384, 8892, 25901, 12999,
	-14913, -25604, -6728, 19917, 23563, 0, -23564, -19916,
	6729, 25605, 14912, -13000, -25901, -8892, 18385, 24431,
	2265, -22516, -21297, 4515, 25114, 16712, -10988, -26000,
	-10987, 16712, 25113, 4514, -21298, -22516, 2266, 24432,
	18384, -8892, -25901, -12999, 14913, 25604, 6728, -19917,
	-23563, 0, 23564, 19916, -6729, -25605, -14912, 13000,
	25901, 8892, -18385, -24431, -2265, 22516, 21297, -4515,
	-25114, -16712, 10988, 26000, 10987, -16712, -25113, -4514,
	21298, 22516, -2266, -24432, -18384, 8893, 25901, 12999,
	-14913, -25604, -6728, 19917, 23563, 0, -23564, -19916,
	6729, 25605, 14912, -13000, -25901, -8891, 18385, 24431,
	2265, -22516, -21297, 4515, 25114, 16711, -10988, -26000,
	-10987, 16713, 25113, 4514, -21298, -22516, 2266, 24432},
	},{{

// Carrier 34 Phase 0
	0, 23873, 18911, -8892, -25956, -11668, 16712, 24907,
	3018, -22516, -20855, 5996, 25605, 14287, -14287, -25605,
	-5996, 20855, 22516, -3018, -24907, -16712, 11668, 25956,
	8892, -18911, -23873, 0, 23873, 18911, -8892, -25956,
	-11668, 16712, 24907, 3018, -22516, -20855, 5995, 25604,
	14287, -14287, -25605, -5996, 20855, 22516, -3018, -24907,
	-16712, 11668, 25956, 8892, -18911, -23873, 0, 23873,
	18911, -8892, -25956, -11668, 16712, 24907, 3018, -22516,
	-20855, 5995, 25604, 14287, -14287, -25605, -5996, 20855,
	22516, -3018, -24907, -16712, 11668, 25956, 8892, -18911,
	-23873, 0, 23873, 18911, -8892, -25956, -11668, 16712,
	24907, 3018, -22516, -20855, 5995, 25604, 14287, -14287,
	-25605, -5996, 20855, 22516, -3018, -24907, -16712, 11668,
	25956, 8892, -18911, -23873, 0, 23873, 18911, -8892,
	-25956, -11668, 16712, 24907, 3018, -22516, -20855, 5995,
	25604, 14287, -14287, -25605, -5996, 20855, 22516, -3018,
	-24907, -16712, 11668, 25956, 8892, -18911, -23873, 0,
	23873, 18911, -8892, -25956, -11668, 16712, 24907, 3018,
	-22516, -20855, 5995, 25604, 14287, -14287, -25605, -5996,
	20855, 22516, -3018, -24907, -16712, 11668, 25956, 8892,
	-18911, -23873, 0, 23873, 18911, -8892, -25956, -11668,
	16712, 24907, 3018, -22516, -20855, 5995, 25604, 14287,
	-14287, -25605, -5996, 20855, 22516, -3018, -24907, -16712,
	11668, 25956, 8892, -18911, -23873, 0, 23873, 18911,
	-8892, -25956, -11668, 16712, 24907, 3018, -22516, -20855,
	5995, 25604, 14287, -14287, -25605, -5996, 20855, 22516,
	-3018, -24907, -16712, 11668, 25956, 8892, -18911, -23873},
	{
// Carrier 34 Phase 1
	18384, 24163, 756, -23563, -19422, 8178, 25901, 12339,
	-16126, -25114, -3768, 22129, 21297, -5257, -25462, -14913,
	13649, 25725, 6729, -20394, -22885, 2266, 24680, 17284,
	-10988, -25989, -9599, 18384, 24163, 756, -23563, -19422,
	8178, 25901, 12339, -16126, -25114, -3768, 22129, 21297,
	-5257, -25462, -14913, 13649, 25725, 6729, -20394, -22885,
	2266, 24680, 17284, -10988, -25989, -9599, 18384, 24163,
	756, -23563, -19422, 8178, 25901, 12339, -16126, -25114,
	-3768, 22129, 21297, -5257, -25462, -14913, 13649, 25725,
	6729, -20394, -22885, 2266, 24680, 17284, -10988, -25989,
	-9599, 18384, 24163, 756, -23563, -19422, 8178, 25901,
	12339, -16126, -25114, -3768, 22129, 21297, -5257, -25462,
	-14913, 13649, 25725, 6729, -20394, -22885, 2265, 24680,
	17284, -10988, -25989, -9599, 18384, 24163, 756, -23563,
	-19422, 8178, 25901, 12339, -16126, -25114, -3768, 22129,
	21297, -5257, -25462, -14913, 13649, 25725, 6729, -20394,
	-22885, 2265, 24680, 17284, -10988, -25989, -9599, 18384,
	24163, 756, -23563, -19422, 8178, 25901, 12339, -16126,
	-25114, -3768, 22128, 21297, -5257, -25462, -14913, 13649,
	25725, 6729, -20394, -22885, 2265, 24680, 17284, -10988,
	-25989, -9599, 18384, 24163, 756, -23563, -19422, 8178,
	25901, 12339, -16126, -25114, -3768, 22128, 21298, -5257,
	-25462, -14913, 13649, 25725, 6729, -20394, -22885, 2265,
	24680, 17284, -10987, -25989, -9599, 18384, 24163, 756,
	-23563, -19422, 8178, 25901, 12339, -16126, -25114, -3768,
	22128, 21298, -5257, -25462, -14913, 13649, 25725, 6729,
	-20394, -22885, 2265, 24680, 17284, -10987, -25989, -9599},
	{
// Carrier 34 Phase 2
	26000, 10298, -17842, -24432, -1511, 23234, 19917, -7456,
	-25824, -13000, 15526, 25299, 4514, -21722, -21722, 4514,
	25299, 15526, -12999, -25824, -7456, 19917, 23234, -1511,
	-24432, -17842, 10298, 26000, 10298, -17842, -24432, -1511,
	23234, 19917, -7456, -25824, -13000, 15526, 25299, 4514,
	-21722, -21722, 4514, 25299, 15526, -12999, -25824, -7456,
	19917, 23234, -1511, -24432, -17842, 10298, 26000, 10298,
	-17842, -24432, -1511, 23234, 19917, -7456, -25824, -13000,
	15526, 25299, 4514, -21722, -21722, 4514, 25299, 15526,
	-12999, -25824, -7456, 19917, 23234, -1511, -24431, -17842,
	10298, 26000, 10298, -17842, -24432, -1511, 23234, 19917,
	-7456, -25824, -13000, 15526, 25299, 4514, -21722, -21722,
	4514, 25299, 15526, -12999, -25824, -7456, 19917, 23234,
	-1511, -24431, -17842, 10298, 26000, 10298, -17842, -24432,
	-1511, 23234, 19917, -7456, -25824, -13000, 15526, 25299,
	4514, -21722, -21722, 4514, 25299, 15526, -12999, -25824,
	-7456, 19917, 23234, -1511, -24431, -17842, 10298, 26000,
	10298, -17842, -24432, -1511, 23234, 19917, -7456, -25824,
	-13000, 15526, 25299, 4514, -21722, -21722, 4514, 25299,
	15526, -12999, -25824, -7456, 19917, 23234, -1511, -24431,
	-17842, 10298, 26000, 10298, -17842, -24432, -1511, 23234,
	19917, -7456, -25824, -13000, 15526, 25299, 4514, -21722,
	-21722, 4514, 25299, 15526, -12999, -25824, -7456, 19917,
	23234, -1511, -24431, -17842, 10297, 26000, 10298, -17842,
	-24432, -1511, 23234, 19917, -7456, -25824, -13000, 15526,
	25299, 4514, -21722, -21722, 4514, 25299, 15526, -12999,
	-25824, -7456, 19917, 23234, -1511, -24431, -17842, 10297},
	{
// Carrier 34 Phase 3
	18384, -9599, -25989, -10988, 17284, 24680, 2266, -22885,
	-20394, 6729, 25725, 13649, -14912, -25462, -5257, 21297,
	22129, -3768, -25114, -16126, 12339, 25901, 8178, -19422,
	-23564, 756, 24163, 18384, -9599, -25989, -10988, 17284,
	24680, 2266, -22885, -20394, 6729, 25725, 13649, -14912,
	-25462, -5257, 21297, 22129, -3768, -25114, -16126, 12339,
	25901, 8178, -19422, -23564, 756, 24163, 18384, -9599,
	-25989, -10988, 17284, 24680, 2266, -22885, -20394, 6729,
	25725, 13649, -14912, -25462, -5257, 21297, 22129, -3768,
	-25114, -16126, 12339, 25901, 8178, -19422, -23564, 756,
	24163, 18384, -9599, -25989, -10988, 17284, 24680, 2266,
	-22885, -20394, 6729, 25725, 13649, -14912, -25462, -5257,
	21297, 22129, -3768, -25114, -16126, 12339, 25901, 8178,
	-19422, -23564, 756, 24163, 18384, -9599, -25988, -10988,
	17284, 24680, 2266, -22885, -20394, 6729, 25725, 13649,
	-14912, -25462, -5257, 21297, 22129, -3768, -25114, -16126,
	12339, 25901, 8178, -19422, -23564, 756, 24163, 18384,
	-9599, -25988, -10988, 17284, 24680, 2266, -22885, -20394,
	6729, 25725, 13649, -14912, -25462, -5257, 21297, 22129,
	-3768, -25114, -16126, 12339, 25901, 8178, -19422, -23564,
	756, 24163, 18384, -9599, -25988, -10988, 17284, 24680,
	2266, -22885, -20394, 6729, 25725, 13649, -14912, -25462,
	-5257, 21297, 22129, -3768, -25114, -16126, 12339, 25901,
	8178, -19422, -23564, 756, 24163, 18384, -9599, -25988,
	-10988, 17284, 24680, 2266, -22885, -20394, 6729, 25725,
	13649, -14912, -25462, -5257, 21297, 22129, -3768, -25114,
	-16126, 12339, 25901, 8178, -19422, -23564, 756, 24162},
	},{{

// Carrier 35 Phase 0
	0, 24163, 17842, -10988, -25956, -8178, 19917, 22885,
	-3018, -25114, -15526, 13649, 25604, 5257, -21722, -21297,
	5996, 25725, 12999, -16126, -24907, -2266, 23234, 19422,
	-8892, -25989, -10298, 18384, 23873, -756, -24432, -17284,
	11668, 25901, 7456, -20394, -22516, 3768, 25299, 14912,
	-14287, -25462, -4514, 22129, 20855, -6729, -25824, -12339,
	16712, 24680, 1511, -23564, -18911, 9599, 26000, 9599,
	-18911, -23563, 1511, 24680, 16712, -12339, -25824, -6729,
	20855, 22128, -4514, -25462, -14287, 14913, 25299, 3768,
	-22516, -20394, 7457, 25901, 11668, -17284, -24431, -756,
	23873, 18384, -10298, -25988, -8892, 19422, 23234, -2266,
	-24907, -16125, 13000, 25725, 5995, -21298, -21722, 5257,
	25605, 13649, -15526, -25114, -3018, 22885, 19917, -8178,
	-25956, -10987, 17842, 24162, 0, -24163, -17842, 10988,
	25955, 8177, -19917, -22885, 3018, 25114, 15525, -13649,
	-25604, -5257, 21722, 21297, -5996, -25725, -12999, 16126,
	24907, 2265, -23234, -19422, 8892, 25989, 10297, -18384,
	-23873, 756, 24432, 17284, -11669, -25901, -7456, 20394,
	22516, -3768, -25299, -14912, 14287, 25462, 4514, -22129,
	-20855, 6729, 25824, 12339, -16712, -24680, -1511, 23564,
	18911, -9599, -26000, -9599, 18911, 23563, -1512, -24680,
	-16712, 12339, 25824, 6728, -20855, -22128, 4515, 25462,
	14286, -14913, -25299, -3767, 22516, 20394, -7457, -25901,
	-11668, 17284, 24431, 755, -23873, -18384, 10298, 25988,
	8892, -19422, -23234, 2266, 24907, 16125, -13000, -25725,
	-5995, 21298, 21722, -5258, -25605, -13649, 15526, 25113,
	3018, -22885, -19916, 8178, 25956, 10987, -17842, -24162},
	{
// Carrier 35 Phase 1
	18384, 23873, -756, -24432, -17284, 11668, 25901, 7456,
	-20394, -22516, 3768, 25299, 14912, -14287, -25462, -4514,
	22129, 20855, -6729, -25824, -12339, 16712, 24680, 1511,
	-23564, -18911, 9599, 26000, 9599, -18911, -23563, 1511,
	24680, 16712, -12339, -25824, -6729, 20855, 22128, -4514,
	-25462, -14287, 14913, 25299, 3768, -22516, -20394, 7456,
	25901, 11668, -17284, -24431, -756, 23873, 18384, -10298,
	-25988, -8892, 19422, 23234, -2266, -24907, -16126, 13000,
	25725, 5995, -21298, -21722, 5257, 25605, 13649, -15526,
	-25114, -3018, 22885, 19917, -8178, -25956, -10987, 17842,
	24162, 0, -24163, -17842, 10988, 25956, 8178, -19917,
	-22885, 3018, 25114, 15525, -13649, -25604, -5257, 21722,
	21297, -5996, -25725, -12999, 16126, 24907, 2265, -23234,
	-19422, 8892, 25989, 10297, -18384, -23873, 756, 24432,
	17284, -11668, -25901, -7456, 20394, 22516, -3768, -25299,
	-14912, 14287, 25462, 4514, -22129, -20855, 6729, 25824,
	12339, -16712, -24680, -1511, 23564, 18911, -9599, -26000,
	-9599, 18911, 23563, -1512, -24680, -16712, 12339, 25824,
	6729, -20855, -22128, 4515, 25462, 14286, -14913, -25299,
	-3767, 22516, 20394, -7457, -25901, -11668, 17284, 24431,
	755, -23873, -18384, 10298, 25988, 8892, -19422, -23234,
	2266, 24907, 16125, -13000, -25725, -5995, 21298, 21722,
	-5257, -25605, -13649, 15526, 25113, 3018, -22885, -19916,
	8178, 25956, 10987, -17842, -24162, 0, 24163, 17842,
	-10988, -25955, -8177, 19917, 22885, -3018, -25114, -15525,
	13649, 25604, 5257, -21722, -21297, 5996, 25725, 12999,
	-16126, -24907, -2265, 23234, 19422, -8892, -25989, -10297},
	{
// Carrier 35 Phase 2
	26000, 9599, -18911, -23564, 1511, 24680, 16712, -12339,
	-25824, -6729, 20855, 22129, -4514, -25462, -14287, 14913,
	25299, 3768, -22516, -20394, 7456, 25901, 11668, -17284,
	-24431, -756, 23873, 18384, -10298, -25988, -8892, 19422,
	23234, -2266, -24907, -16126, 13000, 25725, 5995, -21297,
	-21722, 5257, 25605, 13649, -15526, -25114, -3018, 22885,
	19917, -8178, -25956, -10987, 17842, 24162, 0, -24163,
	-17842, 10988, 25956, 8178, -19917, -22885, 3018, 25114,
	15526, -13649, -25604, -5257, 21722, 21297, -5996, -25725,
	-12999, 16126, 24907, 2265, -23234, -19422, 8892, 25989,
	10297, -18384, -23873, 756, 24432, 17284, -11668, -25901,
	-7456, 20394, 22516, -3768, -25299, -14912, 14287, 25462,
	4514, -22129, -20855, 6729, 25824, 12339, -16712, -24680,
	-1511, 23564, 18911, -9599, -26000, -9599, 18911, 23563,
	-1511, -24680, -16712, 12339, 25824, 6729, -20855, -22128,
	4515, 25462, 14287, -14913, -25299, -3767, 22516, 20394,
	-7457, -25901, -11668, 17284, 24431, 755, -23873, -18384,
	10298, 25988, 8892, -19422, -23234, 2266, 24907, 16125,
	-13000, -25725, -5995, 21298, 21722, -5257, -25605, -13649,
	15526, 25113, 3018, -22885, -19916, 8178, 25956, 10987,
	-17842, -24162, 0, 24163, 17842, -10988, -25955, -8177,
	19917, 22885, -3018, -25114, -15525, 13649, 25604, 5257,
	-21722, -21297, 5996, 25725, 12999, -16126, -24907, -2265,
	23234, 19422, -8892, -25989, -10297, 18385, 23873, -756,
	-24432, -17284, 11669, 25901, 7456, -20395, -22516, 3768,
	25299, 14912, -14287, -25462, -4514, 22129, 20854, -6729,
	-25824, -12339, 16712, 24680, 1511, -23564, -18911, 9599},
	{
// Carrier 35 Phase 3
	18384, -10298, -25989, -8892, 19422, 23234, -2266, -24907,
	-16126, 13000, 25725, 5995, -21297, -21722, 5257, 25605,
	13649, -15526, -25114, -3018, 22885, 19917, -8178, -25956,
	-10988, 17842, 24163, 0, -24163, -17842, 10988, 25956,
	8178, -19917, -22885, 3018, 25114, 15526, -13649, -25604,
	-5257, 21722, 21297, -5996, -25725, -12999, 16126, 24907,
	2265, -23234, -19422, 8892, 25989, 10297, -18384, -23873,
	756, 24432, 17284, -11668, -25901, -7456, 20394, 22516,
	-3768, -25299, -14912, 14287, 25462, 4514, -22129, -20855,
	6729, 25824, 12339, -16712, -24680, -1511, 23564, 18911,
	-9599, -26000, -9599, 18911, 23563, -1511, -24680, -16712,
	12339, 25824, 6729, -20855, -22128, 4515, 25462, 14287,
	-14913, -25299, -3768, 22516, 20394, -7457, -25901, -11668,
	17284, 24431, 755, -23873, -18384, 10298, 25988, 8892,
	-19422, -23234, 2266, 24907, 16125, -13000, -25725, -5995,
	21298, 21722, -5257, -25605, -13649, 15526, 25114, 3018,
	-22885, -19916, 8178, 25956, 10987, -17842, -24162, 0,
	24163, 17842, -10988, -25955, -8177, 19917, 22885, -3018,
	-25114, -15525, 13649, 25604, 5257, -21722, -21297, 5996,
	25725, 12999, -16126, -24907, -2265, 23234, 19422, -8892,
	-25989, -10297, 18385, 23873, -756, -24432, -17284, 11669,
	25901, 7456, -20395, -22516, 3768, 25299, 14912, -14287,
	-25462, -4514, 22129, 20854, -6729, -25824, -12339, 16712,
	24680, 1511, -23564, -18911, 9599, 26000, 9599, -18911,
	-23563, 1512, 24680, 16712, -12339, -25824, -6728, 20855,
	22128, -4515, -25462, -14286, 14913, 25299, 3767, -22516,
	-20394, 7457, 25901, 11668, -17284, -24431, -755, 23873},
	},{{

// Carrier 36 Phase 0
	0, 24432, 16712, -12999, -25605, -4514, 22516, 19917,
	-8892, -26000, -8892, 19917, 22516, -4514, -25604, -13000,
	16712, 24432, 0, -24431, -16712, 12999, 25605, 4514,
	-22516, -19917, 8892, 26000, 8892, -19917, -22516, 4514,
	25604, 13000, -16712, -24432, 0, 24431, 16712, -12999,
	-25605, -4514, 22516, 19917, -8892, -26000, -8892, 19917,
	22516, -4514, -25604, -13000, 16712, 24432, 0, -24431,
	-16712, 12999, 25605, 4515, -22516, -19917, 8892, 26000,
	8892, -19917, -22516, 4514, 25604, 13000, -16712, -24432,
	0, 24431, 16712, -12999, -25605, -4515, 22516, 19917,
	-8892, -26000, -8892, 19916, 22516, -4514, -25604, -13000,
	16712, 24432, 0, -24431, -16712, 12999, 25605, 4515,
	-22516, -19917, 8892, 26000, 8892, -19916, -22516, 4514,
	25604, 13000, -16712, -24432, 0, 24431, 16712, -12999,
	-25605, -4515, 22516, 19917, -8892, -26000, -8892, 19916,
	22516, -4514, -25604, -13000, 16712, 24432, 0, -24431,
	-16712, 12999, 25605, 4515, -22516, -19917, 8892, 26000,
	8892, -19916, -22516, 4514, 25604, 13000, -16712, -24432,
	0, 24431, 16712, -12999, -25605, -4515, 22516, 19917,
	-8892, -26000, -8893, 19916, 22516, -4514, -25604, -13000,
	16712, 24432, 0, -24431, -16712, 12999, 25605, 4515,
	-22516, -19917, 8891, 26000, 8893, -19916, -22516, 4514,
	25604, 13000, -16712, -24432, 0, 24431, 16712, -12999,
	-25605, -4515, 22516, 19917, -8891, -26000, -8893, 19916,
	22516, -4514, -25604, -13000, 16711, 24432, 0, -24431,
	-16713, 12999, 25605, 4515, -22516, -19917, 8891, 26000,
	8893, -19916, -22517, 4514, 25604, 13000, -16711, -24432},
	{
// Carrier 36 Phase 1
	18384, 23564, -2266, -25114, -14913, 14912, 25114, 2266,
	-23563, -18384, 10988, 25901, 6729, -21297, -21297, 6729,
	25901, 10988, -18384, -23564, 2265, 25114, 14913, -14912,
	-25114, -2266, 23563, 18384, -10988, -25901, -6729, 21297,
	21298, -6729, -25901, -10988, 18384, 23564, -2265, -25114,
	-14913, 14912, 25114, 2266, -23563, -18384, 10987, 25901,
	6729, -21297, -21298, 6729, 25901, 10988, -18384, -23564,
	2265, 25114, 14913, -14912, -25114, -2266, 23563, 18384,
	-10987, -25901, -6729, 21297, 21298, -6729, -25901, -10988,
	18384, 23564, -2265, -25114, -14913, 14912, 25114, 2266,
	-23563, -18384, 10987, 25901, 6729, -21297, -21298, 6729,
	25901, 10988, -18384, -23564, 2265, 25113, 14913, -14912,
	-25114, -2266, 23563, 18385, -10987, -25901, -6729, 21297,
	21298, -6728, -25901, -10988, 18384, 23564, -2265, -25113,
	-14913, 14912, 25114, 2266, -23563, -18385, 10987, 25901,
	6729, -21297, -21298, 6728, 25901, 10988, -18384, -23564,
	2265, 25113, 14913, -14912, -25114, -2266, 23563, 18385,
	-10987, -25901, -6729, 21297, 21298, -6728, -25901, -10988,
	18384, 23564, -2265, -25113, -14913, 14912, 25114, 2266,
	-23563, -18385, 10987, 25901, 6729, -21297, -21298, 6728,
	25901, 10988, -18384, -23564, 2265, 25113, 14913, -14912,
	-25114, -2266, 23563, 18385, -10987, -25901, -6729, 21297,
	21298, -6728, -25901, -10988, 18384, 23564, -2265, -25113,
	-14913, 14912, 25114, 2266, -23563, -18385, 10987, 25901,
	6729, -21297, -21298, 6728, 25901, 10988, -18384, -23564,
	2265, 25113, 14913, -14912, -25114, -2266, 23563, 18385,
	-10987, -25901, -6729, 21297, 21298, -6728, -25900, -10988},
	{
// Carrier 36 Phase 2
	26000, 8892, -19917, -22516, 4514, 25604, 13000, -16712,
	-24432, 0, 24431, 16712, -12999, -25605, -4514, 22516,
	19917, -8892, -26000, -8892, 19917, 22516, -4514, -25604,
	-13000, 16712, 24432, 0, -24431, -16712, 12999, 25605,
	4514, -22516, -19917, 8892, 26000, 8892, -19917, -22516,
	4514, 25604, 13000, -16712, -24432, 0, 24431, 16712,
	-12999, -25605, -4515, 22516, 19917, -8892, -26000, -8892,
	19917, 22516, -4514, -25604, -13000, 16712, 24432, 0,
	-24431, -16712, 12999, 25605, 4515, -22516, -19917, 8892,
	26000, 8892, -19916, -22516, 4514, 25604, 13000, -16712,
	-24432, 0, 24431, 16712, -12999, -25605, -4515, 22516,
	19917, -8892, -26000, -8892, 19916, 22516, -4514, -25604,
	-13000, 16712, 24432, 0, -24431, -16712, 12999, 25605,
	4515, -22516, -19917, 8892, 26000, 8892, -19916, -22516,
	4514, 25604, 13000, -16712, -24432, 0, 24431, 16712,
	-12999, -25605, -4515, 22516, 19917, -8892, -26000, -8892,
	19916, 22516, -4514, -25604, -13000, 16712, 24432, 0,
	-24431, -16712, 12999, 25605, 4515, -22516, -19917, 8892,
	26000, 8892, -19916, -22516, 4514, 25604, 13000, -16712,
	-24432, 0, 24431, 16712, -12999, -25605, -4515, 22516,
	19917, -8891, -26000, -8893, 19916, 22516, -4514, -25604,
	-13000, 16712, 24432, 0, -24431, -16712, 12999, 25605,
	4515, -22516, -19917, 8891, 26000, 8893, -19916, -22516,
	4514, 25604, 13000, -16711, -24432, 0, 24431, 16712,
	-12999, -25605, -4515, 22516, 19917, -8891, -26000, -8893,
	19916, 22517, -4514, -25604, -13000, 16711, 24432, 0,
	-24431, -16713, 12999, 25605, 4515, -22516, -19917, 8891},
	{
// Carrier 36 Phase 3
	18384, -10988, -25901, -6729, 21297, 21297, -6729, -25901,
	-10988, 18384, 23564, -2265, -25114, -14913, 14912, 25114,
	2266, -23563, -18384, 10988, 25901, 6729, -21297, -21298,
	6729, 25901, 10988, -18384, -23564, 2265, 25114, 14913,
	-14912, -25114, -2266, 23563, 18384, -10987, -25901, -6729,
	21297, 21298, -6729, -25901, -10988, 18384, 23564, -2265,
	-25114, -14913, 14912, 25114, 2266, -23563, -18384, 10987,
	25901, 6729, -21297, -21298, 6729, 25901, 10988, -18384,
	-23564, 2265, 25114, 14913, -14912, -25114, -2266, 23563,
	18384, -10987, -25901, -6729, 21297, 21298, -6729, -25901,
	-10988, 18384, 23564, -2265, -25113, -14913, 14912, 25114,
	2266, -23563, -18385, 10987, 25901, 6729, -21297, -21298,
	6728, 25901, 10988, -18384, -23564, 2265, 25113, 14913,
	-14912, -25114, -2266, 23563, 18385, -10987, -25901, -6729,
	21297, 21298, -6728, -25901, -10988, 18384, 23564, -2265,
	-25113, -14913, 14912, 25114, 2266, -23563, -18385, 10987,
	25901, 6729, -21297, -21298, 6728, 25901, 10988, -18384,
	-23564, 2265, 25113, 14913, -14912, -25114, -2266, 23563,
	18385, -10987, -25901, -6729, 21297, 21298, -6728, -25901,
	-10988, 18384, 23564, -2265, -25113, -14913, 14912, 25114,
	2266, -23563, -18385, 10987, 25901, 6729, -21297, -21298,
	6728, 25901, 10988, -18384, -23564, 2265, 25113, 14913,
	-14912, -25114, -2266, 23563, 18385, -10987, -25901, -6729,
	21297, 21298, -6728, -25901, -10988, 18384, 23564, -2265,
	-25113, -14913, 14912, 25114, 2266, -23563, -18385, 10987,
	25901, 6729, -21297, -21298, 6728, 25901, 10988, -18384,
	-23564, 2265, 25113, 14913, -14912, -25114, -2266, 23563},
	},{{

// Carrier 37 Phase 0
	0, 24680, 15526, -14912, -24907, -756, 24432, 16126,
	-14287, -25114, -1511, 24163, 16712, -13649, -25299, -2266,
	23873, 17284, -12999, -25462, -3018, 23563, 17842, -12339,
	-25605, -3768, 23234, 18384, -11668, -25725, -4514, 22885,
	18911, -10988, -25824, -5257, 22516, 19422, -10298, -25901,
	-5996, 22129, 19917, -9599, -25956, -6729, 21722, 20394,
	-8892, -25989, -7456, 21297, 20855, -8178, -26000, -8178,
	20855, 21297, -7456, -25988, -8892, 20394, 21722, -6729,
	-25956, -9599, 19917, 22129, -5995, -25901, -10298, 19422,
	22516, -5257, -25824, -10988, 18911, 22885, -4514, -25725,
	-11668, 18384, 23234, -3768, -25604, -12339, 17842, 23564,
	-3018, -25462, -13000, 17284, 23873, -2265, -25299, -13649,
	16712, 24163, -1511, -25114, -14287, 16126, 24432, -756,
	-24907, -14913, 15526, 24680, 0, -24680, -15526, 14912,
	24907, 756, -24431, -16126, 14287, 25114, 1511, -24162,
	-16712, 13649, 25299, 2266, -23873, -17284, 12999, 25462,
	3018, -23563, -17842, 12339, 25605, 3768, -23234, -18384,
	11668, 25725, 4514, -22885, -18911, 10987, 25824, 5257,
	-22516, -19422, 10297, 25901, 5996, -22128, -19917, 9599,
	25956, 6729, -21722, -20394, 8892, 25989, 7457, -21297,
	-20855, 8178, 26000, 8178, -20855, -21298, 7456, 25988,
	8892, -20394, -21722, 6729, 25956, 9599, -19917, -22129,
	5995, 25901, 10298, -19422, -22516, 5257, 25824, 10988,
	-18911, -22885, 4514, 25725, 11668, -18384, -23234, 3768,
	25604, 12339, -17842, -23564, 3018, 25462, 13000, -17284,
	-23873, 2265, 25299, 13649, -16712, -24163, 1511, 25114,
	14287, -16125, -24432, 756, 24907, 14913, -15525, -24680},
	{
// Carrier 37 Phase 1
	18384, 23234, -3768, -25604, -12339, 17842, 23564, -3018,
	-25462, -13000, 17284, 23873, -2266, -25299, -13649, 16712,
	24163, -1511, -25114, -14287, 16126, 24432, -756, -24907,
	-14913, 15526, 24680, 0, -24680, -15526, 14912, 24907,
	756, -24431, -16126, 14287, 25114, 1511, -24163, -16712,
	13649, 25299, 2266, -23873, -17284, 12999, 25462, 3018,
	-23563, -17842, 12339, 25605, 3768, -23234, -18384, 11668,
	25725, 4514, -22885, -18911, 10988, 25824, 5257, -22516,
	-19422, 10298, 25901, 5996, -22129, -19917, 9599, 25956,
	6729, -21722, -20394, 8892, 25989, 7456, -21297, -20855,
	8178, 26000, 8178, -20855, -21297, 7456, 25988, 8892,
	-20394, -21722, 6729, 25956, 9599, -19917, -22129, 5995,
	25901, 10298, -19422, -22516, 5257, 25824, 10988, -18911,
	-22885, 4514, 25725, 11668, -18384, -23234, 3768, 25604,
	12339, -17842, -23564, 3018, 25462, 13000, -17284, -23873,
	2265, 25299, 13649, -16712, -24163, 1511, 25114, 14287,
	-16126, -24432, 756, 24907, 14913, -15526, -24680, 0,
	24680, 15526, -14912, -24907, -756, 24431, 16126, -14287,
	-25114, -1511, 24162, 16712, -13649, -25299, -2266, 23873,
	17284, -12999, -25462, -3018, 23563, 17842, -12339, -25605,
	-3768, 23234, 18384, -11668, -25725, -4514, 22885, 18911,
	-10987, -25824, -5257, 22516, 19422, -10297, -25901, -5996,
	22128, 19917, -9599, -25956, -6729, 21722, 20394, -8892,
	-25989, -7457, 21297, 20855, -8178, -26000, -8178, 20855,
	21298, -7456, -25988, -8892, 20394, 21722, -6729, -25956,
	-9599, 19917, 22129, -5995, -25901, -10298, 19422, 22516,
	-5257, -25824, -10988, 18911, 22885, -4514, -25725, -11668},
	{
// Carrier 37 Phase 2
	26000, 8178, -20855, -21297, 7456, 25989, 8892, -20394,
	-21722, 6729, 25956, 9599, -19917, -22129, 5995, 25901,
	10298, -19422, -22516, 5257, 25824, 10988, -18911, -22885,
	4514, 25725, 11668, -18384, -23234, 3768, 25604, 12339,
	-17842, -23564, 3018, 25462, 13000, -17284, -23873, 2266,
	25299, 13649, -16712, -24163, 1511, 25114, 14287, -16126,
	-24432, 756, 24907, 14913, -15526, -24680, 0, 24680,
	15526, -14912, -24907, -756, 24431, 16126, -14287, -25114,
	-1511, 24163, 16712, -13649, -25299, -2266, 23873, 17284,
	-12999, -25462, -3018, 23563, 17842, -12339, -25605, -3768,
	23234, 18384, -11668, -25725, -4514, 22885, 18911, -10988,
	-25824, -5257, 22516, 19422, -10297, -25901, -5996, 22128,
	19917, -9599, -25956, -6729, 21722, 20394, -8892, -25989,
	-7456, 21297, 20855, -8178, -26000, -8178, 20855, 21298,
	-7456, -25988, -8892, 20394, 21722, -6729, -25956, -9599,
	19917, 22129, -5995, -25901, -10298, 19422, 22516, -5257,
	-25824, -10988, 18911, 22885, -4514, -25725, -11668, 18384,
	23234, -3768, -25604, -12339, 17842, 23564, -3018, -25462,
	-13000, 17284, 23873, -2265, -25299, -13649, 16712, 24163,
	-1511, -25114, -14287, 16126, 24432, -756, -24907, -14913,
	15526, 24680, 0, -24680, -15526, 14912, 24907, 756,
	-24431, -16126, 14287, 25114, 1511, -24162, -16712, 13649,
	25299, 2266, -23873, -17284, 12999, 25462, 3018, -23563,
	-17842, 12339, 25605, 3768, -23234, -18384, 11668, 25725,
	4515, -22885, -18911, 10987, 25824, 5257, -22516, -19422,
	10297, 25901, 5996, -22128, -19917, 9599, 25956, 6729,
	-21722, -20394, 8892, 25989, 7457, -21297, -20855, 8177},
	{
// Carrier 37 Phase 3
	18384, -11668, -25725, -4514, 22885, 18911, -10988, -25824,
	-5257, 22516, 19422, -10298, -25901, -5996, 22129, 19917,
	-9599, -25956, -6729, 21722, 20394, -8892, -25989, -7456,
	21297, 20855, -8178, -26000, -8178, 20855, 21297, -7456,
	-25989, -8892, 20394, 21722, -6729, -25956, -9599, 19917,
	22129, -5995, -25901, -10298, 19422, 22516, -5257, -25824,
	-10988, 18911, 22885, -4514, -25725, -11668, 18384, 23234,
	-3768, -25604, -12339, 17842, 23564, -3018, -25462, -13000,
	17284, 23873, -2265, -25299, -13649, 16712, 24163, -1511,
	-25114, -14287, 16126, 24432, -756, -24907, -14913, 15526,
	24680, 0, -24680, -15526, 14912, 24907, 756, -24431,
	-16126, 14287, 25114, 1511, -24163, -16712, 13649, 25299,
	2266, -23873, -17284, 12999, 25462, 3018, -23563, -17842,
	12339, 25605, 3768, -23234, -18384, 11668, 25725, 4514,
	-22885, -18911, 10987, 25824, 5257, -22516, -19422, 10297,
	25901, 5996, -22128, -19917, 9599, 25956, 6729, -21722,
	-20394, 8892, 25989, 7456, -21297, -20855, 8178, 26000,
	8178, -20855, -21298, 7456, 25988, 8892, -20394, -21722,
	6729, 25956, 9599, -19917, -22129, 5995, 25901, 10298,
	-19422, -22516, 5257, 25824, 10988, -18911, -22885, 4514,
	25725, 11668, -18384, -23234, 3768, 25604, 12339, -17842,
	-23564, 3018, 25462, 13000, -17284, -23873, 2265, 25299,
	13649, -16712, -24163, 1511, 25114, 14287, -16126, -24432,
	756, 24907, 14913, -15526, -24680, 0, 24680, 15526,
	-14912, -24907, -756, 24431, 16126, -14287, -25114, -1511,
	24162, 16712, -13649, -25299, -2266, 23873, 17284, -12999,
	-25462, -3018, 23563, 17842, -12339, -25605, -3768, 23234},
	},{{

// Carrier 38 Phase 0
	0, 24907, 14287, -16712, -23873, 3018, 25605, 11668,
	-18911, -22516, 5996, 25956, 8892, -20855, -20855, 8892,
	25956, 5995, -22516, -18911, 11668, 25604, 3018, -23873,
	-16712, 14287, 24907, 0, -24907, -14287, 16712, 23873,
	-3018, -25605, -11668, 18911, 22516, -5996, -25956, -8892,
	20855, 20855, -8892, -25956, -5995, 22516, 18911, -11668,
	-25604, -3018, 23873, 16712, -14287, -24907, 0, 24907,
	14287, -16712, -23873, 3018, 25605, 11668, -18911, -22516,
	5996, 25956, 8892, -20855, -20855, 8892, 25955, 5995,
	-22516, -18911, 11668, 25604, 3018, -23873, -16712, 14287,
	24907, 0, -24907, -14287, 16712, 23873, -3018, -25605,
	-11668, 18911, 22516, -5996, -25956, -8892, 20855, 20855,
	-8892, -25955, -5995, 22516, 18911, -11669, -25604, -3018,
	23873, 16712, -14287, -24907, 0, 24907, 14286, -16712,
	-23873, 3018, 25605, 11668, -18911, -22516, 5996, 25956,
	8892, -20855, -20854, 8892, 25955, 5995, -22516, -18911,
	11669, 25604, 3018, -23873, -16712, 14287, 24907, 0,
	-24907, -14286, 16712, 23873, -3018, -25605, -11668, 18912,
	22516, -5996, -25956, -8892, 20855, 20854, -8892, -25955,
	-5995, 22516, 18911, -11669, -25604, -3017, 23873, 16712,
	-14287, -24907, 0, 24907, 14286, -16712, -23873, 3018,
	25605, 11668, -18912, -22516, 5996, 25956, 8892, -20855,
	-20854, 8893, 25955, 5995, -22516, -18911, 11669, 25604,
	3017, -23873, -16712, 14287, 24907, 0, -24907, -14286,
	16712, 23873, -3019, -25605, -11668, 18912, 22516, -5996,
	-25956, -8891, 20855, 20854, -8893, -25955, -5995, 22516,
	18911, -11669, -25604, -3017, 23873, 16711, -14287, -24907},
	{
// Carrier 38 Phase 1
	18384, 22885, -5257, -25901, -9599, 20394, 21297, -8178,
	-25989, -6729, 22129, 19422, -10988, -25725, -3768, 23564,
	17284, -13649, -25114, -756, 24680, 14912, -16126, -24163,
	2266, 25462, 12339, -18384, -22885, 5257, 25901, 9599,
	-20394, -21297, 8178, 25988, 6729, -22129, -19422, 10988,
	25725, 3768, -23564, -17284, 13649, 25114, 756, -24680,
	-14912, 16126, 24162, -2266, -25462, -12339, 18384, 22885,
	-5257, -25901, -9599, 20394, 21297, -8178, -25988, -6729,
	22129, 19422, -10988, -25725, -3768, 23564, 17284, -13649,
	-25114, -755, 24680, 14912, -16126, -24162, 2266, 25462,
	12339, -18384, -22885, 5257, 25901, 9599, -20394, -21297,
	8178, 25988, 6729, -22129, -19422, 10988, 25725, 3767,
	-23564, -17284, 13649, 25113, 755, -24680, -14912, 16126,
	24162, -2266, -25462, -12339, 18385, 22885, -5257, -25901,
	-9599, 20395, 21297, -8178, -25988, -6728, 22129, 19422,
	-10988, -25725, -3767, 23564, 17284, -13649, -25113, -755,
	24680, 14912, -16126, -24162, 2266, 25462, 12339, -18385,
	-22885, 5258, 25901, 9598, -20395, -21297, 8178, 25988,
	6728, -22129, -19422, 10988, 25725, 3767, -23564, -17284,
	13649, 25113, 755, -24680, -14912, 16126, 24162, -2266,
	-25462, -12339, 18385, 22884, -5258, -25901, -9598, 20395,
	21297, -8178, -25988, -6728, 22129, 19422, -10988, -25725,
	-3767, 23564, 17284, -13649, -25113, -755, 24680, 14912,
	-16126, -24162, 2266, 25462, 12339, -18385, -22884, 5258,
	25901, 9598, -20395, -21297, 8178, 25988, 6728, -22129,
	-19422, 10988, 25725, 3767, -23564, -17284, 13649, 25113,
	755, -24680, -14912, 16126, 24162, -2266, -25462, -12339},
	{
// Carrier 38 Phase 2
	26000, 7456, -21722, -19917, 10298, 25824, 4514, -23234,
	-17842, 13000, 25299, 1511, -24432, -15526, 15526, 24431,
	-1511, -25299, -12999, 17842, 23234, -4514, -25824, -10298,
	19917, 21722, -7456, -26000, -7456, 21722, 19917, -10298,
	-25824, -4514, 23234, 17842, -13000, -25299, -1511, 24432,
	15526, -15526, -24431, 1511, 25299, 12999, -17842, -23234,
	4514, 25824, 10297, -19917, -21722, 7457, 26000, 7456,
	-21722, -19917, 10298, 25824, 4514, -23234, -17842, 13000,
	25299, 1511, -24432, -15525, 15526, 24431, -1511, -25299,
	-12999, 17842, 23234, -4515, -25824, -10297, 19917, 21722,
	-7457, -26000, -7456, 21722, 19916, -10298, -25824, -4514,
	23234, 17842, -13000, -25299, -1511, 24432, 15525, -15526,
	-24431, 1512, 25299, 12999, -17842, -23234, 4515, 25824,
	10297, -19917, -21722, 7457, 26000, 7456, -21722, -19916,
	10298, 25824, 4514, -23234, -17842, 13000, 25299, 1511,
	-24432, -15525, 15526, 24431, -1512, -25299, -12999, 17842,
	23234, -4515, -25824, -10297, 19917, 21722, -7457, -26000,
	-7456, 21722, 19916, -10298, -25824, -4514, 23234, 17841,
	-13000, -25299, -1511, 24432, 15525, -15526, -24431, 1512,
	25299, 12999, -17842, -23234, 4515, 25824, 10297, -19917,
	-21722, 7457, 26000, 7456, -21722, -19916, 10298, 25824,
	4514, -23234, -17841, 13000, 25299, 1511, -24432, -15525,
	15526, 24431, -1512, -25299, -12999, 17842, 23234, -4515,
	-25824, -10297, 19917, 21722, -7457, -26000, -7456, 21723,
	19916, -10298, -25824, -4514, 23234, 17841, -13000, -25299,
	-1511, 24432, 15525, -15526, -24431, 1512, 25299, 12999,
	-17842, -23234, 4515, 25824, 10297, -19917, -21722, 7457},
	{
// Carrier 38 Phase 3
	18384, -12339, -25462, -2266, 24163, 16126, -14913, -24680,
	756, 25114, 13649, -17284, -23563, 3768, 25725, 10988,
	-19422, -22129, 6729, 25989, 8178, -21297, -20394, 9599,
	25901, 5257, -22885, -18384, 12339, 25462, 2265, -24163,
	-16126, 14913, 24680, -756, -25114, -13649, 17284, 23563,
	-3768, -25725, -10987, 19422, 22128, -6729, -25989, -8178,
	21298, 20394, -9599, -25901, -5257, 22885, 18384, -12339,
	-25462, -2265, 24163, 16125, -14913, -24680, 756, 25114,
	13649, -17284, -23563, 3768, 25725, 10987, -19422, -22128,
	6729, 25989, 8177, -21298, -20394, 9599, 25901, 5257,
	-22885, -18384, 12339, 25462, 2265, -24163, -16125, 14913,
	24680, -756, -25114, -13649, 17284, 23563, -3768, -25725,
	-10987, 19422, 22128, -6729, -25989, -8177, 21298, 20394,
	-9599, -25901, -5257, 22885, 18384, -12339, -25462, -2265,
	24163, 16125, -14913, -24680, 756, 25114, 13649, -17284,
	-23563, 3768, 25725, 10987, -19422, -22128, 6729, 25989,
	8177, -21298, -20394, 9599, 25901, 5257, -22885, -18384,
	12339, 25462, 2265, -24163, -16125, 14913, 24680, -756,
	-25114, -13648, 17285, 23563, -3768, -25725, -10987, 19422,
	22128, -6729, -25989, -8177, 21298, 20394, -9599, -25901,
	-5257, 22885, 18384, -12340, -25462, -2265, 24163, 16125,
	-14913, -24680, 756, 25114, 13648, -17285, -23563, 3768,
	25725, 10987, -19423, -22128, 6729, 25989, 8177, -21298,
	-20394, 9599, 25901, 5257, -22885, -18384, 12340, 25462,
	2265, -24163, -16125, 14913, 24680, -756, -25114, -13648,
	17285, 23563, -3768, -25725, -10987, 19423, 22128, -6729,
	-25989, -8177, 21298, 20394, -9599, -25901, -5256, 22885},
	},{{

// Carrier 39 Phase 0
	0, 25114, 13000, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25114,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6729,
	-22516, -18384, 13000, 25114, 0, -25114, -12999, 18384,
	22516, -6729, -26000, -6729, 22516, 18384, -13000, -25113,
	0, 25114, 12999, -18384, -22516, 6729, 26000, 6728,
	-22516, -18384, 13000, 25113, 0, -25114, -12999, 18385,
	22516, -6729, -26000, -6728, 22516, 18384, -13000, -25113,
	0, 25114, 12999, -18385, -22516, 6729, 26000, 6728,
	-22516, -18384, 13000, 25113, 0, -25114, -12999, 18385,
	22516, -6729, -26000, -6728, 22516, 18384, -13000, -25113,
	0, 25114, 12999, -18385, -22516, 6729, 26000, 6728,
	-22516, -18384, 13000, 25113, 0, -25114, -12999, 18385,
	22516, -6729, -26000, -6728, 22516, 18384, -13000, -25113},
	{
// Carrier 39 Phase 1
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25114, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25114, 0, 25114, 12999, -18384, -22516, 6729, 26000,
	6729, -22516, -18384, 13000, 25113, 0, -25114, -12999,
	18384, 22516, -6729, -26000, -6729, 22516, 18384, -13000,
	-25113, 0, 25114, 12999, -18385, -22516, 6729, 26000,
	6728, -22516, -18384, 13000, 25113, 0, -25114, -12999,
	18385, 22516, -6729, -26000, -6728, 22516, 18384, -13000,
	-25113, 0, 25114, 12999, -18385, -22516, 6729, 26000,
	6728, -22516, -18384, 13000, 25113, 0, -25114, -12999,
	18385, 22516, -6729, -26000, -6728, 22516, 18384, -13000,
	-25113, 0, 25114, 12999, -18385, -22516, 6729, 26000,
	6728, -22516, -18384, 13000, 25113, 0, -25114, -12999},
	{
// Carrier 39 Phase 2
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25114, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6729, -22516, -18384, 13000, 25114, 0, -25114,
	-12999, 18384, 22516, -6729, -26000, -6729, 22516, 18384,
	-13000, -25113, 0, 25114, 12999, -18384, -22516, 6729,
	26000, 6728, -22516, -18384, 13000, 25113, 0, -25114,
	-12999, 18385, 22516, -6729, -26000, -6728, 22516, 18384,
	-13000, -25113, 0, 25114, 12999, -18385, -22516, 6729,
	26000, 6728, -22516, -18384, 13000, 25113, 0, -25114,
	-12999, 18385, 22516, -6729, -26000, -6728, 22516, 18384,
	-13000, -25113, 0, 25114, 12999, -18385, -22516, 6729,
	26000, 6728, -22516, -18384, 13000, 25113, 0, -25114,
	-12999, 18385, 22516, -6729, -26000, -6728, 22516, 18384,
	-13000, -25113, 0, 25114, 12999, -18385, -22516, 6729},
	{
// Carrier 39 Phase 3
	18384, -12999, -25114, 0, 25114, 13000, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25114, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6729, -22516, -18384, 13000, 25114, 0,
	-25114, -12999, 18384, 22516, -6729, -26000, -6729, 22516,
	18384, -13000, -25113, 0, 25114, 12999, -18384, -22516,
	6729, 26000, 6728, -22516, -18384, 13000, 25113, 0,
	-25114, -12999, 18385, 22516, -6729, -26000, -6728, 22516,
	18384, -13000, -25113, 0, 25114, 12999, -18385, -22516,
	6729, 26000, 6728, -22516, -18384, 13000, 25113, 0,
	-25114, -12999, 18385, 22516, -6729, -26000, -6728, 22516,
	18384, -13000, -25113, 0, 25114, 12999, -18385, -22516,
	6729, 26000, 6728, -22516, -18384, 13000, 25113, 0,
	-25114, -12999, 18385, 22516, -6729, -26000, -6728, 22516},
	},{{

// Carrier 40 Phase 0
	0, 25299, 11668, -19917, -20855, 10298, 25605, 1511,
	-24907, -12999, 18911, 21722, -8892, -25824, -3018, 24432,
	14287, -17842, -22516, 7456, 25956, 4514, -23873, -15526,
	16712, 23234, -5996, -26000, -5996, 23234, 16712, -15526,
	-23873, 4514, 25956, 7456, -22516, -17842, 14287, 24432,
	-3018, -25824, -8892, 21722, 18911, -13000, -24907, 1511,
	25605, 10298, -20855, -19917, 11668, 25299, 0, -25299,
	-11668, 19917, 20855, -10298, -25604, -1511, 24907, 12999,
	-18911, -21722, 8892, 25824, 3018, -24432, -14287, 17842,
	22516, -7456, -25956, -4514, 23873, 15526, -16712, -23234,
	5996, 26000, 5996, -23234, -16712, 15526, 23873, -4514,
	-25956, -7456, 22516, 17842, -14287, -24432, 3018, 25824,
	8892, -21722, -18911, 13000, 24907, -1511, -25605, -10298,
	20855, 19917, -11668, -25299, 0, 25299, 11668, -19917,
	-20855, 10298, 25604, 1511, -24907, -12999, 18911, 21722,
	-8892, -25824, -3018, 24432, 14287, -17842, -22516, 7456,
	25956, 4514, -23873, -15526, 16712, 23234, -5996, -26000,
	-5995, 23234, 16712, -15526, -23873, 4514, 25956, 7456,
	-22516, -17842, 14287, 24431, -3018, -25824, -8892, 21722,
	18911, -13000, -24907, 1511, 25605, 10298, -20855, -19917,
	11668, 25299, 0, -25299, -11668, 19917, 20855, -10298,
	-25604, -1511, 24907, 12999, -18911, -21722, 8892, 25824,
	3018, -24432, -14287, 17842, 22516, -7456, -25956, -4514,
	23873, 15526, -16712, -23234, 5996, 26000, 5995, -23234,
	-16712, 15526, 23873, -4514, -25956, -7456, 22516, 17842,
	-14287, -24431, 3018, 25824, 8892, -21722, -18911, 13000,
	24907, -1511, -25605, -10298, 20855, 19917, -11668, -25299},
	{
// Carrier 40 Phase 1
	18384, 22129, -8178, -25901, -3768, 24163, 14912, -17284,
	-22885, 6729, 25989, 5257, -23564, -16126, 16126, 23564,
	-5257, -25989, -6729, 22885, 17284, -14912, -24163, 3768,
	25901, 8178, -22129, -18384, 13649, 24680, -2266, -25725,
	-9599, 21297, 19422, -12339, -25114, 756, 25462, 10988,
	-20394, -20394, 10988, 25462, 756, -25114, -12339, 19422,
	21297, -9599, -25725, -2266, 24680, 13649, -18384, -22129,
	8178, 25901, 3768, -24163, -14912, 17284, 22885, -6729,
	-25989, -5257, 23564, 16126, -16126, -23564, 5257, 25989,
	6729, -22885, -17284, 14912, 24163, -3768, -25901, -8178,
	22129, 18384, -13649, -24680, 2266, 25725, 9599, -21297,
	-19422, 12339, 25114, -756, -25462, -10988, 20394, 20394,
	-10988, -25462, -756, 25114, 12339, -19422, -21297, 9599,
	25725, 2266, -24680, -13649, 18384, 22129, -8178, -25901,
	-3768, 24163, 14912, -17284, -22885, 6729, 25989, 5257,
	-23564, -16126, 16126, 23563, -5257, -25989, -6729, 22885,
	17284, -14912, -24163, 3768, 25901, 8178, -22129, -18384,
	13649, 24680, -2266, -25725, -9599, 21297, 19422, -12339,
	-25114, 756, 25462, 10988, -20394, -20394, 10988, 25462,
	756, -25114, -12339, 19422, 21297, -9599, -25725, -2266,
	24680, 13649, -18384, -22129, 8178, 25901, 3768, -24163,
	-14912, 17284, 22885, -6729, -25989, -5257, 23564, 16126,
	-16126, -23563, 5257, 25989, 6729, -22885, -17284, 14913,
	24163, -3768, -25901, -8178, 22129, 18384, -13649, -24680,
	2266, 25725, 9599, -21297, -19422, 12339, 25114, -756,
	-25462, -10988, 20394, 20394, -10988, -25462, -756, 25114,
	12339, -19422, -21297, 9599, 25725, 2266, -24680, -13649},
	{
// Carrier 40 Phase 2
	26000, 5996, -23234, -16712, 15526, 23873, -4514, -25956,
	-7456, 22516, 17842, -14287, -24432, 3018, 25824, 8892,
	-21722, -18911, 13000, 24907, -1511, -25605, -10298, 20855,
	19917, -11668, -25299, 0, 25299, 11668, -19917, -20855,
	10298, 25604, 1511, -24907, -12999, 18911, 21722, -8892,
	-25824, -3018, 24432, 14287, -17842, -22516, 7456, 25956,
	4514, -23873, -15526, 16712, 23234, -5996, -26000, -5996,
	23234, 16712, -15526, -23873, 4514, 25956, 7456, -22516,
	-17842, 14287, 24432, -3018, -25824, -8892, 21722, 18911,
	-13000, -24907, 1511, 25605, 10298, -20855, -19917, 11668,
	25299, 0, -25299, -11668, 19917, 20855, -10298, -25604,
	-1511, 24907, 12999, -18911, -21722, 8892, 25824, 3018,
	-24432, -14287, 17842, 22516, -7456, -25956, -4514, 23873,
	15526, -16712, -23234, 5996, 26000, 5995, -23234, -16712,
	15526, 23873, -4514, -25956, -7456, 22516, 17842, -14287,
	-24432, 3018, 25824, 8892, -21722, -18911, 13000, 24907,
	-1511, -25605, -10298, 20855, 19917, -11668, -25299, 0,
	25299, 11668, -19917, -20855, 10298, 25604, 1511, -24907,
	-12999, 18911, 21722, -8892, -25824, -3018, 24432, 14287,
	-17842, -22516, 7456, 25956, 4514, -23873, -15526, 16712,
	23234, -5996, -26000, -5995, 23234, 16712, -15526, -23873,
	4514, 25956, 7456, -22516, -17842, 14287, 24431, -3018,
	-25824, -8892, 21722, 18911, -13000, -24907, 1511, 25605,
	10298, -20855, -19917, 11668, 25299, 0, -25299, -11668,
	19917, 20855, -10298, -25604, -1511, 24907, 12999, -18911,
	-21722, 8892, 25824, 3018, -24432, -14287, 17842, 22516,
	-7456, -25956, -4514, 23873, 15526, -16712, -23234, 5996},
	{
// Carrier 40 Phase 3
	18384, -13649, -24680, 2266, 25725, 9599, -21297, -19422,
	12339, 25114, -756, -25462, -10988, 20394, 20394, -10988,
	-25462, -756, 25114, 12339, -19422, -21297, 9599, 25725,
	2266, -24680, -13649, 18384, 22129, -8178, -25901, -3768,
	24163, 14912, -17284, -22885, 6729, 25989, 5257, -23564,
	-16126, 16126, 23564, -5257, -25989, -6729, 22885, 17284,
	-14912, -24163, 3768, 25901, 8178, -22129, -18384, 13649,
	24680, -2266, -25725, -9599, 21297, 19422, -12339, -25114,
	756, 25462, 10988, -20394, -20394, 10988, 25462, 756,
	-25114, -12339, 19422, 21297, -9599, -25725, -2266, 24680,
	13649, -18384, -22129, 8178, 25901, 3768, -24163, -14912,
	17284, 22885, -6729, -25989, -5257, 23564, 16126, -16126,
	-23564, 5257, 25989, 6729, -22885, -17284, 14912, 24163,
	-3768, -25901, -8178, 22129, 18384, -13649, -24680, 2266,
	25725, 9599, -21297, -19422, 12339, 25114, -756, -25462,
	-10988, 20394, 20394, -10988, -25462, -756, 25114, 12339,
	-19422, -21297, 9599, 25725, 2266, -24680, -13649, 18384,
	22129, -8178, -25901, -3768, 24163, 14912, -17284, -22885,
	6729, 25989, 5257, -23564, -16126, 16126, 23563, -5257,
	-25989, -6729, 22885, 17284, -14912, -24163, 3768, 25901,
	8178, -22129, -18384, 13649, 24680, -2266, -25725, -9599,
	21297, 19422, -12339, -25114, 756, 25462, 10988, -20394,
	-20394, 10988, 25462, 756, -25114, -12339, 19422, 21297,
	-9599, -25725, -2266, 24680, 13649, -18384, -22129, 8178,
	25901, 3768, -24163, -14912, 17284, 22885, -6729, -25989,
	-5257, 23564, 16126, -16126, -23563, 5257, 25989, 6729,
	-22885, -17284, 14913, 24163, -3768, -25901, -8178, 22129},
	},{{

// Carrier 41 Phase 0
	0, 25462, 10298, -21297, -18911, 13649, 24432, -3768,
	-25956, -6729, 23234, 16126, -16712, -22885, 7456, 25901,
	3018, -24680, -12999, 19422, 20855, -10988, -25299, 756,
	25605, 9599, -21722, -18384, 14287, 24163, -4514, -25989,
	-5995, 23564, 15526, -17284, -22516, 8178, 25824, 2266,
	-24907, -12339, 19917, 20394, -11668, -25114, 1511, 25725,
	8892, -22129, -17842, 14913, 23873, -5257, -26000, -5257,
	23873, 14912, -17842, -22129, 8892, 25725, 1511, -25114,
	-11668, 20394, 19917, -12339, -24907, 2266, 25824, 8178,
	-22516, -17284, 15526, 23563, -5996, -25988, -4514, 24163,
	14287, -18384, -21722, 9599, 25604, 756, -25299, -10987,
	20855, 19422, -13000, -24680, 3018, 25901, 7456, -22885,
	-16712, 16126, 23234, -6729, -25956, -3768, 24432, 13649,
	-18911, -21297, 10298, 25462, 0, -25462, -10297, 21298,
	18911, -13649, -24431, 3768, 25956, 6729, -23234, -16125,
	16712, 22885, -7457, -25901, -3018, 24680, 12999, -19422,
	-20855, 10988, 25299, -756, -25605, -9599, 21722, 18384,
	-14287, -24162, 4515, 25989, 5995, -23564, -15525, 17284,
	22516, -8178, -25824, -2265, 24907, 12339, -19917, -20394,
	11668, 25114, -1511, -25725, -8892, 22129, 17842, -14913,
	-23873, 5257, 26000, 5257, -23873, -14912, 17842, 22128,
	-8892, -25725, -1511, 25114, 11668, -20394, -19916, 12339,
	24907, -2266, -25824, -8177, 22516, 17284, -15526, -23563,
	5996, 25988, 4514, -24163, -14286, 18384, 21722, -9599,
	-25604, -755, 25299, 10987, -20855, -19422, 13000, 24680,
	-3018, -25901, -7456, 22885, 16712, -16126, -23234, 6729,
	25955, 3767, -24432, -13649, 18911, 21297, -10298, -25462},
	{
// Carrier 41 Phase 1
	18384, 21722, -9599, -25605, -756, 25299, 10988, -20855,
	-19422, 13000, 24680, -3018, -25901, -7456, 22885, 16712,
	-16126, -23234, 6729, 25956, 3768, -24432, -13649, 18911,
	21297, -10298, -25462, 0, 25462, 10298, -21297, -18911,
	13649, 24431, -3768, -25956, -6729, 23234, 16126, -16712,
	-22885, 7456, 25901, 3018, -24680, -12999, 19422, 20855,
	-10988, -25299, 756, 25605, 9599, -21722, -18384, 14287,
	24163, -4514, -25989, -5995, 23564, 15526, -17284, -22516,
	8178, 25824, 2265, -24907, -12339, 19917, 20394, -11668,
	-25114, 1511, 25725, 8892, -22129, -17842, 14913, 23873,
	-5257, -26000, -5257, 23873, 14912, -17842, -22128, 8892,
	25725, 1511, -25114, -11668, 20394, 19917, -12339, -24907,
	2266, 25824, 8178, -22516, -17284, 15526, 23563, -5996,
	-25988, -4514, 24163, 14287, -18384, -21722, 9599, 25604,
	756, -25299, -10987, 20855, 19422, -13000, -24680, 3018,
	25901, 7456, -22885, -16712, 16126, 23234, -6729, -25956,
	-3768, 24432, 13649, -18911, -21297, 10298, 25462, 0,
	-25462, -10297, 21298, 18911, -13649, -24431, 3768, 25956,
	6729, -23234, -16125, 16712, 22885, -7457, -25901, -3018,
	24680, 12999, -19422, -20855, 10988, 25299, -756, -25605,
	-9599, 21722, 18384, -14287, -24162, 4515, 25989, 5995,
	-23564, -15525, 17284, 22516, -8178, -25824, -2265, 24907,
	12339, -19917, -20394, 11669, 25113, -1512, -25725, -8892,
	22129, 17842, -14913, -23873, 5257, 26000, 5257, -23873,
	-14912, 17842, 22128, -8892, -25725, -1511, 25114, 11668,
	-20395, -19916, 12339, 24907, -2266, -25824, -8177, 22516,
	17284, -15526, -23563, 5996, 25988, 4514, -24163, -14286},
	{
// Carrier 41 Phase 2
	26000, 5257, -23873, -14912, 17842, 22129, -8892, -25725,
	-1511, 25114, 11668, -20394, -19917, 12339, 24907, -2266,
	-25824, -8178, 22516, 17284, -15526, -23563, 5996, 25989,
	4514, -24163, -14287, 18384, 21722, -9599, -25604, -756,
	25299, 10988, -20855, -19422, 13000, 24680, -3018, -25901,
	-7456, 22885, 16712, -16126, -23234, 6729, 25956, 3768,
	-24432, -13649, 18911, 21297, -10298, -25462, 0, 25462,
	10297, -21298, -18911, 13649, 24431, -3768, -25956, -6729,
	23234, 16126, -16712, -22885, 7456, 25901, 3018, -24680,
	-12999, 19422, 20855, -10988, -25299, 756, 25605, 9599,
	-21722, -18384, 14287, 24162, -4514, -25989, -5995, 23564,
	15526, -17284, -22516, 8178, 25824, 2265, -24907, -12339,
	19917, 20394, -11668, -25114, 1511, 25725, 8892, -22129,
	-17842, 14913, 23873, -5257, -26000, -5257, 23873, 14912,
	-17842, -22128, 8892, 25725, 1511, -25114, -11668, 20394,
	19917, -12339, -24907, 2266, 25824, 8177, -22516, -17284,
	15526, 23563, -5996, -25988, -4514, 24163, 14287, -18384,
	-21722, 9599, 25604, 755, -25299, -10987, 20855, 19422,
	-13000, -24680, 3018, 25901, 7456, -22885, -16712, 16126,
	23234, -6729, -25955, -3767, 24432, 13649, -18911, -21297,
	10298, 25462, 0, -25462, -10297, 21298, 18911, -13649,
	-24431, 3768, 25956, 6729, -23234, -16125, 16712, 22885,
	-7457, -25901, -3018, 24680, 12999, -19422, -20855, 10988,
	25299, -756, -25605, -9599, 21722, 18384, -14287, -24162,
	4515, 25989, 5995, -23564, -15525, 17284, 22516, -8178,
	-25824, -2265, 24907, 12339, -19917, -20394, 11669, 25113,
	-1512, -25725, -8892, 22129, 17842, -14913, -23873, 5257},
	{
// Carrier 41 Phase 3
	18384, -14287, -24163, 4514, 25989, 5996, -23564, -15526,
	17284, 22516, -8178, -25824, -2266, 24907, 12339, -19917,
	-20394, 11668, 25114, -1511, -25725, -8892, 22129, 17842,
	-14913, -23873, 5257, 26000, 5257, -23873, -14912, 17842,
	22129, -8892, -25725, -1511, 25114, 11668, -20394, -19917,
	12339, 24907, -2266, -25824, -8178, 22516, 17284, -15526,
	-23563, 5996, 25988, 4514, -24163, -14287, 18384, 21722,
	-9599, -25604, -756, 25299, 10987, -20855, -19422, 13000,
	24680, -3018, -25901, -7456, 22885, 16712, -16126, -23234,
	6729, 25956, 3768, -24432, -13649, 18911, 21297, -10298,
	-25462, 0, 25462, 10297, -21298, -18911, 13649, 24431,
	-3768, -25956, -6729, 23234, 16126, -16712, -22885, 7457,
	25901, 3018, -24680, -12999, 19422, 20855, -10988, -25299,
	756, 25605, 9599, -21722, -18384, 14287, 24162, -4515,
	-25989, -5995, 23564, 15525, -17284, -22516, 8178, 25824,
	2265, -24907, -12339, 19917, 20394, -11668, -25114, 1511,
	25725, 8892, -22129, -17842, 14913, 23873, -5257, -26000,
	-5257, 23873, 14912, -17842, -22128, 8892, 25725, 1511,
	-25114, -11668, 20394, 19917, -12339, -24907, 2266, 25824,
	8177, -22516, -17284, 15526, 23563, -5996, -25988, -4514,
	24163, 14287, -18384, -21722, 9599, 25604, 755, -25299,
	-10987, 20855, 19422, -13000, -24680, 3018, 25901, 7456,
	-22885, -16712, 16126, 23234, -6729, -25955, -3767, 24432,
	13649, -18911, -21297, 10298, 25462, 0, -25462, -10297,
	21298, 18911, -13649, -24431, 3768, 25956, 6728, -23234,
	-16125, 16712, 22885, -7457, -25901, -3018, 24680, 12999,
	-19422, -20855, 10988, 25299, -756, -25605, -9599, 21722},
	},{{

// Carrier 42 Phase 0
	0, 25605, 8892, -22516, -16712, 16712, 22516, -8892,
	-25605, 0, 25605, 8892, -22516, -16712, 16712, 22516,
	-8892, -25605, 0, 25605, 8892, -22516, -16712, 16712,
	22516, -8892, -25605, 0, 25605, 8892, -22516, -16712,
	16712, 22516, -8892, -25605, 0, 25605, 8892, -22516,
	-16712, 16712, 22516, -8892, -25605, 0, 25605, 8892,
	-22516, -16712, 16712, 22516, -8892, -25605, 0, 25605,
	8892, -22516, -16712, 16712, 22516, -8892, -25605, 0,
	25605, 8892, -22516, -16712, 16712, 22516, -8892, -25605,
	0, 25605, 8892, -22516, -16712, 16712, 22516, -8892,
	-25605, 0, 25605, 8892, -22516, -16712, 16712, 22516,
	-8892, -25605, 0, 25605, 8892, -22516, -16712, 16712,
	22516, -8892, -25605, 0, 25605, 8892, -22516, -16712,
	16712, 22516, -8892, -25605, 0, 25605, 8892, -22516,
	-16712, 16712, 22516, -8892, -25605, 0, 25605, 8892,
	-22516, -16712, 16712, 22516, -8892, -25605, 0, 25605,
	8892, -22516, -16712, 16712, 22516, -8892, -25605, 0,
	25605, 8892, -22516, -16712, 16712, 22516, -8892, -25605,
	0, 25605, 8892, -22516, -16712, 16712, 22516, -8892,
	-25605, 0, 25605, 8892, -22516, -16712, 16712, 22516,
	-8892, -25605, 0, 25605, 8892, -22516, -16712, 16712,
	22516, -8892, -25605, 0, 25605, 8892, -22516, -16712,
	16712, 22516, -8892, -25605, 0, 25605, 8892, -22516,
	-16712, 16712, 22516, -8892, -25605, 0, 25605, 8892,
	-22516, -16712, 16712, 22516, -8892, -25605, 0, 25605,
	8892, -22516, -16712, 16712, 22516, -8892, -25605, 0,
	25605, 8892, -22516, -16712, 16712, 22516, -8892, -25605},
	{
// Carrier 42 Phase 1
	18384, 21297, -10988, -25114, 2266, 25901, 6729, -23564,
	-14912, 18384, 21297, -10988, -25114, 2266, 25901, 6729,
	-23564, -14912, 18384, 21297, -10988, -25114, 2266, 25901,
	6729, -23564, -14912, 18384, 21297, -10988, -25114, 2266,
	25901, 6729, -23564, -14912, 18384, 21297, -10988, -25114,
	2266, 25901, 6729, -23564, -14912, 18384, 21297, -10988,
	-25114, 2266, 25901, 6729, -23564, -14912, 18384, 21297,
	-10988, -25114, 2266, 25901, 6729, -23564, -14912, 18384,
	21297, -10988, -25114, 2266, 25901, 6729, -23564, -14912,
	18384, 21297, -10988, -25114, 2266, 25901, 6729, -23564,
	-14912, 18384, 21297, -10988, -25114, 2266, 25901, 6729,
	-23564, -14912, 18384, 21297, -10988, -25114, 2266, 25901,
	6729, -23564, -14912, 18384, 21297, -10988, -25114, 2266,
	25901, 6729, -23564, -14912, 18384, 21297, -10988, -25114,
	2266, 25901, 6729, -23564, -14912, 18384, 21297, -10988,
	-25114, 2266, 25901, 6729, -23564, -14912, 18384, 21297,
	-10988, -25114, 2266, 25901, 6729, -23564, -14912, 18384,
	21297, -10988, -25114, 2266, 25901, 6729, -23564, -14912,
	18384, 21297, -10988, -25114, 2266, 25901, 6729, -23564,
	-14912, 18384, 21297, -10988, -25114, 2266, 25901, 6729,
	-23564, -14912, 18384, 21297, -10988, -25114, 2266, 25901,
	6729, -23564, -14912, 18384, 21297, -10988, -25114, 2266,
	25901, 6729, -23564, -14912, 18384, 21297, -10988, -25114,
	2266, 25901, 6729, -23564, -14912, 18384, 21297, -10988,
	-25114, 2266, 25901, 6729, -23564, -14912, 18384, 21297,
	-10988, -25114, 2266, 25901, 6729, -23564, -14912, 18384,
	21297, -10988, -25114, 2266, 25901, 6729, -23564, -14912},
	{
// Carrier 42 Phase 2
	26000, 4514, -24432, -13000, 19917, 19917, -12999, -24432,
	4514, 26000, 4514, -24432, -13000, 19917, 19917, -12999,
	-24432, 4514, 26000, 4514, -24432, -13000, 19917, 19917,
	-12999, -24432, 4514, 26000, 4514, -24432, -13000, 19917,
	19917, -12999, -24432, 4514, 26000, 4514, -24432, -13000,
	19917, 19917, -12999, -24432, 4514, 26000, 4514, -24432,
	-13000, 19917, 19917, -12999, -24432, 4514, 26000, 4514,
	-24432, -13000, 19917, 19917, -12999, -24432, 4514, 26000,
	4514, -24432, -13000, 19917, 19917, -12999, -24432, 4514,
	26000, 4514, -24432, -13000, 19917, 19917, -12999, -24432,
	4514, 26000, 4514, -24432, -13000, 19917, 19917, -12999,
	-24432, 4514, 26000, 4514, -24432, -13000, 19917, 19917,
	-12999, -24432, 4514, 26000, 4514, -24432, -13000, 19917,
	19917, -12999, -24432, 4514, 26000, 4514, -24432, -13000,
	19917, 19917, -12999, -24432, 4514, 26000, 4514, -24432,
	-13000, 19917, 19917, -12999, -24432, 4514, 26000, 4514,
	-24432, -13000, 19917, 19917, -12999, -24432, 4514, 26000,
	4514, -24432, -13000, 19917, 19917, -12999, -24432, 4514,
	26000, 4514, -24432, -13000, 19917, 19917, -12999, -24432,
	4514, 26000, 4514, -24432, -13000, 19917, 19917, -12999,
	-24432, 4514, 26000, 4514, -24432, -13000, 19917, 19917,
	-12999, -24432, 4514, 26000, 4514, -24432, -13000, 19917,
	19917, -12999, -24432, 4514, 26000, 4514, -24432, -13000,
	19917, 19917, -12999, -24432, 4514, 26000, 4514, -24432,
	-13000, 19917, 19917, -12999, -24432, 4514, 26000, 4514,
	-24432, -13000, 19917, 19917, -12999, -24432, 4514, 26000,
	4514, -24432, -13000, 19917, 19917, -12999, -24432, 4514},
	{
// Carrier 42 Phase 3
	18384, -14912, -23564, 6729, 25901, 2266, -25114, -10988,
	21297, 18384, -14912, -23563, 6729, 25901, 2266, -25114,
	-10988, 21297, 18384, -14912, -23563, 6729, 25901, 2266,
	-25114, -10988, 21297, 18384, -14912, -23563, 6729, 25901,
	2266, -25114, -10988, 21297, 18384, -14912, -23563, 6729,
	25901, 2266, -25114, -10988, 21297, 18384, -14912, -23563,
	6729, 25901, 2266, -25114, -10988, 21297, 18384, -14912,
	-23563, 6729, 25901, 2266, -25114, -10988, 21297, 18384,
	-14912, -23563, 6729, 25901, 2266, -25114, -10988, 21297,
	18384, -14912, -23563, 6729, 25901, 2266, -25114, -10988,
	21297, 18384, -14912, -23563, 6729, 25901, 2266, -25114,
	-10988, 21297, 18384, -14912, -23563, 6729, 25901, 2266,
	-25114, -10988, 21297, 18384, -14912, -23563, 6729, 25901,
	2266, -25114, -10988, 21297, 18384, -14912, -23563, 6729,
	25901, 2266, -25114, -10988, 21297, 18384, -14912, -23563,
	6729, 25901, 2266, -25114, -10988, 21297, 18384, -14912,
	-23563, 6729, 25901, 2266, -25114, -10988, 21297, 18384,
	-14912, -23563, 6729, 25901, 2266, -25114, -10988, 21297,
	18384, -14912, -23563, 6729, 25901, 2266, -25114, -10988,
	21297, 18384, -14912, -23563, 6729, 25901, 2266, -25114,
	-10988, 21297, 18384, -14912, -23563, 6729, 25901, 2266,
	-25114, -10988, 21297, 18384, -14912, -23563, 6729, 25901,
	2266, -25114, -10988, 21297, 18384, -14912, -23563, 6729,
	25901, 2266, -25114, -10988, 21297, 18384, -14912, -23563,
	6729, 25901, 2266, -25114, -10988, 21297, 18384, -14912,
	-23563, 6729, 25901, 2266, -25114, -10988, 21297, 18384,
	-14912, -23563, 6729, 25901, 2266, -25114, -10988, 21297}}};
*/
